/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.api.jaxb;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.lens.api.error.ErrorCollection;
import org.apache.lens.api.error.ErrorCollectionFactory;
import org.apache.lens.api.jaxb.LensJAXBContext;
import org.apache.lens.api.result.LensAPIResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class LensJAXBContextResolver
implements ContextResolver<JAXBContext> {
    private static final Logger log = LoggerFactory.getLogger(LensJAXBContextResolver.class);
    private Map<Class, JAXBContext> jaxbContextCache = new ConcurrentHashMap<Class, JAXBContext>();

    public JAXBContext getContext(Class<?> type) {
        JAXBContext jaxbContext = this.jaxbContextCache.get(type);
        if (jaxbContext == null) {
            log.debug("JAXB instance to be created for {}", type);
            try {
                if (type.equals(LensAPIResult.class)) {
                    ErrorCollection errorCollection = new ErrorCollectionFactory().createErrorCollection();
                    HashSet classesToBeBound = Sets.newHashSet(errorCollection.getErrorPayloadClasses());
                    log.debug("classesToBeBound:{}", (Object)classesToBeBound);
                    classesToBeBound.add(type);
                    Class[] classesToBeBoundArray = classesToBeBound.toArray(new Class[classesToBeBound.size()]);
                    jaxbContext = new LensJAXBContext(classesToBeBoundArray);
                } else {
                    jaxbContext = new LensJAXBContext(type);
                }
                this.jaxbContextCache.put(type, jaxbContext);
            }
            catch (ClassNotFoundException | JAXBException e) {
                log.error("JAXBContext not initialized for " + type, e);
            }
        }
        return jaxbContext;
    }
}

