/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.api.jaxb;

import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.Validator;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.util.ValidationEventCollector;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.lens.api.jaxb.LensJAXBValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class LensJAXBContext
extends JAXBContext {
    private static final Logger log = LoggerFactory.getLogger(LensJAXBContext.class);
    private final JAXBContext jaxbContext;
    private final boolean hasTopLevelClass;

    public LensJAXBContext(Class ... classesToBeBoundArray) throws JAXBException {
        this.jaxbContext = JAXBContext.newInstance((Class[])classesToBeBoundArray);
        boolean hasTopLevelClass = false;
        for (Class clas : classesToBeBoundArray) {
            if (!clas.isAnnotationPresent(XmlRootElement.class)) continue;
            hasTopLevelClass = true;
            break;
        }
        this.hasTopLevelClass = hasTopLevelClass;
    }

    public Unmarshaller createUnmarshaller() throws JAXBException {
        Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        if (!this.hasTopLevelClass) {
            ClassLoader classLoader = LensJAXBContext.class.getClassLoader();
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                URL resource = classLoader.getResource("cube-0.1.xsd");
                Schema schema = sf.newSchema(resource);
                unmarshaller.setSchema(schema);
            }
            catch (SAXException e) {
                throw new JAXBException((Throwable)e);
            }
        }
        unmarshaller.setEventHandler((ValidationEventHandler)new LensValidationEventCollector());
        return unmarshaller;
    }

    public Marshaller createMarshaller() throws JAXBException {
        return this.jaxbContext.createMarshaller();
    }

    public Validator createValidator() throws JAXBException {
        return this.jaxbContext.createValidator();
    }

    private static class LensValidationEventCollector
    extends ValidationEventCollector {
        private LensValidationEventCollector() {
        }

        public boolean handleEvent(ValidationEvent event) {
            block3: {
                block2: {
                    if (event.getSeverity() == 1) break block2;
                    if (event.getSeverity() != 2) break block3;
                }
                throw new LensJAXBValidationException(event);
            }
            return true;
        }
    }
}

