/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.api;

import java.beans.ConstructorProperties;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.lens.api.jaxb.LensJAXBContext;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class APIResult {
    @XmlElement
    private Status status;
    @XmlElement
    private String message;
    private static final JAXBContext JAXB_CONTEXT;
    private static final APIResult SUCCESS;

    public String toString() {
        try {
            StringWriter stringWriter = new StringWriter();
            Marshaller marshaller = JAXB_CONTEXT.createMarshaller();
            marshaller.marshal((Object)this, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (JAXBException e) {
            return e.getMessage();
        }
    }

    public static APIResult partial(int actual, int expected) {
        return new APIResult(Status.PARTIAL, actual + " out of " + expected);
    }

    public static APIResult successOrPartialOrFailure(int actual, int expected) {
        return APIResult.successOrPartialOrFailure(actual, expected, null);
    }

    public static APIResult successOrPartialOrFailure(int actual, int expected, Exception e) {
        if (actual == 0 && expected != 0) {
            return APIResult.failure(e);
        }
        if (actual < expected) {
            return APIResult.partial(actual, expected);
        }
        return APIResult.success();
    }

    public static APIResult success() {
        return SUCCESS;
    }

    public static APIResult failure(Exception e) {
        String cause = APIResult.extractCause(e);
        return new APIResult(Status.FAILED, cause);
    }

    public static APIResult partial(Exception e) {
        String cause = APIResult.extractCause(e);
        return new APIResult(Status.PARTIAL, cause);
    }

    private static String extractCause(Throwable e) {
        StringBuilder cause = new StringBuilder();
        String sep = "";
        while (e != null) {
            cause.append(sep).append(e.getMessage());
            e = e.getCause();
            sep = ": ";
        }
        return cause.toString();
    }

    @ConstructorProperties(value={"status", "message"})
    public APIResult(Status status, String message) {
        this.status = status;
        this.message = message;
    }

    protected APIResult() {
    }

    public Status getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    static {
        try {
            JAXB_CONTEXT = new LensJAXBContext(APIResult.class);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        SUCCESS = new APIResult(Status.SUCCEEDED, "");
    }

    @XmlType
    @XmlEnum
    public static enum Status {
        SUCCEEDED,
        PARTIAL,
        FAILED;

    }
}

