/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.management.codec;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.ConfigFileInfo;
import org.apache.karaf.features.ConfigInfo;
import org.apache.karaf.features.Dependency;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.management.FeaturesServiceMBean;

public class JmxFeature {
    public static final CompositeType FEATURE;
    public static final TabularType FEATURE_TABLE;
    public static final CompositeType FEATURE_IDENTIFIER;
    public static final TabularType FEATURE_IDENTIFIER_TABLE;
    public static final CompositeType FEATURE_CONFIG_ELEMENT;
    public static final TabularType FEATURE_CONFIG_ELEMENT_TABLE;
    public static final CompositeType FEATURE_CONFIG;
    public static final TabularType FEATURE_CONFIG_TABLE;
    public static final CompositeType FEATURE_CONFIG_FILES;
    public static final TabularType FEATURE_CONFIG_FILES_TABLE;
    private final CompositeData data;

    public JmxFeature(Feature feature, boolean installed) {
        try {
            String[] itemNames = FeaturesServiceMBean.FEATURE;
            Object[] itemValues = new Object[itemNames.length];
            itemValues[0] = feature.getName();
            itemValues[1] = feature.getVersion();
            itemValues[2] = JmxFeature.getDependencyIdentifierTable(feature.getDependencies());
            itemValues[3] = JmxFeature.getBundleUris(feature.getBundles());
            itemValues[4] = JmxFeature.getConfigList(feature.getConfigurations());
            itemValues[5] = JmxFeature.getConfigFileList(feature.getConfigurationFiles());
            itemValues[6] = installed;
            this.data = new CompositeDataSupport(FEATURE, itemNames, itemValues);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form feature open data", e);
        }
    }

    public CompositeData asCompositeData() {
        return this.data;
    }

    public static TabularData tableFrom(Collection<JmxFeature> features) {
        TabularDataSupport table = new TabularDataSupport(FEATURE_TABLE);
        for (JmxFeature feature : features) {
            table.put(feature.asCompositeData());
        }
        return table;
    }

    private static TabularData getDependencyIdentifierTable(List<Dependency> features) throws OpenDataException {
        TabularDataSupport table = new TabularDataSupport(FEATURE_IDENTIFIER_TABLE);
        HashSet<String> featureSet = new HashSet<String>();
        for (Dependency feature : features) {
            if (featureSet.contains(feature.getName() + feature.getVersion())) continue;
            featureSet.add(feature.getName() + feature.getVersion());
            String[] itemNames = new String[]{"Name", "Version"};
            Object[] itemValues = new Object[]{feature.getName(), feature.getVersion()};
            CompositeDataSupport ident = new CompositeDataSupport(FEATURE_IDENTIFIER, itemNames, itemValues);
            table.put(ident);
        }
        return table;
    }

    static String[] getBundleUris(List<BundleInfo> infos) {
        String[] array = new String[infos.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = infos.get(i).getLocation();
        }
        return array;
    }

    static TabularData getConfigList(List<ConfigInfo> config) throws OpenDataException {
        TabularDataSupport table = new TabularDataSupport(FEATURE_CONFIG_TABLE);
        for (ConfigInfo configInfo : config) {
            String[] itemNames = FeaturesServiceMBean.FEATURE_CONFIG;
            Object[] itemValues = new Object[]{configInfo.getName(), JmxFeature.getConfigElementTable(configInfo.getProperties()), new Boolean(configInfo.isAppend())};
            CompositeDataSupport configComposite = new CompositeDataSupport(FEATURE_CONFIG, itemNames, itemValues);
            table.put(configComposite);
        }
        return table;
    }

    static TabularData getConfigFileList(List<ConfigFileInfo> configFiles) throws OpenDataException {
        TabularDataSupport table = new TabularDataSupport(FEATURE_CONFIG_FILES_TABLE);
        for (ConfigFileInfo configFile : configFiles) {
            String[] itemNames = FeaturesServiceMBean.FEATURE_CONFIG_FILES;
            Object[] itemValues = new Object[]{configFile.getFinalname()};
            CompositeDataSupport config = new CompositeDataSupport(FEATURE_CONFIG_FILES, itemNames, itemValues);
            table.put(config);
        }
        return table;
    }

    static TabularData getConfigElementTable(Map<String, String> config) throws OpenDataException {
        TabularDataSupport table = new TabularDataSupport(FEATURE_CONFIG_ELEMENT_TABLE);
        for (Map.Entry<String, String> entry : config.entrySet()) {
            String[] itemNames = FeaturesServiceMBean.FEATURE_CONFIG_ELEMENT;
            Object[] itemValues = new Object[]{entry.getKey(), entry.getValue()};
            CompositeDataSupport element = new CompositeDataSupport(FEATURE_CONFIG_ELEMENT, itemNames, itemValues);
            table.put(element);
        }
        return table;
    }

    static TabularData getConfigElementTable(Properties props) throws OpenDataException {
        TabularDataSupport table = new TabularDataSupport(FEATURE_CONFIG_ELEMENT_TABLE);
        for (Object key : props.keySet()) {
            String[] itemNames = FeaturesServiceMBean.FEATURE_CONFIG_ELEMENT;
            Object[] itemValues = new Object[]{key, props.getProperty((String)key)};
            CompositeDataSupport element = new CompositeDataSupport(FEATURE_CONFIG_ELEMENT, itemNames, itemValues);
            table.put(element);
        }
        return table;
    }

    private static CompositeType createFeatureIdentifierType() {
        try {
            String description = "This type identify a Karaf features";
            String[] itemNames = FeaturesServiceMBean.FEATURE_IDENTIFIER;
            OpenType[] itemTypes = new OpenType[itemNames.length];
            String[] itemDescriptions = new String[itemNames.length];
            itemTypes[0] = SimpleType.STRING;
            itemTypes[1] = SimpleType.STRING;
            itemDescriptions[0] = "The id of the feature";
            itemDescriptions[1] = "The version of the feature";
            return new CompositeType("FeatureIdentifier", description, itemNames, itemDescriptions, itemTypes);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Unable to build featureIdentifier type", e);
        }
    }

    private static TabularType createFeatureIdentifierTableType() {
        try {
            return new TabularType("Features", "The table of featureIdentifiers", FEATURE_IDENTIFIER, new String[]{"Name", "Version"});
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Unable to build featureIdentifier table type", e);
        }
    }

    private static CompositeType createFeatureConfigElementType() {
        try {
            String description = "This type encapsulates Karaf feature config element";
            String[] itemNames = FeaturesServiceMBean.FEATURE_CONFIG_ELEMENT;
            OpenType[] itemTypes = new OpenType[itemNames.length];
            String[] itemDescriptions = new String[itemNames.length];
            itemTypes[0] = SimpleType.STRING;
            itemTypes[1] = SimpleType.STRING;
            itemDescriptions[0] = "The key";
            itemDescriptions[1] = "The value";
            return new CompositeType("ConfigElement", description, itemNames, itemDescriptions, itemTypes);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Unable to build configElement type", e);
        }
    }

    private static TabularType createFeatureConfigElementTableType() {
        try {
            return new TabularType("ConfigElement", "The table of configurations elements", FEATURE_CONFIG_ELEMENT, new String[]{"Key"});
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Unable to build feature table type", e);
        }
    }

    private static CompositeType createFeatureConfigType() {
        try {
            String description = "This type encapsulates Karaf feature config";
            String[] itemNames = FeaturesServiceMBean.FEATURE_CONFIG;
            OpenType[] itemTypes = new OpenType[itemNames.length];
            String[] itemDescriptions = new String[itemNames.length];
            itemTypes[0] = SimpleType.STRING;
            itemTypes[1] = FEATURE_CONFIG_ELEMENT_TABLE;
            itemTypes[2] = SimpleType.BOOLEAN;
            itemDescriptions[0] = "The PID of the config";
            itemDescriptions[1] = "The configuration elements";
            itemDescriptions[2] = "The Append flag";
            return new CompositeType("Config", description, itemNames, itemDescriptions, itemTypes);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Unable to build configElement type", e);
        }
    }

    private static CompositeType createFeatureConfigFilesType() {
        try {
            String description = "This type encapsulates Karaf feature config files";
            String[] itemNames = FeaturesServiceMBean.FEATURE_CONFIG_FILES;
            OpenType[] itemTypes = new OpenType[itemNames.length];
            String[] itemDescriptions = new String[itemNames.length];
            itemTypes[0] = SimpleType.STRING;
            itemDescriptions[0] = "The configuration file";
            return new CompositeType("Config", description, itemNames, itemDescriptions, itemTypes);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Unable to build configElement type", e);
        }
    }

    private static TabularType createFeatureConfigTableType() {
        try {
            return new TabularType("Features", "The table of configurations", FEATURE_CONFIG, new String[]{"Pid"});
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Unable to build feature table type", e);
        }
    }

    private static TabularType createFeatureConfigFilesTableType() {
        try {
            return new TabularType("Features", "The table of configuration files", FEATURE_CONFIG_FILES, new String[]{"Files"});
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Unable to build feature table type", e);
        }
    }

    private static CompositeType createFeatureType() {
        try {
            String description = "This type encapsulates Karaf features";
            String[] itemNames = FeaturesServiceMBean.FEATURE;
            OpenType[] itemTypes = new OpenType[itemNames.length];
            String[] itemDescriptions = new String[itemNames.length];
            itemTypes[0] = SimpleType.STRING;
            itemTypes[1] = SimpleType.STRING;
            itemTypes[2] = FEATURE_IDENTIFIER_TABLE;
            itemTypes[3] = new ArrayType(1, SimpleType.STRING);
            itemTypes[4] = FEATURE_CONFIG_TABLE;
            itemTypes[5] = FEATURE_CONFIG_FILES_TABLE;
            itemTypes[6] = SimpleType.BOOLEAN;
            itemDescriptions[0] = "The name of the feature";
            itemDescriptions[1] = "The version of the feature";
            itemDescriptions[2] = "The feature dependencies";
            itemDescriptions[3] = "The feature bundles";
            itemDescriptions[4] = "The feature configurations";
            itemDescriptions[5] = "The feature configuration files";
            itemDescriptions[6] = "Whether the feature is installed";
            return new CompositeType("Feature", description, itemNames, itemDescriptions, itemTypes);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Unable to build feature type", e);
        }
    }

    private static TabularType createFeatureTableType() {
        try {
            return new TabularType("Features", "The table of all features", FEATURE, new String[]{"Name", "Version"});
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Unable to build feature table type", e);
        }
    }

    static {
        FEATURE_IDENTIFIER = JmxFeature.createFeatureIdentifierType();
        FEATURE_IDENTIFIER_TABLE = JmxFeature.createFeatureIdentifierTableType();
        FEATURE_CONFIG_ELEMENT = JmxFeature.createFeatureConfigElementType();
        FEATURE_CONFIG_ELEMENT_TABLE = JmxFeature.createFeatureConfigElementTableType();
        FEATURE_CONFIG = JmxFeature.createFeatureConfigType();
        FEATURE_CONFIG_TABLE = JmxFeature.createFeatureConfigTableType();
        FEATURE_CONFIG_FILES = JmxFeature.createFeatureConfigFilesType();
        FEATURE_CONFIG_FILES_TABLE = JmxFeature.createFeatureConfigFilesTableType();
        FEATURE = JmxFeature.createFeatureType();
        FEATURE_TABLE = JmxFeature.createFeatureTableType();
    }
}

