/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.region;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Conditional;
import org.apache.karaf.features.Dependency;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Library;
import org.apache.karaf.features.ScopeFilter;
import org.apache.karaf.features.internal.download.DownloadManager;
import org.apache.karaf.features.internal.download.Downloader;
import org.apache.karaf.features.internal.download.StreamProvider;
import org.apache.karaf.features.internal.region.RepositoryManager;
import org.apache.karaf.features.internal.region.SubsystemResolveContext;
import org.apache.karaf.features.internal.region.SubsystemResolverCallback;
import org.apache.karaf.features.internal.repository.BaseRepository;
import org.apache.karaf.features.internal.resolver.CapabilityImpl;
import org.apache.karaf.features.internal.resolver.FeatureResource;
import org.apache.karaf.features.internal.resolver.RequirementImpl;
import org.apache.karaf.features.internal.resolver.ResolverUtil;
import org.apache.karaf.features.internal.resolver.ResourceBuilder;
import org.apache.karaf.features.internal.resolver.ResourceImpl;
import org.apache.karaf.features.internal.resolver.ResourceUtils;
import org.apache.karaf.features.internal.resolver.SimpleFilter;
import org.apache.karaf.features.internal.service.Overrides;
import org.apache.karaf.features.internal.util.MapUtils;
import org.apache.karaf.features.internal.util.StringArrayMap;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class Subsystem
extends ResourceImpl {
    private static final String ALL_FILTER = "(|(!(all=*))(all=*))";
    private static final String SUBSYSTEM_FILTER = String.format("(%s=%s)", "type", "karaf.subsystem");
    private static final String FEATURE_FILTER = String.format("(%s=%s)", "type", "karaf.feature");
    private static final String SUBSYSTEM_OR_FEATURE_FILTER = String.format("(|%s%s)", SUBSYSTEM_FILTER, FEATURE_FILTER);
    private static final Map<String, Set<String>> SHARE_ALL_POLICY = Collections.singletonMap("org.eclipse.equinox.allow.all", Collections.singleton("(|(!(all=*))(all=*))"));
    private static final Map<String, Set<String>> SHARE_NONE_POLICY = Collections.singletonMap("osgi.identity", Collections.singleton(SUBSYSTEM_FILTER));
    private final String name;
    private final boolean acceptDependencies;
    private final Subsystem parent;
    private final Feature feature;
    private final boolean mandatory;
    private final List<Subsystem> children = new ArrayList<Subsystem>();
    private final Map<String, Set<String>> importPolicy;
    private final Map<String, Set<String>> exportPolicy;
    private final List<Resource> installable = new ArrayList<Resource>();
    private final Map<String, DependencyInfo> dependencies = new HashMap<String, DependencyInfo>();
    private final List<Requirement> dependentFeatures = new ArrayList<Requirement>();
    private final List<String> bundles = new ArrayList<String>();

    public Subsystem(String name) {
        super(name, "karaf.subsystem", Version.emptyVersion);
        this.name = name;
        this.parent = null;
        this.acceptDependencies = true;
        this.feature = null;
        this.importPolicy = SHARE_NONE_POLICY;
        this.exportPolicy = SHARE_NONE_POLICY;
        this.mandatory = true;
    }

    public Subsystem(String name, Feature feature, Subsystem parent, boolean mandatory) {
        super(name, "karaf.subsystem", Version.emptyVersion);
        this.name = name;
        this.parent = parent;
        this.acceptDependencies = feature.getScoping() != null && feature.getScoping().acceptDependencies();
        this.feature = feature;
        this.mandatory = mandatory;
        if (feature.getScoping() != null) {
            this.importPolicy = this.createPolicy(feature.getScoping().getImports());
            this.importPolicy.put("osgi.identity", Collections.singleton(SUBSYSTEM_OR_FEATURE_FILTER));
            this.exportPolicy = this.createPolicy(feature.getScoping().getExports());
            this.exportPolicy.put("osgi.identity", Collections.singleton(SUBSYSTEM_OR_FEATURE_FILTER));
        } else {
            this.importPolicy = SHARE_ALL_POLICY;
            this.exportPolicy = SHARE_ALL_POLICY;
        }
        ResourceUtils.addIdentityRequirement((ResourceImpl)this, feature.getName(), "karaf.feature", new VersionRange(VersionTable.getVersion(feature.getVersion()), true));
    }

    public Subsystem(String name, Subsystem parent, boolean acceptDependencies, boolean mandatory) {
        super(name, "karaf.subsystem", Version.emptyVersion);
        this.name = name;
        this.parent = parent;
        this.acceptDependencies = acceptDependencies;
        this.feature = null;
        this.mandatory = mandatory;
        this.importPolicy = SHARE_ALL_POLICY;
        this.exportPolicy = SHARE_NONE_POLICY;
    }

    public List<Resource> getInstallable() {
        return this.installable;
    }

    public String getName() {
        return this.name;
    }

    public Subsystem getParent() {
        return this.parent;
    }

    public Collection<Subsystem> getChildren() {
        return this.children;
    }

    public Subsystem getChild(String name) {
        for (Subsystem child : this.children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public boolean isAcceptDependencies() {
        return this.acceptDependencies;
    }

    public Map<String, Set<String>> getImportPolicy() {
        return this.importPolicy;
    }

    public Map<String, Set<String>> getExportPolicy() {
        return this.exportPolicy;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public Subsystem createSubsystem(String name, boolean acceptDependencies) {
        if (this.feature != null) {
            throw new UnsupportedOperationException("Can not create application subsystems inside a feature subsystem");
        }
        String childName = this.getName() + "/" + name;
        Subsystem as = new Subsystem(childName, this, acceptDependencies, true);
        this.children.add(as);
        ResourceUtils.addIdentityRequirement((ResourceImpl)this, childName, "karaf.subsystem", (VersionRange)null);
        this.installable.add(as);
        return as;
    }

    public void addSystemResource(Resource resource) {
        this.installable.add(resource);
    }

    public void requireFeature(String name, String range, boolean mandatory) {
        if (mandatory) {
            ResourceUtils.addIdentityRequirement((ResourceImpl)this, name, "karaf.feature", range);
        } else {
            ResourceImpl res = new ResourceImpl();
            ResourceUtils.addIdentityRequirement(res, name, "karaf.feature", range, false);
            this.dependentFeatures.addAll(res.getRequirements(null));
        }
    }

    public void require(String requirement) throws BundleException {
        String req;
        String type;
        int idx = requirement.indexOf(58);
        if (idx >= 0) {
            type = requirement.substring(0, idx);
            req = requirement.substring(idx + 1);
        } else {
            type = "feature";
            req = requirement;
        }
        switch (type) {
            case "feature": {
                this.addRequirement(ResourceUtils.toFeatureRequirement(req));
                break;
            }
            case "requirement": {
                this.addRequirement(req);
                break;
            }
            case "bundle": {
                this.bundles.add(req);
            }
        }
    }

    protected void addRequirement(String requirement) throws BundleException {
        for (Requirement req : ResourceBuilder.parseRequirement(this, requirement)) {
            Object range = req.getAttributes().get("version");
            if (range instanceof String) {
                req.getAttributes().put("version", new VersionRange((String)range));
            }
            this.addRequirement(req);
        }
    }

    public Map<String, BundleInfo> getBundleInfos() {
        HashMap<String, BundleInfo> infos = new HashMap<String, BundleInfo>();
        for (DependencyInfo di : this.dependencies.values()) {
            infos.put(di.getLocation(), di);
        }
        return infos;
    }

    public void build(Map<String, List<Feature>> allFeatures) throws Exception {
        this.doBuild(allFeatures, true);
    }

    private void doBuild(Map<String, List<Feature>> allFeatures, boolean mandatory) throws Exception {
        for (Subsystem subsystem : this.children) {
            subsystem.doBuild(allFeatures, true);
        }
        if (this.feature != null) {
            for (Dependency dependency : this.feature.getDependencies()) {
                if (dependency.isBlacklisted()) continue;
                Subsystem ss = this;
                while (!ss.isAcceptDependencies()) {
                    ss = ss.getParent();
                }
                ss.requireFeature(dependency.getName(), dependency.getVersion(), false);
            }
            for (Conditional conditional : this.feature.getConditional()) {
                if (conditional.isBlacklisted()) continue;
                Feature fcond = conditional.asFeature();
                String ssName = this.name + "#" + (fcond.hasVersion() ? fcond.getName() + "-" + fcond.getVersion() : fcond.getName());
                Subsystem fs = this.getChild(ssName);
                if (fs != null) continue;
                fs = new Subsystem(ssName, fcond, this, true);
                fs.doBuild(allFeatures, false);
                this.installable.add(fs);
                this.children.add(fs);
            }
        }
        ArrayList<Requirement> processed = new ArrayList<Requirement>();
        block4: while (true) {
            List<Requirement> list = this.getRequirements("osgi.identity");
            list.addAll(this.dependentFeatures);
            list.removeAll(processed);
            if (list.isEmpty()) break;
            Iterator<Requirement> iterator = list.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block4;
                Requirement requirement = iterator.next();
                String name = (String)requirement.getAttributes().get("osgi.identity");
                String type = (String)requirement.getAttributes().get("type");
                VersionRange range = (VersionRange)requirement.getAttributes().get("version");
                if ("karaf.feature".equals(type) && allFeatures.containsKey(name)) {
                    for (Feature feature : allFeatures.get(name)) {
                        String ssName;
                        Subsystem fs;
                        if (range != null && !range.contains(VersionTable.getVersion(feature.getVersion())) || feature == this.feature || feature.isBlacklisted() || (fs = this.getChild(ssName = this.name + "#" + (feature.hasVersion() ? feature.getName() + "-" + feature.getVersion() : feature.getName()))) != null) continue;
                        fs = new Subsystem(ssName, feature, this, mandatory && !SubsystemResolveContext.isOptional(requirement));
                        fs.build(allFeatures);
                        this.installable.add(fs);
                        this.children.add(fs);
                    }
                }
                processed.add(requirement);
            }
            break;
        }
    }

    public Set<String> collectPrerequisites() {
        HashSet<String> prereqs = new HashSet<String>();
        this.doCollectPrerequisites(prereqs);
        return prereqs;
    }

    private void doCollectPrerequisites(Set<String> prereqs) {
        for (Subsystem child : this.children) {
            child.doCollectPrerequisites(prereqs);
        }
        if (this.feature != null) {
            boolean match = false;
            for (String prereq : prereqs) {
                String[] p = prereq.split("/");
                if (!this.feature.getName().equals(p[0]) || !VersionRange.parseVersionRange(p[1]).contains(Version.parseVersion((String)this.feature.getVersion()))) continue;
                match = true;
                break;
            }
            if (!match) {
                for (Dependency dep : this.feature.getDependencies()) {
                    if (!dep.isPrerequisite()) continue;
                    prereqs.add(dep.toString());
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void downloadBundles(DownloadManager manager, String featureResolutionRange, FeaturesService.ServiceRequirementsBehavior serviceRequirements, RepositoryManager repos, SubsystemResolverCallback callback) throws Exception {
        void var13_42;
        String loc;
        void var13_35;
        for (Subsystem child : this.children) {
            child.downloadBundles(manager, featureResolutionRange, serviceRequirements, repos, callback);
        }
        HashMap<BundleInfo, Conditional> infos = new HashMap<BundleInfo, Conditional>();
        Downloader downloader = manager.createDownloader();
        if (this.feature != null) {
            for (Conditional conditional : this.feature.getConditional()) {
                if (conditional.isBlacklisted()) continue;
                for (BundleInfo bundleInfo : conditional.getBundles()) {
                    infos.put(bundleInfo, conditional);
                }
            }
            for (BundleInfo bundleInfo : this.feature.getBundles()) {
                infos.put(bundleInfo, null);
            }
        }
        Iterator iterator = infos.keySet().iterator();
        while (iterator.hasNext()) {
            BundleInfo bundleInfo = (BundleInfo)iterator.next();
            if (!bundleInfo.isBlacklisted()) continue;
            iterator.remove();
            if (callback == null) continue;
            callback.bundleBlacklisted(bundleInfo);
        }
        ConcurrentHashMap bundles = new ConcurrentHashMap();
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        boolean removeServiceRequirements = this.serviceRequirementsBehavior(this.feature, serviceRequirements);
        for (Map.Entry entry : infos.entrySet()) {
            BundleInfo bundleInfo = (BundleInfo)entry.getKey();
            String string = bundleInfo.getLocation();
            downloader.download(string, provider -> {
                ResourceImpl resource = this.createResource(loc2, this.getMetadata(provider), removeServiceRequirements);
                bundles.put(loc2, resource);
                if (bi.isOverriden() == BundleInfo.BundleOverrideMode.OSGI) {
                    downloader.download(bi.getOriginalLocation(), provider2 -> {
                        ResourceImpl originalResource = this.createResource(bi.getOriginalLocation(), this.getMetadata(provider2), removeServiceRequirements);
                        bundles.put(bi.getOriginalLocation(), originalResource);
                        overrides.put(loc2, originalResource);
                    });
                }
            });
        }
        Clause[] clauseArray = Parser.parseClauses(this.bundles.toArray(new String[this.bundles.size()]));
        int n = clauseArray.length;
        boolean bl = false;
        while (var13_35 < n) {
            Clause clause = clauseArray[var13_35];
            loc = clause.getName();
            downloader.download(loc, provider -> bundles.put(loc, this.createResource(loc, this.getMetadata(provider), removeServiceRequirements)));
            ++var13_35;
        }
        if (this.feature != null) {
            for (Library library : this.feature.getLibraries()) {
                if (!library.isExport()) continue;
                String string = library.getLocation();
                downloader.download(string, provider -> bundles.put(loc3, this.createResource(loc3, this.getMetadata(provider), removeServiceRequirements)));
            }
        }
        downloader.await();
        Overrides.override(bundles, concurrentHashMap);
        if (this.feature != null) {
            ResourceImpl res;
            HashMap<Conditional, FeatureResource> hashMap = new HashMap<Conditional, FeatureResource>();
            for (Conditional conditional : this.feature.getConditional()) {
                if (conditional.isBlacklisted()) continue;
                FeatureResource featureResource = FeatureResource.build(this.feature, conditional, featureResolutionRange, bundles);
                ResourceUtils.addIdentityRequirement(this, featureResource, false);
                ResourceUtils.addIdentityRequirement(featureResource, this, true);
                this.installable.add(featureResource);
                hashMap.put(conditional, featureResource);
            }
            FeatureResource featureResource = FeatureResource.build(this.feature, featureResolutionRange, bundles);
            ResourceUtils.addIdentityRequirement(featureResource, this);
            this.installable.add(featureResource);
            for (Map.Entry entry : infos.entrySet()) {
                boolean mandatory;
                int sl;
                BundleInfo bi = (BundleInfo)entry.getKey();
                String loc4 = bi.getLocation();
                Conditional cond = (Conditional)entry.getValue();
                res = (ResourceImpl)bundles.get(loc4);
                int n2 = sl = bi.getStartLevel() <= 0 ? this.feature.getStartLevel() : bi.getStartLevel();
                if (cond != null) {
                    ResourceUtils.addIdentityRequirement(res, (Resource)hashMap.get(cond), true);
                }
                boolean bl2 = mandatory = !bi.isDependency() && cond == null;
                if (bi.isDependency()) {
                    this.addDependency(res, mandatory, bi.isStart(), sl, bi.isBlacklisted());
                    continue;
                }
                this.doAddDependency(res, mandatory, bi.isStart(), sl, bi.isBlacklisted());
            }
            for (Library library : this.feature.getLibraries()) {
                if (!library.isExport()) continue;
                loc = library.getLocation();
                ResourceImpl res2 = (ResourceImpl)bundles.get(loc);
                this.addDependency(res2, false, false, 0, false);
            }
            for (String string : this.feature.getResourceRepositories()) {
                BaseRepository repo = repos.getRepository(this.feature.getRepositoryUrl(), string);
                for (Resource resource : repo.getResources()) {
                    res = this.cloneResource(resource);
                    this.addDependency(res, false, true, 0, false);
                }
            }
        }
        Clause[] clauseArray2 = Parser.parseClauses(this.bundles.toArray(new String[this.bundles.size()]));
        int n3 = clauseArray2.length;
        boolean bl3 = false;
        while (var13_42 < n3) {
            Clause clause = clauseArray2[var13_42];
            loc = clause.getName();
            boolean dependency = Boolean.parseBoolean(clause.getAttribute("dependency"));
            boolean start = clause.getAttribute("start") == null || Boolean.parseBoolean(clause.getAttribute("start"));
            boolean blacklisted = clause.getAttribute("blacklisted") != null && Boolean.parseBoolean(clause.getAttribute("blacklisted"));
            int startLevel = 0;
            try {
                startLevel = Integer.parseInt(clause.getAttribute("start-level"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (dependency) {
                this.addDependency((ResourceImpl)bundles.get(loc), false, start, startLevel, blacklisted);
            } else {
                this.doAddDependency((ResourceImpl)bundles.get(loc), true, start, startLevel, blacklisted);
                ResourceUtils.addIdentityRequirement(this, (Resource)bundles.get(loc));
            }
            ++var13_42;
        }
        for (DependencyInfo dependencyInfo : this.dependencies.values()) {
            this.installable.add(dependencyInfo.resource);
            ResourceUtils.addIdentityRequirement(dependencyInfo.resource, this, dependencyInfo.mandatory);
        }
    }

    private boolean serviceRequirementsBehavior(Feature feature, FeaturesService.ServiceRequirementsBehavior serviceRequirements) {
        if (FeaturesService.ServiceRequirementsBehavior.Disable == serviceRequirements) {
            return true;
        }
        if (feature != null && FeaturesService.ServiceRequirementsBehavior.Default == serviceRequirements) {
            return "http://karaf.apache.org/xmlns/features/v1.0.0".equals(feature.getNamespace()) || "http://karaf.apache.org/xmlns/features/v1.1.0".equals(feature.getNamespace()) || "http://karaf.apache.org/xmlns/features/v1.2.0".equals(feature.getNamespace()) || "http://karaf.apache.org/xmlns/features/v1.2.1".equals(feature.getNamespace());
        }
        return false;
    }

    ResourceImpl cloneResource(Resource resource) {
        ResourceImpl res = new ResourceImpl();
        for (Capability cap : resource.getCapabilities(null)) {
            res.addCapability(new CapabilityImpl(res, cap.getNamespace(), new StringArrayMap<String>(cap.getDirectives()), new StringArrayMap<Object>(cap.getAttributes())));
        }
        for (Requirement req : resource.getRequirements(null)) {
            SimpleFilter sf = req instanceof RequirementImpl ? ((RequirementImpl)req).getFilter() : (req.getDirectives().containsKey("filter") ? SimpleFilter.parse((String)req.getDirectives().get("filter")) : SimpleFilter.convert(req.getAttributes()));
            res.addRequirement(new RequirementImpl(res, req.getNamespace(), new StringArrayMap<String>(req.getDirectives()), new StringArrayMap<Object>(req.getAttributes()), sf));
        }
        return res;
    }

    Map<String, String> getMetadata(StreamProvider provider) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(provider.open());){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (!"META-INF/MANIFEST.MF".equals(entry.getName())) continue;
                Attributes attributes = new Manifest(zis).getMainAttributes();
                HashMap<String, String> headers = new HashMap<String, String>();
                for (Map.Entry<Object, Object> attr : attributes.entrySet()) {
                    headers.put(attr.getKey().toString(), attr.getValue().toString());
                }
                HashMap<String, String> hashMap = headers;
                return hashMap;
            }
        }
        throw new IllegalArgumentException("Resource " + provider.getUrl() + " does not contain a manifest");
    }

    void addDependency(ResourceImpl resource, boolean mandatory, boolean start, int startLevel, boolean blacklisted) {
        if (this.isAcceptDependencies()) {
            this.doAddDependency(resource, mandatory, start, startLevel, blacklisted);
        } else {
            this.parent.addDependency(resource, mandatory, start, startLevel, blacklisted);
        }
    }

    private void doAddDependency(ResourceImpl resource, boolean mandatory, boolean start, int startLevel, boolean blacklisted) {
        String id = ResolverUtil.getSymbolicName(resource) + "|" + ResolverUtil.getVersion(resource);
        DependencyInfo info = new DependencyInfo(resource, mandatory, start, startLevel, blacklisted);
        this.dependencies.merge(id, info, this::merge);
    }

    /*
     * Enabled aggressive block sorting
     */
    private DependencyInfo merge(DependencyInfo di1, DependencyInfo di2) {
        DependencyInfo info = new DependencyInfo();
        if (di1.resource != di2.resource) {
            RequirementImpl r1 = this.getFirstIdentityReq(di1.resource);
            RequirementImpl r2 = this.getFirstIdentityReq(di2.resource);
            if (r1 == null) {
                info.resource = di1.resource;
            } else {
                if (r2 != null) {
                    String id = ResolverUtil.getSymbolicName(di1.resource) + "/" + ResolverUtil.getVersion(di1.resource);
                    throw new IllegalStateException("Resource " + id + " is duplicated on subsystem " + this.toString() + ". First resource requires " + r1 + " while the second requires " + r2);
                }
                info.resource = di2.resource;
            }
        } else {
            info.resource = di1.resource;
        }
        info.mandatory = di1.mandatory | di2.mandatory;
        info.start = di1.start | di2.start;
        if (di1.startLevel > 0 && di2.startLevel > 0) {
            info.startLevel = Math.min(di1.startLevel, di2.startLevel);
            return info;
        }
        info.startLevel = Math.max(di1.startLevel, di2.startLevel);
        return info;
    }

    private RequirementImpl getFirstIdentityReq(ResourceImpl resource) {
        for (Requirement r : resource.getRequirements(null)) {
            if (!"osgi.identity".equals(r.getNamespace())) continue;
            return (RequirementImpl)r;
        }
        return null;
    }

    Map<String, Set<String>> createPolicy(List<? extends ScopeFilter> filters) {
        HashMap<String, Set<String>> policy = new HashMap<String, Set<String>>();
        for (ScopeFilter scopeFilter : filters) {
            MapUtils.addToMapSet(policy, scopeFilter.getNamespace(), scopeFilter.getFilter());
        }
        return policy;
    }

    ResourceImpl createResource(String uri, Map<String, String> headers, boolean removeServiceRequirements) throws Exception {
        try {
            return ResourceBuilder.build(uri, headers, removeServiceRequirements);
        }
        catch (BundleException e) {
            throw new Exception("Unable to create resource for bundle " + uri, e);
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    class DependencyInfo
    implements BundleInfo {
        ResourceImpl resource;
        boolean mandatory;
        boolean start;
        int startLevel;
        boolean blacklisted;
        BundleInfo.BundleOverrideMode overriden;

        public DependencyInfo() {
        }

        public DependencyInfo(ResourceImpl resource, boolean mandatory, boolean start, int startLevel, boolean blacklisted) {
            this.resource = resource;
            this.mandatory = mandatory;
            this.start = start;
            this.startLevel = startLevel;
            this.blacklisted = blacklisted;
        }

        @Override
        public boolean isStart() {
            return this.start;
        }

        @Override
        public int getStartLevel() {
            return this.startLevel;
        }

        @Override
        public String getLocation() {
            return ResourceUtils.getUri(this.resource);
        }

        @Override
        public String getOriginalLocation() {
            return ResourceUtils.getUri(this.resource);
        }

        @Override
        public boolean isDependency() {
            return !this.mandatory;
        }

        @Override
        public boolean isBlacklisted() {
            return this.blacklisted;
        }

        @Override
        public BundleInfo.BundleOverrideMode isOverriden() {
            return this.overriden;
        }

        public void setOverriden(BundleInfo.BundleOverrideMode overriden) {
            this.overriden = overriden;
        }

        public String toString() {
            return "DependencyInfo{resource=" + this.resource + '}';
        }
    }
}

