/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.OutputStream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.consumer.ConsumerThreadId;
import kafka.tools.VerifyConsumerRebalance$;
import kafka.tools.VerifyConsumerRebalance$$anonfun$validateRebalancingOperation$2$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VerifyConsumerRebalance$
implements Logging,
ScalaObject {
    public static final VerifyConsumerRebalance$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new VerifyConsumerRebalance$();
    }

    public void main(String[] args) {
        OptionSet options;
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec zkConnectOpt = parser.accepts("zookeeper.connect", "ZooKeeper connect string.").withRequiredArg().defaultsTo((Object)"localhost:2181", (Object[])new String[0]).ofType(String.class);
        ArgumentAcceptingOptionSpec groupOpt = parser.accepts("group", "Consumer group.").withRequiredArg().ofType(String.class);
        parser.accepts("help", "Print this message.");
        if (args.length == 0) {
            CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Validate that all partitions have a consumer for a given consumer group.");
        }
        if ((options = parser.parse(args)).has("help")) {
            parser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{groupOpt}));
        String zkConnect$1 = (String)options.valueOf((OptionSpec)zkConnectOpt);
        String group$1 = (String)options.valueOf((OptionSpec)groupOpt);
        ZkClient zkClient = null;
        try {
            zkClient = new ZkClient(zkConnect$1, 30000, 30000, (ZkSerializer)ZKStringSerializer$.MODULE$);
            this.debug((Function0<String>)new Serializable(zkConnect$1, group$1){
                public static final long serialVersionUID;
                private final String zkConnect$1;
                private final String group$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("zkConnect = %s; group = %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkConnect$1, this.group$1}));
                }
                {
                    this.zkConnect$1 = string;
                    this.group$1 = string2;
                }
            });
            try {
                if (this.validateRebalancingOperation(zkClient, group$1)) {
                    Predef$.MODULE$.println((Object)"Rebalance operation successful !");
                }
                Predef$.MODULE$.println((Object)"Rebalance operation failed !");
            }
            catch (Throwable throwable) {
                this.error((Function0<String>)new Serializable(){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return "Error while verifying current rebalancing operation";
                    }
                }, (Function0<Throwable>)new Serializable(throwable){
                    public static final long serialVersionUID;
                    private final Throwable e2$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Throwable apply() {
                        return this.e2$1;
                    }
                    {
                        this.e2$1 = throwable;
                    }
                });
            }
            return;
        }
        finally {
            if (zkClient != null) {
                zkClient.close();
            }
        }
    }

    private boolean validateRebalancingOperation(ZkClient zkClient$1, String group$2) {
        this.info((Function0<String>)new Serializable(group$2){
            public static final long serialVersionUID;
            private final String group$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Verifying rebalancing operation for consumer group ").append((Object)this.group$2).toString();
            }
            {
                this.group$2 = string;
            }
        });
        BooleanRef rebalanceSucceeded$1 = new BooleanRef(true);
        Map<String, List<ConsumerThreadId>> consumersPerTopicMap$1 = ZkUtils$.MODULE$.getConsumersPerTopic(zkClient$1, group$2, false);
        Map<String, Seq<Object>> partitionsPerTopicMap = ZkUtils$.MODULE$.getPartitionsForTopics(zkClient$1, (Seq<String>)consumersPerTopicMap$1.keySet().toSeq());
        partitionsPerTopicMap.foreach((Function1)new Serializable(zkClient$1, group$2, rebalanceSucceeded$1, consumersPerTopicMap$1){
            public static final long serialVersionUID;
            public final ZkClient zkClient$1;
            public final String group$2;
            public final BooleanRef rebalanceSucceeded$1;
            public final Map consumersPerTopicMap$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<String, Seq<Object>> partitionsForTopic2) {
                String topic$1 = (String)partitionsForTopic2._1();
                Seq partitions$1 = (Seq)partitionsForTopic2._2();
                ZKGroupTopicDirs topicDirs$1 = new ZKGroupTopicDirs(this.group$2, topic$1);
                VerifyConsumerRebalance$.MODULE$.info((Function0<String>)new Serializable(this, topic$1, partitions$1){
                    public static final long serialVersionUID;
                    private final String topic$1;
                    private final Seq partitions$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Alive partitions for topic %s are %s ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.partitions$1.toString()}));
                    }
                    {
                        this.topic$1 = string;
                        this.partitions$1 = seq;
                    }
                });
                VerifyConsumerRebalance$.MODULE$.info((Function0<String>)new Serializable(this, topic$1){
                    public static final long serialVersionUID;
                    private final anonfun.validateRebalancingOperation.2 $outer;
                    private final String topic$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Alive consumers for topic %s => %s ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.$outer.consumersPerTopicMap$1.get((Object)this.topic$1)}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.topic$1 = string;
                    }
                });
                Seq<String> partitionsWithOwners$1 = ZkUtils$.MODULE$.getChildrenParentMayNotExist(this.zkClient$1, topicDirs$1.consumerOwnerDir());
                if (partitionsWithOwners$1.size() == 0) {
                    VerifyConsumerRebalance$.MODULE$.error((Function0<String>)new Serializable(this, topic$1){
                        public static final long serialVersionUID;
                        private final String topic$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return new StringBuilder().append((Object)"No owners for any partitions for topic ").append((Object)this.topic$1).toString();
                        }
                        {
                            this.topic$1 = string;
                        }
                    });
                    this.rebalanceSucceeded$1.elem = false;
                }
                VerifyConsumerRebalance$.MODULE$.debug((Function0<String>)new Serializable(this, topicDirs$1, partitionsWithOwners$1){
                    public static final long serialVersionUID;
                    private final ZKGroupTopicDirs topicDirs$1;
                    private final Seq partitionsWithOwners$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Children of ").append((Object)this.topicDirs$1.consumerOwnerDir()).append((Object)" = ").append((Object)this.partitionsWithOwners$1.toString()).toString();
                    }
                    {
                        this.topicDirs$1 = zKGroupTopicDirs;
                        this.partitionsWithOwners$1 = seq;
                    }
                });
                Option consumerIdsForTopic$1 = this.consumersPerTopicMap$1.get((Object)topic$1);
                partitions$1.foreach((Function1)new Serializable(this, topic$1, topicDirs$1, partitionsWithOwners$1, consumerIdsForTopic$1){
                    public static final long serialVersionUID;
                    private final anonfun.validateRebalancingOperation.2 $outer;
                    public final String topic$1;
                    private final ZKGroupTopicDirs topicDirs$1;
                    private final Seq partitionsWithOwners$1;
                    private final Option consumerIdsForTopic$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(int partition) {
                        this.apply$mcVI$sp(partition);
                    }

                    public void apply$mcVI$sp(int v1$1) {
                        Option option;
                        block8: {
                            Option option2;
                            block12: {
                                block10: {
                                    block11: {
                                        String partitionOwner$1;
                                        block9: {
                                            block7: {
                                                String string;
                                                block6: {
                                                    String partitionOwnerPath;
                                                    if (!this.partitionsWithOwners$1.exists((Function1)new Serializable(this, v1$1){
                                                        public static final long serialVersionUID;
                                                        private final int v1$1;

                                                        static {
                                                            long l = serialVersionUID = 0L;
                                                        }

                                                        public final boolean apply(String p) {
                                                            return p.equals(BoxesRunTime.boxToInteger((int)this.v1$1));
                                                        }
                                                        {
                                                            this.v1$1 = n;
                                                        }
                                                    })) {
                                                        VerifyConsumerRebalance$.MODULE$.error((Function0<String>)new Serializable(this, v1$1){
                                                            public static final long serialVersionUID;
                                                            private final anonfun$validateRebalancingOperation$2$$anonfun$apply$1 $outer;
                                                            private final int v1$1;

                                                            static {
                                                                long l = serialVersionUID = 0L;
                                                            }

                                                            public final String apply() {
                                                                return Predef$.MODULE$.augmentString("No owner for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic$1, BoxesRunTime.boxToInteger((int)this.v1$1)}));
                                                            }
                                                            {
                                                                if ($outer == null) {
                                                                    throw new NullPointerException();
                                                                }
                                                                this.$outer = $outer;
                                                                this.v1$1 = n;
                                                            }
                                                        });
                                                        this.$outer.rebalanceSucceeded$1.elem = false;
                                                    }
                                                    if (!((option = (Option)ZkUtils$.MODULE$.readDataMaybeNull(this.$outer.zkClient$1, partitionOwnerPath = new StringBuilder().append((Object)this.topicDirs$1.consumerOwnerDir()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)v1$1)).toString())._1()) instanceof Some)) break block6;
                                                    string = (String)((Some)option).x();
                                                    break block7;
                                                }
                                                None$ none$ = None$.MODULE$;
                                                Option option3 = option;
                                                if (none$ != null ? !none$.equals(option3) : option3 != null) break block8;
                                                string = partitionOwner$1 = null;
                                            }
                                            if (partitionOwner$1 != null) break block9;
                                            VerifyConsumerRebalance$.MODULE$.error((Function0<String>)new Serializable(this, v1$1){
                                                public static final long serialVersionUID;
                                                private final anonfun$validateRebalancingOperation$2$$anonfun$apply$1 $outer;
                                                private final int v1$1;

                                                static {
                                                    long l = serialVersionUID = 0L;
                                                }

                                                public final String apply() {
                                                    return Predef$.MODULE$.augmentString("No owner for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic$1, BoxesRunTime.boxToInteger((int)this.v1$1)}));
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw new NullPointerException();
                                                    }
                                                    this.$outer = $outer;
                                                    this.v1$1 = n;
                                                }
                                            });
                                            this.$outer.rebalanceSucceeded$1.elem = false;
                                            break block10;
                                        }
                                        option2 = this.consumerIdsForTopic$1;
                                        if (!(option2 instanceof Some)) break block11;
                                        if (((SeqLike)((Some)option2).x()).contains((Object)partitionOwner$1)) {
                                            VerifyConsumerRebalance$.MODULE$.info((Function0<String>)new Serializable(this, partitionOwner$1, v1$1){
                                                public static final long serialVersionUID;
                                                private final anonfun$validateRebalancingOperation$2$$anonfun$apply$1 $outer;
                                                private final String partitionOwner$1;
                                                private final int v1$1;

                                                static {
                                                    long l = serialVersionUID = 0L;
                                                }

                                                public final String apply() {
                                                    return Predef$.MODULE$.augmentString("Owner of partition [%s,%d] is %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic$1, BoxesRunTime.boxToInteger((int)this.v1$1), this.partitionOwner$1}));
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw new NullPointerException();
                                                    }
                                                    this.$outer = $outer;
                                                    this.partitionOwner$1 = string;
                                                    this.v1$1 = n;
                                                }
                                            });
                                        } else {
                                            VerifyConsumerRebalance$.MODULE$.error((Function0<String>)new Serializable(this, partitionOwner$1, v1$1){
                                                public static final long serialVersionUID;
                                                private final anonfun$validateRebalancingOperation$2$$anonfun$apply$1 $outer;
                                                private final String partitionOwner$1;
                                                private final int v1$1;

                                                static {
                                                    long l = serialVersionUID = 0L;
                                                }

                                                public final String apply() {
                                                    return Predef$.MODULE$.augmentString("Owner %s for partition [%s,%d] is not a valid member of consumer group %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionOwner$1, this.$outer.topic$1, BoxesRunTime.boxToInteger((int)this.v1$1), this.$outer.kafka$tools$VerifyConsumerRebalance$$anonfun$$anonfun$$$outer().group$2}));
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw new NullPointerException();
                                                    }
                                                    this.$outer = $outer;
                                                    this.partitionOwner$1 = string;
                                                    this.v1$1 = n;
                                                }
                                            });
                                            this.$outer.rebalanceSucceeded$1.elem = false;
                                        }
                                        break block10;
                                    }
                                    None$ none$ = None$.MODULE$;
                                    Option option4 = option2;
                                    if (none$ != null ? !none$.equals(option4) : option4 != null) break block12;
                                    VerifyConsumerRebalance$.MODULE$.error((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID;
                                        private final anonfun$validateRebalancingOperation$2$$anonfun$apply$1 $outer;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final String apply() {
                                            return new StringBuilder().append((Object)"No consumer ids registered for topic ").append((Object)this.$outer.topic$1).toString();
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                    this.$outer.rebalanceSucceeded$1.elem = false;
                                }
                                return;
                            }
                            throw new MatchError((Object)option2);
                        }
                        throw new MatchError((Object)option);
                    }

                    public anonfun.validateRebalancingOperation.2 kafka$tools$VerifyConsumerRebalance$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.topic$1 = string;
                        this.topicDirs$1 = zKGroupTopicDirs;
                        this.partitionsWithOwners$1 = seq;
                        this.consumerIdsForTopic$1 = option;
                    }
                });
            }
            {
                this.zkClient$1 = zkClient;
                this.group$2 = string;
                this.rebalanceSucceeded$1 = booleanRef;
                this.consumersPerTopicMap$1 = map;
            }
        });
        return rebalanceSucceeded$1.elem;
    }

    private VerifyConsumerRebalance$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

