/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.common.Topic$;
import kafka.tools.StateChangeLogMerger;
import kafka.tools.StateChangeLogMerger$dateBasedOrdering$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassManifest$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StateChangeLogMerger$
implements Logging,
ScalaObject {
    public static final StateChangeLogMerger$ MODULE$;
    private final String dateFormatString;
    private final Regex topicPartitionRegex;
    private final Regex dateRegex;
    private final SimpleDateFormat dateFormat;
    private List<String> files;
    private String topic;
    private List<Object> partitions;
    private Date startDate;
    private Date endDate;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new StateChangeLogMerger$();
    }

    public String dateFormatString() {
        return this.dateFormatString;
    }

    public Regex topicPartitionRegex() {
        return this.topicPartitionRegex;
    }

    public Regex dateRegex() {
        return this.dateRegex;
    }

    public SimpleDateFormat dateFormat() {
        return this.dateFormat;
    }

    public List<String> files() {
        return this.files;
    }

    public void files_$eq(List<String> list) {
        this.files = list;
    }

    public String topic() {
        return this.topic;
    }

    public void topic_$eq(String string) {
        this.topic = string;
    }

    public List<Object> partitions() {
        return this.partitions;
    }

    public void partitions_$eq(List<Object> list) {
        this.partitions = list;
    }

    public Date startDate() {
        return this.startDate;
    }

    public void startDate_$eq(Date date) {
        this.startDate = date;
    }

    public Date endDate() {
        return this.endDate;
    }

    public void endDate_$eq(Date date) {
        this.endDate = date;
    }

    public void main(String[] args) {
        OptionSet options;
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec filesOpt = parser.accepts("logs", "Comma separated list of state change logs or a regex for the log file names").withRequiredArg().describedAs("file1,file2,...").ofType(String.class);
        ArgumentAcceptingOptionSpec regexOpt = parser.accepts("logs-regex", "Regex to match the state change log files to be merged").withRequiredArg().describedAs("for example: /tmp/state-change.log*").ofType(String.class);
        ArgumentAcceptingOptionSpec topicOpt = parser.accepts("topic", "The topic whose state change logs should be merged").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec partitionsOpt = parser.accepts("partitions", "Comma separated list of partition ids whose state change logs should be merged").withRequiredArg().describedAs("0,1,2,...").ofType(String.class);
        ArgumentAcceptingOptionSpec startTimeOpt = parser.accepts("start-time", "The earliest timestamp of state change log entries to be merged").withRequiredArg().describedAs(new StringBuilder().append((Object)"start timestamp in the format ").append((Object)this.dateFormat()).toString()).ofType(String.class).defaultsTo((Object)"0000-00-00 00:00:00,000", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec endTimeOpt = parser.accepts("end-time", "The latest timestamp of state change log entries to be merged").withRequiredArg().describedAs(new StringBuilder().append((Object)"end timestamp in the format ").append((Object)this.dateFormat()).toString()).ofType(String.class).defaultsTo((Object)"9999-12-31 23:59:59,999", (Object[])new String[0]);
        if (args.length == 0) {
            CommandLineUtils$.MODULE$.printUsageAndDie(parser, "A tool for merging the log files from several brokers to reconnstruct a unified history of what happened.");
        }
        if (!(options = parser.parse(args)).has((OptionSpec)filesOpt) && !options.has((OptionSpec)regexOpt) || options.has((OptionSpec)filesOpt) && options.has((OptionSpec)regexOpt)) {
            System.err.println(new StringBuilder().append((Object)"Provide arguments to exactly one of the two options \"").append((Object)filesOpt).append((Object)"\" or \"").append((Object)regexOpt).append((Object)"\"").toString());
            parser.printHelpOn((OutputStream)System.err);
            System.exit(1);
        }
        if (options.has((OptionSpec)partitionsOpt) && !options.has((OptionSpec)topicOpt)) {
            System.err.println(new StringBuilder().append((Object)"The option \"").append((Object)topicOpt).append((Object)"\" needs to be provided an argument when specifying partition ids").toString());
            parser.printHelpOn((OutputStream)System.err);
            System.exit(1);
        }
        if (options.has((OptionSpec)filesOpt)) {
            this.files_$eq((List<String>)this.files().$colon$colon$colon(Predef$.MODULE$.refArrayOps((Object[])((String)options.valueOf((OptionSpec)filesOpt)).split(",")).toList()));
        } else if (options.has((OptionSpec)regexOpt)) {
            String regex = (String)options.valueOf((OptionSpec)regexOpt);
            int fileNameIndex = regex.lastIndexOf(47) + 1;
            String dirName$1 = fileNameIndex == 0 ? "." : regex.substring(0, fileNameIndex - 1);
            Regex fileNameRegex$1 = new Regex(regex.substring(fileNameIndex), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            this.files_$eq((List<String>)this.files().$colon$colon$colon(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])new File(dirName$1).listFiles()).filter((Function1)new Serializable(fileNameRegex$1){
                public static final long serialVersionUID;
                private final Regex fileNameRegex$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(File f) {
                    Option option = this.fileNameRegex$1.findFirstIn((CharSequence)f.getName());
                    None$ none$ = None$.MODULE$;
                    return option != null ? !option.equals(none$) : none$ != null;
                }
                {
                    this.fileNameRegex$1 = regex;
                }
            })).map((Function1)new Serializable(dirName$1){
                public static final long serialVersionUID;
                private final String dirName$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply(File file) {
                    return new StringBuilder().append((Object)this.dirName$1).append((Object)"/").append((Object)file.getName()).toString();
                }
                {
                    this.dirName$1 = string;
                }
            }, Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(String.class)))).toList()));
        }
        if (options.has((OptionSpec)topicOpt)) {
            this.topic_$eq((String)options.valueOf((OptionSpec)topicOpt));
        }
        if (options.has((OptionSpec)partitionsOpt)) {
            this.partitions_$eq((List<Object>)((List)Predef$.MODULE$.refArrayOps((Object[])((String)options.valueOf((OptionSpec)partitionsOpt)).split(",")).toList().map((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final int apply(String string) {
                    return Predef$.MODULE$.augmentString(string).toInt();
                }
            }, List$.MODULE$.canBuildFrom())));
            Iterable<Object> duplicatePartitions = Utils$.MODULE$.duplicates(this.partitions());
            if (duplicatePartitions.nonEmpty()) {
                System.err.println(Predef$.MODULE$.augmentString("The list of partitions contains repeated entries: %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicatePartitions.mkString(",")})));
                System.exit(1);
            }
        }
        this.startDate_$eq(this.dateFormat().parse(((String)options.valueOf((OptionSpec)startTimeOpt)).replace('\"', ' ').trim()));
        this.endDate_$eq(this.dateFormat().parse(((String)options.valueOf((OptionSpec)endTimeOpt)).replace('\"', ' ').trim()));
        PriorityQueue pqueue = new PriorityQueue((Ordering)StateChangeLogMerger$dateBasedOrdering$.MODULE$);
        BufferedOutputStream output = new BufferedOutputStream(System.out, 0x100000);
        List lineIterators = (List)this.files().map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Iterator<String> apply(String string) {
                return Source$.MODULE$.fromFile(string, Codec$.MODULE$.fallbackSystemCodec()).getLines();
            }
        }, List$.MODULE$.canBuildFrom());
        ObjectRef lines$1 = new ObjectRef((Object)Nil$.MODULE$);
        lineIterators.foreach((Function1)new Serializable(lines$1){
            public static final long serialVersionUID;
            private final ObjectRef lines$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Iterator<String> itr) {
                StateChangeLogMerger.LineIterator lineItr = StateChangeLogMerger$.MODULE$.getNextLine(itr);
                if (!lineItr.isEmpty()) {
                    this.lines$1.elem = ((List)this.lines$1.elem).$colon$colon((Object)lineItr);
                }
            }
            {
                this.lines$1 = objectRef;
            }
        });
        if (!((List)lines$1.elem).isEmpty()) {
            pqueue.enqueue((Seq)((List)lines$1.elem));
        }
        while (true) {
            if (pqueue.isEmpty()) {
                ((OutputStream)output).flush();
                return;
            }
            StateChangeLogMerger.LineIterator lineItr = (StateChangeLogMerger.LineIterator)pqueue.dequeue();
            ((OutputStream)output).write(new StringBuilder().append((Object)lineItr.line()).append((Object)"\n").toString().getBytes());
            StateChangeLogMerger.LineIterator nextLineItr = this.getNextLine(lineItr.itr());
            if (nextLineItr.isEmpty()) continue;
            pqueue.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StateChangeLogMerger.LineIterator[]{nextLineItr}));
        }
    }

    public StateChangeLogMerger.LineIterator getNextLine(Iterator<String> itr) {
        while (itr != null && itr.hasNext()) {
            String nextLine = (String)itr.next();
            Option option = this.dateRegex().findFirstIn((CharSequence)nextLine);
            if (option instanceof Some) {
                String string;
                Some some = (Some)option;
                String d = string = (String)some.x();
                Date date = this.dateFormat().parse(d);
                if (!date.equals(this.startDate()) && !date.after(this.startDate()) || !date.equals(this.endDate()) && !date.before(this.endDate())) continue;
                Option option2 = this.topicPartitionRegex().findFirstMatchIn((CharSequence)nextLine);
                if (option2 instanceof Some) {
                    Regex.Match match;
                    Some some2 = (Some)option2;
                    Regex.Match matcher = match = (Regex.Match)some2.x();
                    if (this.topic() != null) {
                        String string2 = this.topic();
                        String string3 = matcher.group(1);
                        if (string2 != null ? !string2.equals(string3) : string3 != null) continue;
                    }
                    if (!this.partitions().isEmpty() && !this.partitions().contains((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.augmentString(matcher.group(3)).toInt()))) continue;
                    return new StateChangeLogMerger.LineIterator(nextLine, itr);
                }
                None$ none$ = None$.MODULE$;
                Option option3 = option2;
                if (!(none$ == null ? option3 != null : !none$.equals(option3))) continue;
                throw new MatchError((Object)option2);
            }
            None$ none$ = None$.MODULE$;
            Option option4 = option;
            if (!(none$ == null ? option4 != null : !none$.equals(option4))) continue;
            throw new MatchError((Object)option);
        }
        return new StateChangeLogMerger.LineIterator();
    }

    private StateChangeLogMerger$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.dateFormatString = "yyyy-MM-dd HH:mm:ss,SSS";
        this.topicPartitionRegex = new Regex(new StringBuilder().append((Object)"\\[(").append((Object)Topic$.MODULE$.legalChars()).append((Object)"+),( )*([0-9]+)\\]").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.dateRegex = new Regex("[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2},[0-9]{3}", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.dateFormat = new SimpleDateFormat(this.dateFormatString());
        this.files = Nil$.MODULE$;
        this.topic = null;
        this.partitions = Nil$.MODULE$;
        this.startDate = null;
        this.endDate = null;
    }
}

