/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.OutputStream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImportZkOffsets$
implements Logging,
ScalaObject {
    public static final ImportZkOffsets$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new ImportZkOffsets$();
    }

    public void main(String[] args) {
        OptionSet options;
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec zkConnectOpt = parser.accepts("zkconnect", "ZooKeeper connect string.").withRequiredArg().defaultsTo((Object)"localhost:2181", (Object[])new String[0]).ofType(String.class);
        ArgumentAcceptingOptionSpec inFileOpt = parser.accepts("input-file", "Input file").withRequiredArg().ofType(String.class);
        parser.accepts("help", "Print this message.");
        if (args.length == 0) {
            CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Import offsets to zookeeper from files.");
        }
        if ((options = parser.parse(args)).has("help")) {
            parser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{inFileOpt}));
        String zkConnect = (String)options.valueOf((OptionSpec)zkConnectOpt);
        String partitionOffsetFile = (String)options.valueOf((OptionSpec)inFileOpt);
        ZkClient zkClient = new ZkClient(zkConnect, 30000, 30000, (ZkSerializer)ZKStringSerializer$.MODULE$);
        Map<String, String> partitionOffsets = this.getPartitionOffsetsFromFile(partitionOffsetFile);
        this.updateZkOffsets(zkClient, partitionOffsets);
    }

    private Map<String, String> getPartitionOffsetsFromFile(String filename) {
        FileReader fr = new FileReader(filename);
        BufferedReader br = new BufferedReader(fr);
        Map partOffsetsMap = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        ObjectRef s$1 = new ObjectRef((Object)br.readLine());
        while ((String)s$1.elem != null && ((String)s$1.elem).length() >= 1) {
            String[] tokens = ((String)s$1.elem).split(":");
            partOffsetsMap = partOffsetsMap.$plus(Predef$.MODULE$.any2ArrowAssoc((Object)tokens[0]).$minus$greater((Object)tokens[1]));
            this.debug((Function0<String>)new Serializable(s$1){
                public static final long serialVersionUID;
                private final ObjectRef s$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"adding node path [").append((Object)((String)this.s$1.elem)).append((Object)"]").toString();
                }
                {
                    this.s$1 = objectRef;
                }
            });
            s$1.elem = br.readLine();
        }
        return partOffsetsMap;
    }

    private void updateZkOffsets(ZkClient zkClient$1, Map<String, String> partitionOffsets) {
        ((IterableLike)partitionOffsets.filter((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<String, String> tuple2) {
                Tuple2<String, String> tuple22 = tuple2;
                return tuple22 != null;
            }
        })).foreach((Function1)new Serializable(zkClient$1){
            public static final long serialVersionUID;
            private final ZkClient zkClient$1;

            static {
                long l = serialVersionUID = 0L;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void apply(Tuple2<String, String> tuple2) {
                Tuple2<String, String> tuple22 = tuple2;
                if (tuple22 == null) throw new MatchError(tuple22);
                String string = (String)tuple22._1();
                String string2 = (String)tuple22._2();
                String partition$1 = string;
                String offset$1 = string2;
                ImportZkOffsets$.MODULE$.debug((Function0<String>)new Serializable(this, partition$1, offset$1){
                    public static final long serialVersionUID;
                    private final String partition$1;
                    private final String offset$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"updating [").append((Object)this.partition$1).append((Object)"] with offset [").append((Object)this.offset$1).append((Object)"]").toString();
                    }
                    {
                        this.partition$1 = string;
                        this.offset$1 = string2;
                    }
                });
                try {
                    ZkUtils$.MODULE$.updatePersistentPath(this.zkClient$1, partition$1, offset$1.toString());
                    return;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            {
                this.zkClient$1 = zkClient;
            }
        });
    }

    private ImportZkOffsets$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

