/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Meter;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import kafka.common.KafkaException;
import kafka.network.AbstractServerThread;
import kafka.network.BoundedByteBufferReceive;
import kafka.network.ConnectionQuotas;
import kafka.network.Receive;
import kafka.network.RequestChannel;
import kafka.network.RequestChannel$CloseConnectionAction$;
import kafka.network.RequestChannel$NoOpAction$;
import kafka.network.RequestChannel$SendAction$;
import kafka.network.Send;
import kafka.utils.SystemTime$;
import kafka.utils.Time;
import scala.Function0;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005}d!B\u0001\u0003\u0001\u00111!!\u0003)s_\u000e,7o]8s\u0015\t\u0019A!A\u0004oKR<xN]6\u000b\u0003\u0015\tQa[1gW\u0006\u001c2\u0001A\u0004\f!\tA\u0011\"D\u0001\u0003\u0013\tQ!A\u0001\u000bBEN$(/Y2u'\u0016\u0014h/\u001a:UQJ,\u0017\r\u001a\t\u0003\u0019=i\u0011!\u0004\u0006\u0002\u001d\u0005)1oY1mC&\u0011\u0001#\u0004\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0003\u0005\u0013\u0001\t\u0015\r\u0011\"\u0001\u0015\u0003\tIGm\u0001\u0001\u0016\u0003U\u0001\"\u0001\u0004\f\n\u0005]i!aA%oi\"A\u0011\u0004\u0001B\u0001B\u0003%Q#A\u0002jI\u0002B\u0001b\u0007\u0001\u0003\u0006\u0004%\t\u0001H\u0001\u0005i&lW-F\u0001\u001e!\tq\u0012%D\u0001 \u0015\t\u0001C!A\u0003vi&d7/\u0003\u0002#?\t!A+[7f\u0011!!\u0003A!A!\u0002\u0013i\u0012!\u0002;j[\u0016\u0004\u0003\u0002\u0003\u0014\u0001\u0005\u000b\u0007I\u0011\u0001\u000b\u0002\u001d5\f\u0007PU3rk\u0016\u001cHoU5{K\"A\u0001\u0006\u0001B\u0001B\u0003%Q#A\bnCb\u0014V-];fgR\u001c\u0016N_3!\u0011!Q\u0003A!b\u0001\n\u0003Y\u0013AE1hOJ,w-\u0019;f\u0013\u0012dW-T3uKJ,\u0012\u0001\f\t\u0003[Yj\u0011A\f\u0006\u0003_A\nAaY8sK*\u0011\u0011GM\u0001\b[\u0016$(/[2t\u0015\t\u0019D'\u0001\u0004zC6lWM\u001d\u0006\u0002k\u0005\u00191m\\7\n\u0005]r#!B'fi\u0016\u0014\b\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0017\u0002'\u0005<wM]3hCR,\u0017\n\u001a7f\u001b\u0016$XM\u001d\u0011\t\u0011m\u0002!Q1A\u0005\u0002-\n\u0011\"\u001b3mK6+G/\u001a:\t\u0011u\u0002!\u0011!Q\u0001\n1\n!\"\u001b3mK6+G/\u001a:!\u0011!y\u0004A!b\u0001\n\u0003!\u0012!\u0006;pi\u0006d\u0007K]8dKN\u001cxN\u001d+ie\u0016\fGm\u001d\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005+\u00051Bo\u001c;bYB\u0013xnY3tg>\u0014H\u000b\u001b:fC\u0012\u001c\b\u0005\u0003\u0005D\u0001\t\u0015\r\u0011\"\u0001E\u00039\u0011X-];fgR\u001c\u0005.\u00198oK2,\u0012!\u0012\t\u0003\u0011\u0019K!a\u0012\u0002\u0003\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY\"A\u0011\n\u0001B\u0001B\u0003%Q)A\bsKF,Xm\u001d;DQ\u0006tg.\u001a7!\u0011!Y\u0005A!A!\u0002\u0013a\u0015\u0001E2p]:,7\r^5p]F+x\u000e^1t!\tAQ*\u0003\u0002O\u0005\t\u00012i\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m\u001d\u0005\t!\u0002\u0011)\u0019!C\u0001#\u0006!2m\u001c8oK\u000e$\u0018n\u001c8t\u001b\u0006D\u0018\n\u001a7f\u001bN,\u0012A\u0015\t\u0003\u0019MK!\u0001V\u0007\u0003\t1{gn\u001a\u0005\t-\u0002\u0011\t\u0011)A\u0005%\u0006)2m\u001c8oK\u000e$\u0018n\u001c8t\u001b\u0006D\u0018\n\u001a7f\u001bN\u0004\u0003\"\u0002-\u0001\t\u0003I\u0016A\u0002\u001fj]&$h\b\u0006\u0006[7rkfl\u00181bE\u000e\u0004\"\u0001\u0003\u0001\t\u000bI9\u0006\u0019A\u000b\t\u000bm9\u0006\u0019A\u000f\t\u000b\u0019:\u0006\u0019A\u000b\t\u000b):\u0006\u0019\u0001\u0017\t\u000bm:\u0006\u0019\u0001\u0017\t\u000b}:\u0006\u0019A\u000b\t\u000b\r;\u0006\u0019A#\t\u000b-;\u0006\u0019\u0001'\t\u000bA;\u0006\u0019\u0001*\t\u000f\u0015\u0004!\u0019!C\u0005M\u0006qa.Z<D_:tWm\u0019;j_:\u001cX#A4\u0011\u0007!|\u0017/D\u0001j\u0015\tQ7.\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001\\7\u0002\tU$\u0018\u000e\u001c\u0006\u0002]\u0006!!.\u0019<b\u0013\t\u0001\u0018NA\u000bD_:\u001cWO\u001d:f]Rd\u0015N\\6fIF+X-^3\u0011\u0005I<X\"A:\u000b\u0005Q,\u0018\u0001C2iC:tW\r\\:\u000b\u0005Yl\u0017a\u00018j_&\u0011\u0001p\u001d\u0002\u000e'>\u001c7.\u001a;DQ\u0006tg.\u001a7\t\ri\u0004\u0001\u0015!\u0003h\u0003=qWm^\"p]:,7\r^5p]N\u0004\u0003b\u0002?\u0001\u0005\u0004%I!U\u0001\u0018G>tg.Z2uS>t7/T1y\u0013\u0012dWMT1o_NDaA \u0001!\u0002\u0013\u0011\u0016\u0001G2p]:,7\r^5p]Nl\u0015\r_%eY\u0016t\u0015M\\8tA!A\u0011\u0011\u0001\u0001A\u0002\u0013%\u0011+\u0001\tdkJ\u0014XM\u001c;US6,g*\u00198pg\"I\u0011Q\u0001\u0001A\u0002\u0013%\u0011qA\u0001\u0015GV\u0014(/\u001a8u)&lWMT1o_N|F%Z9\u0015\t\u0005%\u0011q\u0002\t\u0004\u0019\u0005-\u0011bAA\u0007\u001b\t!QK\\5u\u0011%\t\t\"a\u0001\u0002\u0002\u0003\u0007!+A\u0002yIEBq!!\u0006\u0001A\u0003&!+A\tdkJ\u0014XM\u001c;US6,g*\u00198pg\u0002B\u0011\"!\u0007\u0001\u0005\u0004%I!a\u0007\u0002\u001d1\u0014XoQ8o]\u0016\u001cG/[8ogV\u0011\u0011Q\u0004\t\b\u0003?\t\t#!\nS\u001b\u0005Y\u0017bAA\u0012W\niA*\u001b8lK\u0012D\u0015m\u001d5NCB\u00042A]A\u0014\u0013\r\tIc\u001d\u0002\r'\u0016dWm\u0019;j_:\\U-\u001f\u0005\t\u0003[\u0001\u0001\u0015!\u0003\u0002\u001e\u0005yAN];D_:tWm\u0019;j_:\u001c\b\u0005\u0003\u0005\u00022\u0001\u0001\r\u0011\"\u0003R\u0003YqW\r\u001f;JI2,7\t\\8tK\u000eCWmY6US6,\u0007\"CA\u001b\u0001\u0001\u0007I\u0011BA\u001c\u0003iqW\r\u001f;JI2,7\t\\8tK\u000eCWmY6US6,w\fJ3r)\u0011\tI!!\u000f\t\u0013\u0005E\u00111GA\u0001\u0002\u0004\u0011\u0006bBA\u001f\u0001\u0001\u0006KAU\u0001\u0018]\u0016DH/\u00133mK\u000ecwn]3DQ\u0016\u001c7\u000eV5nK\u0002Bq!!\u0011\u0001\t\u0003\n\u0019%A\u0002sk:$\"!!\u0003\t\u000f\u0005\u001d\u0003\u0001\"\u0011\u0002J\u0005)1\r\\8tKR!\u0011\u0011BA&\u0011!\ti%!\u0012A\u0002\u0005\u0015\u0012aA6fs\"9\u0011\u0011\u000b\u0001\u0005\n\u0005\r\u0013a\u00059s_\u000e,7o\u001d(foJ+7\u000f]8og\u0016\u001c\bbBA+\u0001\u0011\u0005\u0011qK\u0001\u0007C\u000e\u001cW\r\u001d;\u0015\t\u0005%\u0011\u0011\f\u0005\b\u00037\n\u0019\u00061\u0001r\u00035\u0019xnY6fi\u000eC\u0017M\u001c8fY\"9\u0011q\f\u0001\u0005\n\u0005\r\u0013aF2p]\u001aLw-\u001e:f\u001d\u0016<8i\u001c8oK\u000e$\u0018n\u001c8t\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003K\nAA]3bIR!\u0011\u0011BA4\u0011!\ti%!\u0019A\u0002\u0005\u0015\u0002bBA6\u0001\u0011\u0005\u0011QN\u0001\u0006oJLG/\u001a\u000b\u0005\u0003\u0013\ty\u0007\u0003\u0005\u0002N\u0005%\u0004\u0019AA\u0013\u0011\u001d\t\u0019\b\u0001C\u0005\u0003k\n!b\u00195b]:,GNR8s)\r\t\u0018q\u000f\u0005\t\u0003\u001b\n\t\b1\u0001\u0002&!9\u00111\u0010\u0001\u0005\n\u0005u\u0014AG7bs\n,7\t\\8tK>cG-Z:u\u0007>tg.Z2uS>tWCAA\u0005\u0001")
public class Processor
extends AbstractServerThread
implements ScalaObject {
    private final int id;
    private final Time time;
    private final int maxRequestSize;
    private final Meter aggregateIdleMeter;
    private final Meter idleMeter;
    private final int totalProcessorThreads;
    private final RequestChannel requestChannel;
    private final long connectionsMaxIdleMs;
    private final ConcurrentLinkedQueue<SocketChannel> newConnections;
    private final long connectionsMaxIdleNanos;
    private long kafka$network$Processor$$currentTimeNanos;
    private final LinkedHashMap<SelectionKey, Object> lruConnections;
    private long nextIdleCloseCheckTime;

    public int id() {
        return this.id;
    }

    public Time time() {
        return this.time;
    }

    public int maxRequestSize() {
        return this.maxRequestSize;
    }

    public Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    public Meter idleMeter() {
        return this.idleMeter;
    }

    public int totalProcessorThreads() {
        return this.totalProcessorThreads;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public long connectionsMaxIdleMs() {
        return this.connectionsMaxIdleMs;
    }

    private ConcurrentLinkedQueue<SocketChannel> newConnections() {
        return this.newConnections;
    }

    private long connectionsMaxIdleNanos() {
        return this.connectionsMaxIdleNanos;
    }

    public final long kafka$network$Processor$$currentTimeNanos() {
        return this.kafka$network$Processor$$currentTimeNanos;
    }

    private void kafka$network$Processor$$currentTimeNanos_$eq(long l) {
        this.kafka$network$Processor$$currentTimeNanos = l;
    }

    private LinkedHashMap<SelectionKey, Object> lruConnections() {
        return this.lruConnections;
    }

    private long nextIdleCloseCheckTime() {
        return this.nextIdleCloseCheckTime;
    }

    private void nextIdleCloseCheckTime_$eq(long l) {
        this.nextIdleCloseCheckTime = l;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [0, 2, 1 : 66->185)] java.io.EOFException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void close(SelectionKey key) {
        this.lruConnections().remove(key);
        super.close(key);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processNewResponses() {
        RequestChannel.ResponseAction responseAction;
        ObjectRef curr$1 = new ObjectRef((Object)this.requestChannel().receiveResponse(this.id()));
        while (true) {
            Object object;
            if ((RequestChannel.Response)curr$1.elem == null) {
                return;
            }
            SelectionKey key = (SelectionKey)((RequestChannel.Response)curr$1.elem).request().requestKey();
            Object exceptionResult1 = null;
            responseAction = ((RequestChannel.Response)curr$1.elem).responseAction();
            RequestChannel$NoOpAction$ requestChannel$NoOpAction$ = RequestChannel$NoOpAction$.MODULE$;
            RequestChannel.ResponseAction responseAction2 = responseAction;
            if (!(requestChannel$NoOpAction$ != null ? !requestChannel$NoOpAction$.equals(responseAction2) : responseAction2 != null)) {
                ((RequestChannel.Response)curr$1.elem).request().updateRequestMetrics();
                this.trace((Function0<String>)new Serializable(this, curr$1){
                    public static final long serialVersionUID;
                    private final ObjectRef curr$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Socket server received empty response to send, registering for read: ").append((Object)((RequestChannel.Response)this.curr$1.elem)).toString();
                    }
                    {
                        this.curr$1 = objectRef;
                    }
                });
                key.interestOps(1);
                object = key.attach(null);
            } else {
                RequestChannel$SendAction$ requestChannel$SendAction$ = RequestChannel$SendAction$.MODULE$;
                RequestChannel.ResponseAction responseAction3 = responseAction;
                if (!(requestChannel$SendAction$ != null ? !requestChannel$SendAction$.equals(responseAction3) : responseAction3 != null)) {
                    this.trace((Function0<String>)new Serializable(this, curr$1){
                        public static final long serialVersionUID;
                        private final ObjectRef curr$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return new StringBuilder().append((Object)"Socket server received response to send, registering for write: ").append((Object)((RequestChannel.Response)this.curr$1.elem)).toString();
                        }
                        {
                            this.curr$1 = objectRef;
                        }
                    });
                    key.interestOps(4);
                    object = key.attach((RequestChannel.Response)curr$1.elem);
                } else {
                    RequestChannel$CloseConnectionAction$ requestChannel$CloseConnectionAction$ = RequestChannel$CloseConnectionAction$.MODULE$;
                    RequestChannel.ResponseAction responseAction4 = responseAction;
                    if (requestChannel$CloseConnectionAction$ != null ? !requestChannel$CloseConnectionAction$.equals(responseAction4) : responseAction4 != null) break;
                    ((RequestChannel.Response)curr$1.elem).request().updateRequestMetrics();
                    this.trace((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return "Closing socket connection actively according to the response code.";
                        }
                    });
                    this.close(key);
                    object = BoxedUnit.UNIT;
                }
            }
            exceptionResult1 = object;
            curr$1.elem = this.requestChannel().receiveResponse(this.id());
            continue;
            break;
        }
        try {
            throw new KafkaException(new StringBuilder().append((Object)"No mapping found for response code ").append((Object)responseAction).toString());
        }
        catch (Throwable throwable) {
            curr$1.elem = this.requestChannel().receiveResponse(this.id());
            throw throwable;
        }
    }

    public void accept(SocketChannel socketChannel) {
        this.newConnections().add(socketChannel);
        this.wakeup();
    }

    private void configureNewConnections() {
        while (this.newConnections().size() > 0) {
            SocketChannel channel$2 = this.newConnections().poll();
            this.debug((Function0<String>)new Serializable(this, channel$2){
                public static final long serialVersionUID;
                private final Processor $outer;
                private final SocketChannel channel$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Processor ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.id())).append((Object)" listening to new connection from ").append((Object)this.channel$2.socket().getRemoteSocketAddress()).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.channel$2 = socketChannel;
                }
            });
            channel$2.register(this.selector(), 1);
        }
    }

    public void read(SelectionKey key) {
        Object object;
        this.lruConnections().put(key, BoxesRunTime.boxToLong((long)this.kafka$network$Processor$$currentTimeNanos()));
        SocketChannel socketChannel$2 = this.kafka$network$Processor$$channelFor(key);
        Receive receive = (Receive)key.attachment();
        if (key.attachment() == null) {
            receive = new BoundedByteBufferReceive(this.maxRequestSize());
            object = key.attach(receive);
        } else {
            object = BoxedUnit.UNIT;
        }
        int read$1 = receive.readFrom(socketChannel$2);
        SocketAddress address$1 = socketChannel$2.socket().getRemoteSocketAddress();
        this.trace((Function0<String>)new Serializable(this, read$1, address$1){
            public static final long serialVersionUID;
            private final int read$1;
            private final SocketAddress address$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append(this.read$1).append((Object)" bytes read from ").append((Object)this.address$1).toString();
            }
            {
                this.read$1 = n;
                this.address$1 = socketAddress;
            }
        });
        if (read$1 < 0) {
            this.close(key);
        } else if (receive.complete()) {
            RequestChannel.Request req = new RequestChannel.Request(this.id(), key, receive.buffer(), this.time().milliseconds(), address$1);
            this.requestChannel().sendRequest(req);
            key.attach(null);
            key.interestOps(key.interestOps() & ~1);
        } else {
            this.trace((Function0<String>)new Serializable(this, socketChannel$2){
                public static final long serialVersionUID;
                private final SocketChannel socketChannel$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Did not finish reading, registering for read again on connection ").append((Object)this.socketChannel$2.socket().getRemoteSocketAddress()).toString();
                }
                {
                    this.socketChannel$2 = socketChannel;
                }
            });
            key.interestOps(1);
            this.wakeup();
        }
    }

    public void write(SelectionKey key$3) {
        SocketChannel socketChannel$3 = this.kafka$network$Processor$$channelFor(key$3);
        RequestChannel.Response response = (RequestChannel.Response)key$3.attachment();
        Send responseSend = response.responseSend();
        if (responseSend == null) {
            throw new IllegalStateException("Registered for write interest but no response attached to key.");
        }
        int written$1 = responseSend.writeTo(socketChannel$3);
        this.trace((Function0<String>)new Serializable(this, key$3, socketChannel$3, written$1){
            public static final long serialVersionUID;
            private final SelectionKey key$3;
            private final SocketChannel socketChannel$3;
            private final int written$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append(this.written$1).append((Object)" bytes written to ").append((Object)this.socketChannel$3.socket().getRemoteSocketAddress()).append((Object)" using key ").append((Object)this.key$3).toString();
            }
            {
                this.key$3 = selectionKey;
                this.socketChannel$3 = socketChannel;
                this.written$1 = n;
            }
        });
        if (responseSend.complete()) {
            response.request().updateRequestMetrics();
            key$3.attach(null);
            this.trace((Function0<String>)new Serializable(this, socketChannel$3){
                public static final long serialVersionUID;
                private final SocketChannel socketChannel$3;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Finished writing, registering for read on connection ").append((Object)this.socketChannel$3.socket().getRemoteSocketAddress()).toString();
                }
                {
                    this.socketChannel$3 = socketChannel;
                }
            });
            key$3.interestOps(1);
        } else {
            this.trace((Function0<String>)new Serializable(this, socketChannel$3){
                public static final long serialVersionUID;
                private final SocketChannel socketChannel$3;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Did not finish writing, registering for write again on connection ").append((Object)this.socketChannel$3.socket().getRemoteSocketAddress()).toString();
                }
                {
                    this.socketChannel$3 = socketChannel;
                }
            });
            key$3.interestOps(4);
            this.wakeup();
        }
    }

    public final SocketChannel kafka$network$Processor$$channelFor(SelectionKey key) {
        return (SocketChannel)key.channel();
    }

    private void maybeCloseOldestConnection() {
        if (this.kafka$network$Processor$$currentTimeNanos() > this.nextIdleCloseCheckTime()) {
            if (this.lruConnections().isEmpty()) {
                this.nextIdleCloseCheckTime_$eq(this.kafka$network$Processor$$currentTimeNanos() + this.connectionsMaxIdleNanos());
            } else {
                Map.Entry<SelectionKey, Object> oldestConnectionEntry = this.lruConnections().entrySet().iterator().next();
                long connectionLastActiveTime$1 = BoxesRunTime.unboxToLong((Object)oldestConnectionEntry.getValue());
                this.nextIdleCloseCheckTime_$eq(connectionLastActiveTime$1 + this.connectionsMaxIdleNanos());
                if (this.kafka$network$Processor$$currentTimeNanos() > this.nextIdleCloseCheckTime()) {
                    SelectionKey key$4 = oldestConnectionEntry.getKey();
                    this.trace((Function0<String>)new Serializable(this, connectionLastActiveTime$1, key$4){
                        public static final long serialVersionUID;
                        private final Processor $outer;
                        private final long connectionLastActiveTime$1;
                        private final SelectionKey key$4;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return new StringBuilder().append((Object)"About to close the idle connection from ").append((Object)((SocketChannel)this.key$4.channel()).socket().getRemoteSocketAddress()).append((Object)" due to being idle for ").append((Object)BoxesRunTime.boxToLong((long)((this.$outer.kafka$network$Processor$$currentTimeNanos() - this.connectionLastActiveTime$1) / 1000L / 1000L))).append((Object)" millis").toString();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.connectionLastActiveTime$1 = l;
                            this.key$4 = selectionKey;
                        }
                    });
                    this.close(key$4);
                }
            }
        }
    }

    public Processor(int id, Time time, int maxRequestSize, Meter aggregateIdleMeter, Meter idleMeter, int totalProcessorThreads, RequestChannel requestChannel, ConnectionQuotas connectionQuotas, long connectionsMaxIdleMs) {
        this.id = id;
        this.time = time;
        this.maxRequestSize = maxRequestSize;
        this.aggregateIdleMeter = aggregateIdleMeter;
        this.idleMeter = idleMeter;
        this.totalProcessorThreads = totalProcessorThreads;
        this.requestChannel = requestChannel;
        this.connectionsMaxIdleMs = connectionsMaxIdleMs;
        super(connectionQuotas);
        this.newConnections = new ConcurrentLinkedQueue();
        this.connectionsMaxIdleNanos = connectionsMaxIdleMs * 1000L * 1000L;
        this.kafka$network$Processor$$currentTimeNanos = SystemTime$.MODULE$.nanoseconds();
        this.lruConnections = new LinkedHashMap();
        this.nextIdleCloseCheckTime = this.kafka$network$Processor$$currentTimeNanos() + this.connectionsMaxIdleNanos();
    }
}

