/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.net.InetSocketAddress;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import kafka.api.RequestOrResponse;
import kafka.network.BlockingChannel$;
import kafka.network.BoundedByteBufferReceive;
import kafka.network.BoundedByteBufferSend;
import kafka.network.Receive;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005}s!B\u0001\u0003\u0011\u000b9\u0011a\u0004\"m_\u000e\\\u0017N\\4DQ\u0006tg.\u001a7\u000b\u0005\r!\u0011a\u00028fi^|'o\u001b\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u0001\u0001C\u0001\u0005\n\u001b\u0005\u0011a!\u0002\u0006\u0003\u0011\u000bY!a\u0004\"m_\u000e\\\u0017N\\4DQ\u0006tg.\u001a7\u0014\u0007%aA\u0003\u0005\u0002\u000e%5\taB\u0003\u0002\u0010!\u0005!A.\u00198h\u0015\u0005\t\u0012\u0001\u00026bm\u0006L!a\u0005\b\u0003\r=\u0013'.Z2u!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u000bmIA\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u00059\u0001b\u0002\u0010\n\u0005\u0004%\taH\u0001\u0015+N,G)\u001a4bk2$()\u001e4gKJ\u001c\u0016N_3\u0016\u0003\u0001\u0002\"!F\u0011\n\u0005\t2\"aA%oi\"1A%\u0003Q\u0001\n\u0001\nQ#V:f\t\u00164\u0017-\u001e7u\u0005V4g-\u001a:TSj,\u0007E\u0002\u0003\u000b\u0005\u000113\u0003B\u0013\rOQ\u0001\"\u0001K\u0016\u000e\u0003%R!A\u000b\u0003\u0002\u000bU$\u0018\u000e\\:\n\u00051J#a\u0002'pO\u001eLgn\u001a\u0005\t]\u0015\u0012)\u0019!C\u0001_\u0005!\u0001n\\:u+\u0005\u0001\u0004CA\u00195\u001d\t)\"'\u0003\u00024-\u00051\u0001K]3eK\u001aL!!\u000e\u001c\u0003\rM#(/\u001b8h\u0015\t\u0019d\u0003\u0003\u00059K\t\u0005\t\u0015!\u00031\u0003\u0015Awn\u001d;!\u0011!QTE!b\u0001\n\u0003y\u0012\u0001\u00029peRD\u0001\u0002P\u0013\u0003\u0002\u0003\u0006I\u0001I\u0001\u0006a>\u0014H\u000f\t\u0005\t}\u0015\u0012)\u0019!C\u0001?\u0005q!/Z1e\u0005V4g-\u001a:TSj,\u0007\u0002\u0003!&\u0005\u0003\u0005\u000b\u0011\u0002\u0011\u0002\u001fI,\u0017\r\u001a\"vM\u001a,'oU5{K\u0002B\u0001BQ\u0013\u0003\u0006\u0004%\taH\u0001\u0010oJLG/\u001a\"vM\u001a,'oU5{K\"AA)\nB\u0001B\u0003%\u0001%\u0001\txe&$XMQ;gM\u0016\u00148+\u001b>fA!Aa)\nBC\u0002\u0013\u0005q$A\u0007sK\u0006$G+[7f_V$Xj\u001d\u0005\t\u0011\u0016\u0012\t\u0011)A\u0005A\u0005q!/Z1e)&lWm\\;u\u001bN\u0004\u0003\"B\u000e&\t\u0003QECB&M\u001b:{\u0005\u000b\u0005\u0002\tK!)a&\u0013a\u0001a!)!(\u0013a\u0001A!)a(\u0013a\u0001A!)!)\u0013a\u0001A!)a)\u0013a\u0001A!9!+\na\u0001\n\u0013\u0019\u0016!C2p]:,7\r^3e+\u0005!\u0006CA\u000bV\u0013\t1fCA\u0004C_>dW-\u00198\t\u000fa+\u0003\u0019!C\u00053\u0006i1m\u001c8oK\u000e$X\rZ0%KF$\"AW/\u0011\u0005UY\u0016B\u0001/\u0017\u0005\u0011)f.\u001b;\t\u000fy;\u0016\u0011!a\u0001)\u0006\u0019\u0001\u0010J\u0019\t\r\u0001,\u0003\u0015)\u0003U\u0003)\u0019wN\u001c8fGR,G\r\t\u0005\bE\u0016\u0002\r\u0011\"\u0003d\u0003\u001d\u0019\u0007.\u00198oK2,\u0012\u0001\u001a\t\u0003K*l\u0011A\u001a\u0006\u0003O\"\f\u0001b\u00195b]:,Gn\u001d\u0006\u0003SB\t1A\\5p\u0013\tYgMA\u0007T_\u000e\\W\r^\"iC:tW\r\u001c\u0005\b[\u0016\u0002\r\u0011\"\u0003o\u0003-\u0019\u0007.\u00198oK2|F%Z9\u0015\u0005i{\u0007b\u00020m\u0003\u0003\u0005\r\u0001\u001a\u0005\u0007c\u0016\u0002\u000b\u0015\u00023\u0002\u0011\rD\u0017M\u001c8fY\u0002Bqa]\u0013A\u0002\u0013%A/A\u0006sK\u0006$7\t[1o]\u0016dW#A;\u0011\u0005\u00154\u0018BA<g\u0005M\u0011V-\u00193bE2,')\u001f;f\u0007\"\fgN\\3m\u0011\u001dIX\u00051A\u0005\ni\fqB]3bI\u000eC\u0017M\u001c8fY~#S-\u001d\u000b\u00035nDqA\u0018=\u0002\u0002\u0003\u0007Q\u000f\u0003\u0004~K\u0001\u0006K!^\u0001\re\u0016\fGm\u00115b]:,G\u000e\t\u0005\t\u007f\u0016\u0002\r\u0011\"\u0003\u0002\u0002\u0005aqO]5uK\u000eC\u0017M\u001c8fYV\u0011\u00111\u0001\t\u0004K\u0006\u0015\u0011bAA\u0004M\n!r)\u0019;iKJLgn\u001a\"zi\u0016\u001c\u0005.\u00198oK2D\u0011\"a\u0003&\u0001\u0004%I!!\u0004\u0002!]\u0014\u0018\u000e^3DQ\u0006tg.\u001a7`I\u0015\fHc\u0001.\u0002\u0010!Ia,!\u0003\u0002\u0002\u0003\u0007\u00111\u0001\u0005\t\u0003')\u0003\u0015)\u0003\u0002\u0004\u0005iqO]5uK\u000eC\u0017M\u001c8fY\u0002B\u0011\"a\u0006&\u0005\u0004%I!!\u0007\u0002\t1|7m[\u000b\u0002\u0019!9\u0011QD\u0013!\u0002\u0013a\u0011!\u00027pG.\u0004\u0003\u0002CA\u0011K\t\u0007I\u0011B\u0010\u0002!\r|gN\\3diRKW.Z8vi6\u001b\bbBA\u0013K\u0001\u0006I\u0001I\u0001\u0012G>tg.Z2u)&lWm\\;u\u001bN\u0004\u0003bBA\u0015K\u0011\u0005\u00111F\u0001\bG>tg.Z2u)\u0005Q\u0006bBA\u0018K\u0011\u0005\u00111F\u0001\u000bI&\u001c8m\u001c8oK\u000e$\bBBA\u001aK\u0011\u00051+A\u0006jg\u000e{gN\\3di\u0016$\u0007bBA\u001cK\u0011\u0005\u0011\u0011H\u0001\u0005g\u0016tG\rF\u0002!\u0003wA\u0001\"!\u0010\u00026\u0001\u0007\u0011qH\u0001\be\u0016\fX/Z:u!\u0011\t\t%a\u0012\u000e\u0005\u0005\r#bAA#\t\u0005\u0019\u0011\r]5\n\t\u0005%\u00131\t\u0002\u0012%\u0016\fX/Z:u\u001fJ\u0014Vm\u001d9p]N,\u0007bBA'K\u0011\u0005\u0011qJ\u0001\be\u0016\u001cW-\u001b<f)\t\t\t\u0006E\u0002\t\u0003'J1!!\u0016\u0003\u0005\u001d\u0011VmY3jm\u0016D3!JA-!\rA\u00131L\u0005\u0004\u0003;J#!\u00048p]RD'/Z1eg\u00064W\r")
public class BlockingChannel
implements Logging,
ScalaObject {
    private final String host;
    private final int port;
    private final int readBufferSize;
    private final int writeBufferSize;
    private final int readTimeoutMs;
    private boolean connected;
    private SocketChannel kafka$network$BlockingChannel$$channel;
    private ReadableByteChannel kafka$network$BlockingChannel$$readChannel;
    private GatheringByteChannel writeChannel;
    private final Object lock;
    private final int kafka$network$BlockingChannel$$connectTimeoutMs;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final int UseDefaultBufferSize() {
        return BlockingChannel$.MODULE$.UseDefaultBufferSize();
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public int readBufferSize() {
        return this.readBufferSize;
    }

    public int writeBufferSize() {
        return this.writeBufferSize;
    }

    public int readTimeoutMs() {
        return this.readTimeoutMs;
    }

    private boolean connected() {
        return this.connected;
    }

    private void connected_$eq(boolean bl) {
        this.connected = bl;
    }

    public final SocketChannel kafka$network$BlockingChannel$$channel() {
        return this.kafka$network$BlockingChannel$$channel;
    }

    private void kafka$network$BlockingChannel$$channel_$eq(SocketChannel socketChannel) {
        this.kafka$network$BlockingChannel$$channel = socketChannel;
    }

    public final ReadableByteChannel kafka$network$BlockingChannel$$readChannel() {
        return this.kafka$network$BlockingChannel$$readChannel;
    }

    private void kafka$network$BlockingChannel$$readChannel_$eq(ReadableByteChannel readableByteChannel) {
        this.kafka$network$BlockingChannel$$readChannel = readableByteChannel;
    }

    private GatheringByteChannel writeChannel() {
        return this.writeChannel;
    }

    private void writeChannel_$eq(GatheringByteChannel gatheringByteChannel) {
        this.writeChannel = gatheringByteChannel;
    }

    private Object lock() {
        return this.lock;
    }

    public final int kafka$network$BlockingChannel$$connectTimeoutMs() {
        return this.kafka$network$BlockingChannel$$connectTimeoutMs;
    }

    public void connect() {
        Object object = this.lock();
        synchronized (object) {
            BoxedUnit boxedUnit;
            if (this.connected()) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.liftedTree1$1();
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void disconnect() {
        Object object = this.lock();
        synchronized (object) {
            if (this.kafka$network$BlockingChannel$$channel() != null) {
                this.swallow((Function0<BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID;
                    private final BlockingChannel $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.kafka$network$BlockingChannel$$channel().close();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.swallow((Function0<BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID;
                    private final BlockingChannel $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.kafka$network$BlockingChannel$$channel().socket().close();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.kafka$network$BlockingChannel$$channel_$eq(null);
                this.writeChannel_$eq(null);
            }
            if (this.kafka$network$BlockingChannel$$readChannel() != null) {
                this.swallow((Function0<BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID;
                    private final BlockingChannel $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.kafka$network$BlockingChannel$$readChannel().close();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.kafka$network$BlockingChannel$$readChannel_$eq(null);
            }
            this.connected_$eq(false);
            return;
        }
    }

    public boolean isConnected() {
        return this.connected();
    }

    public int send(RequestOrResponse request) {
        if (this.connected()) {
            BoundedByteBufferSend send2 = new BoundedByteBufferSend(request);
            return send2.writeCompletely(this.writeChannel());
        }
        throw new ClosedChannelException();
    }

    /*
     * WARNING - void declaration
     */
    public Receive receive() {
        if (this.connected()) {
            void var1_1;
            BoundedByteBufferReceive response = new BoundedByteBufferReceive();
            response.readCompletely(this.kafka$network$BlockingChannel$$readChannel());
            return var1_1;
        }
        throw new ClosedChannelException();
    }

    private final void liftedTree1$1() {
        try {
            this.kafka$network$BlockingChannel$$channel_$eq(SocketChannel.open());
            if (this.readBufferSize() > 0) {
                this.kafka$network$BlockingChannel$$channel().socket().setReceiveBufferSize(this.readBufferSize());
            }
            if (this.writeBufferSize() > 0) {
                this.kafka$network$BlockingChannel$$channel().socket().setSendBufferSize(this.writeBufferSize());
            }
            this.kafka$network$BlockingChannel$$channel().configureBlocking(true);
            this.kafka$network$BlockingChannel$$channel().socket().setSoTimeout(this.readTimeoutMs());
            this.kafka$network$BlockingChannel$$channel().socket().setKeepAlive(true);
            this.kafka$network$BlockingChannel$$channel().socket().setTcpNoDelay(true);
            this.kafka$network$BlockingChannel$$channel().socket().connect(new InetSocketAddress(this.host(), this.port()), this.kafka$network$BlockingChannel$$connectTimeoutMs());
            this.writeChannel_$eq(this.kafka$network$BlockingChannel$$channel());
            this.kafka$network$BlockingChannel$$readChannel_$eq(Channels.newChannel(this.kafka$network$BlockingChannel$$channel().socket().getInputStream()));
            this.connected_$eq(true);
            String msg$1 = "Created socket with SO_TIMEOUT = %d (requested %d), SO_RCVBUF = %d (requested %d), SO_SNDBUF = %d (requested %d), connectTimeoutMs = %d.";
            this.debug((Function0<String>)new Serializable(this, msg$1){
                public static final long serialVersionUID;
                private final BlockingChannel $outer;
                private final String msg$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString(this.msg$1).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$network$BlockingChannel$$channel().socket().getSoTimeout()), BoxesRunTime.boxToInteger((int)this.$outer.readTimeoutMs()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$network$BlockingChannel$$channel().socket().getReceiveBufferSize()), BoxesRunTime.boxToInteger((int)this.$outer.readBufferSize()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$network$BlockingChannel$$channel().socket().getSendBufferSize()), BoxesRunTime.boxToInteger((int)this.$outer.writeBufferSize()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$network$BlockingChannel$$connectTimeoutMs())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.msg$1 = string;
                }
            });
        }
        catch (Throwable throwable) {
            this.disconnect();
        }
    }

    public BlockingChannel(String host, int port, int readBufferSize, int writeBufferSize, int readTimeoutMs) {
        this.host = host;
        this.port = port;
        this.readBufferSize = readBufferSize;
        this.writeBufferSize = writeBufferSize;
        this.readTimeoutMs = readTimeoutMs;
        Logging$class.$init$(this);
        this.connected = false;
        this.kafka$network$BlockingChannel$$channel = null;
        this.kafka$network$BlockingChannel$$readChannel = null;
        this.writeChannel = null;
        this.lock = new Object();
        this.kafka$network$BlockingChannel$$connectTimeoutMs = readTimeoutMs;
    }
}

