/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.common.KafkaException;
import kafka.common.TopicAndPartition;
import kafka.log.CleanerConfig;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleaner;
import kafka.log.LogConfig;
import kafka.log.LogManager$;
import kafka.log.LogManager$$anonfun$loadLogs$2$;
import kafka.log.LogManager$$anonfun$loadLogs$2$$anonfun$3$;
import kafka.log.LogManager$$anonfun$loadLogs$2$$anonfun$3$$anonfun$apply$7$;
import kafka.log.LogSegment;
import kafka.server.BrokerState;
import kafka.server.OffsetCheckpoint;
import kafka.server.RecoveringFromUncleanShutdown$;
import kafka.utils.FileLock;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.Time;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$Int$;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.reflect.OptManifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\tMc\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h\u001b\u0006t\u0017mZ3s\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001\u0002\u0005\f\u0011\u0005%qQ\"\u0001\u0006\u000b\u0005-a\u0011\u0001\u00027b]\u001eT\u0011!D\u0001\u0005U\u00064\u0018-\u0003\u0002\u0010\u0015\t1qJ\u00196fGR\u0004\"!\u0005\u000b\u000e\u0003IQ!a\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005U\u0011\"a\u0002'pO\u001eLgn\u001a\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0003\u0005\u001e\u0001\t\u0015\r\u0011\"\u0001\u001f\u0003\u001dawn\u001a#jeN,\u0012a\b\t\u0004/\u0001\u0012\u0013BA\u0011\u0019\u0005\u0015\t%O]1z!\t\u0019c%D\u0001%\u0015\t)C\"\u0001\u0002j_&\u0011q\u0005\n\u0002\u0005\r&dW\r\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003 \u0003!awn\u001a#jeN\u0004\u0003\u0002C\u0016\u0001\u0005\u000b\u0007I\u0011\u0001\u0017\u0002\u0019Q|\u0007/[2D_:4\u0017nZ:\u0016\u00035\u0002BAL\u00194u5\tqF\u0003\u000211\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Iz#aA'baB\u0011Ag\u000e\b\u0003/UJ!A\u000e\r\u0002\rA\u0013X\rZ3g\u0013\tA\u0014H\u0001\u0004TiJLgn\u001a\u0006\u0003ma\u0001\"a\u000f\u001f\u000e\u0003\tI!!\u0010\u0002\u0003\u00131{wmQ8oM&<\u0007\u0002C \u0001\u0005\u0003\u0005\u000b\u0011B\u0017\u0002\u001bQ|\u0007/[2D_:4\u0017nZ:!\u0011!\t\u0005A!b\u0001\n\u0003\u0011\u0015!\u00043fM\u0006,H\u000e^\"p]\u001aLw-F\u0001;\u0011!!\u0005A!A!\u0002\u0013Q\u0014A\u00043fM\u0006,H\u000e^\"p]\u001aLw\r\t\u0005\t\r\u0002\u0011)\u0019!C\u0001\u000f\u0006i1\r\\3b]\u0016\u00148i\u001c8gS\u001e,\u0012\u0001\u0013\t\u0003w%K!A\u0013\u0002\u0003\u001b\rcW-\u00198fe\u000e{gNZ5h\u0011!a\u0005A!A!\u0002\u0013A\u0015AD2mK\u0006tWM]\"p]\u001aLw\r\t\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u001f\u0006I\u0011n\u001c+ie\u0016\fGm\u001d\t\u0003/AK!!\u0015\r\u0003\u0007%sG\u000f\u0003\u0005T\u0001\t\u0015\r\u0011\"\u0001U\u000311G.^:i\u0007\",7m['t+\u0005)\u0006CA\fW\u0013\t9\u0006D\u0001\u0003M_:<\u0007\u0002C-\u0001\u0005\u0003\u0005\u000b\u0011B+\u0002\u001b\u0019dWo\u001d5DQ\u0016\u001c7.T:!\u0011!Y\u0006A!b\u0001\n\u0003!\u0016!\u00054mkND7\t[3dWB|\u0017N\u001c;Ng\"AQ\f\u0001B\u0001B\u0003%Q+\u0001\ngYV\u001c\bn\u00115fG.\u0004x.\u001b8u\u001bN\u0004\u0003\u0002C0\u0001\u0005\u000b\u0007I\u0011\u0001+\u0002!I,G/\u001a8uS>t7\t[3dW6\u001b\b\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011B+\u0002#I,G/\u001a8uS>t7\t[3dW6\u001b\b\u0005\u0003\u0005d\u0001\t\u0005\t\u0015!\u0003e\u0003%\u00198\r[3ek2,'\u000f\u0005\u0002\u0012K&\u0011aM\u0005\u0002\n'\u000eDW\rZ;mKJD\u0001\u0002\u001b\u0001\u0003\u0006\u0004%\t![\u0001\fEJ|7.\u001a:Ti\u0006$X-F\u0001k!\tYg.D\u0001m\u0015\tiG!\u0001\u0004tKJ4XM]\u0005\u0003_2\u00141B\u0011:pW\u0016\u00148\u000b^1uK\"A\u0011\u000f\u0001B\u0001B\u0003%!.\u0001\u0007ce>\\WM]*uCR,\u0007\u0005\u0003\u0005t\u0001\t\u0015\r\u0011\"\u0003u\u0003\u0011!\u0018.\\3\u0016\u0003U\u0004\"!\u0005<\n\u0005]\u0014\"\u0001\u0002+j[\u0016D\u0001\"\u001f\u0001\u0003\u0002\u0003\u0006I!^\u0001\u0006i&lW\r\t\u0005\u0006w\u0002!\t\u0001`\u0001\u0007y%t\u0017\u000e\u001e \u0015+utx0!\u0001\u0002\u0004\u0005\u0015\u0011qAA\u0005\u0003\u0017\ti!a\u0004\u0002\u0012A\u00111\b\u0001\u0005\u0006;i\u0004\ra\b\u0005\u0006Wi\u0004\r!\f\u0005\u0006\u0003j\u0004\rA\u000f\u0005\u0006\rj\u0004\r\u0001\u0013\u0005\u0006\u001dj\u0004\ra\u0014\u0005\u0006'j\u0004\r!\u0016\u0005\u00067j\u0004\r!\u0016\u0005\u0006?j\u0004\r!\u0016\u0005\u0006Gj\u0004\r\u0001\u001a\u0005\u0006Qj\u0004\rA\u001b\u0005\u0006gj\u0004\r!\u001e\u0005\n\u0003+\u0001!\u0019!C\u0001\u0003/\t1DU3d_Z,'/\u001f)pS:$8\t[3dWB|\u0017N\u001c;GS2,WCAA\r!\rI\u00111D\u0005\u0003q)A\u0001\"a\b\u0001A\u0003%\u0011\u0011D\u0001\u001d%\u0016\u001cwN^3ssB{\u0017N\u001c;DQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3!\u0011%\t\u0019\u0003\u0001b\u0001\n\u0003\t9\"\u0001\u0005M_\u000e\\g)\u001b7f\u0011!\t9\u0003\u0001Q\u0001\n\u0005e\u0011!\u0003'pG.4\u0015\u000e\\3!\u0011%\tY\u0003\u0001b\u0001\n\u0003\ti#\u0001\nJ]&$\u0018.\u00197UCN\\G)\u001a7bs6\u001bX#A(\t\u000f\u0005E\u0002\u0001)A\u0005\u001f\u0006\u0019\u0012J\\5uS\u0006dG+Y:l\t\u0016d\u0017-_'tA!I\u0011Q\u0007\u0001C\u0002\u0013%\u0011qG\u0001\u001aY><7I]3bi&|gn\u0014:EK2,G/[8o\u0019>\u001c7.F\u0001\t\u0011\u001d\tY\u0004\u0001Q\u0001\n!\t!\u0004\\8h\u0007J,\u0017\r^5p]>\u0013H)\u001a7fi&|g\u000eT8dW\u0002B\u0011\"a\u0010\u0001\u0005\u0004%I!!\u0011\u0002\t1|wm]\u000b\u0003\u0003\u0007\u0002r!EA#\u0003\u0013\n)&C\u0002\u0002HI\u0011A\u0001U8pYB!\u00111JA)\u001b\t\tiEC\u0002\u0002P\u0011\taaY8n[>t\u0017\u0002BA*\u0003\u001b\u0012\u0011\u0003V8qS\u000e\fe\u000e\u001a)beRLG/[8o!\rY\u0014qK\u0005\u0004\u00033\u0012!a\u0001'pO\"A\u0011Q\f\u0001!\u0002\u0013\t\u0019%A\u0003m_\u001e\u001c\b\u0005C\u0005\u0002b\u0001\u0011\r\u0011\"\u0003\u0002d\u0005AA-\u001b:M_\u000e\\7/\u0006\u0002\u0002fA)a&a\u001a\u0002l%\u0019\u0011\u0011N\u0018\u0003\u0007M+\u0017\u000fE\u0002\u0012\u0003[J1!a\u001c\u0013\u0005!1\u0015\u000e\\3M_\u000e\\\u0007\u0002CA:\u0001\u0001\u0006I!!\u001a\u0002\u0013\u0011L'\u000fT8dWN\u0004\u0003\"CA<\u0001\t\u0007I\u0011BA=\u0003a\u0011XmY8wKJL\bk\\5oi\u000eCWmY6q_&tGo]\u000b\u0003\u0003w\u0002r!! \u0002\u0004\n\n))\u0004\u0002\u0002\u0000)\u0019\u0011\u0011Q\u0018\u0002\u0013%lW.\u001e;bE2,\u0017b\u0001\u001a\u0002\u0000A\u00191.a\"\n\u0007\u0005%EN\u0001\tPM\u001a\u001cX\r^\"iK\u000e\\\u0007o\\5oi\"A\u0011Q\u0012\u0001!\u0002\u0013\tY(A\rsK\u000e|g/\u001a:z!>Lg\u000e^\"iK\u000e\\\u0007o\\5oiN\u0004\u0003\"CAI\u0001\t\u0007I\u0011AAJ\u0003\u001d\u0019G.Z1oKJ,\"!!&\u0011\u0007m\n9*C\u0002\u0002\u001a\n\u0011!\u0002T8h\u00072,\u0017M\\3s\u0011!\ti\n\u0001Q\u0001\n\u0005U\u0015\u0001C2mK\u0006tWM\u001d\u0011\t\u000f\u0005\u0005\u0006\u0001\"\u0003\u0002$\u0006A2M]3bi\u0016\fe\u000e\u001a,bY&$\u0017\r^3M_\u001e$\u0015N]:\u0015\t\u0005\u0015\u00161\u0016\t\u0004/\u0005\u001d\u0016bAAU1\t!QK\\5u\u0011!\ti+a(A\u0002\u0005=\u0016\u0001\u00023jeN\u0004BALA4E!9\u00111\u0017\u0001\u0005\n\u0005U\u0016a\u00037pG.dun\u001a#jeN$B!!\u001a\u00028\"A\u0011QVAY\u0001\u0004\ty\u000bC\u0004\u0002<\u0002!I!!0\u0002\u00111|\u0017\r\u001a'pON$\"!!*\t\u000f\u0005\u0005\u0007\u0001\"\u0001\u0002>\u000691\u000f^1siV\u0004\bbBAc\u0001\u0011\u0005\u0011QX\u0001\tg\",H\u000fZ8x]\"9\u0011\u0011\u001a\u0001\u0005\u0002\u0005-\u0017A\u0003;sk:\u001c\u0017\r^3U_R!\u0011QUAg\u0011!\ty-a2A\u0002\u0005E\u0017a\u00059beRLG/[8o\u0003:$wJ\u001a4tKR\u001c\b#\u0002\u00182\u0003\u0013*\u0006bBAk\u0001\u0011\u0005\u0011q[\u0001\u0018iJ,hnY1uK\u001a+H\u000e\\=B]\u0012\u001cF/\u0019:u\u0003R$b!!*\u0002Z\u0006u\u0007\u0002CAn\u0003'\u0004\r!!\u0013\u0002#Q|\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002`\u0006M\u0007\u0019A+\u0002\u00139,wo\u00144gg\u0016$\bbBAr\u0001\u0011\u0005\u0011QX\u0001\u001fG\",7m\u001b9pS:$(+Z2pm\u0016\u0014\u0018\u0010U8j]R|eMZ:fiNDq!a:\u0001\t\u0013\tI/A\ndQ\u0016\u001c7\u000e]8j]RdunZ:J]\u0012K'\u000f\u0006\u0003\u0002&\u0006-\bbBAw\u0003K\u0004\rAI\u0001\u0004I&\u0014\bbBAy\u0001\u0011\u0005\u00111_\u0001\u0007O\u0016$Hj\\4\u0015\t\u0005U\u00181 \t\u0006/\u0005]\u0018QK\u0005\u0004\u0003sD\"AB(qi&|g\u000e\u0003\u0005\u0002\\\u0006=\b\u0019AA%\u0011\u001d\ty\u0010\u0001C\u0001\u0005\u0003\t\u0011b\u0019:fCR,Gj\\4\u0015\r\u0005U#1\u0001B\u0003\u0011!\tY.!@A\u0002\u0005%\u0003b\u0002B\u0004\u0003{\u0004\rAO\u0001\u0007G>tg-[4\t\u000f\t-\u0001\u0001\"\u0001\u0003\u000e\u0005IA-\u001a7fi\u0016dun\u001a\u000b\u0005\u0003K\u0013y\u0001\u0003\u0005\u0002\\\n%\u0001\u0019AA%\u0011\u001d\u0011\u0019\u0002\u0001C\u0005\u0005+\t!B\\3yi2{w\rR5s)\u0005\u0011\u0003b\u0002B\r\u0001\u0011%!1D\u0001\u0017G2,\u0017M\\;q\u000bb\u0004\u0018N]3e'\u0016<W.\u001a8ugR\u0019qJ!\b\t\u000f\r\u00119\u00021\u0001\u0002V!9!\u0011\u0005\u0001\u0005\n\t\r\u0012!H2mK\u0006tW\u000f]*fO6,g\u000e^:U_6\u000b\u0017N\u001c;bS:\u001c\u0016N_3\u0015\u0007=\u0013)\u0003C\u0004\u0004\u0005?\u0001\r!!\u0016\t\u000f\t%\u0002\u0001\"\u0001\u0002>\u0006Y1\r\\3b]V\u0004Hj\\4t\u0011\u001d\u0011i\u0003\u0001C\u0001\u0005_\tq!\u00197m\u0019><7\u000f\u0006\u0002\u00032A)aFa\r\u0002V%\u0019!QG\u0018\u0003\u0011%#XM]1cY\u0016DqA!\u000f\u0001\t\u0003\u0011Y$\u0001\u000bm_\u001e\u001c()\u001f+pa&\u001c\u0007+\u0019:uSRLwN\\\u000b\u0003\u0005{\u0001\u0002\"! \u0002\u0004\u0006%\u0013Q\u000b\u0005\b\u0005\u0003\u0002A\u0011\u0002B\"\u0003%awnZ:Cs\u0012K'/\u0006\u0002\u0003FAA\u0011QPAB\u00033\u0011i\u0004C\u0004\u0003J\u0001!I!!0\u0002\u001d\u0019dWo\u001d5ESJ$\u0018\u0010T8hg\"\u001a\u0001A!\u0014\u0011\u0007E\u0011y%C\u0002\u0003RI\u0011!\u0002\u001e5sK\u0006$7/\u00194f\u0001")
public class LogManager
implements Logging,
ScalaObject {
    private final File[] logDirs;
    private final Map<String, LogConfig> topicConfigs;
    private final LogConfig defaultConfig;
    private final CleanerConfig cleanerConfig;
    public final int kafka$log$LogManager$$ioThreads;
    private final long flushCheckMs;
    private final long flushCheckpointMs;
    private final long retentionCheckMs;
    public final Scheduler kafka$log$LogManager$$scheduler;
    private final BrokerState brokerState;
    private final Time kafka$log$LogManager$$time;
    private final String RecoveryPointCheckpointFile;
    private final String LockFile;
    private final int InitialTaskDelayMs;
    private final Object logCreationOrDeletionLock;
    private final Pool<TopicAndPartition, Log> kafka$log$LogManager$$logs;
    private final Seq<FileLock> dirLocks;
    private final scala.collection.immutable.Map<File, OffsetCheckpoint> kafka$log$LogManager$$recoveryPointCheckpoints;
    private final LogCleaner cleaner;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public File[] logDirs() {
        return this.logDirs;
    }

    public Map<String, LogConfig> topicConfigs() {
        return this.topicConfigs;
    }

    public LogConfig defaultConfig() {
        return this.defaultConfig;
    }

    public CleanerConfig cleanerConfig() {
        return this.cleanerConfig;
    }

    public long flushCheckMs() {
        return this.flushCheckMs;
    }

    public long flushCheckpointMs() {
        return this.flushCheckpointMs;
    }

    public long retentionCheckMs() {
        return this.retentionCheckMs;
    }

    public BrokerState brokerState() {
        return this.brokerState;
    }

    public final Time kafka$log$LogManager$$time() {
        return this.kafka$log$LogManager$$time;
    }

    public String RecoveryPointCheckpointFile() {
        return this.RecoveryPointCheckpointFile;
    }

    public String LockFile() {
        return this.LockFile;
    }

    public int InitialTaskDelayMs() {
        return this.InitialTaskDelayMs;
    }

    private Object logCreationOrDeletionLock() {
        return this.logCreationOrDeletionLock;
    }

    public final Pool<TopicAndPartition, Log> kafka$log$LogManager$$logs() {
        return this.kafka$log$LogManager$$logs;
    }

    private Seq<FileLock> dirLocks() {
        return this.dirLocks;
    }

    public final scala.collection.immutable.Map<File, OffsetCheckpoint> kafka$log$LogManager$$recoveryPointCheckpoints() {
        return this.kafka$log$LogManager$$recoveryPointCheckpoints;
    }

    public LogCleaner cleaner() {
        return this.cleaner;
    }

    private void createAndValidateLogDirs(Seq<File> dirs) {
        if (((TraversableOnce)dirs.map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(File file) {
                return file.getCanonicalPath();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet().size() < dirs.size()) {
            throw new KafkaException(new StringBuilder().append((Object)"Duplicate log directory found: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).mkString(", ")).toString());
        }
        dirs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final LogManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(File dir$1) {
                block5: {
                    block4: {
                        if (dir$1.exists()) break block4;
                        this.$outer.info((Function0<String>)new Serializable(this, dir$1){
                            public static final long serialVersionUID;
                            private final File dir$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return new StringBuilder().append((Object)"Log directory '").append((Object)this.dir$1.getAbsolutePath()).append((Object)"' not found, creating it.").toString();
                            }
                            {
                                this.dir$1 = file;
                            }
                        });
                        boolean created = dir$1.mkdirs();
                        if (!created) break block5;
                    }
                    if (dir$1.isDirectory() && dir$1.canRead()) {
                        return;
                    }
                    throw new KafkaException(new StringBuilder().append((Object)dir$1.getAbsolutePath()).append((Object)" is not a readable log directory.").toString());
                }
                throw new KafkaException(new StringBuilder().append((Object)"Failed to create data directory ").append((Object)dir$1.getAbsolutePath()).toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    private Seq<FileLock> lockLogDirs(Seq<File> dirs) {
        return (Seq)dirs.map((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final LogManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final FileLock apply(File dir) {
                FileLock lock2 = new FileLock(new File(dir, this.$outer.LockFile()));
                if (lock2.tryLock()) {
                    return lock2;
                }
                throw new KafkaException(new StringBuilder().append((Object)"Failed to acquire lock on file .lock in ").append((Object)lock2.file().getParentFile().getAbsolutePath()).append((Object)". A Kafka instance in another process or thread is using this directory.").toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private void loadLogs() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Loading logs.";
            }
        });
        ArrayBuffer threadPools$1 = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        scala.collection.mutable.Map jobs$1 = Map$.MODULE$.empty();
        Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).foreach((Function1)new Serializable(this, threadPools$1, jobs$1){
            public static final long serialVersionUID;
            private final LogManager $outer;
            private final ArrayBuffer threadPools$1;
            private final scala.collection.mutable.Map jobs$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(File dir$2) {
                ExecutorService pool$1 = Executors.newFixedThreadPool(this.$outer.kafka$log$LogManager$$ioThreads);
                this.threadPools$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutorService[]{pool$1}));
                File cleanShutdownFile = new File(dir$2, Log$.MODULE$.CleanShutdownFile());
                if (cleanShutdownFile.exists()) {
                    this.$outer.debug((Function0<String>)new Serializable(this, dir$2){
                        public static final long serialVersionUID;
                        private final File dir$2;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return new StringBuilder().append((Object)"Found clean shutdown file. Skipping recovery for all logs in data directory: ").append((Object)this.dir$2.getAbsolutePath()).toString();
                        }
                        {
                            this.dir$2 = file;
                        }
                    });
                } else {
                    this.$outer.brokerState().newState(RecoveringFromUncleanShutdown$.MODULE$);
                }
                Map<TopicAndPartition, Object> recoveryPoints$1 = ((OffsetCheckpoint)this.$outer.kafka$log$LogManager$$recoveryPointCheckpoints().apply((Object)dir$2)).read();
                List jobsForDir = (List)Option$.MODULE$.apply((Object)dir$2.listFiles()).toList().flatMap((Function1)new Serializable(this, recoveryPoints$1){
                    public static final long serialVersionUID;
                    private final $anonfun$loadLogs$2 $outer;
                    public final Map recoveryPoints$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final ArrayOps<Runnable> apply(File[] dirContent) {
                        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])dirContent).withFilter((Function1)new Serializable(this){
                            public static final long serialVersionUID;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final boolean apply(File logDir) {
                                return logDir.isDirectory();
                            }
                        }).map((Function1)new Serializable(this){
                            public static final long serialVersionUID;
                            private final $anonfun$loadLogs$2$$anonfun$3 $outer;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final Runnable apply(File logDir$1) {
                                return Utils$.MODULE$.runnable((Function0<BoxedUnit>)new Serializable(this, logDir$1){
                                    public static final long serialVersionUID;
                                    private final $anonfun$loadLogs$2$$anonfun$3$$anonfun$apply$7 $outer;
                                    public final File logDir$1;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        this.$outer.kafka$log$LogManager$$anonfun$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$$outer().debug((Function0<String>)new Serializable(this){
                                            public static final long serialVersionUID;
                                            private final $anonfun$loadLogs$2$$anonfun$3$$anonfun$apply$7$$anonfun$apply$1 $outer;

                                            static {
                                                long l = serialVersionUID = 0L;
                                            }

                                            public final String apply() {
                                                return new StringBuilder().append((Object)"Loading log '").append((Object)this.$outer.logDir$1.getName()).append((Object)"'").toString();
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw new NullPointerException();
                                                }
                                                this.$outer = $outer;
                                            }
                                        });
                                        TopicAndPartition topicPartition = Log$.MODULE$.parseTopicPartitionName(this.logDir$1.getName());
                                        LogConfig config = (LogConfig)this.$outer.kafka$log$LogManager$$anonfun$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$$outer().topicConfigs().getOrElse((Object)topicPartition.topic(), (Function0)new Serializable(this){
                                            public static final long serialVersionUID;
                                            private final $anonfun$loadLogs$2$$anonfun$3$$anonfun$apply$7$$anonfun$apply$1 $outer;

                                            static {
                                                long l = serialVersionUID = 0L;
                                            }

                                            public final LogConfig apply() {
                                                return this.$outer.kafka$log$LogManager$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$$outer().defaultConfig();
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw new NullPointerException();
                                                }
                                                this.$outer = $outer;
                                            }
                                        });
                                        long logRecoveryPoint = BoxesRunTime.unboxToLong((Object)this.$outer.kafka$log$LogManager$$anonfun$$anonfun$$anonfun$$$outer().recoveryPoints$1.getOrElse((Object)topicPartition, (Function0)new Serializable(this){
                                            public static final long serialVersionUID;

                                            static {
                                                long l = serialVersionUID = 0L;
                                            }

                                            public final long apply() {
                                                return this.apply$mcJ$sp();
                                            }

                                            public long apply$mcJ$sp() {
                                                return 0L;
                                            }
                                        }));
                                        Log current = new Log(this.logDir$1, config, logRecoveryPoint, this.$outer.kafka$log$LogManager$$anonfun$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$$outer().kafka$log$LogManager$$scheduler, this.$outer.kafka$log$LogManager$$anonfun$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$$outer().kafka$log$LogManager$$time());
                                        Log previous = this.$outer.kafka$log$LogManager$$anonfun$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$$outer().kafka$log$LogManager$$logs().put(topicPartition, current);
                                        if (previous == null) {
                                            return;
                                        }
                                        throw new IllegalArgumentException(Predef$.MODULE$.augmentString("Duplicate log directories found: %s, %s!").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{current.dir().getAbsolutePath(), previous.dir().getAbsolutePath()})));
                                    }

                                    public $anonfun$loadLogs$2$$anonfun$3$$anonfun$apply$7 kafka$log$LogManager$$anonfun$$anonfun$$anonfun$$anonfun$$$outer() {
                                        return this.$outer;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.logDir$1 = file;
                                    }
                                });
                            }

                            public $anonfun$loadLogs$2$$anonfun$3 kafka$log$LogManager$$anonfun$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(Runnable.class))));
                    }

                    public $anonfun$loadLogs$2 kafka$log$LogManager$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.recoveryPoints$1 = map;
                    }
                }, List$.MODULE$.canBuildFrom());
                this.jobs$1.update((Object)cleanShutdownFile, (Object)((scala.collection.immutable.Seq)jobsForDir.map((Function1)new Serializable(this, pool$1){
                    public static final long serialVersionUID;
                    private final ExecutorService pool$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Future<?> apply(Runnable runnable) {
                        return this.pool$1.submit(runnable);
                    }
                    {
                        this.pool$1 = executorService;
                    }
                }, List$.MODULE$.canBuildFrom())).toSeq());
            }

            public LogManager kafka$log$LogManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.threadPools$1 = arrayBuffer;
                this.jobs$1 = map;
            }
        });
        try {
            ((IterableLike)jobs$1.filter((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(Tuple2<File, Seq<Future<?>>> tuple2) {
                    Tuple2<File, Seq<Future<?>>> tuple22 = tuple2;
                    return tuple22 != null;
                }
            })).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(Tuple2<File, Seq<Future<?>>> tuple2) {
                    Tuple2<File, Seq<Future<?>>> tuple22 = tuple2;
                    if (tuple22 != null) {
                        ((IterableLike)tuple22._2()).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final Object apply(Future<?> future) {
                                return future.get();
                            }
                        });
                        return ((File)tuple22._1()).delete();
                    }
                    throw new MatchError(tuple22);
                }
            });
        }
        catch (ExecutionException executionException) {
            try {
                this.error((Function0<String>)new Serializable(this, executionException){
                    public static final long serialVersionUID;
                    private final ExecutionException e$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"There was an error in one of the threads during logs loading: ").append((Object)this.e$1.getCause()).toString();
                    }
                    {
                        this.e$1 = executionException;
                    }
                });
                throw executionException.getCause();
            }
            catch (Throwable throwable) {
                threadPools$1.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(ExecutorService executorService) {
                        executorService.shutdown();
                    }
                });
                throw throwable;
            }
        }
        threadPools$1.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Logs loading complete.";
            }
        });
        return;
    }

    public void startup() {
        if (this.kafka$log$LogManager$$scheduler != null) {
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;
                private final LogManager $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Starting log cleanup with a period of %d ms.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.retentionCheckMs())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.kafka$log$LogManager$$scheduler.schedule("kafka-log-retention", (Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID;
                private final LogManager $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.cleanupLogs();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, this.InitialTaskDelayMs(), this.retentionCheckMs(), TimeUnit.MILLISECONDS);
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;
                private final LogManager $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Starting log flusher with a default period of %d ms.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.flushCheckMs())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.kafka$log$LogManager$$scheduler.schedule("kafka-log-flusher", (Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID;
                private final LogManager $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.kafka$log$LogManager$$flushDirtyLogs();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, this.InitialTaskDelayMs(), this.flushCheckMs(), TimeUnit.MILLISECONDS);
            this.kafka$log$LogManager$$scheduler.schedule("kafka-recovery-point-checkpoint", (Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID;
                private final LogManager $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.checkpointRecoveryPointOffsets();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, this.InitialTaskDelayMs(), this.flushCheckpointMs(), TimeUnit.MILLISECONDS);
        }
        if (this.cleanerConfig().enableCleaner()) {
            this.cleaner().startup();
        }
    }

    public void shutdown() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Shutting down.";
            }
        });
        ArrayBuffer threadPools$2 = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        scala.collection.mutable.Map jobs$2 = Map$.MODULE$.empty();
        if (this.cleaner() != null) {
            Utils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID;
                private final LogManager $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.cleaner().shutdown();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).foreach((Function1)new Serializable(this, threadPools$2, jobs$2){
            public static final long serialVersionUID;
            private final LogManager $outer;
            private final ArrayBuffer threadPools$2;
            private final scala.collection.mutable.Map jobs$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(File dir$3) {
                this.$outer.debug((Function0<String>)new Serializable(this, dir$3){
                    public static final long serialVersionUID;
                    private final File dir$3;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Flushing and closing logs at ").append((Object)this.dir$3).toString();
                    }
                    {
                        this.dir$3 = file;
                    }
                });
                ExecutorService pool$2 = Executors.newFixedThreadPool(this.$outer.kafka$log$LogManager$$ioThreads);
                this.threadPools$2.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutorService[]{pool$2}));
                Iterable logsInDir = ((MapLike)this.$outer.kafka$log$LogManager$$logsByDir().getOrElse((Object)dir$3.toString(), (Function0)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Map<Nothing$, Nothing$> apply() {
                        return (Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                    }
                })).values();
                Iterable jobsForDir = (Iterable)logsInDir.map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Runnable apply(Log log$2) {
                        return Utils$.MODULE$.runnable((Function0<BoxedUnit>)new Serializable(this, log$2){
                            public static final long serialVersionUID;
                            private final Log log$2;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                this.log$2.flush();
                                this.log$2.close();
                            }
                            {
                                this.log$2 = log;
                            }
                        });
                    }
                }, Iterable$.MODULE$.canBuildFrom());
                this.jobs$2.update((Object)dir$3, (Object)((TraversableOnce)jobsForDir.map((Function1)new Serializable(this, pool$2){
                    public static final long serialVersionUID;
                    private final ExecutorService pool$2;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Future<?> apply(Runnable runnable) {
                        return this.pool$2.submit(runnable);
                    }
                    {
                        this.pool$2 = executorService;
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toSeq());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.threadPools$2 = arrayBuffer;
                this.jobs$2 = map;
            }
        });
        try {
            ((IterableLike)jobs$2.filter((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(Tuple2<File, Seq<Future<?>>> tuple2) {
                    Tuple2<File, Seq<Future<?>>> tuple22 = tuple2;
                    return tuple22 != null;
                }
            })).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID;
                private final LogManager $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Tuple2<File, Seq<Future<?>>> tuple2) {
                    Tuple2<File, Seq<Future<?>>> tuple22 = tuple2;
                    if (tuple22 != null) {
                        File file;
                        File dir$4 = file = (File)tuple22._1();
                        ((IterableLike)tuple22._2()).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final Object apply(Future<?> future) {
                                return future.get();
                            }
                        });
                        this.$outer.debug((Function0<String>)new Serializable(this, dir$4){
                            public static final long serialVersionUID;
                            private final File dir$4;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return new StringBuilder().append((Object)"Updating recovery points at ").append((Object)this.dir$4).toString();
                            }
                            {
                                this.dir$4 = file;
                            }
                        });
                        this.$outer.kafka$log$LogManager$$checkpointLogsInDir(dir$4);
                        this.$outer.debug((Function0<String>)new Serializable(this, dir$4){
                            public static final long serialVersionUID;
                            private final File dir$4;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return new StringBuilder().append((Object)"Writing clean shutdown marker at ").append((Object)this.dir$4).toString();
                            }
                            {
                                this.dir$4 = file;
                            }
                        });
                        Utils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this, dir$4){
                            public static final long serialVersionUID;
                            private final File dir$4;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                new File(this.dir$4, Log$.MODULE$.CleanShutdownFile()).createNewFile();
                            }
                            {
                                this.dir$4 = file;
                            }
                        });
                        return;
                    }
                    throw new MatchError(tuple22);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        catch (ExecutionException executionException) {
            try {
                this.error((Function0<String>)new Serializable(this, executionException){
                    public static final long serialVersionUID;
                    private final ExecutionException e$3;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"There was an error in one of the threads during LogManager shutdown: ").append((Object)this.e$3.getCause()).toString();
                    }
                    {
                        this.e$3 = executionException;
                    }
                });
                throw executionException.getCause();
            }
            catch (Throwable throwable) {
                threadPools$2.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(ExecutorService executorService) {
                        executorService.shutdown();
                    }
                });
                this.dirLocks().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(FileLock fileLock) {
                        fileLock.destroy();
                    }
                });
                throw throwable;
            }
        }
        threadPools$2.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
        this.dirLocks().foreach((Function1)new /* invalid duplicate definition of identical inner class */);
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Shutdown complete.";
            }
        });
        return;
    }

    public void truncateTo(Map<TopicAndPartition, Object> partitionAndOffsets) {
        ((IterableLike)partitionAndOffsets.filter((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<TopicAndPartition, Object> tuple2) {
                Tuple2<TopicAndPartition, Object> tuple22 = tuple2;
                return tuple22 != null;
            }
        })).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final LogManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<TopicAndPartition, Object> tuple2) {
                Tuple2<TopicAndPartition, Object> tuple22 = tuple2;
                if (tuple22 != null) {
                    TopicAndPartition topicAndPartition = (TopicAndPartition)tuple22._1();
                    long l = BoxesRunTime.unboxToLong((Object)tuple22._2());
                    TopicAndPartition topicAndPartition2 = topicAndPartition;
                    long truncateOffset = l;
                    Log log = this.$outer.kafka$log$LogManager$$logs().get(topicAndPartition2);
                    if (log != null) {
                        boolean needToStopCleaner;
                        boolean bl = needToStopCleaner = truncateOffset < log.activeSegment().baseOffset();
                        if (needToStopCleaner && this.$outer.cleaner() != null) {
                            this.$outer.cleaner().abortAndPauseCleaning(topicAndPartition2);
                        }
                        log.truncateTo(truncateOffset);
                        if (needToStopCleaner && this.$outer.cleaner() != null) {
                            this.$outer.cleaner().resumeCleaning(topicAndPartition2);
                        }
                    }
                    return;
                }
                throw new MatchError(tuple22);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.checkpointRecoveryPointOffsets();
    }

    public void truncateFullyAndStartAt(TopicAndPartition topicAndPartition, long newOffset) {
        Log log = this.kafka$log$LogManager$$logs().get(topicAndPartition);
        if (log != null) {
            if (this.cleaner() != null) {
                this.cleaner().abortAndPauseCleaning(topicAndPartition);
            }
            log.truncateFullyAndStartAt(newOffset);
            if (this.cleaner() != null) {
                this.cleaner().resumeCleaning(topicAndPartition);
            }
        }
        this.checkpointRecoveryPointOffsets();
    }

    public void checkpointRecoveryPointOffsets() {
        Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final LogManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(File file) {
                this.$outer.kafka$log$LogManager$$checkpointLogsInDir(file);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public final void kafka$log$LogManager$$checkpointLogsInDir(File dir) {
        Option recoveryPoints = this.kafka$log$LogManager$$logsByDir().get((Object)dir.toString());
        if (recoveryPoints.isDefined()) {
            ((OffsetCheckpoint)this.kafka$log$LogManager$$recoveryPointCheckpoints().apply((Object)dir)).write((Map<TopicAndPartition, Object>)((scala.collection.immutable.MapLike)recoveryPoints.get()).mapValues((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final long apply(Log log) {
                    return log.recoveryPoint();
                }
            }));
        }
    }

    public Option<Log> getLog(TopicAndPartition topicAndPartition) {
        Log log = this.kafka$log$LogManager$$logs().get(topicAndPartition);
        return log == null ? None$.MODULE$ : new Some((Object)log);
    }

    public Log createLog(TopicAndPartition topicAndPartition$1, LogConfig config$1) {
        Object object = this.logCreationOrDeletionLock();
        synchronized (object) {
            Log log;
            block4: {
                log = this.kafka$log$LogManager$$logs().get(topicAndPartition$1);
                if (log != null) break block4;
                File dataDir$1 = this.nextLogDir();
                File dir = new File(dataDir$1, new StringBuilder().append((Object)topicAndPartition$1.topic()).append((Object)"-").append((Object)BoxesRunTime.boxToInteger((int)topicAndPartition$1.partition())).toString());
                dir.mkdirs();
                log = new Log(dir, config$1, 0L, this.kafka$log$LogManager$$scheduler, this.kafka$log$LogManager$$time());
                this.kafka$log$LogManager$$logs().put(topicAndPartition$1, log);
                this.info((Function0<String>)new Serializable(this, topicAndPartition$1, config$1, dataDir$1){
                    public static final long serialVersionUID;
                    private final TopicAndPartition topicAndPartition$1;
                    private final LogConfig config$1;
                    private final File dataDir$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Created log for partition [%s,%d] in %s with properties {%s}.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$1.topic(), BoxesRunTime.boxToInteger((int)this.topicAndPartition$1.partition()), this.dataDir$1.getAbsolutePath(), JavaConversions$.MODULE$.propertiesAsScalaMap(this.config$1.toProps()).mkString(", ")}));
                    }
                    {
                        this.topicAndPartition$1 = topicAndPartition;
                        this.config$1 = logConfig;
                        this.dataDir$1 = file;
                    }
                });
                Log log2 = log;
                return log2;
            }
            return log;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteLog(TopicAndPartition topicAndPartition$2) {
        ObjectRef removedLog$1 = new ObjectRef(null);
        Object object = this.logCreationOrDeletionLock();
        synchronized (object) {
            removedLog$1.elem = this.kafka$log$LogManager$$logs().remove(topicAndPartition$2);
        }
        if ((Log)removedLog$1.elem != null) {
            if (this.cleaner() != null) {
                this.cleaner().abortCleaning(topicAndPartition$2);
                this.cleaner().updateCheckpoints(((Log)removedLog$1.elem).dir().getParentFile());
            }
            ((Log)removedLog$1.elem).delete();
            this.info((Function0<String>)new Serializable(this, topicAndPartition$2, removedLog$1){
                public static final long serialVersionUID;
                private final TopicAndPartition topicAndPartition$2;
                private final ObjectRef removedLog$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Deleted log for partition [%s,%d] in %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$2.topic(), BoxesRunTime.boxToInteger((int)this.topicAndPartition$2.partition()), ((Log)this.removedLog$1.elem).dir().getAbsolutePath()}));
                }
                {
                    this.topicAndPartition$2 = topicAndPartition;
                    this.removedLog$1 = objectRef;
                }
            });
        }
    }

    private File nextLogDir() {
        File file;
        if (Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).size() == 1) {
            file = this.logDirs()[0];
        } else {
            scala.collection.immutable.Map logCounts = this.allLogs().groupBy((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply(Log log) {
                    return log.dir().getParent();
                }
            }).mapValues((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final int apply(Iterable<Log> iterable) {
                    return iterable.size();
                }
            });
            scala.collection.immutable.Map zeros = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).map((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Tuple2<String, Object> apply(File dir) {
                    return new Tuple2((Object)dir.getPath(), (Object)BoxesRunTime.boxToInteger((int)0));
                }
            }, Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(Tuple2.class, (OptManifest)ClassManifest$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{Manifest$.MODULE$.Int()}))))).toMap(Predef$.MODULE$.conforms());
            Buffer dirCounts = zeros.$plus$plus((GenTraversableOnce)logCounts).toBuffer();
            Tuple2 leastLoaded = (Tuple2)((IterableLike)dirCounts.sortBy((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final int apply(Tuple2<String, Object> tuple2) {
                    return tuple2._2$mcI$sp();
                }
            }, (Ordering)Ordering$Int$.MODULE$)).head();
            file = new File((String)leastLoaded._1());
        }
        return file;
    }

    public final int kafka$log$LogManager$$cleanupExpiredSegments(Log log$3) {
        long startMs$1 = this.kafka$log$LogManager$$time().milliseconds();
        return log$3.deleteOldSegments((Function1<LogSegment, Object>)new Serializable(this, log$3, startMs$1){
            public static final long serialVersionUID;
            private final Log log$3;
            private final long startMs$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(LogSegment logSegment) {
                return this.startMs$1 - logSegment.lastModified() > this.log$3.config().retentionMs();
            }
            {
                this.log$3 = log;
                this.startMs$1 = l;
            }
        });
    }

    public final int kafka$log$LogManager$$cleanupSegmentsToMaintainSize(Log log) {
        if (log.config().retentionSize() < 0L || log.size() < log.config().retentionSize()) {
            return 0;
        }
        LongRef diff$1 = new LongRef(log.size() - log.config().retentionSize());
        return log.deleteOldSegments((Function1<LogSegment, Object>)new Serializable(this, diff$1){
            public static final long serialVersionUID;
            private final LogManager $outer;
            private final LongRef diff$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(LogSegment logSegment) {
                return this.$outer.shouldDelete$1(logSegment, this.diff$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.diff$1 = longRef;
            }
        });
    }

    public void cleanupLogs() {
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Beginning log cleanup...";
            }
        });
        IntRef total$1 = new IntRef(0);
        long startMs$2 = this.kafka$log$LogManager$$time().milliseconds();
        this.allLogs().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Log log) {
                return !log.config().compact();
            }
        }).foreach((Function1)new Serializable(this, total$1){
            public static final long serialVersionUID;
            private final LogManager $outer;
            private final IntRef total$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Log log$4) {
                this.$outer.debug((Function0<String>)new Serializable(this, log$4){
                    public static final long serialVersionUID;
                    private final Log log$4;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Garbage collecting '").append((Object)this.log$4.name()).append((Object)"'").toString();
                    }
                    {
                        this.log$4 = log;
                    }
                });
                this.total$1.elem += this.$outer.kafka$log$LogManager$$cleanupExpiredSegments(log$4) + this.$outer.kafka$log$LogManager$$cleanupSegmentsToMaintainSize(log$4);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.total$1 = intRef;
            }
        });
        this.debug((Function0<String>)new Serializable(this, total$1, startMs$2){
            public static final long serialVersionUID;
            private final LogManager $outer;
            private final IntRef total$1;
            private final long startMs$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Log cleanup completed. ").append((Object)BoxesRunTime.boxToInteger((int)this.total$1.elem)).append((Object)" files deleted in ").append((Object)BoxesRunTime.boxToLong((long)((this.$outer.kafka$log$LogManager$$time().milliseconds() - this.startMs$2) / 1000L))).append((Object)" seconds").toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.total$1 = intRef;
                this.startMs$2 = l;
            }
        });
    }

    public Iterable<Log> allLogs() {
        return this.kafka$log$LogManager$$logs().values();
    }

    public scala.collection.immutable.Map<TopicAndPartition, Log> logsByTopicPartition() {
        return this.kafka$log$LogManager$$logs().toMap(Predef$.MODULE$.conforms());
    }

    public final scala.collection.immutable.Map<String, scala.collection.immutable.Map<TopicAndPartition, Log>> kafka$log$LogManager$$logsByDir() {
        return this.logsByTopicPartition().groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(Tuple2<TopicAndPartition, Log> tuple2) {
                Tuple2<TopicAndPartition, Log> tuple22 = tuple2;
                if (tuple22 != null) {
                    return ((Log)tuple22._2()).dir().getParent();
                }
                throw new MatchError(tuple22);
            }
        });
    }

    public final void kafka$log$LogManager$$flushDirtyLogs() {
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Checking for dirty logs to flush...";
            }
        });
        ((IterableLike)this.kafka$log$LogManager$$logs().filter((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<TopicAndPartition, Log> tuple2) {
                Tuple2<TopicAndPartition, Log> tuple22 = tuple2;
                return tuple22 != null;
            }
        })).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final LogManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void apply(Tuple2<TopicAndPartition, Log> tuple2) {
                Tuple2<TopicAndPartition, Log> tuple22 = tuple2;
                if (tuple22 == null) throw new MatchError(tuple22);
                TopicAndPartition topicAndPartition = (TopicAndPartition)tuple22._1();
                Log log = (Log)tuple22._2();
                TopicAndPartition topicAndPartition$3 = topicAndPartition;
                Log log$1 = log;
                try {
                    long timeSinceLastFlush$1 = this.$outer.kafka$log$LogManager$$time().milliseconds() - log$1.lastFlushTime();
                    this.$outer.debug((Function0<String>)new Serializable(this, topicAndPartition$3, log$1, timeSinceLastFlush$1){
                        public static final long serialVersionUID;
                        private final TopicAndPartition topicAndPartition$3;
                        private final Log log$1;
                        private final long timeSinceLastFlush$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return new StringBuilder().append((Object)"Checking if flush is needed on ").append((Object)this.topicAndPartition$3.topic()).append((Object)" flush interval  ").append((Object)BoxesRunTime.boxToLong((long)this.log$1.config().flushMs())).append((Object)" last flushed ").append((Object)BoxesRunTime.boxToLong((long)this.log$1.lastFlushTime())).append((Object)" time since last flush: ").append((Object)BoxesRunTime.boxToLong((long)this.timeSinceLastFlush$1)).toString();
                        }
                        {
                            this.topicAndPartition$3 = topicAndPartition;
                            this.log$1 = log;
                            this.timeSinceLastFlush$1 = l;
                        }
                    });
                    if (timeSinceLastFlush$1 < log$1.config().flushMs()) return;
                    log$1.flush();
                    return;
                }
                catch (Throwable throwable) {
                    this.$outer.error((Function0<String>)new Serializable(this, topicAndPartition$3){
                        public static final long serialVersionUID;
                        private final TopicAndPartition topicAndPartition$3;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return new StringBuilder().append((Object)"Error flushing topic ").append((Object)this.topicAndPartition$3.topic()).toString();
                        }
                        {
                            this.topicAndPartition$3 = topicAndPartition;
                        }
                    }, (Function0<Throwable>)new Serializable(this, throwable){
                        public static final long serialVersionUID;
                        private final Throwable e$2;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final Throwable apply() {
                            return this.e$2;
                        }
                        {
                            this.e$2 = throwable;
                        }
                    });
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public final boolean shouldDelete$1(LogSegment segment, LongRef longRef) {
        boolean bl;
        if (longRef.elem - segment.size() >= 0L) {
            longRef.elem -= segment.size();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public LogManager(File[] logDirs, Map<String, LogConfig> topicConfigs, LogConfig defaultConfig, CleanerConfig cleanerConfig, int ioThreads, long flushCheckMs, long flushCheckpointMs, long retentionCheckMs, Scheduler scheduler, BrokerState brokerState, Time time) {
        this.logDirs = logDirs;
        this.topicConfigs = topicConfigs;
        this.defaultConfig = defaultConfig;
        this.cleanerConfig = cleanerConfig;
        this.kafka$log$LogManager$$ioThreads = ioThreads;
        this.flushCheckMs = flushCheckMs;
        this.flushCheckpointMs = flushCheckpointMs;
        this.retentionCheckMs = retentionCheckMs;
        this.kafka$log$LogManager$$scheduler = scheduler;
        this.brokerState = brokerState;
        this.kafka$log$LogManager$$time = time;
        Logging$class.$init$(this);
        this.RecoveryPointCheckpointFile = "recovery-point-offset-checkpoint";
        this.LockFile = ".lock";
        this.InitialTaskDelayMs = 30000;
        this.logCreationOrDeletionLock = new Object();
        this.kafka$log$LogManager$$logs = new Pool(Pool$.MODULE$.init$default$1());
        this.createAndValidateLogDirs((Seq<File>)Predef$.MODULE$.wrapRefArray((Object[])logDirs));
        this.dirLocks = this.lockLogDirs((Seq<File>)Predef$.MODULE$.wrapRefArray((Object[])logDirs));
        this.kafka$log$LogManager$$recoveryPointCheckpoints = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])logDirs).map((Function1)new $anonfun$2(this), Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(Tuple2.class, (OptManifest)ClassManifest$.MODULE$.classType(File.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{ClassManifest$.MODULE$.classType(OffsetCheckpoint.class)}))))).toMap(Predef$.MODULE$.conforms());
        this.loadLogs();
        this.cleaner = cleanerConfig.enableCleaner() ? new LogCleaner(cleanerConfig, logDirs, this.kafka$log$LogManager$$logs(), time) : null;
    }
}

