/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.nio.ByteBuffer;
import kafka.api.PartitionMetadata$;
import kafka.api.TopicMetadata$;
import kafka.cluster.Broker;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Uw!B\u0001\u0003\u0011\u000b9\u0011!\u0005)beRLG/[8o\u001b\u0016$\u0018\rZ1uC*\u00111\u0001B\u0001\u0004CBL'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0003\u0017\t\t\u0002+\u0019:uSRLwN\\'fi\u0006$\u0017\r^1\u0014\t%aAC\u0007\t\u0003\u001bIi\u0011A\u0004\u0006\u0003\u001fA\tA\u0001\\1oO*\t\u0011#\u0001\u0003kCZ\f\u0017BA\n\u000f\u0005\u0019y%M[3diB\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\tY1kY1mC>\u0013'.Z2u!\t)2$\u0003\u0002\u001d-\ta1+\u001a:jC2L'0\u00192mK\")a$\u0003C\u0001?\u00051A(\u001b8jiz\"\u0012a\u0002\u0005\u0006C%!\tAI\u0001\te\u0016\fGM\u0012:p[R)1%!%\u0002\u0014B\u0011\u0001\u0002\n\u0004\u0005\u0015\t\u0001Ue\u0005\u0004%\u0019\u0019\"BF\u0007\t\u0003O)j\u0011\u0001\u000b\u0006\u0003S\u0011\tQ!\u001e;jYNL!a\u000b\u0015\u0003\u000f1{wmZ5oOB\u0011Q#L\u0005\u0003]Y\u0011q\u0001\u0015:pIV\u001cG\u000f\u0003\u00051I\tU\r\u0011\"\u00012\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\u0016\u0003I\u0002\"!F\u001a\n\u0005Q2\"aA%oi\"Aa\u0007\nB\tB\u0003%!'\u0001\u0007qCJ$\u0018\u000e^5p]&#\u0007\u0005\u0003\u00059I\tU\r\u0011\"\u0001:\u0003\u0019aW-\u00193feV\t!\bE\u0002\u0016wuJ!\u0001\u0010\f\u0003\r=\u0003H/[8o!\tq\u0014)D\u0001@\u0015\t\u0001E!A\u0004dYV\u001cH/\u001a:\n\u0005\t{$A\u0002\"s_.,'\u000f\u0003\u0005EI\tE\t\u0015!\u0003;\u0003\u001daW-\u00193fe\u0002B\u0001B\u0012\u0013\u0003\u0016\u0004%\taR\u0001\te\u0016\u0004H.[2bgV\t\u0001\nE\u0002J#vr!AS(\u000f\u0005-sU\"\u0001'\u000b\u000553\u0011A\u0002\u001fs_>$h(C\u0001\u0018\u0013\t\u0001f#A\u0004qC\u000e\\\u0017mZ3\n\u0005I\u001b&aA*fc*\u0011\u0001K\u0006\u0005\t+\u0012\u0012\t\u0012)A\u0005\u0011\u0006I!/\u001a9mS\u000e\f7\u000f\t\u0005\t/\u0012\u0012)\u001a!C\u0001\u000f\u0006\u0019\u0011n\u001d:\t\u0011e##\u0011#Q\u0001\n!\u000bA![:sA!A1\f\nBK\u0002\u0013\u0005A,A\u0005feJ|'oQ8eKV\tQ\f\u0005\u0002\u0016=&\u0011qL\u0006\u0002\u0006'\"|'\u000f\u001e\u0005\tC\u0012\u0012\t\u0012)A\u0005;\u0006QQM\u001d:pe\u000e{G-\u001a\u0011\t\u000by!C\u0011A2\u0015\r\r\"WMZ4i\u0011\u0015\u0001$\r1\u00013\u0011\u0015A$\r1\u0001;\u0011\u00151%\r1\u0001I\u0011\u001d9&\r%AA\u0002!Cqa\u00172\u0011\u0002\u0003\u0007Q\fC\u0003kI\u0011\u0005\u0011'A\u0006tSj,\u0017J\u001c\"zi\u0016\u001c\b\"\u00027%\t\u0003i\u0017aB<sSR,Gk\u001c\u000b\u0003]F\u0004\"!F8\n\u0005A4\"\u0001B+oSRDQA]6A\u0002M\faAY;gM\u0016\u0014\bC\u0001;x\u001b\u0005)(B\u0001<\u0011\u0003\rq\u0017n\\\u0005\u0003qV\u0014!BQ=uK\n+hMZ3s\u0011\u0015QH\u0005\"\u0011|\u0003!!xn\u0015;sS:<G#\u0001?\u0011\u0007u\f\tA\u0004\u0002\u0016}&\u0011qPF\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u0011Q\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005}4\u0002bBA\u0005I\u0011%\u00111B\u0001\rM>\u0014X.\u0019;Ce>\\WM\u001d\u000b\u0005\u0003\u001b\t\t\u0002E\u0002\u000e\u0003\u001fI1!a\u0001\u000f\u0011\u001d\t\u0019\"a\u0002A\u0002u\naA\u0019:pW\u0016\u0014\b\"CA\fI\u0005\u0005I\u0011AA\r\u0003\u0011\u0019w\u000e]=\u0015\u0017\r\nY\"!\b\u0002 \u0005\u0005\u00121\u0005\u0005\ta\u0005U\u0001\u0013!a\u0001e!A\u0001(!\u0006\u0011\u0002\u0003\u0007!\b\u0003\u0005G\u0003+\u0001\n\u00111\u0001I\u0011!9\u0016Q\u0003I\u0001\u0002\u0004A\u0005\u0002C.\u0002\u0016A\u0005\t\u0019A/\t\u0013\u0005\u001dB%%A\u0005\u0002\u0005%\u0012AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003WQ3AMA\u0017W\t\ty\u0003\u0005\u0003\u00022\u0005mRBAA\u001a\u0015\u0011\t)$a\u000e\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001d-\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00121\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA!IE\u0005I\u0011AA\"\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!\u0012+\u0007i\ni\u0003C\u0005\u0002J\u0011\n\n\u0011\"\u0001\u0002L\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAA'U\rA\u0015Q\u0006\u0005\n\u0003#\"\u0013\u0013!C\u0001\u0003\u0017\nabY8qs\u0012\"WMZ1vYR$C\u0007C\u0005\u0002V\u0011\n\n\u0011\"\u0001\u0002X\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*TCAA-U\ri\u0016Q\u0006\u0005\b\u0003;\"C\u0011IA0\u0003!A\u0017m\u001d5D_\u0012,G#\u0001\u001a\t\u000f\u0005\rD\u0005\"\u0011\u0002f\u00051Q-];bYN$B!a\u001a\u0002nA\u0019Q#!\u001b\n\u0007\u0005-dCA\u0004C_>dW-\u00198\t\u0015\u0005=\u0014\u0011MA\u0001\u0002\u0004\t\t(A\u0002yIE\u00022!FA:\u0013\r\t)H\u0006\u0002\u0004\u0003:L\bbBA=I\u0011\u0005\u00131P\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u00055\u0001BBA@I\u0011\u0005\u0013'\u0001\u0007qe>$Wo\u0019;Be&$\u0018\u0010C\u0004\u0002\u0004\u0012\"\t%!\"\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011OAD\u0011%\ty'!!\u0002\u0002\u0003\u0007!\u0007C\u0004\u0002\f\u0012\"\t%!$\u0002\u0011\r\fg.R9vC2$B!a\u001a\u0002\u0010\"Q\u0011qNAE\u0003\u0003\u0005\r!!\u001d\t\u000bI\u0004\u0003\u0019A:\t\u000f\u0005U\u0005\u00051\u0001\u0002\u0018\u00069!M]8lKJ\u001c\b#B?\u0002\u001aJj\u0014\u0002BAN\u0003\u000b\u00111!T1q\u0011%\ty*CA\u0001\n\u0003\u000b\t+A\u0003baBd\u0017\u0010F\u0006$\u0003G\u000b)+a*\u0002*\u0006-\u0006B\u0002\u0019\u0002\u001e\u0002\u0007!\u0007\u0003\u00049\u0003;\u0003\rA\u000f\u0005\u0007\r\u0006u\u0005\u0019\u0001%\t\u0011]\u000bi\n%AA\u0002!C\u0001bWAO!\u0003\u0005\r!\u0018\u0005\n\u0003_K\u0011\u0011!CA\u0003c\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u00024\u0006m\u0006\u0003B\u000b<\u0003k\u0003\u0002\"FA\\eiB\u0005*X\u0005\u0004\u0003s3\"A\u0002+va2,W\u0007C\u0004\u0002>\u00065\u0006\u0019A\u0012\u0002\u0007a$\u0003\u0007C\u0005\u0002B&\t\n\u0011\"\u0001\u0002L\u0005q\u0011N\\5uI\u0011,g-Y;mi\u0012\"\u0004\"CAc\u0013E\u0005I\u0011AA,\u00039Ig.\u001b;%I\u00164\u0017-\u001e7uIUB\u0011\"!3\n#\u0003%\t!a\u0013\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQB\u0011\"!4\n#\u0003%\t!a\u0016\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIUBq!!5\n\t#\t\u0019.A\u0006sK\u0006$'+Z:pYZ,G#\u0001\u0007")
public class PartitionMetadata
implements Logging,
ScalaObject,
Product,
Serializable {
    private final int partitionId;
    private final Option<Broker> leader;
    private final Seq<Broker> replicas;
    private final Seq<Broker> isr;
    private final short errorCode;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final short apply$default$5() {
        return PartitionMetadata$.MODULE$.apply$default$5();
    }

    public static final Seq apply$default$4() {
        return PartitionMetadata$.MODULE$.apply$default$4();
    }

    public static final short init$default$5() {
        return PartitionMetadata$.MODULE$.init$default$5();
    }

    public static final Seq init$default$4() {
        return PartitionMetadata$.MODULE$.init$default$4();
    }

    public static final PartitionMetadata readFrom(ByteBuffer byteBuffer, Map<Object, Broker> map) {
        return PartitionMetadata$.MODULE$.readFrom(byteBuffer, map);
    }

    public int partitionId() {
        return this.partitionId;
    }

    public Option<Broker> leader() {
        return this.leader;
    }

    public Seq<Broker> replicas() {
        return this.replicas;
    }

    public Seq<Broker> isr() {
        return this.isr;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public int sizeInBytes() {
        return 14 + 4 * this.replicas().size() + 4 + 4 * this.isr().size();
    }

    public void writeTo(ByteBuffer buffer$4) {
        buffer$4.putShort(this.errorCode());
        buffer$4.putInt(this.partitionId());
        int leaderId = this.leader().isDefined() ? ((Broker)this.leader().get()).id() : TopicMetadata$.MODULE$.NoLeaderNodeId();
        buffer$4.putInt(leaderId);
        buffer$4.putInt(this.replicas().size());
        this.replicas().foreach((Function1)new Serializable(this, buffer$4){
            public static final long serialVersionUID;
            private final ByteBuffer buffer$4;

            static {
                long l = serialVersionUID = 0L;
            }

            public final ByteBuffer apply(Broker r) {
                return this.buffer$4.putInt(r.id());
            }
            {
                this.buffer$4 = byteBuffer;
            }
        });
        buffer$4.putInt(this.isr().size());
        this.isr().foreach((Function1)new Serializable(this, buffer$4){
            public static final long serialVersionUID;
            private final ByteBuffer buffer$4;

            static {
                long l = serialVersionUID = 0L;
            }

            public final ByteBuffer apply(Broker r) {
                return this.buffer$4.putInt(r.id());
            }
            {
                this.buffer$4 = byteBuffer;
            }
        });
    }

    public String toString() {
        StringBuilder partitionMetadataString = new StringBuilder();
        partitionMetadataString.append(new StringBuilder().append((Object)"\tpartition ").append((Object)BoxesRunTime.boxToInteger((int)this.partitionId())).toString());
        partitionMetadataString.append(new StringBuilder().append((Object)"\tleader: ").append((Object)(this.leader().isDefined() ? this.kafka$api$PartitionMetadata$$formatBroker((Broker)this.leader().get()) : "none")).toString());
        partitionMetadataString.append(new StringBuilder().append((Object)"\treplicas: ").append((Object)((TraversableOnce)this.replicas().map((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final PartitionMetadata $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(Broker broker) {
                return this.$outer.kafka$api$PartitionMetadata$$formatBroker(broker);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(",")).toString());
        partitionMetadataString.append(new StringBuilder().append((Object)"\tisr: ").append((Object)((TraversableOnce)this.isr().map((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final PartitionMetadata $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(Broker broker) {
                return this.$outer.kafka$api$PartitionMetadata$$formatBroker(broker);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(",")).toString());
        partitionMetadataString.append(Predef$.MODULE$.augmentString("\tisUnderReplicated: %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.isr().size() < this.replicas().size() ? "true" : "false"})));
        return partitionMetadataString.toString();
    }

    public final String kafka$api$PartitionMetadata$$formatBroker(Broker broker) {
        return new StringBuilder().append(broker.id()).append((Object)" (").append((Object)Utils.formatAddress((String)broker.host(), (Integer)Predef$.MODULE$.int2Integer(broker.port()))).append((Object)")").toString();
    }

    public PartitionMetadata copy(int partitionId, Option leader, Seq replicas, Seq isr, short errorCode) {
        return new PartitionMetadata(partitionId, (Option<Broker>)leader, (Seq<Broker>)replicas, (Seq<Broker>)isr, errorCode);
    }

    public short copy$default$5() {
        return this.errorCode();
    }

    public Seq copy$default$4() {
        return this.isr();
    }

    public Seq copy$default$3() {
        return this.replicas();
    }

    public Option copy$default$2() {
        return this.leader();
    }

    public int copy$default$1() {
        return this.partitionId();
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        short s;
        short errorCode$2;
        Seq<Broker> seq;
        Seq<Broker> isr$1;
        Seq<Broker> seq2;
        Seq<Broker> replicas$1;
        Option<Broker> option;
        Option<Broker> leader$1;
        if (this == object) return true;
        Object object2 = object;
        if (!(object2 instanceof PartitionMetadata)) return false;
        PartitionMetadata partitionMetadata = (PartitionMetadata)object2;
        int n = partitionMetadata.partitionId();
        int partitionId$1 = n;
        if (!this.gd2$1(partitionId$1, leader$1 = (option = partitionMetadata.leader()), replicas$1 = (seq2 = partitionMetadata.replicas()), isr$1 = (seq = partitionMetadata.isr()), errorCode$2 = (s = partitionMetadata.errorCode()))) return false;
        boolean bl = ((PartitionMetadata)object).canEqual(this);
        if (!bl) return false;
        return true;
    }

    public String productPrefix() {
        return "PartitionMetadata";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
            }
            case 4: {
                object = BoxesRunTime.boxToShort((short)this.errorCode());
                break;
            }
            case 3: {
                object = this.isr();
                break;
            }
            case 2: {
                object = this.replicas();
                break;
            }
            case 1: {
                object = this.leader();
                break;
            }
            case 0: {
                object = BoxesRunTime.boxToInteger((int)this.partitionId());
            }
        }
        return object;
    }

    public boolean canEqual(Object object) {
        return object instanceof PartitionMetadata;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean gd2$1(int n, Option option, Seq seq, Seq seq2, short s) {
        if (n != this.partitionId()) return false;
        Option option2 = option;
        Option<Broker> option3 = this.leader();
        if (option2 == null) {
            if (option3 != null) {
                return false;
            }
        } else if (!option2.equals(option3)) return false;
        Seq seq3 = seq;
        Seq<Broker> seq4 = this.replicas();
        if (seq3 == null) {
            if (seq4 != null) {
                return false;
            }
        } else if (!seq3.equals(seq4)) return false;
        Seq seq5 = seq2;
        Seq<Broker> seq6 = this.isr();
        if (seq5 == null) {
            if (seq6 != null) {
                return false;
            }
        } else if (!seq5.equals(seq6)) return false;
        if (s != this.errorCode()) return false;
        return true;
    }

    public PartitionMetadata(int partitionId, Option<Broker> leader, Seq<Broker> replicas, Seq<Broker> isr, short errorCode) {
        this.partitionId = partitionId;
        this.leader = leader;
        this.replicas = replicas;
        this.isr = isr;
        this.errorCode = errorCode;
        Logging$class.$init$(this);
        Product.class.$init$((Product)this);
    }
}

