/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.nio.ByteBuffer;
import kafka.api.ApiUtils$;
import kafka.api.OffsetCommitRequest;
import kafka.api.OffsetCommitRequest$;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.common.TopicAndPartition;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.SystemTime$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple7;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OffsetCommitRequest$
implements Logging,
ScalaObject,
Serializable {
    public static final OffsetCommitRequest$ MODULE$;
    private final short CurrentVersion;
    private final String DefaultClientId;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new OffsetCommitRequest$();
    }

    public short CurrentVersion() {
        return this.CurrentVersion;
    }

    public String DefaultClientId() {
        return this.DefaultClientId;
    }

    public OffsetCommitRequest readFrom(ByteBuffer buffer$1) {
        short versionId$2 = buffer$1.getShort();
        Predef$.MODULE$.assert(versionId$2 == 0 || versionId$2 == 1, (Function0)new Serializable(versionId$2){
            public static final long serialVersionUID;
            private final short versionId$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Version ").append((Object)BoxesRunTime.boxToShort((short)this.versionId$2)).append((Object)" is invalid for OffsetCommitRequest. Valid versions are 0 or 1.").toString();
            }
            {
                this.versionId$2 = s;
            }
        });
        int correlationId = buffer$1.getInt();
        String clientId = ApiUtils$.MODULE$.readShortString(buffer$1);
        String consumerGroupId = ApiUtils$.MODULE$.readShortString(buffer$1);
        int groupGenerationId = -1;
        String consumerId = "";
        if (versionId$2 == 1) {
            groupGenerationId = buffer$1.getInt();
            consumerId = ApiUtils$.MODULE$.readShortString(buffer$1);
        }
        int topicCount = buffer$1.getInt();
        IndexedSeq pairs = (IndexedSeq)Predef$.MODULE$.intWrapper(1).to(topicCount).flatMap((Function1)new Serializable(buffer$1, versionId$2){
            public static final long serialVersionUID;
            public final ByteBuffer buffer$1;
            public final short versionId$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final IndexedSeq<Tuple2<TopicAndPartition, OffsetAndMetadata>> apply(int x$1) {
                String topic$1 = ApiUtils$.MODULE$.readShortString(this.buffer$1);
                int partitionCount = this.buffer$1.getInt();
                return (IndexedSeq)Predef$.MODULE$.intWrapper(1).to(partitionCount).map((Function1)new Serializable(this, topic$1){
                    public static final long serialVersionUID;
                    private final anonfun.1 $outer;
                    private final String topic$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Tuple2<TopicAndPartition, OffsetAndMetadata> apply(int x$2) {
                        long given;
                        int partitionId = this.$outer.buffer$1.getInt();
                        long offset = this.$outer.buffer$1.getLong();
                        long timestamp = this.$outer.versionId$2 == 1 ? (given = this.$outer.buffer$1.getLong()) : OffsetAndMetadata$.MODULE$.InvalidTime();
                        String metadata = ApiUtils$.MODULE$.readShortString(this.$outer.buffer$1);
                        return new Tuple2((Object)new TopicAndPartition(this.topic$1, partitionId), (Object)new OffsetAndMetadata(offset, metadata, timestamp));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.topic$1 = string;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.buffer$1 = byteBuffer;
                this.versionId$2 = s;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return new OffsetCommitRequest(consumerGroupId, (Map<TopicAndPartition, OffsetAndMetadata>)((Map)Map$.MODULE$.apply((Seq)pairs)), versionId$2, correlationId, clientId, groupGenerationId, consumerId);
    }

    public void changeInvalidTimeToCurrentTime(OffsetCommitRequest offsetCommitRequest) {
        long now$1 = SystemTime$.MODULE$.milliseconds();
        ((IterableLike)offsetCommitRequest.requestInfo().filter((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<TopicAndPartition, OffsetAndMetadata> tuple2) {
                Tuple2<TopicAndPartition, OffsetAndMetadata> tuple22 = tuple2;
                return tuple22 != null;
            }
        })).foreach((Function1)new Serializable(now$1){
            public static final long serialVersionUID;
            private final long now$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<TopicAndPartition, OffsetAndMetadata> tuple2) {
                Tuple2<TopicAndPartition, OffsetAndMetadata> tuple22 = tuple2;
                if (tuple22 != null) {
                    OffsetAndMetadata offsetAndMetadata = (OffsetAndMetadata)tuple22._2();
                    OffsetAndMetadata offsetAndMetadata2 = offsetAndMetadata;
                    if (offsetAndMetadata2.timestamp() == OffsetAndMetadata$.MODULE$.InvalidTime()) {
                        offsetAndMetadata2.timestamp_$eq(this.now$1);
                    }
                    return;
                }
                throw new MatchError(tuple22);
            }
            {
                this.now$1 = l;
            }
        });
    }

    public String apply$default$7() {
        return "";
    }

    public int apply$default$6() {
        return -1;
    }

    public String apply$default$5() {
        return this.DefaultClientId();
    }

    public int apply$default$4() {
        return 0;
    }

    public short apply$default$3() {
        return this.CurrentVersion();
    }

    public String init$default$7() {
        return "";
    }

    public int init$default$6() {
        return -1;
    }

    public String init$default$5() {
        return this.DefaultClientId();
    }

    public int init$default$4() {
        return 0;
    }

    public short init$default$3() {
        return this.CurrentVersion();
    }

    public Option unapply(OffsetCommitRequest x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple7((Object)x$0.groupId(), x$0.requestInfo(), (Object)BoxesRunTime.boxToShort((short)x$0.versionId()), (Object)BoxesRunTime.boxToInteger((int)x$0.correlationId()), (Object)x$0.clientId(), (Object)BoxesRunTime.boxToInteger((int)x$0.groupGenerationId()), (Object)x$0.consumerId()));
    }

    public OffsetCommitRequest apply(String groupId, Map requestInfo, short versionId, int correlationId, String clientId, int groupGenerationId, String consumerId) {
        return new OffsetCommitRequest(groupId, (Map<TopicAndPartition, OffsetAndMetadata>)requestInfo, versionId, correlationId, clientId, groupGenerationId, consumerId);
    }

    public Object readResolve() {
        return MODULE$;
    }

    private OffsetCommitRequest$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.CurrentVersion = 1;
        this.DefaultClientId = "";
    }
}

