/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.controller.ControllerContext;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaState;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t3Qa\u0002\u0005\u0002\u00025A\u0001B\u0007\u0001\u0003\u0002\u0003\u0006Ia\u0007\u0005\u0006?\u0001!\t\u0001\t\u0005\u0006G\u0001!\t\u0001\n\u0005\u0006Q\u0001!\t\u0001\n\u0005\u0006S\u0001!I\u0001\n\u0005\u0006U\u00011\ta\u000b\u0002\u0014%\u0016\u0004H.[2b'R\fG/Z'bG\"Lg.\u001a\u0006\u0003\u0013)\t!bY8oiJ|G\u000e\\3s\u0015\u0005Y\u0011!B6bM.\f7\u0001A\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u001615\taC\u0003\u0002\u0018\u0015\u0005)Q\u000f^5mg&\u0011\u0011D\u0006\u0002\b\u0019><w-\u001b8h\u0003E\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\t\u00039ui\u0011\u0001C\u0005\u0003=!\u0011\u0011cQ8oiJ|G\u000e\\3s\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\u0011\u0011E\t\t\u00039\u0001AQA\u0007\u0002A\u0002m\tqa\u001d;beR,\b\u000fF\u0001&!\tya%\u0003\u0002(!\t!QK\\5u\u0003!\u0019\b.\u001e;e_^t\u0017AF5oSRL\u0017\r\\5{KJ+\u0007\u000f\\5dCN#\u0018\r^3\u0002%!\fg\u000e\u001a7f'R\fG/Z\"iC:<Wm\u001d\u000b\u0004K1j\u0004\"B\u0017\u0007\u0001\u0004q\u0013\u0001\u0003:fa2L7-Y:\u0011\u0007=:$H\u0004\u00021k9\u0011\u0011\u0007N\u0007\u0002e)\u00111\u0007D\u0001\u0007yI|w\u000e\u001e \n\u0003EI!A\u000e\t\u0002\u000fA\f7m[1hK&\u0011\u0001(\u000f\u0002\u0004'\u0016\f(B\u0001\u001c\u0011!\ta2(\u0003\u0002=\u0011\t\u0019\u0002+\u0019:uSRLwN\\!oIJ+\u0007\u000f\\5dC\")aH\u0002a\u0001\u007f\u0005YA/\u0019:hKR\u001cF/\u0019;f!\ta\u0002)\u0003\u0002B\u0011\ta!+\u001a9mS\u000e\f7\u000b^1uK\u0002")
public abstract class ReplicaStateMachine
implements Logging {
    private final ControllerContext controllerContext;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ReplicaStateMachine replicaStateMachine = this;
        synchronized (replicaStateMachine) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Initializing replica state");
        this.initializeReplicaState();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Triggering online replica state changes");
        Tuple2<Set<PartitionAndReplica>, Set<PartitionAndReplica>> tuple2 = this.controllerContext.onlineAndOfflineReplicas();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Set onlineReplicas = (Set)tuple2._1();
        Set offlineReplicas = (Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)onlineReplicas, (Object)offlineReplicas);
        Tuple2 tuple23 = tuple22;
        Set onlineReplicas2 = (Set)tuple23._1();
        Set offlineReplicas2 = (Set)tuple23._2();
        this.handleStateChanges((Seq<PartitionAndReplica>)onlineReplicas2.toSeq(), OnlineReplica$.MODULE$);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Triggering offline replica state changes");
        this.handleStateChanges((Seq<PartitionAndReplica>)offlineReplicas2.toSeq(), OfflineReplica$.MODULE$);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Started replica state machine with initial state -> ").append($this.controllerContext.replicaStates()).toString());
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped replica state machine");
    }

    private void initializeReplicaState() {
        this.controllerContext.allPartitions().foreach((Function1 & Serializable & scala.Serializable)partition -> {
            ReplicaStateMachine.$anonfun$initializeReplicaState$1(this, partition);
            return BoxedUnit.UNIT;
        });
    }

    public abstract void handleStateChanges(Seq<PartitionAndReplica> var1, ReplicaState var2);

    public static final /* synthetic */ void $anonfun$initializeReplicaState$1(ReplicaStateMachine $this, TopicPartition partition) {
        Seq<Object> replicas = $this.controllerContext.partitionReplicaAssignment(partition);
        replicas.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)replicaId -> {
            PartitionAndReplica partitionAndReplica = new PartitionAndReplica(partition, replicaId);
            if ($this.controllerContext.isReplicaOnline(replicaId, partition, $this.controllerContext.isReplicaOnline$default$3())) {
                $this.controllerContext.putReplicaState(partitionAndReplica, OnlineReplica$.MODULE$);
            } else {
                $this.controllerContext.putReplicaState(partitionAndReplica, ReplicaDeletionIneligible$.MODULE$);
            }
        });
    }

    public ReplicaStateMachine(ControllerContext controllerContext) {
        this.controllerContext = controllerContext;
        Logging.$init$(this);
    }
}

