/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.EndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.AbstractServerThread;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor;
import kafka.network.RequestChannel;
import kafka.network.TooManyConnectionsException;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.utils.KafkaThread;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud!B\u0001\u0003\u0001\u00111!\u0001C!dG\u0016\u0004Ho\u001c:\u000b\u0005\r!\u0011a\u00028fi^|'o\u001b\u0006\u0002\u000b\u0005)1.\u00194lCN\u0019\u0001aB\u0006\u0011\u0005!IQ\"\u0001\u0002\n\u0005)\u0011!\u0001F!cgR\u0014\u0018m\u0019;TKJ4XM\u001d+ie\u0016\fG\r\u0005\u0002\r\u001f5\tQB\u0003\u0002\u000f\t\u00059Q.\u001a;sS\u000e\u001c\u0018B\u0001\t\u000e\u0005EY\u0015MZ6b\u001b\u0016$(/[2t\u000fJ|W\u000f\u001d\u0005\t%\u0001\u0011)\u0019!C\u0001)\u0005AQM\u001c3Q_&tGo\u0001\u0001\u0016\u0003U\u0001\"AF\r\u000e\u0003]Q!\u0001\u0007\u0003\u0002\u000f\rdWo\u001d;fe&\u0011!d\u0006\u0002\t\u000b:$\u0007k\\5oi\"AA\u0004\u0001B\u0001B\u0003%Q#A\u0005f]\u0012\u0004v.\u001b8uA!Aa\u0004\u0001BC\u0002\u0013\u0005q$\u0001\btK:$')\u001e4gKJ\u001c\u0016N_3\u0016\u0003\u0001\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u00121!\u00138u\u0011!9\u0003A!A!\u0002\u0013\u0001\u0013aD:f]\u0012\u0014UO\u001a4feNK'0\u001a\u0011\t\u0011%\u0002!Q1A\u0005\u0002}\taB]3dm\n+hMZ3s'&TX\r\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003!\u0003=\u0011Xm\u0019<Ck\u001a4WM]*ju\u0016\u0004\u0003\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0011\u0002\u0011\t\u0014xn[3s\u0013\u0012D\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001M\u0001\u0011G>tg.Z2uS>t\u0017+^8uCN\u0004\"\u0001C\u0019\n\u0005I\u0012!\u0001E\"p]:,7\r^5p]F+x\u000e^1t\u0011\u0015!\u0004\u0001\"\u00016\u0003\u0019a\u0014N\\5u}Q1ag\u000e\u001d:um\u0002\"\u0001\u0003\u0001\t\u000bI\u0019\u0004\u0019A\u000b\t\u000by\u0019\u0004\u0019\u0001\u0011\t\u000b%\u001a\u0004\u0019\u0001\u0011\t\u000b5\u001a\u0004\u0019\u0001\u0011\t\u000b=\u001a\u0004\u0019\u0001\u0019\t\u000fu\u0002!\u0019!C\u0005}\u0005Ya.[8TK2,7\r^8s+\u0005y\u0004C\u0001!H\u001b\u0005\t%B\u0001\"D\u0003!\u0019\u0007.\u00198oK2\u001c(B\u0001#F\u0003\rq\u0017n\u001c\u0006\u0002\r\u0006!!.\u0019<b\u0013\tA\u0015I\u0001\u0005TK2,7\r^8s\u0011\u0019Q\u0005\u0001)A\u0005\u007f\u0005aa.[8TK2,7\r^8sA!9A\n\u0001b\u0001\n\u0003i\u0015!D:feZ,'o\u00115b]:,G.F\u0001O!\t\u0001u*\u0003\u0002Q\u0003\n\u00192+\u001a:wKJ\u001cvnY6fi\u000eC\u0017M\u001c8fY\"1!\u000b\u0001Q\u0001\n9\u000bab]3sm\u0016\u00148\t[1o]\u0016d\u0007\u0005C\u0004U\u0001\t\u0007I\u0011B+\u0002\u0015A\u0014xnY3tg>\u00148/F\u0001W!\r9FLX\u0007\u00021*\u0011\u0011LW\u0001\b[V$\u0018M\u00197f\u0015\tY&%\u0001\u0006d_2dWm\u0019;j_:L!!\u0018-\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0003\u0011}K!\u0001\u0019\u0002\u0003\u0013A\u0013xnY3tg>\u0014\bB\u00022\u0001A\u0003%a+A\u0006qe>\u001cWm]:peN\u0004\u0003b\u00023\u0001\u0005\u0004%I!Z\u0001\u0012aJ|7-Z:t_J\u001c8\u000b^1si\u0016$W#\u00014\u0011\u0005\u001dtW\"\u00015\u000b\u0005%T\u0017AB1u_6L7M\u0003\u0002lY\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u00055,\u0015\u0001B;uS2L!a\u001c5\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0011\u0019\t\b\u0001)A\u0005M\u0006\u0011\u0002O]8dKN\u001cxN]:Ti\u0006\u0014H/\u001a3!\u0011\u0019\u0019\b\u0001\"\u0001\u0003i\u0006i\u0011\r\u001a3Qe>\u001cWm]:peN$\"!\u001e=\u0011\u0005\u00052\u0018BA<#\u0005\u0011)f.\u001b;\t\u000be\u0014\b\u0019\u0001>\u0002\u001b9,w\u000f\u0015:pG\u0016\u001c8o\u001c:t!\r96PX\u0005\u0003yb\u0013aAQ;gM\u0016\u0014\bB\u0002@\u0001\t\u0003\u0011q0A\bti\u0006\u0014H\u000f\u0015:pG\u0016\u001c8o\u001c:t)\u0005)\bB\u0002@\u0001\t\u0013\t\u0019\u0001F\u0002v\u0003\u000bAq\u0001VA\u0001\u0001\u0004\t9\u0001E\u0003\u0002\n\u0005-a,D\u0001[\u0013\r\tiA\u0017\u0002\u0004'\u0016\f\b\u0002CA\t\u0001\u0011\u0005!!a\u0005\u0002!I,Wn\u001c<f!J|7-Z:t_J\u001cH#B;\u0002\u0016\u0005e\u0001bBA\f\u0003\u001f\u0001\r\u0001I\u0001\fe\u0016lwN^3D_VtG\u000f\u0003\u0005\u0002\u001c\u0005=\u0001\u0019AA\u000f\u00039\u0011X-];fgR\u001c\u0005.\u00198oK2\u00042\u0001CA\u0010\u0013\r\t\tC\u0001\u0002\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0011\u0019\t)\u0003\u0001C!\u007f\u0006A1\u000f[;uI><h\u000e\u0003\u0004\u0002*\u0001!\ta`\u0001\u0004eVt\u0007bBA\u0017\u0001\u0011%\u0011qF\u0001\u0011_B,gnU3sm\u0016\u00148k\\2lKR$RATA\u0019\u0003\u0017B\u0001\"a\r\u0002,\u0001\u0007\u0011QG\u0001\u0005Q>\u001cH\u000f\u0005\u0003\u00028\u0005\u0015c\u0002BA\u001d\u0003\u0003\u00022!a\u000f#\u001b\t\tiDC\u0002\u0002@M\ta\u0001\u0010:p_Rt\u0014bAA\"E\u00051\u0001K]3eK\u001aLA!a\u0012\u0002J\t11\u000b\u001e:j]\u001eT1!a\u0011#\u0011\u001d\ti%a\u000bA\u0002\u0001\nA\u0001]8si\"9\u0011\u0011\u000b\u0001\u0005\u0002\u0005M\u0013AB1dG\u0016\u0004H\u000fF\u0003v\u0003+\ny\u0006\u0003\u0005\u0002X\u0005=\u0003\u0019AA-\u0003\rYW-\u001f\t\u0004\u0001\u0006m\u0013bAA/\u0003\na1+\u001a7fGRLwN\\&fs\"9\u0011\u0011MA(\u0001\u0004q\u0016!\u00039s_\u000e,7o]8s\u0011\u0019\t)\u0007\u0001C\u0001\u007f\u00061q/Y6fkBDC!a\u0019\u0002jA!\u00111NA9\u001b\t\tiGC\u0002\u0002p\u0015\u000bA\u0001\\1oO&!\u00111OA7\u0005!ye/\u001a:sS\u0012,\u0007")
public class Acceptor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private final EndPoint endPoint;
    private final int sendBufferSize;
    private final int recvBufferSize;
    private final int brokerId;
    private final ConnectionQuotas connectionQuotas;
    private final Selector nioSelector;
    private final ServerSocketChannel serverChannel;
    private final ArrayBuffer<Processor> processors;
    private final AtomicBoolean processorsStarted;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    public EndPoint endPoint() {
        return this.endPoint;
    }

    public int sendBufferSize() {
        return this.sendBufferSize;
    }

    public int recvBufferSize() {
        return this.recvBufferSize;
    }

    private Selector nioSelector() {
        return this.nioSelector;
    }

    public ServerSocketChannel serverChannel() {
        return this.serverChannel;
    }

    private ArrayBuffer<Processor> processors() {
        return this.processors;
    }

    private AtomicBoolean processorsStarted() {
        return this.processorsStarted;
    }

    public synchronized void addProcessors(Buffer<Processor> newProcessors) {
        block0: {
            this.processors().$plus$plus$eq(newProcessors);
            if (!this.processorsStarted().get()) break block0;
            this.startProcessors((Seq<Processor>)newProcessors);
        }
    }

    public synchronized void startProcessors() {
        block0: {
            if (this.processorsStarted().getAndSet(true)) break block0;
            this.startProcessors((Seq<Processor>)this.processors());
        }
    }

    private synchronized void startProcessors(Seq<Processor> processors) {
        processors.foreach((Function1 & Serializable & scala.Serializable)processor -> {
            Acceptor.$anonfun$startProcessors$3(this, processor);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void removeProcessors(int removeCount, RequestChannel requestChannel) {
        ArrayBuffer toRemove = (ArrayBuffer)this.processors().takeRight(removeCount);
        this.processors().remove(this.processors().size() - removeCount, removeCount);
        toRemove.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.shutdown();
            return BoxedUnit.UNIT;
        });
        toRemove.foreach((Function1 & Serializable & scala.Serializable)processor -> {
            requestChannel.removeProcessor(processor.id());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        Acceptor acceptor = this;
        synchronized (acceptor) {
            this.processors().foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                x$8.shutdown();
                return BoxedUnit.UNIT;
            });
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.serverChannel().register(this.nioSelector(), 16);
        this.startupComplete();
        try {
            int currentProcessor = 0;
            while (this.isRunning()) {
                try {
                    int ready = this.nioSelector().select(500L);
                    if (ready <= 0) continue;
                    Set<SelectionKey> keys = this.nioSelector().selectedKeys();
                    Iterator<SelectionKey> iter = keys.iterator();
                    while (iter.hasNext() && this.isRunning()) {
                        try {
                            Processor processor;
                            SelectionKey key = iter.next();
                            iter.remove();
                            if (!key.isAcceptable()) throw new IllegalStateException("Unrecognized key state for acceptor thread.");
                            Acceptor acceptor = this;
                            synchronized (acceptor) {
                                processor = (Processor)this.processors().apply(currentProcessor %= this.processors().size());
                            }
                            Processor processor2 = processor;
                            this.accept(key, processor2);
                            ++currentProcessor;
                        }
                        catch (Throwable e) {
                            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while accepting connection", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof ControlThrowable) {
                        ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                        throw (Throwable)controlThrowable;
                    }
                    if (throwable2 == null) throw throwable;
                    Throwable throwable3 = throwable2;
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurred", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable3);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    continue;
                    return;
                }
            }
        }
        finally {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing server socket and selector.");
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.serverChannel().close(), this, Level.ERROR);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.nioSelector().close(), this, Level.ERROR);
            this.shutdownComplete();
        }
    }

    private ServerSocketChannel openServerSocket(String host, int port) {
        InetSocketAddress socketAddress = host == null || host.trim().isEmpty() ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        serverChannel.configureBlocking(false);
        if (this.recvBufferSize() != -1) {
            serverChannel.socket().setReceiveBufferSize(this.recvBufferSize());
        }
        try {
            serverChannel.socket().bind(socketAddress);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Awaiting socket connections on %s:%d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{socketAddress.getHostString(), BoxesRunTime.boxToInteger((int)serverChannel.socket().getLocalPort())})));
        }
        catch (SocketException e) {
            throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("Socket server failed to bind to %s:%d: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{socketAddress.getHostString(), BoxesRunTime.boxToInteger((int)port), e.getMessage()})), (Throwable)e);
        }
        return serverChannel;
    }

    public void accept(SelectionKey key, Processor processor) {
        ServerSocketChannel serverSocketChannel = (ServerSocketChannel)key.channel();
        SocketChannel socketChannel = serverSocketChannel.accept();
        try {
            this.connectionQuotas.inc(socketChannel.socket().getInetAddress());
            socketChannel.configureBlocking(false);
            socketChannel.socket().setTcpNoDelay(true);
            socketChannel.socket().setKeepAlive(true);
            if (this.sendBufferSize() != -1) {
                socketChannel.socket().setSendBufferSize(this.sendBufferSize());
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Accepted connection from %s on %s and assigned it to processor %d, sendBufferSize [actual|requested]: [%d|%d] recvBufferSize [actual|requested]: [%d|%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{socketChannel.socket().getRemoteSocketAddress(), socketChannel.socket().getLocalSocketAddress(), BoxesRunTime.boxToInteger((int)processor.id()), BoxesRunTime.boxToInteger((int)socketChannel.socket().getSendBufferSize()), BoxesRunTime.boxToInteger((int)this.sendBufferSize()), BoxesRunTime.boxToInteger((int)socketChannel.socket().getReceiveBufferSize()), BoxesRunTime.boxToInteger((int)this.recvBufferSize())})));
            processor.accept(socketChannel);
        }
        catch (TooManyConnectionsException e) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Rejected connection from %s, address already has the configured maximum of %d connections.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.ip(), BoxesRunTime.boxToInteger((int)e.count())})));
            this.close(socketChannel);
        }
    }

    @Override
    public void wakeup() {
        this.nioSelector().wakeup();
    }

    public static final /* synthetic */ void $anonfun$startProcessors$3(Acceptor $this, Processor processor) {
        KafkaThread.nonDaemon((String)new StringBuilder(24).append("kafka-network-thread-").append($this.brokerId).append("-").append($this.endPoint().listenerName()).append("-").append($this.endPoint().securityProtocol()).append("-").append(processor.id()).toString(), (Runnable)processor).start();
    }

    public Acceptor(EndPoint endPoint, int sendBufferSize, int recvBufferSize, int brokerId, ConnectionQuotas connectionQuotas) {
        this.endPoint = endPoint;
        this.sendBufferSize = sendBufferSize;
        this.recvBufferSize = recvBufferSize;
        this.brokerId = brokerId;
        this.connectionQuotas = connectionQuotas;
        super(connectionQuotas);
        KafkaMetricsGroup.$init$(this);
        this.nioSelector = Selector.open();
        this.serverChannel = this.openServerSocket(endPoint.host(), endPoint.port());
        this.processors = new ArrayBuffer();
        this.processorsStarted = new AtomicBoolean();
    }
}

