/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientSensors;
import kafka.server.ConfigEntityName$;
import kafka.server.QuotaEntity;
import kafka.server.QuotaId;
import kafka.server.QuotaType;
import kafka.server.QuotaTypes$;
import kafka.server.SensorAccess;
import kafka.server.ThrottledResponse;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.Total;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tee\u0001B\u0001\u0003\u0001\u001d\u0011!c\u00117jK:$\u0018+^8uC6\u000bg.Y4fe*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011U\u0001!Q1A\u0005\nY\taaY8oM&<W#A\f\u0011\u0005aIR\"\u0001\u0002\n\u0005i\u0011!\u0001G\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJ\u001cuN\u001c4jO\"AA\u0004\u0001B\u0001B\u0003%q#A\u0004d_:4\u0017n\u001a\u0011\t\u0011y\u0001!Q1A\u0005\n}\tq!\\3ue&\u001c7/F\u0001!!\t\t#&D\u0001#\u0015\tq2E\u0003\u0002%K\u000511m\\7n_:T!!\u0002\u0014\u000b\u0005\u001dB\u0013AB1qC\u000eDWMC\u0001*\u0003\ry'oZ\u0005\u0003W\t\u0012q!T3ue&\u001c7\u000f\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003!\u0003!iW\r\u001e:jGN\u0004\u0003\u0002C\u0018\u0001\u0005\u000b\u0007I\u0011\u0002\u0019\u0002\u0013E,x\u000e^1UsB,W#A\u0019\u0011\u0005a\u0011\u0014BA\u001a\u0003\u0005%\tVo\u001c;b)f\u0004X\r\u0003\u00056\u0001\t\u0005\t\u0015!\u00032\u0003)\tXo\u001c;b)f\u0004X\r\t\u0005\to\u0001\u0011)\u0019!C\u0005q\u0005!A/[7f+\u0005I\u0004C\u0001\u001e=\u001b\u0005Y$BA\t$\u0013\ti4H\u0001\u0003US6,\u0007\u0002C \u0001\u0005\u0003\u0005\u000b\u0011B\u001d\u0002\u000bQLW.\u001a\u0011\t\u000b\u0005\u0003A\u0011\u0001\"\u0002\rqJg.\u001b;?)\u0015\u0019E)\u0012$H!\tA\u0002\u0001C\u0003\u0016\u0001\u0002\u0007q\u0003C\u0003\u001f\u0001\u0002\u0007\u0001\u0005C\u00030\u0001\u0002\u0007\u0011\u0007C\u00038\u0001\u0002\u0007\u0011\bC\u0004J\u0001\t\u0007I\u0011\u0002&\u0002\u001f=4XM\u001d:jI\u0012,g.U;pi\u0006,\u0012a\u0013\t\u0005\u0019N+\u0006,D\u0001N\u0015\tqu*\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001U)\u0002\tU$\u0018\u000e\u001c\u0006\u0002%\u0006!!.\u0019<b\u0013\t!VJA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u0004\"\u0001\u0007,\n\u0005]\u0013!aB)v_R\f\u0017\n\u001a\t\u0003CeK!A\u0017\u0012\u0003\u000bE+x\u000e^1\t\rq\u0003\u0001\u0015!\u0003L\u0003Ayg/\u001a:sS\u0012$WM\\)v_R\f\u0007\u0005C\u0004_\u0001\t\u0007I\u0011B0\u00023M$\u0018\r^5d\u0007>tg-[4DY&,g\u000e^%e#V|G/Y\u000b\u00021\"1\u0011\r\u0001Q\u0001\na\u000b!d\u001d;bi&\u001c7i\u001c8gS\u001e\u001cE.[3oi&#\u0017+^8uC\u0002Bqa\u0019\u0001A\u0002\u0013%A-A\trk>$\u0018\rV=qKN,e.\u00192mK\u0012,\u0012!\u001a\t\u0003\u0013\u0019L!a\u001a\u0006\u0003\u0007%sG\u000fC\u0004j\u0001\u0001\u0007I\u0011\u00026\u0002+E,x\u000e^1UsB,7/\u00128bE2,Gm\u0018\u0013fcR\u00111N\u001c\t\u0003\u00131L!!\u001c\u0006\u0003\tUs\u0017\u000e\u001e\u0005\b_\"\f\t\u00111\u0001f\u0003\rAH%\r\u0005\u0007c\u0002\u0001\u000b\u0015B3\u0002%E,x\u000e^1UsB,7/\u00128bE2,G\r\t\u0015\u0003aN\u0004\"!\u0003;\n\u0005UT!\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u000f]\u0004!\u0019!C\u0005q\u0006!An\\2l+\u0005I\bC\u0001>~\u001b\u0005Y(B\u0001?N\u0003\u0015awnY6t\u0013\tq8P\u0001\fSK\u0016tGO]1oiJ+\u0017\rZ,sSR,Gj\\2l\u0011\u001d\t\t\u0001\u0001Q\u0001\ne\fQ\u0001\\8dW\u0002B\u0011\"!\u0002\u0001\u0005\u0004%I!a\u0002\u0002\u0015\u0011,G.Y=Rk\u0016,X-\u0006\u0002\u0002\nA)A*a\u0003\u0002\u0010%\u0019\u0011QB'\u0003\u0015\u0011+G.Y=Rk\u0016,X\rE\u0002\u0019\u0003#I1!a\u0005\u0003\u0005E!\u0006N]8ui2,GMU3ta>t7/\u001a\u0005\t\u0003/\u0001\u0001\u0015!\u0003\u0002\n\u0005YA-\u001a7bsF+X-^3!\u0011%\tY\u0002\u0001b\u0001\n\u0013\ti\"\u0001\btK:\u001cxN]!dG\u0016\u001c8o\u001c:\u0016\u0005\u0005}\u0001c\u0001\r\u0002\"%\u0019\u00111\u0005\u0002\u0003\u0019M+gn]8s\u0003\u000e\u001cWm]:\t\u0011\u0005\u001d\u0002\u0001)A\u0005\u0003?\tqb]3og>\u0014\u0018iY2fgN|'\u000f\t\u0005\n\u0003W\u0001!\u0019!C\u0001\u0003[\ta\u0003\u001e5s_R$H.\u001a3SKF,Xm\u001d;SK\u0006\u0004XM]\u000b\u0003\u0003_\u0001B!!\r\u000245\t\u0001A\u0002\u0004\u00026\u0001\u0001\u0011q\u0007\u0002\u0017)\"\u0014x\u000e\u001e;mK\u0012\u0014V-];fgR\u0014V-\u00199feN!\u00111GA\u001d!\ry\u00111H\u0005\u0004\u0003{\u0001\"AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012D1\"!\u0002\u00024\t\u0005\t\u0015!\u0003\u0002\n!9\u0011)a\r\u0005\u0002\u0005\rC\u0003BA\u0018\u0003\u000bB\u0001\"!\u0002\u0002B\u0001\u0007\u0011\u0011\u0002\u0005\t\u0003\u0013\n\u0019\u0004\"\u0011\u0002L\u00051Am\\,pe.$\u0012a\u001b\u0005\t\u0003\u001f\u0002\u0001\u0015!\u0003\u00020\u00059B\u000f\u001b:piRdW\r\u001a*fcV,7\u000f\u001e*fCB,'\u000f\t\u0005\n\u0003'\u0002!\u0019!C\u0005\u0003+\n\u0001\u0003Z3mCf\fV/Z;f'\u0016t7o\u001c:\u0016\u0005\u0005]\u0003cA\u0011\u0002Z%\u0019\u00111\f\u0012\u0003\rM+gn]8s\u0011!\ty\u0006\u0001Q\u0001\n\u0005]\u0013!\u00053fY\u0006L\u0018+^3vKN+gn]8sA!9\u00111\r\u0001\u0005\n\u0005-\u0013!B:uCJ$\bbBA4\u0001\u0011\u0005\u0011\u0011N\u0001\u000ecV|G/Y:F]\u0006\u0014G.\u001a3\u0016\u0005\u0005-\u0004cA\u0005\u0002n%\u0019\u0011q\u000e\u0006\u0003\u000f\t{w\u000e\\3b]\"9\u00111\u000f\u0001\u0005\u0002\u0005U\u0014AF7bs\n,'+Z2pe\u0012\fe\u000e\u001a+ie>$H\u000f\\3\u0015\u0013\u0015\f9(!%\u0002\u0016\u0006}\u0005\u0002CA=\u0003c\u0002\r!a\u001f\u0002\u001bM\fg.\u001b;ju\u0016$Wk]3s!\u0011\ti(a#\u000f\t\u0005}\u0014q\u0011\t\u0004\u0003\u0003SQBAAB\u0015\r\t)IB\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005%%\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001b\u000byI\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0013S\u0001\u0002CAJ\u0003c\u0002\r!a\u001f\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012D\u0001\"a&\u0002r\u0001\u0007\u0011\u0011T\u0001\u0006m\u0006dW/\u001a\t\u0004\u0013\u0005m\u0015bAAO\u0015\t1Ai\\;cY\u0016D\u0001\"!)\u0002r\u0001\u0007\u00111U\u0001\tG\u0006dGNY1dWB)\u0011\"!*fW&\u0019\u0011q\u0015\u0006\u0003\u0013\u0019+hn\u0019;j_:\f\u0004bBAV\u0001\u0011\u0005\u0011QV\u0001\"e\u0016\u001cwN\u001d3B]\u0012$\u0006N]8ui2,wJ\\)v_R\fg+[8mCRLwN\u001c\u000b\bK\u0006=\u0016\u0011XA^\u0011!\t\t,!+A\u0002\u0005M\u0016!D2mS\u0016tGoU3og>\u00148\u000fE\u0002\u0019\u0003kK1!a.\u0003\u00055\u0019E.[3oiN+gn]8sg\"A\u0011qSAU\u0001\u0004\tI\n\u0003\u0005\u0002\"\u0006%\u0006\u0019AAR\u0011\u001d\ty\f\u0001C\u0001\u0003\u0003\f\u0001C]3d_J$gj\u001c+ie>$H\u000f\\3\u0015\u000b-\f\u0019-!2\t\u0011\u0005E\u0016Q\u0018a\u0001\u0003gC\u0001\"a&\u0002>\u0002\u0007\u0011\u0011\u0014\u0005\b\u0003\u0013\u0004A\u0011BAf\u0003-\tXo\u001c;b\u000b:$\u0018\u000e^=\u0015\u0011\u00055\u00171[Ak\u0003/\u00042\u0001GAh\u0013\r\t\tN\u0001\u0002\f#V|G/Y#oi&$\u0018\u0010\u0003\u0005\u0002z\u0005\u001d\u0007\u0019AA>\u0011!\t\u0019*a2A\u0002\u0005m\u0004\u0002CAm\u0003\u000f\u0004\r!a\u001f\u0002#M\fg.\u001b;ju\u0016$7\t\\5f]RLE\rC\u0004\u0002^\u0002!I!a8\u0002EE,x\u000e^1F]RLG/_,ji\"lU\u000f\u001c;ja2,\u0017+^8uC2+g/\u001a7t)!\ti-!9\u0002d\u0006\u0015\b\u0002CA=\u00037\u0004\r!a\u001f\t\u0011\u0005M\u00151\u001ca\u0001\u0003wB\u0001\"a:\u0002\\\u0002\u0007\u00111P\u0001\u0012g\u0006t\u0017\u000e^5{KJ\u001cE.[3oi&#\u0007bBAv\u0001\u0011\u0005\u0011Q^\u0001\u0006cV|G/\u0019\u000b\u00061\u0006=\u00181\u001f\u0005\t\u0003c\fI\u000f1\u0001\u0002|\u0005!Qo]3s\u0011!\t\u0019*!;A\u0002\u0005m\u0004bBA|\u0001\u0011E\u0011\u0011`\u0001\ri\"\u0014x\u000e\u001e;mKRKW.\u001a\u000b\u0007\u0003w\u0014\tAa\u0003\u0011\u0007%\ti0C\u0002\u0002\u0000*\u0011A\u0001T8oO\"A!1AA{\u0001\u0004\u0011)!\u0001\u0007dY&,g\u000e^'fiJL7\rE\u0002\"\u0005\u000fI1A!\u0003#\u0005-Y\u0015MZ6b\u001b\u0016$(/[2\t\u000fU\t)\u00101\u0001\u0003\u000eA\u0019\u0011Ea\u0004\n\u0007\tE!E\u0001\u0007NKR\u0014\u0018nY\"p]\u001aLw\rC\u0004\u0003\u0016\u0001!IAa\u0006\u0002!5,\u0017m];sC\ndW-Q:SCR,GC\u0002B\r\u0005K\u0011\t\u0004\u0005\u0003\u0003\u001c\t\u0005RB\u0001B\u000f\u0015\r\u0011yBI\u0001\u0006gR\fGo]\u0005\u0005\u0005G\u0011iB\u0001\u0003SCR,\u0007\u0002\u0003B\u0014\u0005'\u0001\rA!\u000b\u0002\t9\fW.\u001a\t\u0005\u0005W\u0011i#D\u0001$\u0013\r\u0011yc\t\u0002\u000b\u001b\u0016$(/[2OC6,\u0007\u0002\u0003B\u001a\u0005'\u0001\rA!\u000e\u0002\u00155,\u0017m];sC\ndW\rE\u0002\"\u0005oI1A!\u000f#\u0005)iU-Y:ve\u0006\u0014G.\u001a\u0005\b\u0005{\u0001A\u0011\u0001B \u0003]9W\r^(s\u0007J,\u0017\r^3Rk>$\u0018mU3og>\u00148\u000f\u0006\u0004\u00024\n\u0005#1\t\u0005\t\u0003s\u0012Y\u00041\u0001\u0002|!A\u00111\u0013B\u001e\u0001\u0004\tY\bC\u0004\u0003H\u0001!IA!\u0013\u00023\u001d,G\u000f\u00165s_R$H.\u001a+j[\u0016\u001cVM\\:pe:\u000bW.\u001a\u000b\u0005\u0003w\u0012Y\u0005C\u0004\u0003N\t\u0015\u0003\u0019A+\u0002\u000fE,x\u000e^1JI\"9!\u0011\u000b\u0001\u0005\n\tM\u0013AE4fiF+x\u000e^1TK:\u001cxN\u001d(b[\u0016$B!a\u001f\u0003V!9!Q\nB(\u0001\u0004)\u0006b\u0002B-\u0001\u0011E!1L\u0001\u0015O\u0016$\u0018+^8uC6+GO]5d\u0007>tg-[4\u0015\t\t5!Q\f\u0005\b\u0003W\u00149\u00061\u0001Y\u0011\u001d\u0011\t\u0007\u0001C\t\u0005G\n\u0011cZ3u\u001fJ\u001c%/Z1uKN+gn]8s)\u0019\t9F!\u001a\u0003j!A!q\rB0\u0001\u0004\tY(\u0001\u0006tK:\u001cxN\u001d(b[\u0016D\u0001Ba\u001b\u0003`\u0001\u0007!\u0011F\u0001\u000b[\u0016$(/[2OC6,\u0007b\u0002B8\u0001\u0011\u0005!\u0011O\u0001\fkB$\u0017\r^3Rk>$\u0018\rF\u0005l\u0005g\u0012YH! \u0003\u0000!A\u0011\u0011\u0010B7\u0001\u0004\u0011)\bE\u0003\n\u0005o\nY(C\u0002\u0003z)\u0011aa\u00149uS>t\u0007\u0002CAJ\u0005[\u0002\rA!\u001e\t\u0011\u0005e'Q\u000ea\u0001\u0005kB\u0001\"a;\u0003n\u0001\u0007!\u0011\u0011\t\u0005\u0013\t]\u0004\fC\u0004\u0003\u0006\u0002!\tBa\"\u0002)\rd\u0017.\u001a8u%\u0006$X-T3ue&\u001cg*Y7f)\u0019\u0011IC!#\u0003\f\"A\u0011\u0011\u0010BB\u0001\u0004\tY\b\u0003\u0005\u0002\u0014\n\r\u0005\u0019AA>\u0011\u001d\u0011y\t\u0001C\u0005\u0005#\u000b!\u0003\u001e5s_R$H.Z'fiJL7MT1nKR!!\u0011\u0006BJ\u0011!\tIM!$A\u0002\u00055\u0007b\u0002BL\u0001\u0011\u0005\u00111J\u0001\tg\",H\u000fZ8x]\u0002")
public class ClientQuotaManager
implements Logging {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final QuotaType kafka$server$ClientQuotaManager$$quotaType;
    private final Time time;
    private final ConcurrentHashMap<QuotaId, Quota> overriddenQuota;
    private final Quota staticConfigClientIdQuota;
    private volatile int quotaTypesEnabled;
    private final ReentrantReadWriteLock lock;
    private final DelayQueue<ThrottledResponse> delayQueue;
    private final SensorAccess sensorAccessor;
    private final ThrottledRequestReaper throttledRequestReaper;
    private final Sensor kafka$server$ClientQuotaManager$$delayQueueSensor;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ClientQuotaManager clientQuotaManager = this;
        synchronized (clientQuotaManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    public QuotaType kafka$server$ClientQuotaManager$$quotaType() {
        return this.kafka$server$ClientQuotaManager$$quotaType;
    }

    private Time time() {
        return this.time;
    }

    private ConcurrentHashMap<QuotaId, Quota> overriddenQuota() {
        return this.overriddenQuota;
    }

    private Quota staticConfigClientIdQuota() {
        return this.staticConfigClientIdQuota;
    }

    private int quotaTypesEnabled() {
        return this.quotaTypesEnabled;
    }

    private void quotaTypesEnabled_$eq(int x$1) {
        this.quotaTypesEnabled = x$1;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private DelayQueue<ThrottledResponse> delayQueue() {
        return this.delayQueue;
    }

    private SensorAccess sensorAccessor() {
        return this.sensorAccessor;
    }

    public ThrottledRequestReaper throttledRequestReaper() {
        return this.throttledRequestReaper;
    }

    public Sensor kafka$server$ClientQuotaManager$$delayQueueSensor() {
        return this.kafka$server$ClientQuotaManager$$delayQueueSensor;
    }

    private void start() {
        this.throttledRequestReaper().start();
    }

    public boolean quotasEnabled() {
        return this.quotaTypesEnabled() != QuotaTypes$.MODULE$.NoQuotas();
    }

    public int maybeRecordAndThrottle(String sanitizedUser, String clientId, double value, Function1<Object, BoxedUnit> callback) {
        int n;
        if (this.quotasEnabled()) {
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(sanitizedUser, clientId);
            n = this.recordAndThrottleOnQuotaViolation(clientSensors, value, callback);
        } else {
            int throttleTimeMs = 0;
            callback.apply$mcVI$sp(throttleTimeMs);
            n = throttleTimeMs;
        }
        return n;
    }

    public int recordAndThrottleOnQuotaViolation(ClientSensors clientSensors, double value, Function1<Object, BoxedUnit> callback) {
        int throttleTimeMs = 0;
        try {
            clientSensors.quotaSensor().record(value);
            callback.apply$mcVI$sp(0);
        }
        catch (QuotaViolationException quotaViolationException) {
            QuotaEntity clientQuotaEntity = clientSensors.quotaEntity();
            KafkaMetric clientMetric = (KafkaMetric)this.metrics().metrics().get(this.clientRateMetricName(clientQuotaEntity.sanitizedUser(), clientQuotaEntity.clientId()));
            throttleTimeMs = (int)this.throttleTime(clientMetric, this.getQuotaMetricConfig(clientQuotaEntity.quota()));
            clientSensors.throttleTimeSensor().record((double)throttleTimeMs);
            this.delayQueue().add(new ThrottledResponse(this.time(), throttleTimeMs, callback));
            this.kafka$server$ClientQuotaManager$$delayQueueSensor().record();
            this.logger().debug((Object)new StringOps(Predef$.MODULE$.augmentString("Quota violated for sensor (%s). Delay time: (%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clientSensors.quotaSensor().name(), BoxesRunTime.boxToInteger((int)throttleTimeMs)})));
        }
        return throttleTimeMs;
    }

    public void recordNoThrottle(ClientSensors clientSensors, double value) {
        clientSensors.quotaSensor().record(value, this.time().milliseconds(), false);
    }

    private QuotaEntity quotaEntity(String sanitizedUser, String clientId, String sanitizedClientId) {
        QuotaEntity quotaEntity;
        int n = this.quotaTypesEnabled();
        boolean bl = QuotaTypes$.MODULE$.NoQuotas() == n ? true : QuotaTypes$.MODULE$.ClientIdQuotaEnabled() == n;
        if (bl) {
            QuotaId quotaId = new QuotaId((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)clientId), (Option<String>)new Some((Object)sanitizedClientId));
            Quota quota = this.overriddenQuota().get(quotaId);
            if (quota == null && (quota = this.overriddenQuota().get(ClientQuotaManagerConfig$.MODULE$.DefaultClientIdQuotaId())) == null) {
                quota = this.staticConfigClientIdQuota();
            }
            quotaEntity = new QuotaEntity(quotaId, "", clientId, sanitizedClientId, quota);
        } else if (QuotaTypes$.MODULE$.UserQuotaEnabled() == n) {
            QuotaId quotaId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
            Quota quota = this.overriddenQuota().get(quotaId);
            if (quota == null && (quota = this.overriddenQuota().get(ClientQuotaManagerConfig$.MODULE$.DefaultUserQuotaId())) == null) {
                quota = ClientQuotaManagerConfig$.MODULE$.UnlimitedQuota();
            }
            quotaEntity = new QuotaEntity(quotaId, sanitizedUser, "", "", quota);
        } else if (QuotaTypes$.MODULE$.UserClientIdQuotaEnabled() == n) {
            QuotaId quotaId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)new Some((Object)clientId), (Option<String>)new Some((Object)sanitizedClientId));
            Quota quota = this.overriddenQuota().get(quotaId);
            if (quota == null && (quota = this.overriddenQuota().get(new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default())))) == null && (quota = this.overriddenQuota().get(new QuotaId((Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)clientId), (Option<String>)new Some((Object)sanitizedClientId)))) == null && (quota = this.overriddenQuota().get(ClientQuotaManagerConfig$.MODULE$.DefaultUserClientIdQuotaId())) == null) {
                quota = ClientQuotaManagerConfig$.MODULE$.UnlimitedQuota();
            }
            quotaEntity = new QuotaEntity(quotaId, sanitizedUser, clientId, sanitizedClientId, quota);
        } else {
            quotaEntity = this.quotaEntityWithMultipleQuotaLevels(sanitizedUser, clientId, sanitizedClientId);
        }
        return quotaEntity;
    }

    private QuotaEntity quotaEntityWithMultipleQuotaLevels(String sanitizedUser, String clientId, String sanitizerClientId) {
        QuotaId userClientQuotaId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)new Some((Object)clientId), (Option<String>)new Some((Object)sanitizerClientId));
        QuotaId userQuotaId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        QuotaId clientQuotaId = new QuotaId((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)clientId), (Option<String>)new Some((Object)sanitizerClientId));
        QuotaId quotaId = userClientQuotaId;
        QuotaId quotaConfigId = userClientQuotaId;
        Quota quota = this.overriddenQuota().get(quotaConfigId);
        if (quota == null) {
            quotaId = userClientQuotaId;
            quotaConfigId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
            quota = this.overriddenQuota().get(quotaConfigId);
            if (quota == null) {
                quotaConfigId = quotaId = userQuotaId;
                quota = this.overriddenQuota().get(quotaConfigId);
                if (quota == null) {
                    quotaId = userClientQuotaId;
                    quotaConfigId = new QuotaId((Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)clientId), (Option<String>)new Some((Object)sanitizerClientId));
                    quota = this.overriddenQuota().get(quotaConfigId);
                    if (quota == null) {
                        quotaId = userClientQuotaId;
                        quotaConfigId = new QuotaId((Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
                        quota = this.overriddenQuota().get(quotaConfigId);
                        if (quota == null) {
                            quotaId = userQuotaId;
                            quotaConfigId = new QuotaId((Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
                            quota = this.overriddenQuota().get(quotaConfigId);
                            if (quota == null) {
                                quotaId = clientQuotaId;
                                quotaConfigId = new QuotaId((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)clientId), (Option<String>)new Some((Object)sanitizerClientId));
                                quota = this.overriddenQuota().get(quotaConfigId);
                                if (quota == null) {
                                    quotaId = clientQuotaId;
                                    quotaConfigId = new QuotaId((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
                                    quota = this.overriddenQuota().get(quotaConfigId);
                                    if (quota == null) {
                                        quotaId = clientQuotaId;
                                        quotaConfigId = null;
                                        quota = this.staticConfigClientIdQuota();
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        QuotaId quotaId2 = quotaId;
        QuotaId quotaId3 = clientQuotaId;
        String quotaUser = !(quotaId2 != null ? !((Object)quotaId2).equals(quotaId3) : quotaId3 != null) ? "" : sanitizedUser;
        QuotaId quotaId4 = quotaId;
        QuotaId quotaId5 = userQuotaId;
        String quotaClientId = !(quotaId4 != null ? !((Object)quotaId4).equals(quotaId5) : quotaId5 != null) ? "" : clientId;
        return new QuotaEntity(quotaId, quotaUser, quotaClientId, sanitizerClientId, quota);
    }

    public Quota quota(String user, String clientId) {
        return this.quotaEntity(Sanitizer.sanitize((String)user), clientId, Sanitizer.sanitize((String)clientId)).quota();
    }

    public long throttleTime(KafkaMetric clientMetric, MetricConfig config) {
        Rate rateMetric = this.measurableAsRate(clientMetric.metricName(), clientMetric.measurable());
        Quota quota = config.quota();
        double difference = clientMetric.value() - quota.bound();
        double throttleTimeMs = difference / quota.bound() * (double)rateMetric.windowSize(config, this.time().milliseconds());
        return RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(throttleTimeMs));
    }

    private Rate measurableAsRate(MetricName name, Measurable measurable) {
        Rate rate;
        Measurable measurable2 = measurable;
        if (!(measurable2 instanceof Rate)) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Metric ", " is not a Rate metric, value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, measurable})));
        }
        Rate rate2 = rate = (Rate)measurable2;
        return rate2;
    }

    public ClientSensors getOrCreateQuotaSensors(String sanitizedUser, String clientId) {
        String sanitizedClientId = Sanitizer.sanitize((String)clientId);
        QuotaEntity clientQuotaEntity = this.quotaEntity(sanitizedUser, clientId, sanitizedClientId);
        return new ClientSensors(clientQuotaEntity, this.sensorAccessor().getOrCreate(this.getQuotaSensorName(clientQuotaEntity.quotaId()), ClientQuotaManagerConfig$.MODULE$.InactiveSensorExpirationTimeSeconds(), (Function0<MetricName>)(Function0 & Serializable & scala.Serializable)() -> this.clientRateMetricName(clientQuotaEntity.sanitizedUser(), clientQuotaEntity.clientId()), (Function0<Option<MetricConfig>>)(Function0 & Serializable & scala.Serializable)() -> new Some((Object)this.getQuotaMetricConfig(clientQuotaEntity.quota())), (Function0<MeasurableStat>)(Function0 & Serializable & scala.Serializable)() -> new Rate()), this.sensorAccessor().getOrCreate(this.getThrottleTimeSensorName(clientQuotaEntity.quotaId()), ClientQuotaManagerConfig$.MODULE$.InactiveSensorExpirationTimeSeconds(), (Function0<MetricName>)(Function0 & Serializable & scala.Serializable)() -> this.throttleMetricName(clientQuotaEntity), (Function0<Option<MetricConfig>>)(Function0 & Serializable & scala.Serializable)() -> None$.MODULE$, (Function0<MeasurableStat>)(Function0 & Serializable & scala.Serializable)() -> new Avg()));
    }

    private String getThrottleTimeSensorName(QuotaId quotaId) {
        return Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.kafka$server$ClientQuotaManager$$quotaType()), "ThrottleTime-") + quotaId.sanitizedUser().getOrElse((Function0 & Serializable & scala.Serializable)() -> "") + ':' + quotaId.clientId().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
    }

    private String getQuotaSensorName(QuotaId quotaId) {
        return Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.kafka$server$ClientQuotaManager$$quotaType()), "-") + quotaId.sanitizedUser().getOrElse((Function0 & Serializable & scala.Serializable)() -> "") + ':' + quotaId.clientId().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
    }

    public MetricConfig getQuotaMetricConfig(Quota quota) {
        return new MetricConfig().timeWindow((long)this.config().quotaWindowSizeSeconds(), TimeUnit.SECONDS).samples(this.config().numQuotaSamples()).quota(quota);
    }

    public Sensor getOrCreateSensor(String sensorName, MetricName metricName) {
        return this.sensorAccessor().getOrCreate(sensorName, ClientQuotaManagerConfig$.MODULE$.InactiveSensorExpirationTimeSeconds(), (Function0<MetricName>)(Function0 & Serializable & scala.Serializable)() -> metricName, (Function0<Option<MetricConfig>>)(Function0 & Serializable & scala.Serializable)() -> None$.MODULE$, (Function0<MeasurableStat>)(Function0 & Serializable & scala.Serializable)() -> new Rate());
    }

    /*
     * Unable to fully structure code
     */
    public void updateQuota(Option<String> sanitizedUser, Option<String> clientId, Option<String> sanitizedClientId, Option<Quota> quota) {
        this.lock().writeLock().lock();
        try {
            block28: {
                block23: {
                    block25: {
                        block27: {
                            block26: {
                                block24: {
                                    quotaId = new QuotaId(sanitizedUser, clientId, sanitizedClientId);
                                    var13_6 = false;
                                    var14_7 = null;
                                    var15_8 = sanitizedUser;
                                    if (!(var15_8 instanceof Some)) ** GOTO lbl-1000
                                    var13_6 = true;
                                    var14_7 = (Some)var15_8;
                                    var16_9 = (String)var14_7.value();
                                    v0 = ConfigEntityName$.MODULE$.Default();
                                    var17_10 = var16_9;
                                    if (!(v0 != null ? v0.equals(var17_10) == false : var17_10 != null)) {
                                        var10_11 = "default user ";
                                    } else if (var13_6) {
                                        user = (String)var14_7.value();
                                        var10_11 = "user " + user + " ";
                                    } else if (None$.MODULE$.equals(var15_8)) {
                                        var10_11 = "";
                                    } else {
                                        throw new MatchError(var15_8);
                                    }
                                    userInfo = var10_11;
                                    var20_14 = false;
                                    var21_15 = null;
                                    var22_16 = clientId;
                                    if (!(var22_16 instanceof Some)) ** GOTO lbl-1000
                                    var20_14 = true;
                                    var21_15 = (Some)var22_16;
                                    var23_17 = (String)var21_15.value();
                                    v1 = ConfigEntityName$.MODULE$.Default();
                                    var24_18 = var23_17;
                                    if (!(v1 != null ? v1.equals(var24_18) == false : var24_18 != null)) {
                                        var9_19 = "default client-id";
                                    } else if (var20_14) {
                                        id = (String)var21_15.value();
                                        var9_19 = "client-id " + id;
                                    } else if (None$.MODULE$.equals(var22_16)) {
                                        var9_19 = "";
                                    } else {
                                        throw new MatchError(var22_16);
                                    }
                                    clientIdInfo = var9_19;
                                    var26_22 = quota;
                                    if (!(var26_22 instanceof Some)) break block23;
                                    var27_23 = (Some)var26_22;
                                    newQuota = (Quota)var27_23.value();
                                    this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changing ", " quota for ", "", " to ", ".bound}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$server$ClientQuotaManager$$quotaType(), userInfo, clientIdInfo, newQuota})));
                                    this.overriddenQuota().put(quotaId, newQuota);
                                    var29_25 = new Tuple2(sanitizedUser, clientId);
                                    if (var29_25 == null) break block24;
                                    var30_26 = (Option)var29_25._1();
                                    var31_27 = (Option)var29_25._2();
                                    if (!(var30_26 instanceof Some) || !(var31_27 instanceof Some)) break block24;
                                    this.quotaTypesEnabled_$eq(this.quotaTypesEnabled() | QuotaTypes$.MODULE$.UserClientIdQuotaEnabled());
                                    var8_28 = BoxedUnit.UNIT;
                                    break block25;
                                }
                                if (var29_25 == null) break block26;
                                var32_32 = (Option)var29_25._1();
                                var33_33 = (Option)var29_25._2();
                                if (!(var32_32 instanceof Some) || !None$.MODULE$.equals(var33_33)) break block26;
                                this.quotaTypesEnabled_$eq(this.quotaTypesEnabled() | QuotaTypes$.MODULE$.UserQuotaEnabled());
                                var8_29 = BoxedUnit.UNIT;
                                break block25;
                            }
                            if (var29_25 == null) break block27;
                            var34_34 = (Option)var29_25._1();
                            var35_35 = (Option)var29_25._2();
                            if (!None$.MODULE$.equals(var34_34) || !(var35_35 instanceof Some)) break block27;
                            this.quotaTypesEnabled_$eq(this.quotaTypesEnabled() | QuotaTypes$.MODULE$.ClientIdQuotaEnabled());
                            var8_30 = BoxedUnit.UNIT;
                            break block25;
                        }
                        if (var29_25 == null) ** GOTO lbl-1000
                        var36_36 = (Option)var29_25._1();
                        var37_37 = (Option)var29_25._2();
                        if (None$.MODULE$.equals(var36_36) && None$.MODULE$.equals(var37_37)) {
                            var8_31 = BoxedUnit.UNIT;
                        } else lbl-1000:
                        // 2 sources

                        {
                            throw new MatchError((Object)var29_25);
                        }
                    }
                    var7_38 = BoxedUnit.UNIT;
                    break block28;
                }
                if (None$.MODULE$.equals(var26_22)) {
                    this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing ", " quota for ", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$server$ClientQuotaManager$$quotaType(), userInfo, clientIdInfo})));
                    var7_38 = this.overriddenQuota().remove(quotaId);
                } else {
                    throw new MatchError(var26_22);
                }
            }
            quotaMetricName = this.clientRateMetricName((String)sanitizedUser.getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$updateQuota$1(), ()Ljava/lang/String;)()), (String)clientId.getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$updateQuota$2(), ()Ljava/lang/String;)()));
            allMetrics = this.metrics().metrics();
            var41_41 = this.quotaTypesEnabled();
            var6_42 = QuotaTypes$.MODULE$.NoQuotas() == var41_41 ? true : (QuotaTypes$.MODULE$.ClientIdQuotaEnabled() == var41_41 ? true : (QuotaTypes$.MODULE$.UserQuotaEnabled() == var41_41 ? true : QuotaTypes$.MODULE$.UserClientIdQuotaEnabled() == var41_41));
            var5_43 = var6_42 != false ? sanitizedUser.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$updateQuota$3$adapted(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)()).isDefined() == false && clientId.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$updateQuota$4$adapted(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)()).isDefined() == false : false;
            singleUpdate = var5_43;
            if (singleUpdate) {
                metric = (KafkaMetric)allMetrics.get(quotaMetricName);
                if (metric != null) {
                    metricConfigEntity = this.quotaEntity((String)sanitizedUser.getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$updateQuota$5(), ()Ljava/lang/String;)()), (String)clientId.getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$updateQuota$6(), ()Ljava/lang/String;)()), (String)sanitizedClientId.getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$updateQuota$7(), ()Ljava/lang/String;)()));
                    newQuota = metricConfigEntity.quota();
                    this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sensor for ", "", " already exists. Changing quota to ", " in MetricConfig"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{userInfo, clientIdInfo, BoxesRunTime.boxToDouble((double)newQuota.bound())})));
                    metric.config(this.getQuotaMetricConfig(newQuota));
                }
            } else {
                ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(allMetrics).asScala()).filterKeys((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$updateQuota$8$adapted(org.apache.kafka.common.MetricName org.apache.kafka.common.MetricName ), (Lorg/apache/kafka/common/MetricName;)Ljava/lang/Object;)((MetricName)quotaMetricName)).foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$updateQuota$9$adapted(kafka.server.ClientQuotaManager scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)((ClientQuotaManager)this));
            }
        }
        finally {
            this.lock().writeLock().unlock();
        }
    }

    public MetricName clientRateMetricName(String sanitizedUser, String clientId) {
        return this.metrics().metricName("byte-rate", this.kafka$server$ClientQuotaManager$$quotaType().toString(), "Tracking byte-rate per user/client-id", new String[]{"user", sanitizedUser, "client-id", clientId});
    }

    private MetricName throttleMetricName(QuotaEntity quotaEntity) {
        return this.metrics().metricName("throttle-time", this.kafka$server$ClientQuotaManager$$quotaType().toString(), "Tracking average throttle-time per user/client-id", new String[]{"user", quotaEntity.sanitizedUser(), "client-id", quotaEntity.clientId()});
    }

    public void shutdown() {
        this.throttledRequestReaper().shutdown();
    }

    public static final /* synthetic */ String $anonfun$updateQuota$1() {
        return "";
    }

    public static final /* synthetic */ String $anonfun$updateQuota$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$updateQuota$3(String x$1) {
        String string = x$1;
        String string2 = ConfigEntityName$.MODULE$.Default();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$updateQuota$4(String x$2) {
        String string = x$2;
        String string2 = ConfigEntityName$.MODULE$.Default();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ String $anonfun$updateQuota$5() {
        return "";
    }

    public static final /* synthetic */ String $anonfun$updateQuota$6() {
        return "";
    }

    public static final /* synthetic */ String $anonfun$updateQuota$7() {
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$updateQuota$8(MetricName quotaMetricName$1, MetricName n) {
        String string = n.name();
        String string2 = quotaMetricName$1.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = n.group();
        String string4 = quotaMetricName$1.group();
        if (string3 == null) {
            if (string4 == null) return true;
            return false;
        } else {
            if (!string3.equals(string4)) return false;
            return true;
        }
    }

    public static final /* synthetic */ void $anonfun$updateQuota$9(ClientQuotaManager $this, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            MetricName metricName = (MetricName)tuple2._1();
            KafkaMetric metric = (KafkaMetric)tuple2._2();
            String userTag = metricName.tags().containsKey("user") ? (String)metricName.tags().get("user") : "";
            String clientIdTag = metricName.tags().containsKey("client-id") ? (String)metricName.tags().get("client-id") : "";
            QuotaEntity metricConfigEntity = $this.quotaEntity(userTag, clientIdTag, Sanitizer.sanitize((String)clientIdTag));
            Quota quota = metricConfigEntity.quota();
            Quota quota2 = metric.config().quota();
            if (quota == null ? quota2 != null : !quota.equals(quota2)) {
                Quota newQuota = metricConfigEntity.quota();
                $this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sensor for quota-id ", " already exists. Setting quota to ", " in MetricConfig"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metricConfigEntity.quotaId(), BoxesRunTime.boxToDouble((double)newQuota.bound())})));
                metric.config($this.getQuotaMetricConfig(newQuota));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public ClientQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, QuotaType quotaType, Time time) {
        this.config = config;
        this.metrics = metrics;
        this.kafka$server$ClientQuotaManager$$quotaType = quotaType;
        this.time = time;
        Logging.$init$(this);
        this.overriddenQuota = new ConcurrentHashMap();
        this.staticConfigClientIdQuota = Quota.upperBound((double)config.quotaBytesPerSecondDefault());
        this.quotaTypesEnabled = config.quotaBytesPerSecondDefault() == Long.MAX_VALUE ? QuotaTypes$.MODULE$.NoQuotas() : QuotaTypes$.MODULE$.ClientIdQuotaEnabled();
        this.lock = new ReentrantReadWriteLock();
        this.delayQueue = new DelayQueue();
        this.sensorAccessor = new SensorAccess(this.lock(), metrics);
        this.throttledRequestReaper = new ThrottledRequestReaper(this, this.delayQueue());
        this.kafka$server$ClientQuotaManager$$delayQueueSensor = metrics.sensor(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)quotaType), "-delayQueue"));
        this.kafka$server$ClientQuotaManager$$delayQueueSensor().add(metrics.metricName("queue-size", quotaType.toString(), "Tracks the size of the delay queue"), (MeasurableStat)new Total());
        this.start();
    }

    public static final /* synthetic */ Object $anonfun$updateQuota$3$adapted(String x$1) {
        return BoxesRunTime.boxToBoolean((boolean)ClientQuotaManager.$anonfun$updateQuota$3(x$1));
    }

    public static final /* synthetic */ Object $anonfun$updateQuota$4$adapted(String x$2) {
        return BoxesRunTime.boxToBoolean((boolean)ClientQuotaManager.$anonfun$updateQuota$4(x$2));
    }

    public static final /* synthetic */ Object $anonfun$updateQuota$8$adapted(MetricName quotaMetricName$1, MetricName n) {
        return BoxesRunTime.boxToBoolean((boolean)ClientQuotaManager.$anonfun$updateQuota$8(quotaMetricName$1, n));
    }

    public static final /* synthetic */ Object $anonfun$updateQuota$9$adapted(ClientQuotaManager $this, Tuple2 x0$1) {
        ClientQuotaManager.$anonfun$updateQuota$9($this, x0$1);
        return BoxedUnit.UNIT;
    }

    public class ThrottledRequestReaper
    extends ShutdownableThread {
        private final DelayQueue<ThrottledResponse> delayQueue;
        public final /* synthetic */ ClientQuotaManager $outer;

        @Override
        public void doWork() {
            block0: {
                ThrottledResponse response = (ThrottledResponse)this.delayQueue.poll(1L, TimeUnit.SECONDS);
                if (response == null) break block0;
                this.kafka$server$ClientQuotaManager$ThrottledRequestReaper$$$outer().kafka$server$ClientQuotaManager$$delayQueueSensor().record(-1.0);
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Response throttled for: " + response.throttleTimeMs() + " ms");
                response.execute();
            }
        }

        public /* synthetic */ ClientQuotaManager kafka$server$ClientQuotaManager$ThrottledRequestReaper$$$outer() {
            return this.$outer;
        }

        public ThrottledRequestReaper(ClientQuotaManager $outer, DelayQueue<ThrottledResponse> delayQueue) {
            this.delayQueue = delayQueue;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(new StringOps(Predef$.MODULE$.augmentString("ThrottledRequestReaper-%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$outer.kafka$server$ClientQuotaManager$$quotaType()})), false);
        }
    }
}

