/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.X509TrustManager;
import kafka.admin.BrokerMetadata;
import kafka.api.ApiVersion$;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.api.Request$;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.cluster.Partition;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.security.auth.Acl;
import kafka.security.auth.Authorizer;
import kafka.security.auth.Resource;
import kafka.server.BrokerState;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.server.LogDirFailureChannel;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$;
import kafka.utils.JaasTestUtils$;
import kafka.utils.Logging;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.TestUtils$$anonfun$verifyTopicDeletion$5$;
import kafka.utils.TestUtils$$anonfun$verifyTopicDeletion$6$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.BrokerIdsZNode$;
import kafka.zk.BrokerInfo$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZkVersion$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestSslUtils;
import org.apache.kafka.test.TestUtils;
import org.apache.zookeeper.data.ACL;
import org.junit.Assert;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.collection.parallel.ParIterableLike;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.util.Properties$;

public final class TestUtils$
implements Logging {
    public static final TestUtils$ MODULE$;
    private final Random random;
    private final int RandomPort;
    private final int MockZkPort;
    private final String MockZkConnect;
    private final String SslCertificateCn;
    private final String kafka$utils$TestUtils$$transactionStatusKey;
    private final byte[] kafka$utils$TestUtils$$committedValue;
    private final byte[] kafka$utils$TestUtils$$abortedValue;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new TestUtils$();
    }

    private Logger logger$lzycompute() {
        TestUtils$ testUtils$ = this;
        synchronized (testUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.class.msgWithLogIdent((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public Random random() {
        return this.random;
    }

    public int RandomPort() {
        return this.RandomPort;
    }

    public int MockZkPort() {
        return this.MockZkPort;
    }

    public String MockZkConnect() {
        return this.MockZkConnect;
    }

    public String SslCertificateCn() {
        return this.SslCertificateCn;
    }

    public String kafka$utils$TestUtils$$transactionStatusKey() {
        return this.kafka$utils$TestUtils$$transactionStatusKey;
    }

    public byte[] kafka$utils$TestUtils$$committedValue() {
        return this.kafka$utils$TestUtils$$committedValue;
    }

    public byte[] kafka$utils$TestUtils$$abortedValue() {
        return this.kafka$utils$TestUtils$$abortedValue;
    }

    public File tempDir() {
        return TestUtils.tempDirectory();
    }

    public String tempTopic() {
        return new StringBuilder().append((Object)"testTopic").append((Object)BoxesRunTime.boxToInteger((int)this.random().nextInt(1000000))).toString();
    }

    public File tempRelativeDir(String parent) {
        File parentFile = new File(parent);
        parentFile.mkdirs();
        return TestUtils.tempDirectory((Path)parentFile.toPath(), null);
    }

    /*
     * WARNING - void declaration
     */
    public File randomPartitionLogDir(File parentDir) {
        void var3_3;
        int attempts = 1000;
        File f = (File)scala.package$.MODULE$.Iterator().continually((Function0)new Serializable(parentDir){
            public static final long serialVersionUID = 0L;
            private final File parentDir$1;

            public final File apply() {
                return new File(this.parentDir$1, new StringBuilder().append((Object)"kafka-").append((Object)BoxesRunTime.boxToInteger((int)TestUtils$.MODULE$.random().nextInt(1000000))).toString());
            }
            {
                this.parentDir$1 = parentDir$1;
            }
        }).take(attempts).find((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$1) {
                return x$1.mkdir();
            }
        }).getOrElse((Function0)new Serializable(attempts){
            public static final long serialVersionUID = 0L;
            private final int attempts$1;

            public final Nothing$ apply() {
                return scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to create directory after ", " attempts"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.attempts$1)})));
            }
            {
                this.attempts$1 = attempts$1;
            }
        });
        f.deleteOnExit();
        return var3_3;
    }

    public File tempFile() {
        return TestUtils.tempFile();
    }

    public FileChannel tempChannel() {
        return FileChannel.open(this.tempFile().toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);
    }

    /*
     * WARNING - void declaration
     */
    public KafkaServer createServer(KafkaConfig config, Time time) {
        void var3_3;
        KafkaServer server = new KafkaServer(config, time, KafkaServer$.MODULE$.$lessinit$greater$default$3(), KafkaServer$.MODULE$.$lessinit$greater$default$4());
        server.startup();
        return var3_3;
    }

    public Time createServer$default$2() {
        return Time.SYSTEM;
    }

    public int boundPort(KafkaServer server, SecurityProtocol securityProtocol) {
        return server.boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol));
    }

    public SecurityProtocol boundPort$default$2() {
        return SecurityProtocol.PLAINTEXT;
    }

    public Broker createBroker(int id, String host, int port, SecurityProtocol securityProtocol) {
        return new Broker(id, host, port, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol);
    }

    public SecurityProtocol createBroker$default$4() {
        return SecurityProtocol.PLAINTEXT;
    }

    public Seq<Properties> createBrokerConfigs(int numConfigs, String zkConnect, boolean enableControlledShutdown, boolean enableDeleteTopic, Option<SecurityProtocol> interBrokerSecurityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, boolean enablePlaintext, boolean enableSsl, boolean enableSaslPlaintext, boolean enableSaslSsl, Map<Object, String> rackInfo, int logDirCount, boolean enableToken) {
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numConfigs).map((Function1)new Serializable(zkConnect, enableControlledShutdown, enableDeleteTopic, interBrokerSecurityProtocol, trustStoreFile, saslProperties, enablePlaintext, enableSsl, enableSaslPlaintext, enableSaslSsl, rackInfo, logDirCount, enableToken){
            public static final long serialVersionUID = 0L;
            private final String zkConnect$1;
            private final boolean enableControlledShutdown$1;
            private final boolean enableDeleteTopic$1;
            private final Option interBrokerSecurityProtocol$1;
            private final Option trustStoreFile$1;
            private final Option saslProperties$1;
            private final boolean enablePlaintext$1;
            private final boolean enableSsl$1;
            private final boolean enableSaslPlaintext$1;
            private final boolean enableSaslSsl$1;
            private final Map rackInfo$1;
            private final int logDirCount$1;
            private final boolean enableToken$1;

            public final Properties apply(int node) {
                int x$27 = node;
                String x$28 = this.zkConnect$1;
                boolean x$29 = this.enableControlledShutdown$1;
                boolean x$30 = this.enableDeleteTopic$1;
                int x$31 = TestUtils$.MODULE$.RandomPort();
                Option x$32 = this.interBrokerSecurityProtocol$1;
                Option x$33 = this.trustStoreFile$1;
                Option x$34 = this.saslProperties$1;
                boolean x$35 = this.enablePlaintext$1;
                boolean x$36 = this.enableSsl$1;
                boolean x$37 = this.enableSaslPlaintext$1;
                boolean x$38 = this.enableSaslSsl$1;
                Option x$39 = this.rackInfo$1.get((Object)BoxesRunTime.boxToInteger((int)node));
                int x$40 = this.logDirCount$1;
                boolean x$41 = this.enableToken$1;
                int x$42 = TestUtils$.MODULE$.createBrokerConfig$default$11();
                int x$43 = TestUtils$.MODULE$.createBrokerConfig$default$13();
                int x$44 = TestUtils$.MODULE$.createBrokerConfig$default$15();
                return TestUtils$.MODULE$.createBrokerConfig(x$27, x$28, x$29, x$30, x$31, (Option<SecurityProtocol>)x$32, (Option<File>)x$33, (Option<Properties>)x$34, x$35, x$37, x$42, x$36, x$43, x$38, x$44, (Option<String>)x$39, x$40, x$41);
            }
            {
                this.zkConnect$1 = zkConnect$1;
                this.enableControlledShutdown$1 = enableControlledShutdown$1;
                this.enableDeleteTopic$1 = enableDeleteTopic$1;
                this.interBrokerSecurityProtocol$1 = interBrokerSecurityProtocol$1;
                this.trustStoreFile$1 = trustStoreFile$1;
                this.saslProperties$1 = saslProperties$1;
                this.enablePlaintext$1 = enablePlaintext$1;
                this.enableSsl$1 = enableSsl$1;
                this.enableSaslPlaintext$1 = enableSaslPlaintext$1;
                this.enableSaslSsl$1 = enableSaslSsl$1;
                this.rackInfo$1 = rackInfo$1;
                this.logDirCount$1 = logDirCount$1;
                this.enableToken$1 = enableToken$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    public String getBrokerListStrFromServers(Seq<KafkaServer> servers, SecurityProtocol protocol) {
        return ((TraversableOnce)servers.map((Function1)new Serializable(protocol){
            public static final long serialVersionUID = 0L;
            public final SecurityProtocol protocol$1;

            public final String apply(KafkaServer s) {
                EndPoint listener = (EndPoint)s.config().advertisedListeners().find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.getBrokerListStrFromServers.1 $outer;

                    public final boolean apply(EndPoint x$2) {
                        SecurityProtocol securityProtocol = x$2.securityProtocol();
                        SecurityProtocol securityProtocol2 = this.$outer.protocol$1;
                        return !(securityProtocol != null ? !securityProtocol.equals(securityProtocol2) : securityProtocol2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.getBrokerListStrFromServers.1 $outer;

                    public final Nothing$ apply() {
                        return scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find listener with security protocol ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.protocol$1})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return Utils.formatAddress((String)listener.host(), (Integer)Predef$.MODULE$.int2Integer(TestUtils$.MODULE$.boundPort(s, this.protocol$1)));
            }
            {
                this.protocol$1 = protocol$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    public SecurityProtocol getBrokerListStrFromServers$default$2() {
        return SecurityProtocol.PLAINTEXT;
    }

    public String bootstrapServers(Seq<KafkaServer> servers, ListenerName listenerName) {
        return ((TraversableOnce)servers.map((Function1)new Serializable(listenerName){
            public static final long serialVersionUID = 0L;
            public final ListenerName listenerName$1;

            public final String apply(KafkaServer s) {
                EndPoint listener = (EndPoint)s.config().advertisedListeners().find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.bootstrapServers.1 $outer;

                    public final boolean apply(EndPoint x$3) {
                        ListenerName listenerName = x$3.listenerName();
                        ListenerName listenerName2 = this.$outer.listenerName$1;
                        return !(listenerName != null ? !listenerName.equals(listenerName2) : listenerName2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.bootstrapServers.1 $outer;

                    public final Nothing$ apply() {
                        return scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find listener with name ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.listenerName$1.value()})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return Utils.formatAddress((String)listener.host(), (Integer)Predef$.MODULE$.int2Integer(s.boundPort(this.listenerName$1)));
            }
            {
                this.listenerName$1 = listenerName$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    public void shutdownServers(Seq<KafkaServer> servers) {
        ((ParIterableLike)servers.par()).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer s) {
                s.shutdown();
                CoreUtils$.MODULE$.delete(s.config().logDirs());
            }
        });
    }

    public Properties createBrokerConfig(int nodeId, String zkConnect, boolean enableControlledShutdown, boolean enableDeleteTopic, int port, Option<SecurityProtocol> interBrokerSecurityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, boolean enablePlaintext, boolean enableSaslPlaintext, int saslPlaintextPort, boolean enableSsl, int sslPort, boolean enableSaslSsl, int saslSslPort, Option<String> rack, int logDirCount, boolean enableToken) {
        Object object;
        ArrayBuffer protocolAndPorts = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Object object2 = enablePlaintext || this.shouldEnable$1(SecurityProtocol.PLAINTEXT, interBrokerSecurityProtocol) ? protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.PLAINTEXT), (Object)BoxesRunTime.boxToInteger((int)port))) : BoxedUnit.UNIT;
        Object object3 = enableSsl || this.shouldEnable$1(SecurityProtocol.SSL, interBrokerSecurityProtocol) ? protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.SSL), (Object)BoxesRunTime.boxToInteger((int)sslPort))) : BoxedUnit.UNIT;
        Object object4 = enableSaslPlaintext || this.shouldEnable$1(SecurityProtocol.SASL_PLAINTEXT, interBrokerSecurityProtocol) ? protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.SASL_PLAINTEXT), (Object)BoxesRunTime.boxToInteger((int)saslPlaintextPort))) : BoxedUnit.UNIT;
        Object object5 = enableSaslSsl || this.shouldEnable$1(SecurityProtocol.SASL_SSL, interBrokerSecurityProtocol) ? protocolAndPorts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityProtocol.SASL_SSL), (Object)BoxesRunTime.boxToInteger((int)saslSslPort))) : BoxedUnit.UNIT;
        String listeners = ((TraversableOnce)protocolAndPorts.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<SecurityProtocol, Object> x0$1) {
                Tuple2<SecurityProtocol, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    SecurityProtocol protocol = (SecurityProtocol)tuple2._1();
                    int port = tuple2._2$mcI$sp();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "://localhost:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{protocol.name, BoxesRunTime.boxToInteger((int)port)}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).mkString(",");
        Properties props = new Properties();
        Object object6 = nodeId >= 0 ? props.put(KafkaConfig$.MODULE$.BrokerIdProp(), ((Object)BoxesRunTime.boxToInteger((int)nodeId)).toString()) : BoxedUnit.UNIT;
        props.put(KafkaConfig$.MODULE$.ListenersProp(), listeners);
        if (logDirCount > 1) {
            String logDirs = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), logDirCount).toList().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Comparable<? extends Comparable<? extends Object>> apply(int i) {
                    return i % 2 == 0 ? TestUtils$.MODULE$.tempDir().getAbsolutePath() : TestUtils$.MODULE$.tempRelativeDir("data");
                }
            }, List$.MODULE$.canBuildFrom())).mkString(",");
            object = props.put(KafkaConfig$.MODULE$.LogDirsProp(), logDirs);
        } else {
            object = props.put(KafkaConfig$.MODULE$.LogDirProp(), this.tempDir().getAbsolutePath());
        }
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), zkConnect);
        props.put(KafkaConfig$.MODULE$.ZkConnectionTimeoutMsProp(), "10000");
        props.put(KafkaConfig$.MODULE$.ReplicaSocketTimeoutMsProp(), "1500");
        props.put(KafkaConfig$.MODULE$.ControllerSocketTimeoutMsProp(), "1500");
        props.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)enableControlledShutdown)).toString());
        props.put(KafkaConfig$.MODULE$.DeleteTopicEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)enableDeleteTopic)).toString());
        props.put(KafkaConfig$.MODULE$.LogDeleteDelayMsProp(), "1000");
        props.put(KafkaConfig$.MODULE$.ControlledShutdownRetryBackoffMsProp(), "100");
        props.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), "2097152");
        props.put(KafkaConfig$.MODULE$.LogMessageTimestampDifferenceMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        props.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "1");
        Object object7 = props.containsKey(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp()) ? BoxedUnit.UNIT : props.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "5");
        Object object8 = props.containsKey(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp()) ? BoxedUnit.UNIT : props.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        rack.foreach((Function1)new Serializable(props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Object apply(String x$5) {
                return this.props$1.put(KafkaConfig$.MODULE$.RackProp(), x$5);
            }
            {
                this.props$1 = props$1;
            }
        });
        if (protocolAndPorts.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<SecurityProtocol, Object> x0$2) {
                Tuple2<SecurityProtocol, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    SecurityProtocol protocol = (SecurityProtocol)tuple2._1();
                    boolean bl = TestUtils$.MODULE$.usesSslTransportLayer(protocol);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })) {
            Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(this.sslConfigs(Mode.SERVER, false, trustStoreFile, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"server", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)nodeId)})), this.sslConfigs$default$5()));
        }
        if (protocolAndPorts.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<SecurityProtocol, Object> x0$3) {
                Tuple2<SecurityProtocol, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    SecurityProtocol protocol = (SecurityProtocol)tuple2._1();
                    boolean bl = TestUtils$.MODULE$.usesSaslAuthentication(protocol);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })) {
            Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(JaasTestUtils$.MODULE$.saslConfigs(saslProperties));
        }
        interBrokerSecurityProtocol.foreach((Function1)new Serializable(props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Object apply(SecurityProtocol protocol) {
                return this.props$1.put(KafkaConfig$.MODULE$.InterBrokerSecurityProtocolProp(), protocol.name);
            }
            {
                this.props$1 = props$1;
            }
        });
        Object object9 = enableToken ? props.put(KafkaConfig$.MODULE$.DelegationTokenMasterKeyProp(), "masterkey") : BoxedUnit.UNIT;
        return props;
    }

    public boolean createBrokerConfigs$default$3() {
        return true;
    }

    public boolean createBrokerConfigs$default$4() {
        return true;
    }

    public Option<SecurityProtocol> createBrokerConfigs$default$5() {
        return None$.MODULE$;
    }

    public Option<File> createBrokerConfigs$default$6() {
        return None$.MODULE$;
    }

    public Option<Properties> createBrokerConfigs$default$7() {
        return None$.MODULE$;
    }

    public boolean createBrokerConfigs$default$8() {
        return true;
    }

    public boolean createBrokerConfigs$default$9() {
        return false;
    }

    public boolean createBrokerConfigs$default$10() {
        return false;
    }

    public boolean createBrokerConfigs$default$11() {
        return false;
    }

    public Map<Object, String> createBrokerConfigs$default$12() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public int createBrokerConfigs$default$13() {
        return 1;
    }

    public boolean createBrokerConfigs$default$14() {
        return false;
    }

    public boolean createBrokerConfig$default$3() {
        return true;
    }

    public boolean createBrokerConfig$default$4() {
        return true;
    }

    public int createBrokerConfig$default$5() {
        return this.RandomPort();
    }

    public Option<SecurityProtocol> createBrokerConfig$default$6() {
        return None$.MODULE$;
    }

    public Option<File> createBrokerConfig$default$7() {
        return None$.MODULE$;
    }

    public Option<Properties> createBrokerConfig$default$8() {
        return None$.MODULE$;
    }

    public boolean createBrokerConfig$default$9() {
        return true;
    }

    public boolean createBrokerConfig$default$10() {
        return false;
    }

    public int createBrokerConfig$default$11() {
        return this.RandomPort();
    }

    public boolean createBrokerConfig$default$12() {
        return false;
    }

    public int createBrokerConfig$default$13() {
        return this.RandomPort();
    }

    public boolean createBrokerConfig$default$14() {
        return false;
    }

    public int createBrokerConfig$default$15() {
        return this.RandomPort();
    }

    public Option<String> createBrokerConfig$default$16() {
        return None$.MODULE$;
    }

    public int createBrokerConfig$default$17() {
        return 1;
    }

    public boolean createBrokerConfig$default$18() {
        return false;
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(KafkaZkClient zkClient, String topic, int numPartitions, int replicationFactor, Seq<KafkaServer> servers, Properties topicConfig) {
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        adminZkClient.createTopic(topic, numPartitions, replicationFactor, topicConfig, adminZkClient.createTopic$default$5());
        return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1)new Serializable(zkClient, topic, servers){
            public static final long serialVersionUID = 0L;
            private final KafkaZkClient zkClient$4;
            private final String topic$2;
            private final Seq servers$3;

            public final Tuple2<Object, Object> apply(int i) {
                TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers$3, this.topic$2, i, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)i)), (Object)BoxesRunTime.boxToInteger((int)TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient$4, this.topic$2, i, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6())));
            }
            {
                this.zkClient$4 = zkClient$4;
                this.topic$2 = topic$2;
                this.servers$3 = servers$3;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(KafkaZkClient zkClient, String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Seq<KafkaServer> servers) {
        return this.createTopic(zkClient, topic, partitionReplicaAssignment, servers, new Properties());
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(KafkaZkClient zkClient, String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Seq<KafkaServer> servers, Properties topicConfig) {
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        adminZkClient.createOrUpdateTopicPartitionAssignmentPathInZK(topic, partitionReplicaAssignment, topicConfig, adminZkClient.createOrUpdateTopicPartitionAssignmentPathInZK$default$4());
        return ((TraversableOnce)partitionReplicaAssignment.keySet().map((Function1)new Serializable(zkClient, topic, servers){
            public static final long serialVersionUID = 0L;
            private final KafkaZkClient zkClient$3;
            private final String topic$1;
            private final Seq servers$2;

            public final Tuple2<Object, Object> apply(int x0$4) {
                int n = x0$4;
                TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers$2, this.topic$1, n, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)n)), (Object)BoxesRunTime.boxToInteger((int)TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient$3, this.topic$1, n, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6())));
                return tuple2;
            }
            {
                this.zkClient$3 = zkClient$3;
                this.topic$1 = topic$1;
                this.servers$2 = servers$2;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public int createTopic$default$3() {
        return 1;
    }

    public int createTopic$default$4() {
        return 1;
    }

    public Properties createTopic$default$6() {
        return new Properties();
    }

    public void createOffsetsTopic(KafkaZkClient zkClient, Seq<KafkaServer> servers) {
        KafkaServer server = (KafkaServer)servers.head();
        this.createTopic(zkClient, "__consumer_offsets", Predef$.MODULE$.Integer2int(server.config().getInt(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp())), Predef$.MODULE$.Short2short(server.config().getShort(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp())), servers, server.groupCoordinator().offsetsTopicConfigs());
    }

    public Nothing$ fail(String msg) {
        throw new AssertionError((Object)msg);
    }

    public MemoryRecords singletonRecords(byte[] value, byte[] key, CompressionType codec, long timestamp, byte magicValue) {
        return this.records((Iterable<SimpleRecord>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord(timestamp, key, value)}))), magicValue, codec, this.records$default$4(), this.records$default$5(), this.records$default$6(), this.records$default$7(), this.records$default$8());
    }

    public byte[] singletonRecords$default$2() {
        return null;
    }

    public CompressionType singletonRecords$default$3() {
        return CompressionType.NONE;
    }

    public long singletonRecords$default$4() {
        return -1L;
    }

    public byte singletonRecords$default$5() {
        return 2;
    }

    public MemoryRecords recordsWithValues(byte magicValue, CompressionType codec, Seq<byte[]> values) {
        return this.records((Iterable<SimpleRecord>)((Iterable)values.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SimpleRecord apply(byte[] value) {
                return new SimpleRecord(value);
            }
        }, Seq$.MODULE$.canBuildFrom())), magicValue, codec, this.records$default$4(), this.records$default$5(), this.records$default$6(), this.records$default$7(), this.records$default$8());
    }

    public MemoryRecords records(Iterable<SimpleRecord> records2, byte magicValue, CompressionType codec, long producerId, short producerEpoch, int sequence, long baseOffset, int partitionLeaderEpoch) {
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(records2).asJava())));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)baseOffset, (long)System.currentTimeMillis(), (long)producerId, (short)producerEpoch, (int)sequence, (boolean)false, (int)partitionLeaderEpoch);
        records2.foreach((Function1)new Serializable(builder){
            public static final long serialVersionUID = 0L;
            private final MemoryRecordsBuilder builder$1;

            public final Long apply(SimpleRecord x$1) {
                return this.builder$1.append(x$1);
            }
            {
                this.builder$1 = builder$1;
            }
        });
        return builder.build();
    }

    public byte records$default$2() {
        return 2;
    }

    public CompressionType records$default$3() {
        return CompressionType.NONE;
    }

    public long records$default$4() {
        return -1L;
    }

    public short records$default$5() {
        return -1;
    }

    public int records$default$6() {
        return -1;
    }

    public long records$default$7() {
        return 0L;
    }

    public int records$default$8() {
        return -1;
    }

    public byte[] randomBytes(int numBytes) {
        return TestUtils.randomBytes((int)numBytes);
    }

    public String randomString(int len) {
        return TestUtils.randomString((int)len);
    }

    public void checkEquals(ByteBuffer b1, ByteBuffer b2) {
        Assert.assertEquals((String)"Buffers should have equal length", (long)(b1.limit() - b1.position()), (long)(b2.limit() - b2.position()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), b1.limit() - b1.position()).foreach$mVc$sp((Function1)new Serializable(b1, b2){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer b1$1;
            private final ByteBuffer b2$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((String)new StringBuilder().append((Object)"byte ").append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)" byte not equal.").toString(), (long)this.b1$1.get(this.b1$1.position() + i), (long)this.b2$1.get(this.b1$1.position() + i));
            }
            {
                this.b1$1 = b1$1;
                this.b2$1 = b2$1;
            }
        });
    }

    public <T> void checkEquals(Iterator<T> expected, Iterator<T> actual) {
        int length = 0;
        while (expected.hasNext() && actual.hasNext()) {
            ++length;
            Assert.assertEquals((Object)expected.next(), (Object)actual.next());
        }
        if (expected.hasNext()) {
            int length1 = length;
            while (expected.hasNext()) {
                expected.next();
                ++length1;
            }
            Assert.assertFalse((String)new StringBuilder().append((Object)"Iterators have uneven length-- first has more: ").append((Object)BoxesRunTime.boxToInteger((int)length1)).append((Object)" > ").append((Object)BoxesRunTime.boxToInteger((int)length)).toString(), (boolean)true);
        }
        if (actual.hasNext()) {
            int length2 = length;
            while (actual.hasNext()) {
                actual.next();
                ++length2;
            }
            Assert.assertFalse((String)new StringBuilder().append((Object)"Iterators have uneven length-- second has more: ").append((Object)BoxesRunTime.boxToInteger((int)length2)).append((Object)" > ").append((Object)BoxesRunTime.boxToInteger((int)length)).toString(), (boolean)true);
        }
    }

    public <T> void checkLength(Iterator<T> s1, int expectedLength) {
        int n = 0;
        while (s1.hasNext()) {
            ++n;
            s1.next();
        }
        Assert.assertEquals((long)expectedLength, (long)n);
    }

    public <T> void checkEquals(java.util.Iterator<T> s1, java.util.Iterator<T> s2) {
        while (s1.hasNext() && s2.hasNext()) {
            Assert.assertEquals(s1.next(), s2.next());
        }
        Assert.assertFalse((String)"Iterators have uneven length--first has more", (boolean)s1.hasNext());
        Assert.assertFalse((String)"Iterators have uneven length--second has more", (boolean)s2.hasNext());
    }

    public <T> Iterator<T> stackedIterator(Seq<Iterator<T>> s) {
        return new Iterator<T>(s){
            private Iterator<T> cur;
            private final Iterator<Iterator<T>> topIterator;

            public Iterator<T> seq() {
                return Iterator.class.seq((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.class.isEmpty((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.class.isTraversableAgain((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.class.hasDefiniteSize((Iterator)this);
            }

            public Iterator<T> take(int n) {
                return Iterator.class.take((Iterator)this, (int)n);
            }

            public Iterator<T> drop(int n) {
                return Iterator.class.drop((Iterator)this, (int)n);
            }

            public Iterator<T> slice(int from, int until) {
                return Iterator.class.slice((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<T, B> f) {
                return Iterator.class.map((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.class.$plus$plus((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<T, GenTraversableOnce<B>> f) {
                return Iterator.class.flatMap((Iterator)this, f);
            }

            public Iterator<T> filter(Function1<T, Object> p) {
                return Iterator.class.filter((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<T, B, Object> p) {
                return Iterator.class.corresponds((Iterator)this, that, p);
            }

            public Iterator<T> withFilter(Function1<T, Object> p) {
                return Iterator.class.withFilter((Iterator)this, p);
            }

            public Iterator<T> filterNot(Function1<T, Object> p) {
                return Iterator.class.filterNot((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<T, B> pf) {
                return Iterator.class.collect((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, T, B> op) {
                return Iterator.class.scanLeft((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<T, B, B> op) {
                return Iterator.class.scanRight((Iterator)this, z, op);
            }

            public Iterator<T> takeWhile(Function1<T, Object> p) {
                return Iterator.class.takeWhile((Iterator)this, p);
            }

            public Tuple2<Iterator<T>, Iterator<T>> partition(Function1<T, Object> p) {
                return Iterator.class.partition((Iterator)this, p);
            }

            public Tuple2<Iterator<T>, Iterator<T>> span(Function1<T, Object> p) {
                return Iterator.class.span((Iterator)this, p);
            }

            public Iterator<T> dropWhile(Function1<T, Object> p) {
                return Iterator.class.dropWhile((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<T, B>> zip(Iterator<B> that) {
                return Iterator.class.zip((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.class.padTo((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<T, Object>> zipWithIndex() {
                return Iterator.class.zipWithIndex((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<T, U> f) {
                Iterator.class.foreach((Iterator)this, f);
            }

            public boolean forall(Function1<T, Object> p) {
                return Iterator.class.forall((Iterator)this, p);
            }

            public boolean exists(Function1<T, Object> p) {
                return Iterator.class.exists((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.class.contains((Iterator)this, (Object)elem);
            }

            public Option<T> find(Function1<T, Object> p) {
                return Iterator.class.find((Iterator)this, p);
            }

            public int indexWhere(Function1<T, Object> p) {
                return Iterator.class.indexWhere((Iterator)this, p);
            }

            public <B> int indexOf(B elem) {
                return Iterator.class.indexOf((Iterator)this, elem);
            }

            public BufferedIterator<T> buffered() {
                return Iterator.class.buffered((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size2) {
                return Iterator.class.grouped((Iterator)this, (int)size2);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size2, int step) {
                return Iterator.class.sliding((Iterator)this, (int)size2, (int)step);
            }

            public int length() {
                return Iterator.class.length((Iterator)this);
            }

            public Tuple2<Iterator<T>, Iterator<T>> duplicate() {
                return Iterator.class.duplicate((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start2, int len) {
                Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start2, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.class.sameElements((Iterator)this, that);
            }

            public Traversable<T> toTraversable() {
                return Iterator.class.toTraversable((Iterator)this);
            }

            public Iterator<T> toIterator() {
                return Iterator.class.toIterator((Iterator)this);
            }

            public Stream<T> toStream() {
                return Iterator.class.toStream((Iterator)this);
            }

            public String toString() {
                return Iterator.class.toString((Iterator)this);
            }

            public <B> int sliding$default$2() {
                return Iterator.class.sliding$default$2((Iterator)this);
            }

            public List<T> reversed() {
                return TraversableOnce.class.reversed((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.class.size((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.class.nonEmpty((TraversableOnce)this);
            }

            public int count(Function1<T, Object> p) {
                return TraversableOnce.class.count((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<T, B> pf) {
                return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, T, B> op) {
                return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<T, B, B> op) {
                return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, T, B> op) {
                return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<T, B, B> op) {
                return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, T, B> op) {
                return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<T, B, B> op) {
                return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, T, B> op) {
                return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<T, B, B> op) {
                return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, T, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.class.product((TraversableOnce)this, num);
            }

            public <B> T min(Ordering<B> cmp) {
                return (T)TraversableOnce.class.min((TraversableOnce)this, cmp);
            }

            public <B> T max(Ordering<B> cmp) {
                return (T)TraversableOnce.class.max((TraversableOnce)this, cmp);
            }

            public <B> T maxBy(Function1<T, B> f, Ordering<B> cmp) {
                return (T)TraversableOnce.class.maxBy((TraversableOnce)this, f, cmp);
            }

            public <B> T minBy(Function1<T, B> f, Ordering<B> cmp) {
                return (T)TraversableOnce.class.minBy((TraversableOnce)this, f, cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start2) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start2);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
            }

            public List<T> toList() {
                return TraversableOnce.class.toList((TraversableOnce)this);
            }

            public Iterable<T> toIterable() {
                return TraversableOnce.class.toIterable((TraversableOnce)this);
            }

            public Seq<T> toSeq() {
                return TraversableOnce.class.toSeq((TraversableOnce)this);
            }

            public IndexedSeq<T> toIndexedSeq() {
                return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.class.toBuffer((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.class.toSet((TraversableOnce)this);
            }

            public Vector<T> toVector() {
                return TraversableOnce.class.toVector((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, T, Col> cbf) {
                return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
            }

            public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<T, Tuple2<T, U>> ev) {
                return TraversableOnce.class.toMap((TraversableOnce)this, ev);
            }

            public String mkString(String start2, String sep, String end) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)start2, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.class.mkString((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start2, String sep, String end) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start2, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
            }

            private Iterator<T> cur() {
                return this.cur;
            }

            private void cur_$eq(Iterator<T> x$1) {
                this.cur = x$1;
            }

            private Iterator<Iterator<T>> topIterator() {
                return this.topIterator;
            }

            public boolean hasNext() {
                while (true) {
                    if (this.cur() == null) {
                        if (this.topIterator().hasNext()) {
                            this.cur_$eq((Iterator)this.topIterator().next());
                        } else {
                            return false;
                        }
                    }
                    if (this.cur().hasNext()) {
                        return true;
                    }
                    this.cur_$eq(null);
                }
            }

            public T next() {
                return (T)this.cur().next();
            }
            {
                TraversableOnce.class.$init$((TraversableOnce)this);
                Iterator.class.$init$((Iterator)this);
                this.cur = null;
                this.topIterator = s$1.iterator();
            }
        };
    }

    public String hexString(byte[] bytes) {
        return this.hexString(ByteBuffer.wrap(bytes));
    }

    public String hexString(ByteBuffer buffer) {
        StringBuilder builder = new StringBuilder("0x");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), buffer.limit()).foreach((Function1)new Serializable(buffer, builder){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer buffer$1;
            private final StringBuilder builder$2;

            public final StringBuilder apply(int i) {
                return this.builder$2.append(String.format("%x", this.buffer$1.get(this.buffer$1.position() + i)));
            }
            {
                this.buffer$1 = buffer$1;
                this.builder$2 = builder$2;
            }
        });
        return builder.toString();
    }

    public Properties securityConfigs(Mode mode, SecurityProtocol securityProtocol, Option<File> trustStoreFile, String certAlias, String certCn, Option<Properties> saslProperties) {
        Properties props = new Properties();
        if (this.usesSslTransportLayer(securityProtocol)) {
            SecurityProtocol securityProtocol2 = securityProtocol;
            SecurityProtocol securityProtocol3 = SecurityProtocol.SSL;
            Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(this.sslConfigs(mode, !(securityProtocol2 != null ? !securityProtocol2.equals(securityProtocol3) : securityProtocol3 != null), trustStoreFile, certAlias, certCn));
        }
        if (this.usesSaslAuthentication(securityProtocol)) {
            Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(JaasTestUtils$.MODULE$.saslConfigs(saslProperties));
        }
        props.put("security.protocol", securityProtocol.name);
        return props;
    }

    public Properties producerSecurityConfigs(SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties) {
        return this.securityConfigs(Mode.CLIENT, securityProtocol, trustStoreFile, "producer", this.SslCertificateCn(), saslProperties);
    }

    public <K, V> KafkaProducer<K, V> createProducer(String brokerList, int acks, long maxBlockMs, long bufferSize, int retries, int deliveryTimeoutMs, int lingerMs, int batchSize, String compressionType, int requestTimeoutMs, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", brokerList);
        producerProps.put("acks", ((Object)BoxesRunTime.boxToInteger((int)acks)).toString());
        producerProps.put("max.block.ms", ((Object)BoxesRunTime.boxToLong((long)maxBlockMs)).toString());
        producerProps.put("buffer.memory", ((Object)BoxesRunTime.boxToLong((long)bufferSize)).toString());
        producerProps.put("retries", ((Object)BoxesRunTime.boxToInteger((int)retries)).toString());
        producerProps.put("delivery.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)deliveryTimeoutMs)).toString());
        producerProps.put("request.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)requestTimeoutMs)).toString());
        producerProps.put("linger.ms", ((Object)BoxesRunTime.boxToInteger((int)lingerMs)).toString());
        producerProps.put("batch.size", ((Object)BoxesRunTime.boxToInteger((int)batchSize)).toString());
        producerProps.put("compression.type", compressionType);
        Implicits$.MODULE$.PropertiesOps(producerProps).$plus$plus$eq(this.producerSecurityConfigs(securityProtocol, trustStoreFile, saslProperties));
        return new KafkaProducer(producerProps, keySerializer, valueSerializer);
    }

    public <K, V> int createProducer$default$2() {
        return -1;
    }

    public <K, V> long createProducer$default$3() {
        return 60000L;
    }

    public <K, V> long createProducer$default$4() {
        return 0x100000L;
    }

    public <K, V> int createProducer$default$5() {
        return Integer.MAX_VALUE;
    }

    public <K, V> int createProducer$default$6() {
        return 30000;
    }

    public <K, V> int createProducer$default$7() {
        return 0;
    }

    public <K, V> int createProducer$default$8() {
        return 16384;
    }

    public <K, V> String createProducer$default$9() {
        return "none";
    }

    public <K, V> int createProducer$default$10() {
        return 20000;
    }

    public <K, V> SecurityProtocol createProducer$default$11() {
        return SecurityProtocol.PLAINTEXT;
    }

    public <K, V> Option<File> createProducer$default$12() {
        return None$.MODULE$;
    }

    public <K, V> Option<Properties> createProducer$default$13() {
        return None$.MODULE$;
    }

    public <K, V> ByteArraySerializer createProducer$default$14() {
        return new ByteArraySerializer();
    }

    public <K, V> ByteArraySerializer createProducer$default$15() {
        return new ByteArraySerializer();
    }

    public boolean usesSslTransportLayer(SecurityProtocol securityProtocol) {
        SecurityProtocol securityProtocol2 = securityProtocol;
        boolean bl = SecurityProtocol.SSL.equals(securityProtocol2) ? true : SecurityProtocol.SASL_SSL.equals(securityProtocol2);
        boolean bl2 = bl;
        return bl2;
    }

    public boolean usesSaslAuthentication(SecurityProtocol securityProtocol) {
        SecurityProtocol securityProtocol2 = securityProtocol;
        boolean bl = SecurityProtocol.SASL_PLAINTEXT.equals(securityProtocol2) ? true : SecurityProtocol.SASL_SSL.equals(securityProtocol2);
        boolean bl2 = bl;
        return bl2;
    }

    public Properties consumerSecurityConfigs(SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties) {
        return this.securityConfigs(Mode.CLIENT, securityProtocol, trustStoreFile, "consumer", this.SslCertificateCn(), saslProperties);
    }

    public Properties adminClientSecurityConfigs(SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties) {
        return this.securityConfigs(Mode.CLIENT, securityProtocol, trustStoreFile, "admin-client", this.SslCertificateCn(), saslProperties);
    }

    public <K, V> KafkaConsumer<K, V> createConsumer(String brokerList, String groupId, String autoOffsetReset, boolean enableAutoCommit, boolean readCommitted, int maxPollRecords, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> saslProperties, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        Properties consumerProps = new Properties();
        consumerProps.put("bootstrap.servers", brokerList);
        consumerProps.put("auto.offset.reset", autoOffsetReset);
        consumerProps.put("group.id", groupId);
        consumerProps.put("enable.auto.commit", ((Object)BoxesRunTime.boxToBoolean((boolean)enableAutoCommit)).toString());
        consumerProps.put("max.poll.records", ((Object)BoxesRunTime.boxToInteger((int)maxPollRecords)).toString());
        consumerProps.put("isolation.level", readCommitted ? "read_committed" : "read_uncommitted");
        Implicits$.MODULE$.PropertiesOps(consumerProps).$plus$plus$eq(this.consumerSecurityConfigs(securityProtocol, trustStoreFile, saslProperties));
        return new KafkaConsumer(consumerProps, keyDeserializer, valueDeserializer);
    }

    public <K, V> String createConsumer$default$2() {
        return "group";
    }

    public <K, V> String createConsumer$default$3() {
        return "earliest";
    }

    public <K, V> boolean createConsumer$default$4() {
        return true;
    }

    public <K, V> boolean createConsumer$default$5() {
        return false;
    }

    public <K, V> int createConsumer$default$6() {
        return 500;
    }

    public <K, V> SecurityProtocol createConsumer$default$7() {
        return SecurityProtocol.PLAINTEXT;
    }

    public <K, V> Option<File> createConsumer$default$8() {
        return None$.MODULE$;
    }

    public <K, V> Option<Properties> createConsumer$default$9() {
        return None$.MODULE$;
    }

    public <K, V> ByteArrayDeserializer createConsumer$default$10() {
        return new ByteArrayDeserializer();
    }

    public <K, V> ByteArrayDeserializer createConsumer$default$11() {
        return new ByteArrayDeserializer();
    }

    public Seq<Broker> createBrokersInZk(KafkaZkClient zkClient, Seq<Object> ids) {
        return this.createBrokersInZk((Seq<BrokerMetadata>)((Seq)ids.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(int x$6) {
                return new BrokerMetadata(x$6, (Option)None$.MODULE$);
            }
        }, Seq$.MODULE$.canBuildFrom())), zkClient);
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Broker> createBrokersInZk(Seq<BrokerMetadata> brokerMetadatas, KafkaZkClient zkClient) {
        void var3_3;
        zkClient.makeSurePersistentPathExists(BrokerIdsZNode$.MODULE$.path());
        Seq brokers = (Seq)brokerMetadatas.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Broker apply(BrokerMetadata b) {
                SecurityProtocol protocol = SecurityProtocol.PLAINTEXT;
                ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)protocol);
                return new Broker(b.id(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{new EndPoint("localhost", 6667, listenerName, protocol)})), b.rack());
            }
        }, Seq$.MODULE$.canBuildFrom());
        brokers.foreach((Function1)new Serializable(zkClient){
            public static final long serialVersionUID = 0L;
            private final KafkaZkClient zkClient$1;

            public final void apply(Broker b) {
                this.zkClient$1.registerBroker(BrokerInfo$.MODULE$.apply(new Broker(b.id(), b.endPoints(), b.rack()), ApiVersion$.MODULE$.latestVersion(), -1));
            }
            {
                this.zkClient$1 = zkClient$1;
            }
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Broker> deleteBrokersInZk(KafkaZkClient zkClient, Seq<Object> ids) {
        void var3_3;
        Seq brokers = (Seq)ids.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Broker apply(int x$7) {
                return TestUtils$.MODULE$.createBroker(x$7, "localhost", 6667, SecurityProtocol.PLAINTEXT);
            }
        }, Seq$.MODULE$.canBuildFrom());
        ids.foreach((Function1)new Serializable(zkClient){
            public static final long serialVersionUID = 0L;
            private final KafkaZkClient zkClient$8;

            public final boolean apply(int b) {
                return this.apply$mcZI$sp(b);
            }

            public boolean apply$mcZI$sp(int b) {
                return this.zkClient$8.deletePath(new StringBuilder().append((Object)BrokerIdsZNode$.MODULE$.path()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)b)).toString());
            }
            {
                this.zkClient$8 = zkClient$8;
            }
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> getMsgStrings(int n) {
        void var2_2;
        ListBuffer buffer = new ListBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).foreach((Function1)new Serializable(buffer){
            public static final long serialVersionUID = 0L;
            private final ListBuffer buffer$2;

            public final ListBuffer<String> apply(int i) {
                return this.buffer$2.$plus$eq((Object)new StringBuilder().append((Object)"msg").append((Object)BoxesRunTime.boxToInteger((int)i)).toString());
            }
            {
                this.buffer$2 = buffer$2;
            }
        });
        return var2_2;
    }

    public void makeLeaderForPartition(KafkaZkClient zkClient, String topic, scala.collection.immutable.Map<Object, Object> leaderPerPartitionMap, int controllerEpoch) {
        scala.collection.immutable.Map newLeaderIsrAndControllerEpochs = (scala.collection.immutable.Map)leaderPerPartitionMap.map((Function1)new Serializable(zkClient, topic, controllerEpoch){
            public static final long serialVersionUID = 0L;
            private final KafkaZkClient zkClient$6;
            private final String topic$6;
            private final int controllerEpoch$1;

            public final Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> apply(Tuple2<Object, Object> x0$5) {
                Tuple2<Object, Object> tuple2 = x0$5;
                if (tuple2 != null) {
                    int partition = tuple2._1$mcI$sp();
                    int leader2 = tuple2._2$mcI$sp();
                    TopicPartition topicPartition = new TopicPartition(this.topic$6, partition);
                    LeaderAndIsr newLeaderAndIsr = (LeaderAndIsr)this.zkClient$6.getTopicPartitionState(topicPartition).map((Function1)new Serializable(this, leader2){
                        public static final long serialVersionUID = 0L;
                        private final int leader$1;

                        public final LeaderAndIsr apply(LeaderIsrAndControllerEpoch x$8) {
                            return x$8.leaderAndIsr().newLeader(this.leader$1);
                        }
                        {
                            this.leader$1 = leader$1;
                        }
                    }).getOrElse((Function0)new Serializable(this, leader2){
                        public static final long serialVersionUID = 0L;
                        private final int leader$1;

                        public final LeaderAndIsr apply() {
                            return LeaderAndIsr$.MODULE$.apply(this.leader$1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.leader$1})));
                        }
                        {
                            this.leader$1 = leader$1;
                        }
                    });
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new LeaderIsrAndControllerEpoch(newLeaderAndIsr, this.controllerEpoch$1));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.zkClient$6 = zkClient$6;
                this.topic$6 = topic$6;
                this.controllerEpoch$1 = controllerEpoch$1;
            }
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        zkClient.setTopicPartitionStatesRaw(newLeaderIsrAndControllerEpochs, ZkVersion$.MODULE$.MatchAnyVersion());
    }

    /*
     * Unable to fully structure code
     */
    public int waitUntilLeaderIsElectedOrChanged(KafkaZkClient zkClient, String topic, int partition, long timeoutMs, Option<Object> oldLeaderOpt, Option<Object> newLeaderOpt) {
        Predef$.MODULE$.require(oldLeaderOpt.isDefined() == false || newLeaderOpt.isDefined() == false, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Can't define both the old and the new leader";
            }
        });
        startTime = System.currentTimeMillis();
        topicPartition = new TopicPartition(topic, partition);
        this.trace((Function0<String>)new Serializable(oldLeaderOpt, newLeaderOpt, topicPartition){
            public static final long serialVersionUID = 0L;
            private final Option oldLeaderOpt$1;
            private final Option newLeaderOpt$1;
            private final TopicPartition topicPartition$3;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Waiting for leader to be elected or changed for partition ", ", old leader is ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$3, this.oldLeaderOpt$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"new leader is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newLeaderOpt$1}))).toString();
            }
            {
                this.oldLeaderOpt$1 = oldLeaderOpt$1;
                this.newLeaderOpt$1 = newLeaderOpt$1;
                this.topicPartition$3 = topicPartition$3;
            }
        });
        leader = ObjectRef.create((Object)None$.MODULE$);
        electedOrChangedLeader = None$.MODULE$;
        while (electedOrChangedLeader.isEmpty() && System.currentTimeMillis() < startTime + timeoutMs) {
            block11: {
                block10: {
                    block6: {
                        block8: {
                            block9: {
                                block7: {
                                    leader.elem = zkClient.getLeaderForPartition(topicPartition);
                                    var13_11 = (Option)leader.elem;
                                    if (!(var13_11 instanceof Some)) break block6;
                                    var14_12 = (Some)var13_11;
                                    l = BoxesRunTime.unboxToInt((Object)var14_12.x());
                                    var17_15 = new Tuple2(newLeaderOpt, oldLeaderOpt);
                                    if (var17_15 == null || !((var18_16 = (Option)var17_15._1()) instanceof Some) || (newLeader = BoxesRunTime.unboxToInt((Object)(var19_17 = (Some)var18_16).x())) != l) break block7;
                                    this.trace((Function0<String>)new Serializable(topicPartition, l){
                                        public static final long serialVersionUID = 0L;
                                        private final TopicPartition topicPartition$3;
                                        private final int l$1;

                                        public final String apply() {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected new leader ", " is elected for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.l$1), this.topicPartition$3}));
                                        }
                                        {
                                            this.topicPartition$3 = topicPartition$3;
                                            this.l$1 = l$1;
                                        }
                                    });
                                    electedOrChangedLeader = (Option)leader.elem;
                                    var21_19 = BoxedUnit.UNIT;
                                    break block8;
                                }
                                if (var17_15 == null || !((var22_20 = (Option)var17_15._2()) instanceof Some) || (oldLeader = BoxesRunTime.unboxToInt((Object)(var23_21 = (Some)var22_20).x())) == l) break block9;
                                this.trace((Function0<String>)new Serializable(topicPartition, l, oldLeader){
                                    public static final long serialVersionUID = 0L;
                                    private final TopicPartition topicPartition$3;
                                    private final int l$1;
                                    private final int oldLeader$2;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Leader for partition ", " is changed from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$3, BoxesRunTime.boxToInteger((int)this.oldLeader$2), BoxesRunTime.boxToInteger((int)this.l$1)}));
                                    }
                                    {
                                        this.topicPartition$3 = topicPartition$3;
                                        this.l$1 = l$1;
                                        this.oldLeader$2 = oldLeader$2;
                                    }
                                });
                                electedOrChangedLeader = (Option)leader.elem;
                                var21_19 = BoxedUnit.UNIT;
                                break block8;
                            }
                            if (var17_15 == null) ** GOTO lbl-1000
                            var25_23 = (Option)var17_15._1();
                            var26_24 = (Option)var17_15._2();
                            if (None$.MODULE$.equals(var25_23) && None$.MODULE$.equals(var26_24)) {
                                this.trace((Function0<String>)new Serializable(topicPartition, l){
                                    public static final long serialVersionUID = 0L;
                                    private final TopicPartition topicPartition$3;
                                    private final int l$1;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Leader ", " is elected for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.l$1), this.topicPartition$3}));
                                    }
                                    {
                                        this.topicPartition$3 = topicPartition$3;
                                        this.l$1 = l$1;
                                    }
                                });
                                electedOrChangedLeader = (Option)leader.elem;
                                var21_19 = BoxedUnit.UNIT;
                            } else lbl-1000:
                            // 2 sources

                            {
                                this.trace((Function0<String>)new Serializable(topicPartition, l){
                                    public static final long serialVersionUID = 0L;
                                    private final TopicPartition topicPartition$3;
                                    private final int l$1;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Current leader for partition ", " is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$3, BoxesRunTime.boxToInteger((int)this.l$1)}));
                                    }
                                    {
                                        this.topicPartition$3 = topicPartition$3;
                                        this.l$1 = l$1;
                                    }
                                });
                                var21_19 = BoxedUnit.UNIT;
                            }
                        }
                        var16_14 = BoxedUnit.UNIT;
                        break block10;
                    }
                    if (!None$.MODULE$.equals(var13_11)) break block11;
                    this.trace((Function0<String>)new Serializable(topicPartition){
                        public static final long serialVersionUID = 0L;
                        private final TopicPartition topicPartition$3;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Leader for partition ", " is not elected yet"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$3}));
                        }
                        {
                            this.topicPartition$3 = topicPartition$3;
                        }
                    });
                    var16_14 = BoxedUnit.UNIT;
                }
                Thread.sleep(package$.MODULE$.min(timeoutMs, 100L));
                continue;
            }
            throw new MatchError((Object)var13_11);
        }
        return BoxesRunTime.unboxToInt((Object)electedOrChangedLeader.getOrElse((Function0)new Serializable(timeoutMs, oldLeaderOpt, newLeaderOpt, topicPartition, leader){
            public static final long serialVersionUID = 0L;
            private final long timeoutMs$1;
            private final Option oldLeaderOpt$1;
            private final Option newLeaderOpt$1;
            private final TopicPartition topicPartition$3;
            private final ObjectRef leader$2;

            public final Nothing$ apply() {
                Option option;
                String string;
                Option option2;
                Tuple2 tuple2 = new Tuple2((Object)this.newLeaderOpt$1, (Object)this.oldLeaderOpt$1);
                if (tuple2 != null && (option2 = (Option)tuple2._1()) instanceof Some) {
                    Some some = (Some)option2;
                    int newLeader = BoxesRunTime.unboxToInt((Object)some.x());
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timing out after ", " ms since expected new leader ", " was not elected for partition ", ", leader is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.timeoutMs$1), BoxesRunTime.boxToInteger((int)newLeader), this.topicPartition$3, (Option)this.leader$2.elem}));
                } else if (tuple2 != null && (option = (Option)tuple2._2()) instanceof Some) {
                    Some some = (Some)option;
                    int oldLeader = BoxesRunTime.unboxToInt((Object)some.x());
                    string = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timing out after ", " ms since a new leader that is different from ", " was not elected for partition ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.timeoutMs$1), BoxesRunTime.boxToInteger((int)oldLeader), this.topicPartition$3}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"leader is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Option)this.leader$2.elem}))).toString();
                } else {
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timing out after ", " ms since a leader was not elected for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.timeoutMs$1), this.topicPartition$3}));
                }
                String errorMessage = string;
                return TestUtils$.MODULE$.fail(errorMessage);
            }
            {
                this.timeoutMs$1 = timeoutMs$1;
                this.oldLeaderOpt$1 = oldLeaderOpt$1;
                this.newLeaderOpt$1 = newLeaderOpt$1;
                this.topicPartition$3 = topicPartition$3;
                this.leader$2 = leader$2;
            }
        }));
    }

    public long waitUntilLeaderIsElectedOrChanged$default$4() {
        return 30000L;
    }

    public Option<Object> waitUntilLeaderIsElectedOrChanged$default$5() {
        return None$.MODULE$;
    }

    public Option<Object> waitUntilLeaderIsElectedOrChanged$default$6() {
        return None$.MODULE$;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void retry(long maxWaitMs, Function0<BoxedUnit> block) {
        LongRef wait = LongRef.create((long)1L);
        long startTime = System.currentTimeMillis();
        {
            block.apply$mcV$sp();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitUntilTrue(Function0<Object> condition, Function0<String> msg, long waitTime, long pause, int maxRetries) {
        long startTime = System.currentTimeMillis();
        int retry2 = 0;
        {
            while (!condition.apply$mcZ$sp()) {
                if (System.currentTimeMillis() > startTime + waitTime) {
                    throw this.fail((String)msg.apply());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTime), pause));
            }
            return;
        }
    }

    public long waitUntilTrue$default$3() {
        return 15000L;
    }

    public long waitUntilTrue$default$4() {
        return 100L;
    }

    public int waitUntilTrue$default$5() {
        return 0;
    }

    public <T> Tuple2<T, Object> computeUntilTrue(Function0<T> compute, long waitTime, long pause, Function1<T, Object> predicate) {
        long startTime = System.currentTimeMillis();
        Object result;
        while (!BoxesRunTime.unboxToBoolean((Object)predicate.apply(result = compute.apply()))) {
            if (System.currentTimeMillis() > startTime + waitTime) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTime), pause));
        }
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public <T> long computeUntilTrue$default$2() {
        return 15000L;
    }

    public <T> long computeUntilTrue$default$3() {
        return 100L;
    }

    public boolean isLeaderLocalOnBroker(String topic, int partitionId, KafkaServer server) {
        return server.replicaManager().getPartition(new TopicPartition(topic, partitionId)).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Partition x$9) {
                return x$9.leaderReplicaIfLocal().isDefined();
            }
        });
    }

    public int findLeaderEpoch(int brokerId, TopicPartition topicPartition, Iterable<KafkaServer> servers) {
        Option leaderServer = servers.find((Function1)new Serializable(brokerId){
            public static final long serialVersionUID = 0L;
            private final int brokerId$1;

            public final boolean apply(KafkaServer x$10) {
                return x$10.config().brokerId() == this.brokerId$1;
            }
            {
                this.brokerId$1 = brokerId$1;
            }
        });
        Partition leaderPartition = (Partition)leaderServer.flatMap((Function1)new Serializable(topicPartition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$1;

            public final Option<Partition> apply(KafkaServer x$11) {
                return x$11.replicaManager().getPartition(this.topicPartition$1);
            }
            {
                this.topicPartition$1 = topicPartition$1;
            }
        }).getOrElse((Function0)new Serializable(brokerId){
            public static final long serialVersionUID = 0L;
            private final int brokerId$1;

            public final Nothing$ apply() {
                return TestUtils$.MODULE$.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to find expected replica on broker ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.brokerId$1)})));
            }
            {
                this.brokerId$1 = brokerId$1;
            }
        });
        return leaderPartition.getLeaderEpoch();
    }

    public int findFollowerId(TopicPartition topicPartition, Iterable<KafkaServer> servers) {
        Option followerOpt = servers.find((Function1)new Serializable(topicPartition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$2;

            public final boolean apply(KafkaServer server) {
                Option option;
                block4: {
                    boolean bl;
                    block3: {
                        block2: {
                            option = server.replicaManager().getPartition(this.topicPartition$2);
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            Partition partition = (Partition)some.x();
                            bl = !partition.leaderReplicaIdOpt().contains((Object)BoxesRunTime.boxToInteger((int)server.config().brokerId()));
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block4;
                        bl = false;
                    }
                    return bl;
                }
                throw new MatchError((Object)option);
            }
            {
                this.topicPartition$2 = topicPartition$2;
            }
        });
        return BoxesRunTime.unboxToInt((Object)followerOpt.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$12) {
                return x$12.config().brokerId();
            }
        }).getOrElse((Function0)new Serializable(topicPartition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$2;

            public final Nothing$ apply() {
                return TestUtils$.MODULE$.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to locate follower for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$2})));
            }
            {
                this.topicPartition$2 = topicPartition$2;
            }
        }));
    }

    public void waitUntilBrokerMetadataIsPropagated(Seq<KafkaServer> servers, long timeout) {
        Set expectedBrokerIds = ((TraversableOnce)servers.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$13) {
                return x$13.config().brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
        this.waitUntilTrue((Function0<Object>)new Serializable(servers, expectedBrokerIds){
            public static final long serialVersionUID = 0L;
            private final Seq servers$1;
            public final Set expectedBrokerIds$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.servers$1.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.waitUntilBrokerMetadataIsPropagated.1 $outer;

                    public final boolean apply(KafkaServer server) {
                        Set set = this.$outer.expectedBrokerIds$1;
                        Set set2 = ((TraversableOnce)server.apis().metadataCache().getAliveBrokers().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(Broker x$14) {
                                return x$14.id();
                            }
                        }, Seq$.MODULE$.canBuildFrom())).toSet();
                        return !(set != null ? !set.equals(set2) : set2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.servers$1 = servers$1;
                this.expectedBrokerIds$1 = expectedBrokerIds$1;
            }
        }, (Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Timed out waiting for broker metadata to propagate to all servers";
            }
        }, timeout, this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
    }

    public long waitUntilBrokerMetadataIsPropagated$default$2() {
        return 15000L;
    }

    public int waitUntilMetadataIsPropagated(Seq<KafkaServer> servers, String topic, int partition, long timeout) {
        IntRef leader2 = IntRef.create((int)-1);
        this.waitUntilTrue((Function0<Object>)new Serializable(servers, topic, partition, leader2){
            public static final long serialVersionUID = 0L;
            private final Seq servers$5;
            public final String topic$4;
            public final int partition$1;
            public final IntRef leader$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return BoxesRunTime.unboxToBoolean((Object)this.servers$5.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.waitUntilMetadataIsPropagated.1 $outer;

                    public final boolean apply(boolean result, KafkaServer server) {
                        Option option;
                        block4: {
                            boolean bl;
                            block3: {
                                block2: {
                                    Option partitionStateOpt = server.apis().metadataCache().getPartitionInfo(this.$outer.topic$4, this.$outer.partition$1);
                                    option = partitionStateOpt;
                                    if (!None$.MODULE$.equals(option)) break block2;
                                    bl = false;
                                    break block3;
                                }
                                if (!(option instanceof Some)) break block4;
                                Some some = (Some)option;
                                UpdateMetadataRequest.PartitionState partitionState = (UpdateMetadataRequest.PartitionState)some.x();
                                this.$outer.leader$3.elem = partitionState.basePartitionState.leader;
                                bl = result && Request$.MODULE$.isValidBrokerId(this.$outer.leader$3.elem);
                            }
                            return bl;
                        }
                        throw new MatchError((Object)option);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.servers$5 = servers$5;
                this.topic$4 = topic$4;
                this.partition$1 = partition$1;
                this.leader$3 = leader$3;
            }
        }, (Function0<String>)new Serializable(topic, partition, timeout){
            public static final long serialVersionUID = 0L;
            private final String topic$4;
            private final int partition$1;
            private final long timeout$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Partition [%s,%d] metadata not propagated after %d ms")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$4, BoxesRunTime.boxToInteger((int)this.partition$1), BoxesRunTime.boxToLong((long)this.timeout$2)}));
            }
            {
                this.topic$4 = topic$4;
                this.partition$1 = partition$1;
                this.timeout$2 = timeout$2;
            }
        }, timeout, this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
        return leader2.elem;
    }

    public long waitUntilMetadataIsPropagated$default$4() {
        return 15000L;
    }

    public int waitUntilControllerElected(KafkaZkClient zkClient, long timeout) {
        Tuple2 tuple2 = this.computeUntilTrue((Function0)new Serializable(zkClient){
            public static final long serialVersionUID = 0L;
            private final KafkaZkClient zkClient$2;

            public final Option<Object> apply() {
                return this.zkClient$2.getControllerId();
            }
            {
                this.zkClient$2 = zkClient$2;
            }
        }, timeout, this.computeUntilTrue$default$3(), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Option<Object> x$15) {
                return x$15.isDefined();
            }
        });
        if (tuple2 != null) {
            Option controllerId;
            Option option;
            Option controllerId2 = option = (controllerId = (Option)tuple2._1());
            return BoxesRunTime.unboxToInt((Object)controllerId2.getOrElse((Function0)new Serializable(timeout){
                public static final long serialVersionUID = 0L;
                private final long timeout$1;

                public final Nothing$ apply() {
                    return TestUtils$.MODULE$.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Controller not elected after ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.timeout$1)})));
                }
                {
                    this.timeout$1 = timeout$1;
                }
            }));
        }
        throw new MatchError(tuple2);
    }

    public long waitUntilControllerElected$default$2() {
        return 15000L;
    }

    public int awaitLeaderChange(Seq<KafkaServer> servers, TopicPartition tp, int oldLeader, long timeout) {
        this.waitUntilTrue((Function0<Object>)new Serializable(servers, tp, oldLeader){
            public static final long serialVersionUID = 0L;
            private final Seq servers$7;
            private final TopicPartition tp$1;
            private final int oldLeader$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return TestUtils$.MODULE$.kafka$utils$TestUtils$$newLeaderExists$1(this.servers$7, this.tp$1, this.oldLeader$1).isDefined();
            }
            {
                this.servers$7 = servers$7;
                this.tp$1 = tp$1;
                this.oldLeader$1 = oldLeader$1;
            }
        }, (Function0<String>)new Serializable(tp, timeout){
            public static final long serialVersionUID = 0L;
            private final TopicPartition tp$1;
            private final long timeout$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not observe leader change for partition ", " after ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tp$1, BoxesRunTime.boxToLong((long)this.timeout$3)}));
            }
            {
                this.tp$1 = tp$1;
                this.timeout$3 = timeout$3;
            }
        }, timeout, this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
        return BoxesRunTime.unboxToInt((Object)this.kafka$utils$TestUtils$$newLeaderExists$1(servers, tp, oldLeader).get());
    }

    public long awaitLeaderChange$default$4() {
        return 15000L;
    }

    public int waitUntilLeaderIsKnown(Seq<KafkaServer> servers, TopicPartition tp, long timeout) {
        this.waitUntilTrue((Function0<Object>)new Serializable(servers, tp){
            public static final long serialVersionUID = 0L;
            private final Seq servers$8;
            private final TopicPartition tp$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return TestUtils$.MODULE$.kafka$utils$TestUtils$$leaderIfExists$1(this.servers$8, this.tp$2).isDefined();
            }
            {
                this.servers$8 = servers$8;
                this.tp$2 = tp$2;
            }
        }, (Function0<String>)new Serializable(tp, timeout){
            public static final long serialVersionUID = 0L;
            private final TopicPartition tp$2;
            private final long timeout$4;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition ", " leaders not made yet after ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tp$2, BoxesRunTime.boxToLong((long)this.timeout$4)}));
            }
            {
                this.tp$2 = tp$2;
                this.timeout$4 = timeout$4;
            }
        }, timeout, this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
        return BoxesRunTime.unboxToInt((Object)this.kafka$utils$TestUtils$$leaderIfExists$1(servers, tp).get());
    }

    public long waitUntilLeaderIsKnown$default$3() {
        return 15000L;
    }

    public void writeNonsenseToFile(File fileName, long position, int size2) {
        RandomAccessFile file = new RandomAccessFile(fileName, "rw");
        file.seek(position);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size2).foreach$mVc$sp((Function1)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final RandomAccessFile file$1;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                this.file$1.writeByte(TestUtils$.MODULE$.random().nextInt(255));
            }
            {
                this.file$1 = file$1;
            }
        });
        file.close();
    }

    /*
     * WARNING - void declaration
     */
    public void appendNonsenseToFile(File file, int size2) {
        OutputStream outputStream = Files.newOutputStream(file.toPath(), StandardOpenOption.APPEND);
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size2).foreach$mVc$sp((Function1)new Serializable(outputStream){
                public static final long serialVersionUID = 0L;
                private final OutputStream outputStream$1;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    this.outputStream$1.write(TestUtils$.MODULE$.random().nextInt(255));
                }
                {
                    this.outputStream$1 = outputStream$1;
                }
            });
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        outputStream.close();
    }

    public void checkForPhantomInSyncReplicas(KafkaZkClient zkClient, String topic, int partitionToBeReassigned, Seq<Object> assignedReplicas) {
        Option inSyncReplicas = zkClient.getInSyncReplicasForPartition(new TopicPartition(topic, partitionToBeReassigned));
        Set phantomInSyncReplicas = (Set)((TraversableOnce)inSyncReplicas.get()).toSet().$minus$minus((GenTraversableOnce)assignedReplicas.toSet());
        Assert.assertTrue((String)new StringOps(Predef$.MODULE$.augmentString("All in sync replicas %s must be in the assigned replica list %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inSyncReplicas, assignedReplicas})), (boolean)phantomInSyncReplicas.isEmpty());
    }

    public void ensureNoUnderReplicatedPartitions(KafkaZkClient zkClient, String topic, int partitionToBeReassigned, Seq<Object> assignedReplicas, Seq<KafkaServer> servers) {
        TopicPartition topicPartition = new TopicPartition(topic, partitionToBeReassigned);
        this.waitUntilTrue((Function0<Object>)new Serializable(zkClient, assignedReplicas, topicPartition){
            public static final long serialVersionUID = 0L;
            private final KafkaZkClient zkClient$7;
            private final Seq assignedReplicas$1;
            private final TopicPartition topicPartition$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Option inSyncReplicas = this.zkClient$7.getInSyncReplicasForPartition(this.topicPartition$4);
                return ((SeqLike)inSyncReplicas.get()).size() == this.assignedReplicas$1.size();
            }
            {
                this.zkClient$7 = zkClient$7;
                this.assignedReplicas$1 = assignedReplicas$1;
                this.topicPartition$4 = topicPartition$4;
            }
        }, (Function0<String>)new Serializable(topic, partitionToBeReassigned){
            public static final long serialVersionUID = 0L;
            private final String topic$7;
            private final int partitionToBeReassigned$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Reassigned partition [%s,%d] is under replicated")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$7, BoxesRunTime.boxToInteger((int)this.partitionToBeReassigned$1)}));
            }
            {
                this.topic$7 = topic$7;
                this.partitionToBeReassigned$1 = partitionToBeReassigned$1;
            }
        }, this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
        ObjectRef leader2 = ObjectRef.create((Object)None$.MODULE$);
        this.waitUntilTrue((Function0<Object>)new Serializable(zkClient, topicPartition, leader2){
            public static final long serialVersionUID = 0L;
            private final KafkaZkClient zkClient$7;
            private final TopicPartition topicPartition$4;
            private final ObjectRef leader$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.leader$4.elem = this.zkClient$7.getLeaderForPartition(this.topicPartition$4);
                return ((Option)this.leader$4.elem).isDefined();
            }
            {
                this.zkClient$7 = zkClient$7;
                this.topicPartition$4 = topicPartition$4;
                this.leader$4 = leader$4;
            }
        }, (Function0<String>)new Serializable(topic, partitionToBeReassigned){
            public static final long serialVersionUID = 0L;
            private final String topic$7;
            private final int partitionToBeReassigned$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Reassigned partition [%s,%d] is unavailable")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$7, BoxesRunTime.boxToInteger((int)this.partitionToBeReassigned$1)}));
            }
            {
                this.topic$7 = topic$7;
                this.partitionToBeReassigned$1 = partitionToBeReassigned$1;
            }
        }, this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
        this.waitUntilTrue((Function0<Object>)new Serializable(servers, leader2){
            public static final long serialVersionUID = 0L;
            private final Seq servers$6;
            public final ObjectRef leader$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                KafkaServer leaderBroker = (KafkaServer)((IterableLike)this.servers$6.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.ensureNoUnderReplicatedPartitions.3 $outer;

                    public final boolean apply(KafkaServer s) {
                        return s.config().brokerId() == BoxesRunTime.unboxToInt((Object)((Option)this.$outer.leader$4.elem).get());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })).head();
                return leaderBroker.replicaManager().underReplicatedPartitionCount() == 0;
            }
            {
                this.servers$6 = servers$6;
                this.leader$4 = leader$4;
            }
        }, (Function0<String>)new Serializable(topic, partitionToBeReassigned, leader2){
            public static final long serialVersionUID = 0L;
            private final String topic$7;
            private final int partitionToBeReassigned$1;
            private final ObjectRef leader$4;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Reassigned partition [%s,%d] is under-replicated as reported by the leader %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$7, BoxesRunTime.boxToInteger((int)this.partitionToBeReassigned$1), ((Option)this.leader$4.elem).get()}));
            }
            {
                this.topic$7 = topic$7;
                this.partitionToBeReassigned$1 = partitionToBeReassigned$1;
                this.leader$4 = leader$4;
            }
        }, this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
    }

    public void verifyNonDaemonThreadsStatus(String threadNamePrefix) {
        int threadCount = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(Thread.getAllStackTraces().keySet()).asScala()).count((Function1)new Serializable(threadNamePrefix){
            public static final long serialVersionUID = 0L;
            private final String threadNamePrefix$1;

            public final boolean apply(Thread t) {
                return !t.isDaemon() && t.isAlive() && t.getName().startsWith(this.threadNamePrefix$1);
            }
            {
                this.threadNamePrefix$1 = threadNamePrefix$1;
            }
        });
        Assert.assertEquals((long)0L, (long)threadCount);
    }

    public String allThreadStackTraces() {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Thread.getAllStackTraces()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<Thread, StackTraceElement[]> x0$6) {
                Tuple2<Thread, StackTraceElement[]> tuple2 = x0$6;
                if (tuple2 != null) {
                    Thread thread = (Thread)tuple2._1();
                    StackTraceElement[] stackTrace = (StackTraceElement[])tuple2._2();
                    String string = new StringBuilder().append((Object)thread.getName()).append((Object)"\n\t").append((Object)((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])stackTrace).toList().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(StackTraceElement x$20) {
                            return x$20.toString();
                        }
                    }, List$.MODULE$.canBuildFrom())).mkString("\n\t")).toString();
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).mkString("\n");
    }

    public LogManager createLogManager(Seq<File> logDirs, LogConfig defaultConfig, CleanerConfig cleanerConfig, MockTime time) {
        Seq x$54 = (Seq)logDirs.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final File apply(File x$21) {
                return x$21.getAbsoluteFile();
            }
        }, Seq$.MODULE$.canBuildFrom());
        WrappedArray x$55 = Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)));
        Map x$56 = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        LogConfig x$57 = defaultConfig;
        CleanerConfig x$58 = cleanerConfig;
        int x$59 = 4;
        long x$60 = 1000L;
        long x$61 = 10000L;
        long x$62 = 10000L;
        long x$63 = 1000L;
        int x$64 = 3600000;
        MockScheduler x$65 = time.scheduler();
        MockTime x$66 = time;
        BrokerState x$67 = new BrokerState();
        BrokerTopicStats x$68 = new BrokerTopicStats();
        LogDirFailureChannel x$69 = new LogDirFailureChannel(logDirs.size());
        return new LogManager(x$54, (Seq)x$55, x$56, x$57, x$58, x$59, x$60, x$61, x$62, x$63, x$64, (Scheduler)x$65, x$67, x$68, x$69, (Time)x$66);
    }

    public Seq<File> createLogManager$default$1() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public LogConfig createLogManager$default$2() {
        return LogConfig$.MODULE$.apply();
    }

    public CleanerConfig createLogManager$default$3() {
        boolean x$98 = false;
        int x$99 = CleanerConfig$.MODULE$.apply$default$1();
        long x$100 = CleanerConfig$.MODULE$.apply$default$2();
        double x$101 = CleanerConfig$.MODULE$.apply$default$3();
        int x$102 = CleanerConfig$.MODULE$.apply$default$4();
        int x$103 = CleanerConfig$.MODULE$.apply$default$5();
        double x$104 = CleanerConfig$.MODULE$.apply$default$6();
        long x$105 = CleanerConfig$.MODULE$.apply$default$7();
        String x$106 = CleanerConfig$.MODULE$.apply$default$9();
        return new CleanerConfig(x$99, x$100, x$101, x$102, x$103, x$104, x$105, x$98, x$106);
    }

    public MockTime createLogManager$default$4() {
        return new MockTime();
    }

    /*
     * WARNING - void declaration
     */
    public void produceMessages(Seq<KafkaServer> servers, Seq<ProducerRecord<byte[], byte[]>> records2, int acks) {
        KafkaProducer producer = this.createProducer(this.getBrokerListStrFromServers(servers, this.getBrokerListStrFromServers$default$2()), acks, this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6(), this.createProducer$default$7(), this.createProducer$default$8(), this.createProducer$default$9(), this.createProducer$default$10(), this.createProducer$default$11(), this.createProducer$default$12(), this.createProducer$default$13(), (Serializer)this.createProducer$default$14(), (Serializer)this.createProducer$default$15());
        try {
            Seq futures = (Seq)records2.map((Function1)new Serializable(producer){
                public static final long serialVersionUID = 0L;
                private final KafkaProducer producer$1;

                public final Future<RecordMetadata> apply(ProducerRecord<byte[], byte[]> x$1) {
                    return this.producer$1.send(x$1);
                }
                {
                    this.producer$1 = producer$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
            futures.foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final RecordMetadata apply(Future<RecordMetadata> x$22) {
                    return x$22.get();
                }
            });
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.close();
            throw throwable;
        }
        producer.close();
        Seq topics = (Seq)((SeqLike)records2.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(ProducerRecord<byte[], byte[]> x$23) {
                return x$23.topic();
            }
        }, Seq$.MODULE$.canBuildFrom())).distinct();
        this.debug((Function0<String>)new Serializable(records2, topics){
            public static final long serialVersionUID = 0L;
            private final Seq records$1;
            private final Seq topics$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sent ", " messages for topics ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.records$1.size()), this.topics$1.mkString(",")}));
            }
            {
                this.records$1 = records$1;
                this.topics$1 = topics$1;
            }
        });
    }

    public Seq<String> generateAndProduceMessages(Seq<KafkaServer> servers, String topic, int numMessages, int acks) {
        IndexedSeq values = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(int x) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x)}));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq records2 = (IndexedSeq)values.map((Function1)new Serializable(topic){
            public static final long serialVersionUID = 0L;
            private final String topic$8;

            public final ProducerRecord<byte[], byte[]> apply(String v) {
                return new ProducerRecord(this.topic$8, (Object)v.getBytes());
            }
            {
                this.topic$8 = topic$8;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.produceMessages(servers, (Seq<ProducerRecord<byte[], byte[]>>)records2, acks);
        return values;
    }

    public int generateAndProduceMessages$default$4() {
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public void produceMessage(Seq<KafkaServer> servers, String topic, String message, int deliveryTimeoutMs, int requestTimeoutMs) {
        String x$70 = this.getBrokerListStrFromServers(servers, this.getBrokerListStrFromServers$default$2());
        int x$71 = deliveryTimeoutMs;
        int x$72 = requestTimeoutMs;
        int x$73 = this.createProducer$default$2();
        long x$74 = this.createProducer$default$3();
        long x$75 = this.createProducer$default$4();
        int x$76 = this.createProducer$default$5();
        int x$77 = this.createProducer$default$7();
        int x$78 = this.createProducer$default$8();
        String x$79 = this.createProducer$default$9();
        SecurityProtocol x$80 = this.createProducer$default$11();
        Option<File> x$81 = this.createProducer$default$12();
        Option<Properties> x$82 = this.createProducer$default$13();
        ByteArraySerializer x$83 = this.createProducer$default$14();
        ByteArraySerializer x$84 = this.createProducer$default$15();
        KafkaProducer producer = this.createProducer(x$70, x$73, x$74, x$75, x$76, x$71, x$77, x$78, x$79, x$72, x$80, x$81, x$82, (Serializer)x$83, (Serializer)x$84);
        try {
            producer.send(new ProducerRecord(topic, (Object)topic.getBytes(), (Object)message.getBytes())).get();
        }
        catch (Throwable throwable) {
            void var6_21;
            var6_21.close();
            throw throwable;
        }
        producer.close();
    }

    public int produceMessages$default$3() {
        return -1;
    }

    public int produceMessage$default$4() {
        return 30000;
    }

    public int produceMessage$default$5() {
        return 20000;
    }

    public void verifyTopicDeletion(KafkaZkClient zkClient, String topic, int numPartitions, Seq<KafkaServer> servers) {
        IndexedSeq topicPartitions = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1)new Serializable(topic){
            public static final long serialVersionUID = 0L;
            private final String topic$3;

            public final TopicPartition apply(int x$24) {
                return new TopicPartition(this.topic$3, x$24);
            }
            {
                this.topic$3 = topic$3;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.waitUntilTrue((Function0<Object>)new Serializable(zkClient, topic){
            public static final long serialVersionUID = 0L;
            private final KafkaZkClient zkClient$5;
            private final String topic$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.zkClient$5.isTopicMarkedForDeletion(this.topic$3);
            }
            {
                this.zkClient$5 = zkClient$5;
                this.topic$3 = topic$3;
            }
        }, (Function0<String>)new Serializable(topic){
            public static final long serialVersionUID = 0L;
            private final String topic$3;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Admin path /admin/delete_topic/%s path not deleted even after a replica is restarted")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$3}));
            }
            {
                this.topic$3 = topic$3;
            }
        }, this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
        this.waitUntilTrue((Function0<Object>)new Serializable(zkClient, topic){
            public static final long serialVersionUID = 0L;
            private final KafkaZkClient zkClient$5;
            private final String topic$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.zkClient$5.topicExists(this.topic$3);
            }
            {
                this.zkClient$5 = zkClient$5;
                this.topic$3 = topic$3;
            }
        }, (Function0<String>)new Serializable(topic){
            public static final long serialVersionUID = 0L;
            private final String topic$3;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Topic path /brokers/topics/%s not deleted after /admin/delete_topic/%s path is deleted")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$3, this.topic$3}));
            }
            {
                this.topic$3 = topic$3;
            }
        }, this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
        this.waitUntilTrue((Function0<Object>)new Serializable(servers, topicPartitions){
            public static final long serialVersionUID = 0L;
            private final Seq servers$4;
            public final IndexedSeq topicPartitions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.servers$4.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.verifyTopicDeletion.3 $outer;

                    public final boolean apply(KafkaServer server) {
                        return this.$outer.topicPartitions$1.forall((Function1)new Serializable(this, server){
                            public static final long serialVersionUID = 0L;
                            private final KafkaServer server$1;

                            public final boolean apply(TopicPartition tp) {
                                return this.server$1.replicaManager().getPartition(tp).isEmpty();
                            }
                            {
                                this.server$1 = server$1;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.servers$4 = servers$4;
                this.topicPartitions$1 = topicPartitions$1;
            }
        }, (Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Replica manager's should have deleted all of this topic's partitions";
            }
        }, this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
        Assert.assertTrue((String)"Replica logs not deleted after delete topic is complete", (boolean)servers.forall((Function1)new Serializable(topicPartitions){
            public static final long serialVersionUID = 0L;
            private final IndexedSeq topicPartitions$1;

            public final boolean apply(KafkaServer server) {
                return this.topicPartitions$1.forall((Function1)new Serializable(this, server){
                    public static final long serialVersionUID = 0L;
                    private final KafkaServer server$2;

                    public final boolean apply(TopicPartition tp) {
                        LogManager qual$1 = this.server$2.getLogManager();
                        TopicPartition x$85 = tp;
                        boolean x$86 = qual$1.getLog$default$2();
                        return qual$1.getLog(x$85, x$86).isEmpty();
                    }
                    {
                        this.server$2 = server$2;
                    }
                });
            }
            {
                this.topicPartitions$1 = topicPartitions$1;
            }
        }));
        this.waitUntilTrue((Function0<Object>)new Serializable(servers, topicPartitions){
            public static final long serialVersionUID = 0L;
            private final Seq servers$4;
            public final IndexedSeq topicPartitions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.servers$4.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.verifyTopicDeletion.4 $outer;

                    public final boolean apply(KafkaServer server) {
                        return this.$outer.topicPartitions$1.forall((Function1)new Serializable(this, server){
                            public static final long serialVersionUID = 0L;
                            private final KafkaServer server$3;

                            public final boolean apply(TopicPartition tp) {
                                Seq checkpoints = (Seq)this.server$3.getLogManager().liveLogDirs().map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Map<TopicPartition, Object> apply(File logDir) {
                                        return new OffsetCheckpointFile(new File(logDir, "cleaner-offset-checkpoint"), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read();
                                    }
                                }, Seq$.MODULE$.canBuildFrom());
                                return checkpoints.forall((Function1)new Serializable(this, tp){
                                    public static final long serialVersionUID = 0L;
                                    private final TopicPartition tp$3;

                                    public final boolean apply(Map<TopicPartition, Object> checkpointsPerLogDir) {
                                        return !checkpointsPerLogDir.contains((Object)this.tp$3);
                                    }
                                    {
                                        this.tp$3 = tp$3;
                                    }
                                });
                            }
                            {
                                this.server$3 = server$3;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.servers$4 = servers$4;
                this.topicPartitions$1 = topicPartitions$1;
            }
        }, (Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Cleaner offset for deleted partition should have been removed";
            }
        }, this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
        this.waitUntilTrue((Function0<Object>)new Serializable(servers, topicPartitions){
            public static final long serialVersionUID = 0L;
            private final Seq servers$4;
            public final IndexedSeq topicPartitions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.servers$4.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.verifyTopicDeletion.5 $outer;

                    public final boolean apply(KafkaServer server) {
                        return server.config().logDirs().forall((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$verifyTopicDeletion$5$$anonfun$apply$mcZ$sp$5 $outer;

                            public final boolean apply(String logDir) {
                                return this.$outer.kafka$utils$TestUtils$$anonfun$$anonfun$$$outer().topicPartitions$1.forall((Function1)new Serializable(this, logDir){
                                    public static final long serialVersionUID = 0L;
                                    private final String logDir$1;

                                    public final boolean apply(TopicPartition tp) {
                                        return !new File(this.logDir$1, new StringBuilder().append((Object)tp.topic()).append((Object)"-").append((Object)BoxesRunTime.boxToInteger((int)tp.partition())).toString()).exists();
                                    }
                                    {
                                        this.logDir$1 = logDir$1;
                                    }
                                });
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ anonfun.verifyTopicDeletion.5 kafka$utils$TestUtils$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.servers$4 = servers$4;
                this.topicPartitions$1 = topicPartitions$1;
            }
        }, (Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to soft-delete the data to a delete directory";
            }
        }, this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
        this.waitUntilTrue((Function0<Object>)new Serializable(servers, topicPartitions){
            public static final long serialVersionUID = 0L;
            private final Seq servers$4;
            public final IndexedSeq topicPartitions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.servers$4.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.verifyTopicDeletion.6 $outer;

                    public final boolean apply(KafkaServer server) {
                        return server.config().logDirs().forall((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$verifyTopicDeletion$6$$anonfun$apply$mcZ$sp$6 $outer;

                            public final boolean apply(String logDir) {
                                return this.$outer.kafka$utils$TestUtils$$anonfun$$anonfun$$$outer().topicPartitions$1.forall((Function1)new Serializable(this, logDir){
                                    public static final long serialVersionUID = 0L;
                                    private final String logDir$2;

                                    public final boolean apply(TopicPartition tp) {
                                        return !((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(Arrays.asList((Object[])new String[][]{new File(this.logDir$2).list()})).asScala()).exists((Function1)new Serializable(this, tp){
                                            public static final long serialVersionUID = 0L;
                                            private final TopicPartition tp$4;

                                            public final boolean apply(String[] partitionDirectoryName) {
                                                return Predef$.MODULE$.refArrayOps((Object[])partitionDirectoryName).startsWith((GenSeq)Predef$.MODULE$.wrapString(new StringBuilder().append((Object)this.tp$4.topic()).append((Object)"-").append((Object)BoxesRunTime.boxToInteger((int)this.tp$4.partition())).toString())) && Predef$.MODULE$.refArrayOps((Object[])partitionDirectoryName).endsWith((GenSeq)Predef$.MODULE$.wrapString(Log$.MODULE$.DeleteDirSuffix()));
                                            }
                                            {
                                                this.tp$4 = tp$4;
                                            }
                                        });
                                    }
                                    {
                                        this.logDir$2 = logDir$2;
                                    }
                                });
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ anonfun.verifyTopicDeletion.6 kafka$utils$TestUtils$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.servers$4 = servers$4;
                this.topicPartitions$1 = topicPartitions$1;
            }
        }, (Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to hard-delete the delete directory";
            }
        }, this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
    }

    public String readString(ByteBuffer buffer, String encoding) {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return new String(bytes, encoding);
    }

    public String readString$default$2() {
        return Charset.defaultCharset().toString();
    }

    /*
     * WARNING - void declaration
     */
    public Properties copyOf(Properties props) {
        void var2_2;
        Properties copy = new Properties();
        Implicits$.MODULE$.PropertiesOps(copy).$plus$plus$eq(props);
        return var2_2;
    }

    public Properties sslConfigs(Mode mode, boolean clientCert, Option<File> trustStoreFile, String certAlias, String certCn) {
        File trustStore = (File)trustStoreFile.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new Exception("SSL enabled but no trustStoreFile provided");
            }
        });
        java.util.Map sslConfigs2 = TestSslUtils.createSslConfig((boolean)clientCert, (boolean)true, (Mode)mode, (File)trustStore, (String)certAlias, (String)certCn);
        Properties sslProps = new Properties();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(sslConfigs2).asScala()).foreach((Function1)new Serializable(sslProps){
            public static final long serialVersionUID = 0L;
            private final Properties sslProps$1;

            public final Object apply(Tuple2<String, Object> x0$7) {
                Tuple2<String, Object> tuple2 = x0$7;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    Object v = tuple2._2();
                    Object object = this.sslProps$1.put(k, v);
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.sslProps$1 = sslProps$1;
            }
        });
        return sslProps;
    }

    public String sslConfigs$default$5() {
        return this.SslCertificateCn();
    }

    /*
     * WARNING - void declaration
     */
    public X509TrustManager trustAllCerts() {
        void var1_1;
        X509TrustManager trustManager = new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        };
        return var1_1;
    }

    public void waitAndVerifyAcls(Set<Acl> expected, Authorizer authorizer, Resource resource) {
        String newLine = Properties$.MODULE$.lineSeparator();
        this.waitUntilTrue((Function0<Object>)new Serializable(expected, authorizer, resource){
            public static final long serialVersionUID = 0L;
            private final Set expected$1;
            private final Authorizer authorizer$1;
            private final Resource resource$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Set set = this.authorizer$1.getAcls(this.resource$1);
                Set set2 = this.expected$1;
                return !(set != null ? !set.equals(set2) : set2 != null);
            }
            {
                this.expected$1 = expected$1;
                this.authorizer$1 = authorizer$1;
                this.resource$1 = resource$1;
            }
        }, (Function0<String>)new Serializable(expected, authorizer, resource, newLine){
            public static final long serialVersionUID = 0L;
            private final Set expected$1;
            private final Authorizer authorizer$1;
            private final Resource resource$1;
            private final String newLine$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected acls:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.expected$1.mkString(new StringBuilder().append((Object)this.newLine$1).append((Object)"\t").toString(), new StringBuilder().append((Object)this.newLine$1).append((Object)"\t").toString(), this.newLine$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but got:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.authorizer$1.getAcls(this.resource$1).mkString(new StringBuilder().append((Object)this.newLine$1).append((Object)"\t").toString(), new StringBuilder().append((Object)this.newLine$1).append((Object)"\t").toString(), this.newLine$1)}))).toString();
            }
            {
                this.expected$1 = expected$1;
                this.authorizer$1 = authorizer$1;
                this.resource$1 = resource$1;
                this.newLine$1 = newLine$1;
            }
        }, 15000L, this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
    }

    public boolean isAclSecure(ACL acl, boolean sensitive) {
        boolean bl;
        this.debug((Function0<String>)new Serializable(acl){
            public static final long serialVersionUID = 0L;
            private final ACL acl$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ACL ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.acl$1}));
            }
            {
                this.acl$1 = acl$1;
            }
        });
        int n = acl.getPerms();
        switch (n) {
            default: {
                bl = false;
                break;
            }
            case 31: {
                String string = acl.getId().getScheme();
                String string2 = "sasl";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 1: {
                if (!sensitive) {
                    String string = acl.getId().getScheme();
                    String string3 = "world";
                    if (!(string != null ? !string.equals(string3) : string3 != null)) {
                        bl = true;
                        break;
                    }
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean isAclUnsecure(ACL acl) {
        boolean bl;
        this.debug((Function0<String>)new Serializable(acl){
            public static final long serialVersionUID = 0L;
            private final ACL acl$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ACL ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.acl$2}));
            }
            {
                this.acl$2 = acl$2;
            }
        });
        int n = acl.getPerms();
        switch (n) {
            default: {
                bl = false;
                break;
            }
            case 31: {
                String string = acl.getId().getScheme();
                String string2 = "world";
                bl = !(string != null ? !string.equals(string2) : string2 != null);
            }
        }
        return bl;
    }

    private Seq<String> secureZkPaths(ZkUtils zkUtils) {
        Seq topLevelPaths = (Seq)ZkUtils$.MODULE$.SecureZkRootPaths().$plus$plus((GenTraversableOnce)ZkUtils$.MODULE$.SensitiveZkRootPaths(), Seq$.MODULE$.canBuildFrom());
        return (Seq)topLevelPaths.flatMap((Function1)new Serializable(zkUtils){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$3;

            public final Seq<String> apply(String path) {
                return TestUtils$.MODULE$.kafka$utils$TestUtils$$subPaths$1(path, this.zkUtils$3);
            }
            {
                this.zkUtils$3 = zkUtils$3;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public void verifySecureZkAcls(ZkUtils zkUtils, int usersWithAccess) {
        this.secureZkPaths(zkUtils).foreach((Function1)new Serializable(zkUtils, usersWithAccess){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$2;
            private final int usersWithAccess$1;

            public final void apply(String path) {
                if (this.zkUtils$2.pathExists(path)) {
                    boolean sensitive = ZkUtils$.MODULE$.sensitivePath(path);
                    int aclCount = sensitive ? this.usersWithAccess$1 : this.usersWithAccess$1 + 1;
                    java.util.List acls = (java.util.List)this.zkUtils$2.zkConnection().getAcl(path).getKey();
                    Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid ACLs for ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path, acls})), (long)aclCount, (long)acls.size());
                    ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(acls).asScala()).foreach((Function1)new Serializable(this, sensitive){
                        public static final long serialVersionUID = 0L;
                        private final boolean sensitive$1;

                        public final boolean apply(ACL acl) {
                            return TestUtils$.MODULE$.isAclSecure(acl, this.sensitive$1);
                        }
                        {
                            this.sensitive$1 = sensitive$1;
                        }
                    });
                }
            }
            {
                this.zkUtils$2 = zkUtils$2;
                this.usersWithAccess$1 = usersWithAccess$1;
            }
        });
    }

    public void verifyUnsecureZkAcls(ZkUtils zkUtils) {
        this.secureZkPaths(zkUtils).foreach((Function1)new Serializable(zkUtils){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$1;

            public final void apply(String path) {
                if (this.zkUtils$1.pathExists(path)) {
                    java.util.List acls = (java.util.List)this.zkUtils$1.zkConnection().getAcl(path).getKey();
                    Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid ACLs for ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path, acls})), (long)1L, (long)acls.size());
                    ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(acls).asScala()).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(ACL acl) {
                            return TestUtils$.MODULE$.isAclUnsecure(acl);
                        }
                    });
                }
            }
            {
                this.zkUtils$1 = zkUtils$1;
            }
        });
    }

    public void assertConcurrent(String message, Seq<Function0<Object>> functions, int timeoutMs) {
        int numThreads = functions.size();
        ExecutorService threadPool = Executors.newFixedThreadPool(numThreads);
        ArrayBuffer exceptions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        try {
            ArrayBuffer arrayBuffer;
            try {
                java.util.List runnables = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)functions.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(Function0<Object> function) {
                        return new Callable<BoxedUnit>(this, function){
                            private final Function0 function$1;

                            public void call() {
                                this.function$1.apply();
                            }
                            {
                                this.function$1 = function$1;
                            }
                        };
                    }
                }, Seq$.MODULE$.canBuildFrom())).asJava();
                Buffer futures = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(threadPool.invokeAll(runnables, timeoutMs, TimeUnit.MILLISECONDS)).asScala();
                futures.foreach((Function1)new Serializable(message, timeoutMs, exceptions){
                    public static final long serialVersionUID = 0L;
                    private final String message$1;
                    private final int timeoutMs$2;
                    private final ArrayBuffer exceptions$1;

                    public final Object apply(Future<BoxedUnit> future) {
                        BoxedUnit boxedUnit;
                        if (future.isCancelled()) {
                            TestUtils$.MODULE$.kafka$utils$TestUtils$$failWithTimeout$1(this.message$1, this.timeoutMs$2);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            try {
                                boxedUnit = future.get();
                            }
                            catch (Exception exception) {
                                boxedUnit = this.exceptions$1.$plus$eq((Object)exception);
                            }
                        }
                        return boxedUnit;
                    }
                    {
                        this.message$1 = message$1;
                        this.timeoutMs$2 = timeoutMs$2;
                        this.exceptions$1 = exceptions$1;
                    }
                });
                arrayBuffer = BoxedUnit.UNIT;
            }
            catch (Throwable throwable) {
                arrayBuffer = exceptions.$plus$eq((Object)throwable);
            }
            catch (InterruptedException interruptedException) {
                this.kafka$utils$TestUtils$$failWithTimeout$1(message, timeoutMs);
                arrayBuffer = BoxedUnit.UNIT;
            }
        }
        finally {
            threadPool.shutdownNow();
        }
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " failed with exception(s) ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message, exceptions})), (boolean)exceptions.isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    public <K, V> Seq<ConsumerRecord<byte[], byte[]>> consumeTopicRecords(Seq<KafkaServer> servers, String topic, int numMessages, String groupId, SecurityProtocol securityProtocol, Option<File> trustStoreFile, long waitTime) {
        Seq<ConsumerRecord<K, V>> seq;
        String x$87 = this.getBrokerListStrFromServers(servers, securityProtocol);
        String x$88 = groupId;
        SecurityProtocol x$89 = securityProtocol;
        Option<File> x$90 = trustStoreFile;
        String x$91 = this.createConsumer$default$3();
        boolean x$92 = this.createConsumer$default$4();
        boolean x$93 = this.createConsumer$default$5();
        int x$94 = this.createConsumer$default$6();
        Option<Properties> x$95 = this.createConsumer$default$9();
        ByteArrayDeserializer x$96 = this.createConsumer$default$10();
        ByteArrayDeserializer x$97 = this.createConsumer$default$11();
        KafkaConsumer<K, V> consumer = this.createConsumer(x$87, x$88, x$91, x$92, x$93, x$94, x$89, x$90, x$95, (Deserializer<K>)x$96, (Deserializer<V>)x$97);
        try {
            consumer.subscribe(Collections.singleton(topic));
            seq = this.consumeRecords(consumer, numMessages, waitTime);
        }
        catch (Throwable throwable) {
            void var9_19;
            var9_19.close();
            throw throwable;
        }
        consumer.close();
        return seq;
    }

    public <K, V> String consumeTopicRecords$default$4() {
        return "group";
    }

    public <K, V> SecurityProtocol consumeTopicRecords$default$5() {
        return SecurityProtocol.PLAINTEXT;
    }

    public <K, V> Option<File> consumeTopicRecords$default$6() {
        return None$.MODULE$;
    }

    public <K, V> long consumeTopicRecords$default$7() {
        return 15000L;
    }

    public <K, V> Seq<ConsumerRecord<K, V>> consumeRecords(KafkaConsumer<K, V> consumer, int numMessages, long waitTime) {
        ArrayBuffer records2 = new ArrayBuffer();
        this.waitUntilTrue((Function0<Object>)new Serializable(consumer, numMessages, records2){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$1;
            private final int numMessages$1;
            private final ArrayBuffer records$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.records$2.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)this.consumer$1.poll(Duration.ofMillis(50L))).asScala());
                return this.records$2.size() >= this.numMessages$1;
            }
            {
                this.consumer$1 = consumer$1;
                this.numMessages$1 = numMessages$1;
                this.records$2 = records$2;
            }
        }, (Function0<String>)new Serializable(numMessages, records2){
            public static final long serialVersionUID = 0L;
            private final int numMessages$1;
            private final ArrayBuffer records$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Consumed ", " records until timeout instead of the expected ", " records"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.records$2.size()), BoxesRunTime.boxToInteger((int)this.numMessages$1)}));
            }
            {
                this.numMessages$1 = numMessages$1;
                this.records$2 = records$2;
            }
        }, waitTime, this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
        Assert.assertEquals((String)"Consumed more records than expected", (long)numMessages, (long)records2.size());
        return records2;
    }

    public <K, V> long consumeRecords$default$3() {
        return 15000L;
    }

    public <K, V> Seq<ConsumerRecord<K, V>> consumeRecordsFor(KafkaConsumer<K, V> consumer, long duration) {
        long startTime = System.currentTimeMillis();
        ArrayBuffer records2 = new ArrayBuffer();
        this.waitUntilTrue((Function0<Object>)new Serializable(consumer, duration, startTime, records2){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$5;
            private final long duration$1;
            private final long startTime$1;
            private final ArrayBuffer records$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.records$3.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)this.consumer$5.poll(Duration.ofMillis(50L))).asScala());
                return System.currentTimeMillis() - this.startTime$1 > this.duration$1;
            }
            {
                this.consumer$5 = consumer$5;
                this.duration$1 = duration$1;
                this.startTime$1 = startTime$1;
                this.records$3 = records$3;
            }
        }, (Function0<String>)new Serializable(duration){
            public static final long serialVersionUID = 0L;
            private final long duration$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The timeout ", " was greater than the maximum wait time."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.duration$1)}));
            }
            {
                this.duration$1 = duration$1;
            }
        }, this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
        return records2;
    }

    public <K, V> long consumeRecordsFor$default$2() {
        return 15000L;
    }

    public KafkaProducer<byte[], byte[]> createTransactionalProducer(String transactionalId, Seq<KafkaServer> servers, int batchSize, long transactionTimeoutMs) {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.getBrokerListStrFromServers(servers, this.getBrokerListStrFromServers$default$2()));
        props.put("acks", "all");
        props.put("batch.size", ((Object)BoxesRunTime.boxToInteger((int)batchSize)).toString());
        props.put("transactional.id", transactionalId);
        props.put("enable.idempotence", "true");
        props.put("transaction.timeout.ms", ((Object)BoxesRunTime.boxToLong((long)transactionTimeoutMs)).toString());
        return new KafkaProducer(props, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
    }

    public int createTransactionalProducer$default$3() {
        return 16384;
    }

    public long createTransactionalProducer$default$4() {
        return 60000L;
    }

    /*
     * WARNING - void declaration
     */
    public void seedTopicWithNumberedRecords(String topic, int numRecords, Seq<KafkaServer> servers) {
        Properties props = new Properties();
        props.put("enable.idempotence", "true");
        props.put("bootstrap.servers", this.getBrokerListStrFromServers(servers, this.getBrokerListStrFromServers$default$2()));
        KafkaProducer producer = new KafkaProducer(props, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1)new Serializable(topic, producer){
                public static final long serialVersionUID = 0L;
                private final String topic$5;
                private final KafkaProducer producer$2;

                public final Future<RecordMetadata> apply(int i) {
                    return this.producer$2.send(new ProducerRecord(this.topic$5, (Object)TestUtils$.MODULE$.kafka$utils$TestUtils$$asBytes(((Object)BoxesRunTime.boxToInteger((int)i)).toString()), (Object)TestUtils$.MODULE$.kafka$utils$TestUtils$$asBytes(((Object)BoxesRunTime.boxToInteger((int)i)).toString())));
                }
                {
                    this.topic$5 = topic$5;
                    this.producer$2 = producer$2;
                }
            });
            producer.flush();
        }
        catch (Throwable throwable) {
            void var5_5;
            var5_5.close();
            throw throwable;
        }
        producer.close();
    }

    private String asString(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public byte[] kafka$utils$TestUtils$$asBytes(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    public String assertCommittedAndGetValue(ConsumerRecord<byte[], byte[]> record) {
        Option option = ((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(record.headers().headers(this.kafka$utils$TestUtils$$transactionStatusKey())).asScala()).headOption();
        if (option instanceof Some) {
            Some some = (Some)option;
            Header header = (Header)some.x();
            Assert.assertEquals((String)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got ", " but expected the value to indicate "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.asString(header.value())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"committed status."})).s((Seq)Nil$.MODULE$)).toString(), (Object)this.asString(this.kafka$utils$TestUtils$$committedValue()), (Object)this.asString(header.value()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.recordValueAsString(record);
        }
        if (None$.MODULE$.equals(option)) {
            throw this.fail("expected the record header to include an expected transaction status, but received nothing.");
        }
        throw new MatchError((Object)option);
    }

    public String recordValueAsString(ConsumerRecord<byte[], byte[]> record) {
        return this.asString((byte[])record.value());
    }

    public ProducerRecord<byte[], byte[]> producerRecordWithExpectedTransactionStatus(String topic, byte[] key, byte[] value, boolean willBeCommitted) {
        Header header = new Header(willBeCommitted){
            private final boolean willBeCommitted$1;

            public String key() {
                return TestUtils$.MODULE$.kafka$utils$TestUtils$$transactionStatusKey();
            }

            public byte[] value() {
                return this.willBeCommitted$1 ? TestUtils$.MODULE$.kafka$utils$TestUtils$$committedValue() : TestUtils$.MODULE$.kafka$utils$TestUtils$$abortedValue();
            }
            {
                this.willBeCommitted$1 = willBeCommitted$1;
            }
        };
        return new ProducerRecord(topic, null, (Object)key, (Object)value, Collections.singleton(header));
    }

    public ProducerRecord<byte[], byte[]> producerRecordWithExpectedTransactionStatus(String topic, String key, String value, boolean willBeCommitted) {
        return this.producerRecordWithExpectedTransactionStatus(topic, this.kafka$utils$TestUtils$$asBytes(key), this.kafka$utils$TestUtils$$asBytes(value), willBeCommitted);
    }

    public Map<TopicPartition, OffsetAndMetadata> consumerPositions(KafkaConsumer<byte[], byte[]> consumer) {
        HashMap offsetsToCommit = new HashMap();
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(consumer.assignment()).asScala()).foreach((Function1)new Serializable(consumer, offsetsToCommit){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$3;
            private final HashMap offsetsToCommit$1;

            public final Option<OffsetAndMetadata> apply(TopicPartition topicPartition) {
                return this.offsetsToCommit$1.put((Object)topicPartition, (Object)new OffsetAndMetadata(this.consumer$3.position(topicPartition)));
            }
            {
                this.consumer$3 = consumer$3;
                this.offsetsToCommit$1 = offsetsToCommit$1;
            }
        });
        return offsetsToCommit.toMap(Predef$.MODULE$.$conforms());
    }

    /*
     * WARNING - void declaration
     */
    public Seq<ConsumerRecord<byte[], byte[]>> pollUntilAtLeastNumRecords(KafkaConsumer<byte[], byte[]> consumer, int numRecords) {
        void var3_3;
        ArrayBuffer records2 = new ArrayBuffer();
        this.waitUntilTrue((Function0<Object>)new Serializable(consumer, numRecords, records2){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$2;
            private final int numRecords$1;
            private final ArrayBuffer records$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.records$4.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)this.consumer$2.poll(Duration.ofMillis(50L))).asScala());
                return this.records$4.size() >= this.numRecords$1;
            }
            {
                this.consumer$2 = consumer$2;
                this.numRecords$1 = numRecords$1;
                this.records$4 = records$4;
            }
        }, (Function0<String>)new Serializable(numRecords, records2){
            public static final long serialVersionUID = 0L;
            private final int numRecords$1;
            private final ArrayBuffer records$4;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Consumed ", " records until timeout, but expected ", " records."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.records$4.size()), BoxesRunTime.boxToInteger((int)this.numRecords$1)}));
            }
            {
                this.numRecords$1 = numRecords$1;
                this.records$4 = records$4;
            }
        }, this.waitUntilTrue$default$3(), this.waitUntilTrue$default$4(), this.waitUntilTrue$default$5());
        return var3_3;
    }

    public void resetToCommittedPositions(KafkaConsumer<byte[], byte[]> consumer) {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(consumer.assignment()).asScala()).foreach((Function1)new Serializable(consumer){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$4;

            public final void apply(TopicPartition topicPartition) {
                OffsetAndMetadata offset = this.consumer$4.committed(topicPartition);
                if (offset == null) {
                    this.consumer$4.seekToBeginning(Collections.singletonList(topicPartition));
                } else {
                    this.consumer$4.seek(topicPartition, offset.offset());
                }
            }
            {
                this.consumer$4 = consumer$4;
            }
        });
    }

    public AlterConfigsResult alterConfigs(Seq<KafkaServer> servers, AdminClient adminClient, Properties props, boolean perBrokerConfig) {
        java.util.List configEntries = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ConfigEntry apply(Tuple2<String, String> x0$8) {
                Tuple2<String, String> tuple2 = x0$8;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    ConfigEntry configEntry2 = new ConfigEntry(k, v);
                    return configEntry2;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList()).asJava();
        Config newConfig = new Config((Collection)configEntries);
        java.util.Map configs = perBrokerConfig ? (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)servers.map((Function1)new Serializable(newConfig){
            public static final long serialVersionUID = 0L;
            private final Config newConfig$1;

            public final Tuple2<ConfigResource, Config> apply(KafkaServer server) {
                ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.boxToInteger((int)server.config().brokerId())).toString());
                return new Tuple2((Object)resource, (Object)this.newConfig$1);
            }
            {
                this.newConfig$1 = newConfig$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava() : (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.BROKER, "")), (Object)newConfig)}))).asJava();
        return adminClient.alterConfigs(configs);
    }

    public AlterConfigsResult alterTopicConfigs(AdminClient adminClient, String topic, Properties topicConfigs) {
        java.util.List configEntries = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(topicConfigs).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ConfigEntry apply(Tuple2<String, String> x0$9) {
                Tuple2<String, String> tuple2 = x0$9;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    ConfigEntry configEntry2 = new ConfigEntry(k, v);
                    return configEntry2;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList()).asJava();
        Config newConfig = new Config((Collection)configEntries);
        java.util.Map configs = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, topic)), (Object)newConfig)}))).asJava();
        return adminClient.alterConfigs(configs);
    }

    public String grabConsoleOutput(Function0<BoxedUnit> f) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)out, f);
            return out.toString();
        }
        finally {
            Console$.MODULE$.out().flush();
        }
    }

    public String grabConsoleError(Function0<BoxedUnit> f) {
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withErr((OutputStream)err, f);
            return err.toString();
        }
        finally {
            Console$.MODULE$.err().flush();
        }
    }

    public Tuple2<String, String> grabConsoleOutputAndError(Function0<BoxedUnit> f) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)out, (Function0)new Serializable(f, err){
                public static final long serialVersionUID = 0L;
                private final Function0 f$1;
                private final ByteArrayOutputStream err$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    Console$.MODULE$.withErr((OutputStream)this.err$1, this.f$1);
                }
                {
                    this.f$1 = f$1;
                    this.err$1 = err$1;
                }
            });
            return new Tuple2((Object)out.toString(), (Object)err.toString());
        }
        finally {
            Console$.MODULE$.out().flush();
            Console$.MODULE$.err().flush();
        }
    }

    public void assertFutureExceptionTypeEquals(KafkaFuture<?> future, Class<? extends Throwable> clazz) {
        try {
            future.get();
            throw this.fail("Expected CompletableFuture.get to return an exception");
        }
        catch (ExecutionException executionException) {
            Throwable cause = executionException.getCause();
            Assert.assertTrue((String)new StringBuilder().append((Object)"Expected an exception of type ").append((Object)clazz.getName()).append((Object)"; got type ").append((Object)cause.getClass().getName()).toString(), (boolean)clazz.isInstance(cause));
            return;
        }
    }

    public long totalMetricValue(KafkaServer server, String metricName) {
        java.util.Map allMetrics = server.metrics().metrics();
        double total = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(allMetrics.values()).asScala()).filter((Function1)new Serializable(metricName){
            public static final long serialVersionUID = 0L;
            private final String metricName$1;

            public final boolean apply(KafkaMetric x$26) {
                String string = x$26.metricName().name();
                String string2 = this.metricName$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.metricName$1 = metricName$1;
            }
        })).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double total, KafkaMetric metric) {
                return total + BoxesRunTime.unboxToDouble((Object)metric.metricValue());
            }
        }));
        return (long)total;
    }

    private final boolean shouldEnable$1(SecurityProtocol protocol, Option interBrokerSecurityProtocol$2) {
        return BoxesRunTime.unboxToBoolean((Object)interBrokerSecurityProtocol$2.fold((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }, (Function1)new Serializable(protocol){
            public static final long serialVersionUID = 0L;
            private final SecurityProtocol protocol$2;

            public final boolean apply(SecurityProtocol x$4) {
                SecurityProtocol securityProtocol = x$4;
                SecurityProtocol securityProtocol2 = this.protocol$2;
                return !(securityProtocol != null ? !securityProtocol.equals(securityProtocol2) : securityProtocol2 != null);
            }
            {
                this.protocol$2 = protocol$2;
            }
        }));
    }

    public final Option kafka$utils$TestUtils$$newLeaderExists$1(Seq servers$7, TopicPartition tp$1, int oldLeader$1) {
        return servers$7.find((Function1)new Serializable(tp$1, oldLeader$1){
            public static final long serialVersionUID = 0L;
            private final TopicPartition tp$1;
            private final int oldLeader$1;

            public final boolean apply(KafkaServer server) {
                return server.config().brokerId() != this.oldLeader$1 && server.replicaManager().getPartition(this.tp$1).exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Partition x$16) {
                        return x$16.leaderReplicaIfLocal().isDefined();
                    }
                });
            }
            {
                this.tp$1 = tp$1;
                this.oldLeader$1 = oldLeader$1;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$17) {
                return x$17.config().brokerId();
            }
        });
    }

    public final Option kafka$utils$TestUtils$$leaderIfExists$1(Seq servers$8, TopicPartition tp$2) {
        return servers$8.find((Function1)new Serializable(tp$2){
            public static final long serialVersionUID = 0L;
            private final TopicPartition tp$2;

            public final boolean apply(KafkaServer server) {
                return server.replicaManager().getPartition(this.tp$2).exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Partition x$18) {
                        return x$18.leaderReplicaIfLocal().isDefined();
                    }
                });
            }
            {
                this.tp$2 = tp$2;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$19) {
                return x$19.config().brokerId();
            }
        });
    }

    public final Seq kafka$utils$TestUtils$$subPaths$1(String path, ZkUtils zkUtils$3) {
        Seq seq;
        if (zkUtils$3.pathExists(path)) {
            String string = path;
            seq = (Seq)((SeqLike)((TraversableLike)zkUtils$3.getChildren(path).map((Function1)new Serializable(path){
                public static final long serialVersionUID = 0L;
                private final String path$1;

                public final String apply(String c) {
                    return new StringBuilder().append((Object)this.path$1).append((Object)"/").append((Object)c).toString();
                }
                {
                    this.path$1 = path$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(zkUtils$3){
                public static final long serialVersionUID = 0L;
                private final ZkUtils zkUtils$3;

                public final Seq<String> apply(String path) {
                    return TestUtils$.MODULE$.kafka$utils$TestUtils$$subPaths$1(path, this.zkUtils$3);
                }
                {
                    this.zkUtils$3 = zkUtils$3;
                }
            }, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom());
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    public final void kafka$utils$TestUtils$$failWithTimeout$1(String message$1, int timeoutMs$2) {
        throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ". Timed out, the concurrent functions took more than ", " milliseconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message$1, BoxesRunTime.boxToInteger((int)timeoutMs$2)})));
    }

    private TestUtils$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.random = TestUtils.RANDOM;
        this.RandomPort = 0;
        this.MockZkPort = 1;
        this.MockZkConnect = new StringBuilder().append((Object)"127.0.0.1:").append((Object)BoxesRunTime.boxToInteger((int)this.MockZkPort())).toString();
        this.SslCertificateCn = "localhost";
        this.kafka$utils$TestUtils$$transactionStatusKey = "transactionStatus";
        this.kafka$utils$TestUtils$$committedValue = "committed".getBytes(StandardCharsets.UTF_8);
        this.kafka$utils$TestUtils$$abortedValue = "aborted".getBytes(StandardCharsets.UTF_8);
    }
}

