/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Optional;
import java.util.Properties;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.LogManager;
import kafka.server.AbstractFetcherThread;
import kafka.server.BlockingSend;
import kafka.server.Fetching$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.OffsetAndEpoch;
import kafka.server.PartitionFetchState;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaAlterLogDirsManager;
import kafka.server.ReplicaFetcherThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicaState;
import kafka.server.ReplicationQuotaManager;
import kafka.server.Truncating$;
import kafka.server.epoch.util.ReplicaFetcherMockBlockingSend;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.CaptureType;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.immutable.List$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u0001\u0003\u0001\u001d\u0011\u0001DU3qY&\u001c\u0017MR3uG\",'\u000f\u00165sK\u0006$G+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\b)\u0001\u0011\r\u0011\"\u0003\u0016\u0003\u0011!\u0018\u0007\u001d\u0019\u0016\u0003Y\u0001\"aF\u0010\u000e\u0003aQ!!\u0007\u000e\u0002\r\r|W.\\8o\u0015\t)1D\u0003\u0002\u001d;\u00051\u0011\r]1dQ\u0016T\u0011AH\u0001\u0004_J<\u0017B\u0001\u0011\u0019\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:DaA\t\u0001!\u0002\u00131\u0012!\u0002;2aB\u0002\u0003b\u0002\u0013\u0001\u0005\u0004%I!F\u0001\u0005iF\u0002\u0018\u0007\u0003\u0004'\u0001\u0001\u0006IAF\u0001\u0006iF\u0002\u0018\u0007\t\u0005\bQ\u0001\u0011\r\u0011\"\u0003\u0016\u0003\u0011!(\u0007]\u0019\t\r)\u0002\u0001\u0015!\u0003\u0017\u0003\u0015!(\u0007]\u0019!\u0011\u001da\u0003\u00011A\u0005\n5\na\u0001^8GC&dW#\u0001\u0018\u0011\u0005%y\u0013B\u0001\u0019\u000b\u0005\u001d\u0011un\u001c7fC:DqA\r\u0001A\u0002\u0013%1'\u0001\u0006u_\u001a\u000b\u0017\u000e\\0%KF$\"\u0001N\u001c\u0011\u0005%)\u0014B\u0001\u001c\u000b\u0005\u0011)f.\u001b;\t\u000fa\n\u0014\u0011!a\u0001]\u0005\u0019\u0001\u0010J\u0019\t\ri\u0002\u0001\u0015)\u0003/\u0003\u001d!xNR1jY\u0002Bq\u0001\u0010\u0001C\u0002\u0013%Q(\u0001\bce>\\WM]#oIB{\u0017N\u001c;\u0016\u0003y\u0002\"a\u0010\"\u000e\u0003\u0001S!!\u0011\u0003\u0002\u000f\rdWo\u001d;fe&\u00111\t\u0011\u0002\u000f\u0005J|7.\u001a:F]\u0012\u0004v.\u001b8u\u0011\u0019)\u0005\u0001)A\u0005}\u0005y!M]8lKJ,e\u000e\u001a)pS:$\b\u0005C\u0003H\u0001\u0011%\u0001*\u0001\bpM\u001a\u001cX\r^!oI\u0016\u0003xn\u00195\u0015\u0007%c\u0015\u000b\u0005\u0002\u0013\u0015&\u00111J\u0001\u0002\u000f\u001f\u001a47/\u001a;B]\u0012,\u0005o\\2i\u0011\u0015ie\t1\u0001O\u0003-1W\r^2i\u001f\u001a47/\u001a;\u0011\u0005%y\u0015B\u0001)\u000b\u0005\u0011auN\\4\t\u000fI3\u0005\u0013!a\u0001'\u0006YA.Z1eKJ,\u0005o\\2i!\tIA+\u0003\u0002V\u0015\t\u0019\u0011J\u001c;\t\u000b]\u0003A\u0011\u0001-\u0002QMDw.\u001e7e'\u0016tG\rT1uKN$(+Z9vKN$h+\u001a:tS>t7OQ=EK\u001a\fW\u000f\u001c;\u0015\u0003QB#A\u0016.\u0011\u0005msV\"\u0001/\u000b\u0005uk\u0012!\u00026v]&$\u0018BA0]\u0005\u0011!Vm\u001d;\t\u000b\u0005\u0004A\u0011\u0001-\u0002\u0001NDw.\u001e7e\r\u0016$8\r\u001b'fC\u0012,'/\u00129pG\"\u0014V-];fgRLe\rT1ti\u0016\u0003xn\u00195EK\u001aLg.\u001a3G_J\u001cv.\\3QCJ$\u0018\u000e^5p]ND#\u0001\u0019.\t\u000b\u0011\u0004A\u0011A3\u0002+\u0005\u001c8/\u001a:u!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;fgR)AGZ6n_\")qm\u0019a\u0001Q\u00069a-\u001a;dQ\u0016\u0014\bC\u0001\nj\u0013\tQ'AA\u000bBEN$(/Y2u\r\u0016$8\r[3s)\"\u0014X-\u00193\t\u000b1\u001c\u0007\u0019\u0001\u0018\u0002+MDw.\u001e7e\u0005\u0016\u0014V-\u00193z\r>\u0014h)\u001a;dQ\")an\u0019a\u0001]\u0005)2\u000f[8vY\u0012\u0014U\r\u0016:v]\u000e\fG/\u001b8h\u0019><\u0007\"\u00029d\u0001\u0004q\u0013aD:i_VdGMQ3EK2\f\u00170\u001a3\t\u000bI\u0004A\u0011\u0001-\u0002KMDw.\u001e7e\u0011\u0006tG\r\\3Fq\u000e,\u0007\u000f^5p]\u001a\u0013x.\u001c\"m_\u000e\\\u0017N\\4TK:$\u0007FA9[\u0011\u0015)\b\u0001\"\u0001Y\u0003y\u001a\bn\\;mI\u001a+Go\u00195MK\u0006$WM]#q_\u000eDwJ\u001c$jeN$h)\u001a;dQ>sG._%g\u0019\u0016\fG-\u001a:Fa>\u001c\u0007n\u00138po:$vNQ8uQ\"\u0012AO\u0017\u0005\u0006q\u0002!\t\u0001W\u00015g\"|W\u000f\u001c3UeVt7-\u0019;f)>|eMZ:fiN\u0003XmY5gS\u0016$\u0017J\\#q_\u000eDwJ\u001a4tKR\u0014Vm\u001d9p]N,\u0007FA<[\u0011\u0015Y\b\u0001\"\u0001Y\u00035\u001b\bn\\;mIR\u0013XO\\2bi\u0016$vn\u00144gg\u0016$8\u000b]3dS\u001aLW\rZ%o\u000bB|7\r[(gMN,GOU3ta>t7/Z%g\r>dGn\\<fe\"\u000b7OT8N_J,W\t]8dQND#A\u001f.\t\u000by\u0004A\u0011\u0001-\u0002\u0015NDw.\u001e7e\r\u0016$8\r\u001b'fC\u0012,'/\u00129pG\"\u001cVmY8oIRKW.Z%g\u0019\u0016\fG-\u001a:SKBd\u0017.Z:XSRDW\t]8dQ:{Go\u00138po:$vNR8mY><XM\u001d\u0015\u0003{jCa!a\u0001\u0001\t\u0003A\u0016aM:i_VdG-V:f\u0019\u0016\fG-\u001a:F]\u0012|eMZ:fi&3\u0017J\u001c;fe\n\u0013xn[3s-\u0016\u00148/[8o\u0005\u0016dwn\u001e\u001a1Q\r\t\tA\u0017\u0005\u0007\u0003\u0013\u0001A\u0011\u0001-\u0002\u0001NDw.\u001e7e)J,hnY1uKR{\u0017J\\5uS\u0006dg)\u001a;dQ>3gm]3u\u0013\u001adU-\u00193feJ+G/\u001e:ogVsG-\u001a4j]\u0016$wJ\u001a4tKRD3!a\u0002[\u0011\u0019\ty\u0001\u0001C\u00011\u0006\t4\u000f[8vY\u0012\u0004v\u000e\u001c7J]\u0012,g-\u001b8ji\u0016d\u00170\u00134MK\u0006$WM\u001d*fiV\u0014hn]!os\u0016C8-\u001a9uS>t\u0007fAA\u00075\"1\u0011Q\u0003\u0001\u0005\u0002a\u000b1f\u001d5pk2$Wj\u001c<f!\u0006\u0014H/\u001b;j_:\u001cx*\u001e;PMR\u0013XO\\2bi&tw\rT8h'R\fG/\u001a\u0015\u0004\u0003'Q\u0006BBA\u000e\u0001\u0011\u0005\u0001,\u0001\u001dtQ>,H\u000e\u001a$jYR,'\u000fU1si&$\u0018n\u001c8t\u001b\u0006$W\rT3bI\u0016\u0014H)\u001e:j]\u001edU-\u00193fe\u0016\u0003xn\u00195SKF,Xm\u001d;)\u0007\u0005e!\f\u0003\u0004\u0002\"\u0001!\t\u0001W\u0001Ig\"|W\u000f\u001c3DCR\u001c\u0007.\u0012=dKB$\u0018n\u001c8Ge>l'\t\\8dW&twmU3oI^CWM\\*ikR$\u0018N\\4E_^t'+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012D3!a\b[\u0011\u001d\t9\u0003\u0001C\u0001\u0003S\tAa\u001d;vERA\u00111FA\"\u0003\u001b\n\t\u0006\u0005\u0004\u0002.\u0005M\u0012qG\u0007\u0003\u0003_Q1!!\r\u001e\u0003!)\u0017m]=n_\u000e\\\u0017\u0002BA\u001b\u0003_\u00111#S#ya\u0016\u001cG/\u0019;j_:\u001cV\r\u001e;feN\u0004R!CA\u001d\u0003{I1!a\u000f\u000b\u0005\u0019y\u0005\u000f^5p]B\u0019q(a\u0010\n\u0007\u0005\u0005\u0003IA\u0005QCJ$\u0018\u000e^5p]\"A\u0011QIA\u0013\u0001\u0004\t9%A\u0004sKBd\u0017nY1\u0011\u0007}\nI%C\u0002\u0002L\u0001\u0013qAU3qY&\u001c\u0017\r\u0003\u0005\u0002P\u0005\u0015\u0002\u0019AA\u001f\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0003\u0005\u0002T\u0005\u0015\u0002\u0019AA+\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u00042AEA,\u0013\r\tIF\u0001\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0011%\ti\u0006AI\u0001\n\u0013\ty&\u0001\rpM\u001a\u001cX\r^!oI\u0016\u0003xn\u00195%I\u00164\u0017-\u001e7uII*\"!!\u0019+\u0007M\u000b\u0019g\u000b\u0002\u0002fA!\u0011qMA9\u001b\t\tIG\u0003\u0003\u0002l\u00055\u0014!C;oG\",7m[3e\u0015\r\tyGC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA:\u0003S\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class ReplicaFetcherThreadTest {
    private final TopicPartition t1p0 = new TopicPartition("topic1", 0);
    private final TopicPartition t1p1 = new TopicPartition("topic1", 1);
    private final TopicPartition t2p1 = new TopicPartition("topic2", 1);
    private boolean toFail = false;
    private final BrokerEndPoint brokerEndPoint = new BrokerEndPoint(0, "localhost", 1000);

    private TopicPartition t1p0() {
        return this.t1p0;
    }

    private TopicPartition t1p1() {
        return this.t1p1;
    }

    private TopicPartition t2p1() {
        return this.t2p1;
    }

    private boolean toFail() {
        return this.toFail;
    }

    private void toFail_$eq(boolean x$1) {
        this.toFail = x$1;
    }

    private BrokerEndPoint brokerEndPoint() {
        return this.brokerEndPoint;
    }

    private OffsetAndEpoch offsetAndEpoch(long fetchOffset, int leaderEpoch) {
        return new OffsetAndEpoch(fetchOffset, leaderEpoch);
    }

    private int offsetAndEpoch$default$2() {
        return 1;
    }

    @Test
    public void shouldSendLatestRequestVersionsByDefault() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, null, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, (Option)None$.MODULE$);
        Assert.assertEquals((long)ApiKeys.FETCH.latestVersion(), (long)thread.fetchRequestVersion());
        Assert.assertEquals((long)ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(), (long)thread.offsetForLeaderEpochRequestVersion());
        Assert.assertEquals((long)ApiKeys.LIST_OFFSETS.latestVersion(), (long)thread.listOffsetRequestVersion());
    }

    @Test
    public void shouldFetchLeaderEpochRequestIfLastEpochDefinedForSomePartitions() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        ReplicationQuotaManager quota = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)EasyMock.createMock(ReplicaAlterLogDirsManager.class);
        Replica replica = (Replica)EasyMock.createNiceMock(Replica.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        int leaderEpoch = 5;
        EasyMock.expect((Object)replica.logEndOffset()).andReturn((Object)new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)replica.highWatermark()).andReturn((Object)new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)replica.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).once();
        EasyMock.expect((Object)replica.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).once();
        EasyMock.expect((Object)replica.latestEpoch()).andReturn((Object)None$.MODULE$).once();
        EasyMock.expect((Object)replica.endOffsetForEpoch(leaderEpoch)).andReturn((Object)new Some((Object)new OffsetAndEpoch(0L, leaderEpoch))).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        EasyMock.expect((Object)replicaManager.replicaAlterLogDirsManager()).andReturn((Object)replicaAlterLogDirsManager).anyTimes();
        this.stub(replica, partition, replicaManager);
        partition.truncateTo(EasyMock.anyLong(), EasyMock.anyBoolean());
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quota, replica});
        java.util.Map offsets = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new EpochEndOffset(leaderEpoch, 1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new EpochEndOffset(leaderEpoch, 1L))}))).asJava();
        ReplicaFetcherMockBlockingSend mockNetwork = new ReplicaFetcherMockBlockingSend(offsets, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, (Option)new Some((Object)mockNetwork));
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2()))})));
        this.assertPartitionStates((AbstractFetcherThread)thread, false, true, false);
        thread.doWork();
        Assert.assertEquals((long)1L, (long)mockNetwork.epochFetchCount());
        Assert.assertEquals((long)1L, (long)mockNetwork.fetchCount());
        this.assertPartitionStates((AbstractFetcherThread)thread, true, false, false);
        thread.doWork();
        Assert.assertEquals((long)1L, (long)mockNetwork.epochFetchCount());
        Assert.assertEquals((long)2L, (long)mockNetwork.fetchCount());
        this.assertPartitionStates((AbstractFetcherThread)thread, true, false, false);
        thread.doWork();
        Assert.assertEquals((long)1L, (long)mockNetwork.epochFetchCount());
        Assert.assertEquals((long)3L, (long)mockNetwork.fetchCount());
        this.assertPartitionStates((AbstractFetcherThread)thread, true, false, false);
        EasyMock.verify((Object[])new Object[]{logManager});
    }

    public void assertPartitionStates(AbstractFetcherThread fetcher, boolean shouldBeReadyForFetch, boolean shouldBeTruncatingLog, boolean shouldBeDelayed) {
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.t1p0(), this.t1p1(), this.t2p1()})).foreach((Function1)new Serializable(this, fetcher, shouldBeReadyForFetch, shouldBeTruncatingLog, shouldBeDelayed){
            public static final long serialVersionUID = 0L;
            private final AbstractFetcherThread fetcher$1;
            private final boolean shouldBeReadyForFetch$1;
            private final boolean shouldBeTruncatingLog$1;
            private final boolean shouldBeDelayed$1;

            public final void apply(TopicPartition tp) {
                Assert.assertTrue((boolean)this.fetcher$1.fetchState(tp).isDefined());
                PartitionFetchState fetchState = (PartitionFetchState)this.fetcher$1.fetchState(tp).get();
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition ", " should", " be ready for fetching"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp, this.shouldBeReadyForFetch$1 ? "" : " NOT"})), (Object)BoxesRunTime.boxToBoolean((boolean)this.shouldBeReadyForFetch$1), (Object)BoxesRunTime.boxToBoolean((boolean)fetchState.isReadyForFetch()));
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition ", " should", " be truncating its log"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp, this.shouldBeTruncatingLog$1 ? "" : " NOT"})), (Object)BoxesRunTime.boxToBoolean((boolean)this.shouldBeTruncatingLog$1), (Object)BoxesRunTime.boxToBoolean((boolean)fetchState.isTruncating()));
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition ", " should", " be delayed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp, this.shouldBeDelayed$1 ? "" : " NOT"})), (Object)BoxesRunTime.boxToBoolean((boolean)this.shouldBeDelayed$1), (Object)BoxesRunTime.boxToBoolean((boolean)fetchState.isDelayed()));
            }
            {
                this.fetcher$1 = fetcher$1;
                this.shouldBeReadyForFetch$1 = shouldBeReadyForFetch$1;
                this.shouldBeTruncatingLog$1 = shouldBeTruncatingLog$1;
                this.shouldBeDelayed$1 = shouldBeDelayed$1;
            }
        });
    }

    @Test
    public void shouldHandleExceptionFromBlockingSend() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        BlockingSend mockBlockingSend = (BlockingSend)EasyMock.createMock(BlockingSend.class);
        EasyMock.expect((Object)mockBlockingSend.sendRequest((AbstractRequest.Builder)EasyMock.anyObject())).andThrow((Throwable)new NullPointerException()).once();
        EasyMock.replay((Object[])new Object[]{mockBlockingSend});
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, null, new Metrics(), (Time)new SystemTime(), null, (Option)new Some((Object)mockBlockingSend));
        Map result = thread.fetchEpochEndOffsets((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new OffsetsForLeaderEpochRequest.PartitionData(Optional.empty(), 0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new OffsetsForLeaderEpochRequest.PartitionData(Optional.empty(), 0))})));
        Map expected = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new EpochEndOffset(Errors.UNKNOWN_SERVER_ERROR, -1, -1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new EpochEndOffset(Errors.UNKNOWN_SERVER_ERROR, -1, -1L))}));
        Assert.assertEquals((String)"results from leader epoch request should have undefined offset", (Object)expected, (Object)result);
        EasyMock.verify((Object[])new Object[]{mockBlockingSend});
    }

    @Test
    public void shouldFetchLeaderEpochOnFirstFetchOnlyIfLeaderEpochKnownToBoth() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)EasyMock.createMock(ReplicaAlterLogDirsManager.class);
        Replica replica = (Replica)EasyMock.createNiceMock(Replica.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        int leaderEpoch = 5;
        EasyMock.expect((Object)replica.logEndOffset()).andReturn((Object)new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)replica.highWatermark()).andReturn((Object)new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)replica.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).anyTimes();
        EasyMock.expect((Object)replica.endOffsetForEpoch(leaderEpoch)).andReturn((Object)new Some((Object)new OffsetAndEpoch(0L, leaderEpoch))).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        EasyMock.expect((Object)replicaManager.replicaAlterLogDirsManager()).andReturn((Object)replicaAlterLogDirsManager).anyTimes();
        this.stub(replica, partition, replicaManager);
        partition.truncateTo(EasyMock.anyLong(), EasyMock.anyBoolean());
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, replica});
        java.util.Map offsets = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new EpochEndOffset(leaderEpoch, 1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new EpochEndOffset(leaderEpoch, 1L))}))).asJava();
        ReplicaFetcherMockBlockingSend mockNetwork = new ReplicaFetcherMockBlockingSend(offsets, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, (Option)new Some((Object)mockNetwork));
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2()))})));
        thread.doWork();
        Assert.assertEquals((long)1L, (long)mockNetwork.epochFetchCount());
        Assert.assertEquals((long)1L, (long)mockNetwork.fetchCount());
        thread.doWork();
        Assert.assertEquals((long)1L, (long)mockNetwork.epochFetchCount());
        Assert.assertEquals((long)2L, (long)mockNetwork.fetchCount());
        thread.doWork();
        Assert.assertEquals((long)1L, (long)mockNetwork.epochFetchCount());
        Assert.assertEquals((long)3L, (long)mockNetwork.fetchCount());
        EasyMock.verify((Object[])new Object[]{logManager});
    }

    @Test
    public void shouldTruncateToOffsetSpecifiedInEpochOffsetResponse() {
        Capture truncateToCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        Seq configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom());
        ReplicationQuotaManager quota = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)EasyMock.createMock(ReplicaAlterLogDirsManager.class);
        Replica replica = (Replica)EasyMock.createNiceMock(Replica.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        int leaderEpoch = 5;
        int initialLEO = 200;
        partition.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncateToCapture)), EasyMock.anyBoolean());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)replica.logEndOffset()).andReturn((Object)new LogOffsetMetadata((long)initialLEO, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)replica.highWatermark()).andReturn((Object)new LogOffsetMetadata((long)(initialLEO - 1), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)replica.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).anyTimes();
        EasyMock.expect((Object)replica.endOffsetForEpoch(leaderEpoch)).andReturn((Object)new Some((Object)new OffsetAndEpoch((long)initialLEO, leaderEpoch))).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        EasyMock.expect((Object)replicaManager.replicaAlterLogDirsManager()).andReturn((Object)replicaAlterLogDirsManager).anyTimes();
        this.stub(replica, partition, replicaManager);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quota, replica, partition});
        java.util.Map offsetsReply = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new EpochEndOffset(leaderEpoch, 156L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)new EpochEndOffset(leaderEpoch, 172L))}))).asJava();
        ReplicaFetcherMockBlockingSend mockNetwork = new ReplicaFetcherMockBlockingSend(offsetsReply, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.brokerEndPoint(), (KafkaConfig)configs.apply(0), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, (Option)new Some((Object)mockNetwork));
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2()))})));
        thread.doWork();
        Assert.assertTrue((String)new StringBuilder().append((Object)"Expected ").append((Object)this.t1p0()).append((Object)" to truncate to offset 156 (truncation offsets: ").append((Object)truncateToCapture.getValues()).append((Object)")").toString(), (boolean)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)156)));
        Assert.assertTrue((String)new StringBuilder().append((Object)"Expected ").append((Object)this.t2p1()).append((Object)" to truncate to offset 172 (truncation offsets: ").append((Object)truncateToCapture.getValues()).append((Object)")").toString(), (boolean)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)172)));
    }

    @Test
    public void shouldTruncateToOffsetSpecifiedInEpochOffsetResponseIfFollowerHasNoMoreEpochs() {
        Capture truncateToCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        Seq configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom());
        ReplicationQuotaManager quota = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)EasyMock.createMock(ReplicaAlterLogDirsManager.class);
        Replica replica = (Replica)EasyMock.createNiceMock(Replica.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        int leaderEpochAtFollower = 5;
        int leaderEpochAtLeader = 4;
        int initialLEO = 200;
        partition.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncateToCapture)), EasyMock.anyBoolean());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)replica.logEndOffset()).andReturn((Object)new LogOffsetMetadata((long)initialLEO, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)replica.highWatermark()).andReturn((Object)new LogOffsetMetadata((long)(initialLEO - 3), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)replica.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpochAtFollower))).anyTimes();
        EasyMock.expect((Object)replica.endOffsetForEpoch(leaderEpochAtLeader)).andReturn((Object)None$.MODULE$).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        EasyMock.expect((Object)replicaManager.replicaAlterLogDirsManager()).andReturn((Object)replicaAlterLogDirsManager).anyTimes();
        this.stub(replica, partition, replicaManager);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quota, replica, partition});
        java.util.Map offsetsReply = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new EpochEndOffset(leaderEpochAtLeader, 156L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)new EpochEndOffset(leaderEpochAtLeader, 202L))}))).asJava();
        ReplicaFetcherMockBlockingSend mockNetwork = new ReplicaFetcherMockBlockingSend(offsetsReply, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.brokerEndPoint(), (KafkaConfig)configs.apply(0), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, (Option)new Some((Object)mockNetwork));
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2()))})));
        thread.doWork();
        Assert.assertTrue((String)new StringBuilder().append((Object)"Expected ").append((Object)this.t1p0()).append((Object)" to truncate to offset 156 (truncation offsets: ").append((Object)truncateToCapture.getValues()).append((Object)")").toString(), (boolean)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)156)));
        Assert.assertTrue((String)new StringBuilder().append((Object)"Expected ").append((Object)this.t2p1()).append((Object)" to truncate to offset ").append((Object)BoxesRunTime.boxToInteger((int)initialLEO)).append((Object)" (truncation offsets: ").append((Object)truncateToCapture.getValues()).append((Object)")").toString(), (boolean)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)initialLEO)));
    }

    @Test
    public void shouldFetchLeaderEpochSecondTimeIfLeaderRepliesWithEpochNotKnownToFollower() {
        Capture truncateToCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        ReplicationQuotaManager quota = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)EasyMock.createMock(ReplicaAlterLogDirsManager.class);
        Replica replica = (Replica)EasyMock.createNiceMock(Replica.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        int initialLEO = 200;
        partition.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncateToCapture)), EasyMock.anyBoolean());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)replica.logEndOffset()).andReturn((Object)new LogOffsetMetadata((long)initialLEO, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)replica.highWatermark()).andReturn((Object)new LogOffsetMetadata((long)(initialLEO - 2), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)replica.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5))).anyTimes();
        EasyMock.expect((Object)replica.endOffsetForEpoch(4)).andReturn((Object)new Some((Object)new OffsetAndEpoch(120L, 3))).anyTimes();
        EasyMock.expect((Object)replica.endOffsetForEpoch(3)).andReturn((Object)new Some((Object)new OffsetAndEpoch(120L, 3))).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        EasyMock.expect((Object)replicaManager.replicaAlterLogDirsManager()).andReturn((Object)replicaAlterLogDirsManager).anyTimes();
        this.stub(replica, partition, replicaManager);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quota, replica, partition});
        java.util.Map offsets = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new EpochEndOffset(4, 155L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new EpochEndOffset(4, 143L))}))).asJava();
        ReplicaFetcherMockBlockingSend mockNetwork = new ReplicaFetcherMockBlockingSend(offsets, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, (Option)new Some((Object)mockNetwork));
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2()))})));
        thread.doWork();
        Assert.assertEquals((long)1L, (long)mockNetwork.epochFetchCount());
        Assert.assertEquals((long)0L, (long)mockNetwork.fetchCount());
        java.util.Map nextOffsets = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new EpochEndOffset(3, 101L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new EpochEndOffset(3, 102L))}))).asJava();
        mockNetwork.setOffsetsForNextResponse(nextOffsets);
        thread.doWork();
        Assert.assertEquals((long)2L, (long)mockNetwork.epochFetchCount());
        Assert.assertEquals((long)1L, (long)mockNetwork.fetchCount());
        Assert.assertEquals((String)"OffsetsForLeaderEpochRequest version.", (long)2L, (long)mockNetwork.lastUsedOffsetForLeaderEpochVersion());
        thread.doWork();
        Assert.assertEquals((long)2L, (long)mockNetwork.epochFetchCount());
        Assert.assertEquals((long)2L, (long)mockNetwork.fetchCount());
        Assert.assertTrue((String)new StringBuilder().append((Object)"Expected ").append((Object)this.t1p1()).append((Object)" to truncate to offset 102 (truncation offsets: ").append((Object)truncateToCapture.getValues()).append((Object)")").toString(), (boolean)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)102)));
        Assert.assertTrue((String)new StringBuilder().append((Object)"Expected ").append((Object)this.t1p0()).append((Object)" to truncate to offset 101 (truncation offsets: ").append((Object)truncateToCapture.getValues()).append((Object)")").toString(), (boolean)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)101)));
    }

    @Test
    public void shouldUseLeaderEndOffsetIfInterBrokerVersionBelow20() {
        Capture truncateToCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "0.11.0");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        ReplicationQuotaManager quota = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)EasyMock.createMock(ReplicaAlterLogDirsManager.class);
        Replica replica = (Replica)EasyMock.createNiceMock(Replica.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        int initialLEO = 200;
        partition.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncateToCapture)), EasyMock.anyBoolean());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)replica.logEndOffset()).andReturn((Object)new LogOffsetMetadata((long)initialLEO, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)replica.highWatermark()).andReturn((Object)new LogOffsetMetadata((long)(initialLEO - 2), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)replica.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5))).anyTimes();
        EasyMock.expect((Object)replica.endOffsetForEpoch(4)).andReturn((Object)new Some((Object)new OffsetAndEpoch(120L, 3))).anyTimes();
        EasyMock.expect((Object)replica.endOffsetForEpoch(3)).andReturn((Object)new Some((Object)new OffsetAndEpoch(120L, 3))).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        EasyMock.expect((Object)replicaManager.replicaAlterLogDirsManager()).andReturn((Object)replicaAlterLogDirsManager).anyTimes();
        this.stub(replica, partition, replicaManager);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quota, replica, partition});
        java.util.Map offsets = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new EpochEndOffset(-1, 155L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new EpochEndOffset(-1, 143L))}))).asJava();
        ReplicaFetcherMockBlockingSend mockNetwork = new ReplicaFetcherMockBlockingSend(offsets, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, (Option)new Some((Object)mockNetwork));
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2()))})));
        thread.doWork();
        Assert.assertEquals((long)1L, (long)mockNetwork.epochFetchCount());
        Assert.assertEquals((long)1L, (long)mockNetwork.fetchCount());
        Assert.assertEquals((String)"OffsetsForLeaderEpochRequest version.", (long)0L, (long)mockNetwork.lastUsedOffsetForLeaderEpochVersion());
        thread.doWork();
        Assert.assertEquals((long)1L, (long)mockNetwork.epochFetchCount());
        Assert.assertEquals((long)2L, (long)mockNetwork.fetchCount());
        Assert.assertTrue((String)new StringBuilder().append((Object)"Expected ").append((Object)this.t1p0()).append((Object)" to truncate to offset 155 (truncation offsets: ").append((Object)truncateToCapture.getValues()).append((Object)")").toString(), (boolean)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)155)));
        Assert.assertTrue((String)new StringBuilder().append((Object)"Expected ").append((Object)this.t1p1()).append((Object)" to truncate to offset 143 (truncation offsets: ").append((Object)truncateToCapture.getValues()).append((Object)")").toString(), (boolean)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)143)));
    }

    @Test
    public void shouldTruncateToInitialFetchOffsetIfLeaderReturnsUndefinedOffset() {
        Capture truncated = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        Seq configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom());
        ReplicationQuotaManager quota = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)EasyMock.createMock(ReplicaAlterLogDirsManager.class);
        Replica replica = (Replica)EasyMock.createNiceMock(Replica.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        int initialFetchOffset = 100;
        int initialLeo = 300;
        partition.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncated)), EasyMock.anyBoolean());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)replica.logEndOffset()).andReturn((Object)new LogOffsetMetadata((long)initialLeo, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)replica.highWatermark()).andReturn((Object)new LogOffsetMetadata((long)initialFetchOffset, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)replica.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        EasyMock.expect((Object)replicaManager.replicaAlterLogDirsManager()).andReturn((Object)replicaAlterLogDirsManager).anyTimes();
        this.stub(replica, partition, replicaManager);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quota, replica, partition});
        java.util.Map offsetsReply = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new EpochEndOffset(-1, -1L))}))).asJava();
        ReplicaFetcherMockBlockingSend mockNetwork = new ReplicaFetcherMockBlockingSend(offsetsReply, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.brokerEndPoint(), (KafkaConfig)configs.apply(0), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, (Option)new Some((Object)mockNetwork));
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.offsetAndEpoch(initialFetchOffset, this.offsetAndEpoch$default$2()))})));
        thread.doWork();
        Assert.assertEquals((long)initialFetchOffset, (long)BoxesRunTime.unboxToLong((Object)truncated.getValue()));
    }

    @Test
    public void shouldPollIndefinitelyIfLeaderReturnsAnyException() {
        Capture truncated = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        Seq configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom());
        ReplicationQuotaManager quota = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)EasyMock.createMock(ReplicaAlterLogDirsManager.class);
        Replica replica = (Replica)EasyMock.createNiceMock(Replica.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        int leaderEpoch = 5;
        int highWaterMark = 100;
        int initialLeo = 300;
        EasyMock.expect((Object)replica.highWatermark()).andReturn((Object)new LogOffsetMetadata((long)highWaterMark, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        partition.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncated)), EasyMock.anyBoolean());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)replica.logEndOffset()).andReturn((Object)new LogOffsetMetadata((long)initialLeo, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)replica.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).anyTimes();
        EasyMock.expect((Object)replica.endOffsetForEpoch(leaderEpoch)).andReturn((Object)new Some((Object)new OffsetAndEpoch((long)initialLeo, leaderEpoch))).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        EasyMock.expect((Object)replicaManager.replicaAlterLogDirsManager()).andReturn((Object)replicaAlterLogDirsManager).anyTimes();
        this.stub(replica, partition, replicaManager);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quota, replica, partition});
        java.util.Map offsetsReply = (java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new EpochEndOffset(Errors.NOT_LEADER_FOR_PARTITION, -1, -1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new EpochEndOffset(Errors.UNKNOWN_SERVER_ERROR, -1, -1L))}))).asJava();
        ReplicaFetcherMockBlockingSend mockNetwork = new ReplicaFetcherMockBlockingSend(offsetsReply, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.brokerEndPoint(), (KafkaConfig)configs.apply(0), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, (Option)new Some((Object)mockNetwork));
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2()))})));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)new Serializable(this, thread){
            public static final long serialVersionUID = 0L;
            private final ReplicaFetcherThread thread$1;

            public final void apply(int x$1) {
                this.apply$mcVI$sp(x$1);
            }

            public void apply$mcVI$sp(int x$1) {
                this.thread$1.doWork();
            }
            {
                this.thread$1 = thread$1;
            }
        });
        Assert.assertEquals((long)0L, (long)truncated.getValues().size());
        offsetsReply.put(this.t1p0(), new EpochEndOffset(leaderEpoch, 156L));
        thread.doWork();
        Assert.assertEquals((long)156L, (long)BoxesRunTime.unboxToLong((Object)truncated.getValue()));
    }

    @Test
    public void shouldMovePartitionsOutOfTruncatingLogState() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        ReplicationQuotaManager quota = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createNiceMock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)EasyMock.createMock(ReplicaAlterLogDirsManager.class);
        Replica replica = (Replica)EasyMock.createNiceMock(Replica.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class);
        int leaderEpoch = 4;
        EasyMock.expect((Object)replica.logEndOffset()).andReturn((Object)new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)replica.highWatermark()).andReturn((Object)new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)replica.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).anyTimes();
        EasyMock.expect((Object)replica.endOffsetForEpoch(leaderEpoch)).andReturn((Object)new Some((Object)new OffsetAndEpoch(0L, leaderEpoch))).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        EasyMock.expect((Object)replicaManager.replicaAlterLogDirsManager()).andReturn((Object)replicaAlterLogDirsManager).anyTimes();
        this.stub(replica, partition, replicaManager);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quota, replica});
        java.util.Map offsetsReply = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new EpochEndOffset(leaderEpoch, 1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new EpochEndOffset(leaderEpoch, 1L))}))).asJava();
        ReplicaFetcherMockBlockingSend mockNetwork = new ReplicaFetcherMockBlockingSend(offsetsReply, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, (Option)new Some((Object)mockNetwork));
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2()))})));
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)Truncating$.MODULE$), (Object)thread.fetchState(this.t1p0()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ReplicaState apply(PartitionFetchState x$2) {
                return x$2.state();
            }
        }));
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)Truncating$.MODULE$), (Object)thread.fetchState(this.t1p1()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ReplicaState apply(PartitionFetchState x$3) {
                return x$3.state();
            }
        }));
        thread.doWork();
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)thread.fetchState(this.t1p0()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ReplicaState apply(PartitionFetchState x$4) {
                return x$4.state();
            }
        }));
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)thread.fetchState(this.t1p1()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ReplicaState apply(PartitionFetchState x$5) {
                return x$5.state();
            }
        }));
    }

    @Test
    public void shouldFilterPartitionsMadeLeaderDuringLeaderEpochRequest() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        Capture truncateToCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        int initialLEO = 100;
        ReplicationQuotaManager quota = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createNiceMock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)EasyMock.createMock(ReplicaAlterLogDirsManager.class);
        Replica replica = (Replica)EasyMock.createNiceMock(Replica.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class);
        partition.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncateToCapture)), EasyMock.anyBoolean());
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.expect((Object)replica.logEndOffset()).andReturn((Object)new LogOffsetMetadata((long)initialLEO, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)replica.highWatermark()).andReturn((Object)new LogOffsetMetadata((long)(initialLEO - 2), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)replica.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5))).anyTimes();
        EasyMock.expect((Object)replica.endOffsetForEpoch(5)).andReturn((Object)new Some((Object)new OffsetAndEpoch((long)initialLEO, 5))).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        EasyMock.expect((Object)replicaManager.replicaAlterLogDirsManager()).andReturn((Object)replicaAlterLogDirsManager).anyTimes();
        this.stub(replica, partition, replicaManager);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quota, replica, partition});
        java.util.Map offsetsReply = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new EpochEndOffset(5, 52L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new EpochEndOffset(5, 49L))}))).asJava();
        ReplicaFetcherMockBlockingSend mockNetwork = new ReplicaFetcherMockBlockingSend(offsetsReply, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, (Option)new Some((Object)mockNetwork));
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2()))})));
        TopicPartition partitionThatBecameLeader = this.t1p0();
        mockNetwork.setEpochRequestCallback((Function0<BoxedUnit>)new Serializable(this, thread, partitionThatBecameLeader){
            public static final long serialVersionUID = 0L;
            private final ReplicaFetcherThread thread$2;
            private final TopicPartition partitionThatBecameLeader$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.thread$2.removePartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partitionThatBecameLeader$1})));
            }
            {
                this.thread$2 = thread$2;
                this.partitionThatBecameLeader$1 = partitionThatBecameLeader$1;
            }
        });
        thread.doWork();
        Assert.assertEquals((long)49L, (long)BoxesRunTime.unboxToLong((Object)truncateToCapture.getValue()));
    }

    @Test
    public void shouldCatchExceptionFromBlockingSendWhenShuttingDownReplicaFetcherThread() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        BlockingSend mockBlockingSend = (BlockingSend)EasyMock.createMock(BlockingSend.class);
        mockBlockingSend.initiateClose();
        EasyMock.expect((Object)BoxedUnit.UNIT).andThrow((Throwable)new IllegalArgumentException()).once();
        mockBlockingSend.close();
        EasyMock.expect((Object)BoxedUnit.UNIT).andThrow((Throwable)new IllegalStateException()).once();
        EasyMock.replay((Object[])new Object[]{mockBlockingSend});
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, null, new Metrics(), (Time)new SystemTime(), null, (Option)new Some((Object)mockBlockingSend));
        thread.start();
        thread.initiateShutdown();
        thread.awaitShutdown();
        EasyMock.verify((Object[])new Object[]{mockBlockingSend});
    }

    public IExpectationSetters<Option<Partition>> stub(Replica replica, Partition partition, ReplicaManager replicaManager) {
        EasyMock.expect((Object)replicaManager.localReplica(this.t1p0())).andReturn((Object)new Some((Object)replica)).anyTimes();
        EasyMock.expect((Object)replicaManager.localReplicaOrException(this.t1p0())).andReturn((Object)replica).anyTimes();
        EasyMock.expect((Object)replicaManager.getPartition(this.t1p0())).andReturn((Object)new Some((Object)partition)).anyTimes();
        EasyMock.expect((Object)replicaManager.localReplica(this.t1p1())).andReturn((Object)new Some((Object)replica)).anyTimes();
        EasyMock.expect((Object)replicaManager.localReplicaOrException(this.t1p1())).andReturn((Object)replica).anyTimes();
        EasyMock.expect((Object)replicaManager.getPartition(this.t1p1())).andReturn((Object)new Some((Object)partition)).anyTimes();
        EasyMock.expect((Object)replicaManager.localReplica(this.t2p1())).andReturn((Object)new Some((Object)replica)).anyTimes();
        EasyMock.expect((Object)replicaManager.localReplicaOrException(this.t2p1())).andReturn((Object)replica).anyTimes();
        return EasyMock.expect((Object)replicaManager.getPartition(this.t2p1())).andReturn((Object)new Some((Object)partition)).anyTimes();
    }
}

