/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.LogReadResult$;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055g\u0001B\u0001\u0003\u0001\u001d\u0011\u0011#S:s\u000bb\u0004\u0018N]1uS>tG+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\b)\u0001\u0001\r\u0011\"\u0001\u0016\u0003E!x\u000e]5d!\u0006\u0014H/\u001b;j_:L5O]\u000b\u0002-A!q\u0003\b\u0010,\u001b\u0005A\"BA\r\u001b\u0003\u001diW\u000f^1cY\u0016T!a\u0007\u0006\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002\u001e1\t\u0019Q*\u00199\u0011\t%y\u0012\u0005K\u0005\u0003A)\u0011a\u0001V;qY\u0016\u0014\u0004C\u0001\u0012&\u001d\tI1%\u0003\u0002%\u0015\u00051\u0001K]3eK\u001aL!AJ\u0014\u0003\rM#(/\u001b8h\u0015\t!#\u0002\u0005\u0002\nS%\u0011!F\u0003\u0002\u0004\u0013:$\bc\u0001\u00175Q9\u0011QF\r\b\u0003]Ej\u0011a\f\u0006\u0003a\u0019\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005MR\u0011a\u00029bG.\fw-Z\u0005\u0003kY\u00121aU3r\u0015\t\u0019$\u0002C\u00049\u0001\u0001\u0007I\u0011A\u001d\u0002+Q|\u0007/[2QCJ$\u0018\u000e^5p]&\u001b(o\u0018\u0013fcR\u0011!(\u0010\t\u0003\u0013mJ!\u0001\u0010\u0006\u0003\tUs\u0017\u000e\u001e\u0005\b}]\n\t\u00111\u0001\u0017\u0003\rAH%\r\u0005\u0007\u0001\u0002\u0001\u000b\u0015\u0002\f\u0002%Q|\u0007/[2QCJ$\u0018\u000e^5p]&\u001b(\u000f\t\u0005\b\u0005\u0002\u0011\r\u0011\"\u0001D\u0003M\u0011X\r\u001d7jG\u0006d\u0015m\u001a+j[\u0016l\u0015\r_'t+\u0005!\u0005CA\u0005F\u0013\t1%B\u0001\u0003M_:<\u0007B\u0002%\u0001A\u0003%A)\u0001\u000bsKBd\u0017nY1MC\u001e$\u0016.\\3NCbl5\u000f\t\u0005\b\u0015\u0002\u0011\r\u0011\"\u0001L\u0003U\u0011X\r\u001d7jG\u00064U\r^2i/\u0006LG/T1y\u001bN,\u0012\u0001\u000b\u0005\u0007\u001b\u0002\u0001\u000b\u0011\u0002\u0015\u0002-I,\u0007\u000f\\5dC\u001a+Go\u00195XC&$X*\u0019=Ng\u0002Bqa\u0014\u0001C\u0002\u0013\u00051*\u0001\nmK\u0006$WM\u001d'pO\u0016sGm\u00144gg\u0016$\bBB)\u0001A\u0003%\u0001&A\nmK\u0006$WM\u001d'pO\u0016sGm\u00144gg\u0016$\b\u0005C\u0004T\u0001\t\u0007I\u0011\u0001+\u0002\u001f=4XM\u001d:jI&tw\r\u0015:paN,\u0012!\u0016\t\u0003-nk\u0011a\u0016\u0006\u00031f\u000bA!\u001e;jY*\t!,\u0001\u0003kCZ\f\u0017B\u0001/X\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\u0007=\u0002\u0001\u000b\u0011B+\u0002!=4XM\u001d:jI&tw\r\u0015:paN\u0004\u0003b\u00021\u0001\u0005\u0004%\t!Y\u0001\bG>tg-[4t+\u0005\u0011\u0007cA2eK6\t!$\u0003\u000265A\u0011!CZ\u0005\u0003O\n\u00111bS1gW\u0006\u001cuN\u001c4jO\"1\u0011\u000e\u0001Q\u0001\n\t\f\u0001bY8oM&<7\u000f\t\u0005\bW\u0002\u0011\r\u0011\"\u0001m\u0003\u0015!x\u000e]5d+\u0005i\u0007C\u00018r\u001b\u0005y'B\u00019Z\u0003\u0011a\u0017M\\4\n\u0005\u0019z\u0007BB:\u0001A\u0003%Q.\u0001\u0004u_BL7\r\t\u0005\bk\u0002\u0011\r\u0011\"\u0001w\u0003\u0011!\u0018.\\3\u0016\u0003]\u0004\"\u0001_>\u000e\u0003eT!A\u001f\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005qL(\u0001C'pG.$\u0016.\\3\t\ry\u0004\u0001\u0015!\u0003x\u0003\u0015!\u0018.\\3!\u0011%\t\t\u0001\u0001b\u0001\n\u0003\t\u0019!A\u0004nKR\u0014\u0018nY:\u0016\u0005\u0005\u0015\u0001\u0003BA\u0004\u00033i!!!\u0003\u000b\t\u0005\u0005\u00111\u0002\u0006\u0005\u0003\u001b\ty!\u0001\u0004d_6lwN\u001c\u0006\u0004\u000b\u0005E!\u0002BA\n\u0003+\ta!\u00199bG\",'BAA\f\u0003\ry'oZ\u0005\u0005\u00037\tIAA\u0004NKR\u0014\u0018nY:\t\u0011\u0005}\u0001\u0001)A\u0005\u0003\u000b\t\u0001\"\\3ue&\u001c7\u000f\t\u0005\n\u0003G\u0001\u0001\u0019!C\u0001\u0003K\taB]3qY&\u001c\u0017-T1oC\u001e,'/\u0006\u0002\u0002(A\u0019!#!\u000b\n\u0007\u0005-\"A\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\t\u0013\u0005=\u0002\u00011A\u0005\u0002\u0005E\u0012A\u0005:fa2L7-Y'b]\u0006<WM]0%KF$2AOA\u001a\u0011%q\u0014QFA\u0001\u0002\u0004\t9\u0003\u0003\u0005\u00028\u0001\u0001\u000b\u0015BA\u0014\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0003bBA\u001e\u0001\u0011\u0005\u0011QH\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002u!\"\u0011\u0011HA!!\u0011\t\u0019%!\u0013\u000e\u0005\u0005\u0015#\u0002BA$\u0003+\tQA[;oSRLA!a\u0013\u0002F\t1!)\u001a4pe\u0016Dq!a\u0014\u0001\t\u0003\ti$\u0001\u0005uK\u0006\u0014Hi\\<oQ\u0011\ti%a\u0015\u0011\t\u0005\r\u0013QK\u0005\u0005\u0003/\n)EA\u0003BMR,'\u000fC\u0004\u0002\\\u0001!\t!!\u0010\u0002EQ,7\u000f^%te\u0016C\b/\u001b:bi&|gNR8s'R,8m\u001b$pY2|w/\u001a:tQ\u0011\tI&a\u0018\u0011\t\u0005\r\u0013\u0011M\u0005\u0005\u0003G\n)E\u0001\u0003UKN$\bbBA4\u0001\u0011\u0005\u0011QH\u0001&i\u0016\u001cH/S:s\u000bb\u0004\u0018N]1uS>t\u0017J\u001a(p\r\u0016$8\r\u001b*fcV,7\u000f^'bI\u0016DC!!\u001a\u0002`!9\u0011Q\u000e\u0001\u0005\u0002\u0005u\u0012!\t;fgRL5O]#ya&\u0014\u0018\r^5p]\u001a{'o\u00157po\u001a{G\u000e\\8xKJ\u001c\b\u0006BA6\u0003?Bq!a\u001d\u0001\t\u0003\ti$A\u0013uKN$\u0018j\u001d:FqBL'/\u0019;j_:4uN]\"bk\u001eDG/\u00169G_2dwn^3sg\"\"\u0011\u0011OA0\u0011\u001d\tI\b\u0001C\u0005\u0003w\n\u0001eZ3u!\u0006\u0014H/\u001b;j_:<\u0016\u000e\u001e5BY2\u0014V\r\u001d7jG\u0006\u001c\u0018J\\%teRa\u0011QPAE\u0003\u0017\u000by)a'\u0002 B!\u0011qPAC\u001b\t\t\tIC\u0002\u0002\u0004\u0012\tqa\u00197vgR,'/\u0003\u0003\u0002\b\u0006\u0005%!\u0003)beRLG/[8o\u0011\u0019Y\u0017q\u000fa\u0001C!9\u0011QRA<\u0001\u0004A\u0013a\u00039beRLG/[8o\u0013\u0012Dq!^A<\u0001\u0004\t\t\n\u0005\u0003\u0002\u0014\u0006]UBAAK\u0015\rQ\u00181B\u0005\u0005\u00033\u000b)J\u0001\u0003US6,\u0007bBAO\u0003o\u0002\r!Z\u0001\u0007G>tg-[4\t\u0011\u0005\u0005\u0016q\u000fa\u0001\u0003G\u000b\u0001\u0002\\8dC2dun\u001a\t\u0005\u0003K\u000bY+\u0004\u0002\u0002(*\u0019\u0011\u0011\u0016\u0003\u0002\u00071|w-\u0003\u0003\u0002.\u0006\u001d&a\u0001'pO\"9\u0011\u0011\u0017\u0001\u0005\n\u0005M\u0016a\u00027pO6{7m[\u000b\u0003\u0003GCq!a.\u0001\t\u0013\tI,A\nhKR4u\u000e\u001c7po\u0016\u0014(+\u001a9mS\u000e\f7\u000f\u0006\u0005\u0002<\u0006\r\u0017qYAf!\u0011aC'!0\u0011\t\u0005}\u0014qX\u0005\u0005\u0003\u0003\f\tIA\u0004SKBd\u0017nY1\t\u0011\u0005\u0015\u0017Q\u0017a\u0001\u0003{\n\u0011\u0002]1si&$\u0018n\u001c8\t\u000f\u0005%\u0017Q\u0017a\u0001Q\u0005AA.Z1eKJLE\rC\u0004v\u0003k\u0003\r!!%")
public class IsrExpirationTest {
    private Map<Tuple2<String, Object>, Seq<Object>> topicPartitionIsr = new HashMap();
    private final long replicaLagTimeMaxMs;
    private final int replicaFetchWaitMaxMs;
    private final int leaderLogEndOffset;
    private final Properties overridingProps = new Properties();
    private final Seq<KafkaConfig> configs;
    private final String topic;
    private final MockTime time;
    private final Metrics metrics;
    private ReplicaManager replicaManager;

    public Map<Tuple2<String, Object>, Seq<Object>> topicPartitionIsr() {
        return this.topicPartitionIsr;
    }

    public void topicPartitionIsr_$eq(Map<Tuple2<String, Object>, Seq<Object>> x$1) {
        this.topicPartitionIsr = x$1;
    }

    public long replicaLagTimeMaxMs() {
        return this.replicaLagTimeMaxMs;
    }

    public int replicaFetchWaitMaxMs() {
        return this.replicaFetchWaitMaxMs;
    }

    public int leaderLogEndOffset() {
        return this.leaderLogEndOffset;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public String topic() {
        return this.topic;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    @Before
    public void setUp() {
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)logManager.liveLogDirs()).andReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)))).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        this.replicaManager_$eq(new ReplicaManager((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), null, null, logManager, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(((KafkaConfig)this.configs().head()).brokerId()), new LogDirFailureChannel(((KafkaConfig)this.configs().head()).logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12()));
    }

    @After
    public void tearDown() {
        this.replicaManager().shutdown(false);
        this.metrics().close();
    }

    @Test
    public void testIsrExpirationForStuckFollowers() {
        Log log2 = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log2);
        Assert.assertEquals((String)"All replicas should be in ISR", (Object)((TraversableOnce)this.configs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaConfig x$2) {
                return x$2.brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet(), (Object)partition0.inSyncReplicas().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$3) {
                return x$3.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        Replica leaderReplica = (Replica)partition0.getReplica(((KafkaConfig)this.configs().head()).brokerId()).get();
        partition0.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsrExpirationTest $outer;

            public final void apply(Replica replica) {
                replica.updateLogReadResult(new LogReadResult(new FetchDataInfo(new LogOffsetMetadata((long)(this.$outer.leaderLogEndOffset() - 1), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), (long)(this.$outer.leaderLogEndOffset() - 1), 0L, (long)this.$outer.leaderLogEndOffset(), 0L, this.$outer.time().milliseconds(), -1, (Option)None$.MODULE$, LogReadResult$.MODULE$.$lessinit$greater$default$9()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$4) {
                return x$4.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        this.time().sleep(150L);
        partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"Replica 1 should be out of sync", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition0OSR.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$5) {
                return x$5.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        EasyMock.verify((Object[])new Object[]{log2});
    }

    @Test
    public void testIsrExpirationIfNoFetchRequestMade() {
        Log log2 = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log2);
        Assert.assertEquals((String)"All replicas should be in ISR", (Object)((TraversableOnce)this.configs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaConfig x$6) {
                return x$6.brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet(), (Object)partition0.inSyncReplicas().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$7) {
                return x$7.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        Replica leaderReplica = (Replica)partition0.getReplica(((KafkaConfig)this.configs().head()).brokerId()).get();
        this.time().sleep(150L);
        Set partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"Replica 1 should be out of sync", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition0OSR.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$8) {
                return x$8.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        EasyMock.verify((Object[])new Object[]{log2});
    }

    @Test
    public void testIsrExpirationForSlowFollowers() {
        Log log2 = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log2);
        Assert.assertEquals((String)"All replicas should be in ISR", (Object)((TraversableOnce)this.configs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaConfig x$9) {
                return x$9.brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet(), (Object)partition0.inSyncReplicas().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$10) {
                return x$10.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        Replica leaderReplica = (Replica)partition0.getReplica(((KafkaConfig)this.configs().head()).brokerId()).get();
        partition0.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsrExpirationTest $outer;

            public final void apply(Replica replica) {
                replica.updateLogReadResult(new LogReadResult(new FetchDataInfo(new LogOffsetMetadata((long)(this.$outer.leaderLogEndOffset() - 2), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), (long)(this.$outer.leaderLogEndOffset() - 2), 0L, (long)this.$outer.leaderLogEndOffset(), 0L, this.$outer.time().milliseconds(), -1, (Option)None$.MODULE$, LogReadResult$.MODULE$.$lessinit$greater$default$9()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$11) {
                return x$11.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        this.time().sleep(75L);
        partition0.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsrExpirationTest $outer;

            public final void apply(Replica r) {
                r.updateLogReadResult(new LogReadResult(new FetchDataInfo(new LogOffsetMetadata((long)(this.$outer.leaderLogEndOffset() - 1), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), (long)(this.$outer.leaderLogEndOffset() - 1), 0L, (long)this.$outer.leaderLogEndOffset(), 0L, this.$outer.time().milliseconds(), -1, (Option)None$.MODULE$, LogReadResult$.MODULE$.$lessinit$greater$default$9()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$12) {
                return x$12.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        this.time().sleep(75L);
        partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"Replica 1 should be out of sync", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition0OSR.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$13) {
                return x$13.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        partition0.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsrExpirationTest $outer;

            public final void apply(Replica r) {
                r.updateLogReadResult(new LogReadResult(new FetchDataInfo(new LogOffsetMetadata((long)this.$outer.leaderLogEndOffset(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), (long)this.$outer.leaderLogEndOffset(), 0L, (long)this.$outer.leaderLogEndOffset(), 0L, this.$outer.time().milliseconds(), -1, (Option)None$.MODULE$, LogReadResult$.MODULE$.$lessinit$greater$default$9()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$14) {
                return x$14.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        EasyMock.verify((Object[])new Object[]{log2});
    }

    @Test
    public void testIsrExpirationForCaughtUpFollowers() {
        Log log2 = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log2);
        Assert.assertEquals((String)"All replicas should be in ISR", (Object)((TraversableOnce)this.configs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaConfig x$15) {
                return x$15.brokerId();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet(), (Object)partition0.inSyncReplicas().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$16) {
                return x$16.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        Replica leaderReplica = (Replica)partition0.getReplica(((KafkaConfig)this.configs().head()).brokerId()).get();
        partition0.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsrExpirationTest $outer;

            public final void apply(Replica replica) {
                replica.updateLogReadResult(new LogReadResult(new FetchDataInfo(new LogOffsetMetadata((long)this.$outer.leaderLogEndOffset(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), (long)this.$outer.leaderLogEndOffset(), 0L, (long)this.$outer.leaderLogEndOffset(), 0L, this.$outer.time().milliseconds(), -1, (Option)None$.MODULE$, LogReadResult$.MODULE$.$lessinit$greater$default$9()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$17) {
                return x$17.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        this.time().sleep(150L);
        partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$18) {
                return x$18.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        EasyMock.verify((Object[])new Object[]{log2});
    }

    private Partition getPartitionWithAllReplicasInIsr(String topic, int partitionId, Time time, KafkaConfig config, Log localLog) {
        int leaderId = config.brokerId();
        TopicPartition tp = new TopicPartition(topic, partitionId);
        Partition partition = this.replicaManager().getOrCreatePartition(tp);
        Replica leaderReplica = new Replica(leaderId, tp, time, 0L, (Option)new Some((Object)localLog));
        Seq allReplicas = (Seq)this.getFollowerReplicas(partition, leaderId, time).$colon$plus((Object)leaderReplica, Seq$.MODULE$.canBuildFrom());
        allReplicas.foreach((Function1)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final Partition partition$1;

            public final Replica apply(Replica r) {
                return this.partition$1.addReplicaIfNotExists(r);
            }
            {
                this.partition$1 = partition$1;
            }
        });
        partition.inSyncReplicas_$eq(allReplicas.toSet());
        partition.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1)new Serializable(this, time){
            public static final long serialVersionUID = 0L;
            private final Time time$1;

            public final void apply(Replica replica) {
                replica.updateLogReadResult(new LogReadResult(new FetchDataInfo(new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), 0L, 0L, 0L, 0L, this.time$1.milliseconds(), -1, (Option)None$.MODULE$, LogReadResult$.MODULE$.$lessinit$greater$default$9()));
            }
            {
                this.time$1 = time$1;
            }
        });
        partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)leaderId)));
        return partition;
    }

    /*
     * WARNING - void declaration
     */
    private Log logMock() {
        void var1_1;
        Log log2 = (Log)EasyMock.createMock(Log.class);
        EasyMock.expect((Object)log2.dir()).andReturn((Object)TestUtils$.MODULE$.tempDir()).anyTimes();
        log2.onHighWatermarkIncremented(0L);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)log2.logEndOffsetMetadata()).andReturn((Object)new LogOffsetMetadata((long)this.leaderLogEndOffset(), LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())).anyTimes();
        EasyMock.replay((Object[])new Object[]{log2});
        return var1_1;
    }

    private Seq<Replica> getFollowerReplicas(Partition partition, int leaderId, Time time) {
        return (Seq)((TraversableLike)this.configs().filter((Function1)new Serializable(this, leaderId){
            public static final long serialVersionUID = 0L;
            private final int leaderId$1;

            public final boolean apply(KafkaConfig x$19) {
                return x$19.brokerId() != this.leaderId$1;
            }
            {
                this.leaderId$1 = leaderId$1;
            }
        })).map((Function1)new Serializable(this, partition, time){
            public static final long serialVersionUID = 0L;
            private final Partition partition$2;
            private final Time time$2;

            public final Replica apply(KafkaConfig config) {
                return new Replica(config.brokerId(), this.partition$2.topicPartition(), this.time$2, Replica$.MODULE$.$lessinit$greater$default$4(), Replica$.MODULE$.$lessinit$greater$default$5());
            }
            {
                this.partition$2 = partition$2;
                this.time$2 = time$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public IsrExpirationTest() {
        this.replicaLagTimeMaxMs = 100L;
        this.replicaFetchWaitMaxMs = 100;
        this.leaderLogEndOffset = 20;
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)this.replicaLagTimeMaxMs())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchWaitMaxMs())).toString());
        this.configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsrExpirationTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.overridingProps());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.topic = "foo";
        this.time = new MockTime();
        this.metrics = new Metrics();
        this.replicaManager = null;
    }
}

