/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.KafkaScheduler;
import kafka.utils.KafkaScheduler$;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001\u000f\ta\u0002*[4io\u0006$XM]7be.\u0004VM]:jgR,gnY3UKN$(BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\rC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001b\u0001\n\u0003)\u0012aB2p]\u001aLwm]\u000b\u0002-A\u0019qC\u0007\u000f\u000e\u0003aQ!!\u0007\u0006\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002\u001c1\t\u00191+Z9\u0011\u0005Ii\u0012B\u0001\u0010\u0003\u0005-Y\u0015MZ6b\u0007>tg-[4\t\r\u0001\u0002\u0001\u0015!\u0003\u0017\u0003!\u0019wN\u001c4jON\u0004\u0003b\u0002\u0012\u0001\u0005\u0004%\taI\u0001\u0006i>\u0004\u0018nY\u000b\u0002IA\u0011QEK\u0007\u0002M)\u0011q\u0005K\u0001\u0005Y\u0006twMC\u0001*\u0003\u0011Q\u0017M^1\n\u0005-2#AB*ue&tw\r\u0003\u0004.\u0001\u0001\u0006I\u0001J\u0001\u0007i>\u0004\u0018n\u0019\u0011\t\u000f=\u0002!\u0019!C\u0001a\u0005A!p[\"mS\u0016tG/F\u00012!\t\u0011T'D\u00014\u0015\t!D!\u0001\u0002{W&\u0011ag\r\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\t\ra\u0002\u0001\u0015!\u00032\u0003%Q8n\u00117jK:$\b\u0005C\u0004;\u0001\t\u0007I\u0011A\u001e\u0002\u00171|w-T1oC\u001e,'o]\u000b\u0002yA\u0019qCG\u001f\u0011\u0005y\nU\"A \u000b\u0005\u0001#\u0011a\u00017pO&\u0011!i\u0010\u0002\u000b\u0019><W*\u00198bO\u0016\u0014\bB\u0002#\u0001A\u0003%A(\u0001\u0007m_\u001el\u0015M\\1hKJ\u001c\b\u0005C\u0004G\u0001\t\u0007I\u0011A$\u0002+1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3mgV\t\u0001\nE\u0002\u00185%\u0003\"A\u0005&\n\u0005-\u0013!\u0001\u0006'pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G\u000e\u0003\u0004N\u0001\u0001\u0006I\u0001S\u0001\u0017Y><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7tA!)q\n\u0001C\u0001!\u0006AA/Z1sI><h\u000eF\u0001R!\tI!+\u0003\u0002T\u0015\t!QK\\5uQ\tqU\u000b\u0005\u0002W76\tqK\u0003\u0002Y3\u0006)!.\u001e8ji*\t!,A\u0002pe\u001eL!\u0001X,\u0003\u000b\u00053G/\u001a:\t\u000by\u0003A\u0011\u0001)\u0002WQ,7\u000f\u001e%jO\"<\u0016\r^3s[\u0006\u00148\u000eU3sg&\u001cH/\u001a8dKNKgn\u001a7f!\u0006\u0014H/\u001b;j_:D#!\u00181\u0011\u0005Y\u000b\u0017B\u00012X\u0005\u0011!Vm\u001d;\t\u000b\u0011\u0004A\u0011\u0001)\u0002]Q,7\u000f\u001e%jO\"<\u0016\r^3s[\u0006\u00148\u000eU3sg&\u001cH/\u001a8dK6+H\u000e^5qY\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0003G\u0002DQa\u001a\u0001\u0005\u0002!\fa\u0001[<n\r>\u0014H\u0003B5mcb\u0004\"!\u00036\n\u0005-T!\u0001\u0002'p]\u001eDQ!\u001c4A\u00029\faB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0005\u0002\u0013_&\u0011\u0001O\u0001\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0011\u0015\u0011c\r1\u0001s!\t\u0019hO\u0004\u0002\ni&\u0011QOC\u0001\u0007!J,G-\u001a4\n\u0005-:(BA;\u000b\u0011\u0015Ih\r1\u0001{\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0005\u0002\nw&\u0011AP\u0003\u0002\u0004\u0013:$\b")
public class HighwatermarkPersistenceTest {
    private final Seq<KafkaConfig> configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final KafkaConfig apply(Properties props) {
            return KafkaConfig$.MODULE$.fromProps(props);
        }
    }, Seq$.MODULE$.canBuildFrom());
    private final String topic;
    private final KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createMock(KafkaZkClient.class);
    private final Seq<LogManager> logManagers = (Seq)this.configs().map((Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final LogManager apply(KafkaConfig config) {
            Seq x$2 = (Seq)config.logDirs().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final File apply(String x$1) {
                    return new File(x$1);
                }
            }, Seq$.MODULE$.canBuildFrom());
            CleanerConfig x$3 = new CleanerConfig(CleanerConfig$.MODULE$.apply$default$1(), CleanerConfig$.MODULE$.apply$default$2(), CleanerConfig$.MODULE$.apply$default$3(), CleanerConfig$.MODULE$.apply$default$4(), CleanerConfig$.MODULE$.apply$default$5(), CleanerConfig$.MODULE$.apply$default$6(), CleanerConfig$.MODULE$.apply$default$7(), CleanerConfig$.MODULE$.apply$default$8(), CleanerConfig$.MODULE$.apply$default$9());
            LogConfig x$4 = TestUtils$.MODULE$.createLogManager$default$2();
            MockTime x$5 = TestUtils$.MODULE$.createLogManager$default$4();
            return TestUtils$.MODULE$.createLogManager((Seq<File>)x$2, x$4, x$3, x$5);
        }
    }, Seq$.MODULE$.canBuildFrom());
    private final Seq<LogDirFailureChannel> logDirFailureChannels = (Seq)this.configs().map((Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final LogDirFailureChannel apply(KafkaConfig config) {
            return new LogDirFailureChannel(config.logDirs().size());
        }
    }, Seq$.MODULE$.canBuildFrom());

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public String topic() {
        return this.topic;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public Seq<LogManager> logManagers() {
        return this.logManagers;
    }

    public Seq<LogDirFailureChannel> logDirFailureChannels() {
        return this.logDirFailureChannels;
    }

    @After
    public void teardown() {
        this.logManagers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(LogManager manager) {
                manager.liveLogDirs().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(File dir) {
                        Utils.delete((File)dir);
                    }
                });
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHighWatermarkPersistenceSinglePartition() {
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        KafkaScheduler scheduler = new KafkaScheduler(2, KafkaScheduler$.MODULE$.$lessinit$greater$default$2(), KafkaScheduler$.MODULE$.$lessinit$greater$default$3());
        scheduler.startup();
        Metrics metrics = new Metrics();
        MockTime time = new MockTime();
        ReplicaManager replicaManager = new ReplicaManager((KafkaConfig)this.configs().head(), metrics, (Time)time, this.zkClient(), (Scheduler)scheduler, (LogManager)this.logManagers().head(), new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), metrics, (Time)time, ""), new BrokerTopicStats(), new MetadataCache(((KafkaConfig)this.configs().head()).brokerId()), (LogDirFailureChannel)this.logDirFailureChannels().head(), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        replicaManager.startup();
        try {
            replicaManager.checkpointHighWatermarks();
            long fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assert.assertEquals((long)0L, (long)fooPartition0Hw);
            TopicPartition tp0 = new TopicPartition(this.topic(), 0);
            Partition partition0 = replicaManager.getOrCreatePartition(tp0);
            LogManager qual$1 = (LogManager)this.logManagers().head();
            TopicPartition x$6 = new TopicPartition(this.topic(), 0);
            LogConfig x$7 = LogConfig$.MODULE$.apply();
            boolean x$8 = qual$1.getOrCreateLog$default$3();
            boolean x$9 = qual$1.getOrCreateLog$default$4();
            Log log0 = qual$1.getOrCreateLog(x$6, x$7, x$8, x$9);
            Replica leaderReplicaPartition0 = new Replica(((KafkaConfig)this.configs().head()).brokerId(), tp0, (Time)time, 0L, (Option)new Some((Object)log0));
            partition0.addReplicaIfNotExists(leaderReplicaPartition0);
            Replica followerReplicaPartition0 = new Replica(((KafkaConfig)this.configs().last()).brokerId(), tp0, (Time)time, Replica$.MODULE$.$lessinit$greater$default$4(), Replica$.MODULE$.$lessinit$greater$default$5());
            partition0.addReplicaIfNotExists(followerReplicaPartition0);
            replicaManager.checkpointHighWatermarks();
            fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assert.assertEquals((long)leaderReplicaPartition0.highWatermark().messageOffset(), (long)fooPartition0Hw);
            ((Replica)partition0.localReplica().get()).highWatermark_$eq(new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
            replicaManager.checkpointHighWatermarks();
            fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assert.assertEquals((long)leaderReplicaPartition0.highWatermark().messageOffset(), (long)fooPartition0Hw);
            EasyMock.verify((Object[])new Object[]{this.zkClient()});
        }
        catch (Throwable throwable) {
            void var1_1;
            void var2_2;
            void var4_4;
            var4_4.shutdown(false);
            var2_2.close();
            var1_1.shutdown();
            throw throwable;
        }
        replicaManager.shutdown(false);
        metrics.close();
        scheduler.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHighWatermarkPersistenceMultiplePartitions() {
        String topic1 = "foo1";
        String topic2 = "foo2";
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        KafkaScheduler scheduler = new KafkaScheduler(2, KafkaScheduler$.MODULE$.$lessinit$greater$default$2(), KafkaScheduler$.MODULE$.$lessinit$greater$default$3());
        scheduler.startup();
        Metrics metrics = new Metrics();
        MockTime time = new MockTime();
        ReplicaManager replicaManager = new ReplicaManager((KafkaConfig)this.configs().head(), metrics, (Time)time, this.zkClient(), (Scheduler)scheduler, (LogManager)this.logManagers().head(), new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), metrics, (Time)time, ""), new BrokerTopicStats(), new MetadataCache(((KafkaConfig)this.configs().head()).brokerId()), (LogDirFailureChannel)this.logDirFailureChannels().head(), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        replicaManager.startup();
        try {
            replicaManager.checkpointHighWatermarks();
            long topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assert.assertEquals((long)0L, (long)topic1Partition0Hw);
            TopicPartition t1p0 = new TopicPartition(topic1, 0);
            Partition topic1Partition0 = replicaManager.getOrCreatePartition(t1p0);
            LogManager qual$2 = (LogManager)this.logManagers().head();
            TopicPartition x$10 = t1p0;
            LogConfig x$11 = LogConfig$.MODULE$.apply();
            boolean x$12 = qual$2.getOrCreateLog$default$3();
            boolean x$13 = qual$2.getOrCreateLog$default$4();
            Log topic1Log0 = qual$2.getOrCreateLog(x$10, x$11, x$12, x$13);
            Replica leaderReplicaTopic1Partition0 = new Replica(((KafkaConfig)this.configs().head()).brokerId(), t1p0, (Time)time, 0L, (Option)new Some((Object)topic1Log0));
            topic1Partition0.addReplicaIfNotExists(leaderReplicaTopic1Partition0);
            replicaManager.checkpointHighWatermarks();
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assert.assertEquals((long)leaderReplicaTopic1Partition0.highWatermark().messageOffset(), (long)topic1Partition0Hw);
            ((Replica)topic1Partition0.localReplica().get()).highWatermark_$eq(new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
            replicaManager.checkpointHighWatermarks();
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assert.assertEquals((long)5L, (long)leaderReplicaTopic1Partition0.highWatermark().messageOffset());
            Assert.assertEquals((long)5L, (long)topic1Partition0Hw);
            TopicPartition t2p0 = new TopicPartition(topic2, 0);
            Partition topic2Partition0 = replicaManager.getOrCreatePartition(t2p0);
            LogManager qual$3 = (LogManager)this.logManagers().head();
            TopicPartition x$14 = t2p0;
            LogConfig x$15 = LogConfig$.MODULE$.apply();
            boolean x$16 = qual$3.getOrCreateLog$default$3();
            boolean x$17 = qual$3.getOrCreateLog$default$4();
            Log topic2Log0 = qual$3.getOrCreateLog(x$14, x$15, x$16, x$17);
            Replica leaderReplicaTopic2Partition0 = new Replica(((KafkaConfig)this.configs().head()).brokerId(), t2p0, (Time)time, 0L, (Option)new Some((Object)topic2Log0));
            topic2Partition0.addReplicaIfNotExists(leaderReplicaTopic2Partition0);
            replicaManager.checkpointHighWatermarks();
            long topic2Partition0Hw = this.hwmFor(replicaManager, topic2, 0);
            Assert.assertEquals((long)leaderReplicaTopic2Partition0.highWatermark().messageOffset(), (long)topic2Partition0Hw);
            ((Replica)topic2Partition0.localReplica().get()).highWatermark_$eq(new LogOffsetMetadata(15L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
            Assert.assertEquals((long)15L, (long)leaderReplicaTopic2Partition0.highWatermark().messageOffset());
            ((Replica)topic1Partition0.localReplica().get()).highWatermark_$eq(new LogOffsetMetadata(10L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
            Assert.assertEquals((long)10L, (long)leaderReplicaTopic1Partition0.highWatermark().messageOffset());
            replicaManager.checkpointHighWatermarks();
            topic2Partition0Hw = this.hwmFor(replicaManager, topic2, 0);
            Assert.assertEquals((long)15L, (long)topic2Partition0Hw);
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assert.assertEquals((long)10L, (long)topic1Partition0Hw);
            EasyMock.verify((Object[])new Object[]{this.zkClient()});
        }
        catch (Throwable throwable) {
            void var3_3;
            void var4_4;
            void var6_6;
            var6_6.shutdown(false);
            var4_4.close();
            var3_3.shutdown();
            throw throwable;
        }
        replicaManager.shutdown(false);
        metrics.close();
        scheduler.shutdown();
    }

    public long hwmFor(ReplicaManager replicaManager, String topic, int partition) {
        return BoxesRunTime.unboxToLong((Object)((OffsetCheckpointFile)replicaManager.highWatermarkCheckpoints().apply((Object)new File((String)replicaManager.config().logDirs().head()).getAbsolutePath())).read().getOrElse((Object)new TopicPartition(topic, partition), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
    }

    public HighwatermarkPersistenceTest() {
        this.topic = "foo";
    }
}

