/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricName;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.cluster.BrokerEndPoint;
import kafka.log.LogAppendInfo;
import kafka.message.CompressionCodec;
import kafka.message.NoCompressionCodec$;
import kafka.server.AbstractFetcherThread;
import kafka.server.AbstractFetcherThread$;
import kafka.server.AbstractFetcherThreadTest$MockFetcherThread$;
import kafka.server.FetcherMetrics$;
import kafka.server.Fetching$;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaState;
import kafka.server.Truncating$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.UnknownLeaderEpochException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\r%g\u0001B\u0001\u0003\u0001\u001d\u0011\u0011$\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG\rV3ti*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000bQ\u0001A\u0011A\u000b\u0002'\rdW-\u00198NKR\u0014\u0018n\u0019*fO&\u001cHO]=\u0015\u0003Y\u0001\"!C\f\n\u0005aQ!\u0001B+oSRD#a\u0005\u000e\u0011\u0005m\u0001S\"\u0001\u000f\u000b\u0005uq\u0012!\u00026v]&$(\"A\u0010\u0002\u0007=\u0014x-\u0003\u0002\"9\t1!)\u001a4pe\u0016DQa\t\u0001\u0005\n\u0011\nq\"\u00197m\u001b\u0016$(/[2t\u001d\u0006lWm]\u000b\u0002KA\u0019a%K\u0016\u000e\u0003\u001dR!\u0001\u000b\u0006\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002+O\t\u00191+\u001a;\u0011\u00051zcBA\u0005.\u0013\tq#\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003aE\u0012aa\u0015;sS:<'B\u0001\u0018\u000b\u0011\u0015\u0019\u0004\u0001\"\u00035\u0003\u001di7NQ1uG\"$B!\u000e!F\u0015B\u0011aGP\u0007\u0002o)\u0011\u0001(O\u0001\u0007e\u0016\u001cwN\u001d3\u000b\u0005iZ\u0014AB2p[6|gN\u0003\u0002\u0006y)\u0011QHH\u0001\u0007CB\f7\r[3\n\u0005}:$a\u0003*fG>\u0014HMQ1uG\"DQ!\u0011\u001aA\u0002\t\u000b!BY1tK>3gm]3u!\tI1)\u0003\u0002E\u0015\t!Aj\u001c8h\u0011\u00151%\u00071\u0001H\u0003-aW-\u00193fe\u0016\u0003xn\u00195\u0011\u0005%A\u0015BA%\u000b\u0005\rIe\u000e\u001e\u0005\u0006\u0017J\u0002\r\u0001T\u0001\be\u0016\u001cwN\u001d3t!\rIQjT\u0005\u0003\u001d*\u0011!\u0002\u0010:fa\u0016\fG/\u001a3?!\t1\u0004+\u0003\u0002Ro\ta1+[7qY\u0016\u0014VmY8sI\")1\u000b\u0001C\u0005)\u0006qqN\u001a4tKR\fe\u000eZ#q_\u000eDGcA+Y5B\u0011!CV\u0005\u0003/\n\u0011ab\u00144gg\u0016$\u0018I\u001c3Fa>\u001c\u0007\u000eC\u0003Z%\u0002\u0007!)A\u0006gKR\u001c\u0007n\u00144gg\u0016$\b\"\u0002$S\u0001\u00049\u0005\"\u0002/\u0001\t\u0003)\u0012\u0001\b;fgRlU\r\u001e:jGN\u0014V-\\8wK\u0012|en\u00155vi\u0012|wO\u001c\u0015\u00037z\u0003\"aG0\n\u0005\u0001d\"\u0001\u0002+fgRDQA\u0019\u0001\u0005\u0002U\t1\u0005^3ti\u000e{gn];nKJd\u0015m\u001a*f[>4X\rZ,ji\"\u0004\u0016M\u001d;ji&|g\u000e\u000b\u0002b=\")Q\r\u0001C\u0001+\u0005yA/Z:u'&l\u0007\u000f\\3GKR\u001c\u0007\u000e\u000b\u0002e=\")\u0001\u000e\u0001C\u0001+\u0005!B/Z:u\r\u0016t7-\u001a3UeVt7-\u0019;j_:D#a\u001a0\t\u000b-\u0004A\u0011A\u000b\u0002\u001fQ,7\u000f\u001e$f]\u000e,GMR3uG\"D#A\u001b0\t\u000b9\u0004A\u0011A\u000b\u0002EQ,7\u000f^+oW:|wO\u001c'fC\u0012,'/\u00129pG\"Le\u000e\u0016:v]\u000e\fG/[8oQ\tig\fC\u0003r\u0001\u0011\u0005Q#A\u0012uKN$XK\\6o_^tG*Z1eKJ,\u0005o\\2i/\"LG.\u001a$fi\u000eD\u0017N\\4)\u0005At\u0006\"\u0002;\u0001\t\u0003)\u0012A\u0004;fgR$&/\u001e8dCRLwN\u001c\u0015\u0003gzCQa\u001e\u0001\u0005\u0002U\t1\b^3tiR\u0013XO\\2bi\u0016$v\u000eS5hQ^\u000bG/\u001a:nCJ\\\u0017J\u001a'fC\u0012,'/\u00129pG\"\u0014V-];fgRtu\u000e^*vaB|'\u000f^3eQ\t1h\fC\u0003{\u0001\u0011\u0005Q#\u0001\u001duKN$HK];oG\u0006$X\rV8IS\u001eDw+\u0019;fe6\f'o[%g\u0019\u0016\fG-\u001a:Fa>\u001c\u0007.\u00138g_:{G/\u0011<bS2\f'\r\\3)\u0005et\u0006\"B?\u0001\t\u0003)\u0012\u0001\n;fgR$&/\u001e8dCRLwN\\*lSB\u0004X\rZ%g\u001d>,\u0005o\\2i\u0007\"\fgnZ3)\u0005qt\u0006BBA\u0001\u0001\u0011\u0005Q#A\u0010uKN$hi\u001c7m_^,'OR3uG\"|U\u000f^(g%\u0006tw-\u001a%jO\"D#a 0\t\r\u0005\u001d\u0001\u0001\"\u0001\u0016\u0003\u0011\"Xm\u001d;GK:\u001cW\rZ(gMN,GOU3tKR\fe\r^3s\u001fV$xJ\u001a*b]\u001e,\u0007fAA\u0003=\"1\u0011Q\u0002\u0001\u0005\u0002U\ta\u0004^3ti\u001a{G\u000e\\8xKJ4U\r^2i\u001fV$xJ\u001a*b]\u001e,Gj\\<)\u0007\u0005-a\f\u0003\u0004\u0002\u0014\u0001!\t!F\u00014i\u0016\u001cHOU3uef\fe\r^3s+:\\gn\\<o\u0019\u0016\fG-\u001a:Fa>\u001c\u0007.\u00138MCR,7\u000f^(gMN,GOR3uG\"D3!!\u0005_\u0011\u0019\tI\u0002\u0001C\u0001+\u0005\u0011B/Z:u\u0007>\u0014(/\u001e9u\u001b\u0016\u001c8/Y4fQ\r\t9B\u0018\u0005\u0007\u0003?\u0001A\u0011A\u000b\u0002mQ,7\u000f\u001e'fC\u0012,'/\u00129pG\"\u001c\u0005.\u00198hK\u0012+(/\u001b8h\r\u0016t7-\u001a3GKR\u001c\u0007.\u00129pG\"\u001chI]8n\u0019\u0016\fG-\u001a:)\u0007\u0005ua\f\u0003\u0004\u0002&\u0001!\t!F\u0001;i\u0016\u001cH\u000fT3bI\u0016\u0014X\t]8dQ\u000eC\u0017M\\4f\tV\u0014\u0018N\\4Tk\u000e\u001cWm]:gk24U\r^2i\u000bB|7\r[:Ge>lG*Z1eKJD3!a\t_\u0011\u001d\tY\u0003\u0001C\u0005\u0003[\t\u0001\u0007^3ti2+\u0017\rZ3s\u000bB|7\r[\"iC:<W\rR;sS:<g)\u001a;dQ\u0016\u0003xn\u00195t\rJ|W\u000eT3bI\u0016\u0014Hc\u0001\f\u00020!9\u0011\u0011GA\u0015\u0001\u00049\u0015a\u00057fC\u0012,'/\u00129pG\"|e\u000eT3bI\u0016\u0014\bBBA\u001b\u0001\u0011\u0005Q#A(uKN$HK];oG\u0006$\u0018n\u001c8UQJ|wo]#yG\u0016\u0004H/[8o\u0013\u001adU-\u00193feJ+G/\u001e:ogB\u000b'\u000f^5uS>t7OT8u%\u0016\fX/Z:uK\u0012LeNR3uG\",\u0005o\\2ig\"\u001a\u00111\u00070\b\u000f\u0005m\u0002\u0001#\u0001\u0002>\u0005\tRj\\2l\r\u0016$8\r[3s)\"\u0014X-\u00193\u0011\t\u0005}\u0012\u0011I\u0007\u0002\u0001\u00199\u00111\t\u0001\t\u0002\u0005\u0015#!E'pG.4U\r^2iKJ$\u0006N]3bIN\u0019\u0011\u0011\t\u0005\t\u000f=\t\t\u0005\"\u0001\u0002JQ\u0011\u0011Q\b\u0004\b\u0003\u001b\n\t\u0005AA(\u00059\u0001\u0016M\u001d;ji&|gn\u0015;bi\u0016\u001c2!a\u0013\t\u0011-\t\u0019&a\u0013\u0003\u0002\u0004%\t!!\u0016\u0002\u00071|w-\u0006\u0002\u0002XA)\u0011\u0011LA0k5\u0011\u00111\f\u0006\u0004\u0003;:\u0013aB7vi\u0006\u0014G.Z\u0005\u0005\u0003C\nYF\u0001\u0004Ck\u001a4WM\u001d\u0005\f\u0003K\nYE!a\u0001\n\u0003\t9'A\u0004m_\u001e|F%Z9\u0015\u0007Y\tI\u0007\u0003\u0006\u0002l\u0005\r\u0014\u0011!a\u0001\u0003/\n1\u0001\u001f\u00132\u0011-\ty'a\u0013\u0003\u0002\u0003\u0006K!a\u0016\u0002\t1|w\r\t\u0005\u000b\r\u0006-#\u00111A\u0005\u0002\u0005MT#A$\t\u0017\u0005]\u00141\nBA\u0002\u0013\u0005\u0011\u0011P\u0001\u0010Y\u0016\fG-\u001a:Fa>\u001c\u0007n\u0018\u0013fcR\u0019a#a\u001f\t\u0013\u0005-\u0014QOA\u0001\u0002\u00049\u0005BCA@\u0003\u0017\u0012\t\u0011)Q\u0005\u000f\u0006aA.Z1eKJ,\u0005o\\2iA!Y\u00111QA&\u0005\u0003\u0007I\u0011AAC\u00039awnZ*uCJ$xJ\u001a4tKR,\u0012A\u0011\u0005\f\u0003\u0013\u000bYE!a\u0001\n\u0003\tY)\u0001\nm_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;`I\u0015\fHc\u0001\f\u0002\u000e\"I\u00111NAD\u0003\u0003\u0005\rA\u0011\u0005\u000b\u0003#\u000bYE!A!B\u0013\u0011\u0015a\u00047pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0011\t\u0017\u0005U\u00151\nBA\u0002\u0013\u0005\u0011QQ\u0001\rY><WI\u001c3PM\u001a\u001cX\r\u001e\u0005\f\u00033\u000bYE!a\u0001\n\u0003\tY*\u0001\tm_\u001e,e\u000eZ(gMN,Go\u0018\u0013fcR\u0019a#!(\t\u0013\u0005-\u0014qSA\u0001\u0002\u0004\u0011\u0005BCAQ\u0003\u0017\u0012\t\u0011)Q\u0005\u0005\u0006iAn\\4F]\u0012|eMZ:fi\u0002B1\"!*\u0002L\t\u0005\r\u0011\"\u0001\u0002\u0006\u0006i\u0001.[4i/\u0006$XM]7be.D1\"!+\u0002L\t\u0005\r\u0011\"\u0001\u0002,\u0006\t\u0002.[4i/\u0006$XM]7be.|F%Z9\u0015\u0007Y\ti\u000bC\u0005\u0002l\u0005\u001d\u0016\u0011!a\u0001\u0005\"Q\u0011\u0011WA&\u0005\u0003\u0005\u000b\u0015\u0002\"\u0002\u001d!Lw\r[,bi\u0016\u0014X.\u0019:lA!9q\"a\u0013\u0005\u0002\u0005UF\u0003DA\\\u0003w\u000bi,a0\u0002B\u0006\r\u0007\u0003BA]\u0003\u0017j!!!\u0011\t\u0011\u0005M\u00131\u0017a\u0001\u0003/BaARAZ\u0001\u00049\u0005bBAB\u0003g\u0003\rA\u0011\u0005\b\u0003+\u000b\u0019\f1\u0001C\u0011\u001d\t)+a-A\u0002\t;\u0001\"a2\u0002B!\u0005\u0011\u0011Z\u0001\u000f!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f!\u0011\tI,a3\u0007\u0011\u00055\u0013\u0011\tE\u0001\u0003\u001b\u001c2!a3\t\u0011\u001dy\u00111\u001aC\u0001\u0003#$\"!!3\t\u0011\u0005U\u00171\u001aC\u0001\u0003/\fQ!\u00199qYf$\u0002\"a.\u0002Z\u0006M\u0018Q\u001f\u0005\t\u0003'\n\u0019\u000e1\u0001\u0002\\B)\u0011Q\\Awk9!\u0011q\\Au\u001d\u0011\t\t/a:\u000e\u0005\u0005\r(bAAs\r\u00051AH]8pizJ\u0011aC\u0005\u0004\u0003WT\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003_\f\tPA\u0002TKFT1!a;\u000b\u0011\u00191\u00151\u001ba\u0001\u000f\"9\u0011QUAj\u0001\u0004\u0011\u0005\u0002CAk\u0003\u0017$\t!!?\u0015\t\u0005]\u00161 \u0005\u0007\r\u0006]\b\u0019A$\t\u0015\u0005}\u0018\u0011II\u0001\n\u0003\u0011\t!A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%M\u000b\u0003\u0005\u0007Q3a\u0012B\u0003W\t\u00119\u0001\u0005\u0003\u0003\n\tMQB\u0001B\u0006\u0015\u0011\u0011iAa\u0004\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\t\u0015\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tU!1\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007B\u0003B\r\u0003\u0003\n\n\u0011\"\u0001\u0003\u0002\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII2a!a\u0011\u0001\u0001\tu1\u0003\u0002B\u000e\u0005?\u00012A\u0005B\u0011\u0013\r\u0011\u0019C\u0001\u0002\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e\u0011-\u00119Ca\u0007\u0003\u0006\u0004%\t!a\u001d\u0002\u0013I,\u0007\u000f\\5dC&#\u0007B\u0003B\u0016\u00057\u0011\t\u0011)A\u0005\u000f\u0006Q!/\u001a9mS\u000e\f\u0017\n\u001a\u0011\t\u0017\t=\"1\u0004BC\u0002\u0013\u0005\u00111O\u0001\tY\u0016\fG-\u001a:JI\"Q!1\u0007B\u000e\u0005\u0003\u0005\u000b\u0011B$\u0002\u00131,\u0017\rZ3s\u0013\u0012\u0004\u0003bB\b\u0003\u001c\u0011\u0005!q\u0007\u000b\u0007\u0005s\u0011YD!\u0010\u0011\t\u0005}\"1\u0004\u0005\n\u0005O\u0011)\u0004%AA\u0002\u001dC\u0011Ba\f\u00036A\u0005\t\u0019A$\t\u0015\t\u0005#1\u0004b\u0001\n\u0013\u0011\u0019%\u0001\fsKBd\u0017nY1QCJ$\u0018\u000e^5p]N#\u0018\r^3t+\t\u0011)\u0005\u0005\u0005\u0002Z\t\u001d#1\nB*\u0013\u0011\u0011I%a\u0017\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0003N\t=S\"A\u001d\n\u0007\tE\u0013H\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\t\tU\u00131\n\b\u0005\u0003\u007f\tI\u0004C\u0005\u0003Z\tm\u0001\u0015!\u0003\u0003F\u00059\"/\u001a9mS\u000e\f\u0007+\u0019:uSRLwN\\*uCR,7\u000f\t\u0005\u000b\u0005;\u0012YB1A\u0005\n\t\r\u0013!\u00067fC\u0012,'\u000fU1si&$\u0018n\u001c8Ti\u0006$Xm\u001d\u0005\n\u0005C\u0012Y\u0002)A\u0005\u0005\u000b\na\u0003\\3bI\u0016\u0014\b+\u0019:uSRLwN\\*uCR,7\u000f\t\u0005\t\u0005K\u0012Y\u0002\"\u0001\u0003h\u0005q1/\u001a;MK\u0006$WM]*uCR,G#\u0002\f\u0003j\t5\u0004\u0002\u0003B6\u0005G\u0002\rAa\u0013\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\"A!q\u000eB2\u0001\u0004\u0011\u0019&A\u0003ti\u0006$X\r\u0003\u0005\u0003t\tmA\u0011\u0001B;\u0003=\u0019X\r\u001e*fa2L7-Y*uCR,G#\u0002\f\u0003x\te\u0004\u0002\u0003B6\u0005c\u0002\rAa\u0013\t\u0011\t=$\u0011\u000fa\u0001\u0005'B\u0001B! \u0003\u001c\u0011\u0005!qP\u0001\u0016e\u0016\u0004H.[2b!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f)\u0011\u0011\u0019F!!\t\u0011\t-$1\u0010a\u0001\u0005\u0017B\u0001B!\"\u0003\u001c\u0011\u0005!qQ\u0001\u0015Y\u0016\fG-\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3\u0015\t\tM#\u0011\u0012\u0005\t\u0005W\u0012\u0019\t1\u0001\u0003L!A!Q\u0012B\u000e\t\u0003\u0012y)\u0001\u000bqe>\u001cWm]:QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u000b\t\u0005#\u0013\tKa)\u0003&B)\u0011Ba%\u0003\u0018&\u0019!Q\u0013\u0006\u0003\r=\u0003H/[8o!\u0011\u0011IJ!(\u000e\u0005\tm%bAA*\t%!!q\u0014BN\u00055aunZ!qa\u0016tG-\u00138g_\"A!1\u000eBF\u0001\u0004\u0011Y\u0005\u0003\u0004Z\u0005\u0017\u0003\rA\u0011\u0005\t\u0005O\u0013Y\t1\u0001\u0003*\u0006i\u0001/\u0019:uSRLwN\u001c#bi\u0006\u0004BAa+\u0003.6\u0011!1D\u0005\u0005\u0005_\u0013\tCA\u0005GKR\u001c\u0007\u000eR1uC\"A!1\u0017B\u000e\t\u0003\u0012),\u0001\u0005ueVt7-\u0019;f)\u00151\"q\u0017B]\u0011!\u0011YG!-A\u0002\t-\u0003\u0002\u0003B^\u0005c\u0003\rA!0\u0002\u001fQ\u0014XO\\2bi&|gn\u0015;bi\u0016\u00042A\u0005B`\u0013\r\u0011\tM\u0001\u0002\u0016\u001f\u001a47/\u001a;UeVt7-\u0019;j_:\u001cF/\u0019;f\u0011!\u0011)Ma\u0007\u0005B\t\u001d\u0017a\u0006;sk:\u001c\u0017\r^3Gk2d\u00170\u00118e'R\f'\u000f^!u)\u00151\"\u0011\u001aBf\u0011!\u0011YGa1A\u0002\t-\u0003b\u0002Bg\u0005\u0007\u0004\rAQ\u0001\u0007_\u001a47/\u001a;\t\u0011\tE'1\u0004C!\u0005'\f!BY;jY\u00124U\r^2i)\u0011\u0011)n!\u0001\u0011\r\t]'Q\u001dBv\u001d\u0011\u0011IN!9\u000f\t\tm'q\u001c\b\u0005\u0003C\u0014i.C\u0001\u0006\u0013\t\u0019A!C\u0002\u0003d\n\tQ#\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG-\u0003\u0003\u0003h\n%(\u0001\u0006*fgVdGoV5uQB\u000b'\u000f^5uS>t7OC\u0002\u0003d\n\u0001R!\u0003BJ\u0005[\u0004BAa<\u0003|:!!\u0011\u001fB|\u001b\t\u0011\u0019PC\u0002\u0003vf\n\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0005s\u0014\u00190\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH/\u0003\u0003\u0003~\n}(a\u0002\"vS2$WM\u001d\u0006\u0005\u0005s\u0014\u0019\u0010\u0003\u0005\u0004\u0004\t=\u0007\u0019AB\u0003\u00031\u0001\u0018M\u001d;ji&|g.T1q!\u001d13q\u0001B&\u0007\u0013I1A!\u0013(!\r\u001121B\u0005\u0004\u0007\u001b\u0011!a\u0005)beRLG/[8o\r\u0016$8\r[*uCR,\u0007\u0002CB\t\u00057!\tea\u0005\u0002\u00171\fG/Z:u\u000bB|7\r\u001b\u000b\u0005\u0007+\u00199\u0002\u0005\u0003\n\u0005';\u0005\u0002\u0003B6\u0007\u001f\u0001\rAa\u0013\t\u0011\u0005U%1\u0004C!\u00077!2AQB\u000f\u0011!\u0011Yg!\u0007A\u0002\t-\u0003\u0002CB\u0011\u00057!\tea\t\u0002#\u0015tGm\u00144gg\u0016$hi\u001c:Fa>\u001c\u0007\u000e\u0006\u0004\u0004&\r\u001d2\u0011\u0006\t\u0005\u0013\tMU\u000b\u0003\u0005\u0003l\r}\u0001\u0019\u0001B&\u0011\u001d\u0019Yca\bA\u0002\u001d\u000bQ!\u001a9pG\"D\u0001ba\f\u0003\u001c\u0011%1\u0011G\u0001\u0019G\",7m[#ya\u0016\u001cG/\u001a3MK\u0006$WM]#q_\u000eDGCBB\u001a\u0007\u0003\u001a\t\u0007E\u0003\n\u0005'\u001b)\u0004\u0005\u0003\u00048\ruRBAB\u001d\u0015\r\u0019Y$O\u0001\taJ|Go\\2pY&!1qHB\u001d\u0005\u0019)%O]8sg\"A11IB\u0017\u0001\u0004\u0019)%\u0001\tfqB,7\r^3e\u000bB|7\r[(qiB11qIB)\u0007+j!a!\u0013\u000b\t\r-3QJ\u0001\u0005kRLGN\u0003\u0002\u0004P\u0005!!.\u0019<b\u0013\u0011\u0019\u0019f!\u0013\u0003\u0011=\u0003H/[8oC2\u0004Baa\u0016\u0004^5\u00111\u0011\f\u0006\u0005\u00077\u001ai%\u0001\u0003mC:<\u0017\u0002BB0\u00073\u0012q!\u00138uK\u001e,'\u000f\u0003\u0005\u0004d\r5\u0002\u0019\u0001B*\u00039\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016D\u0001ba\u001a\u0003\u001c\u0011%1\u0011N\u0001\u0018Y>|7.\u001e9F]\u0012|eMZ:fi\u001a{'/\u00129pG\"$baa\u001b\u0004r\rm\u0004\u0003\u0002By\u0007[JAaa\u001c\u0003t\nqQ\t]8dQ\u0016sGm\u00144gg\u0016$\b\u0002CB:\u0007K\u0002\ra!\u001e\u0002\u0013\u0015\u0004xn\u00195ECR\f\u0007\u0003\u0002BV\u0007oJAa!\u001f\u0003\"\tIQ\t]8dQ\u0012\u000bG/\u0019\u0005\t\u0007G\u001a)\u00071\u0001\u0003T!A1q\u0010B\u000e\t\u0003\u001a\t)\u0001\u000bgKR\u001c\u0007.\u00129pG\",e\u000eZ(gMN,Go\u001d\u000b\u0005\u0007\u0007\u001b)\tE\u0004'\u0007\u000f\u0011Yea\u001b\t\u0011\r\u001d5Q\u0010a\u0001\u0007\u0013\u000b!\u0002]1si&$\u0018n\u001c8t!\u001d13q\u0001B&\u0007kB\u0001b!$\u0003\u001c\u0011E3qR\u0001 SN|eMZ:fi\u001a{'\u000fT3bI\u0016\u0014X\t]8dQN+\b\u000f]8si\u0016$WCABI!\rI11S\u0005\u0004\u0007+S!a\u0002\"p_2,\u0017M\u001c\u0005\t\u00073\u0013Y\u0002\"\u0011\u0004\u001c\u0006ya-\u001a;dQ\u001a\u0013x.\u001c'fC\u0012,'\u000f\u0006\u0003\u0004\u001e\u000e\u0015\u0006CBAo\u0003[\u001cy\nE\u0004\n\u0007C\u0013YE!+\n\u0007\r\r&B\u0001\u0004UkBdWM\r\u0005\t\u0007O\u001b9\n1\u0001\u0003n\u0006aa-\u001a;dQJ+\u0017/^3ti\"A11\u0016B\u000e\t\u0013\u0019i+\u0001\rdQ\u0016\u001c7\u000eT3bI\u0016\u0014X\t]8dQ\u0006sG\r\u00165s_^$RAFBX\u0007gCqa!-\u0004*\u0002\u0007q)A\u0007fqB,7\r^3e\u000bB|7\r\u001b\u0005\t\u0007G\u001aI\u000b1\u0001\u0003T!A1q\u0017B\u000e\t#\u001aI,A\u000fgKR\u001c\u0007.R1sY&,7\u000f^(gMN,GO\u0012:p[2+\u0017\rZ3s)\u0015\u001151XB_\u0011!\u0011Yg!.A\u0002\t-\u0003B\u0002$\u00046\u0002\u0007q\t\u0003\u0005\u0004B\nmA\u0011KBb\u0003m1W\r^2i\u0019\u0006$Xm\u001d;PM\u001a\u001cX\r\u001e$s_6dU-\u00193feR)!i!2\u0004H\"A!1NB`\u0001\u0004\u0011Y\u0005\u0003\u0004G\u0007\u007f\u0003\ra\u0012")
public class AbstractFetcherThreadTest {
    private volatile AbstractFetcherThreadTest$MockFetcherThread$ MockFetcherThread$module;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AbstractFetcherThreadTest$MockFetcherThread$ MockFetcherThread$lzycompute() {
        AbstractFetcherThreadTest abstractFetcherThreadTest = this;
        synchronized (abstractFetcherThreadTest) {
            if (this.MockFetcherThread$module != null) return this.MockFetcherThread$module;
            this.MockFetcherThread$module = new AbstractFetcherThreadTest$MockFetcherThread$(this);
            return this.MockFetcherThread$module;
        }
    }

    @Before
    public void cleanMetricRegistry() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(Metrics.defaultRegistry().allMetrics().keySet()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(MetricName metricName) {
                Metrics.defaultRegistry().removeMetric(metricName);
            }
        });
    }

    public Set<String> kafka$server$AbstractFetcherThreadTest$$allMetricsNames() {
        return (Set)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).keySet().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(MetricName x$1) {
                return x$1.getName();
            }
        }, Set$.MODULE$.canBuildFrom());
    }

    private RecordBatch mkBatch(long baseOffset, int leaderEpoch, Seq<SimpleRecord> records2) {
        return (RecordBatch)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(MemoryRecords.withRecords((long)baseOffset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(leaderEpoch), (SimpleRecord[])((SimpleRecord[])records2.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))).batches()).asScala()).head();
    }

    public OffsetAndEpoch kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(long fetchOffset, int leaderEpoch) {
        return new OffsetAndEpoch(fetchOffset, leaderEpoch);
    }

    @Test
    public void testMetricsRemovedOnShutdown() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0))})));
        fetcher.setLeaderState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.start();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractFetcherThreadTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Set<String> set = this.$outer.kafka$server$AbstractFetcherThreadTest$$allMetricsNames();
                GenTraversable genTraversable = Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{FetcherMetrics$.MODULE$.BytesPerSec(), FetcherMetrics$.MODULE$.RequestsPerSec(), FetcherMetrics$.MODULE$.ConsumerLag()}));
                return !(set != null ? !set.equals((Object)genTraversable) : genTraversable != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed waiting for all fetcher metrics to be registered";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        fetcher.shutdown();
        Assert.assertTrue((boolean)Metrics.defaultRegistry().allMetrics().isEmpty());
    }

    @Test
    public void testConsumerLagRemovedWithPartition() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0))})));
        fetcher.setLeaderState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.doWork();
        Assert.assertTrue((String)"Failed waiting for consumer lag metric", (boolean)this.kafka$server$AbstractFetcherThreadTest$$allMetricsNames().apply((Object)FetcherMetrics$.MODULE$.ConsumerLag()));
        fetcher.removePartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})));
        Assert.assertFalse((boolean)this.kafka$server$AbstractFetcherThreadTest$$allMetricsNames().apply((Object)FetcherMetrics$.MODULE$.ConsumerLag()));
    }

    @Test
    public void testSimpleFetch() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0))})));
        RecordBatch batch = this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{batch}))), 0, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        MockFetcherThread.PartitionState replicaState = fetcher.replicaPartitionState(partition);
        Assert.assertEquals((long)2L, (long)replicaState.logEndOffset());
        Assert.assertEquals((long)2L, (long)replicaState.highWatermark());
    }

    @Test
    public void testFencedTruncation() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0))})));
        RecordBatch batch = this.mkBatch(0L, 1, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{batch}))), 1, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        MockFetcherThread.PartitionState replicaState = fetcher.replicaPartitionState(partition);
        Assert.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assert.assertEquals((long)0L, (long)replicaState.highWatermark());
        Assert.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
    }

    @Test
    public void testFencedFetch() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply(0);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0))})));
        RecordBatch batch = this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{batch}))), 0, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((long)2L, (long)replicaState.logEndOffset());
        MockFetcherThread.PartitionState partitionState = fetcher.leaderPartitionState(partition);
        partitionState.leaderEpoch_$eq(partitionState.leaderEpoch() + 1);
        fetcher.doWork();
        Assert.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
    }

    @Test
    public void testUnknownLeaderEpochInTruncation() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply(1);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 1))})));
        RecordBatch batch = this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{batch}))), 0, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assert.assertEquals((Object)new Some((Object)Truncating$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ReplicaState apply(PartitionFetchState x$2) {
                return x$2.state();
            }
        }));
        MockFetcherThread.PartitionState partitionState = fetcher.leaderPartitionState(partition);
        partitionState.leaderEpoch_$eq(partitionState.leaderEpoch() + 1);
        fetcher.doWork();
        Assert.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assert.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ReplicaState apply(PartitionFetchState x$3) {
                return x$3.state();
            }
        }));
    }

    @Test
    public void testUnknownLeaderEpochWhileFetching() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply(1);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 1))})));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())}))}))), 1, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assert.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ReplicaState apply(PartitionFetchState x$4) {
                return x$4.state();
            }
        }));
        fetcher.leaderPartitionState(partition).leaderEpoch_$eq(0);
        fetcher.doWork();
        Assert.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assert.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ReplicaState apply(PartitionFetchState x$5) {
                return x$5.state();
            }
        }));
        fetcher.leaderPartitionState(partition).leaderEpoch_$eq(1);
        fetcher.doWork();
        Assert.assertEquals((long)2L, (long)replicaState.logEndOffset());
        Assert.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ReplicaState apply(PartitionFetchState x$6) {
                return x$6.state();
            }
        }));
    }

    @Test
    public void testTruncation() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 5, 0L);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(3L, 5))})));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 1, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 3, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 5, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, 5, 2L);
        fetcher.setLeaderState(partition, leaderState);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, partition, fetcher){
            public static final long serialVersionUID = 0L;
            private final TopicPartition partition$1;
            private final MockFetcherThread fetcher$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.fetcher$1.doWork();
                Buffer<RecordBatch> buffer = this.fetcher$1.replicaPartitionState(this.partition$1).log();
                Buffer<RecordBatch> buffer2 = this.fetcher$1.leaderPartitionState(this.partition$1).log();
                return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
            }
            {
                this.partition$1 = partition$1;
                this.fetcher$1 = fetcher$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to reconcile leader and follower logs";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertEquals((long)leaderState.logStartOffset(), (long)replicaState.logStartOffset());
        Assert.assertEquals((long)leaderState.logEndOffset(), (long)replicaState.logEndOffset());
        Assert.assertEquals((long)leaderState.highWatermark(), (long)replicaState.highWatermark());
    }

    @Test
    public void testTruncateToHighWatermarkIfLeaderEpochRequestNotSupported() {
        long highWatermark = 2L;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, highWatermark){
            private final long highWatermark$1;

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                Assert.assertEquals((long)this.highWatermark$1, (long)truncationState.offset());
                Assert.assertTrue((boolean)truncationState.truncationCompleted());
                super.truncate(topicPartition, truncationState);
            }

            public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
                throw new UnsupportedOperationException();
            }

            public boolean isOffsetForLeaderEpochSupported() {
                return false;
            }
            {
                this.highWatermark$1 = highWatermark$1;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
            }
        };
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 5, highWatermark);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(highWatermark, 5))})));
        fetcher.doWork();
        Assert.assertEquals((long)highWatermark, (long)replicaState.logEndOffset());
        Assert.assertEquals((long)highWatermark, (long)((PartitionFetchState)fetcher.fetchState(partition).get()).fetchOffset());
        Assert.assertTrue((boolean)((PartitionFetchState)fetcher.fetchState(partition).get()).isReadyForFetch());
    }

    @Test
    public void testTruncateToHighWatermarkIfLeaderEpochInfoNotAvailable() {
        long highWatermark = 2L;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, highWatermark){
            private final long highWatermark$2;

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                Assert.assertEquals((long)this.highWatermark$2, (long)truncationState.offset());
                Assert.assertTrue((boolean)truncationState.truncationCompleted());
                super.truncate(topicPartition, truncationState);
            }

            public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
                throw new UnsupportedOperationException();
            }

            public Option<Object> latestEpoch(TopicPartition topicPartition) {
                return None$.MODULE$;
            }
            {
                this.highWatermark$2 = highWatermark$2;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
            }
        };
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 5, highWatermark);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(highWatermark, 5))})));
        fetcher.doWork();
        Assert.assertEquals((long)highWatermark, (long)replicaState.logEndOffset());
        Assert.assertEquals((long)highWatermark, (long)((PartitionFetchState)fetcher.fetchState(partition).get()).fetchOffset());
        Assert.assertTrue((boolean)((PartitionFetchState)fetcher.fetchState(partition).get()).isReadyForFetch());
    }

    @Test
    public void testTruncationSkippedIfNoEpochChange() {
        TopicPartition partition = new TopicPartition("topic", 0);
        IntRef truncations = IntRef.create((int)0);
        MockFetcherThread fetcher = new MockFetcherThread(this, truncations){
            private final IntRef truncations$1;

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                ++this.truncations$1.elem;
                super.truncate(topicPartition, truncationState);
            }
            {
                this.truncations$1 = truncations$1;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
            }
        };
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply(5);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 5))})));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 1, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 3, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 5, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, 5, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assert.assertEquals((long)1L, (long)truncations.elem);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(3L, 5))})));
        fetcher.doWork();
        Assert.assertEquals((long)1L, (long)truncations.elem);
        Assert.assertEquals((long)2L, (long)replicaState.logEndOffset());
    }

    @Test
    public void testFollowerFetchOutOfRangeHigh() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 4, 0L);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(3L, 4))})));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, 4, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((long)3L, (long)replicaState.logEndOffset());
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ReplicaState apply(PartitionFetchState x$7) {
                return x$7.state();
            }
        }));
        leaderState.log().clear();
        leaderState.logEndOffset_$eq(0L);
        leaderState.logStartOffset_$eq(0L);
        leaderState.highWatermark_$eq(0L);
        fetcher.doWork();
        Assert.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assert.assertEquals((long)0L, (long)replicaState.logStartOffset());
        Assert.assertEquals((long)0L, (long)replicaState.highWatermark());
    }

    @Test
    public void testFencedOffsetResetAfterOutOfRange() {
        TopicPartition partition = new TopicPartition("topic", 0);
        BooleanRef fetchedEarliestOffset = BooleanRef.create((boolean)false);
        MockFetcherThread fetcher = new MockFetcherThread(this, fetchedEarliestOffset){
            private final BooleanRef fetchedEarliestOffset$1;

            public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
                this.fetchedEarliestOffset$1.elem = true;
                throw new FencedLeaderEpochException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Epoch ", " is fenced"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leaderEpoch)})));
            }
            {
                this.fetchedEarliestOffset$1 = fetchedEarliestOffset$1;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
            }
        };
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 4, 0L);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 4))})));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, 4, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assert.assertTrue((boolean)fetchedEarliestOffset.elem);
        Assert.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
    }

    @Test
    public void testFollowerFetchOutOfRangeLow() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 0, 0L);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(3L, 0))})));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, 0, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ReplicaState apply(PartitionFetchState x$8) {
                return x$8.state();
            }
        }));
        Assert.assertEquals((long)2L, (long)replicaState.logStartOffset());
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)replicaState.log().toList());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, partition, fetcher){
            public static final long serialVersionUID = 0L;
            private final TopicPartition partition$2;
            private final MockFetcherThread fetcher$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.fetcher$2.doWork();
                Buffer<RecordBatch> buffer = this.fetcher$2.replicaPartitionState(this.partition$2).log();
                Buffer<RecordBatch> buffer2 = this.fetcher$2.leaderPartitionState(this.partition$2).log();
                return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
            }
            {
                this.partition$2 = partition$2;
                this.fetcher$2 = fetcher$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to reconcile leader and follower logs";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertEquals((long)leaderState.logStartOffset(), (long)replicaState.logStartOffset());
        Assert.assertEquals((long)leaderState.logEndOffset(), (long)replicaState.logEndOffset());
        Assert.assertEquals((long)leaderState.highWatermark(), (long)replicaState.highWatermark());
    }

    @Test
    public void testRetryAfterUnknownLeaderEpochInLatestOffsetFetch() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this){
            private final AtomicInteger tries;

            private AtomicInteger tries() {
                return this.tries;
            }

            public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
                if (this.tries().getAndIncrement() == 0) {
                    throw new UnknownLeaderEpochException("Unexpected leader epoch");
                }
                return super.fetchLatestOffsetFromLeader(topicPartition, leaderEpoch);
            }
            {
                this.tries = new AtomicInteger(0);
            }
        };
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 0, 0L);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(3L, 0))})));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, 0, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ReplicaState apply(PartitionFetchState x$9) {
                return x$9.state();
            }
        }));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, partition, fetcher){
            public static final long serialVersionUID = 0L;
            private final TopicPartition partition$3;
            private final MockFetcherThread fetcher$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.fetcher$3.doWork();
                Buffer<RecordBatch> buffer = this.fetcher$3.replicaPartitionState(this.partition$3).log();
                Buffer<RecordBatch> buffer2 = this.fetcher$3.leaderPartitionState(this.partition$3).log();
                return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
            }
            {
                this.partition$3 = partition$3;
                this.fetcher$3 = fetcher$3;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to reconcile leader and follower logs";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertEquals((long)leaderState.logStartOffset(), (long)replicaState.logStartOffset());
        Assert.assertEquals((long)leaderState.logEndOffset(), (long)replicaState.logEndOffset());
        Assert.assertEquals((long)leaderState.highWatermark(), (long)replicaState.highWatermark());
    }

    @Test
    public void testCorruptMessage() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this){
            private boolean fetchedOnce;

            public boolean fetchedOnce() {
                return this.fetchedOnce;
            }

            public void fetchedOnce_$eq(boolean x$1) {
                this.fetchedOnce = x$1;
            }

            /*
             * WARNING - void declaration
             */
            public Seq<Tuple2<TopicPartition, FetchResponse.PartitionData<Records>>> fetchFromLeader(FetchRequest.Builder fetchRequest) {
                void var2_2;
                Seq<Tuple2<TopicPartition, FetchResponse.PartitionData<Records>>> fetchedData = super.fetchFromLeader(fetchRequest);
                if (!this.fetchedOnce()) {
                    MemoryRecords records2 = (MemoryRecords)((FetchResponse.PartitionData)((Tuple2)fetchedData.head())._2()).records;
                    ByteBuffer buffer = records2.buffer();
                    buffer.putInt(15, buffer.getInt(15) ^ 0x5B7E);
                    buffer.putInt(30, buffer.getInt(30) ^ 0x16C3A);
                    this.fetchedOnce_$eq(true);
                }
                return var2_2;
            }
            {
                this.fetchedOnce = false;
            }
        };
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0))})));
        RecordBatch batch = this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{batch}))), 0, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        fetcher.doWork();
        MockFetcherThread.PartitionState replicaState = fetcher.replicaPartitionState(partition);
        Assert.assertEquals((long)2L, (long)replicaState.logEndOffset());
    }

    @Test
    public void testLeaderEpochChangeDuringFencedFetchEpochsFromLeader() {
        this.testLeaderEpochChangeDuringFetchEpochsFromLeader(1);
    }

    @Test
    public void testLeaderEpochChangeDuringSuccessfulFetchEpochsFromLeader() {
        this.testLeaderEpochChangeDuringFetchEpochsFromLeader(0);
    }

    private void testLeaderEpochChangeDuringFetchEpochsFromLeader(int leaderEpochOnLeader) {
        TopicPartition partition = new TopicPartition("topic", 0);
        int initialLeaderEpochOnFollower = 0;
        int nextLeaderEpochOnFollower = initialLeaderEpochOnFollower + 1;
        MockFetcherThread fetcher = new MockFetcherThread(this, partition, nextLeaderEpochOnFollower){
            private boolean fetchEpochsFromLeaderOnce;
            private final /* synthetic */ AbstractFetcherThreadTest $outer;
            private final TopicPartition partition$4;
            private final int nextLeaderEpochOnFollower$1;

            public boolean fetchEpochsFromLeaderOnce() {
                return this.fetchEpochsFromLeaderOnce;
            }

            public void fetchEpochsFromLeaderOnce_$eq(boolean x$1) {
                this.fetchEpochsFromLeaderOnce = x$1;
            }

            /*
             * WARNING - void declaration
             */
            public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
                void var2_2;
                Map<TopicPartition, EpochEndOffset> fetchedEpochs = super.fetchEpochEndOffsets(partitions);
                if (!this.fetchEpochsFromLeaderOnce()) {
                    this.removePartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition$4})));
                    this.setReplicaState(this.partition$4, this.$outer.MockFetcherThread().PartitionState().apply(this.nextLeaderEpochOnFollower$1));
                    this.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition$4), (Object)this.$outer.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, this.nextLeaderEpochOnFollower$1))})));
                    this.fetchEpochsFromLeaderOnce_$eq(true);
                }
                return var2_2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$4 = partition$4;
                this.nextLeaderEpochOnFollower$1 = nextLeaderEpochOnFollower$1;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
                this.fetchEpochsFromLeaderOnce = false;
            }
        };
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(initialLeaderEpochOnFollower));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, initialLeaderEpochOnFollower))})));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, initialLeaderEpochOnFollower, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, leaderEpochOnLeader, 0L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)Truncating$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ReplicaState apply(PartitionFetchState x$10) {
                return x$10.state();
            }
        }));
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)nextLeaderEpochOnFollower)), (Object)fetcher.fetchState(partition).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(PartitionFetchState x$11) {
                return x$11.currentLeaderEpoch();
            }
        }));
        if (leaderEpochOnLeader < nextLeaderEpochOnFollower) {
            fetcher.setLeaderState(partition, this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, nextLeaderEpochOnFollower, 0L));
        }
        fetcher.doWork();
        Assert.assertEquals(fetcher.leaderPartitionState(partition).log(), fetcher.replicaPartitionState(partition).log());
    }

    @Test
    public void testTruncationThrowsExceptionIfLeaderReturnsPartitionsNotRequestedInFetchEpochs() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this){

            public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
                TopicPartition unrequestedTp = new TopicPartition("topic2", 0);
                return super.fetchEpochEndOffsets(partitions).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unrequestedTp), (Object)new EpochEndOffset(0, 0L)));
            }
        };
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0))})));
        fetcher.setLeaderState(partition, this.MockFetcherThread().PartitionState().apply(0));
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, fetcher){
            public static final long serialVersionUID = 0L;
            private final MockFetcherThread fetcher$4;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.fetcher$4.doWork();
            }
            {
                this.fetcher$4 = fetcher$4;
            }
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("AbstractFetcherThreadTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 648));
    }

    public AbstractFetcherThreadTest$MockFetcherThread$ MockFetcherThread() {
        return this.MockFetcherThread$module == null ? this.MockFetcherThread$lzycompute() : this.MockFetcherThread$module;
    }

    public class MockFetcherThread
    extends AbstractFetcherThread {
        private final int replicaId;
        private final int leaderId;
        private final scala.collection.mutable.Map<TopicPartition, PartitionState> replicaPartitionStates;
        private final scala.collection.mutable.Map<TopicPartition, PartitionState> leaderPartitionStates;
        public final /* synthetic */ AbstractFetcherThreadTest $outer;

        public int replicaId() {
            return this.replicaId;
        }

        public int leaderId() {
            return this.leaderId;
        }

        private scala.collection.mutable.Map<TopicPartition, PartitionState> replicaPartitionStates() {
            return this.replicaPartitionStates;
        }

        private scala.collection.mutable.Map<TopicPartition, PartitionState> leaderPartitionStates() {
            return this.leaderPartitionStates;
        }

        public void setLeaderState(TopicPartition topicPartition, PartitionState state) {
            this.leaderPartitionStates().put((Object)topicPartition, (Object)state);
        }

        public void setReplicaState(TopicPartition topicPartition, PartitionState state) {
            this.replicaPartitionStates().put((Object)topicPartition, (Object)state);
        }

        public PartitionState replicaPartitionState(TopicPartition topicPartition) {
            return (PartitionState)this.replicaPartitionStates().getOrElse((Object)topicPartition, (Function0)new Serializable(this, topicPartition){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$1;

                public final Nothing$ apply() {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$1})));
                }
                {
                    this.topicPartition$1 = topicPartition$1;
                }
            });
        }

        public PartitionState leaderPartitionState(TopicPartition topicPartition) {
            return (PartitionState)this.leaderPartitionStates().getOrElse((Object)topicPartition, (Function0)new Serializable(this, topicPartition){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$2;

                public final Nothing$ apply() {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$2})));
                }
                {
                    this.topicPartition$2 = topicPartition$2;
                }
            });
        }

        public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponse.PartitionData<Records> partitionData) {
            PartitionState state = this.replicaPartitionState(topicPartition);
            if (fetchOffset != state.logEndOffset()) {
                throw new RuntimeException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset mismatch for partition ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fetched offset = ", ", log end offset = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)state.logEndOffset())}))).toString());
            }
            Iterable batches = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((Records)partitionData.records).batches()).asScala();
            LongRef maxTimestamp = LongRef.create((long)-1L);
            LongRef offsetOfMaxTimestamp = LongRef.create((long)-1L);
            LongRef lastOffset = LongRef.create((long)state.logEndOffset());
            batches.foreach((Function1)new Serializable(this, state, maxTimestamp, offsetOfMaxTimestamp, lastOffset){
                public static final long serialVersionUID = 0L;
                private final PartitionState state$1;
                private final LongRef maxTimestamp$1;
                private final LongRef offsetOfMaxTimestamp$1;
                private final LongRef lastOffset$1;

                public final void apply(RecordBatch batch) {
                    batch.ensureValid();
                    if (batch.maxTimestamp() > this.maxTimestamp$1.elem) {
                        this.maxTimestamp$1.elem = batch.maxTimestamp();
                        this.offsetOfMaxTimestamp$1.elem = batch.baseOffset();
                    }
                    this.state$1.log().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{batch}));
                    this.state$1.logEndOffset_$eq(batch.nextOffset());
                    this.lastOffset$1.elem = batch.lastOffset();
                }
                {
                    this.state$1 = state$1;
                    this.maxTimestamp$1 = maxTimestamp$1;
                    this.offsetOfMaxTimestamp$1 = offsetOfMaxTimestamp$1;
                    this.lastOffset$1 = lastOffset$1;
                }
            });
            state.logStartOffset_$eq(partitionData.logStartOffset);
            state.highWatermark_$eq(partitionData.highWatermark);
            return new Some((Object)new LogAppendInfo((Option)new Some((Object)BoxesRunTime.boxToLong((long)fetchOffset)), lastOffset.elem, maxTimestamp.elem, offsetOfMaxTimestamp.elem, Time.SYSTEM.milliseconds(), state.logStartOffset(), RecordConversionStats.EMPTY, (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, batches.size(), partitionData.records.sizeInBytes(), true, BoxesRunTime.unboxToLong((Object)batches.headOption().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply(RecordBatch x$14) {
                    return x$14.lastOffset();
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply() {
                    return this.apply$mcJ$sp();
                }

                public long apply$mcJ$sp() {
                    return -1L;
                }
            }))));
        }

        public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
            PartitionState state = this.replicaPartitionState(topicPartition);
            state.log_$eq((Buffer<RecordBatch>)((Buffer)state.log().takeWhile((Function1)new Serializable(this, truncationState){
                public static final long serialVersionUID = 0L;
                private final OffsetTruncationState truncationState$1;

                public final boolean apply(RecordBatch batch) {
                    return batch.lastOffset() < this.truncationState$1.offset();
                }
                {
                    this.truncationState$1 = truncationState$1;
                }
            })));
            state.logEndOffset_$eq(BoxesRunTime.unboxToLong((Object)state.log().lastOption().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply(RecordBatch x$15) {
                    return x$15.lastOffset() + 1L;
                }
            }).getOrElse((Function0)new Serializable(this, state){
                public static final long serialVersionUID = 0L;
                private final PartitionState state$2;

                public final long apply() {
                    return this.apply$mcJ$sp();
                }

                public long apply$mcJ$sp() {
                    return this.state$2.logStartOffset();
                }
                {
                    this.state$2 = state$2;
                }
            })));
            state.highWatermark_$eq(package$.MODULE$.min(state.highWatermark(), state.logEndOffset()));
        }

        public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
            PartitionState state = this.replicaPartitionState(topicPartition);
            state.log().clear();
            state.logStartOffset_$eq(offset);
            state.logEndOffset_$eq(offset);
            state.highWatermark_$eq(offset);
        }

        public AbstractFetcherThread.ResultWithPartitions<Option<FetchRequest.Builder>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
            scala.collection.mutable.Map fetchData = Map$.MODULE$.empty();
            partitionMap.foreach((Function1)new Serializable(this, fetchData){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MockFetcherThread $outer;
                private final scala.collection.mutable.Map fetchData$1;

                public final Object apply(Tuple2<TopicPartition, PartitionFetchState> x0$1) {
                    Tuple2<TopicPartition, PartitionFetchState> tuple2 = x0$1;
                    if (tuple2 != null) {
                        BoxedUnit boxedUnit;
                        TopicPartition partition = (TopicPartition)tuple2._1();
                        PartitionFetchState state = (PartitionFetchState)tuple2._2();
                        if (state.isReadyForFetch()) {
                            PartitionState replicaState = this.$outer.replicaPartitionState(partition);
                            boxedUnit = this.fetchData$1.put((Object)partition, (Object)new FetchRequest.PartitionData(state.fetchOffset(), replicaState.logStartOffset(), 0x100000, Optional.of(Predef$.MODULE$.int2Integer(state.currentLeaderEpoch()))));
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        return boxedUnit2;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.fetchData$1 = fetchData$1;
                }
            });
            FetchRequest.Builder fetchRequest = FetchRequest.Builder.forReplica((short)ApiKeys.FETCH.latestVersion(), (int)this.replicaId(), (int)0, (int)1, (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(fetchData).asJava()));
            return new AbstractFetcherThread.ResultWithPartitions((Object)new Some((Object)fetchRequest), Set$.MODULE$.empty());
        }

        public Option<Object> latestEpoch(TopicPartition topicPartition) {
            PartitionState state = this.replicaPartitionState(topicPartition);
            return state.log().lastOption().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(RecordBatch x$16) {
                    return x$16.partitionLeaderEpoch();
                }
            }).orElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Some<Object> apply() {
                    return new Some((Object)BoxesRunTime.boxToInteger((int)-1));
                }
            });
        }

        public long logEndOffset(TopicPartition topicPartition) {
            return this.replicaPartitionState(topicPartition).logEndOffset();
        }

        public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
            OffsetsForLeaderEpochRequest.PartitionData epochData = new OffsetsForLeaderEpochRequest.PartitionData(Optional.empty(), epoch);
            EpochEndOffset result = this.kafka$server$AbstractFetcherThreadTest$MockFetcherThread$$lookupEndOffsetForEpoch(epochData, this.replicaPartitionState(topicPartition));
            return result.endOffset() == -1L ? None$.MODULE$ : new Some((Object)new OffsetAndEpoch(result.endOffset(), result.leaderEpoch()));
        }

        public Option<Errors> kafka$server$AbstractFetcherThreadTest$MockFetcherThread$$checkExpectedLeaderEpoch(Optional<Integer> expectedEpochOpt, PartitionState partitionState) {
            Integer expectedEpoch;
            return expectedEpochOpt.isPresent() ? (Predef$.MODULE$.Integer2int(expectedEpoch = expectedEpochOpt.get()) < partitionState.leaderEpoch() ? new Some((Object)Errors.FENCED_LEADER_EPOCH) : (Predef$.MODULE$.Integer2int(expectedEpoch) > partitionState.leaderEpoch() ? new Some((Object)Errors.UNKNOWN_LEADER_EPOCH) : None$.MODULE$)) : None$.MODULE$;
        }

        public EpochEndOffset kafka$server$AbstractFetcherThreadTest$MockFetcherThread$$lookupEndOffsetForEpoch(OffsetsForLeaderEpochRequest.PartitionData epochData, PartitionState partitionState) {
            NonLocalReturnControl nonLocalReturnControl2;
            block2: {
                EpochEndOffset epochEndOffset;
                Object object = new Object();
                try {
                    this.kafka$server$AbstractFetcherThreadTest$MockFetcherThread$$checkExpectedLeaderEpoch(epochData.currentLeaderEpoch, partitionState).foreach((Function1)new Serializable(this, object){
                        public static final long serialVersionUID = 0L;
                        private final Object nonLocalReturnKey1$1;

                        public final Nothing$ apply(Errors error) {
                            throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)new EpochEndOffset(error, -1, -1L));
                        }
                        {
                            this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                        }
                    });
                    IntRef epochLowerBound = IntRef.create((int)-1);
                    partitionState.log().foreach((Function1)new Serializable(this, epochData, epochLowerBound, object){
                        public static final long serialVersionUID = 0L;
                        private final OffsetsForLeaderEpochRequest.PartitionData epochData$1;
                        private final IntRef epochLowerBound$1;
                        private final Object nonLocalReturnKey1$1;

                        public final void apply(RecordBatch batch) {
                            if (batch.partitionLeaderEpoch() > this.epochData$1.leaderEpoch) {
                                throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)new EpochEndOffset(Errors.NONE, this.epochLowerBound$1.elem, batch.baseOffset()));
                            }
                            this.epochLowerBound$1.elem = batch.partitionLeaderEpoch();
                        }
                        {
                            this.epochData$1 = epochData$1;
                            this.epochLowerBound$1 = epochLowerBound$1;
                            this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                        }
                    });
                    epochEndOffset = new EpochEndOffset(Errors.NONE, -1, -1L);
                }
                catch (NonLocalReturnControl nonLocalReturnControl2) {
                    if (nonLocalReturnControl2.key() != object) break block2;
                    epochEndOffset = (EpochEndOffset)nonLocalReturnControl2.value();
                }
                return epochEndOffset;
            }
            throw nonLocalReturnControl2;
        }

        /*
         * WARNING - void declaration
         */
        public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
            void var2_2;
            scala.collection.mutable.Map endOffsets = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            partitions.foreach((Function1)new Serializable(this, endOffsets){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MockFetcherThread $outer;
                private final scala.collection.mutable.Map endOffsets$1;

                public final Option<EpochEndOffset> apply(Tuple2<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> x0$2) {
                    Tuple2<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> tuple2 = x0$2;
                    if (tuple2 != null) {
                        TopicPartition partition = (TopicPartition)tuple2._1();
                        OffsetsForLeaderEpochRequest.PartitionData epochData = (OffsetsForLeaderEpochRequest.PartitionData)tuple2._2();
                        PartitionState leaderState = this.$outer.leaderPartitionState(partition);
                        EpochEndOffset epochEndOffset = this.$outer.kafka$server$AbstractFetcherThreadTest$MockFetcherThread$$lookupEndOffsetForEpoch(epochData, leaderState);
                        Option option = this.endOffsets$1.put((Object)partition, (Object)epochEndOffset);
                        return option;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.endOffsets$1 = endOffsets$1;
                }
            });
            return var2_2;
        }

        public boolean isOffsetForLeaderEpochSupported() {
            return true;
        }

        public Seq<Tuple2<TopicPartition, FetchResponse.PartitionData<Records>>> fetchFromLeader(FetchRequest.Builder fetchRequest) {
            return ((MapLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(fetchRequest.fetchData()).asScala()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MockFetcherThread $outer;

                public final Tuple2<TopicPartition, FetchResponse.PartitionData<Records>> apply(Tuple2<TopicPartition, FetchRequest.PartitionData> x0$3) {
                    Tuple2<TopicPartition, FetchRequest.PartitionData> tuple2;
                    block4: {
                        Option option;
                        block10: {
                            Tuple2 tuple22;
                            PartitionState leaderState;
                            TopicPartition partition;
                            block6: {
                                MemoryRecords memoryRecords;
                                Tuple2 tuple23;
                                block9: {
                                    block8: {
                                        FetchRequest.PartitionData fetchData;
                                        block7: {
                                            block5: {
                                                tuple2 = x0$3;
                                                if (tuple2 == null) break block4;
                                                partition = (TopicPartition)tuple2._1();
                                                fetchData = (FetchRequest.PartitionData)tuple2._2();
                                                leaderState = this.$outer.leaderPartitionState(partition);
                                                Option<Errors> epochCheckError = this.$outer.kafka$server$AbstractFetcherThreadTest$MockFetcherThread$$checkExpectedLeaderEpoch(fetchData.currentLeaderEpoch, leaderState);
                                                if (!epochCheckError.isDefined()) break block5;
                                                tuple23 = new Tuple2(epochCheckError.get(), (Object)MemoryRecords.EMPTY);
                                                break block6;
                                            }
                                            if (fetchData.fetchOffset <= leaderState.logEndOffset() && fetchData.fetchOffset >= leaderState.logStartOffset()) break block7;
                                            tuple23 = new Tuple2((Object)Errors.OFFSET_OUT_OF_RANGE, (Object)MemoryRecords.EMPTY);
                                            break block6;
                                        }
                                        option = leaderState.log().find((Function1)new Serializable(this, fetchData){
                                            public static final long serialVersionUID = 0L;
                                            private final FetchRequest.PartitionData fetchData$2;

                                            public final boolean apply(RecordBatch x$17) {
                                                return x$17.baseOffset() >= this.fetchData$2.fetchOffset;
                                            }
                                            {
                                                this.fetchData$2 = fetchData$2;
                                            }
                                        });
                                        if (!(option instanceof Some)) break block8;
                                        Some some = (Some)option;
                                        RecordBatch batch = (RecordBatch)some.x();
                                        ByteBuffer buffer = ByteBuffer.allocate(batch.sizeInBytes());
                                        batch.writeTo(buffer);
                                        buffer.flip();
                                        memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
                                        break block9;
                                    }
                                    if (!None$.MODULE$.equals(option)) break block10;
                                    memoryRecords = MemoryRecords.EMPTY;
                                }
                                MemoryRecords records2 = memoryRecords;
                                tuple23 = tuple22 = new Tuple2((Object)Errors.NONE, (Object)records2);
                            }
                            if (tuple22 != null) {
                                Tuple2 tuple24;
                                Errors error = (Errors)tuple22._1();
                                MemoryRecords records3 = (MemoryRecords)tuple22._2();
                                Tuple2 tuple25 = tuple24 = new Tuple2((Object)error, (Object)records3);
                                Errors error2 = (Errors)tuple25._1();
                                MemoryRecords records4 = (MemoryRecords)tuple25._2();
                                Tuple2 tuple26 = new Tuple2((Object)partition, (Object)new FetchResponse.PartitionData(error2, leaderState.highWatermark(), leaderState.highWatermark(), leaderState.logStartOffset(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava(), (BaseRecords)records4));
                                return tuple26;
                            }
                            throw new MatchError((Object)tuple22);
                        }
                        throw new MatchError((Object)option);
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Map$.MODULE$.canBuildFrom())).toSeq();
        }

        private void checkLeaderEpochAndThrow(int expectedEpoch, PartitionState partitionState) {
            this.kafka$server$AbstractFetcherThreadTest$MockFetcherThread$$checkExpectedLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(expectedEpoch)), partitionState).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply(Errors error) {
                    throw error.exception();
                }
            });
        }

        public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
            PartitionState leaderState = this.leaderPartitionState(topicPartition);
            this.checkLeaderEpochAndThrow(leaderEpoch, leaderState);
            return leaderState.logStartOffset();
        }

        public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
            PartitionState leaderState = this.leaderPartitionState(topicPartition);
            this.checkLeaderEpochAndThrow(leaderEpoch, leaderState);
            return leaderState.logEndOffset();
        }

        public /* synthetic */ AbstractFetcherThreadTest kafka$server$AbstractFetcherThreadTest$MockFetcherThread$$$outer() {
            return this.$outer;
        }

        public MockFetcherThread(AbstractFetcherThreadTest $outer, int replicaId, int leaderId) {
            this.replicaId = replicaId;
            this.leaderId = leaderId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("mock-fetcher", "mock-fetcher", new BrokerEndPoint(leaderId, "localhost", Random$.MODULE$.nextInt()), AbstractFetcherThread$.MODULE$.$lessinit$greater$default$4(), AbstractFetcherThread$.MODULE$.$lessinit$greater$default$5());
            this.replicaPartitionStates = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            this.leaderPartitionStates = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        }

        public class PartitionState {
            private Buffer<RecordBatch> log;
            private int leaderEpoch;
            private long logStartOffset;
            private long logEndOffset;
            private long highWatermark;
            public final /* synthetic */ AbstractFetcherThreadTest$MockFetcherThread$ $outer;

            public Buffer<RecordBatch> log() {
                return this.log;
            }

            public void log_$eq(Buffer<RecordBatch> x$1) {
                this.log = x$1;
            }

            public int leaderEpoch() {
                return this.leaderEpoch;
            }

            public void leaderEpoch_$eq(int x$1) {
                this.leaderEpoch = x$1;
            }

            public long logStartOffset() {
                return this.logStartOffset;
            }

            public void logStartOffset_$eq(long x$1) {
                this.logStartOffset = x$1;
            }

            public long logEndOffset() {
                return this.logEndOffset;
            }

            public void logEndOffset_$eq(long x$1) {
                this.logEndOffset = x$1;
            }

            public long highWatermark() {
                return this.highWatermark;
            }

            public void highWatermark_$eq(long x$1) {
                this.highWatermark = x$1;
            }

            public /* synthetic */ AbstractFetcherThreadTest$MockFetcherThread$ kafka$server$AbstractFetcherThreadTest$MockFetcherThread$PartitionState$$$outer() {
                return this.$outer;
            }

            public PartitionState(AbstractFetcherThreadTest$MockFetcherThread$ $outer, Buffer<RecordBatch> log2, int leaderEpoch, long logStartOffset, long logEndOffset, long highWatermark) {
                this.log = log2;
                this.leaderEpoch = leaderEpoch;
                this.logStartOffset = logStartOffset;
                this.logEndOffset = logEndOffset;
                this.highWatermark = highWatermark;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }
    }
}

