/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.controller.Callbacks;
import kafka.controller.Callbacks$;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewReplica$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.StateChangeLogger;
import kafka.controller.TopicDeletionManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.GetDataResponse$;
import kafka.zookeeper.ResponseMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tud\u0001B\u0001\u0003\u0001\u001d\u0011qCU3qY&\u001c\u0017m\u0015;bi\u0016l\u0015m\u00195j]\u0016$Vm\u001d;\u000b\u0005\r!\u0011AC2p]R\u0014x\u000e\u001c7fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u0011\u001b\u0005Q!BA\u0006\r\u0003\u0015QWO\\5u\u0015\tia\"A\u0005tG\u0006d\u0017\r^3ti*\tq\"A\u0002pe\u001eL!!\u0005\u0006\u0003\u0015)+f.\u001b;Tk&$X\rC\u0003\u0014\u0001\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002+A\u0011a\u0003A\u0007\u0002\u0005!9\u0001\u0004\u0001a\u0001\n\u0013I\u0012!E2p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yiV\t!\u0004\u0005\u0002\u00177%\u0011AD\u0001\u0002\u0012\u0007>tGO]8mY\u0016\u00148i\u001c8uKb$\bb\u0002\u0010\u0001\u0001\u0004%IaH\u0001\u0016G>tGO]8mY\u0016\u00148i\u001c8uKb$x\fJ3r)\t\u0001c\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0003V]&$\bbB\u0014\u001e\u0003\u0003\u0005\rAG\u0001\u0004q\u0012\n\u0004BB\u0015\u0001A\u0003&!$\u0001\nd_:$(o\u001c7mKJ\u001cuN\u001c;fqR\u0004\u0003bB\u0016\u0001\u0001\u0004%I\u0001L\u0001\r[>\u001c7NW6DY&,g\u000e^\u000b\u0002[A\u0011a&M\u0007\u0002_)\u0011\u0001\u0007B\u0001\u0003u.L!AM\u0018\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0011\u001d!\u0004\u00011A\u0005\nU\n\u0001#\\8dWj[7\t\\5f]R|F%Z9\u0015\u0005\u00012\u0004bB\u00144\u0003\u0003\u0005\r!\f\u0005\u0007q\u0001\u0001\u000b\u0015B\u0017\u0002\u001b5|7m\u001b.l\u00072LWM\u001c;!\u0011\u001dQ\u0004\u00011A\u0005\nm\n\u0001%\\8dW\u000e{g\u000e\u001e:pY2,'O\u0011:pW\u0016\u0014(+Z9vKN$()\u0019;dQV\tA\b\u0005\u0002\u0017{%\u0011aH\u0001\u0002\u001d\u0007>tGO]8mY\u0016\u0014(I]8lKJ\u0014V-];fgR\u0014\u0015\r^2i\u0011\u001d\u0001\u0005\u00011A\u0005\n\u0005\u000bA%\\8dW\u000e{g\u000e\u001e:pY2,'O\u0011:pW\u0016\u0014(+Z9vKN$()\u0019;dQ~#S-\u001d\u000b\u0003A\tCqaJ \u0002\u0002\u0003\u0007A\b\u0003\u0004E\u0001\u0001\u0006K\u0001P\u0001\"[>\u001c7nQ8oiJ|G\u000e\\3s\u0005J|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007\u000e\t\u0005\b\r\u0002\u0001\r\u0011\"\u0003H\u0003aiwnY6U_BL7\rR3mKRLwN\\'b]\u0006<WM]\u000b\u0002\u0011B\u0011a#S\u0005\u0003\u0015\n\u0011A\u0003V8qS\u000e$U\r\\3uS>tW*\u00198bO\u0016\u0014\bb\u0002'\u0001\u0001\u0004%I!T\u0001\u001d[>\u001c7\u000eV8qS\u000e$U\r\\3uS>tW*\u00198bO\u0016\u0014x\fJ3r)\t\u0001c\nC\u0004(\u0017\u0006\u0005\t\u0019\u0001%\t\rA\u0003\u0001\u0015)\u0003I\u0003eiwnY6U_BL7\rR3mKRLwN\\'b]\u0006<WM\u001d\u0011\t\u000fI\u0003\u0001\u0019!C\u0005'\u0006a!/\u001a9mS\u000e\f7\u000b^1uKV\tA\u000b\u0005\u0003V5r{V\"\u0001,\u000b\u0005]C\u0016aB7vi\u0006\u0014G.\u001a\u0006\u00033\n\n!bY8mY\u0016\u001cG/[8o\u0013\tYfKA\u0002NCB\u0004\"AF/\n\u0005y\u0013!a\u0005)beRLG/[8o\u0003:$'+\u001a9mS\u000e\f\u0007C\u0001\fa\u0013\t\t'A\u0001\u0007SKBd\u0017nY1Ti\u0006$X\rC\u0004d\u0001\u0001\u0007I\u0011\u00023\u0002!I,\u0007\u000f\\5dCN#\u0018\r^3`I\u0015\fHC\u0001\u0011f\u0011\u001d9#-!AA\u0002QCaa\u001a\u0001!B\u0013!\u0016!\u0004:fa2L7-Y*uCR,\u0007\u0005C\u0004j\u0001\u0001\u0007I\u0011\u00026\u0002'I,\u0007\u000f\\5dCN#\u0018\r^3NC\u000eD\u0017N\\3\u0016\u0003-\u0004\"A\u00067\n\u00055\u0014!a\u0005*fa2L7-Y*uCR,W*Y2iS:,\u0007bB8\u0001\u0001\u0004%I\u0001]\u0001\u0018e\u0016\u0004H.[2b'R\fG/Z'bG\"Lg.Z0%KF$\"\u0001I9\t\u000f\u001dr\u0017\u0011!a\u0001W\"11\u000f\u0001Q!\n-\fAC]3qY&\u001c\u0017m\u0015;bi\u0016l\u0015m\u00195j]\u0016\u0004\u0003bB;\u0001\u0005\u0004%IA^\u0001\tEJ|7.\u001a:JIV\tq\u000f\u0005\u0002\"q&\u0011\u0011P\t\u0002\u0004\u0013:$\bBB>\u0001A\u0003%q/A\u0005ce>\\WM]%eA!9Q\u0010\u0001b\u0001\n\u0013q\u0018AB2p]\u001aLw-F\u0001\u0000!\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003\t\u000511/\u001a:wKJLA!!\u0003\u0002\u0004\tY1*\u00194lC\u000e{gNZ5h\u0011\u001d\ti\u0001\u0001Q\u0001\n}\fqaY8oM&<\u0007\u0005\u0003\u0005\u0002\u0012\u0001\u0011\r\u0011\"\u0003w\u0003=\u0019wN\u001c;s_2dWM]#q_\u000eD\u0007bBA\u000b\u0001\u0001\u0006Ia^\u0001\u0011G>tGO]8mY\u0016\u0014X\t]8dQ\u0002B\u0011\"!\u0007\u0001\u0005\u0004%I!a\u0007\u0002\u0013A\f'\u000f^5uS>tWCAA\u000f!\u0011\ty\"a\u000b\u000e\u0005\u0005\u0005\"\u0002BA\u0012\u0003K\taaY8n[>t'bA\u0003\u0002()\u0019\u0011\u0011\u0006\b\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\ti#!\t\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"A\u0011\u0011\u0007\u0001!\u0002\u0013\ti\"\u0001\u0006qCJ$\u0018\u000e^5p]\u0002B\u0011\"!\u000e\u0001\u0005\u0004%I!a\u000e\u0002\u0015A\f'\u000f^5uS>t7/\u0006\u0002\u0002:A1\u00111HA\u001f\u0003;i\u0011\u0001W\u0005\u0004\u0003\u007fA&aA*fc\"A\u00111\t\u0001!\u0002\u0013\tI$A\u0006qCJ$\u0018\u000e^5p]N\u0004\u0003\"CA$\u0001\t\u0007I\u0011BA%\u0003\u001d\u0011X\r\u001d7jG\u0006,\u0012\u0001\u0018\u0005\b\u0003\u001b\u0002\u0001\u0015!\u0003]\u0003!\u0011X\r\u001d7jG\u0006\u0004\u0003\"CA)\u0001\t\u0007I\u0011BA*\u0003!\u0011X\r\u001d7jG\u0006\u001cXCAA+!\u0015\tY$!\u0010]\u0011!\tI\u0006\u0001Q\u0001\n\u0005U\u0013!\u0003:fa2L7-Y:!\u0011\u001d\ti\u0006\u0001C\u0001\u0003?\nQa]3u+B$\u0012\u0001\t\u0015\u0005\u00037\n\u0019\u0007\u0005\u0003\u0002f\u0005%TBAA4\u0015\tYa\"\u0003\u0003\u0002l\u0005\u001d$A\u0002\"fM>\u0014X\rC\u0004\u0002p\u0001!\t!a\u0018\u0002YQ,7\u000f\u001e(p]\u0016D\u0018n\u001d;f]R\u0014V\r\u001d7jG\u0006$vNT3x%\u0016\u0004H.[2b)J\fgn]5uS>t\u0007\u0006BA7\u0003g\u0002B!!\u001a\u0002v%!\u0011qOA4\u0005\u0011!Vm\u001d;\t\u000f\u0005m\u0004\u0001\"\u0001\u0002`\u00051D/Z:u\u0013:4\u0018\r\\5e\u001d>tW\r_5ti\u0016tGOU3qY&\u001c\u0017\rV8P]2Lg.\u001a*fa2L7-\u0019+sC:\u001c\u0018\u000e^5p]\"\"\u0011\u0011PA:\u0011\u001d\t\t\t\u0001C\u0001\u0003?\nq\u0007^3ti&sg/\u00197jI:{g.\u001a=jgR,g\u000e\u001e*fa2L7-\u0019+p\u001f\u001a4G.\u001b8f%\u0016\u0004H.[2b)J\fgn]5uS>t\u0007\u0006BA@\u0003gBq!a\"\u0001\t\u0003\ty&A uKN$\u0018J\u001c<bY&$gj\u001c8fq&\u001cH/\u001a8u%\u0016\u0004H.[2b)>\u0014V\r\u001d7jG\u0006$U\r\\3uS>t7\u000b^1si\u0016$GK]1og&$\u0018n\u001c8)\t\u0005\u0015\u00151\u000f\u0005\b\u0003\u001b\u0003A\u0011AA0\u0003\t#Xm\u001d;J]Z\fG.\u001b3O_:,\u00070[:uK:$(+\u001a9mS\u000e\fGk\u001c*fa2L7-\u0019#fY\u0016$\u0018n\u001c8J]\u0016d\u0017nZ5cY\u0016$&/\u00198tSRLwN\u001c\u0015\u0005\u0003\u0017\u000b\u0019\bC\u0004\u0002\u0014\u0002!\t!a\u0018\u0002\u0005R,7\u000f^%om\u0006d\u0017\u000e\u001a(p]\u0016D\u0018n\u001d;f]R\u0014V\r\u001d7jG\u0006$vNU3qY&\u001c\u0017\rR3mKRLwN\\*vG\u000e,7o\u001d4vYR\u0013\u0018M\\:ji&|g\u000e\u000b\u0003\u0002\u0012\u0006M\u0004bBAM\u0001\u0011\u0005\u0011qL\u00014i\u0016\u001cH/\u00138wC2LGMT3x%\u0016\u0004H.[2b)>tuN\\3ySN$XM\u001c;SKBd\u0017nY1Ue\u0006t7/\u001b;j_:DC!a&\u0002t!9\u0011q\u0014\u0001\u0005\u0002\u0005}\u0013a\n;fgRtUm\u001e*fa2L7-\u0019+p\u001f:d\u0017N\\3SKBd\u0017nY1Ue\u0006t7/\u001b;j_:DC!!(\u0002t!9\u0011Q\u0015\u0001\u0005\u0002\u0005}\u0013\u0001\u000b;fgRtUm\u001e*fa2L7-\u0019+p\u001f\u001a4G.\u001b8f%\u0016\u0004H.[2b)J\fgn]5uS>t\u0007\u0006BAR\u0003gBq!a+\u0001\t\u0003\ty&A\u001cuKN$\u0018J\u001c<bY&$g*Z<SKBd\u0017nY1U_J+\u0007\u000f\\5dC\u0012+G.\u001a;j_:\u001cF/\u0019:uK\u0012$&/\u00198tSRLwN\u001c\u0015\u0005\u0003S\u000b\u0019\bC\u0004\u00022\u0002!\t!a\u0018\u0002uQ,7\u000f^%om\u0006d\u0017\u000e\u001a(foJ+\u0007\u000f\\5dCR{'+\u001a9mS\u000e\fG)\u001a7fi&|g.\u00138fY&<\u0017N\u00197f)J\fgn]5uS>t\u0007\u0006BAX\u0003gBq!a.\u0001\t\u0003\ty&\u0001\u001euKN$\u0018J\u001c<bY&$g*Z<SKBd\u0017nY1U_J+\u0007\u000f\\5dC\u0012+G.\u001a;j_:\u001cVoY2fgN4W\u000f\u001c+sC:\u001c\u0018\u000e^5p]\"\"\u0011QWA:\u0011\u001d\ti\f\u0001C\u0001\u0003?\na\u0007^3ti&sg/\u00197jI>sG.\u001b8f%\u0016\u0004H.[2b)>tuN\\3ySN$XM\u001c;SKBd\u0017nY1Ue\u0006t7/\u001b;j_:DC!a/\u0002t!9\u00111\u0019\u0001\u0005\u0002\u0005}\u0013A\f;fgRLeN^1mS\u0012|e\u000e\\5oKJ+\u0007\u000f\\5dCR{g*Z<SKBd\u0017nY1Ue\u0006t7/\u001b;j_:DC!!1\u0002t!9\u0011\u0011\u001a\u0001\u0005\u0002\u0005}\u0013A\u000b;fgR|e\u000e\\5oKJ+\u0007\u000f\\5dCR{wJ\u001c7j]\u0016\u0014V\r\u001d7jG\u0006$&/\u00198tSRLwN\u001c\u0015\u0005\u0003\u000f\f\u0019\bC\u0004\u0002P\u0002!\t!a\u0018\u0002WQ,7\u000f^(oY&tWMU3qY&\u001c\u0017\rV8PM\u001ad\u0017N\\3SKBd\u0017nY1Ue\u0006t7/\u001b;j_:DC!!4\u0002t!9\u0011Q\u001b\u0001\u0005\u0002\u0005}\u0013A\u000f;fgRLeN^1mS\u0012|e\u000e\\5oKJ+\u0007\u000f\\5dCR{'+\u001a9mS\u000e\fG)\u001a7fi&|gn\u0015;beR,G\r\u0016:b]NLG/[8oQ\u0011\t\u0019.a\u001d\t\u000f\u0005m\u0007\u0001\"\u0001\u0002`\u0005iD/Z:u\u0013:4\u0018\r\\5e\u001f:d\u0017N\\3SKBd\u0017nY1U_J+\u0007\u000f\\5dC\u0012+G.\u001a;j_:Le.\u001a7jO&\u0014G.\u001a+sC:\u001c\u0018\u000e^5p]\"\"\u0011\u0011\\A:\u0011\u001d\t\t\u000f\u0001C\u0001\u0003?\nQ\b^3ti&sg/\u00197jI>sG.\u001b8f%\u0016\u0004H.[2b)>\u0014V\r\u001d7jG\u0006$U\r\\3uS>t7+^2dKN\u001ch-\u001e7Ue\u0006t7/\u001b;j_:DC!a8\u0002t!9\u0011q\u001d\u0001\u0005\u0002\u0005}\u0013a\u000e;fgRLeN^1mS\u0012|eM\u001a7j]\u0016\u0014V\r\u001d7jG\u0006$vNT8oKbL7\u000f^3oiJ+\u0007\u000f\\5dCR\u0013\u0018M\\:ji&|g\u000e\u000b\u0003\u0002f\u0006M\u0004bBAw\u0001\u0011\u0005\u0011qL\u00010i\u0016\u001cH/\u00138wC2LGm\u00144gY&tWMU3qY&\u001c\u0017\rV8OK^\u0014V\r\u001d7jG\u0006$&/\u00198tSRLwN\u001c\u0015\u0005\u0003W\f\u0019\bC\u0004\u0002t\u0002!\t!a\u0018\u0002WQ,7\u000f^(gM2Lg.\u001a*fa2L7-\u0019+p\u001f:d\u0017N\\3SKBd\u0017nY1Ue\u0006t7/\u001b;j_:DC!!=\u0002t!9\u0011\u0011 \u0001\u0005\u0002\u0005}\u0013\u0001\u000e;fgR|eM\u001a7j]\u0016\u0014V\r\u001d7jG\u0006$vNU3qY&\u001c\u0017\rR3mKRLwN\\*uCJ$X\r\u001a+sC:\u001c\u0018\u000e^5p]\"\"\u0011q_A:\u0011\u001d\ty\u0010\u0001C\u0001\u0003?\na\b^3ti&sg/\u00197jI>3g\r\\5oKJ+\u0007\u000f\\5dCR{'+\u001a9mS\u000e\fG)\u001a7fi&|g.\u00138fY&<\u0017N\u00197f)J\fgn]5uS>t\u0007\u0006BA\u007f\u0003gBqA!\u0002\u0001\t\u0003\ty&\u0001 uKN$\u0018J\u001c<bY&$wJ\u001a4mS:,'+\u001a9mS\u000e\fGk\u001c*fa2L7-\u0019#fY\u0016$\u0018n\u001c8Tk\u000e\u001cWm]:gk2$&/\u00198tSRLwN\u001c\u0015\u0005\u0005\u0007\t\u0019\bC\u0004\u0003\f\u0001!\t!a\u0018\u0002\u007fQ,7\u000f^%om\u0006d\u0017\u000e\u001a*fa2L7-\u0019#fY\u0016$\u0018n\u001c8Ti\u0006\u0014H/\u001a3U_:{g.\u001a=jgR,g\u000e\u001e*fa2L7-\u0019+sC:\u001c\u0018\u000e^5p]\"\"!\u0011BA:\u0011\u001d\u0011\t\u0002\u0001C\u0001\u0003?\nq\u0007^3ti&sg/\u00197jIJ+\u0007\u000f\\5dC\u0012+G.\u001a;j_:\u001cF/\u0019:uK\u0012$vNT3x%\u0016\u0004H.[2b)J\fgn]5uS>t\u0007\u0006\u0002B\b\u0003gBqAa\u0006\u0001\t\u0003\ty&\u0001\u001euKN$\u0018J\u001c<bY&$'+\u001a9mS\u000e\fG)\u001a7fi&|gn\u0015;beR,G\rV8P]2Lg.\u001a*fa2L7-\u0019+sC:\u001c\u0018\u000e^5p]\"\"!QCA:\u0011\u001d\u0011i\u0002\u0001C\u0001\u0003?\n1\b^3ti&sg/\u00197jIJ+\u0007\u000f\\5dC\u0012+G.\u001a;j_:\u001cF/\u0019:uK\u0012$vn\u00144gY&tWMU3qY&\u001c\u0017\r\u0016:b]NLG/[8oQ\u0011\u0011Y\"a\u001d\t\u000f\t\r\u0002\u0001\"\u0001\u0002`\u0005yD/Z:u%\u0016\u0004H.[2b\t\u0016dW\r^5p]N#\u0018M\u001d;fIR{'+\u001a9mS\u000e\fG)\u001a7fi&|g.\u00138fY&<\u0017N\u00197f)J\fgn]5uS>t\u0007\u0006\u0002B\u0011\u0003gBqA!\u000b\u0001\t\u0003\ty&A uKN$(+\u001a9mS\u000e\fG)\u001a7fi&|gn\u0015;beR,G\rV8SKBd\u0017nY1EK2,G/[8o'V\u001c7-Z:tMVdGK]1og&$\u0018n\u001c8)\t\t\u001d\u00121\u000f\u0005\b\u0005_\u0001A\u0011AA0\u0003m\"Xm\u001d;SKBd\u0017nY1EK2,G/[8o'V\u001c7-Z:tMVdGk\u001c(p]\u0016D\u0018n\u001d;f]R\u0014V\r\u001d7jG\u0006$&/\u00198tSRLwN\u001c\u0015\u0005\u0005[\t\u0019\bC\u0004\u00036\u0001!\t!a\u0018\u0002uQ,7\u000f^%om\u0006d\u0017\u000e\u001a*fa2L7-\u0019#fY\u0016$\u0018n\u001c8Tk\u000e\u001cWm]:gk2$vNT3x%\u0016\u0004H.[2b)J\fgn]5uS>t\u0007\u0006\u0002B\u001a\u0003gBqAa\u000f\u0001\t\u0003\ty&A\u001fuKN$\u0018J\u001c<bY&$'+\u001a9mS\u000e\fG)\u001a7fi&|gnU;dG\u0016\u001c8OZ;m)>|e\u000e\\5oKJ+\u0007\u000f\\5dCR\u0013\u0018M\\:ji&|g\u000e\u000b\u0003\u0003:\u0005M\u0004b\u0002B!\u0001\u0011\u0005\u0011qL\u0001?i\u0016\u001cH/\u00138wC2LGMU3qY&\u001c\u0017\rR3mKRLwN\\*vG\u000e,7o\u001d4vYR{wJ\u001a4mS:,'+\u001a9mS\u000e\fGK]1og&$\u0018n\u001c8)\t\t}\u00121\u000f\u0005\b\u0005\u000f\u0002A\u0011AA0\u0003\u0019#Xm\u001d;J]Z\fG.\u001b3SKBd\u0017nY1EK2,G/[8o'V\u001c7-Z:tMVdGk\u001c*fa2L7-\u0019#fY\u0016$\u0018n\u001c8Ti\u0006\u0014H/\u001a3Ue\u0006t7/\u001b;j_:DCA!\u0012\u0002t!9!Q\n\u0001\u0005\u0002\u0005}\u0013!\u0013;fgRLeN^1mS\u0012\u0014V\r\u001d7jG\u0006$U\r\\3uS>t7+^2dKN\u001ch-\u001e7U_J+\u0007\u000f\\5dC\u0012+G.\u001a;j_:Le.\u001a7jO&\u0014G.\u001a+sC:\u001c\u0018\u000e^5p]\"\"!1JA:\u0011\u001d\u0011\u0019\u0006\u0001C\u0001\u0003?\n!\t^3ti&sg/\u00197jIJ+\u0007\u000f\\5dC\u0012+G.\u001a;j_:Le.\u001a7jO&\u0014G.\u001a+p\u001d>tW\r_5ti\u0016tGOU3qY&\u001c\u0017\r\u0016:b]NLG/[8oQ\u0011\u0011\t&a\u001d\t\u000f\te\u0003\u0001\"\u0001\u0002`\u0005QD/Z:u\u0013:4\u0018\r\\5e%\u0016\u0004H.[2b\t\u0016dW\r^5p]&sW\r\\5hS\ndW\rV8OK^\u0014V\r\u001d7jG\u0006$&/\u00198tSRLwN\u001c\u0015\u0005\u0005/\n\u0019\bC\u0004\u0003`\u0001!\t!a\u0018\u0002mQ,7\u000f\u001e*fa2L7-\u0019#fY\u0016$\u0018n\u001c8J]\u0016d\u0017nZ5cY\u0016$vn\u00148mS:,'+\u001a9mS\u000e\fGK]1og&$\u0018n\u001c8)\t\tu\u00131\u000f\u0005\b\u0005K\u0002A\u0011AA0\u0003\u0019#Xm\u001d;J]Z\fG.\u001b3SKBd\u0017nY1EK2,G/[8o\u0013:,G.[4jE2,Gk\u001c*fa2L7-\u0019#fY\u0016$\u0018n\u001c8Ti\u0006\u0014H/\u001a3Ue\u0006t7/\u001b;j_:DCAa\u0019\u0002t!9!1\u000e\u0001\u0005\u0002\u0005}\u0013!\u0013;fgRLeN^1mS\u0012\u0014V\r\u001d7jG\u0006$U\r\\3uS>t\u0017J\\3mS\u001eL'\r\\3U_J+\u0007\u000f\\5dC\u0012+G.\u001a;j_:\u001cVoY2fgN4W\u000f\u001c+sC:\u001c\u0018\u000e^5p]\"\"!\u0011NA:\u0011\u001d\u0011\t\b\u0001C\u0005\u0005g\nQ\u0003^3ti&sg/\u00197jIR\u0013\u0018M\\:ji&|g\u000eF\u0003!\u0005k\u0012I\bC\u0004\u0003x\t=\u0004\u0019A0\u0002\u0013\u0019\u0014x.\\*uCR,\u0007b\u0002B>\u0005_\u0002\raX\u0001\bi>\u001cF/\u0019;f\u0001")
public class ReplicaStateMachineTest
extends JUnitSuite {
    private ControllerContext controllerContext = null;
    private KafkaZkClient mockZkClient = null;
    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch = null;
    private TopicDeletionManager mockTopicDeletionManager = null;
    private Map<PartitionAndReplica, ReplicaState> replicaState = null;
    private ReplicaStateMachine replicaStateMachine = null;
    private final int brokerId;
    private final KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
    private final int controllerEpoch;
    private final TopicPartition partition = new TopicPartition("t", 0);
    private final Seq<TopicPartition> partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition()}));
    private final PartitionAndReplica replica = new PartitionAndReplica(this.partition(), this.brokerId());
    private final Seq<PartitionAndReplica> replicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PartitionAndReplica[]{this.replica()}));

    private ControllerContext controllerContext() {
        return this.controllerContext;
    }

    private void controllerContext_$eq(ControllerContext x$1) {
        this.controllerContext = x$1;
    }

    private KafkaZkClient mockZkClient() {
        return this.mockZkClient;
    }

    private void mockZkClient_$eq(KafkaZkClient x$1) {
        this.mockZkClient = x$1;
    }

    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch() {
        return this.mockControllerBrokerRequestBatch;
    }

    private void mockControllerBrokerRequestBatch_$eq(ControllerBrokerRequestBatch x$1) {
        this.mockControllerBrokerRequestBatch = x$1;
    }

    private TopicDeletionManager mockTopicDeletionManager() {
        return this.mockTopicDeletionManager;
    }

    private void mockTopicDeletionManager_$eq(TopicDeletionManager x$1) {
        this.mockTopicDeletionManager = x$1;
    }

    private Map<PartitionAndReplica, ReplicaState> replicaState() {
        return this.replicaState;
    }

    private void replicaState_$eq(Map<PartitionAndReplica, ReplicaState> x$1) {
        this.replicaState = x$1;
    }

    private ReplicaStateMachine replicaStateMachine() {
        return this.replicaStateMachine;
    }

    private void replicaStateMachine_$eq(ReplicaStateMachine x$1) {
        this.replicaStateMachine = x$1;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    private TopicPartition partition() {
        return this.partition;
    }

    private Seq<TopicPartition> partitions() {
        return this.partitions;
    }

    private PartitionAndReplica replica() {
        return this.replica;
    }

    private Seq<PartitionAndReplica> replicas() {
        return this.replicas;
    }

    @Before
    public void setUp() {
        this.controllerContext_$eq(new ControllerContext());
        this.controllerContext().epoch_$eq(this.controllerEpoch());
        this.mockZkClient_$eq((KafkaZkClient)EasyMock.createMock(KafkaZkClient.class));
        this.mockControllerBrokerRequestBatch_$eq((ControllerBrokerRequestBatch)EasyMock.createMock(ControllerBrokerRequestBatch.class));
        this.mockTopicDeletionManager_$eq((TopicDeletionManager)EasyMock.createMock(TopicDeletionManager.class));
        this.replicaState_$eq((Map<PartitionAndReplica, ReplicaState>)Map$.MODULE$.empty());
        this.replicaStateMachine_$eq(new ReplicaStateMachine(this.config(), new StateChangeLogger(this.brokerId(), true, (Option)None$.MODULE$), this.controllerContext(), this.mockTopicDeletionManager(), this.mockZkClient(), this.replicaState(), this.mockControllerBrokerRequestBatch()));
    }

    @Test
    public void testNonexistentReplicaToNewReplicaTransition() {
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        NewReplica$ x$2 = NewReplica$.MODULE$;
        Callbacks x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        Assert.assertEquals((Object)NewReplica$.MODULE$, (Object)this.replicaState().apply((Object)this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToOnlineReplicaTransition() {
        ReplicaStateMachine qual$2 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$4 = this.replicas();
        OnlineReplica$ x$5 = OnlineReplica$.MODULE$;
        Callbacks x$6 = qual$2.handleStateChanges$default$3();
        qual$2.handleStateChanges(x$4, (ReplicaState)x$5, x$6);
        Assert.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState().apply((Object)this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToOfflineReplicaTransition() {
        ReplicaStateMachine qual$3 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$7 = this.replicas();
        OfflineReplica$ x$8 = OfflineReplica$.MODULE$;
        Callbacks x$9 = qual$3.handleStateChanges$default$3();
        qual$3.handleStateChanges(x$7, (ReplicaState)x$8, x$9);
        Assert.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState().apply((Object)this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToReplicaDeletionStartedTransition() {
        ReplicaStateMachine qual$4 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$10 = this.replicas();
        ReplicaDeletionStarted$ x$11 = ReplicaDeletionStarted$.MODULE$;
        Callbacks x$12 = qual$4.handleStateChanges$default$3();
        qual$4.handleStateChanges(x$10, (ReplicaState)x$11, x$12);
        Assert.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState().apply((Object)this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToReplicaDeletionIneligibleTransition() {
        ReplicaStateMachine qual$5 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$13 = this.replicas();
        ReplicaDeletionIneligible$ x$14 = ReplicaDeletionIneligible$.MODULE$;
        Callbacks x$15 = qual$5.handleStateChanges$default$3();
        qual$5.handleStateChanges(x$13, (ReplicaState)x$14, x$15);
        Assert.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState().apply((Object)this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToReplicaDeletionSuccessfulTransition() {
        ReplicaStateMachine qual$6 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$16 = this.replicas();
        ReplicaDeletionSuccessful$ x$17 = ReplicaDeletionSuccessful$.MODULE$;
        Callbacks x$18 = qual$6.handleStateChanges$default$3();
        qual$6.handleStateChanges(x$16, (ReplicaState)x$17, x$18);
        Assert.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState().apply((Object)this.replica()));
    }

    @Test
    public void testInvalidNewReplicaToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)NewReplica$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testNewReplicaToOnlineReplicaTransition() {
        this.replicaState().put((Object)this.replica(), (Object)NewReplica$.MODULE$);
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        ReplicaStateMachine qual$7 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$19 = this.replicas();
        OnlineReplica$ x$20 = OnlineReplica$.MODULE$;
        Callbacks x$21 = qual$7.handleStateChanges$default$3();
        qual$7.handleStateChanges(x$19, (ReplicaState)x$20, x$21);
        Assert.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState().apply((Object)this.replica()));
    }

    @Test
    public void testNewReplicaToOfflineReplicaTransition() {
        this.replicaState().put((Object)this.replica(), (Object)NewReplica$.MODULE$);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().addStopReplicaRequestForBrokers((Seq)EasyMock.eq((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), (TopicPartition)EasyMock.eq((Object)this.partition()), EasyMock.eq((boolean)false), (Function2)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockControllerBrokerRequestBatch()});
        ReplicaStateMachine qual$8 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$22 = this.replicas();
        OfflineReplica$ x$23 = OfflineReplica$.MODULE$;
        Callbacks x$24 = qual$8.handleStateChanges$default$3();
        qual$8.handleStateChanges(x$22, (ReplicaState)x$23, x$24);
        EasyMock.verify((Object[])new Object[]{this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OfflineReplica$.MODULE$, (Object)this.replicaState().apply((Object)this.replica()));
    }

    @Test
    public void testInvalidNewReplicaToReplicaDeletionStartedTransition() {
        this.testInvalidTransition((ReplicaState)NewReplica$.MODULE$, (ReplicaState)ReplicaDeletionStarted$.MODULE$);
    }

    @Test
    public void testInvalidNewReplicaToReplicaDeletionIneligibleTransition() {
        this.testInvalidTransition((ReplicaState)NewReplica$.MODULE$, (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
    }

    @Test
    public void testInvalidNewReplicaToReplicaDeletionSuccessfulTransition() {
        this.testInvalidTransition((ReplicaState)NewReplica$.MODULE$, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
    }

    @Test
    public void testInvalidOnlineReplicaToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testInvalidOnlineReplicaToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    @Test
    public void testOnlineReplicaToOnlineReplicaTransition() {
        this.replicaState().put((Object)this.replica(), (Object)OnlineReplica$.MODULE$);
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        this.controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), leaderIsrAndControllerEpoch, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        ReplicaStateMachine qual$9 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$25 = this.replicas();
        OnlineReplica$ x$26 = OnlineReplica$.MODULE$;
        Callbacks x$27 = qual$9.handleStateChanges$default$3();
        qual$9.handleStateChanges(x$25, (ReplicaState)x$26, x$27);
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState().apply((Object)this.replica()));
    }

    @Test
    public void testOnlineReplicaToOfflineReplicaTransition() {
        int otherBrokerId = this.brokerId() + 1;
        List replicaIds = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId}));
        this.replicaState().put((Object)this.replica(), (Object)OnlineReplica$.MODULE$);
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)replicaIds);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), replicaIds);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().addStopReplicaRequestForBrokers((Seq)EasyMock.eq((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), (TopicPartition)EasyMock.eq((Object)this.partition()), EasyMock.eq((boolean)false), (Function2)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        LeaderAndIsr adjustedLeaderAndIsr = leaderAndIsr.newLeaderAndIsr(LeaderAndIsr$.MODULE$.NoLeader(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})));
        LeaderAndIsr updatedLeaderAndIsr = adjustedLeaderAndIsr.withZkVersion(adjustedLeaderAndIsr.zkVersion() + 1);
        LeaderIsrAndControllerEpoch updatedLeaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch());
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GetDataResponse[]{new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L), GetDataResponse$.MODULE$.apply$default$7())})));
        EasyMock.expect((Object)this.mockZkClient().updateLeaderAndIsr((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)adjustedLeaderAndIsr)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).andReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)updatedLeaderAndIsr)})), (Seq)Seq$.MODULE$.empty(), Predef$.MODULE$.Map().empty()));
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.mockTopicDeletionManager().isTopicQueuedUpForDeletion(this.partition().topic()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})), this.partition(), updatedLeaderIsrAndControllerEpoch, (Seq)replicaIds, false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch(), this.mockTopicDeletionManager()});
        ReplicaStateMachine qual$10 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$28 = this.replicas();
        OfflineReplica$ x$29 = OfflineReplica$.MODULE$;
        Callbacks x$30 = qual$10.handleStateChanges$default$3();
        qual$10.handleStateChanges(x$28, (ReplicaState)x$29, x$30);
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch(), this.mockTopicDeletionManager()});
        Assert.assertEquals((Object)updatedLeaderIsrAndControllerEpoch, (Object)this.controllerContext().partitionLeadershipInfo().apply((Object)this.partition()));
        Assert.assertEquals((Object)OfflineReplica$.MODULE$, (Object)this.replicaState().apply((Object)this.replica()));
    }

    @Test
    public void testInvalidOnlineReplicaToReplicaDeletionStartedTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)ReplicaDeletionStarted$.MODULE$);
    }

    @Test
    public void testInvalidOnlineReplicaToReplicaDeletionIneligibleTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
    }

    @Test
    public void testInvalidOnlineReplicaToReplicaDeletionSuccessfulTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
    }

    @Test
    public void testInvalidOfflineReplicaToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)OfflineReplica$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testInvalidOfflineReplicaToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)OfflineReplica$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    @Test
    public void testOfflineReplicaToOnlineReplicaTransition() {
        this.replicaState().put((Object)this.replica(), (Object)OfflineReplica$.MODULE$);
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        this.controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), leaderIsrAndControllerEpoch, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        ReplicaStateMachine qual$11 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$31 = this.replicas();
        OnlineReplica$ x$32 = OnlineReplica$.MODULE$;
        Callbacks x$33 = qual$11.handleStateChanges$default$3();
        qual$11.handleStateChanges(x$31, (ReplicaState)x$32, x$33);
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState().apply((Object)this.replica()));
    }

    @Test
    public void testOfflineReplicaToReplicaDeletionStartedTransition() {
        Callbacks callbacks = new Callbacks(Callbacks$.MODULE$.$lessinit$greater$default$1());
        this.replicaState().put((Object)this.replica(), (Object)OfflineReplica$.MODULE$);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), true, callbacks.stopReplicaResponseCallback());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)ReplicaDeletionStarted$.MODULE$, callbacks);
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)ReplicaDeletionStarted$.MODULE$, (Object)this.replicaState().apply((Object)this.replica()));
    }

    @Test
    public void testInvalidOfflineReplicaToReplicaDeletionIneligibleTransition() {
        this.testInvalidTransition((ReplicaState)OfflineReplica$.MODULE$, (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
    }

    @Test
    public void testInvalidOfflineReplicaToReplicaDeletionSuccessfulTransition() {
        this.testInvalidTransition((ReplicaState)OfflineReplica$.MODULE$, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionStartedToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionStarted$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionStartedToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionStarted$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionStartedToOnlineReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionStarted$.MODULE$, (ReplicaState)OnlineReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionStartedToOfflineReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionStarted$.MODULE$, (ReplicaState)OfflineReplica$.MODULE$);
    }

    @Test
    public void testReplicaDeletionStartedToReplicaDeletionIneligibleTransition() {
        this.replicaState().put((Object)this.replica(), (Object)ReplicaDeletionStarted$.MODULE$);
        ReplicaStateMachine qual$12 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$34 = this.replicas();
        ReplicaDeletionIneligible$ x$35 = ReplicaDeletionIneligible$.MODULE$;
        Callbacks x$36 = qual$12.handleStateChanges$default$3();
        qual$12.handleStateChanges(x$34, (ReplicaState)x$35, x$36);
        Assert.assertEquals((Object)ReplicaDeletionIneligible$.MODULE$, (Object)this.replicaState().apply((Object)this.replica()));
    }

    @Test
    public void testReplicaDeletionStartedToReplicaDeletionSuccessfulTransition() {
        this.replicaState().put((Object)this.replica(), (Object)ReplicaDeletionStarted$.MODULE$);
        ReplicaStateMachine qual$13 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$37 = this.replicas();
        ReplicaDeletionSuccessful$ x$38 = ReplicaDeletionSuccessful$.MODULE$;
        Callbacks x$39 = qual$13.handleStateChanges$default$3();
        qual$13.handleStateChanges(x$37, (ReplicaState)x$38, x$39);
        Assert.assertEquals((Object)ReplicaDeletionSuccessful$.MODULE$, (Object)this.replicaState().apply((Object)this.replica()));
    }

    @Test
    public void testReplicaDeletionSuccessfulToNonexistentReplicaTransition() {
        this.replicaState().put((Object)this.replica(), (Object)ReplicaDeletionSuccessful$.MODULE$);
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        ReplicaStateMachine qual$14 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$40 = this.replicas();
        NonExistentReplica$ x$41 = NonExistentReplica$.MODULE$;
        Callbacks x$42 = qual$14.handleStateChanges$default$3();
        qual$14.handleStateChanges(x$40, (ReplicaState)x$41, x$42);
        Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)this.controllerContext().partitionReplicaAssignment(this.partition()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.replicaState().get((Object)this.replica()));
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToOnlineReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)OnlineReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToOfflineReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)OfflineReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToReplicaDeletionStartedTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)ReplicaDeletionStarted$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToReplicaDeletionIneligibleTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionIneligibleToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionIneligible$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionIneligibleToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionIneligible$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    @Test
    public void testReplicaDeletionIneligibleToOnlineReplicaTransition() {
        this.replicaState().put((Object)this.replica(), (Object)ReplicaDeletionIneligible$.MODULE$);
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        this.controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), leaderIsrAndControllerEpoch, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        ReplicaStateMachine qual$15 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$43 = this.replicas();
        OnlineReplica$ x$44 = OnlineReplica$.MODULE$;
        Callbacks x$45 = qual$15.handleStateChanges$default$3();
        qual$15.handleStateChanges(x$43, (ReplicaState)x$44, x$45);
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState().apply((Object)this.replica()));
    }

    @Test
    public void testInvalidReplicaDeletionIneligibleToReplicaDeletionStartedTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionIneligible$.MODULE$, (ReplicaState)ReplicaDeletionStarted$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionIneligibleToReplicaDeletionSuccessfulTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionIneligible$.MODULE$, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
    }

    private void testInvalidTransition(ReplicaState fromState, ReplicaState toState) {
        this.replicaState().put((Object)this.replica(), (Object)fromState);
        ReplicaStateMachine qual$16 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$46 = this.replicas();
        ReplicaState x$47 = toState;
        Callbacks x$48 = qual$16.handleStateChanges$default$3();
        qual$16.handleStateChanges(x$46, x$47, x$48);
        Assert.assertEquals((Object)fromState, (Object)this.replicaState().apply((Object)this.replica()));
    }

    public ReplicaStateMachineTest() {
        this.brokerId = 5;
        this.controllerEpoch = 50;
    }
}

