/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.KAFKA_0_10_2_IV0$;
import kafka.api.Request$;
import kafka.cluster.Partition;
import kafka.cluster.Partition$;
import kafka.cluster.PartitionTest$;
import kafka.cluster.PartitionTest$$anonfun$5$;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.common.UnexpectedAppendOffsetException;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.TimestampOffset;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.DelayedOperationKey;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.LogReadResult$;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.TopicPartitionOperationKey;
import kafka.utils.CoreUtils$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ReplicaNotAvailableException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\t\u0005e\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0002U1si&$\u0018n\u001c8UKN$(BA\u0002\u0005\u0003\u001d\u0019G.^:uKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAq\u0001\u0006\u0001C\u0002\u0013\u0005Q#\u0001\u0005ce>\\WM]%e+\u00051\u0002CA\u0005\u0018\u0013\tA\"BA\u0002J]RDaA\u0007\u0001!\u0002\u00131\u0012!\u00032s_.,'/\u00133!\u0011\u001da\u0002A1A\u0005\u0002u\ta\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.F\u0001\u001f!\tyr%D\u0001!\u0015\t\t#%\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\rR!\u0001J\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0013aA8sO&\u0011\u0001\u0006\t\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019Q\u0003\u0001)A\u0005=\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0005C\u0004-\u0001\t\u0007I\u0011A\u0017\u0002\tQLW.Z\u000b\u0002]A\u0011qFM\u0007\u0002a)\u0011\u0011\u0007B\u0001\u0006kRLGn]\u0005\u0003gA\u0012\u0001\"T8dWRKW.\u001a\u0005\u0007k\u0001\u0001\u000b\u0011\u0002\u0018\u0002\u000bQLW.\u001a\u0011\t\u000f]\u0002!\u0019!C\u0001q\u0005\u0001\"M]8lKJ$v\u000e]5d'R\fGo]\u000b\u0002sA\u0011!(P\u0007\u0002w)\u0011A\bB\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005yZ$\u0001\u0005\"s_.,'\u000fV8qS\u000e\u001cF/\u0019;t\u0011\u0019\u0001\u0005\u0001)A\u0005s\u0005\t\"M]8lKJ$v\u000e]5d'R\fGo\u001d\u0011\t\u000f\t\u0003!\u0019!C\u0001\u0007\u00069Q.\u001a;sS\u000e\u001cX#\u0001#\u0011\u0005\u0015;U\"\u0001$\u000b\u0005\t\u0003\u0013B\u0001%G\u0005\u001diU\r\u001e:jGNDaA\u0013\u0001!\u0002\u0013!\u0015\u0001C7fiJL7m\u001d\u0011\t\u00131\u0003\u0001\u0019!a\u0001\n\u0003i\u0015A\u0002;na\u0012K'/F\u0001O!\tyE+D\u0001Q\u0015\t\t&+\u0001\u0002j_*\t1+\u0001\u0003kCZ\f\u0017BA+Q\u0005\u00111\u0015\u000e\\3\t\u0013]\u0003\u0001\u0019!a\u0001\n\u0003A\u0016A\u0003;na\u0012K'o\u0018\u0013fcR\u0011\u0011\f\u0018\t\u0003\u0013iK!a\u0017\u0006\u0003\tUs\u0017\u000e\u001e\u0005\b;Z\u000b\t\u00111\u0001O\u0003\rAH%\r\u0005\u0007?\u0002\u0001\u000b\u0015\u0002(\u0002\u000fQl\u0007\u000fR5sA!I\u0011\r\u0001a\u0001\u0002\u0004%\t!T\u0001\bY><G)\u001b:2\u0011%\u0019\u0007\u00011AA\u0002\u0013\u0005A-A\u0006m_\u001e$\u0015N]\u0019`I\u0015\fHCA-f\u0011\u001di&-!AA\u00029Caa\u001a\u0001!B\u0013q\u0015\u0001\u00037pO\u0012K'/\r\u0011\t\u0013%\u0004\u0001\u0019!a\u0001\n\u0003i\u0015a\u00027pO\u0012K'O\r\u0005\nW\u0002\u0001\r\u00111A\u0005\u00021\f1\u0002\\8h\t&\u0014(g\u0018\u0013fcR\u0011\u0011,\u001c\u0005\b;*\f\t\u00111\u0001O\u0011\u0019y\u0007\u0001)Q\u0005\u001d\u0006AAn\\4ESJ\u0014\u0004\u0005C\u0005r\u0001\u0001\u0007\t\u0019!C\u0001e\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014X#A:\u0011\u0005i\"\u0018BA;<\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJD\u0011b\u001e\u0001A\u0002\u0003\u0007I\u0011\u0001=\u0002%I,\u0007\u000f\\5dC6\u000bg.Y4fe~#S-\u001d\u000b\u00033fDq!\u0018<\u0002\u0002\u0003\u00071\u000f\u0003\u0004|\u0001\u0001\u0006Ka]\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA!IQ\u0010\u0001a\u0001\u0002\u0004%\tA`\u0001\u000bY><W*\u00198bO\u0016\u0014X#A@\u0011\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u0002\u0005\u0003\rawnZ\u0005\u0005\u0003\u0013\t\u0019A\u0001\u0006M_\u001el\u0015M\\1hKJD1\"!\u0004\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0010\u0005qAn\\4NC:\fw-\u001a:`I\u0015\fHcA-\u0002\u0012!AQ,a\u0003\u0002\u0002\u0003\u0007q\u0010C\u0004\u0002\u0016\u0001\u0001\u000b\u0015B@\u0002\u00171|w-T1oC\u001e,'\u000f\t\u0005\f\u00033\u0001\u0001\u0019!a\u0001\n\u0003\tY\"A\u0005m_\u001e\u001cuN\u001c4jOV\u0011\u0011Q\u0004\t\u0005\u0003\u0003\ty\"\u0003\u0003\u0002\"\u0005\r!!\u0003'pO\u000e{gNZ5h\u0011-\t)\u0003\u0001a\u0001\u0002\u0004%\t!a\n\u0002\u001b1|wmQ8oM&<w\fJ3r)\rI\u0016\u0011\u0006\u0005\n;\u0006\r\u0012\u0011!a\u0001\u0003;A\u0001\"!\f\u0001A\u0003&\u0011QD\u0001\u000bY><7i\u001c8gS\u001e\u0004\u0003bBA\u0019\u0001\u0011\u0005\u00111G\u0001\u0006g\u0016$X\u000f\u001d\u000b\u00023\"\"\u0011qFA\u001c!\u0011\tI$a\u0010\u000e\u0005\u0005m\"bAA\u001fK\u0005)!.\u001e8ji&!\u0011\u0011IA\u001e\u0005\u0019\u0011UMZ8sK\"9\u0011Q\t\u0001\u0005\n\u0005\u001d\u0013aE2sK\u0006$X\rT8h!J|\u0007/\u001a:uS\u0016\u001cH\u0003BA%\u0003+\u0002B!a\u0013\u0002R5\u0011\u0011Q\n\u0006\u0004\u0003\u001f\u0012\u0016\u0001B;uS2LA!a\u0015\u0002N\tQ\u0001K]8qKJ$\u0018.Z:\t\u0011\u0005]\u00131\ta\u0001\u00033\n\u0011b\u001c<feJLG-Z:\u0011\u0011\u0005m\u0013\u0011MA4\u0003Or1!CA/\u0013\r\tyFC\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u0014Q\r\u0002\u0004\u001b\u0006\u0004(bAA0\u0015A!\u00111LA5\u0013\u0011\tY'!\u001a\u0003\rM#(/\u001b8h\u0011\u001d\ty\u0007\u0001C\u0001\u0003g\t\u0001\u0002^3be\u0012{wO\u001c\u0015\u0005\u0003[\n\u0019\b\u0005\u0003\u0002:\u0005U\u0014\u0002BA<\u0003w\u0011Q!\u00114uKJDq!a\u001f\u0001\t\u0003\t\u0019$A\u0010uKN$X*Y6f\u0019\u0016\fG-\u001a:Va\u0012\fG/Z:Fa>\u001c\u0007nQ1dQ\u0016DC!!\u001f\u0002\u0000A!\u0011\u0011HAA\u0013\u0011\t\u0019)a\u000f\u0003\tQ+7\u000f\u001e\u0005\b\u0003\u000f\u0003A\u0011AA\u001a\u0003I\"Xm\u001d;NC.,G*Z1eKJ$u.Z:O_R,\u0006\u000fZ1uK\u0016\u0003xn\u00195DC\u000eDWMR8s\u001f2$gi\u001c:nCR\u001c\b\u0006BAC\u0003\u007fBq!!$\u0001\t\u0003\t\u0019$\u0001\u0015uKN$X*Y=cKJ+\u0007\u000f\\1dK\u000e+(O]3oi^KG\u000f\u001b$viV\u0014XMU3qY&\u001c\u0017\r\u000b\u0003\u0002\f\u0006}\u0004bBAJ\u0001\u0011\u0005\u00111G\u00010i\u0016\u001cHOR3uG\"|eMZ:fiNs\u0017\r]:i_R,\u0005o\\2i-\u0006d\u0017\u000eZ1uS>tgi\u001c:MK\u0006$WM\u001d\u0015\u0005\u0003#\u000by\bC\u0004\u0002\u001a\u0002!\t!a\r\u0002cQ,7\u000f\u001e$fi\u000eDwJ\u001a4tKR\u001cf.\u00199tQ>$X\t]8dQZ\u000bG.\u001b3bi&|gNR8s\r>dGn\\<fe\"\"\u0011qSA@\u0011\u001d\ty\n\u0001C\u0001\u0003g\t1\u0006^3ti>3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i-\u0006d\u0017\u000eZ1uS>tgi\u001c:MK\u0006$WM\u001d\u0015\u0005\u0003;\u000by\bC\u0004\u0002&\u0002!\t!a\r\u0002[Q,7\u000f^(gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NV1mS\u0012\fG/[8o\r>\u0014hi\u001c7m_^,'\u000f\u000b\u0003\u0002$\u0006}\u0004bBAV\u0001\u0011\u0005\u00111G\u0001'i\u0016\u001cHOU3bIJ+7m\u001c:e\u000bB|7\r\u001b,bY&$\u0017\r^5p]\u001a{'\u000fT3bI\u0016\u0014\b\u0006BAU\u0003\u007fBq!!-\u0001\t\u0003\t\u0019$\u0001\u0015uKN$(+Z1e%\u0016\u001cwN\u001d3Fa>\u001c\u0007NV1mS\u0012\fG/[8o\r>\u0014hi\u001c7m_^,'\u000f\u000b\u0003\u00020\u0006}\u0004bBA\\\u0001\u0011\u0005\u00111G\u00014i\u0016\u001cHOR3uG\"|eMZ:fi\u001a{'\u000fV5nKN$\u0018-\u001c9Fa>\u001c\u0007NV1mS\u0012\fG/[8o\r>\u0014H*Z1eKJDC!!.\u0002\u0000!9\u0011Q\u0018\u0001\u0005\u0002\u0005M\u0012!\u000e;fgR4U\r^2i\u001f\u001a47/\u001a;G_J$\u0016.\\3ti\u0006l\u0007/\u00129pG\"4\u0016\r\\5eCRLwN\u001c$pe\u001a{G\u000e\\8xKJDC!a/\u0002\u0000!9\u00111\u0019\u0001\u0005\n\u0005\u0015\u0017aF:fiV\u0004\b+\u0019:uSRLwN\\,ji\"lunY6t)!\t9-!4\u0002R\u0006m\u0007c\u0001\n\u0002J&\u0019\u00111\u001a\u0002\u0003\u0013A\u000b'\u000f^5uS>t\u0007bBAh\u0003\u0003\u0004\rAF\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007\u000e\u0003\u0005\u0002T\u0006\u0005\u0007\u0019AAk\u0003!I7\u000fT3bI\u0016\u0014\bcA\u0005\u0002X&\u0019\u0011\u0011\u001c\u0006\u0003\u000f\t{w\u000e\\3b]\"Q\u0011QAAa!\u0003\u0005\r!!8\u0011\t\u0005\u0005\u0011q\\\u0005\u0005\u0003C\f\u0019AA\u0002M_\u001eDq!!:\u0001\t\u0003\t\u0019$\u0001\u0018uKN$\u0018\t\u001d9f]\u0012\u0014VmY8sIN\f5OR8mY><XM\u001d\"fY><Hj\\4Ti\u0006\u0014Ho\u00144gg\u0016$\b\u0006BAr\u0003\u007fBq!a;\u0001\t\u0003\t\u0019$A\u000fuKN$H*[:u\u001f\u001a47/\u001a;Jg>d\u0017\r^5p]2+g/\u001a7tQ\u0011\tI/a \t\u000f\u0005E\b\u0001\"\u0001\u00024\u0005qA/Z:u\u000f\u0016$(+\u001a9mS\u000e\f\u0007\u0006BAx\u0003\u007fBq!a>\u0001\t\u0003\t\u0019$A\u001cuKN$\u0018\t\u001d9f]\u0012\u0014VmY8sIN$vNR8mY><XM],ji\"tuNU3qY&\u001c\u0017\r\u00165s_^\u001cX\t_2faRLwN\u001c\u0015\u0005\u0003k\fy\bC\u0004\u0002~\u0002!\t!a\r\u0002IQ,7\u000f^'bW\u00164u\u000e\u001c7po\u0016\u0014x+\u001b;i\u001d>dU-\u00193fe&#7\t[1oO\u0016DC!a?\u0002\u0000!9!1\u0001\u0001\u0005\u0002\u0005M\u0012a\u0012;fgR4u\u000e\u001c7po\u0016\u0014Hi\\3t\u001d>$(j\\5o\u0013N\u0013VK\u001c;jY\u000e\u000bWo\u001a5u+B$vn\u00144gg\u0016$x+\u001b;iS:\u001cUO\u001d:f]RdU-\u00193fe\u0016\u0003xn\u00195)\t\t\u0005\u0011q\u0010\u0005\b\u0005\u0013\u0001A\u0011AA\u001a\u0003\t\"Xm\u001d;EK2\f\u00170\u001a3GKR\u001c\u0007.\u00114uKJ\f\u0005\u000f]3oIJ+7m\u001c:eg\"\"!qAA@\u0011\u001d\u0011y\u0001\u0001C\u0001\u0005#\tQb\u0019:fCR,'+Z2pe\u0012\u001cH\u0003\u0003B\n\u0005?\u0011\tEa\u0013\u0011\t\tU!1D\u0007\u0003\u0005/Q1A!\u0007!\u0003\u0019\u0011XmY8sI&!!Q\u0004B\f\u00055iU-\\8ssJ+7m\u001c:eg\"A!\u0011\u0005B\u0007\u0001\u0004\u0011\u0019#A\u0004sK\u000e|'\u000fZ:\u0011\r\t\u0015\"Q\u0007B\u001e\u001d\u0011\u00119C!\r\u000f\t\t%\"qF\u0007\u0003\u0005WQ1A!\f\u0007\u0003\u0019a$o\\8u}%\t1\"C\u0002\u00034)\tq\u0001]1dW\u0006<W-\u0003\u0003\u00038\te\"\u0001C%uKJ\f'\r\\3\u000b\u0007\tM\"\u0002\u0005\u0003\u0003\u0016\tu\u0012\u0002\u0002B \u0005/\u0011AbU5na2,'+Z2pe\u0012D\u0001Ba\u0011\u0003\u000e\u0001\u0007!QI\u0001\u000bE\u0006\u001cXm\u00144gg\u0016$\bcA\u0005\u0003H%\u0019!\u0011\n\u0006\u0003\t1{gn\u001a\u0005\n\u0005\u001b\u0012i\u0001%AA\u0002Y\tA\u0003]1si&$\u0018n\u001c8MK\u0006$WM]#q_\u000eD\u0007b\u0002B)\u0001\u0011\u0005!1K\u0001\u001bGJ,\u0017\r^3Ue\u0006t7/Y2uS>t\u0017\r\u001c*fG>\u0014Hm\u001d\u000b\t\u0005'\u0011)Fa\u0016\u0003Z!A!\u0011\u0005B(\u0001\u0004\u0011\u0019\u0003\u0003\u0005\u0003D\t=\u0003\u0019\u0001B#\u0011%\u0011iEa\u0014\u0011\u0002\u0003\u0007a\u0003C\u0005\u0003^\u0001\t\n\u0011\"\u0003\u0003`\u0005\t3/\u001a;vaB\u000b'\u000f^5uS>tw+\u001b;i\u001b>\u001c7n\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!\u0011\r\u0016\u0005\u0003;\u0014\u0019g\u000b\u0002\u0003fA!!q\rB9\u001b\t\u0011IG\u0003\u0003\u0003l\t5\u0014!C;oG\",7m[3e\u0015\r\u0011yGC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B:\u0005S\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u00119\bAI\u0001\n\u0003\u0011I(A\fde\u0016\fG/\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!1\u0010\u0016\u0004-\t\r\u0004\"\u0003B@\u0001E\u0005I\u0011\u0001B=\u0003\u0011\u001a'/Z1uKR\u0013\u0018M\\:bGRLwN\\1m%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\u001a\u0004")
public class PartitionTest {
    private final int brokerId;
    private final TopicPartition topicPartition = new TopicPartition("test-topic", 0);
    private final MockTime time = new MockTime();
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final Metrics metrics = new Metrics();
    private File tmpDir;
    private File logDir1;
    private File logDir2;
    private ReplicaManager replicaManager;
    private LogManager logManager;
    private LogConfig logConfig;

    public int brokerId() {
        return this.brokerId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public MockTime time() {
        return this.time;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public File logDir1() {
        return this.logDir1;
    }

    public void logDir1_$eq(File x$1) {
        this.logDir1 = x$1;
    }

    public File logDir2() {
        return this.logDir2;
    }

    public void logDir2_$eq(File x$1) {
        this.logDir2 = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public void logConfig_$eq(LogConfig x$1) {
        this.logConfig = x$1;
    }

    @Before
    public void setup() {
        Properties logProps = this.createLogProperties((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        this.logConfig_$eq(new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2()));
        this.tmpDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logDir1_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        this.logDir2_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        boolean x$10 = false;
        int x$11 = CleanerConfig$.MODULE$.apply$default$1();
        long x$12 = CleanerConfig$.MODULE$.apply$default$2();
        double x$13 = CleanerConfig$.MODULE$.apply$default$3();
        int x$14 = CleanerConfig$.MODULE$.apply$default$4();
        int x$15 = CleanerConfig$.MODULE$.apply$default$5();
        double x$16 = CleanerConfig$.MODULE$.apply$default$6();
        long x$17 = CleanerConfig$.MODULE$.apply$default$7();
        String x$18 = CleanerConfig$.MODULE$.apply$default$9();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir1(), this.logDir2()}))), this.logConfig(), new CleanerConfig(x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$10, x$18), this.time()));
        this.logManager().startup();
        Properties brokerProps = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        brokerProps.put(KafkaConfig$.MODULE$.LogDirsProp(), ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir1(), this.logDir2()}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(File x$1) {
                return x$1.getAbsolutePath();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(","));
        KafkaConfig brokerConfig = KafkaConfig$.MODULE$.fromProps(brokerProps);
        KafkaZkClient kafkaZkClient = (KafkaZkClient)EasyMock.createMock(KafkaZkClient.class);
        this.replicaManager_$eq(new ReplicaManager(brokerConfig, this.metrics(), (Time)this.time(), kafkaZkClient, (Scheduler)new MockScheduler((Time)this.time()), this.logManager(), new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(brokerConfig, this.metrics(), (Time)this.time(), ""), this.brokerTopicStats(), new MetadataCache(this.brokerId()), new LogDirFailureChannel(brokerConfig.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12()));
        EasyMock.expect((Object)kafkaZkClient.getEntityConfigs(EasyMock.anyString(), EasyMock.anyString())).andReturn((Object)logProps).anyTimes();
        EasyMock.expect((Object)kafkaZkClient.conditionalUpdatePath((String)EasyMock.anyObject(), (byte[])EasyMock.anyObject(), BoxesRunTime.unboxToInt((Object)EasyMock.anyObject()), (Option)EasyMock.anyObject())).andReturn((Object)new Tuple2.mcZI.sp(true, 0)).anyTimes();
        EasyMock.replay((Object[])new Object[]{kafkaZkClient});
    }

    /*
     * WARNING - void declaration
     */
    private Properties createLogProperties(scala.collection.immutable.Map<String, String> overrides) {
        void var2_2;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(512));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(999));
        overrides.foreach((Function1)new Serializable(this, logProps){
            public static final long serialVersionUID = 0L;
            private final Properties logProps$1;

            public final Object apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Object object = this.logProps$1.put(k, v);
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.logProps$1 = logProps$1;
            }
        });
        return var2_2;
    }

    @After
    public void tearDown() {
        this.brokerTopicStats().close();
        this.metrics().close();
        this.logManager().shutdown();
        Utils.delete((File)this.tmpDir());
        this.logManager().liveLogDirs().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File x$1) {
                Utils.delete((File)x$1);
            }
        });
        this.replicaManager().shutdown(false);
    }

    @Test
    public void testMakeLeaderUpdatesEpochCache() {
        int leaderEpoch = 8;
        LogManager qual$1 = this.logManager();
        TopicPartition x$19 = this.topicPartition();
        LogConfig x$20 = this.logConfig();
        boolean x$21 = qual$1.getOrCreateLog$default$3();
        boolean x$22 = qual$1.getOrCreateLog$default$4();
        Log log2 = qual$1.getOrCreateLog(x$19, x$20, x$21, x$22);
        log2.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())}), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(5), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v3".getBytes()), new SimpleRecord("k4".getBytes(), "v4".getBytes())}), 5, log2.appendAsLeader$default$3());
        Assert.assertEquals((long)4L, (long)log2.logEndOffset());
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, log2);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)4)), (Object)partition.leaderReplicaIfLocal().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Replica x$2) {
                return x$2.logEndOffset().messageOffset();
            }
        }));
        EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), leaderEpoch, true);
        Assert.assertEquals((long)4L, (long)epochEndOffset.endOffset());
        Assert.assertEquals((long)leaderEpoch, (long)epochEndOffset.leaderEpoch());
    }

    @Test
    public void testMakeLeaderDoesNotUpdateEpochCacheForOldFormats() {
        int leaderEpoch = 8;
        LogConfig logConfig = new LogConfig((Map)this.createLogProperties((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageFormatVersionProp()), (Object)KAFKA_0_10_2_IV0$.MODULE$.shortVersion())})))), LogConfig$.MODULE$.apply$default$2());
        LogManager qual$2 = this.logManager();
        TopicPartition x$23 = this.topicPartition();
        LogConfig x$24 = logConfig;
        boolean x$25 = qual$2.getOrCreateLog$default$3();
        boolean x$26 = qual$2.getOrCreateLog$default$4();
        Log log2 = qual$2.getOrCreateLog(x$23, x$24, x$25, x$26);
        log2.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())})), RecordVersion.V1.value, TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v3".getBytes()), new SimpleRecord("k4".getBytes(), "v4".getBytes())})), RecordVersion.V1.value, TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), 5, log2.appendAsLeader$default$3());
        Assert.assertEquals((long)4L, (long)log2.logEndOffset());
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, log2);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)4)), (Object)partition.leaderReplicaIfLocal().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Replica x$3) {
                return x$3.logEndOffset().messageOffset();
            }
        }));
        Assert.assertEquals((Object)None$.MODULE$, (Object)log2.latestEpoch());
        EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), leaderEpoch, true);
        Assert.assertEquals((long)-1L, (long)epochEndOffset.endOffset());
        Assert.assertEquals((long)-1L, (long)epochEndOffset.leaderEpoch());
    }

    @Test
    public void testMaybeReplaceCurrentWithFutureReplica() {
        CountDownLatch latch = new CountDownLatch(1);
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir1().getAbsolutePath());
        LogManager qual$3 = this.logManager();
        TopicPartition x$27 = this.topicPartition();
        LogConfig x$28 = this.logConfig();
        boolean x$29 = qual$3.getOrCreateLog$default$3();
        boolean x$30 = qual$3.getOrCreateLog$default$4();
        Log log1 = qual$3.getOrCreateLog(x$27, x$28, x$29, x$30);
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir2().getAbsolutePath());
        LogManager qual$4 = this.logManager();
        TopicPartition x$31 = this.topicPartition();
        LogConfig x$32 = this.logConfig();
        boolean x$33 = true;
        boolean x$34 = qual$4.getOrCreateLog$default$3();
        Log log2 = qual$4.getOrCreateLog(x$31, x$32, x$34, x$33);
        int x$35 = this.brokerId();
        TopicPartition x$36 = this.topicPartition();
        MockTime x$37 = this.time();
        Some x$38 = new Some((Object)log1);
        long x$39 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica currentReplica = new Replica(x$35, x$36, (Time)x$37, x$39, (Option)x$38);
        int x$40 = Request$.MODULE$.FutureLocalReplicaId();
        TopicPartition x$41 = this.topicPartition();
        MockTime x$42 = this.time();
        Some x$43 = new Some((Object)log2);
        long x$44 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica futureReplica = new Replica(x$40, x$41, (Time)x$42, x$44, (Option)x$43);
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        partition.addReplicaIfNotExists(futureReplica);
        partition.addReplicaIfNotExists(currentReplica);
        Assert.assertEquals((Object)new Some((Object)currentReplica), (Object)partition.localReplica());
        Assert.assertEquals((Object)new Some((Object)futureReplica), (Object)partition.futureLocalReplica());
        Thread thread1 = new Thread(this, latch, partition){
            private final CountDownLatch latch$1;
            private final Partition partition$1;

            public void run() {
                this.latch$1.await();
                this.partition$1.removeFutureLocalReplica(this.partition$1.removeFutureLocalReplica$default$1());
            }
            {
                this.latch$1 = latch$1;
                this.partition$1 = partition$1;
            }
        };
        Thread thread2 = new Thread(this, latch, partition){
            private final CountDownLatch latch$1;
            private final Partition partition$1;

            public void run() {
                this.latch$1.await();
                this.partition$1.maybeReplaceCurrentWithFutureReplica();
            }
            {
                this.latch$1 = latch$1;
                this.partition$1 = partition$1;
            }
        };
        thread1.start();
        thread2.start();
        latch.countDown();
        thread1.join();
        thread2.join();
        Assert.assertEquals((Object)None$.MODULE$, (Object)partition.futureLocalReplica());
    }

    @Test
    public void testFetchOffsetSnapshotEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        this.assertSnapshotError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        this.assertSnapshotError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
        this.assertSnapshotError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        this.assertSnapshotError$1(Errors.NONE, Optional.empty(), partition);
    }

    @Test
    public void testFetchOffsetSnapshotEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        this.assertSnapshotError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        this.assertSnapshotError$2(Errors.NONE, Optional.empty(), false, partition);
        this.assertSnapshotError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        this.assertSnapshotError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        this.assertSnapshotError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        this.assertSnapshotError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.empty(), true, partition);
        this.assertSnapshotError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        this.assertSnapshotError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testOffsetForLeaderEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        this.assertLastOffsetForLeaderError$1(Errors.NONE, Optional.empty(), partition);
        this.assertLastOffsetForLeaderError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        this.assertLastOffsetForLeaderError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        this.assertLastOffsetForLeaderError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testOffsetForLeaderEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        this.assertLastOffsetForLeaderError$2(Errors.NONE, Optional.empty(), false, partition);
        this.assertLastOffsetForLeaderError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        this.assertLastOffsetForLeaderError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        this.assertLastOffsetForLeaderError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        this.assertLastOffsetForLeaderError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.empty(), true, partition);
        this.assertLastOffsetForLeaderError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        this.assertLastOffsetForLeaderError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        this.assertLastOffsetForLeaderError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testReadRecordEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        this.assertReadRecordsError$1(Errors.NONE, Optional.empty(), partition);
        this.assertReadRecordsError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        this.assertReadRecordsError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        this.assertReadRecordsError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testReadRecordEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        this.assertReadRecordsError$2(Errors.NONE, Optional.empty(), false, partition);
        this.assertReadRecordsError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        this.assertReadRecordsError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        this.assertReadRecordsError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        this.assertReadRecordsError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.empty(), true, partition);
        this.assertReadRecordsError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        this.assertReadRecordsError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        this.assertReadRecordsError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testFetchOffsetForTimestampEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        this.assertFetchOffsetError$1(Errors.NONE, Optional.empty(), partition);
        this.assertFetchOffsetError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        this.assertFetchOffsetError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        this.assertFetchOffsetError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testFetchOffsetForTimestampEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        this.assertFetchOffsetError$2(Errors.NONE, Optional.empty(), false, partition);
        this.assertFetchOffsetError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        this.assertFetchOffsetError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        this.assertFetchOffsetError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        this.assertFetchOffsetError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.empty(), true, partition);
        this.assertFetchOffsetError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        this.assertFetchOffsetError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        this.assertFetchOffsetError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    private Partition setupPartitionWithMocks(int leaderEpoch, boolean isLeader, Log log2) {
        java.util.List replicas;
        int x$49 = this.brokerId();
        TopicPartition x$50 = this.topicPartition();
        MockTime x$51 = this.time();
        Some x$52 = new Some((Object)log2);
        long x$53 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica replica = new Replica(x$49, x$50, (Time)x$51, x$53, (Option)x$52);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.mock(ReplicaManager.class);
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.mock(KafkaZkClient.class);
        Partition partition = new Partition(this.topicPartition(), false, Defaults$.MODULE$.ReplicaLagTimeMaxMs(), this.brokerId(), (Time)this.time(), replicaManager, this.logManager(), zkClient);
        EasyMock.replay((Object[])new Object[]{replicaManager, zkClient});
        partition.addReplicaIfNotExists(replica);
        int controllerId = 0;
        int controllerEpoch = 0;
        java.util.List isr = replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.brokerId() + 1)}))).asJava();
        if (isLeader) {
            Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)partition.makeLeader(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, this.brokerId(), leaderEpoch, isr, 1, replicas, true), 0));
            Assert.assertEquals((long)leaderEpoch, (long)partition.getLeaderEpoch());
            Assert.assertEquals((Object)new Some((Object)replica), (Object)partition.leaderReplicaIfLocal());
        } else {
            Assert.assertTrue((String)"Expected become follower transition to succeed", (boolean)partition.makeFollower(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, this.brokerId() + 1, leaderEpoch, isr, 1, replicas, true), 0));
            Assert.assertEquals((long)leaderEpoch, (long)partition.getLeaderEpoch());
            Assert.assertEquals((Object)None$.MODULE$, (Object)partition.leaderReplicaIfLocal());
        }
        return partition;
    }

    private Log setupPartitionWithMocks$default$3() {
        LogManager qual$10 = this.logManager();
        TopicPartition x$90 = this.topicPartition();
        LogConfig x$91 = this.logConfig();
        boolean x$92 = qual$10.getOrCreateLog$default$3();
        boolean x$93 = qual$10.getOrCreateLog$default$4();
        return qual$10.getOrCreateLog(x$90, x$91, x$92, x$93);
    }

    @Test
    public void testAppendRecordsAsFollowerBelowLogStartOffset() {
        LogManager qual$6 = this.logManager();
        TopicPartition x$54 = this.topicPartition();
        LogConfig x$55 = this.logConfig();
        boolean x$56 = qual$6.getOrCreateLog$default$3();
        boolean x$57 = qual$6.getOrCreateLog$default$4();
        Log log2 = qual$6.getOrCreateLog(x$54, x$55, x$56, x$57);
        int x$58 = this.brokerId();
        TopicPartition x$59 = this.topicPartition();
        MockTime x$60 = this.time();
        Some x$61 = new Some((Object)log2);
        long x$62 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica replica = new Replica(x$58, x$59, (Time)x$60, x$62, (Option)x$61);
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        partition.addReplicaIfNotExists(replica);
        Assert.assertEquals((Object)new Some((Object)replica), (Object)partition.localReplica());
        long initialLogStartOffset = 5L;
        partition.truncateFullyAndStartAt(initialLogStartOffset, false);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset after truncate fully and start at ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)initialLogStartOffset)})), (long)initialLogStartOffset, (long)replica.logEndOffset().messageOffset());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log start offset after truncate fully and start at ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)initialLogStartOffset)})), (long)initialLogStartOffset, (long)replica.logStartOffset());
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;
            private final Partition partition$10;

            public final Option<LogAppendInfo> apply() {
                return this.partition$10.appendRecordsToFollowerOrFutureReplica(this.$outer.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())})), 3L, this.$outer.createRecords$default$3()), false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$10 = partition$10;
            }
        }, ClassTag$.MODULE$.apply(UnexpectedAppendOffsetException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 462));
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset should not change after failure to append"})).s((Seq)Nil$.MODULE$), (long)initialLogStartOffset, (long)replica.logEndOffset().messageOffset());
        long newLogStartOffset = 4L;
        MemoryRecords records2 = this.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes()), new SimpleRecord("k3".getBytes(), "v3".getBytes())})), newLogStartOffset, this.createRecords$default$3());
        partition.appendRecordsToFollowerOrFutureReplica(records2, false);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset after append of 3 records with base offset ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)newLogStartOffset)})), (long)7L, (long)replica.logEndOffset().messageOffset());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log start offset after append of 3 records with base offset ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)newLogStartOffset)})), (long)newLogStartOffset, (long)replica.logStartOffset());
        partition.appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())})), 7L, this.createRecords$default$3()), false);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset after append of 1 record at offset 7:"})).s((Seq)Nil$.MODULE$), (long)8L, (long)replica.logEndOffset().messageOffset());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log start offset not expected to change:"})).s((Seq)Nil$.MODULE$), (long)newLogStartOffset, (long)replica.logStartOffset());
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;
            private final Partition partition$10;

            public final Option<LogAppendInfo> apply() {
                MemoryRecords records2 = this.$outer.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())})), 3L, this.$outer.createRecords$default$3());
                return this.partition$10.appendRecordsToFollowerOrFutureReplica(records2, false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$10 = partition$10;
            }
        }, ClassTag$.MODULE$.apply(UnexpectedAppendOffsetException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 485));
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset should not change after failure to append"})).s((Seq)Nil$.MODULE$), (long)8L, (long)replica.logEndOffset().messageOffset());
        partition.appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())})), 8L, this.createRecords$default$3()), false);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset after append of 1 record at offset 8:"})).s((Seq)Nil$.MODULE$), (long)9L, (long)replica.logEndOffset().messageOffset());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log start offset not expected to change:"})).s((Seq)Nil$.MODULE$), (long)newLogStartOffset, (long)replica.logStartOffset());
    }

    @Test
    public void testListOffsetIsolationLevels() {
        java.util.List replicas;
        LogManager qual$7 = this.logManager();
        TopicPartition x$63 = this.topicPartition();
        LogConfig x$64 = this.logConfig();
        boolean x$65 = qual$7.getOrCreateLog$default$3();
        boolean x$66 = qual$7.getOrCreateLog$default$4();
        Log log2 = qual$7.getOrCreateLog(x$63, x$64, x$65, x$66);
        int x$67 = this.brokerId();
        TopicPartition x$68 = this.topicPartition();
        MockTime x$69 = this.time();
        Some x$70 = new Some((Object)log2);
        long x$71 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica replica = new Replica(x$67, x$68, (Time)x$69, x$71, (Option)x$70);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.mock(ReplicaManager.class);
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.mock(KafkaZkClient.class);
        Partition partition = new Partition(this.topicPartition(), false, Defaults$.MODULE$.ReplicaLagTimeMaxMs(), this.brokerId(), (Time)this.time(), replicaManager, this.logManager(), zkClient);
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        java.util.List isr = replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.brokerId() + 1)}))).asJava();
        replicaManager.tryCompleteDelayedFetch((DelayedOperationKey)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andVoid();
        EasyMock.replay((Object[])new Object[]{replicaManager, zkClient});
        partition.addReplicaIfNotExists(replica);
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)partition.makeLeader(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, this.brokerId(), leaderEpoch, isr, 1, replicas, true), 0));
        Assert.assertEquals((long)leaderEpoch, (long)partition.getLeaderEpoch());
        Assert.assertEquals((Object)new Some((Object)replica), (Object)partition.leaderReplicaIfLocal());
        MemoryRecords records2 = this.createTransactionalRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes()), new SimpleRecord("k3".getBytes(), "v3".getBytes())})), 0L, this.createTransactionalRecords$default$3());
        partition.appendRecordsToLeader(records2, true, partition.appendRecordsToLeader$default$3());
        Assert.assertEquals((long)3L, (long)this.fetchLatestOffset$1((Option)None$.MODULE$, partition).offset());
        Assert.assertEquals((long)0L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), partition).offset());
        Assert.assertEquals((long)0L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED), partition).offset());
        replica.highWatermark_$eq(new LogOffsetMetadata(1L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        Assert.assertEquals((long)3L, (long)this.fetchLatestOffset$1((Option)None$.MODULE$, partition).offset());
        Assert.assertEquals((long)1L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), partition).offset());
        Assert.assertEquals((long)0L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED), partition).offset());
        Assert.assertEquals((long)0L, (long)this.fetchEarliestOffset$1((Option)None$.MODULE$, partition).offset());
        Assert.assertEquals((long)0L, (long)this.fetchEarliestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), partition).offset());
        Assert.assertEquals((long)0L, (long)this.fetchEarliestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED), partition).offset());
    }

    @Test
    public void testGetReplica() {
        LogManager qual$8 = this.logManager();
        TopicPartition x$72 = this.topicPartition();
        LogConfig x$73 = this.logConfig();
        boolean x$74 = qual$8.getOrCreateLog$default$3();
        boolean x$75 = qual$8.getOrCreateLog$default$4();
        Log log2 = qual$8.getOrCreateLog(x$72, x$73, x$74, x$75);
        int x$76 = this.brokerId();
        TopicPartition x$77 = this.topicPartition();
        MockTime x$78 = this.time();
        Some x$79 = new Some((Object)log2);
        long x$80 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica replica = new Replica(x$76, x$77, (Time)x$78, x$80, (Option)x$79);
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        Assert.assertEquals((Object)None$.MODULE$, (Object)partition.localReplica());
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final Partition partition$12;

            public final Replica apply() {
                return this.partition$12.localReplicaOrException();
            }
            {
                this.partition$12 = partition$12;
            }
        }, ClassTag$.MODULE$.apply(ReplicaNotAvailableException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 577));
        partition.addReplicaIfNotExists(replica);
        Assert.assertEquals((Object)new Some((Object)replica), (Object)partition.localReplica());
        Assert.assertEquals((Object)replica, (Object)partition.localReplicaOrException());
    }

    @Test
    public void testAppendRecordsToFollowerWithNoReplicaThrowsException() {
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;
            private final Partition partition$13;

            public final Option<LogAppendInfo> apply() {
                return this.partition$13.appendRecordsToFollowerOrFutureReplica(this.$outer.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())})), 0L, this.$outer.createRecords$default$3()), false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$13 = partition$13;
            }
        }, ClassTag$.MODULE$.apply(ReplicaNotAvailableException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 589));
    }

    @Test
    public void testMakeFollowerWithNoLeaderIdChange() {
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        LeaderAndIsrRequest.PartitionState partitionStateInfo = new LeaderAndIsrRequest.PartitionState(0, 1, 1, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava(), 1, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava(), false);
        partition.makeFollower(0, partitionStateInfo, 0);
        partitionStateInfo = new LeaderAndIsrRequest.PartitionState(0, 1, 4, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava(), 1, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava(), false);
        Assert.assertTrue((boolean)partition.makeFollower(0, partitionStateInfo, 2));
        partitionStateInfo = new LeaderAndIsrRequest.PartitionState(0, 1, 4, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava(), 1, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava(), false);
        Assert.assertFalse((boolean)partition.makeFollower(0, partitionStateInfo, 2));
    }

    @Test
    public void testFollowerDoesNotJoinISRUntilCaughtUpToOffsetWithinCurrentLeaderEpoch() {
        int controllerEpoch = 3;
        int leader2 = this.brokerId();
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        int controllerId = this.brokerId() + 3;
        java.util.List replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader2), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2)}))).asJava();
        java.util.List isr = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader2), Predef$.MODULE$.int2Integer(follower2)}))).asJava();
        int leaderEpoch = 8;
        MemoryRecords batch1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())})), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        MemoryRecords batch2 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v1".getBytes()), new SimpleRecord("k4".getBytes(), "v2".getBytes()), new SimpleRecord("k5".getBytes(), "v3".getBytes())})), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        MemoryRecords batch3 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k6".getBytes(), "v1".getBytes()), new SimpleRecord("k7".getBytes(), "v2".getBytes())})), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        Assert.assertTrue((String)"Expected first makeLeader() to return 'leader changed'", (boolean)partition.makeLeader(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, leader2, leaderEpoch, isr, 1, replicas, true), 0));
        Assert.assertEquals((String)"Current leader epoch", (long)leaderEpoch, (long)partition.getLeaderEpoch());
        Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader2), Predef$.MODULE$.int2Integer(follower2)})), (Object)partition.inSyncReplicas().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$4) {
                return x$4.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        Replica leaderReplica = (Replica)partition.getReplica(leader2).get();
        Replica follower1Replica = (Replica)partition.getReplica(follower1).get();
        Replica follower2Replica = (Replica)partition.getReplica(follower2).get();
        long lastOffsetOfFirstBatch = partition.appendRecordsToLeader(batch1, true, partition.appendRecordsToLeader$default$3()).lastOffset();
        partition.appendRecordsToLeader(batch2, true, partition.appendRecordsToLeader$default$3());
        Assert.assertEquals((String)"Expected leader's HW not move", (long)leaderReplica.logStartOffset(), (long)leaderReplica.highWatermark().messageOffset());
        partition.updateReplicaLogReadResult(follower2Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch1, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        partition.updateReplicaLogReadResult(follower2Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(lastOffsetOfFirstBatch, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch2, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        Assert.assertEquals((String)"Expected leader's HW", (long)lastOffsetOfFirstBatch, (long)leaderReplica.highWatermark().messageOffset());
        partition.makeFollower(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, follower2, leaderEpoch + 1, isr, 1, replicas, false), 1);
        Assert.assertTrue((String)"Expected makeLeader() to return 'leader changed' after makeFollower()", (boolean)partition.makeLeader(controllerEpoch, new LeaderAndIsrRequest.PartitionState(controllerEpoch, leader2, leaderEpoch + 2, isr, 1, replicas, false), 2));
        long currentLeaderEpochStartOffset = leaderReplica.logEndOffset().messageOffset();
        partition.appendRecordsToLeader(batch3, true, partition.appendRecordsToLeader$default$3());
        partition.updateReplicaLogReadResult(follower1Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch1, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        partition.updateReplicaLogReadResult(follower1Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(lastOffsetOfFirstBatch, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch2, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader2), Predef$.MODULE$.int2Integer(follower2)})), (Object)partition.inSyncReplicas().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$5) {
                return x$5.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        partition.updateReplicaLogReadResult(follower1Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(currentLeaderEpochStartOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch3, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader2), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2)})), (Object)partition.inSyncReplicas().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$6) {
                return x$6.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testDelayedFetchAfterAppendRecords() {
        java.util.List replicaIds;
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.mock(ReplicaManager.class);
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.mock(KafkaZkClient.class);
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        java.util.List isr = replicaIds = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.brokerId() + 1)}))).asJava();
        LogConfig logConfig = new LogConfig((Map)new Properties(), LogConfig$.MODULE$.apply$default$2());
        IndexedSeq topicPartitions = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TopicPartition apply(int i) {
                return new TopicPartition("test-topic", i);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq logs = (IndexedSeq)topicPartitions.map((Function1)new Serializable(this, logConfig){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;
            private final LogConfig logConfig$1;

            public final Log apply(TopicPartition tp) {
                LogManager qual$9 = this.$outer.logManager();
                TopicPartition x$81 = tp;
                LogConfig x$82 = this.logConfig$1;
                boolean x$83 = qual$9.getOrCreateLog$default$3();
                boolean x$84 = qual$9.getOrCreateLog$default$4();
                return qual$9.getOrCreateLog(x$81, x$82, x$83, x$84);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.logConfig$1 = logConfig$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq replicas = (IndexedSeq)logs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;

            public final Replica apply(Log log2) {
                int x$85 = this.$outer.brokerId();
                TopicPartition x$86 = log2.topicPartition();
                MockTime x$87 = this.$outer.time();
                Some x$88 = new Some((Object)log2);
                long x$89 = Replica$.MODULE$.$lessinit$greater$default$4();
                return new Replica(x$85, x$86, (Time)x$87, x$89, (Option)x$88);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq partitions = (IndexedSeq)replicas.map((Function1)new Serializable(this, replicaManager, zkClient, controllerId, controllerEpoch, leaderEpoch, replicaIds, isr){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;
            private final ReplicaManager replicaManager$1;
            private final KafkaZkClient zkClient$1;
            private final int controllerId$1;
            private final int controllerEpoch$1;
            private final int leaderEpoch$1;
            private final java.util.List replicaIds$1;
            private final java.util.List isr$1;

            /*
             * WARNING - void declaration
             */
            public final Partition apply(Replica replica) {
                void var3_3;
                TopicPartition tp = replica.topicPartition();
                Partition partition = new Partition(tp, false, Defaults$.MODULE$.ReplicaLagTimeMaxMs(), this.$outer.brokerId(), (Time)this.$outer.time(), this.replicaManager$1, this.$outer.logManager(), this.zkClient$1);
                partition.addReplicaIfNotExists(replica);
                partition.makeLeader(this.controllerId$1, new LeaderAndIsrRequest.PartitionState(this.controllerEpoch$1, this.$outer.brokerId(), this.leaderEpoch$1, this.isr$1, 1, this.replicaIds$1, true), 0);
                return var3_3;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.replicaManager$1 = replicaManager$1;
                this.zkClient$1 = zkClient$1;
                this.controllerId$1 = controllerId$1;
                this.controllerEpoch$1 = controllerEpoch$1;
                this.leaderEpoch$1 = leaderEpoch$1;
                this.replicaIds$1 = replicaIds$1;
                this.isr$1 = isr$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Capture tpKey = EasyMock.newCapture();
        replicaManager.tryCompleteDelayedFetch((DelayedOperationKey)EasyMock.capture((Capture)tpKey));
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, leaderEpoch, topicPartitions, partitions, tpKey){
            private final int leaderEpoch$1;
            private final IndexedSeq topicPartitions$1;
            private final IndexedSeq partitions$1;
            private final Capture tpKey$1;

            public void answer() {
                int anotherPartition = (((TopicPartitionOperationKey)this.tpKey$1.getValue()).partition() + 1) % this.topicPartitions$1.size();
                Partition partition = (Partition)this.partitions$1.apply(anotherPartition);
                partition.fetchOffsetSnapshot(Optional.of(Predef$.MODULE$.int2Integer(this.leaderEpoch$1)), true);
            }
            {
                this.leaderEpoch$1 = leaderEpoch$1;
                this.topicPartitions$1 = topicPartitions$1;
                this.partitions$1 = partitions$1;
                this.tpKey$1 = tpKey$1;
            }
        }).anyTimes();
        EasyMock.replay((Object[])new Object[]{replicaManager, zkClient});
        AtomicBoolean done = new AtomicBoolean();
        ExecutorService executor = Executors.newFixedThreadPool(topicPartitions.size() + 1);
        try {
            try {
                executor.submit(CoreUtils$.MODULE$.runnable((Function0)new Serializable(this, partitions, done){
                    public static final long serialVersionUID = 0L;
                    private final IndexedSeq partitions$1;
                    private final AtomicBoolean done$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        while (!this.done$1.get()) {
                            this.partitions$1.foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final void apply(Partition x$7) {
                                    x$7.maybeShrinkIsr(10000L);
                                }
                            });
                        }
                        return;
                    }
                    {
                        this.partitions$1 = partitions$1;
                        this.done$1 = done$1;
                    }
                }));
                IndexedSeq futures = (IndexedSeq)partitions.map((Function1)new Serializable(this, executor){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ PartitionTest $outer;
                    private final ExecutorService executor$1;

                    public final Future<?> apply(Partition partition) {
                        return this.executor$1.submit(CoreUtils$.MODULE$.runnable((Function0)new Serializable(this, partition){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$5 $outer;
                            public final Partition partition$14;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10000).foreach((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$5$$anonfun$apply$1 $outer;

                                    public final LogAppendInfo apply(int x$8) {
                                        return this.$outer.partition$14.appendRecordsToLeader(this.$outer.kafka$cluster$PartitionTest$$anonfun$$anonfun$$$outer().kafka$cluster$PartitionTest$$anonfun$$$outer().kafka$cluster$PartitionTest$$createRecords$1(0L), true, this.$outer.partition$14.appendRecordsToLeader$default$3());
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }

                            public /* synthetic */ $anonfun$5 kafka$cluster$PartitionTest$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.partition$14 = partition$14;
                            }
                        }));
                    }

                    public /* synthetic */ PartitionTest kafka$cluster$PartitionTest$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executor$1 = executor$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                futures.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(Future<?> x$9) {
                        return x$9.get(10L, TimeUnit.SECONDS);
                    }
                });
                done.set(true);
            }
            catch (TimeoutException timeoutException) {
                String allThreads2 = TestUtils$.MODULE$.allThreadStackTraces();
                Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Test timed out with exception ", ", thread stack traces: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{timeoutException, allThreads2})));
            }
        }
        finally {
            executor.shutdownNow();
            executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
    }

    public MemoryRecords createRecords(Iterable<SimpleRecord> records2, long baseOffset, int partitionLeaderEpoch) {
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(records2).asJava())));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.LOG_APPEND_TIME, (long)baseOffset, (long)this.time().milliseconds(), (int)partitionLeaderEpoch);
        records2.foreach((Function1)new Serializable(this, builder){
            public static final long serialVersionUID = 0L;
            private final MemoryRecordsBuilder builder$2;

            public final Long apply(SimpleRecord x$1) {
                return this.builder$2.append(x$1);
            }
            {
                this.builder$2 = builder$2;
            }
        });
        return builder.build();
    }

    public int createRecords$default$3() {
        return 0;
    }

    public MemoryRecords createTransactionalRecords(Iterable<SimpleRecord> records2, long baseOffset, int partitionLeaderEpoch) {
        long producerId = 1L;
        short producerEpoch = (short)0;
        int baseSequence = 0;
        boolean isTransactional = true;
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(records2).asJava())));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (CompressionType)CompressionType.NONE, (long)baseOffset, (long)producerId, (short)producerEpoch, (int)baseSequence, (boolean)isTransactional);
        records2.foreach((Function1)new Serializable(this, builder){
            public static final long serialVersionUID = 0L;
            private final MemoryRecordsBuilder builder$3;

            public final Long apply(SimpleRecord x$1) {
                return this.builder$3.append(x$1);
            }
            {
                this.builder$3 = builder$3;
            }
        });
        return builder.build();
    }

    public int createTransactionalRecords$default$3() {
        return 0;
    }

    private final void assertSnapshotError$1(Errors expectedError, Optional currentLeaderEpoch, Partition partition$2) {
        Either either;
        block4: {
            block3: {
                block2: {
                    either = partition$2.fetchOffsetSnapshotOrError(currentLeaderEpoch, true);
                    if (!(either instanceof Left)) break block2;
                    Assert.assertEquals((Object)Errors.NONE, (Object)expectedError);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(either instanceof Right)) break block4;
                Right right = (Right)either;
                Errors error = (Errors)right.b();
                Assert.assertEquals((Object)expectedError, (Object)error);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)either);
    }

    private final void assertSnapshotError$2(Errors expectedError, Optional currentLeaderEpoch, boolean fetchOnlyLeader, Partition partition$3) {
        Either either;
        block4: {
            block3: {
                block2: {
                    either = partition$3.fetchOffsetSnapshotOrError(currentLeaderEpoch, fetchOnlyLeader);
                    if (!(either instanceof Left)) break block2;
                    Assert.assertEquals((Object)expectedError, (Object)Errors.NONE);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(either instanceof Right)) break block4;
                Right right = (Right)either;
                Errors error = (Errors)right.b();
                Assert.assertEquals((Object)expectedError, (Object)error);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)either);
    }

    private final void assertLastOffsetForLeaderError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$4) {
        EpochEndOffset endOffset = partition$4.lastOffsetForLeaderEpoch(currentLeaderEpochOpt, 0, true);
        Assert.assertEquals((Object)error, (Object)endOffset.error());
    }

    private final void assertLastOffsetForLeaderError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$5) {
        EpochEndOffset endOffset = partition$5.lastOffsetForLeaderEpoch(currentLeaderEpochOpt, 0, fetchOnlyLeader);
        Assert.assertEquals((Object)error, (Object)endOffset.error());
    }

    private final void assertReadRecordsError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$6) {
        try {
            partition$6.readRecords(0L, currentLeaderEpochOpt, 1024, (FetchIsolation)FetchLogEnd$.MODULE$, true, false);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected readRecords to fail with error ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{error})));
            }
        }
        catch (Exception exception) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)exception));
        }
    }

    private final void assertReadRecordsError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$7) {
        try {
            partition$7.readRecords(0L, currentLeaderEpochOpt, 1024, (FetchIsolation)FetchLogEnd$.MODULE$, fetchOnlyLeader, false);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected readRecords to fail with error ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{error})));
            }
        }
        catch (Exception exception) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)exception));
        }
    }

    private final void assertFetchOffsetError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$8) {
        try {
            partition$8.fetchOffsetForTimestamp(0L, (Option)None$.MODULE$, currentLeaderEpochOpt, true);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected readRecords to fail with error ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{error})));
            }
        }
        catch (Exception exception) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)exception));
        }
    }

    private final void assertFetchOffsetError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$9) {
        try {
            partition$9.fetchOffsetForTimestamp(0L, (Option)None$.MODULE$, currentLeaderEpochOpt, fetchOnlyLeader);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected readRecords to fail with error ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{error})));
            }
        }
        catch (Exception exception) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)exception));
        }
    }

    private final TimestampOffset fetchLatestOffset$1(Option isolationLevel, Partition partition$11) {
        return partition$11.fetchOffsetForTimestamp(-1L, isolationLevel, Optional.empty(), true);
    }

    private final TimestampOffset fetchEarliestOffset$1(Option isolationLevel, Partition partition$11) {
        return partition$11.fetchOffsetForTimestamp(-2L, isolationLevel, Optional.empty(), true);
    }

    private final LogReadResult readResult$1(FetchDataInfo fetchInfo, Replica leaderReplica) {
        return new LogReadResult(fetchInfo, leaderReplica.highWatermark().messageOffset(), leaderReplica.logStartOffset(), leaderReplica.logEndOffset().messageOffset(), 0L, this.time().milliseconds(), 10240, (Option)None$.MODULE$, LogReadResult$.MODULE$.apply$default$9());
    }

    public final MemoryRecords kafka$cluster$PartitionTest$$createRecords$1(long baseOffset) {
        List records2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())}));
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)records2).asJava())));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)baseOffset, (long)this.time().milliseconds(), (int)0);
        records2.foreach((Function1)new Serializable(this, builder){
            public static final long serialVersionUID = 0L;
            private final MemoryRecordsBuilder builder$1;

            public final Long apply(SimpleRecord x$1) {
                return this.builder$1.append(x$1);
            }
            {
                this.builder$1 = builder$1;
            }
        });
        return builder.build();
    }

    public PartitionTest() {
        this.brokerId = 101;
    }
}

