/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kafka.api.ConsumerBounceTest$;
import kafka.api.FixedPortTestUtils$;
import kafka.cluster.Replica;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t]d\u0001B\u0001\u0003\u0001\u001d\u0011!cQ8ogVlWM\u001d\"pk:\u001cW\rV3ti*\u00111\u0001B\u0001\u0004CBL'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011AB:feZ,'/\u0003\u0002\u000e\u0015\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH\u000f\u0005\u0002\u0010%5\t\u0001C\u0003\u0002\u0012\t\u0005)Q\u000f^5mg&\u00111\u0003\u0005\u0002\b\u0019><w-\u001b8h\u0011\u0015)\u0002\u0001\"\u0001\u0017\u0003\u0019a\u0014N\\5u}Q\tq\u0003\u0005\u0002\u0019\u00015\t!\u0001C\u0004\u001b\u0001\t\u0007I\u0011A\u000e\u0002\u000bQ|\u0007/[2\u0016\u0003q\u0001\"!\b\u0012\u000e\u0003yQ!a\b\u0011\u0002\t1\fgn\u001a\u0006\u0002C\u0005!!.\u0019<b\u0013\t\u0019cD\u0001\u0004TiJLgn\u001a\u0005\u0007K\u0001\u0001\u000b\u0011\u0002\u000f\u0002\rQ|\u0007/[2!\u0011\u001d9\u0003A1A\u0005\u0002!\nA\u0001]1siV\t\u0011\u0006\u0005\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3FA\u0002J]RDa\u0001\r\u0001!\u0002\u0013I\u0013!\u00029beR\u0004\u0003b\u0002\u001a\u0001\u0005\u0004%\taM\u0001\u0003iB,\u0012\u0001\u000e\t\u0003kuj\u0011A\u000e\u0006\u0003oa\naaY8n[>t'BA\u0003:\u0015\tQ4(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002y\u0005\u0019qN]4\n\u0005y2$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007\u0001\u0002\u0001\u000b\u0011\u0002\u001b\u0002\u0007Q\u0004\b\u0005C\u0004C\u0001\t\u0007I\u0011\u0001\u0015\u0002'\u001d\u0014\u0018mY3gk2\u001cEn\\:f)&lW-T:\t\r\u0011\u0003\u0001\u0015!\u0003*\u0003Q9'/Y2fMVd7\t\\8tKRKW.Z'tA!9a\t\u0001b\u0001\n\u00039\u0015\u0001C3yK\u000e,Ho\u001c:\u0016\u0003!\u0003\"!\u0013(\u000e\u0003)S!a\u0013'\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002NA\u0005!Q\u000f^5m\u0013\ty%J\u0001\rTG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016Da!\u0015\u0001!\u0002\u0013A\u0015!C3yK\u000e,Ho\u001c:!\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cX#A+\u0011\u0007Ys\u0016M\u0004\u0002X9:\u0011\u0001lW\u0007\u00023*\u0011!LB\u0001\u0007yI|w\u000e\u001e \n\u00031J!!X\u0016\u0002\u000fA\f7m[1hK&\u0011q\f\u0019\u0002\u0004'\u0016\f(BA/,!\tI!-\u0003\u0002d\u0015\tY1*\u00194lC\u000e{gNZ5h\u0011\u0015)\u0007\u0001\"\u0011g\u0003\u0015\u0019X\r^+q)\u00059\u0007C\u0001\u0016i\u0013\tI7F\u0001\u0003V]&$\bF\u00013l!\taw.D\u0001n\u0015\tq7(A\u0003kk:LG/\u0003\u0002q[\n1!)\u001a4pe\u0016DQA\u001d\u0001\u0005B\u0019\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0003cR\u0004\"\u0001\\;\n\u0005Yl'!B!gi\u0016\u0014\b\"\u0002=\u0001\t\u00031\u0017!\t;fgR\u001cuN\\:v[B$\u0018n\u001c8XSRD'I]8lKJ4\u0015-\u001b7ve\u0016\u001c\bFA<{!\ta70\u0003\u0002}[\n1\u0011j\u001a8pe\u0016D#a\u001e@\u0011\u00051|\u0018bAA\u0001[\n!A+Z:u\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000f\t\u0011dY8ogVlWmV5uQ\n\u0013xn[3s\r\u0006LG.\u001e:fgR\u0019q-!\u0003\t\u000f\u0005-\u00111\u0001a\u0001S\u0005Aa.^7Ji\u0016\u00148\u000f\u0003\u0004\u0002\u0010\u0001!\tAZ\u0001$i\u0016\u001cHoU3fW\u0006sGmQ8n[&$x+\u001b;i\u0005J|7.\u001a:GC&dWO]3tQ\r\tiA \u0005\b\u0003+\u0001A\u0011AA\f\u0003}\u0019X-Z6B]\u0012\u001cu.\\7ji^KG\u000f\u001b\"s_.,'OR1jYV\u0014Xm\u001d\u000b\u0004O\u0006e\u0001bBA\u0006\u0003'\u0001\r!\u000b\u0005\u0007\u0003;\u0001A\u0011\u00014\u0002CQ,7\u000f^*vEN\u001c'/\u001b2f/\",g\u000eV8qS\u000e,f.\u0019<bS2\f'\r\\3)\u0007\u0005ma\u0010\u0003\u0004\u0002$\u0001!\tAZ\u0001\ni\u0016\u001cHo\u00117pg\u0016D3!!\t\u007f\u0011\u001d\tI\u0003\u0001C\u0005\u0003W\t!c\u00195fG.\u001cEn\\:f\u000f>|G\rU1uQR)q-!\f\u00022!9\u0011qFA\u0014\u0001\u0004I\u0013A\u00038v[J+7m\u001c:eg\"A\u00111GA\u0014\u0001\u0004\t)$A\u0004he>,\b/\u00133\u0011\t\u0005]\u0012Q\b\b\u0004U\u0005e\u0012bAA\u001eW\u00051\u0001K]3eK\u001aL1aIA \u0015\r\tYd\u000b\u0005\b\u0003\u0007\u0002A\u0011BA#\u0003\u0001\u001a\u0007.Z2l\u00072|7/Z,ji\"\u001cun\u001c:eS:\fGo\u001c:GC&dWO]3\u0015\u000f\u001d\f9%!\u0013\u0002N!9\u0011qFA!\u0001\u0004I\u0003\u0002CA&\u0003\u0003\u0002\r!!\u000e\u0002\u0019\u0011Lh.Y7jG\u001e\u0013x.\u001e9\t\u0011\u0005=\u0013\u0011\ta\u0001\u0003k\t1\"\\1ok\u0006dwI]8va\"9\u00111\u000b\u0001\u0005\n\u0005U\u0013a\u00044j]\u0012\u001cun\u001c:eS:\fGo\u001c:\u0015\u0007%\n9\u0006\u0003\u0005\u0002Z\u0005E\u0003\u0019AA\u001b\u0003\u00159'o\\;q\u0011\u001d\ti\u0006\u0001C\u0005\u0003?\nAd\u00195fG.\u001cEn\\:f/&$\bn\u00117vgR,'OR1jYV\u0014X\rF\u0004h\u0003C\n\u0019'a\u001a\t\u000f\u0005=\u00121\fa\u0001S!A\u0011QMA.\u0001\u0004\t)$\u0001\u0004he>,\b/\r\u0005\t\u0003S\nY\u00061\u0001\u00026\u00051qM]8vaJBa!!\u001c\u0001\t\u00031\u0017\u0001\u0007;fgR\u001cEn\\:f\tV\u0014\u0018N\\4SK\n\fG.\u00198dK\"\u001a\u00111\u000e@\t\u000f\u0005M\u0004\u0001\"\u0003\u0002v\u0005I2\r[3dW\u000ecwn]3EkJLgn\u001a*fE\u0006d\u0017M\\2f)%9\u0017qOA=\u0003w\n\u0019\t\u0003\u0005\u00024\u0005E\u0004\u0019AA\u001b\u0011\u001dQ\u0012\u0011\u000fa\u0001\u0003kAqARA9\u0001\u0004\ti\bE\u0002J\u0003\u007fJ1!!!K\u0005=)\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0007\u0002CAC\u0003c\u0002\r!a\"\u00027\t\u0014xn[3sg\u00063\u0018-\u001b7bE2,G)\u001e:j]\u001e\u001cEn\\:f!\rQ\u0013\u0011R\u0005\u0004\u0003\u0017[#a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u001f\u0003A\u0011BAI\u0003e\u0019'/Z1uK\u000e{gn];nKJ<\u0016\u000e\u001e5He>,\b/\u00133\u0015\t\u0005M\u0015q\u0016\t\t\u0003+\u000by*a)\u0002$6\u0011\u0011q\u0013\u0006\u0005\u00033\u000bY*\u0001\u0005d_:\u001cX/\\3s\u0015\r\ti\nO\u0001\bG2LWM\u001c;t\u0013\u0011\t\t+a&\u0003\u001b-\u000bgm[1D_:\u001cX/\\3s!\u0015Q\u0013QUAU\u0013\r\t9k\u000b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004U\u0005-\u0016bAAWW\t!!)\u001f;f\u0011!\t\u0019$!$A\u0002\u0005U\u0002bBAZ\u0001\u0011%\u0011QW\u0001\u0019GJ,\u0017\r^3D_:\u001cX/\\3s\u0003:$'+Z2fSZ,G\u0003CAJ\u0003o\u000bI,!0\t\u0011\u0005M\u0012\u0011\u0017a\u0001\u0003kA\u0001\"a/\u00022\u0002\u0007\u0011qQ\u0001\r[\u0006tW/\u00197BgNLwM\u001c\u0005\b\u0003_\t\t\f1\u0001*\u0011\u001d\t\t\r\u0001C\u0005\u0003\u0007\faB]3dK&4XMU3d_J$7\u000fF\u0005h\u0003\u000b\f9-!3\u0002L\"A\u0011\u0011TA`\u0001\u0004\t\u0019\nC\u0004\u00020\u0005}\u0006\u0019A\u0015\t\u0013i\ty\f%AA\u0002\u0005U\u0002BCAg\u0003\u007f\u0003\n\u00111\u0001\u0002P\u0006IA/[7f_V$Xj\u001d\t\u0004U\u0005E\u0017bAAjW\t!Aj\u001c8h\u0011\u001d\t9\u000e\u0001C\u0005\u00033\fac];c[&$8\t\\8tK\u0006sGMV1mS\u0012\fG/\u001a\u000b\u000b\u00037\f9/!;\u0002n\u0006]\b#B%\u0002^\u0006\u0005\u0018bAAp\u0015\n1a)\u001e;ve\u0016\u00042AKAr\u0013\r\t)o\u000b\u0002\u0004\u0003:L\b\u0002CAM\u0003+\u0004\r!a%\t\u0011\u0005-\u0018Q\u001ba\u0001\u0003\u001f\fab\u00197pg\u0016$\u0016.\\3pkRl5\u000f\u0003\u0005\u0002p\u0006U\u0007\u0019AAy\u00039i\u0017N\\\"m_N,G+[7f\u001bN\u0004RAKAz\u0003\u001fL1!!>,\u0005\u0019y\u0005\u000f^5p]\"A\u0011\u0011`Ak\u0001\u0004\t\t0\u0001\bnCb\u001cEn\\:f)&lW-T:\t\u000f\u0005u\b\u0001\"\u0003\u0002\u0000\u0006\u00012\r[3dW\u000ecwn]3e'R\fG/\u001a\u000b\u0006O\n\u0005!1\u0001\u0005\t\u0003g\tY\u00101\u0001\u00026!9!QAA~\u0001\u0004I\u0013\u0001E2p[6LG\u000f^3e%\u0016\u001cwN\u001d3t\r\u0019\u0011I\u0001\u0001\u0003\u0003\f\t)\"i\\;oG\u0016\u0014%o\\6feN\u001b\u0007.\u001a3vY\u0016\u00148\u0003\u0002B\u0004\u0005\u001b\u00012a\u0004B\b\u0013\r\u0011\t\u0002\u0005\u0002\u0013'\",H\u000fZ8x]\u0006\u0014G.\u001a+ie\u0016\fG\r\u0003\u0006\u0002\f\t\u001d!Q1A\u0005\u0002!B!Ba\u0006\u0003\b\t\u0005\t\u0015!\u0003*\u0003%qW/\\%uKJ\u001c\b\u0005C\u0004\u0016\u0005\u000f!\tAa\u0007\u0015\t\tu!\u0011\u0005\t\u0005\u0005?\u00119!D\u0001\u0001\u0011\u001d\tYA!\u0007A\u0002%B\u0011B!\n\u0003\b\u0001\u0007I\u0011\u0001\u0015\u0002\t%$XM\u001d\u0005\u000b\u0005S\u00119\u00011A\u0005\u0002\t-\u0012\u0001C5uKJ|F%Z9\u0015\u0007\u001d\u0014i\u0003C\u0005\u00030\t\u001d\u0012\u0011!a\u0001S\u0005\u0019\u0001\u0010J\u0019\t\u0011\tM\"q\u0001Q!\n%\nQ!\u001b;fe\u0002BqAa\u000e\u0003\b\u0011\u0005c-\u0001\u0004e_^{'o\u001b\u0005\b\u0005w\u0001A\u0011\u0002B\u001f\u0003-\u0019XM\u001c3SK\u000e|'\u000fZ:\u0015\u000f\u001d\u0014yD!\u0014\u0003P!A!\u0011\tB\u001d\u0001\u0004\u0011\u0019%\u0001\u0005qe>$WoY3s!!\u0011)E!\u0013\u0002$\u0006\rVB\u0001B$\u0015\u0011\u0011\t%a'\n\t\t-#q\t\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\t\u000f\u0005=\"\u0011\ba\u0001S!I!D!\u000f\u0011\u0002\u0003\u0007\u0011Q\u0007\u0005\n\u0005'\u0002\u0011\u0013!C\u0005\u0005+\nQc]3oIJ+7m\u001c:eg\u0012\"WMZ1vYR$3'\u0006\u0002\u0003X)\"\u0011Q\u0007B-W\t\u0011Y\u0006\u0005\u0003\u0003^\t\u001dTB\u0001B0\u0015\u0011\u0011\tGa\u0019\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B3W\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t%$q\f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"\u0003B7\u0001E\u0005I\u0011\u0002B+\u0003a\u0011XmY3jm\u0016\u0014VmY8sIN$C-\u001a4bk2$He\r\u0005\n\u0005c\u0002\u0011\u0013!C\u0005\u0005g\n\u0001D]3dK&4XMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011)H\u000b\u0003\u0002P\ne\u0003")
public class ConsumerBounceTest
extends BaseRequestTest {
    private final String topic;
    private final int part;
    private final TopicPartition tp = new TopicPartition(this.topic(), this.part());
    private final int gracefulCloseTimeMs;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(2);

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public int gracefulCloseTimeMs() {
        return this.gracefulCloseTimeMs;
    }

    public ScheduledExecutorService executor() {
        return this.executor;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Properties properties = new Properties();
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.put(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "10");
        properties.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        properties.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
        properties.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), "false");
        return (Seq)FixedPortTestUtils$.MODULE$.createBrokerConfigs(this.numBrokers(), this.zkConnect(), false, FixedPortTestUtils$.MODULE$.createBrokerConfigs$default$4()).map((Function1)new Serializable(this, properties){
            public static final long serialVersionUID = 0L;
            private final Properties properties$1;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.properties$1);
            }
            {
                this.properties$1 = properties$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createTopic(this.topic(), 1, this.numBrokers(), this.createTopic$default$4());
    }

    @Override
    @After
    public void tearDown() {
        try {
            this.executor().shutdownNow();
            Assert.assertTrue((String)"Executor did not terminate", (boolean)this.executor().awaitTermination(5000L, TimeUnit.MILLISECONDS));
            return;
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    @Ignore
    public void testConsumptionWithBrokerFailures() {
        this.consumeWithBrokerFailures(10);
    }

    public void consumeWithBrokerFailures(int numIters) {
        int numRecords = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.sendRecords$default$3());
        LongRef consumed = LongRef.create((long)0L);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.subscribe(Collections.singletonList(this.topic()));
        BounceBrokerScheduler scheduler = new BounceBrokerScheduler(this, numIters);
        scheduler.start();
        while (scheduler.isRunning()) {
            Iterable records2 = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)consumer.poll(100L)).asScala();
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(consumer.assignment()).asScala());
            records2.foreach((Function1)new Serializable(this, consumed){
                public static final long serialVersionUID = 0L;
                private final LongRef consumed$1;

                public final void apply(ConsumerRecord<byte[], byte[]> record) {
                    Assert.assertEquals((long)this.consumed$1.elem, (long)record.offset());
                    ++this.consumed$1.elem;
                }
                {
                    this.consumed$1 = consumed$1;
                }
            });
            if (!records2.nonEmpty()) continue;
            consumer.commitSync();
            Assert.assertEquals((long)consumer.position(this.tp()), (long)consumer.committed(this.tp()).offset());
            if (consumer.position(this.tp()) != (long)numRecords) continue;
            consumer.seekToBeginning(Collections.emptyList());
            consumed.elem = 0L;
        }
        scheduler.shutdown();
    }

    @Test
    public void testSeekAndCommitWithBrokerFailures() {
        this.seekAndCommitWithBrokerFailures(5);
    }

    public void seekAndCommitWithBrokerFailures(int numIters) {
        int numRecords = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.sendRecords$default$3());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.assign(Collections.singletonList(this.tp()));
        consumer.seek(this.tp(), 0L);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, numRecords){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;
            public final int numRecords$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.servers().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$seekAndCommitWithBrokerFailures$1 $outer;

                    public final boolean apply(KafkaServer server) {
                        return ((Replica)server.replicaManager().localReplica(this.$outer.kafka$api$ConsumerBounceTest$$anonfun$$$outer().tp()).get()).highWatermark().messageOffset() == (long)this.$outer.numRecords$1;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ConsumerBounceTest kafka$api$ConsumerBounceTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numRecords$1 = numRecords$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to update high watermark for followers after timeout";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        BounceBrokerScheduler scheduler = new BounceBrokerScheduler(this, numIters);
        scheduler.start();
        while (scheduler.isRunning()) {
            int coin = TestUtils$.MODULE$.random().nextInt(3);
            if (coin == 0) {
                this.info((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Seeking to end of log";
                    }
                });
                consumer.seekToEnd(Collections.emptyList());
                Assert.assertEquals((long)numRecords, (long)consumer.position(this.tp()));
                continue;
            }
            if (coin == 1) {
                long pos = TestUtils$.MODULE$.random().nextInt(numRecords);
                this.info((Function0<String>)new Serializable(this, pos){
                    public static final long serialVersionUID = 0L;
                    private final long pos$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Seeking to ").append((Object)BoxesRunTime.boxToLong((long)this.pos$1)).toString();
                    }
                    {
                        this.pos$1 = pos$1;
                    }
                });
                consumer.seek(this.tp(), pos);
                Assert.assertEquals((long)pos, (long)consumer.position(this.tp()));
                continue;
            }
            if (coin != 2) continue;
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Committing offset.";
                }
            });
            consumer.commitSync();
            Assert.assertEquals((long)consumer.position(this.tp()), (long)consumer.committed(this.tp()).offset());
        }
    }

    @Test
    public void testSubscribeWhenTopicUnavailable() {
        int numRecords = 1000;
        String newtopic = "newtopic";
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
        consumer.subscribe(Collections.singleton(newtopic));
        this.executor().schedule(new Runnable(this, newtopic){
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final String newtopic$1;

            public void run() {
                this.$outer.createTopic(this.newtopic$1, this.$outer.numBrokers(), this.$outer.numBrokers(), this.$outer.createTopic$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newtopic$1 = newtopic$1;
            }
        }, 2L, TimeUnit.SECONDS);
        consumer.poll(0L);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords$1(numRecords, newtopic, producer);
        this.kafka$api$ConsumerBounceTest$$receiveRecords(consumer, numRecords, newtopic, 10000L);
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.killBroker(server.config().brokerId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Thread.sleep(500L);
        this.restartDeadBrokers();
        Future<?> future = this.executor().submit(new Runnable(this, numRecords, newtopic, consumer){
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final int numRecords$2;
            private final String newtopic$1;
            private final KafkaConsumer consumer$1;

            public void run() {
                this.$outer.kafka$api$ConsumerBounceTest$$receiveRecords((KafkaConsumer<byte[], byte[]>)this.consumer$1, this.numRecords$2, this.newtopic$1, 10000L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numRecords$2 = numRecords$2;
                this.newtopic$1 = newtopic$1;
                this.consumer$1 = consumer$1;
            }
        });
        this.sendRecords$1(numRecords, newtopic, producer);
        future.get();
    }

    @Test
    public void testClose() {
        int numRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.sendRecords$default$3());
        this.checkCloseGoodPath(numRecords, "group1");
        this.checkCloseWithCoordinatorFailure(numRecords, "group2", "group3");
        this.checkCloseWithClusterFailure(numRecords, "group4", "group5");
    }

    private void checkCloseGoodPath(int numRecords, String groupId) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerAndReceive(groupId, false, numRecords);
        Future<Object> future = this.submitCloseAndValidate(consumer, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.gracefulCloseTimeMs())));
        future.get();
        this.checkClosedState(groupId, numRecords);
    }

    private void checkCloseWithCoordinatorFailure(int numRecords, String dynamicGroup, String manualGroup) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerAndReceive(dynamicGroup, false, numRecords);
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerAndReceive(manualGroup, true, numRecords);
        this.killBroker(this.findCoordinator(dynamicGroup));
        this.killBroker(this.findCoordinator(manualGroup));
        Future<Object> future1 = this.submitCloseAndValidate(consumer1, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.gracefulCloseTimeMs())));
        Future<Object> future2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.gracefulCloseTimeMs())));
        future1.get();
        future2.get();
        this.restartDeadBrokers();
        this.checkClosedState(dynamicGroup, 0);
        this.checkClosedState(manualGroup, numRecords);
    }

    private int findCoordinator(String group) {
        FindCoordinatorRequest request = (FindCoordinatorRequest)new FindCoordinatorRequest.Builder(FindCoordinatorRequest.CoordinatorType.GROUP, group).build();
        ByteBuffer resp = this.connectAndSend((AbstractRequest)request, ApiKeys.FIND_COORDINATOR, this.connectAndSend$default$3(), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        FindCoordinatorResponse response = FindCoordinatorResponse.parse((ByteBuffer)resp, (short)ApiKeys.FIND_COORDINATOR.latestVersion());
        return response.node().id();
    }

    private void checkCloseWithClusterFailure(int numRecords, String group1, String group2) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerAndReceive(group1, false, numRecords);
        int requestTimeout = 6000;
        this.consumerConfig().setProperty("session.timeout.ms", "5000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("request.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)requestTimeout)).toString());
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerAndReceive(group2, true, numRecords);
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.killBroker(server.config().brokerId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        int closeTimeout = 2000;
        Future<Object> future1 = this.submitCloseAndValidate(consumer1, closeTimeout, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)closeTimeout)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)closeTimeout)));
        Future<Object> future2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)requestTimeout)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)requestTimeout)));
        future1.get();
        future2.get();
    }

    @Test
    public void testCloseDuringRebalance() {
        String topic = "closetest";
        this.createTopic(topic, 10, this.numBrokers(), this.createTopic$default$4());
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.checkCloseDuringRebalance("group1", topic, this.executor(), true);
    }

    private void checkCloseDuringRebalance(String groupId, String topic, ExecutorService executor, boolean brokersAvailableDuringClose) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerWithGroupId(groupId);
        this.waitForRebalance$1(2000L, this.subscribeAndPoll$1(consumer1, this.subscribeAndPoll$default$2$1(), topic, executor), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[0]));
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerWithGroupId(groupId);
        this.waitForRebalance$1(2000L, this.subscribeAndPoll$1(consumer2, this.subscribeAndPoll$default$2$1(), topic, executor), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[]{consumer1}));
        Future rebalanceFuture = this.createConsumerToRebalance$1(groupId, topic, executor);
        Future<Object> closeFuture1 = this.submitCloseAndValidate(consumer1, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.gracefulCloseTimeMs())));
        this.waitForRebalance$1(2000L, rebalanceFuture, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[]{consumer2}));
        this.createConsumerToRebalance$1(groupId, topic, executor);
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.killBroker(server.config().brokerId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Future<Object> closeFuture2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        closeFuture1.get(2000L, TimeUnit.MILLISECONDS);
        closeFuture2.get(2000L, TimeUnit.MILLISECONDS);
    }

    private KafkaConsumer<byte[], byte[]> createConsumerWithGroupId(String groupId) {
        this.consumerConfig().setProperty("group.id", groupId);
        return this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3());
    }

    private KafkaConsumer<byte[], byte[]> createConsumerAndReceive(String groupId, boolean manualAssign, int numRecords) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerWithGroupId(groupId);
        if (manualAssign) {
            consumer.assign(Collections.singleton(this.tp()));
        } else {
            consumer.subscribe(Collections.singleton(this.topic()));
        }
        this.kafka$api$ConsumerBounceTest$$receiveRecords(consumer, numRecords, this.receiveRecords$default$3(), this.receiveRecords$default$4());
        return consumer;
    }

    public void kafka$api$ConsumerBounceTest$$receiveRecords(KafkaConsumer<byte[], byte[]> consumer, int numRecords, String topic, long timeoutMs) {
        long received;
        long endTimeMs = System.currentTimeMillis() + timeoutMs;
        for (received = 0L; received < (long)numRecords && System.currentTimeMillis() < endTimeMs; received += (long)consumer.poll(1000L).count()) {
        }
        Assert.assertEquals((long)numRecords, (long)received);
    }

    private String receiveRecords$default$3() {
        return this.topic();
    }

    private long receiveRecords$default$4() {
        return 60000L;
    }

    private Future<Object> submitCloseAndValidate(KafkaConsumer<byte[], byte[]> consumer, long closeTimeoutMs, Option<Object> minCloseTimeMs, Option<Object> maxCloseTimeMs) {
        return this.executor().submit(CoreUtils$.MODULE$.runnable((Function0)new Serializable(this, consumer, closeTimeoutMs, minCloseTimeMs, maxCloseTimeMs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final KafkaConsumer consumer$2;
            public final long closeTimeoutMs$1;
            private final Option minCloseTimeMs$1;
            private final Option maxCloseTimeMs$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int closeGraceTimeMs = 2000;
                long startNanos = System.nanoTime();
                this.$outer.info((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$submitCloseAndValidate$1 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Closing consumer with timeout ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.closeTimeoutMs$1)).append((Object)" ms.").toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.consumer$2.close(this.closeTimeoutMs$1, TimeUnit.MILLISECONDS);
                long timeTakenMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
                this.maxCloseTimeMs$1.foreach((Function1)new Serializable(this, closeGraceTimeMs, timeTakenMs){
                    public static final long serialVersionUID = 0L;
                    private final int closeGraceTimeMs$1;
                    private final long timeTakenMs$1;

                    public final void apply(long ms) {
                        this.apply$mcVJ$sp(ms);
                    }

                    public void apply$mcVJ$sp(long ms) {
                        Assert.assertTrue((String)new StringBuilder().append((Object)"Close took too long ").append((Object)BoxesRunTime.boxToLong((long)this.timeTakenMs$1)).toString(), (this.timeTakenMs$1 < ms + (long)this.closeGraceTimeMs$1 ? 1 : 0) != 0);
                    }
                    {
                        this.closeGraceTimeMs$1 = closeGraceTimeMs$1;
                        this.timeTakenMs$1 = timeTakenMs$1;
                    }
                });
                this.minCloseTimeMs$1.foreach((Function1)new Serializable(this, timeTakenMs){
                    public static final long serialVersionUID = 0L;
                    private final long timeTakenMs$1;

                    public final void apply(long ms) {
                        this.apply$mcVJ$sp(ms);
                    }

                    public void apply$mcVJ$sp(long ms) {
                        Assert.assertTrue((String)new StringBuilder().append((Object)"Close finished too quickly ").append((Object)BoxesRunTime.boxToLong((long)this.timeTakenMs$1)).toString(), (this.timeTakenMs$1 >= ms ? 1 : 0) != 0);
                    }
                    {
                        this.timeTakenMs$1 = timeTakenMs$1;
                    }
                });
                this.$outer.info((Function0<String>)new Serializable(this, timeTakenMs){
                    public static final long serialVersionUID = 0L;
                    private final long timeTakenMs$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"consumer.close() completed in ").append((Object)BoxesRunTime.boxToLong((long)this.timeTakenMs$1)).append((Object)" ms.").toString();
                    }
                    {
                        this.timeTakenMs$1 = timeTakenMs$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumer$2 = consumer$2;
                this.closeTimeoutMs$1 = closeTimeoutMs$1;
                this.minCloseTimeMs$1 = minCloseTimeMs$1;
                this.maxCloseTimeMs$1 = maxCloseTimeMs$1;
            }
        }), BoxesRunTime.boxToInteger((int)0));
    }

    private void checkClosedState(String groupId, int committedRecords) {
        Semaphore assignSemaphore = new Semaphore(0);
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerWithGroupId(groupId);
        consumer.subscribe(Collections.singletonList(this.topic()), new ConsumerRebalanceListener(this, assignSemaphore){
            private final Semaphore assignSemaphore$1;

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.assignSemaphore$1.release();
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.assignSemaphore$1 = assignSemaphore$1;
            }
        });
        consumer.poll(3000L);
        Assert.assertTrue((String)"Assignment did not complete on time", (boolean)assignSemaphore.tryAcquire(1L, TimeUnit.SECONDS));
        if (committedRecords > 0) {
            Assert.assertEquals((long)committedRecords, (long)consumer.committed(this.tp()).offset());
        }
        consumer.close();
    }

    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, String topic) {
        IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable(this, producer, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final KafkaProducer producer$1;
            private final String topic$1;

            public final Future<RecordMetadata> apply(int i) {
                return this.producer$1.send(new ProducerRecord(this.topic$1, Predef$.MODULE$.int2Integer(this.$outer.part()), (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(), (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producer$1 = producer$1;
                this.topic$1 = topic$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        futures.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$2) {
                return x$2.get();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private String sendRecords$default$3() {
        return this.topic();
    }

    private final void sendRecords$1(int numRecords, String topic, KafkaProducer producer$2) {
        IntRef remainingRecords = IntRef.create((int)numRecords);
        long endTimeMs = System.currentTimeMillis() + 20000L;
        while (remainingRecords.elem > 0 && System.currentTimeMillis() < endTimeMs) {
            IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), remainingRecords.elem).map((Function1)new Serializable(this, producer$2, topic){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ConsumerBounceTest $outer;
                private final KafkaProducer producer$2;
                private final String topic$2;

                public final Future<RecordMetadata> apply(int i) {
                    return this.producer$2.send(new ProducerRecord(this.topic$2, Predef$.MODULE$.int2Integer(this.$outer.part()), (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(), (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes()));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producer$2 = producer$2;
                    this.topic$2 = topic$2;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            futures.map((Function1)new Serializable(this, remainingRecords){
                public static final long serialVersionUID = 0L;
                private final IntRef remainingRecords$1;

                public final void apply(Future<RecordMetadata> future) {
                    try {
                        future.get();
                        --this.remainingRecords$1.elem;
                    }
                    catch (Exception exception) {}
                }
                {
                    this.remainingRecords$1 = remainingRecords$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
        }
        Assert.assertEquals((long)0L, (long)remainingRecords.elem);
    }

    private final Future subscribeAndPoll$1(KafkaConsumer consumer, Option revokeSemaphore, String topic$3, ExecutorService executor$1) {
        return executor$1.submit(CoreUtils$.MODULE$.runnable((Function0)new Serializable(this, topic$3, consumer, revokeSemaphore){
            public static final long serialVersionUID = 0L;
            private final String topic$3;
            private final KafkaConsumer consumer$3;
            public final Option revokeSemaphore$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.consumer$3.subscribe(Collections.singletonList(this.topic$3), new ConsumerRebalanceListener(this){
                    private final /* synthetic */ $anonfun$subscribeAndPoll$1$1 $outer;

                    public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                    }

                    public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                        this.$outer.revokeSemaphore$1.foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(Semaphore s) {
                                s.release();
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.consumer$3.poll(0L);
            }
            {
                this.topic$3 = topic$3;
                this.consumer$3 = consumer$3;
                this.revokeSemaphore$1 = revokeSemaphore$1;
            }
        }), BoxesRunTime.boxToInteger((int)0));
    }

    private final Option subscribeAndPoll$default$2$1() {
        return None$.MODULE$;
    }

    private final void waitForRebalance$1(long timeoutMs, Future future, Seq otherConsumers) {
        long startMs = System.currentTimeMillis();
        while (System.currentTimeMillis() < startMs + timeoutMs && !future.isDone()) {
            otherConsumers.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ConsumerRecords<byte[], byte[]> apply(KafkaConsumer<byte[], byte[]> consumer) {
                    return consumer.poll(100L);
                }
            });
        }
        Assert.assertTrue((String)"Rebalance did not complete in time", (boolean)future.isDone());
    }

    private final Future createConsumerToRebalance$1(String groupId$1, String topic$3, ExecutorService executor$1) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerWithGroupId(groupId$1);
        Semaphore rebalanceSemaphore = new Semaphore(0);
        Future future = this.subscribeAndPoll$1(consumer, (Option)new Some((Object)rebalanceSemaphore), topic$3, executor$1);
        Assert.assertTrue((String)"Rebalance not triggered", (boolean)rebalanceSemaphore.tryAcquire(2000L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((String)"Rebalance completed too early", (boolean)future.isDone());
        return future;
    }

    public ConsumerBounceTest() {
        this.topic = "topic";
        this.part = 0;
        this.gracefulCloseTimeMs = 1000;
    }

    public class BounceBrokerScheduler
    extends ShutdownableThread {
        private final int numIters;
        private int iter;
        public final /* synthetic */ ConsumerBounceTest $outer;

        public int numIters() {
            return this.numIters;
        }

        public int iter() {
            return this.iter;
        }

        public void iter_$eq(int x$1) {
            this.iter = x$1;
        }

        public void doWork() {
            this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().killRandomBroker();
            Thread.sleep(500L);
            this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().restartDeadBrokers();
            this.iter_$eq(this.iter() + 1);
            if (this.iter() == this.numIters()) {
                this.initiateShutdown();
            } else {
                Thread.sleep(500L);
            }
        }

        public /* synthetic */ ConsumerBounceTest kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer() {
            return this.$outer;
        }

        public BounceBrokerScheduler(ConsumerBounceTest $outer, int numIters) {
            this.numIters = numIters;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("daemon-bounce-broker", false);
            this.iter = 0;
        }
    }
}

