/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareTest;
import kafka.admin.RackAwareTest$class;
import kafka.admin.ReplicaDistributions;
import kafka.admin.TopicCommand;
import kafka.admin.TopicCommand$;
import kafka.server.ConfigType$;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00193A!\u0001\u0002\u0001\u000f\t\u0001Bk\u001c9jG\u000e{W.\\1oIR+7\u000f\u001e\u0006\u0003\u0007\u0011\tQ!\u00193nS:T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001B\u0004\u000b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011A\u0001>l\u0013\ti!B\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o\u001d\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tQ!\u001e;jYNL!a\u0005\t\u0003\u000f1{wmZ5oOB\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\u000e%\u0006\u001c7.Q<be\u0016$Vm\u001d;\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002CA\u000b\u0001\u0011\u0015i\u0002\u0001\"\u0001\u001f\u0003=\"Xm\u001d;D_:4\u0017n\u001a)sKN,'O^1uS>t\u0017i\u0019:pgN\u0004\u0016M\u001d;ji&|g.\u00117uKJ\fG/[8o)\u0005y\u0002C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#\u0001B+oSRD#\u0001\b\u0014\u0011\u0005\u001dbS\"\u0001\u0015\u000b\u0005%R\u0013!\u00026v]&$(\"A\u0016\u0002\u0007=\u0014x-\u0003\u0002.Q\t!A+Z:u\u0011\u0015y\u0003\u0001\"\u0001\u001f\u0003E!Xm\u001d;U_BL7\rR3mKRLwN\u001c\u0015\u0003]\u0019BQA\r\u0001\u0005\u0002y\t!\u0003^3ti\u0012+G.\u001a;f\u0013\u001a,\u00050[:ug\"\u0012\u0011G\n\u0005\u0006k\u0001!\tAH\u0001\u0012i\u0016\u001cH/\u00117uKJLe-\u0012=jgR\u001c\bF\u0001\u001b'\u0011\u0015A\u0004\u0001\"\u0001\u001f\u0003U!Xm\u001d;De\u0016\fG/Z%g\u001d>$X\t_5tiND#a\u000e\u0014\t\u000bm\u0002A\u0011\u0001\u0010\u0002CQ,7\u000f^\"sK\u0006$X-\u00117uKJ$v\u000e]5d/&$\bNU1dW\u0006;\u0018M]3)\u0005i2\u0003\"\u0002 \u0001\t\u0003q\u0012A\u000b;fgR$Um]2sS\n,\u0017I\u001c3MSN$Hk\u001c9jGNl\u0015M]6fI\u001a{'\u000fR3mKRLwN\u001c\u0015\u0003{\u0019BQ!\u0011\u0001\u0005\u0002y\t1\u0004^3ti&sg/\u00197jIR{\u0007/[2MKZ,GnQ8oM&<\u0007F\u0001!'\u0011\u0015!\u0005\u0001\"\u0001\u001f\u00039\"Xm\u001d;EKN\u001c'/\u001b2f\u0003:$G*[:u)>\u0004\u0018nY:XSRDw.\u001e;J]R,'O\\1m)>\u0004\u0018nY:)\u0005\r3\u0003")
public class TopicCommandTest
extends ZooKeeperTestHarness
implements RackAwareTest {
    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment2, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest$class.checkReplicaDistribution(this, assignment2, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment2, Map<Object, String> brokerRackMapping) {
        return RackAwareTest$class.getReplicaDistribution(this, assignment2, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest$class.toBrokerMetadata(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest$class.toBrokerMetadata$default$2(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest$class.checkReplicaDistribution$default$6(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest$class.checkReplicaDistribution$default$7(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest$class.checkReplicaDistribution$default$8(this);
    }

    @Test
    public void testConfigPreservationAcrossPartitionAlteration() {
        String topic = "test";
        int numPartitionsOriginal = 1;
        String cleanupKey = "cleanup.policy";
        String cleanupVal = "compact";
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsOriginal)).toString(), "--replication-factor", "1", "--config", new StringBuilder().append((Object)cleanupKey).append((Object)"=").append((Object)cleanupVal).toString(), "--topic", topic}));
        TopicCommand$.MODULE$.createTopic(this.zkClient(), createOpts);
        Properties props = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic);
        Assert.assertTrue((String)new StringBuilder().append((Object)"Properties after creation don't contain ").append((Object)cleanupKey).toString(), (boolean)props.containsKey(cleanupKey));
        Assert.assertTrue((String)"Properties after creation have incorrect value", (boolean)props.getProperty(cleanupKey).equals(cleanupVal));
        this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        int numPartitionsModified = 3;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsModified)).toString(), "--topic", topic}));
        TopicCommand$.MODULE$.alterTopic(this.zkClient(), alterOpts);
        Properties newProps = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic);
        Assert.assertTrue((String)new StringBuilder().append((Object)"Updated properties do not contain ").append((Object)cleanupKey).toString(), (boolean)newProps.containsKey(cleanupKey));
        Assert.assertTrue((String)"Updated properties have incorrect value", (boolean)newProps.getProperty(cleanupKey).equals(cleanupVal));
    }

    @Test
    public void testTopicDeletion() {
        String normalTopic = "test";
        int numPartitionsOriginal = 1;
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsOriginal)).toString(), "--replication-factor", "1", "--topic", normalTopic}));
        TopicCommand$.MODULE$.createTopic(this.zkClient(), createOpts);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", normalTopic}));
        String deletePath = ZkUtils$.MODULE$.getDeleteTopicPath(normalTopic);
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deletePath));
        TopicCommand$.MODULE$.deleteTopic(this.zkClient(), deleteOpts);
        Assert.assertTrue((String)"Delete path for topic should exist after deletion.", (boolean)this.zkClient().pathExists(deletePath));
        TopicCommand.TopicCommandOptions createOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsOriginal)).toString(), "--replication-factor", "1", "--topic", "__consumer_offsets"}));
        TopicCommand$.MODULE$.createTopic(this.zkClient(), createOffsetTopicOpts);
        TopicCommand.TopicCommandOptions deleteOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "__consumer_offsets"}));
        String deleteOffsetTopicPath = ZkUtils$.MODULE$.getDeleteTopicPath("__consumer_offsets");
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deleteOffsetTopicPath));
        this.intercept((Function0)new Serializable(this, deleteOffsetTopicOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;
            private final TopicCommand.TopicCommandOptions deleteOffsetTopicOpts$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TopicCommand$.MODULE$.deleteTopic(this.$outer.zkClient(), this.deleteOffsetTopicOpts$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.deleteOffsetTopicOpts$1 = deleteOffsetTopicOpts$1;
            }
        }, ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        Assert.assertFalse((String)"Delete path for topic shouldn't exist after deletion.", (boolean)this.zkClient().pathExists(deleteOffsetTopicPath));
    }

    @Test
    public void testDeleteIfExists() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "test"}));
        this.intercept((Function0)new Serializable(this, deleteOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;
            private final TopicCommand.TopicCommandOptions deleteOpts$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TopicCommand$.MODULE$.deleteTopic(this.$outer.zkClient(), this.deleteOpts$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.deleteOpts$1 = deleteOpts$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        TopicCommand.TopicCommandOptions deleteExistsOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "test", "--if-exists"}));
        TopicCommand$.MODULE$.deleteTopic(this.zkClient(), deleteExistsOpts);
    }

    @Test
    public void testAlterIfExists() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "test", "--partitions", "1"}));
        this.intercept((Function0)new Serializable(this, alterOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;
            private final TopicCommand.TopicCommandOptions alterOpts$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TopicCommand$.MODULE$.alterTopic(this.$outer.zkClient(), this.alterOpts$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.alterOpts$1 = alterOpts$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        TopicCommand.TopicCommandOptions alterExistsOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "test", "--partitions", "1", "--if-exists"}));
        TopicCommand$.MODULE$.alterTopic(this.zkClient(), alterExistsOpts);
    }

    @Test
    public void testCreateIfNotExists() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        String topic = "test";
        int numPartitions = 1;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString(), "--replication-factor", "1", "--topic", topic}));
        TopicCommand$.MODULE$.createTopic(this.zkClient(), createOpts);
        this.intercept((Function0)new Serializable(this, createOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;
            private final TopicCommand.TopicCommandOptions createOpts$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TopicCommand$.MODULE$.createTopic(this.$outer.zkClient(), this.createOpts$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.createOpts$1 = createOpts$1;
            }
        }, ClassTag$.MODULE$.apply(TopicExistsException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
        TopicCommand.TopicCommandOptions createNotExistsOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString(), "--replication-factor", "1", "--topic", topic, "--if-not-exists"}));
        TopicCommand$.MODULE$.createTopic(this.zkClient(), createNotExistsOpts);
    }

    @Test
    public void testCreateAlterTopicWithRackAware() {
        scala.collection.immutable.Map rackInfo = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        TestUtils$.MODULE$.createBrokersInZk(this.toBrokerMetadata((Map<Object, String>)rackInfo, this.toBrokerMetadata$default$2()), this.zkClient());
        int numPartitions = 18;
        int replicationFactor = 3;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString(), "--replication-factor", ((Object)BoxesRunTime.boxToInteger((int)replicationFactor)).toString(), "--topic", "foo"}));
        TopicCommand$.MODULE$.createTopic(this.zkClient(), createOpts);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)this.zkClient().getReplicaAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Seq<Object>> apply(Tuple2<TopicPartition, Seq<Object>> x0$1) {
                Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    Seq replicas = (Seq)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)replicas);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment2, (Map<Object, String>)rackInfo, rackInfo.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
        int alteredNumPartitions = 36;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)alteredNumPartitions)).toString(), "--topic", "foo"}));
        TopicCommand$.MODULE$.alterTopic(this.zkClient(), alterOpts);
        assignment2 = (scala.collection.immutable.Map)this.zkClient().getReplicaAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Seq<Object>> apply(Tuple2<TopicPartition, Seq<Object>> x0$2) {
                Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    Seq replicas = (Seq)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)replicas);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment2, (Map<Object, String>)rackInfo, rackInfo.size(), alteredNumPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @Test
    public void testDescribeAndListTopicsMarkedForDeletion() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        String topic = "testtopic";
        String markedForDeletionDescribe = "MarkedForDeletion";
        String markedForDeletionList = "marked for deletion";
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", topic}));
        TopicCommand$.MODULE$.createTopic(this.zkClient(), createOpts);
        TestUtils$.MODULE$.deleteBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand$.MODULE$.deleteTopic(this.zkClient(), new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", topic})));
        String outputWithConfig = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandTest$$describeTopicsWithConfig$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertTrue((outputWithConfig.contains(topic) && outputWithConfig.contains(markedForDeletionDescribe) ? 1 : 0) != 0);
        String outputNoConfig = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandTest$$describeTopicsNoConfig$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertTrue((outputNoConfig.contains(topic) && outputNoConfig.contains(markedForDeletionDescribe) ? 1 : 0) != 0);
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandTest$$listTopics$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertTrue((output.contains(topic) && output.contains(markedForDeletionList) ? 1 : 0) != 0);
    }

    @Test
    public void testInvalidTopicLevelConfig() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        try {
            TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "test", "--config", "message.timestamp.type=boom"}));
            TopicCommand$.MODULE$.createTopic(this.zkClient(), createOpts);
            throw this.fail("Expected exception on invalid topic-level config.", new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        }
        catch (Exception exception) {
            try {
                TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "test", "--config", "message.format.version=boom"}));
                TopicCommand$.MODULE$.createTopic(this.zkClient(), createOpts);
                throw this.fail("Expected exception on invalid topic-level config.", new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
            }
            catch (ConfigException configException) {
                return;
            }
        }
    }

    @Test
    public void testDescribeAndListTopicsWithoutInternalTopics() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        String topic = "testDescribeAndListTopicsWithoutInternalTopics";
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand$.MODULE$.createTopic(this.zkClient(), new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", topic})));
        TopicCommand$.MODULE$.createTopic(this.zkClient(), new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"})));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TopicCommand$.MODULE$.describeTopic(this.$outer.zkClient(), new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--describe", "--exclude-internal"})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertTrue((boolean)output.contains(topic));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
        output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TopicCommand$.MODULE$.listTopics(this.$outer.zkClient(), new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--list", "--exclude-internal"})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertTrue((boolean)output.contains(topic));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    public final void kafka$admin$TopicCommandTest$$describeTopicsWithConfig$1() {
        TopicCommand$.MODULE$.describeTopic(this.zkClient(), new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--describe"})));
    }

    public final void kafka$admin$TopicCommandTest$$describeTopicsNoConfig$1() {
        TopicCommand$.MODULE$.describeTopic(this.zkClient(), new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--describe", "--unavailable-partitions"})));
    }

    public final void kafka$admin$TopicCommandTest$$listTopics$1() {
        TopicCommand$.MODULE$.listTopics(this.zkClient(), new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--list"})));
    }

    public TopicCommandTest() {
        RackAwareTest$class.$init$(this);
    }
}

