/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import joptsimple.OptionException;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommandTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.GroupNotEmptyException;
import org.apache.kafka.common.protocol.Errors;
import org.junit.Assert;
import org.junit.Test;
import scala.Array$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001-3A!\u0001\u0002\u0001\u000f\tAB)\u001a7fi\u0016\u001cuN\\:v[\u0016\u0014xI]8vaN$Vm\u001d;\u000b\u0005\r!\u0011!B1e[&t'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u0013)i\u0011AA\u0005\u0003\u0017\t\u0011\u0001dQ8ogVlWM]$s_V\u00048i\\7nC:$G+Z:u\u0011\u0015i\u0001\u0001\"\u0001\u000f\u0003\u0019a\u0014N\\5u}Q\tq\u0002\u0005\u0002\n\u0001!)\u0011\u0003\u0001C\u0001%\u0005IB/Z:u\t\u0016dW\r^3XSRDGk\u001c9jG>\u0003H/[8o)\u0005\u0019\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"\u0001B+oSRDC\u0001\u0005\u000e#GA\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002?\u0005\u0019qN]4\n\u0005\u0005b\"\u0001\u0002+fgR\f\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0002IA\u0011Q\u0005K\u0007\u0002M)\tq%\u0001\u0006k_B$8/[7qY\u0016L!!\u000b\u0014\u0003\u001f=\u0003H/[8o\u000bb\u001cW\r\u001d;j_:DQa\u000b\u0001\u0005\u0002I\tQ\u0004^3ti\u0012+G.\u001a;f\u00076$gj\u001c8Fq&\u001cH/\u001b8h\u000fJ|W\u000f\u001d\u0015\u0003UiAQA\f\u0001\u0005\u0002I\t!\u0004^3ti\u0012+G.\u001a;f\u001d>tW\t_5ti&twm\u0012:pkBD#!\f\u000e\t\u000bE\u0002A\u0011\u0001\n\u00025Q,7\u000f\u001e#fY\u0016$XmQ7e\u001d>tW)\u001c9us\u001e\u0013x.\u001e9)\u0005AR\u0002\"\u0002\u001b\u0001\t\u0003\u0011\u0012a\u0006;fgR$U\r\\3uK:{g.R7qif<%o\\;qQ\t\u0019$\u0004C\u00038\u0001\u0011\u0005!#A\fuKN$H)\u001a7fi\u0016\u001cU\u000eZ#naRLxI]8va\"\u0012aG\u0007\u0005\u0006u\u0001!\tAE\u0001\u0015i\u0016\u001cH\u000fR3mKR,W)\u001c9us\u001e\u0013x.\u001e9)\u0005eR\u0002\"B\u001f\u0001\t\u0003\u0011\u0012!\n;fgR$U\r\\3uK\u000ekGmV5uQ6K\u0007p\u00144Tk\u000e\u001cWm]:B]\u0012,%O]8sQ\ta$\u0004C\u0003A\u0001\u0011\u0005!#\u0001\u0012uKN$H)\u001a7fi\u0016<\u0016\u000e\u001e5NSb|emU;dG\u0016\u001c8/\u00118e\u000bJ\u0014xN\u001d\u0015\u0003\u007fiAQa\u0011\u0001\u0005\u0002I\tA\u0005^3ti\u0012+G.\u001a;f\u00076$w+\u001b;i'\"|'\u000f^%oSRL\u0017\r\\5{CRLwN\u001c\u0015\u0003\u0005jAQA\u0012\u0001\u0005\u0002I\t\u0011\u0005^3ti\u0012+G.\u001a;f/&$\bn\u00155peRLe.\u001b;jC2L'0\u0019;j_:D#!\u0012\u000e\t\u000b%\u0003A\u0011\u0001\n\u0002WQ,7\u000f\u001e#fY\u0016$XmV5uQVs'/Z2pO:L'0\u001a3OK^\u001cuN\\:v[\u0016\u0014x\n\u001d;j_:DC\u0001\u0013\u000e#G\u0001")
public class DeleteConsumerGroupsTest
extends ConsumerGroupCommandTest {
    @Test(expected=OptionException.class)
    public void testDeleteWithTopicOption() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group(), "--topic"});
        this.getConsumerGroupService(cgcArgs);
    }

    @Test
    public void testDeleteCmdNonExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", missingGroup});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final ConsumerGroupCommand.ConsumerGroupService service$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.service$1.deleteGroups();
            }
            {
                this.service$1 = service$1;
            }
        });
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The expected error (", ") was not detected while deleting consumer group"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Errors.GROUP_ID_NOT_FOUND})), (output.contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Group '", "' could not be deleted due to:"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{missingGroup}))) && output.contains(Errors.GROUP_ID_NOT_FOUND.message()) ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteNonExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", missingGroup});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        Map result = service.deleteGroups();
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The expected error (", ") was not detected while deleting consumer group"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Errors.GROUP_ID_NOT_FOUND})), (result.size() == 1 && result.keySet().contains((Object)missingGroup) && ((Throwable)result.get((Object)missingGroup).get()).getCause() instanceof GroupIdNotFoundException ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteCmdNonEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        Serializable x$1 = new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupsTest $outer;
            private final ConsumerGroupCommand.ConsumerGroupService service$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.service$2.listGroups().contains((Object)this.$outer.group());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.service$2 = service$2;
            }
        };
        Serializable x$2 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The group did not initialize as expected.";
            }
        };
        int x$3 = 3;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$1, (Function0<String>)x$2, x$4, x$5, x$3);
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final ConsumerGroupCommand.ConsumerGroupService service$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.service$2.deleteGroups();
            }
            {
                this.service$2 = service$2;
            }
        });
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The expected error (", ") was not detected while deleting consumer group"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Errors.NON_EMPTY_GROUP})), (output.contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Group '", "' could not be deleted due to:"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group()}))) && output.contains(Errors.NON_EMPTY_GROUP.message()) ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteNonEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        Serializable x$6 = new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupsTest $outer;
            private final ConsumerGroupCommand.ConsumerGroupService service$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.service$3.listGroups().contains((Object)this.$outer.group());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.service$3 = service$3;
            }
        };
        Serializable x$7 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The group did not initialize as expected.";
            }
        };
        int x$8 = 3;
        long x$9 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$10 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$6, (Function0<String>)x$7, x$9, x$10, x$8);
        Map result = service.deleteGroups();
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The expected error (", ") was not detected while deleting consumer group"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Errors.NON_EMPTY_GROUP})), (result.size() == 1 && result.keySet().contains((Object)this.group()) && ((Throwable)result.get((Object)this.group()).get()).getCause() instanceof GroupNotEmptyException ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteCmdEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        Serializable x$11 = new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupsTest $outer;
            private final ConsumerGroupCommand.ConsumerGroupService service$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.service$4.listGroups().contains((Object)this.$outer.group());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.service$4 = service$4;
            }
        };
        Serializable x$12 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The group did not initialize as expected.";
            }
        };
        int x$13 = 3;
        long x$14 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$15 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$11, (Function0<String>)x$12, x$14, x$15, x$13);
        executor.shutdown();
        Serializable x$16 = new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final ConsumerGroupCommand.ConsumerGroupService service$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                String string = this.service$4.collectGroupState().state();
                String string2 = "Empty";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.service$4 = service$4;
            }
        };
        Serializable x$17 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The group did become empty as expected.";
            }
        };
        int x$18 = 3;
        long x$19 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$20 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$16, (Function0<String>)x$17, x$19, x$20, x$18);
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final ConsumerGroupCommand.ConsumerGroupService service$4;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.service$4.deleteGroups();
            }
            {
                this.service$4 = service$4;
            }
        });
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The consumer group could not be deleted as expected"})).s((Seq)Nil$.MODULE$), (boolean)output.contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deletion of requested consumer groups ('", "') was successful."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group()}))));
    }

    @Test
    public void testDeleteEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        Serializable x$21 = new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupsTest $outer;
            private final ConsumerGroupCommand.ConsumerGroupService service$5;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.service$5.listGroups().contains((Object)this.$outer.group());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.service$5 = service$5;
            }
        };
        Serializable x$22 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The group did not initialize as expected.";
            }
        };
        int x$23 = 3;
        long x$24 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$25 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$21, (Function0<String>)x$22, x$24, x$25, x$23);
        executor.shutdown();
        Serializable x$26 = new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final ConsumerGroupCommand.ConsumerGroupService service$5;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                String string = this.service$5.collectGroupState().state();
                String string2 = "Empty";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.service$5 = service$5;
            }
        };
        Serializable x$27 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The group did become empty as expected.";
            }
        };
        int x$28 = 3;
        long x$29 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$30 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$26, (Function0<String>)x$27, x$29, x$30, x$28);
        Map result = service.deleteGroups();
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The consumer group could not be deleted as expected"})).s((Seq)Nil$.MODULE$), (result.size() == 1 && result.keySet().contains((Object)this.group()) && result.get((Object)this.group()).get() == null ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteCmdWithMixOfSuccessAndError() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        Serializable x$31 = new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupsTest $outer;
            private final ConsumerGroupCommand.ConsumerGroupService service$6;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.service$6.listGroups().contains((Object)this.$outer.group());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.service$6 = service$6;
            }
        };
        Serializable x$32 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The group did not initialize as expected.";
            }
        };
        int x$33 = 3;
        long x$34 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$35 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$31, (Function0<String>)x$32, x$34, x$35, x$33);
        executor.shutdown();
        Serializable x$36 = new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final ConsumerGroupCommand.ConsumerGroupService service$6;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                String string = this.service$6.collectGroupState().state();
                String string2 = "Empty";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.service$6 = service$6;
            }
        };
        Serializable x$37 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The group did become empty as expected.";
            }
        };
        int x$38 = 3;
        long x$39 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$40 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$36, (Function0<String>)x$37, x$39, x$40, x$38);
        ConsumerGroupCommand.ConsumerGroupService service2 = this.getConsumerGroupService((String[])Predef$.MODULE$.refArrayOps((Object[])cgcArgs).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--group", missingGroup}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this, service2){
            public static final long serialVersionUID = 0L;
            private final ConsumerGroupCommand.ConsumerGroupService service2$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.service2$1.deleteGroups();
            }
            {
                this.service2$1 = service2$1;
            }
        });
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The consumer group deletion did not work as expected"})).s((Seq)Nil$.MODULE$), (output.contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Group '", "' could not be deleted due to:"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{missingGroup}))) && output.contains(Errors.GROUP_ID_NOT_FOUND.message()) && output.contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"These consumer groups were deleted successfully: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group()}))) ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteWithMixOfSuccessAndError() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        Serializable x$41 = new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupsTest $outer;
            private final ConsumerGroupCommand.ConsumerGroupService service$7;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.service$7.listGroups().contains((Object)this.$outer.group());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.service$7 = service$7;
            }
        };
        Serializable x$42 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The group did not initialize as expected.";
            }
        };
        int x$43 = 3;
        long x$44 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$45 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$41, (Function0<String>)x$42, x$44, x$45, x$43);
        executor.shutdown();
        Serializable x$46 = new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final ConsumerGroupCommand.ConsumerGroupService service$7;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                String string = this.service$7.collectGroupState().state();
                String string2 = "Empty";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.service$7 = service$7;
            }
        };
        Serializable x$47 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The group did become empty as expected.";
            }
        };
        int x$48 = 3;
        long x$49 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$50 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$46, (Function0<String>)x$47, x$49, x$50, x$48);
        ConsumerGroupCommand.ConsumerGroupService service2 = this.getConsumerGroupService((String[])Predef$.MODULE$.refArrayOps((Object[])cgcArgs).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--group", missingGroup}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        Map result = service2.deleteGroups();
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The consumer group deletion did not work as expected"})).s((Seq)Nil$.MODULE$), (result.size() == 2 && result.keySet().contains((Object)this.group()) && result.get((Object)this.group()).get() == null && result.keySet().contains((Object)missingGroup) && ((Throwable)result.get((Object)missingGroup).get()).getMessage().contains(Errors.GROUP_ID_NOT_FOUND.message()) ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteCmdWithShortInitialization() {
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final ConsumerGroupCommand.ConsumerGroupService service$8;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.service$8.deleteGroups();
            }
            {
                this.service$8 = service$8;
            }
        });
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The consumer group deletion did not work as expected"})).s((Seq)Nil$.MODULE$), (boolean)output.contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Group '", "' could not be deleted due to"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group()}))));
    }

    @Test
    public void testDeleteWithShortInitialization() {
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        Map result = service.deleteGroups();
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The consumer group deletion did not work as expected"})).s((Seq)Nil$.MODULE$), (result.size() == 1 && result.keySet().contains((Object)this.group()) ? 1 : 0) != 0);
    }

    @Test(expected=OptionException.class)
    public void testDeleteWithUnrecognizedNewConsumerOption() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--new-consumer", "--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        this.getConsumerGroupService(cgcArgs);
    }
}

