/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareTest;
import kafka.admin.RackAwareTest$class;
import kafka.admin.ReplicaDistributions;
import kafka.utils.Logging;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Range;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001U3A!\u0001\u0002\u0001\u000f\t\u0011\u0012\tZ7j]J\u000b7m[!xCJ,G+Z:u\u0015\t\u0019A!A\u0003bI6LgNC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001\u0005\u000f%A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\t\u000e\u0003\tI!!\u0005\u0002\u0003\u001bI\u000b7m[!xCJ,G+Z:u!\t\u0019b#D\u0001\u0015\u0015\t)B!A\u0003vi&d7/\u0003\u0002\u0018)\t9Aj\\4hS:<\u0007\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ty\u0001\u0001C\u0003\u001e\u0001\u0011\u0005a$A\u001duKN$x)\u001a;SC\u000e\\\u0017\t\u001c;fe:\fG/\u001a3Ce>\\WM\u001d'jgR\fe\u000eZ!tg&<gNU3qY&\u001c\u0017m\u001d+p\u0005J|7.\u001a:t)\u0005y\u0002CA\u0005!\u0013\t\t#B\u0001\u0003V]&$\bF\u0001\u000f$!\t!\u0013&D\u0001&\u0015\t1s%A\u0003kk:LGOC\u0001)\u0003\ry'oZ\u0005\u0003U\u0015\u0012A\u0001V3ti\")A\u0006\u0001C\u0001=\u0005YB/Z:u\u0003N\u001c\u0018n\u001a8nK:$x+\u001b;i%\u0006\u001c7.Q<be\u0016D#aK\u0012\t\u000b=\u0002A\u0011\u0001\u0010\u0002_Q,7\u000f^!tg&<g.\\3oi^KG\u000f\u001b*bG.\fu/\u0019:f/&$\bNU1oI>l7\u000b^1si&sG-\u001a=)\u00059\u001a\u0003\"\u0002\u001a\u0001\t\u0003q\u0012!\f;fgR\f5o]5h]6,g\u000e^,ji\"\u0014\u0016mY6Bo\u0006\u0014XmV5uQVsWM^3o%\u0016\u0004H.[2bg\"\u0012\u0011g\t\u0005\u0006k\u0001!\tAH\u0001+i\u0016\u001cH/Q:tS\u001etW.\u001a8u/&$\bNU1dW\u0006;\u0018M]3XSRDWK\\3wK:\u0014\u0016mY6tQ\t!4\u0005C\u00039\u0001\u0011\u0005a$\u0001\u0013uKN$\u0018i]:jO:lWM\u001c;XSRD'GU3qY&\u001c\u0017m\u001d*bG.\fu/\u0019:fQ\t94\u0005C\u0003<\u0001\u0011\u0005a$\u0001\fuKN$(+Y2l\u0003^\f'/Z#ya\u0006t7/[8oQ\tQ4\u0005C\u0003?\u0001\u0011\u0005a$A\u001auKN$\u0018i]:jO:lWM\u001c;XSRD'GU3qY&\u001c\u0017m\u001d*bG.\fu/\u0019:f/&$\bN\u000e)beRLG/[8og\"\u0012Qh\t\u0005\u0006\u0003\u0002!\tAH\u0001?i\u0016\u001cH/Q:tS\u001etW.\u001a8u/&$\bN\r*fa2L7-Y:SC\u000e\\\u0017i^1sK^KG\u000f\u001b\u001cQCJ$\u0018\u000e^5p]N\fe\u000eZ\u001aCe>\\WM]:)\u0005\u0001\u001b\u0003\"\u0002#\u0001\t\u0003q\u0012a\t;fgRd\u0015M]4f\u001dVl'-\u001a:QCJ$\u0018\u000e^5p]N\f5o]5h]6,g\u000e\u001e\u0015\u0003\u0007\u000eBQa\u0012\u0001\u0005\u0002y\t\u0011\u0004^3ti6{'/\u001a*fa2L7-Y:UQ\u0006t'+Y2lg\"\u0012ai\t\u0005\u0006\u0015\u0002!\tAH\u0001\u001ai\u0016\u001cH\u000fT3tgJ+\u0007\u000f\\5dCN$\u0006.\u00198SC\u000e\\7\u000f\u000b\u0002JG!)Q\n\u0001C\u0001=\u0005qA/Z:u'&tw\r\\3SC\u000e\\\u0007F\u0001'$\u0011\u0015\u0001\u0006\u0001\"\u0001\u001f\u0003!\"Xm\u001d;TW&\u0004(I]8lKJ<\u0016\u000e\u001e5SKBd\u0017nY1BYJ,\u0017\rZ=BgNLwM\\3eQ\ty5\u0005C\u0003T\u0001\u0011\u0005a$A\u000buKN$(+\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;)\u0005I\u001b\u0003")
public class AdminRackAwareTest
implements RackAwareTest,
Logging {
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        AdminRackAwareTest adminRackAwareTest = this;
        synchronized (adminRackAwareTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.class.msgWithLogIdent((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment2, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest$class.checkReplicaDistribution(this, assignment2, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment2, Map<Object, String> brokerRackMapping) {
        return RackAwareTest$class.getReplicaDistribution(this, assignment2, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest$class.toBrokerMetadata(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest$class.toBrokerMetadata$default$2(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest$class.checkReplicaDistribution$default$6(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest$class.checkReplicaDistribution$default$7(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest$class.checkReplicaDistribution$default$8(this);
    }

    @Test
    public void testGetRackAlternatedBrokerListAndAssignReplicasToBrokers() {
        Map rackMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack1")}));
        IndexedSeq newList = AdminUtils$.MODULE$.getRackAlternatedBrokerList(rackMap);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 1, 5, 4, 2})), (Object)newList);
        IndexedSeq anotherList = AdminUtils$.MODULE$.getRackAlternatedBrokerList(rackMap.$minus((Object)BoxesRunTime.boxToInteger((int)5)));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 1, 4, 2})), (Object)anotherList);
        Map assignment2 = AdminUtils$.MODULE$.assignReplicasToBrokers(this.toBrokerMetadata((Map<Object, String>)rackMap, this.toBrokerMetadata$default$2()), 7, 3, 0, 0);
        Map expected = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 5}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 4, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 4, 2})))}));
        Assert.assertEquals((Object)expected, (Object)assignment2);
    }

    @Test
    public void testAssignmentWithRackAware() {
        Map brokerRackMapping = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack1")}));
        int numPartitions = 6;
        int replicationFactor = 3;
        Map assignment2 = AdminUtils$.MODULE$.assignReplicasToBrokers(this.toBrokerMetadata((Map<Object, String>)brokerRackMapping, this.toBrokerMetadata$default$2()), numPartitions, replicationFactor, 2, 0);
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment2, (Map<Object, String>)brokerRackMapping, brokerRackMapping.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @Test
    public void testAssignmentWithRackAwareWithRandomStartIndex() {
        Map brokerRackMapping = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack1")}));
        int numPartitions = 6;
        int replicationFactor = 3;
        Map assignment2 = AdminUtils$.MODULE$.assignReplicasToBrokers(this.toBrokerMetadata((Map<Object, String>)brokerRackMapping, this.toBrokerMetadata$default$2()), numPartitions, replicationFactor, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment2, (Map<Object, String>)brokerRackMapping, brokerRackMapping.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @Test
    public void testAssignmentWithRackAwareWithUnevenReplicas() {
        Map assignment2;
        Map brokerRackMapping = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack1")}));
        int numPartitions = 13;
        int replicationFactor = 3;
        Map x$6 = assignment2 = AdminUtils$.MODULE$.assignReplicasToBrokers(this.toBrokerMetadata((Map<Object, String>)brokerRackMapping, this.toBrokerMetadata$default$2()), numPartitions, replicationFactor, 0, 0);
        Map x$7 = brokerRackMapping;
        int x$8 = brokerRackMapping.size();
        int x$9 = numPartitions;
        int x$10 = replicationFactor;
        boolean x$11 = false;
        boolean x$12 = false;
        boolean x$13 = this.checkReplicaDistribution$default$6();
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)x$6, (Map<Object, String>)x$7, x$8, x$9, x$10, x$13, x$11, x$12);
    }

    @Test
    public void testAssignmentWithRackAwareWithUnevenRacks() {
        Map assignment2;
        Map brokerRackMapping = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack1")}));
        int numPartitions = 12;
        int replicationFactor = 3;
        Map x$14 = assignment2 = AdminUtils$.MODULE$.assignReplicasToBrokers(this.toBrokerMetadata((Map<Object, String>)brokerRackMapping, this.toBrokerMetadata$default$2()), numPartitions, replicationFactor, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
        Map x$15 = brokerRackMapping;
        int x$16 = brokerRackMapping.size();
        int x$17 = numPartitions;
        int x$18 = replicationFactor;
        boolean x$19 = false;
        boolean x$20 = this.checkReplicaDistribution$default$6();
        boolean x$21 = this.checkReplicaDistribution$default$7();
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)x$14, (Map<Object, String>)x$15, x$16, x$17, x$18, x$20, x$21, x$19);
    }

    @Test
    public void testAssignmentWith2ReplicasRackAware() {
        Map brokerRackMapping = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack1")}));
        int numPartitions = 12;
        int replicationFactor = 2;
        Map assignment2 = AdminUtils$.MODULE$.assignReplicasToBrokers(this.toBrokerMetadata((Map<Object, String>)brokerRackMapping, this.toBrokerMetadata$default$2()), numPartitions, replicationFactor, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment2, (Map<Object, String>)brokerRackMapping, brokerRackMapping.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @Test
    public void testRackAwareExpansion() {
        Map brokerRackMapping = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)"rack1")}));
        int numPartitions = 12;
        int replicationFactor = 2;
        Seq<BrokerMetadata> x$22 = this.toBrokerMetadata((Map<Object, String>)brokerRackMapping, this.toBrokerMetadata$default$2());
        int x$23 = numPartitions;
        int x$24 = replicationFactor;
        int x$25 = 12;
        int x$26 = AdminUtils$.MODULE$.assignReplicasToBrokers$default$4();
        Map assignment2 = AdminUtils$.MODULE$.assignReplicasToBrokers(x$22, x$23, x$24, x$26, x$25);
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment2, (Map<Object, String>)brokerRackMapping, brokerRackMapping.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @Test
    public void testAssignmentWith2ReplicasRackAwareWith6Partitions() {
        Map brokerRackMapping = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack1")}));
        int numPartitions = 6;
        int replicationFactor = 2;
        Map assignment2 = AdminUtils$.MODULE$.assignReplicasToBrokers(this.toBrokerMetadata((Map<Object, String>)brokerRackMapping, this.toBrokerMetadata$default$2()), numPartitions, replicationFactor, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment2, (Map<Object, String>)brokerRackMapping, brokerRackMapping.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @Test
    public void testAssignmentWith2ReplicasRackAwareWith6PartitionsAnd3Brokers() {
        Map brokerRackMapping = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3")}));
        int numPartitions = 3;
        int replicationFactor = 2;
        Map assignment2 = AdminUtils$.MODULE$.assignReplicasToBrokers(this.toBrokerMetadata((Map<Object, String>)brokerRackMapping, this.toBrokerMetadata$default$2()), numPartitions, replicationFactor, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment2, (Map<Object, String>)brokerRackMapping, brokerRackMapping.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @Test
    public void testLargeNumberPartitionsAssignment() {
        int numPartitions = 96;
        int replicationFactor = 3;
        Map brokerRackMapping = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)"rack3")}));
        Map assignment2 = AdminUtils$.MODULE$.assignReplicasToBrokers(this.toBrokerMetadata((Map<Object, String>)brokerRackMapping, this.toBrokerMetadata$default$2()), numPartitions, replicationFactor, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment2, (Map<Object, String>)brokerRackMapping, brokerRackMapping.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @Test
    public void testMoreReplicasThanRacks() {
        int numPartitions = 6;
        int replicationFactor = 5;
        Map brokerRackMapping = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack2")}));
        Map assignment2 = AdminUtils$.MODULE$.assignReplicasToBrokers(this.toBrokerMetadata((Map<Object, String>)brokerRackMapping, this.toBrokerMetadata$default$2()), numPartitions, replicationFactor, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
        Assert.assertEquals((Object)List$.MODULE$.fill(assignment2.size(), (Function0)new Serializable(this, replicationFactor){
            public static final long serialVersionUID = 0L;
            private final int replicationFactor$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.replicationFactor$1;
            }
            {
                this.replicationFactor$1 = replicationFactor$1;
            }
        }), (Object)assignment2.values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Seq<Object> x$1) {
                return x$1.size();
            }
        }, Iterable$.MODULE$.canBuildFrom()));
        ReplicaDistributions distribution = this.getReplicaDistribution((Map<Object, Seq<Object>>)assignment2, (Map<Object, String>)brokerRackMapping);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)new Serializable(this, distribution){
            public static final long serialVersionUID = 0L;
            private final ReplicaDistributions distribution$1;

            public final void apply(int partition) {
                this.apply$mcVI$sp(partition);
            }

            public void apply$mcVI$sp(int partition) {
                Assert.assertEquals((long)3L, (long)((TraversableOnce)this.distribution$1.partitionRacks().apply((Object)BoxesRunTime.boxToInteger((int)partition))).toSet().size());
            }
            {
                this.distribution$1 = distribution$1;
            }
        });
    }

    @Test
    public void testLessReplicasThanRacks() {
        int numPartitions = 6;
        int replicationFactor = 2;
        Map brokerRackMapping = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack2")}));
        Map assignment2 = AdminUtils$.MODULE$.assignReplicasToBrokers(this.toBrokerMetadata((Map<Object, String>)brokerRackMapping, this.toBrokerMetadata$default$2()), numPartitions, replicationFactor, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
        Assert.assertEquals((Object)List$.MODULE$.fill(assignment2.size(), (Function0)new Serializable(this, replicationFactor){
            public static final long serialVersionUID = 0L;
            private final int replicationFactor$2;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.replicationFactor$2;
            }
            {
                this.replicationFactor$2 = replicationFactor$2;
            }
        }), (Object)assignment2.values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Seq<Object> x$2) {
                return x$2.size();
            }
        }, Iterable$.MODULE$.canBuildFrom()));
        ReplicaDistributions distribution = this.getReplicaDistribution((Map<Object, Seq<Object>>)assignment2, (Map<Object, String>)brokerRackMapping);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)new Serializable(this, distribution){
            public static final long serialVersionUID = 0L;
            private final ReplicaDistributions distribution$2;

            public final void apply(int partition) {
                this.apply$mcVI$sp(partition);
            }

            public void apply$mcVI$sp(int partition) {
                Assert.assertEquals((long)2L, (long)((TraversableOnce)this.distribution$2.partitionRacks().apply((Object)BoxesRunTime.boxToInteger((int)partition))).toSet().size());
            }
            {
                this.distribution$2 = distribution$2;
            }
        });
    }

    @Test
    public void testSingleRack() {
        int numPartitions = 6;
        int replicationFactor = 3;
        Map brokerRackMapping = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack1")}));
        Map assignment2 = AdminUtils$.MODULE$.assignReplicasToBrokers(this.toBrokerMetadata((Map<Object, String>)brokerRackMapping, this.toBrokerMetadata$default$2()), numPartitions, replicationFactor, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
        Assert.assertEquals((Object)List$.MODULE$.fill(assignment2.size(), (Function0)new Serializable(this, replicationFactor){
            public static final long serialVersionUID = 0L;
            private final int replicationFactor$3;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.replicationFactor$3;
            }
            {
                this.replicationFactor$3 = replicationFactor$3;
            }
        }), (Object)assignment2.values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Seq<Object> x$3) {
                return x$3.size();
            }
        }, Iterable$.MODULE$.canBuildFrom()));
        ReplicaDistributions distribution = this.getReplicaDistribution((Map<Object, Seq<Object>>)assignment2, (Map<Object, String>)brokerRackMapping);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)new Serializable(this, distribution){
            public static final long serialVersionUID = 0L;
            private final ReplicaDistributions distribution$3;

            public final void apply(int partition) {
                this.apply$mcVI$sp(partition);
            }

            public void apply$mcVI$sp(int partition) {
                Assert.assertEquals((long)1L, (long)((TraversableOnce)this.distribution$3.partitionRacks().apply((Object)BoxesRunTime.boxToInteger((int)partition))).toSet().size());
            }
            {
                this.distribution$3 = distribution$3;
            }
        });
        brokerRackMapping.keys().foreach((Function1)new Serializable(this, distribution){
            public static final long serialVersionUID = 0L;
            private final ReplicaDistributions distribution$3;

            public final void apply(int broker) {
                this.apply$mcVI$sp(broker);
            }

            public void apply$mcVI$sp(int broker) {
                Assert.assertEquals((long)1L, (long)BoxesRunTime.unboxToInt((Object)this.distribution$3.brokerLeaderCount().apply((Object)BoxesRunTime.boxToInteger((int)broker))));
            }
            {
                this.distribution$3 = distribution$3;
            }
        });
    }

    @Test
    public void testSkipBrokerWithReplicaAlreadyAssigned() {
        Map rackInfo = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"b"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"c"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"a")}));
        Range.Inclusive brokerList = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4);
        int numPartitions = 6;
        int replicationFactor = 4;
        Seq<BrokerMetadata> brokerMetadatas = this.toBrokerMetadata((Map<Object, String>)rackInfo, this.toBrokerMetadata$default$2());
        Assert.assertEquals((Object)brokerList, (Object)brokerMetadatas.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(BrokerMetadata x$4) {
                return x$4.id();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        Map assignment2 = AdminUtils$.MODULE$.assignReplicasToBrokers(brokerMetadatas, numPartitions, replicationFactor, 2, AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment2, (Map<Object, String>)rackInfo, 5, 6, 4, false, false, false);
    }

    @Test
    public void testReplicaAssignment() {
        scala.collection.immutable.IndexedSeq brokerMetadatas = (scala.collection.immutable.IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(int x$5) {
                return new BrokerMetadata(x$5, (Option)None$.MODULE$);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, brokerMetadatas){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.IndexedSeq brokerMetadatas$1;

            public final Map<Object, Seq<Object>> apply() {
                return AdminUtils$.MODULE$.assignReplicasToBrokers((Seq)this.brokerMetadatas$1, 10, 0, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
            }
            {
                this.brokerMetadatas$1 = brokerMetadatas$1;
            }
        }, ClassTag$.MODULE$.apply(InvalidReplicationFactorException.class), new Position("AdminRackAwareTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, brokerMetadatas){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.IndexedSeq brokerMetadatas$1;

            public final Map<Object, Seq<Object>> apply() {
                return AdminUtils$.MODULE$.assignReplicasToBrokers((Seq)this.brokerMetadatas$1, 10, 6, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
            }
            {
                this.brokerMetadatas$1 = brokerMetadatas$1;
            }
        }, ClassTag$.MODULE$.apply(InvalidReplicationFactorException.class), new Position("AdminRackAwareTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
        Map expectedAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 1, 2})))}));
        Map actualAssignment = AdminUtils$.MODULE$.assignReplicasToBrokers((Seq)brokerMetadatas, 10, 3, 0, AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
        Assert.assertEquals((Object)expectedAssignment, (Object)actualAssignment);
    }

    public AdminRackAwareTest() {
        RackAwareTest$class.$init$(this);
        Logging.class.$init$((Logging)this);
    }
}

