/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import kafka.Kafka$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.Exit$;
import org.apache.kafka.common.internals.FatalExitError;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0001\u0002\u0001\u000b\tI1*\u00194lCR+7\u000f\u001e\u0006\u0002\u0007\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0007!\t9!\"D\u0001\t\u0015\u0005I\u0011!B:dC2\f\u0017BA\u0006\t\u0005\u0019\te.\u001f*fM\")Q\u0002\u0001C\u0001\u001d\u00051A(\u001b8jiz\"\u0012a\u0004\t\u0003!\u0001i\u0011A\u0001\u0005\u0006%\u0001!\taE\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002)A\u0011q!F\u0005\u0003-!\u0011A!\u00168ji\"\u0012\u0011\u0003\u0007\t\u00033yi\u0011A\u0007\u0006\u00037q\tQA[;oSRT\u0011!H\u0001\u0004_J<\u0017BA\u0010\u001b\u0005\u0019\u0011UMZ8sK\")\u0011\u0005\u0001C\u0001'\u0005AA/Z1s\t><h\u000e\u000b\u0002!GA\u0011\u0011\u0004J\u0005\u0003Ki\u0011Q!\u00114uKJDQa\n\u0001\u0005\u0002M\t!\u0004^3ti\u001e+GoS1gW\u0006\u001cuN\u001c4jO\u001a\u0013x.\\!sOND#AJ\u0015\u0011\u0005eQ\u0013BA\u0016\u001b\u0005\u0011!Vm\u001d;\t\u000b5\u0002A\u0011A\n\u0002SQ,7\u000f^$fi.\u000bgm[1D_:4\u0017n\u001a$s_6\f%oZ:O_:\f%oZ:BiRCW-\u00128eQ\u0011a\u0013f\f\u0019\u0002\u0011\u0015D\b/Z2uK\u0012\u001c\u0013!\r\t\u0003eij\u0011a\r\u0006\u0003iU\n\u0011\"\u001b8uKJt\u0017\r\\:\u000b\u0005Y:\u0014AB2p[6|gN\u0003\u0002\u0004q)\u0011\u0011\bH\u0001\u0007CB\f7\r[3\n\u0005m\u001a$A\u0004$bi\u0006dW\t_5u\u000bJ\u0014xN\u001d\u0005\u0006{\u0001!\taE\u0001&i\u0016\u001cHoR3u\u0017\u000647.Y\"p]\u001aLwM\u0012:p[\u0006\u0013xm\u001d(p]\u0006\u0013xm](oYfDC\u0001P\u00150a!)\u0001\t\u0001C\u0001'\u0005iC/Z:u\u000f\u0016$8*\u00194lC\u000e{gNZ5h\rJ|W.\u0011:hg:{g.\u0011:hg\u0006#H\u000b[3CK\u001e<\u0017N\\4)\t}Js\u0006\r\u0005\u0006\u0007\u0002!\taE\u0001\u0016i\u0016\u001cHoS1gW\u0006\u001c6\u000f\u001c)bgN<xN\u001d3tQ\t\u0011\u0015\u0006C\u0003G\u0001\u0011\u00051#\u0001\u0011uKN$8*\u00194lCN\u001bH\u000eU1tg^|'\u000fZ:XSRD7+_7c_2\u001c\bFA#*\u0011\u0015I\u0005\u0001\"\u0001K\u0003Q\u0001(/\u001a9be\u0016$UMZ1vYR\u001cuN\u001c4jOR\t1\n\u0005\u0002M\u001f:\u0011q!T\u0005\u0003\u001d\"\ta\u0001\u0015:fI\u00164\u0017B\u0001)R\u0005\u0019\u0019FO]5oO*\u0011a\n\u0003\u0005\u0006'\u0002!\t\u0001V\u0001\u000eaJ,\u0007/\u0019:f\u0007>tg-[4\u0015\u0005-+\u0006\"\u0002,S\u0001\u00049\u0016!\u00027j]\u0016\u001c\bcA\u0004Y\u0017&\u0011\u0011\f\u0003\u0002\u0006\u0003J\u0014\u0018-\u001f")
public class KafkaTest {
    @Before
    public void setUp() {
        Exit$.MODULE$.setExitProcedure((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(int status, Option<String> x$1) {
                throw new FatalExitError(status);
            }
        });
    }

    @After
    public void tearDown() {
        Exit$.MODULE$.resetExitProcedure();
    }

    @Test
    public void testGetKafkaConfigFromArgs() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config1 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile})));
        Assert.assertEquals((long)1L, (long)config1.brokerId());
        KafkaConfig config2 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "broker.id=2"})));
        Assert.assertEquals((long)2L, (long)config2.brokerId());
        KafkaConfig config3 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "log.cleanup.policy=compact"})));
        Assert.assertEquals((long)1L, (long)config3.brokerId());
        Assert.assertEquals(Arrays.asList((Object[])new String[]{"compact"}), (Object)config3.logCleanupPolicy());
        KafkaConfig config4 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "log.cleanup.policy=compact,delete", "--override", "broker.id=2"})));
        Assert.assertEquals((long)2L, (long)config4.brokerId());
        Assert.assertEquals(Arrays.asList((Object[])new String[]{"compact", "delete"}), (Object)config4.logCleanupPolicy());
    }

    @Test(expected=FatalExitError.class)
    public void testGetKafkaConfigFromArgsNonArgsAtTheEnd() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "broker.id=1", "broker.id=2"})));
    }

    @Test(expected=FatalExitError.class)
    public void testGetKafkaConfigFromArgsNonArgsOnly() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "broker.id=1", "broker.id=2"})));
    }

    @Test(expected=FatalExitError.class)
    public void testGetKafkaConfigFromArgsNonArgsAtTheBegging() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "broker.id=1", "--override", "broker.id=2"})));
    }

    @Test
    public void testKafkaSslPasswords() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "ssl.keystore.password=keystore_password", "--override", "ssl.key.password=key_password", "--override", "ssl.truststore.password=truststore_password"})));
        Assert.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeyPasswordProp()).toString());
        Assert.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystorePasswordProp()).toString());
        Assert.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).toString());
        Assert.assertEquals((Object)"key_password", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeyPasswordProp()).value());
        Assert.assertEquals((Object)"keystore_password", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystorePasswordProp()).value());
        Assert.assertEquals((Object)"truststore_password", (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
    }

    @Test
    public void testKafkaSslPasswordsWithSymbols() {
        String password = "=!#-+!?*/\"'^%$=\\.,@:;=";
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", new StringBuilder().append((Object)"ssl.keystore.password=").append((Object)password).toString(), "--override", new StringBuilder().append((Object)"ssl.key.password=").append((Object)password).toString(), "--override", new StringBuilder().append((Object)"ssl.truststore.password=").append((Object)password).toString()})));
        Assert.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeyPasswordProp()).toString());
        Assert.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystorePasswordProp()).toString());
        Assert.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).toString());
        Assert.assertEquals((Object)password, (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystorePasswordProp()).value());
        Assert.assertEquals((Object)password, (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeyPasswordProp()).value());
        Assert.assertEquals((Object)password, (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
    }

    public String prepareDefaultConfig() {
        return this.prepareConfig((String[])((Object[])new String[]{"broker.id=1", "zookeeper.connect=somewhere"}));
    }

    /*
     * WARNING - void declaration
     */
    public String prepareConfig(String[] lines) {
        String string;
        File file = File.createTempFile("kafkatest", ".properties");
        file.deleteOnExit();
        OutputStream writer = Files.newOutputStream(file.toPath(), new OpenOption[0]);
        try {
            Predef$.MODULE$.refArrayOps((Object[])lines).foreach((Function1)new Serializable(this, writer){
                public static final long serialVersionUID = 0L;
                private final OutputStream writer$1;

                public final void apply(String l) {
                    this.writer$1.write(l.getBytes());
                    this.writer$1.write("\n".getBytes());
                }
                {
                    this.writer$1 = writer$1;
                }
            });
            string = file.getAbsolutePath();
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        writer.close();
        return string;
    }
}

