/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.util.Collections;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.api.QuotaTestClients;
import kafka.api.QuotaTestClients$;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaType;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ua!B\u0001\u0003\u0003\u00039!!\u0004\"bg\u0016\fVo\u001c;b)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0017\u0013:$Xm\u001a:bi&|g\u000eV3ti\"\u000b'O\\3tg\")Q\u0002\u0001C\u0001\u001d\u00051A(\u001b8jiz\"\u0012a\u0004\t\u0003\u0013\u0001Aq!\u0005\u0001C\u0002\u0013\u0005##A\u0006tKJ4XM]\"pk:$X#A\n\u0011\u0005Q9R\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\u0007%sG\u000f\u0003\u0004\u001b\u0001\u0001\u0006IaE\u0001\rg\u0016\u0014h/\u001a:D_VtG\u000f\t\u0005\b9\u0001\u0011\r\u0011\"\u0001\u0013\u00035\u0001(o\u001c3vG\u0016\u00148i\\;oi\"1a\u0004\u0001Q\u0001\nM\ta\u0002\u001d:pIV\u001cWM]\"pk:$\b\u0005C\u0004!\u0001\t\u0007I\u0011\u0001\n\u0002\u001b\r|gn];nKJ\u001cu.\u001e8u\u0011\u0019\u0011\u0003\u0001)A\u0005'\u0005q1m\u001c8tk6,'oQ8v]R\u0004\u0003\"\u0002\u0013\u0001\t#)\u0013\u0001\u00059s_\u0012,8-\u001a:DY&,g\u000e^%e+\u00051\u0003CA\u0014-\u001b\u0005A#BA\u0015+\u0003\u0011a\u0017M\\4\u000b\u0003-\nAA[1wC&\u0011Q\u0006\u000b\u0002\u0007'R\u0014\u0018N\\4\t\u000b=\u0002A\u0011C\u0013\u0002!\r|gn];nKJ\u001cE.[3oi&#\u0007\"B\u0019\u0001\r#\u0011\u0014AF2sK\u0006$X-U;pi\u0006$Vm\u001d;DY&,g\u000e^:\u0015\u0007M2d\b\u0005\u0002\ni%\u0011QG\u0001\u0002\u0011#V|G/\u0019+fgR\u001cE.[3oiNDQa\u000e\u0019A\u0002a\nQ\u0001^8qS\u000e\u0004\"!\u000f\u001f\u000f\u0005QQ\u0014BA\u001e\u0016\u0003\u0019\u0001&/\u001a3fM&\u0011Q&\u0010\u0006\u0003wUAQa\u0010\u0019A\u0002\u0001\u000b!\u0002\\3bI\u0016\u0014hj\u001c3f!\t\tE)D\u0001C\u0015\t\u0019E!\u0001\u0004tKJ4XM]\u0005\u0003\u000b\n\u00131bS1gW\u0006\u001cVM\u001d<fe\"9q\t\u0001b\u0001\n\u0003\u0011\u0012\u0001\u00063fM\u0006,H\u000e\u001e)s_\u0012,8-\u001a:Rk>$\u0018\r\u0003\u0004J\u0001\u0001\u0006IaE\u0001\u0016I\u00164\u0017-\u001e7u!J|G-^2feF+x\u000e^1!\u0011\u001dY\u0005A1A\u0005\u0002I\tA\u0003Z3gCVdGoQ8ogVlWM])v_R\f\u0007BB'\u0001A\u0003%1#A\u000beK\u001a\fW\u000f\u001c;D_:\u001cX/\\3s#V|G/\u0019\u0011\t\u000f=\u0003!\u0019!C\u0001%\u0005\u0019B-\u001a4bk2$(+Z9vKN$\u0018+^8uC\"1\u0011\u000b\u0001Q\u0001\nM\tA\u0003Z3gCVdGOU3rk\u0016\u001cH/U;pi\u0006\u0004\u0003bB*\u0001\u0005\u0004%\t!J\u0001\u0007i>\u0004\u0018nY\u0019\t\rU\u0003\u0001\u0015!\u0003'\u0003\u001d!x\u000e]5dc\u0001B\u0011b\u0010\u0001A\u0002\u0003\u0007I\u0011A,\u0016\u0003\u0001C\u0011\"\u0017\u0001A\u0002\u0003\u0007I\u0011\u0001.\u0002\u001d1,\u0017\rZ3s\u001d>$Wm\u0018\u0013fcR\u00111L\u0018\t\u0003)qK!!X\u000b\u0003\tUs\u0017\u000e\u001e\u0005\b?b\u000b\t\u00111\u0001A\u0003\rAH%\r\u0005\u0007C\u0002\u0001\u000b\u0015\u0002!\u0002\u00171,\u0017\rZ3s\u001d>$W\r\t\u0005\nG\u0002\u0001\r\u00111A\u0005\u0002]\u000bABZ8mY><XM\u001d(pI\u0016D\u0011\"\u001a\u0001A\u0002\u0003\u0007I\u0011\u00014\u0002!\u0019|G\u000e\\8xKJtu\u000eZ3`I\u0015\fHCA.h\u0011\u001dyF-!AA\u0002\u0001Ca!\u001b\u0001!B\u0013\u0001\u0015!\u00044pY2|w/\u001a:O_\u0012,\u0007\u0005C\u0005l\u0001\u0001\u0007\t\u0019!C\u0001Y\u0006\u0001\u0012/^8uCR+7\u000f^\"mS\u0016tGo]\u000b\u0002g!Ia\u000e\u0001a\u0001\u0002\u0004%\ta\\\u0001\u0015cV|G/\u0019+fgR\u001cE.[3oiN|F%Z9\u0015\u0005m\u0003\bbB0n\u0003\u0003\u0005\ra\r\u0005\u0007e\u0002\u0001\u000b\u0015B\u001a\u0002#E,x\u000e^1UKN$8\t\\5f]R\u001c\b\u0005C\u0003u\u0001\u0011\u0005S/A\u0003tKR,\u0006\u000fF\u0001\\Q\t\u0019x\u000f\u0005\u0002y{6\t\u0011P\u0003\u0002{w\u0006)!.\u001e8ji*\tA0A\u0002pe\u001eL!A`=\u0003\r\t+gm\u001c:f\u0011\u0019\t\t\u0001\u0001C\u0001k\u0006iB/Z:u)\"\u0014x\u000e\u001e;mK\u0012\u0004&o\u001c3vG\u0016\u00148i\u001c8tk6,'\u000fK\u0002\u0000\u0003\u000b\u00012\u0001_A\u0004\u0013\r\tI!\u001f\u0002\u0005)\u0016\u001cH\u000f\u0003\u0004\u0002\u000e\u0001!\t!^\u0001(i\u0016\u001cH\u000f\u0015:pIV\u001cWM]\"p]N,X.\u001a:Pm\u0016\u0014(/\u001b3f+:$\bN]8ui2,G\r\u000b\u0003\u0002\f\u0005\u0015\u0001BBA\n\u0001\u0011\u0005Q/A\fuKN$\u0018+^8uC>3XM\u001d:jI\u0016$U\r\\3uK\"\"\u0011\u0011CA\u0003\u0011\u0019\tI\u0002\u0001C\u0001k\u0006!B/Z:u)\"\u0014x\u000e\u001e;mK\u0012\u0014V-];fgRDC!a\u0006\u0002\u0006\u0001")
public abstract class BaseQuotaTest
extends IntegrationTestHarness {
    private final int serverCount;
    private final int producerCount;
    private final int consumerCount;
    private final int defaultProducerQuota;
    private final int defaultConsumerQuota;
    private final int defaultRequestQuota;
    private final String topic1;
    private KafkaServer leaderNode;
    private KafkaServer followerNode;
    private QuotaTestClients quotaTestClients;

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    @Override
    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int consumerCount() {
        return this.consumerCount;
    }

    public String producerClientId() {
        return "QuotasTestProducer-1";
    }

    public String consumerClientId() {
        return "QuotasTestConsumer-1";
    }

    public abstract QuotaTestClients createQuotaTestClients(String var1, KafkaServer var2);

    public int defaultProducerQuota() {
        return this.defaultProducerQuota;
    }

    public int defaultConsumerQuota() {
        return this.defaultConsumerQuota;
    }

    public int defaultRequestQuota() {
        return this.defaultRequestQuota;
    }

    public String topic1() {
        return this.topic1;
    }

    public KafkaServer leaderNode() {
        return this.leaderNode;
    }

    public void leaderNode_$eq(KafkaServer x$1) {
        this.leaderNode = x$1;
    }

    public KafkaServer followerNode() {
        return this.followerNode;
    }

    public void followerNode_$eq(KafkaServer x$1) {
        this.followerNode = x$1;
    }

    public QuotaTestClients quotaTestClients() {
        return this.quotaTestClients;
    }

    public void quotaTestClients_$eq(QuotaTestClients x$1) {
        this.quotaTestClients = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        int numPartitions = 1;
        Map<Object, Object> leaders = this.createTopic(this.topic1(), numPartitions, this.serverCount(), this.createTopic$default$4());
        this.leaderNode_$eq(BoxesRunTime.unboxToInt((Object)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0))) == ((KafkaServer)this.servers().head()).config().brokerId() ? (KafkaServer)this.servers().head() : (KafkaServer)this.servers().apply(1));
        this.followerNode_$eq(BoxesRunTime.unboxToInt((Object)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0))) != ((KafkaServer)this.servers().head()).config().brokerId() ? (KafkaServer)this.servers().head() : (KafkaServer)this.servers().apply(1));
        this.quotaTestClients_$eq(this.createQuotaTestClients(this.topic1(), this.leaderNode()));
    }

    @Test
    public void testThrottledProducerConsumer() {
        int numRecords = 1000;
        QuotaTestClients qual$1 = this.quotaTestClients();
        int x$1 = numRecords;
        boolean x$2 = qual$1.produceUntilThrottled$default$2();
        int produced = qual$1.produceUntilThrottled(x$1, x$2);
        QuotaTestClients qual$2 = this.quotaTestClients();
        boolean x$3 = true;
        boolean x$4 = qual$2.verifyProduceThrottle$default$2();
        qual$2.verifyProduceThrottle(x$3, x$4);
        QuotaTestClients qual$3 = this.quotaTestClients();
        int x$5 = produced;
        boolean x$6 = qual$3.consumeUntilThrottled$default$2();
        qual$3.consumeUntilThrottled(x$5, x$6);
        QuotaTestClients qual$4 = this.quotaTestClients();
        boolean x$7 = true;
        boolean x$8 = qual$4.verifyConsumeThrottle$default$2();
        qual$4.verifyConsumeThrottle(x$7, x$8);
    }

    @Test
    public void testProducerConsumerOverrideUnthrottled() {
        Properties props = new Properties();
        props.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        props.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        this.quotaTestClients().overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE, 2.147483647E9);
        QuotaTestClients qual$5 = this.quotaTestClients();
        long x$9 = Long.MAX_VALUE;
        long x$10 = Long.MAX_VALUE;
        double x$11 = 2.147483647E9;
        KafkaServer x$12 = qual$5.waitForQuotaUpdate$default$4();
        qual$5.waitForQuotaUpdate(x$9, x$10, x$11, x$12);
        int numRecords = 1000;
        QuotaTestClients qual$6 = this.quotaTestClients();
        int x$13 = numRecords;
        boolean x$14 = qual$6.produceUntilThrottled$default$2();
        Assert.assertEquals((long)numRecords, (long)qual$6.produceUntilThrottled(x$13, x$14));
        QuotaTestClients qual$7 = this.quotaTestClients();
        boolean x$15 = false;
        boolean x$16 = qual$7.verifyProduceThrottle$default$2();
        qual$7.verifyProduceThrottle(x$15, x$16);
        QuotaTestClients qual$8 = this.quotaTestClients();
        int x$17 = numRecords;
        boolean x$18 = qual$8.consumeUntilThrottled$default$2();
        Assert.assertEquals((long)numRecords, (long)qual$8.consumeUntilThrottled(x$17, x$18));
        QuotaTestClients qual$9 = this.quotaTestClients();
        boolean x$19 = false;
        boolean x$20 = qual$9.verifyConsumeThrottle$default$2();
        qual$9.verifyConsumeThrottle(x$19, x$20);
    }

    @Test
    public void testQuotaOverrideDelete() {
        this.quotaTestClients().overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE, 2.147483647E9);
        QuotaTestClients qual$10 = this.quotaTestClients();
        long x$21 = Long.MAX_VALUE;
        long x$22 = Long.MAX_VALUE;
        double x$23 = 2.147483647E9;
        KafkaServer x$24 = qual$10.waitForQuotaUpdate$default$4();
        qual$10.waitForQuotaUpdate(x$21, x$22, x$23, x$24);
        int numRecords = 1000;
        QuotaTestClients qual$11 = this.quotaTestClients();
        int x$25 = numRecords;
        boolean x$26 = qual$11.produceUntilThrottled$default$2();
        Assert.assertEquals((long)numRecords, (long)qual$11.produceUntilThrottled(x$25, x$26));
        QuotaTestClients qual$12 = this.quotaTestClients();
        boolean x$27 = false;
        boolean x$28 = qual$12.verifyProduceThrottle$default$2();
        qual$12.verifyProduceThrottle(x$27, x$28);
        QuotaTestClients qual$13 = this.quotaTestClients();
        int x$29 = numRecords;
        boolean x$30 = qual$13.consumeUntilThrottled$default$2();
        Assert.assertEquals((long)numRecords, (long)qual$13.consumeUntilThrottled(x$29, x$30));
        QuotaTestClients qual$14 = this.quotaTestClients();
        boolean x$31 = false;
        boolean x$32 = qual$14.verifyConsumeThrottle$default$2();
        qual$14.verifyConsumeThrottle(x$31, x$32);
        this.quotaTestClients().removeQuotaOverrides();
        QuotaTestClients qual$15 = this.quotaTestClients();
        int x$33 = numRecords;
        boolean x$34 = qual$15.produceUntilThrottled$default$2();
        int produced = qual$15.produceUntilThrottled(x$33, x$34);
        QuotaTestClients qual$16 = this.quotaTestClients();
        boolean x$35 = true;
        boolean x$36 = qual$16.verifyProduceThrottle$default$2();
        qual$16.verifyProduceThrottle(x$35, x$36);
        ((KafkaConsumer)this.consumers().head()).seekToBeginning(Collections.singleton(new TopicPartition(this.topic1(), 0)));
        QuotaTestClients qual$17 = this.quotaTestClients();
        int x$37 = numRecords + produced;
        boolean x$38 = qual$17.consumeUntilThrottled$default$2();
        qual$17.consumeUntilThrottled(x$37, x$38);
        QuotaTestClients qual$18 = this.quotaTestClients();
        boolean x$39 = true;
        boolean x$40 = qual$18.verifyConsumeThrottle$default$2();
        qual$18.verifyConsumeThrottle(x$39, x$40);
    }

    @Test
    public void testThrottledRequest() {
        this.quotaTestClients().overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE, 0.1);
        QuotaTestClients qual$19 = this.quotaTestClients();
        long x$41 = Long.MAX_VALUE;
        long x$42 = Long.MAX_VALUE;
        double x$43 = 0.1;
        KafkaServer x$44 = qual$19.waitForQuotaUpdate$default$4();
        qual$19.waitForQuotaUpdate(x$41, x$42, x$43, x$44);
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        consumer.subscribe(Collections.singleton(this.topic1()));
        long endTimeMs = System.currentTimeMillis() + 10000L;
        boolean throttled = false;
        while (!(throttled && this.quotaTestClients().exemptRequestMetric() != null || System.currentTimeMillis() >= endTimeMs)) {
            consumer.poll(100L);
            KafkaMetric throttleMetric = this.quotaTestClients().throttleMetric((QuotaType)QuotaType.Request$.MODULE$, this.consumerClientId());
            throttled = throttleMetric != null && QuotaTestClients$.MODULE$.metricValue((Metric)throttleMetric) > 0.0;
        }
        Assert.assertTrue((String)"Should have been throttled", (boolean)throttled);
        this.quotaTestClients().verifyConsumerClientThrottleTimeMetric(true, (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)((double)ClientQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds() * 1000.0))));
        KafkaMetric exemptMetric = this.quotaTestClients().exemptRequestMetric();
        Assert.assertNotNull((String)"Exempt requests not recorded", (Object)exemptMetric);
        Assert.assertTrue((String)"Exempt requests not recorded", (QuotaTestClients$.MODULE$.metricValue((Metric)exemptMetric) > 0.0 ? 1 : 0) != 0);
    }

    public BaseQuotaTest() {
        this.serverCount = 2;
        this.producerCount = 1;
        this.consumerCount = 1;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "2");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp(), "30000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        this.producerConfig().setProperty("acks", "0");
        this.producerConfig().setProperty("buffer.memory", "300000");
        this.producerConfig().setProperty("client.id", this.producerClientId());
        this.consumerConfig().setProperty("group.id", "QuotasTest");
        this.consumerConfig().setProperty("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToInteger((int)4096)).toString());
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("client.id", this.consumerClientId());
        this.consumerConfig().setProperty("fetch.min.bytes", "0");
        this.consumerConfig().setProperty("fetch.max.wait.ms", "0");
        this.defaultProducerQuota = 8000;
        this.defaultConsumerQuota = 2500;
        this.defaultRequestQuota = Integer.MAX_VALUE;
        this.topic1 = "topic-1";
    }
}

