/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Properties;
import kafka.common.MessageFormatter;
import kafka.consumer.BaseConsumer;
import kafka.consumer.BaseConsumerRecord;
import kafka.consumer.BaseConsumerRecord$;
import kafka.tools.ConsoleConsumer;
import kafka.tools.ConsoleConsumer$;
import kafka.tools.DefaultMessageFormatter;
import kafka.utils.Exit$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.record.TimestampType;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import scala.Array$;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\r4A!\u0001\u0002\u0001\u000f\t\u00192i\u001c8t_2,7i\u001c8tk6,'\u000fV3ti*\u00111\u0001B\u0001\u0006i>|Gn\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\u0006)\u0001!\t!F\u0001\"g\"|W\u000f\u001c3MS6LGOU3bIN$v.T1y\u001b\u0016\u001c8/Y4f\u0019&l\u0017\u000e\u001e\u000b\u0002-A\u0011\u0011bF\u0005\u00031)\u0011A!\u00168ji\"\u00121C\u0007\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\tQA[;oSRT\u0011aH\u0001\u0004_J<\u0017BA\u0011\u001d\u0005\u0011!Vm\u001d;\t\u000b\r\u0002A\u0011A\u000b\u0002GMDw.\u001e7e'R|\u0007o\u00165f]>+H\u000f];u\u0007\",7m[#se>\u0014h)Y5mg\"\u0012!E\u0007\u0005\u0006M\u0001!\t!F\u0001'g\"|W\u000f\u001c3QCJ\u001cXMV1mS\u0012|E\u000eZ\"p]N,X.\u001a:WC2LGmQ8oM&<\u0007FA\u0013\u001b\u0011\u0015I\u0003\u0001\"\u0001\u0016\u0003\u0019\u001a\bn\\;mIB\u000b'o]3WC2LGMT3x\u0007>t7/^7feZ\u000bG.\u001b3D_:4\u0017n\u001a\u0015\u0003QiAQ\u0001\f\u0001\u0005\u0002U\tQh\u001d5pk2$\u0007+\u0019:tKZ\u000bG.\u001b3OK^\u001c\u0016.\u001c9mK\u000e{gn];nKJ4\u0016\r\\5e\u0007>tg-[4XSRDg*^7fe&\u001cwJ\u001a4tKRD#a\u000b\u000e\t\u000b=\u0002A\u0011A\u000b\u0002'Q,7\u000f\u001e#fM\u0006,H\u000e^\"p]N,X.\u001a:)\u00059R\u0002\"\u0002\u001a\u0001\t\u0003)\u0012\u0001P:i_VdG\rU1sg\u00164\u0016\r\\5e\u001d\u0016<8+[7qY\u0016\u001cuN\\:v[\u0016\u0014h+\u00197jI\u000e{gNZ5h/&$\bn\u0015;sS:<wJ\u001a4tKRD#!\r\u000e\t\u000bU\u0002A\u0011A\u000b\u0002yMDw.\u001e7e!\u0006\u00148/\u001a,bY&$w\n\u001c3D_:\u001cX/\\3s\u0007>tg-[4XSRD\u0017)\u001e;p\u001f\u001a47/\u001a;SKN,GoU7bY2,7\u000f\u001e\u0015\u0003iiAQ\u0001\u000f\u0001\u0005\u0002U\t1h\u001d5pk2$\u0007+\u0019:tKZ\u000bG.\u001b3PY\u0012\u001cuN\\:v[\u0016\u00148i\u001c8gS\u001e<\u0016\u000e\u001e5BkR|wJ\u001a4tKR\u0014Vm]3u\u0019\u0006\u0014x-Z:uQ\t9$\u0004C\u0003<\u0001\u0011\u0005Q#A\u001ctQ>,H\u000eZ*fi\u0006+Ho\u001c*fg\u0016$Hk\\*nC2dWm\u001d;XQ\u0016tgI]8n\u0005\u0016<\u0017N\u001c8j]\u001e\u001cuN\u001c4jOV\u0014X\r\u001a\u0015\u0003uiAQA\u0010\u0001\u0005\u0002U\t!h\u001d5pk2$\u0007+\u0019:tKZ\u000bG.\u001b3OK^\u001cuN\\:v[\u0016\u00148i\u001c8gS\u001e<\u0016\u000e\u001e5BkR|wJ\u001a4tKR\u0014Vm]3u\u0019\u0006$Xm\u001d;)\u0005uR\u0002\"B!\u0001\t\u0003)\u0012\u0001P:i_VdG\rU1sg\u00164\u0016\r\\5e\u001d\u0016<8i\u001c8tk6,'oQ8oM&<w+\u001b;i\u0003V$xn\u00144gg\u0016$(+Z:fi\u0016\u000b'\u000f\\5fgRD#\u0001\u0011\u000e\t\u000b\u0011\u0003A\u0011A\u000b\u0002\u0019NDw.\u001e7e!\u0006\u00148/\u001a,bY&$g*Z<D_:\u001cX/\\3s\u0007>tg-[4XSRD\u0017)\u001e;p\u001f\u001a47/\u001a;SKN,G/\u00118e\u001b\u0006$8\r[5oO\u001a\u0013x.\u001c\"fO&tg.\u001b8hQ\t\u0019%\u0004C\u0003H\u0001\u0011\u0005Q#\u0001\u001atQ>,H\u000e\u001a)beN,g+\u00197jI:+woQ8ogVlWM]\"p]\u001aLwmV5uQ:{wJ\u001a4tKR\u0014Vm]3uQ\t1%\u0004C\u0003K\u0001\u0011\u0005Q#\u0001*tQ>,H\u000eZ#ySR|e.\u00138wC2LGmQ8oM&<w+\u001b;i\u0003V$xn\u00144gg\u0016$(+Z:fi\u0006sGmQ8oM2L7\r^5oO\u001a\u0013x.\u001c\"fO&tg.\u001b8h\u001d\u0016<8i\u001c8tk6,'\u000f\u000b\u0003J51k\u0015\u0001C3ya\u0016\u001cG/\u001a3$\u00039\u0003\"aT,\u000f\u0005A+fBA)U\u001b\u0005\u0011&BA*\u0007\u0003\u0019a$o\\8u}%\t1\"\u0003\u0002W\u0015\u00059\u0001/Y2lC\u001e,\u0017B\u0001-Z\u0005aIE\u000e\\3hC2\f%oZ;nK:$X\t_2faRLwN\u001c\u0006\u0003-*AQa\u0017\u0001\u0005\u0002U\t!k\u001d5pk2$W\t_5u\u001f:LeN^1mS\u0012\u001cuN\u001c4jO^KG\u000f[!vi>|eMZ:fiJ+7/\u001a;B]\u0012\u001cuN\u001c4mS\u000e$\u0018N\\4Ge>l')Z4j]:LgnZ(mI\u000e{gn];nKJDCA\u0017\u000eM\u001b\")a\f\u0001C\u0001+\u0005Q2\u000f[8vY\u0012\u0004\u0016M]:f\u0007>tg-[4t\rJ|WNR5mK\"\u0012QL\u0007\u0005\u0006C\u0002!\t!F\u0001+OJ|W\u000f]%egB\u0013xN^5eK\u0012Le\u000eR5gM\u0016\u0014XM\u001c;QY\u0006\u001cWm]'vgRl\u0015\r^2iQ\t\u0001'\u0004")
public class ConsoleConsumerTest {
    @Test
    public void shouldLimitReadsToMaxMessageLimit() {
        BaseConsumer consumer = (BaseConsumer)EasyMock.createNiceMock(BaseConsumer.class);
        MessageFormatter formatter = (MessageFormatter)EasyMock.createNiceMock(MessageFormatter.class);
        String x$4 = "foo";
        int x$5 = 1;
        long x$6 = 1L;
        byte[] x$7 = (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte());
        byte[] x$8 = (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte());
        long x$9 = BaseConsumerRecord$.MODULE$.$lessinit$greater$default$4();
        TimestampType x$10 = BaseConsumerRecord$.MODULE$.$lessinit$greater$default$5();
        Headers x$11 = BaseConsumerRecord$.MODULE$.$lessinit$greater$default$8();
        BaseConsumerRecord record = new BaseConsumerRecord(x$4, x$5, x$6, x$9, x$10, x$7, x$8, x$11);
        int messageLimit = 10;
        formatter.writeTo((ConsumerRecord)EasyMock.anyObject(), (PrintStream)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).times(messageLimit);
        EasyMock.expect((Object)consumer.receive()).andReturn((Object)record).times(messageLimit);
        EasyMock.replay((Object[])new Object[]{consumer});
        EasyMock.replay((Object[])new Object[]{formatter});
        ConsoleConsumer$.MODULE$.process(Predef$.MODULE$.int2Integer(messageLimit), formatter, consumer, System.out, true);
    }

    @Test
    public void shouldStopWhenOutputCheckErrorFails() {
        BaseConsumer consumer = (BaseConsumer)EasyMock.createNiceMock(BaseConsumer.class);
        MessageFormatter formatter = (MessageFormatter)EasyMock.createNiceMock(MessageFormatter.class);
        PrintStream printStream = (PrintStream)EasyMock.createNiceMock(PrintStream.class);
        String x$12 = "foo";
        int x$13 = 1;
        long x$14 = 1L;
        byte[] x$15 = (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte());
        byte[] x$16 = (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte());
        long x$17 = BaseConsumerRecord$.MODULE$.$lessinit$greater$default$4();
        TimestampType x$18 = BaseConsumerRecord$.MODULE$.$lessinit$greater$default$5();
        Headers x$19 = BaseConsumerRecord$.MODULE$.$lessinit$greater$default$8();
        BaseConsumerRecord record = new BaseConsumerRecord(x$12, x$13, x$14, x$17, x$18, x$15, x$16, x$19);
        EasyMock.expect((Object)consumer.receive()).andReturn((Object)record);
        formatter.writeTo((ConsumerRecord)EasyMock.anyObject(), (PrintStream)EasyMock.eq((Object)printStream));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)printStream.checkError())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.replay((Object[])new Object[]{consumer});
        EasyMock.replay((Object[])new Object[]{formatter});
        EasyMock.replay((Object[])new Object[]{printStream});
        ConsoleConsumer$.MODULE$.process(Predef$.MODULE$.int2Integer(-1), formatter, consumer, printStream, true);
        EasyMock.verify((Object[])new Object[]{consumer, formatter, printStream});
    }

    @Test
    public void shouldParseValidOldConsumerValidConfig() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:2181", "--topic", "test", "--from-beginning"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertTrue((boolean)config.useOldConsumer());
        Assert.assertEquals((Object)"localhost:2181", (Object)config.zkConnectionStr());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
    }

    @Test
    public void shouldParseValidNewConsumerValidConfig() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--from-beginning", "--new-consumer"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertFalse((boolean)config.useOldConsumer());
        Assert.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
    }

    @Test
    public void shouldParseValidNewSimpleConsumerValidConfigWithNumericOffset() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--partition", "0", "--offset", "3", "--new-consumer"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertFalse((boolean)config.useOldConsumer());
        Assert.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToInt((Object)config.partitionArg().get()));
        Assert.assertEquals((long)3L, (long)config.offsetArg());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
    }

    @Test
    public void testDefaultConsumer() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--from-beginning"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertFalse((boolean)config.useOldConsumer());
    }

    @Test
    public void shouldParseValidNewSimpleConsumerValidConfigWithStringOffset() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--partition", "0", "--offset", "LatEst", "--new-consumer", "--property", "print.value=false"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertFalse((boolean)config.useOldConsumer());
        Assert.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToInt((Object)config.partitionArg().get()));
        Assert.assertEquals((long)-1L, (long)config.offsetArg());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)((DefaultMessageFormatter)config.formatter()).printValue()));
    }

    @Test
    public void shouldParseValidOldConsumerConfigWithAutoOffsetResetSmallest() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:2181", "--topic", "test", "--consumer-property", "auto.offset.reset=smallest"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties consumerProperties = ConsoleConsumer$.MODULE$.getOldConsumerProps(config);
        Assert.assertTrue((boolean)config.useOldConsumer());
        Assert.assertEquals((Object)"localhost:2181", (Object)config.zkConnectionStr());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
        Assert.assertEquals((Object)"smallest", (Object)consumerProperties.getProperty("auto.offset.reset"));
    }

    @Test
    public void shouldParseValidOldConsumerConfigWithAutoOffsetResetLargest() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:2181", "--topic", "test", "--consumer-property", "auto.offset.reset=largest"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties consumerProperties = ConsoleConsumer$.MODULE$.getOldConsumerProps(config);
        Assert.assertTrue((boolean)config.useOldConsumer());
        Assert.assertEquals((Object)"localhost:2181", (Object)config.zkConnectionStr());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
        Assert.assertEquals((Object)"largest", (Object)consumerProperties.getProperty("auto.offset.reset"));
    }

    @Test
    public void shouldSetAutoResetToSmallestWhenFromBeginningConfigured() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:2181", "--topic", "test", "--from-beginning"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties consumerProperties = ConsoleConsumer$.MODULE$.getOldConsumerProps(config);
        Assert.assertTrue((boolean)config.useOldConsumer());
        Assert.assertEquals((Object)"localhost:2181", (Object)config.zkConnectionStr());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
        Assert.assertEquals((Object)"smallest", (Object)consumerProperties.getProperty("auto.offset.reset"));
    }

    @Test
    public void shouldParseValidNewConsumerConfigWithAutoOffsetResetLatest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "auto.offset.reset=latest"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties consumerProperties = ConsoleConsumer$.MODULE$.getNewConsumerProps(config);
        Assert.assertFalse((boolean)config.useOldConsumer());
        Assert.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
        Assert.assertEquals((Object)"latest", (Object)consumerProperties.getProperty("auto.offset.reset"));
    }

    @Test
    public void shouldParseValidNewConsumerConfigWithAutoOffsetResetEarliest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "auto.offset.reset=earliest"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties consumerProperties = ConsoleConsumer$.MODULE$.getNewConsumerProps(config);
        Assert.assertFalse((boolean)config.useOldConsumer());
        Assert.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
        Assert.assertEquals((Object)"earliest", (Object)consumerProperties.getProperty("auto.offset.reset"));
    }

    @Test
    public void shouldParseValidNewConsumerConfigWithAutoOffsetResetAndMatchingFromBeginning() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "auto.offset.reset=earliest", "--from-beginning"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties consumerProperties = ConsoleConsumer$.MODULE$.getNewConsumerProps(config);
        Assert.assertFalse((boolean)config.useOldConsumer());
        Assert.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
        Assert.assertEquals((Object)"earliest", (Object)consumerProperties.getProperty("auto.offset.reset"));
    }

    @Test
    public void shouldParseValidNewConsumerConfigWithNoOffsetReset() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test"});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties consumerProperties = ConsoleConsumer$.MODULE$.getNewConsumerProps(config);
        Assert.assertFalse((boolean)config.useOldConsumer());
        Assert.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)config.fromBeginning()));
        Assert.assertEquals((Object)"latest", (Object)consumerProperties.getProperty("auto.offset.reset"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldExitOnInvalidConfigWithAutoOffsetResetAndConflictingFromBeginningNewConsumer() {
        Exit$.MODULE$.setExitProcedure((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(int x$1, Option<String> message) {
                throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
            }
        });
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "auto.offset.reset=latest", "--from-beginning"});
        try {
            ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
            ConsoleConsumer$.MODULE$.getNewConsumerProps(config);
            Assert.fail((String)"Expected consumer property construction to fail due to inconsistent reset options");
            return;
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldExitOnInvalidConfigWithAutoOffsetResetAndConflictingFromBeginningOldConsumer() {
        Exit$.MODULE$.setExitProcedure((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(int x$2, Option<String> message) {
                throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
            }
        });
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:2181", "--topic", "test", "--consumer-property", "auto.offset.reset=largest", "--from-beginning"});
        try {
            ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
            ConsoleConsumer$.MODULE$.getOldConsumerProps(config);
            Assert.fail((String)"Expected consumer property construction to fail due to inconsistent reset options");
            return;
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    @Test
    public void shouldParseConfigsFromFile() {
        File propsFile = TestUtils$.MODULE$.tempFile();
        FileOutputStream propsStream = new FileOutputStream(propsFile);
        propsStream.write("request.timeout.ms=1000\n".getBytes());
        propsStream.write("group.id=group1".getBytes());
        propsStream.close();
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer.config", propsFile.getAbsolutePath()});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertEquals((Object)"1000", (Object)config.consumerProps().getProperty("request.timeout.ms"));
        Assert.assertEquals((Object)"group1", (Object)config.consumerProps().getProperty("group.id"));
    }

    @Test
    public void groupIdsProvidedInDifferentPlacesMustMatch() {
        Exit$.MODULE$.setExitProcedure((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(int x$3, Option<String> message) {
                throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
            }
        });
        File propsFile = TestUtils$.MODULE$.tempFile();
        FileOutputStream propsStream = new FileOutputStream(propsFile);
        propsStream.write("group.id=group-from-file".getBytes());
        propsStream.close();
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "group-from-arguments", "--consumer-property", "group.id=group-from-properties", "--consumer.config", propsFile.getAbsolutePath()});
        try {
            new ConsoleConsumer.ConsumerConfig(args);
            Assert.fail((String)"Expected groups ids provided in different places to match");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        propsFile = TestUtils$.MODULE$.tempFile();
        propsStream = new FileOutputStream(propsFile);
        propsStream.write("group.id=test-group".getBytes());
        propsStream.close();
        args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "test-group", "--consumer-property", "group.id=test-group", "--consumer.config", propsFile.getAbsolutePath()});
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties props = ConsoleConsumer$.MODULE$.getNewConsumerProps(config);
        Assert.assertEquals((Object)"test-group", (Object)props.getProperty("group.id"));
        propsFile = TestUtils$.MODULE$.tempFile();
        propsStream = new FileOutputStream(propsFile);
        propsStream.write("group.id=group-from-file".getBytes());
        propsStream.close();
        args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "group.id=group-from-properties", "--consumer.config", propsFile.getAbsolutePath()});
        try {
            new ConsoleConsumer.ConsumerConfig(args);
            Assert.fail((String)"Expected groups ids provided in different places to match");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "group-from-arguments", "--consumer-property", "group.id=group-from-properties"});
        try {
            new ConsoleConsumer.ConsumerConfig(args);
            Assert.fail((String)"Expected groups ids provided in different places to match");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        propsFile = TestUtils$.MODULE$.tempFile();
        propsStream = new FileOutputStream(propsFile);
        propsStream.write("group.id=group-from-file".getBytes());
        propsStream.close();
        args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "group-from-arguments", "--consumer.config", propsFile.getAbsolutePath()});
        try {
            new ConsoleConsumer.ConsumerConfig(args);
            Assert.fail((String)"Expected groups ids provided in different places to match");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "group-from-arguments"});
        config = new ConsoleConsumer.ConsumerConfig(args);
        props = ConsoleConsumer$.MODULE$.getNewConsumerProps(config);
        Assert.assertEquals((Object)"group-from-arguments", (Object)props.getProperty("group.id"));
        Exit$.MODULE$.resetExitProcedure();
    }
}

