/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.util.Collections;
import java.util.Properties;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReplicationQuotaUtils$;
import kafka.common.AdminCommandFailedException;
import kafka.common.TopicAndPartition;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001B\u0001\u0003\u0001\u001d\u0011QDU3bgNLwM\u001c)beRLG/[8og\u000ecWo\u001d;feR+7\u000f\u001e\u0006\u0003\u0007\u0011\tQ!\u00193nS:T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0004\t\u0003\u00131i\u0011A\u0003\u0006\u0003\u0017\u0011\t!A_6\n\u00055Q!\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002\u0010%5\t\u0001C\u0003\u0002\u0012\t\u0005)Q\u000f^5mg&\u00111\u0003\u0005\u0002\b\u0019><w-\u001b8h\u0011\u0015)\u0002\u0001\"\u0001\u0017\u0003\u0019a\u0014N\\5u}Q\tq\u0003\u0005\u0002\u0019\u00015\t!\u0001C\u0004\u001b\u0001\t\u0007I\u0011A\u000e\u0002\u0017A\f'\u000f^5uS>t\u0017\nZ\u000b\u00029A\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t\u0019\u0011J\u001c;\t\r\r\u0002\u0001\u0015!\u0003\u001d\u00031\u0001\u0018M\u001d;ji&|g.\u00133!\u0011\u001d)\u0003\u00011A\u0005\u0002\u0019\nqa]3sm\u0016\u00148/F\u0001(!\rA3&L\u0007\u0002S)\u0011!FH\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u0017*\u0005\r\u0019V-\u001d\t\u0003]Ej\u0011a\f\u0006\u0003a\u0011\taa]3sm\u0016\u0014\u0018B\u0001\u001a0\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\t\u000fQ\u0002\u0001\u0019!C\u0001k\u0005Y1/\u001a:wKJ\u001cx\fJ3r)\t1\u0014\b\u0005\u0002\u001eo%\u0011\u0001H\b\u0002\u0005+:LG\u000fC\u0004;g\u0005\u0005\t\u0019A\u0014\u0002\u0007a$\u0013\u0007\u0003\u0004=\u0001\u0001\u0006KaJ\u0001\tg\u0016\u0014h/\u001a:tA!9a\b\u0001b\u0001\n\u0003y\u0014!\u0003;pa&\u001cg*Y7f+\u0005\u0001\u0005CA!G\u001b\u0005\u0011%BA\"E\u0003\u0011a\u0017M\\4\u000b\u0003\u0015\u000bAA[1wC&\u0011qI\u0011\u0002\u0007'R\u0014\u0018N\\4\t\r%\u0003\u0001\u0015!\u0003A\u0003)!x\u000e]5d\u001d\u0006lW\r\t\u0005\b\u0017\u0002\u0011\r\u0011\"\u0001\u001c\u0003\u001d!W\r\\1z\u001bNDa!\u0014\u0001!\u0002\u0013a\u0012\u0001\u00033fY\u0006LXj\u001d\u0011\t\u000f=\u0003\u0001\u0019!C\u0001!\u0006Y\u0011\rZ7j]\u000ec\u0017.\u001a8u+\u0005\t\u0006C\u0001*\\\u001b\u0005\u0019&BA\u0002U\u0015\t)f+A\u0004dY&,g\u000e^:\u000b\u0005\u00159&B\u0001-Z\u0003\u0019\t\u0007/Y2iK*\t!,A\u0002pe\u001eL!\u0001X*\u0003\u0017\u0005#W.\u001b8DY&,g\u000e\u001e\u0005\b=\u0002\u0001\r\u0011\"\u0001`\u0003=\tG-\\5o\u00072LWM\u001c;`I\u0015\fHC\u0001\u001ca\u0011\u001dQT,!AA\u0002ECaA\u0019\u0001!B\u0013\t\u0016\u0001D1e[&t7\t\\5f]R\u0004\u0003\"\u00023\u0001\t\u0003)\u0017!\u0004>l+B$\u0017\r^3EK2\f\u0017\u0010F\u00017\u0011\u00159\u0007\u0001\"\u0011f\u0003\u0015\u0019X\r^+qQ\t1\u0017\u000e\u0005\u0002k[6\t1N\u0003\u0002m3\u0006)!.\u001e8ji&\u0011an\u001b\u0002\u0007\u0005\u00164wN]3\t\u000bA\u0004A\u0011A9\u0002\u0019M$\u0018M\u001d;Ce>\\WM]:\u0015\u0005Y\u0012\b\"B:p\u0001\u0004!\u0018!\u00032s_.,'/\u00133t!\rA3\u0006\b\u0005\u0006m\u0002!\ta^\u0001\u0012GJ,\u0017\r^3BI6Lgn\u00117jK:$HCA)y\u0011\u0015)S\u000f1\u0001(\u0011\u0015Q\b\u0001\"\u0001|\u0003e9W\r\u001e*b]\u0012|W\u000eT8h\t&\u0014\u0018i]:jO:lWM\u001c;\u0015\u0007q\f)\u0001E\u0002~\u0003\u0003q!!\b@\n\u0005}t\u0012A\u0002)sK\u0012,g-C\u0002H\u0003\u0007Q!a \u0010\t\r\u0005\u001d\u0011\u00101\u0001\u001d\u0003!\u0011'o\\6fe&#\u0007BBA\u0006\u0001\u0011\u0005S-\u0001\u0005uK\u0006\u0014Hi\\<oQ\u0011\tI!a\u0004\u0011\u0007)\f\t\"C\u0002\u0002\u0014-\u0014Q!\u00114uKJDa!a\u0006\u0001\t\u0003)\u0017!G:i_VdG-T8wKNKgn\u001a7f!\u0006\u0014H/\u001b;j_:DC!!\u0006\u0002\u001cA\u0019!.!\b\n\u0007\u0005}1N\u0001\u0003UKN$\bBBA\u0012\u0001\u0011\u0005Q-A\ntQ>,H\u000eZ#ya\u0006tGm\u00117vgR,'\u000f\u000b\u0003\u0002\"\u0005m\u0001BBA\u0015\u0001\u0011\u0005Q-A\ntQ>,H\u000eZ*ie&t7n\u00117vgR,'\u000f\u000b\u0003\u0002(\u0005m\u0001BBA\u0018\u0001\u0011\u0005Q-\u0001\u000ftQ>,H\u000eZ'pm\u0016\u001cVOY:fi>3\u0007+\u0019:uSRLwN\\:)\t\u00055\u00121\u0004\u0005\u0007\u0003k\u0001A\u0011A3\u0002EMDw.\u001e7e\u000bb,7-\u001e;f)\"\u0014x\u000e\u001e;mK\u0012\u0014V-Y:tS\u001etW.\u001a8uQ\u0011\t\u0019$a\u0007\t\r\u0005m\u0002\u0001\"\u0001f\u0003\u0001\u001a\bn\\;mI>sG.\u001f+ie>$H\u000f\\3N_ZLgn\u001a*fa2L7-Y:)\t\u0005e\u00121\u0004\u0005\u0007\u0003\u0003\u0002A\u0011A3\u0002YMDw.\u001e7e\u0007\"\fgnZ3UQJ|G\u000f\u001e7f\u001f:\u0014VM];o\u0003:$'+Z7pm\u0016|eNV3sS\u001aL\b\u0006BA \u00037Aa!a\u0012\u0001\t\u0003)\u0017\u0001K:i_VdGMR1jY&3\u0007K]8q_N,G\rR8fg:{G/T1uG\",\u00050[:uS:<\u0007\u0006CA#\u00037\tY%!\u0014\u0002\u0011\u0015D\b/Z2uK\u0012\u001c#!a\u0014\u0011\t\u0005E\u0013qK\u0007\u0003\u0003'R1!!\u0016\u0005\u0003\u0019\u0019w.\\7p]&!\u0011\u0011LA*\u0005m\tE-\\5o\u0007>lW.\u00198e\r\u0006LG.\u001a3Fq\u000e,\u0007\u000f^5p]\"1\u0011Q\f\u0001\u0005\u0002\u0015\fqe\u001d5pk2$g)Y5m\u0013\u001a\u0004&o\u001c9pg\u0016$\u0007*Y:F[B$\u0018PU3qY&\u001c\u0017\rT5ti\"B\u00111LA\u000e\u0003\u0017\ni\u0005\u0003\u0004\u0002d\u0001!\t!Z\u0001'g\"|W\u000f\u001c3GC&d\u0017J\u001a)s_B|7/\u001a3ICNLeN^1mS\u0012\u0014%o\\6fe&#\u0005\u0006CA1\u00037\tY%!\u0014\t\r\u0005%\u0004\u0001\"\u0001f\u0003\u0011\u001a\bn\\;mI\u001a\u000b\u0017\u000e\\%g!J|\u0007o\\:fI\"\u000b7/\u00138wC2LG\rT8h\t&\u0014\b\u0006CA4\u00037\tY%!\u0014\t\r\u0005=\u0004\u0001\"\u0001f\u0003-\u001a\bn\\;mI\u001a\u000b\u0017\u000e\\%g!J|\u0007o\\:fI6{g/\u001a*fa2L7-Y,ji\"LgN\u0011:pW\u0016\u0014\b\u0006CA7\u00037\tY%!\u0014\t\r\u0005U\u0004\u0001\"\u0001f\u0003U\u001a\bn\\;mI\u001a\u000b\u0017\u000e\\%g!J|\u0007o\\:fI\"\u000b7/\u00138d_:\u001c\u0018n\u001d;f]R\u0014V\r\u001d7jG\u0006\u001c\u0018I\u001c3M_\u001e$\u0015N]:)\u0011\u0005M\u00141DA&\u0003\u001bBa!a\u001f\u0001\t\u0003)\u0017aM:i_VdG\rU3sM>\u0014X\u000e\u00165s_R$H.\u001a3SK\u0006\u001c8/[4o[\u0016tGo\u0014<feZ\u000b'/[8vgR{\u0007/[2tQ\u0011\tI(a\u0007\t\r\u0005\u0005\u0005\u0001\"\u0001f\u0003u9\u0018-\u001b;G_J\u0014V-Y:tS\u001etW.\u001a8u)>\u001cu.\u001c9mKR,\u0007bBAC\u0001\u0011\u0005\u0011qQ\u0001\u0005UN|g\u000eF\u0002}\u0003\u0013C\u0001\"a#\u0002\u0004\u0002\u0007\u0011QR\u0001\u0006i>\u0004\u0018n\u0019\t\u0005;\u0005=E0C\u0002\u0002\u0012z\u0011!\u0002\u0010:fa\u0016\fG/\u001a3?\u0001")
public class ReassignPartitionsClusterTest
extends ZooKeeperTestHarness {
    private final int partitionId;
    private Seq<KafkaServer> servers = null;
    private final String topicName;
    private final int delayMs;
    private AdminClient adminClient = null;

    public int partitionId() {
        return this.partitionId;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public String topicName() {
        return this.topicName;
    }

    public int delayMs() {
        return this.delayMs;
    }

    public AdminClient adminClient() {
        return this.adminClient;
    }

    public void adminClient_$eq(AdminClient x$1) {
        this.adminClient = x$1;
    }

    public void zkUpdateDelay() {
        Thread.sleep(this.delayMs());
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
    }

    public void startBrokers(Seq<Object> brokerIds) {
        this.servers_$eq((Seq<KafkaServer>)((Seq)((TraversableLike)brokerIds.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReassignPartitionsClusterTest $outer;

            public final Properties apply(int i) {
                int x$2 = i;
                String x$3 = this.$outer.zkConnect();
                int x$4 = 3;
                boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$3();
                boolean x$6 = TestUtils$.MODULE$.createBrokerConfig$default$4();
                int x$7 = TestUtils$.MODULE$.createBrokerConfig$default$5();
                Option<SecurityProtocol> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$6();
                Option<File> x$9 = TestUtils$.MODULE$.createBrokerConfig$default$7();
                Option<Properties> x$10 = TestUtils$.MODULE$.createBrokerConfig$default$8();
                boolean x$11 = TestUtils$.MODULE$.createBrokerConfig$default$9();
                boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$10();
                int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$11();
                boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$12();
                int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$13();
                boolean x$16 = TestUtils$.MODULE$.createBrokerConfig$default$14();
                int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$15();
                Option<String> x$18 = TestUtils$.MODULE$.createBrokerConfig$default$16();
                return TestUtils$.MODULE$.createBrokerConfig(x$2, x$3, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties c) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(c), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom())));
    }

    public AdminClient createAdminClient(Seq<KafkaServer> servers) {
        Properties props = new Properties();
        props.put("bootstrap.servers", TestUtils$.MODULE$.getBrokerListStrFromServers(servers, TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()));
        props.put("request.timeout.ms", "10000");
        return AdminClient.create((Properties)props);
    }

    public String getRandomLogDirAssignment(int brokerId) {
        KafkaServer server = (KafkaServer)this.servers().find((Function1)new Serializable(this, brokerId){
            public static final long serialVersionUID = 0L;
            private final int brokerId$1;

            public final boolean apply(KafkaServer x$1) {
                return x$1.config().brokerId() == this.brokerId$1;
            }
            {
                this.brokerId$1 = brokerId$1;
            }
        }).get();
        Seq logDirs = server.config().logDirs();
        return new File((String)logDirs.apply(Random$.MODULE$.nextInt(logDirs.size()))).getAbsolutePath();
    }

    @Override
    @After
    public void tearDown() {
        if (this.adminClient() != null) {
            this.adminClient().close();
            this.adminClient_$eq(null);
        }
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void shouldMoveSinglePartition() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))));
        this.adminClient_$eq(this.createAdminClient(this.servers()));
        int partition = 0;
        String expectedLogDir = this.getRandomLogDirAssignment(101);
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})))}))), this.servers());
        String topicJson = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"version\":1,\"partitions\":[{\"topic\":\"", "\",\"partition\":0,\"replicas\":[101],\"log_dirs\":[\"", "\"]}]}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicName(), expectedLogDir}));
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), (Option)new Some((Object)this.adminClient()), topicJson, ReassignPartitionsCommand$.MODULE$.NoThrottle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
        this.waitForReassignmentToComplete();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101})), (Object)((MapLike)this.zkUtils().getPartitionAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).get((Object)this.topicName()).get()).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        TopicPartitionReplica replica = new TopicPartitionReplica(this.topicName(), 0, 101);
        Assert.assertEquals((Object)expectedLogDir, (Object)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((java.util.Map)this.adminClient().describeReplicaLogDirs(Collections.singleton(replica)).all().get()).get(replica)).getCurrentReplicaLogDir());
    }

    @Test
    public void shouldExpandCluster() {
        int[] brokers = new int[]{100, 101, 102};
        this.startBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(brokers));
        this.adminClient_$eq(this.createAdminClient(this.servers()));
        String expectedLogDir = this.getRandomLogDirAssignment(102);
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.servers());
        Map newAssignment = (Map)ReassignPartitionsCommand$.MODULE$.generateAssignment(this.zkUtils(), (Seq)Predef$.MODULE$.wrapIntArray(brokers), this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()})), true)._1();
        int partition = ((TopicAndPartition)((Tuple2)newAssignment.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> x0$1) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    Seq brokerIds = (Seq)tuple2._2();
                    boolean bl = brokerIds.contains((Object)BoxesRunTime.boxToInteger((int)102));
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        }).get())._1()).partition();
        TopicPartitionReplica replica = new TopicPartitionReplica(this.topicName(), partition, 102);
        Map newReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)replica), (Object)expectedLogDir)}));
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), (Option)new Some((Object)this.adminClient()), ReassignPartitionsCommand$.MODULE$.formatAsReassignmentJson(newAssignment, newReplicaAssignment), ReassignPartitionsCommand$.MODULE$.NoThrottle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
        this.waitForReassignmentToComplete();
        Map actual = (Map)this.zkUtils().getPartitionAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).apply((Object)this.topicName());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 102})), (Object)((SeqLike)((TraversableOnce)actual.values().flatten((Function1)Predef$.MODULE$.$conforms())).toSeq().distinct()).sorted((Ordering)Ordering.Int$.MODULE$));
        Assert.assertEquals((Object)expectedLogDir, (Object)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((java.util.Map)this.adminClient().describeReplicaLogDirs(Collections.singleton(replica)).all().get()).get(replica)).getCurrentReplicaLogDir());
    }

    @Test
    public void shouldShrinkCluster() {
        int[] brokers = new int[]{100, 101, 102};
        this.startBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(brokers));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{102, 100})))}))), this.servers());
        Map newAssignment = (Map)ReassignPartitionsCommand$.MODULE$.generateAssignment(this.zkUtils(), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}), this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()})), true)._1();
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), (Option)None$.MODULE$, ReassignPartitionsCommand$.MODULE$.formatAsReassignmentJson(newAssignment, (Map)Map$.MODULE$.empty()), ReassignPartitionsCommand$.MODULE$.NoThrottle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
        this.waitForReassignmentToComplete();
        Map actual = (Map)this.zkUtils().getPartitionAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).apply((Object)this.topicName());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})), (Object)((SeqLike)((TraversableOnce)actual.values().flatten((Function1)Predef$.MODULE$.$conforms())).toSeq().distinct()).sorted((Ordering)Ordering.Int$.MODULE$));
    }

    @Test
    public void shouldMoveSubsetOfPartitions() {
        int[] brokers = new int[]{100, 101, 102};
        this.startBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(brokers));
        this.adminClient_$eq(this.createAdminClient(this.servers()));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), "topic1", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{102, 100})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), "topic2", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{102, 100})))}))), this.servers());
        Map proposed = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic2", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 100}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic2", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})))}));
        TopicPartitionReplica replica1 = new TopicPartitionReplica("topic1", 0, 102);
        TopicPartitionReplica replica2 = new TopicPartitionReplica("topic2", 1, 100);
        Map proposedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)replica1), (Object)this.getRandomLogDirAssignment(102)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)replica2), (Object)this.getRandomLogDirAssignment(100))}));
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), (Option)new Some((Object)this.adminClient()), ReassignPartitionsCommand$.MODULE$.formatAsReassignmentJson(proposed, proposedReplicaAssignment), ReassignPartitionsCommand$.MODULE$.NoThrottle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
        this.waitForReassignmentToComplete();
        scala.collection.mutable.Map actual = this.zkUtils().getPartitionAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic1", "topic2"})));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})), (Object)((MapLike)actual.apply((Object)"topic1")).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102})), (Object)((MapLike)actual.apply((Object)"topic1")).apply((Object)BoxesRunTime.boxToInteger((int)1)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})), (Object)((MapLike)actual.apply((Object)"topic1")).apply((Object)BoxesRunTime.boxToInteger((int)2)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})), (Object)((MapLike)actual.apply((Object)"topic2")).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 100})), (Object)((MapLike)actual.apply((Object)"topic2")).apply((Object)BoxesRunTime.boxToInteger((int)1)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})), (Object)((MapLike)actual.apply((Object)"topic2")).apply((Object)BoxesRunTime.boxToInteger((int)2)));
        java.util.Map replicaDirs = (java.util.Map)this.adminClient().describeReplicaLogDirs(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartitionReplica[]{replica1, replica2}))).asJavaCollection()).all().get();
        Assert.assertEquals((Object)proposedReplicaAssignment.apply((Object)replica1), (Object)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)replicaDirs.get(replica1)).getCurrentReplicaLogDir());
        Assert.assertEquals((Object)proposedReplicaAssignment.apply((Object)replica2), (Object)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)replicaDirs.get(replica2)).getCurrentReplicaLogDir());
    }

    @Test
    public void shouldExecuteThrottledReassignment() {
        int[] brokers = new int[]{100, 101, 102};
        this.startBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(brokers));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.servers());
        ReassignPartitionsCommand.Throttle initialThrottle = new ReassignPartitionsCommand.Throttle(10000000L, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReassignPartitionsClusterTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.zkUpdateDelay();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        int expectedDurationSecs = 5;
        int numMessages = 500;
        int msgSize = 100000;
        TestUtils$.MODULE$.produceMessages(this.servers(), this.topicName(), numMessages, 0, msgSize);
        Assert.assertEquals((long)expectedDurationSecs, (long)((long)(numMessages * msgSize) / initialThrottle.value()));
        Map newAssignment = (Map)ReassignPartitionsCommand$.MODULE$.generateAssignment(this.zkUtils(), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}), this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()})), true)._1();
        long start2 = System.currentTimeMillis();
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), (Option)None$.MODULE$, ReassignPartitionsCommand$.MODULE$.formatAsReassignmentJson(newAssignment, (Map)Map$.MODULE$.empty()), initialThrottle, ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigAddedToZK(initialThrottle.value(), this.servers(), this.topicName(), "0:100,0:101", "0:102");
        this.waitForReassignmentToComplete();
        long took = System.currentTimeMillis() - start2 - (long)this.delayMs();
        Map actual = (Map)this.zkUtils().getPartitionAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).apply((Object)this.topicName());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102})), (Object)((SeqLike)((TraversableOnce)actual.values().flatten((Function1)Predef$.MODULE$.$conforms())).toSeq().distinct()).sorted((Ordering)Ordering.Int$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected replication to be > ", " but was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)expectedDurationSecs * 0.9 * (double)1000)), BoxesRunTime.boxToLong((long)took)})), ((double)took > (double)expectedDurationSecs * 0.9 * (double)1000 ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected replication to be < ", " but was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(expectedDurationSecs * 2 * 1000)), BoxesRunTime.boxToLong((long)took)})), (took < (long)(expectedDurationSecs * 2 * 1000) ? 1 : 0) != 0);
    }

    @Test
    public void shouldOnlyThrottleMovingReplicas() {
        int[] brokers = new int[]{100, 101, 102, 103, 104, 105};
        this.startBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(brokers));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), "topic1", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 104})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), "topic2", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{104, 105}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{104, 105}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 104})))}))), this.servers());
        long throttle = 1000000L;
        TestUtils$.MODULE$.produceMessages(this.servers(), "topic1", 100, 0, 100000);
        TestUtils$.MODULE$.produceMessages(this.servers(), "topic2", 100, 0, 100000);
        Map newAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic2", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 105}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic2", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 105}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 104}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic2", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 104})))}));
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), (Option)None$.MODULE$, ReassignPartitionsCommand$.MODULE$.formatAsReassignmentJson(newAssignment, (Map)Map$.MODULE$.empty()), new ReassignPartitionsCommand.Throttle(throttle, ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$2()), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigAddedToZK(throttle, this.servers(), "topic1", "1:100,1:101,0:100,0:101", "1:102,0:102");
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigAddedToZK(throttle, this.servers(), "topic2", "1:104,1:105,0:104,0:105", "1:103,0:103");
    }

    @Test
    public void shouldChangeThrottleOnRerunAndRemoveOnVerify() {
        int[] brokers = new int[]{100, 101, 102};
        this.startBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(brokers));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.servers());
        long initialThrottle = 1000000L;
        TestUtils$.MODULE$.produceMessages(this.servers(), this.topicName(), 200, 0, 100000);
        Map newAssignment = (Map)ReassignPartitionsCommand$.MODULE$.generateAssignment(this.zkUtils(), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}), this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()})), true)._1();
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), (Option)None$.MODULE$, ReassignPartitionsCommand$.MODULE$.formatAsReassignmentJson(newAssignment, (Map)Map$.MODULE$.empty()), new ReassignPartitionsCommand.Throttle(initialThrottle, ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$2()), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigAddedToZK(initialThrottle, this.servers(), this.topicName(), "0:100,0:101", "0:102");
        ReassignPartitionsCommand$.MODULE$.verifyAssignment(this.zkUtils(), (Option)None$.MODULE$, ReassignPartitionsCommand$.MODULE$.formatAsReassignmentJson(newAssignment, (Map)Map$.MODULE$.empty()));
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigAddedToZK(initialThrottle, this.servers(), this.topicName(), "0:100,0:101", "0:102");
        long newThrottle = initialThrottle * 1000L;
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), (Option)None$.MODULE$, ReassignPartitionsCommand$.MODULE$.formatAsReassignmentJson(newAssignment, (Map)Map$.MODULE$.empty()), new ReassignPartitionsCommand.Throttle(newThrottle, ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$2()), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigAddedToZK(newThrottle, this.servers(), this.topicName(), "0:100,0:101", "0:102");
        this.waitForReassignmentToComplete();
        ReassignPartitionsCommand$.MODULE$.verifyAssignment(this.zkUtils(), (Option)None$.MODULE$, ReassignPartitionsCommand$.MODULE$.formatAsReassignmentJson(newAssignment, (Map)Map$.MODULE$.empty()));
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigRemovedFromZK(this.topicName(), this.servers());
        Map actual = (Map)this.zkUtils().getPartitionAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).apply((Object)this.topicName());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102})), (Object)((SeqLike)((TraversableOnce)actual.values().flatten((Function1)Predef$.MODULE$.$conforms())).toSeq().distinct()).sorted((Ordering)Ordering.Int$.MODULE$));
    }

    @Test(expected=AdminCommandFailedException.class)
    public void shouldFailIfProposedDoesNotMatchExisting() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})))}))), this.servers());
        String topicJson = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"version\":1,\"partitions\":[{\"topic\":\"", "\",\"partition\":1,\"replicas\":[101]}]}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicName()}));
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), (Option)None$.MODULE$, topicJson, ReassignPartitionsCommand$.MODULE$.NoThrottle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
    }

    @Test(expected=AdminCommandFailedException.class)
    public void shouldFailIfProposedHasEmptyReplicaList() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})))}))), this.servers());
        String topicJson = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"version\":1,\"partitions\":[{\"topic\":\"", "\",\"partition\":0,\"replicas\":[]}]}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicName()}));
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), (Option)None$.MODULE$, topicJson, ReassignPartitionsCommand$.MODULE$.NoThrottle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
    }

    @Test(expected=AdminCommandFailedException.class)
    public void shouldFailIfProposedHasInvalidBrokerID() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})))}))), this.servers());
        String topicJson = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"version\":1,\"partitions\":[{\"topic\":\"", "\",\"partition\":0,\"replicas\":[101, 102]}]}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicName()}));
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), (Option)None$.MODULE$, topicJson, ReassignPartitionsCommand$.MODULE$.NoThrottle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
    }

    @Test(expected=AdminCommandFailedException.class)
    public void shouldFailIfProposedHasInvalidLogDir() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))));
        this.adminClient_$eq(this.createAdminClient(this.servers()));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})))}))), this.servers());
        String topicJson = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"version\":1,\"partitions\":[{\"topic\":\"", "\",\"partition\":0,\"replicas\":[101],\"log_dirs\":[\"invalidDir\"]}]}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicName()}));
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), (Option)new Some((Object)this.adminClient()), topicJson, ReassignPartitionsCommand$.MODULE$.NoThrottle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
    }

    @Test(expected=AdminCommandFailedException.class)
    public void shouldFailIfProposedMoveReplicaWithinBroker() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))));
        this.adminClient_$eq(this.createAdminClient(this.servers()));
        String logDir = this.getRandomLogDirAssignment(100);
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})))}))), this.servers());
        String topicJson = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"version\":1,\"partitions\":[{\"topic\":\"", "\",\"partition\":0,\"replicas\":[100],\"log_dirs\":[\"", "\"]}]}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicName(), logDir}));
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), (Option)new Some((Object)this.adminClient()), topicJson, ReassignPartitionsCommand$.MODULE$.NoThrottle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
    }

    @Test(expected=AdminCommandFailedException.class)
    public void shouldFailIfProposedHasInconsistentReplicasAndLogDirs() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))));
        this.adminClient_$eq(this.createAdminClient(this.servers()));
        String logDir = this.getRandomLogDirAssignment(100);
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})))}))), this.servers());
        String topicJson = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"version\":1,\"partitions\":[{\"topic\":\"", "\",\"partition\":0,\"replicas\":[101],\"log_dirs\":[\"", "\", \"", "\"]}]}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicName(), logDir, logDir}));
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkUtils(), (Option)new Some((Object)this.adminClient()), topicJson, ReassignPartitionsCommand$.MODULE$.NoThrottle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
    }

    @Test
    public void shouldPerformThrottledReassignmentOverVariousTopics() {
        ReassignPartitionsCommand.Throttle throttle = new ReassignPartitionsCommand.Throttle(1000L, ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$2());
        this.servers_$eq((Seq<KafkaServer>)((Seq)TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties conf) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(conf), TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), "orders", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), "payments", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), "deliveries", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), "customers", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})))}))), this.servers());
        Map move = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("orders", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("orders", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("payments", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("deliveries", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
        ReassignPartitionsCommand qual$1 = new ReassignPartitionsCommand(this.zkUtils(), (Option)None$.MODULE$, move, ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4(), ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$5());
        ReassignPartitionsCommand.Throttle x$19 = throttle;
        long x$20 = qual$1.reassignPartitions$default$2();
        qual$1.reassignPartitions(x$19, x$20);
        this.waitForReassignmentToComplete();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3})), (Object)this.zkUtils().getReplicasForPartition("orders", 0));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Object)this.zkUtils().getReplicasForPartition("orders", 1));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)this.zkUtils().getReplicasForPartition("payments", 1));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)this.zkUtils().getReplicasForPartition("deliveries", 0));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)this.zkUtils().getReplicasForPartition("payments", 0));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)this.zkUtils().getReplicasForPartition("customers", 0));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Object)this.zkUtils().getReplicasForPartition("customers", 1));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Object)this.zkUtils().getReplicasForPartition("customers", 2));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), (Object)this.zkUtils().getReplicasForPartition("customers", 3));
    }

    public void waitForReassignmentToComplete() {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReassignPartitionsClusterTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.zkUtils().pathExists(ZkUtils$.MODULE$.ReassignPartitionsPath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Znode ", " wasn't deleted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ZkUtils$.MODULE$.ReassignPartitionsPath()}));
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    public String json(Seq<String> topic) {
        String topicStr = ((TraversableOnce)topic.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String t) {
                return new StringBuilder().append((Object)"{\"topic\": \"").append((Object)t).append((Object)"\"}").toString();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"topics\": [", "],\"version\":1}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicStr}));
    }

    public ReassignPartitionsClusterTest() {
        this.partitionId = 0;
        this.topicName = "my-topic";
        this.delayMs = 1000;
    }
}

