/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import kafka.api.PartitionMetadata;
import kafka.api.PartitionMetadata$;
import kafka.api.ProducerRequest;
import kafka.api.ProducerResponse;
import kafka.api.ProducerResponse$;
import kafka.api.ProducerResponseStatus;
import kafka.api.TopicMetadata;
import kafka.api.TopicMetadata$;
import kafka.cluster.BrokerEndPoint;
import kafka.common.ErrorMapping$;
import kafka.common.FailedToSendMessageException;
import kafka.common.QueueFullException;
import kafka.common.TopicAndPartition;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.NoCompressionCodec$;
import kafka.producer.KeyedMessage;
import kafka.producer.NegativePartitioner;
import kafka.producer.NegativePartitioner$;
import kafka.producer.Partitioner;
import kafka.producer.Producer;
import kafka.producer.ProducerClosedException;
import kafka.producer.ProducerConfig;
import kafka.producer.ProducerPool;
import kafka.producer.SyncProducer;
import kafka.producer.async.DefaultEventHandler;
import kafka.producer.async.EventHandler;
import kafka.producer.async.ProducerSendThread;
import kafka.serializer.DefaultEncoder;
import kafka.serializer.Encoder;
import kafka.serializer.NullEncoder;
import kafka.serializer.NullEncoder$;
import kafka.serializer.StringEncoder;
import kafka.serializer.StringEncoder$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.FixedValuePartitioner;
import kafka.utils.FixedValuePartitioner$;
import kafka.utils.IntEncoder;
import kafka.utils.IntEncoder$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u0001\u0003\u0001\u001d\u0011\u0011#Q:z]\u000e\u0004&o\u001c3vG\u0016\u0014H+Z:u\u0015\t\u0019A!\u0001\u0005qe>$WoY3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007\"B\b\u0001\t\u0003\u0001\u0012A\u0002\u001fj]&$h\bF\u0001\u0012!\t\u0011\u0002!D\u0001\u0003\u0011\u001d!\u0002A1A\u0005\u0002U\tQ\u0001\u001d:paN,\u0012A\u0006\t\u0004/iaR\"\u0001\r\u000b\u0005eQ\u0011AC2pY2,7\r^5p]&\u00111\u0004\u0007\u0002\u0004'\u0016\f\bCA\u000f#\u001b\u0005q\"BA\u0010!\u0003\u0011)H/\u001b7\u000b\u0003\u0005\nAA[1wC&\u00111E\b\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bBB\u0013\u0001A\u0003%a#\u0001\u0004qe>\u00048\u000f\t\u0005\bO\u0001\u0011\r\u0011\"\u0001)\u0003\u001d\u0019wN\u001c4jON,\u0012!\u000b\t\u0004/iQ\u0003CA\u0016/\u001b\u0005a#BA\u0017\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011q\u0006\f\u0002\f\u0017\u000647.Y\"p]\u001aLw\r\u0003\u00042\u0001\u0001\u0006I!K\u0001\tG>tg-[4tA!91\u0007\u0001b\u0001\n\u0003!\u0014A\u00032s_.,'\u000fT5tiV\tQ\u0007\u0005\u00027s9\u0011\u0011bN\u0005\u0003q)\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001e<\u0005\u0019\u0019FO]5oO*\u0011\u0001H\u0003\u0005\u0007{\u0001\u0001\u000b\u0011B\u001b\u0002\u0017\t\u0014xn[3s\u0019&\u001cH\u000f\t\u0005\u0006\u007f\u0001!\t\u0001Q\u0001\u0016i\u0016\u001cH\u000f\u0015:pIV\u001cWM])vKV,7+\u001b>f)\u0005\t\u0005CA\u0005C\u0013\t\u0019%B\u0001\u0003V]&$\bF\u0001 F!\t15*D\u0001H\u0015\tA\u0015*A\u0003kk:LGOC\u0001K\u0003\ry'oZ\u0005\u0003\u0019\u001e\u0013A\u0001V3ti\")a\n\u0001C\u0001\u0001\u00061B/Z:u!J|G-^2f\u0003\u001a$XM]\"m_N,G\r\u000b\u0002N\u000b\")\u0011\u000b\u0001C\u0001\u0001\u0006iA/Z:u\u0005\u0006$8\r[*ju\u0016D#\u0001U#\t\u000bQ\u0003A\u0011\u0001!\u0002)Q,7\u000f^)vKV,G+[7f\u000bb\u0004\u0018N]3eQ\t\u0019V\tC\u0003X\u0001\u0011\u0005\u0001)A\u000fuKN$\b+\u0019:uSRLwN\\!oI\u000e{G\u000e\\1uK\u00163XM\u001c;tQ\t1V\tC\u0003[\u0001\u0011\u0005\u0001)A\nuKN$8+\u001a:jC2L'0Z#wK:$8\u000f\u000b\u0002Z\u000b\")Q\f\u0001C\u0001\u0001\u0006!B/Z:u\u0013:4\u0018\r\\5e!\u0006\u0014H/\u001b;j_:D#\u0001X#\t\u000b\u0001\u0004A\u0011\u0001!\u0002\u0019Q,7\u000f\u001e(p\u0005J|7.\u001a:)\u0005}+\u0005\"B2\u0001\t\u0003\u0001\u0015a\u0006;fgRLenY8na\u0006$\u0018N\u00197f\u000b:\u001cw\u000eZ3sQ\t\u0011W\tC\u0003g\u0001\u0011\u0005\u0001)A\u000buKN$(+\u00198e_6\u0004\u0016M\u001d;ji&|g.\u001a:)\u0005\u0015,\u0005\"B5\u0001\t\u0003\u0001\u0015\u0001\u0007;fgR4\u0015-\u001b7fIN+g\u000e\u001a*fiJLHj\\4jG\"\u0012\u0001.\u0012\u0005\u0006Y\u0002!\t\u0001Q\u0001\u0011i\u0016\u001cHOS1wCB\u0013x\u000eZ;dKJD#a[#\t\u000b=\u0004A\u0011\u0001!\u00021Q,7\u000f^%om\u0006d\u0017\u000eZ\"p]\u001aLw-\u001e:bi&|g\u000e\u000b\u0002o\u000b\")!\u000f\u0001C\u0001g\u0006qq-\u001a;Qe>$WoY3ECR\fGc\u0001;\u0002\u0006A\u0019Q/`@\u000f\u0005Y\\hBA<{\u001b\u0005A(BA=\u0007\u0003\u0019a$o\\8u}%\t1\"\u0003\u0002}\u0015\u00059\u0001/Y2lC\u001e,\u0017BA\u000e\u007f\u0015\ta(\u0002E\u0003\u0013\u0003\u0003)T'C\u0002\u0002\u0004\t\u0011AbS3zK\u0012lUm]:bO\u0016Dq!a\u0002r\u0001\u0004\tI!A\u0004o\u000bZ,g\u000e^:\u0011\u0007%\tY!C\u0002\u0002\u000e)\u00111!\u00138u\u0011\u001d\t\t\u0002\u0001C\u0005\u0003'\t\u0001cZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1\u0015\u0019\u0005U\u0011\u0011EA\u0013\u0003S\ti#!\r\u0011\t\u0005]\u0011QD\u0007\u0003\u00033Q1!a\u0007\u0005\u0003\r\t\u0007/[\u0005\u0005\u0003?\tIBA\u0007U_BL7-T3uC\u0012\fG/\u0019\u0005\b\u0003G\ty\u00011\u00016\u0003\u0015!x\u000e]5d\u0011!\t9#a\u0004A\u0002\u0005%\u0011!\u00039beRLG/[8o\u0011!\tY#a\u0004A\u0002\u0005%\u0011\u0001\u00032s_.,'/\u00133\t\u000f\u0005=\u0012q\u0002a\u0001k\u0005Q!M]8lKJDun\u001d;\t\u0011\u0005M\u0012q\u0002a\u0001\u0003\u0013\t!B\u0019:pW\u0016\u0014\bk\u001c:u\u0011\u001d\t\t\u0002\u0001C\u0005\u0003o!B\"!\u0006\u0002:\u0005m\u0012qHA!\u0003\u0007Bq!a\t\u00026\u0001\u0007Q\u0007\u0003\u0005\u0002(\u0005U\u0002\u0019AA\u001f!\u0011)X0!\u0003\t\u0011\u0005-\u0012Q\u0007a\u0001\u0003\u0013Aq!a\f\u00026\u0001\u0007Q\u0007\u0003\u0005\u00024\u0005U\u0002\u0019AA\u0005\u0011\u001d\t9\u0005\u0001C\u0001\u0003\u0013\nQ\"\\3tg\u0006<Wm\u001d+p'\u0016$H\u0003BA&\u0003/\u0002B!!\u0014\u0002T5\u0011\u0011q\n\u0006\u0004\u0003#\"\u0011aB7fgN\fw-Z\u0005\u0005\u0003+\nyE\u0001\u000bCsR,')\u001e4gKJlUm]:bO\u0016\u001cV\r\u001e\u0005\t\u00033\n)\u00051\u0001\u0002\\\u0005AQ.Z:tC\u001e,7\u000fE\u0002v{VBq!a\u0012\u0001\t\u0003\ty\u0006\u0006\u0004\u0002L\u0005\u0005\u0014\u0011\u000f\u0005\t\u0003G\ni\u00061\u0001\u0002f\u0005\u00191.Z=\u0011\u000b%\t9'a\u001b\n\u0007\u0005%$BA\u0003BeJ\f\u0017\u0010E\u0002\n\u0003[J1!a\u001c\u000b\u0005\u0011\u0011\u0015\u0010^3\t\u0011\u0005e\u0013Q\fa\u0001\u0003g\u0002B!^?\u0002f\u0001")
public class AsyncProducerTest {
    private final Seq<Properties> props;
    private final Seq<KafkaConfig> configs;
    private final String brokerList;

    public Seq<Properties> props() {
        return this.props;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public String brokerList() {
        return this.brokerList;
    }

    @Test
    public void testProducerQueueSize() {
        EventHandler<String, String> mockEventHandler = new EventHandler<String, String>(this){

            public void handle(Seq<KeyedMessage<String, String>> events) {
                Thread.sleep(500L);
            }

            public void close() {
            }
        };
        Properties props = new Properties();
        props.put("serializer.class", "kafka.serializer.StringEncoder");
        props.put("metadata.broker.list", this.brokerList());
        props.put("producer.type", "async");
        props.put("queue.buffering.max.messages", "10");
        props.put("batch.num.messages", "1");
        props.put("queue.enqueue.timeout.ms", "0");
        ProducerConfig config = new ProducerConfig(props);
        Seq<KeyedMessage<String, String>> produceData = this.getProduceData(12);
        Producer producer = new Producer(config, (EventHandler)mockEventHandler);
        try {
            try {
                producer.send(produceData);
                Assert.fail((String)"Queue should be full");
            }
            catch (QueueFullException queueFullException) {}
        }
        finally {
            producer.close();
        }
    }

    @Test
    public void testProduceAfterClosed() {
        Seq<KeyedMessage<String, String>> produceData = this.getProduceData(10);
        Producer producer = TestUtils$.MODULE$.createProducer(this.brokerList(), StringEncoder.class.getName(), TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5());
        producer.close();
        try {
            producer.send(produceData);
            Assert.fail((String)"should complain that producer is already closed");
        }
        catch (ProducerClosedException producerClosedException) {
            // empty catch block
        }
    }

    @Test
    public void testBatchSize() {
        Seq<KeyedMessage<String, String>> producerDataList = this.getProduceData(10);
        DefaultEventHandler mockHandler = (DefaultEventHandler)EasyMock.createStrictMock(DefaultEventHandler.class);
        mockHandler.handle((Seq)producerDataList.take(5));
        EasyMock.expectLastCall();
        mockHandler.handle((Seq)producerDataList.takeRight(5));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{mockHandler});
        LinkedBlockingQueue queue = new LinkedBlockingQueue(10);
        ProducerSendThread producerSendThread = new ProducerSendThread("thread1", queue, (EventHandler)mockHandler, Integer.MAX_VALUE, 5, "");
        producerSendThread.start();
        producerDataList.foreach((Function1)new Serializable(this, queue){
            public static final long serialVersionUID = 0L;
            private final LinkedBlockingQueue queue$1;

            public final void apply(KeyedMessage<String, String> producerData) {
                this.queue$1.put(producerData);
            }
            {
                this.queue$1 = queue$1;
            }
        });
        producerSendThread.shutdown();
        EasyMock.verify((Object[])new Object[]{mockHandler});
    }

    @Test
    public void testQueueTimeExpired() {
        Seq<KeyedMessage<String, String>> producerDataList = this.getProduceData(2);
        DefaultEventHandler mockHandler = (DefaultEventHandler)EasyMock.createStrictMock(DefaultEventHandler.class);
        mockHandler.handle(producerDataList);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{mockHandler});
        int queueExpirationTime = 200;
        LinkedBlockingQueue queue = new LinkedBlockingQueue(10);
        ProducerSendThread producerSendThread = new ProducerSendThread("thread1", queue, (EventHandler)mockHandler, (long)queueExpirationTime, 5, "");
        producerSendThread.start();
        producerDataList.foreach((Function1)new Serializable(this, queue){
            public static final long serialVersionUID = 0L;
            private final LinkedBlockingQueue queue$2;

            public final void apply(KeyedMessage<String, String> producerData) {
                this.queue$2.put(producerData);
            }
            {
                this.queue$2 = queue$2;
            }
        });
        Thread.sleep(queueExpirationTime + 100);
        EasyMock.verify((Object[])new Object[]{mockHandler});
        producerSendThread.shutdown();
    }

    @Test
    public void testPartitionAndCollateEvents() {
        ArrayBuffer producerDataList = new ArrayBuffer();
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)BoxesRunTime.boxToInteger((int)0), (Object)new Message("msg1".getBytes()))}));
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic2", (Object)BoxesRunTime.boxToInteger((int)-99), (Object)BoxesRunTime.boxToInteger((int)1), (Object)new Message("msg2".getBytes()))}));
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)BoxesRunTime.boxToInteger((int)2), (Object)new Message("msg3".getBytes()))}));
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)BoxesRunTime.boxToInteger((int)-101), (Object)BoxesRunTime.boxToInteger((int)3), (Object)new Message("msg4".getBytes()))}));
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic2", (Object)BoxesRunTime.boxToInteger((int)4), (Object)new Message("msg5".getBytes()))}));
        Properties props = new Properties();
        props.put("metadata.broker.list", this.brokerList());
        BrokerEndPoint broker1 = new BrokerEndPoint(0, "localhost", 9092);
        BrokerEndPoint broker2 = new BrokerEndPoint(1, "localhost", 9093);
        PartitionMetadata partition1Metadata = new PartitionMetadata(0, (Option)new Some((Object)broker1), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerEndPoint[]{broker1, broker2})), PartitionMetadata$.MODULE$.$lessinit$greater$default$4(), PartitionMetadata$.MODULE$.$lessinit$greater$default$5());
        PartitionMetadata partition2Metadata = new PartitionMetadata(1, (Option)new Some((Object)broker2), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerEndPoint[]{broker1, broker2})), PartitionMetadata$.MODULE$.$lessinit$greater$default$4(), PartitionMetadata$.MODULE$.$lessinit$greater$default$5());
        TopicMetadata topic1Metadata = new TopicMetadata("topic1", (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PartitionMetadata[]{partition1Metadata, partition2Metadata})), TopicMetadata$.MODULE$.$lessinit$greater$default$3());
        TopicMetadata topic2Metadata = new TopicMetadata("topic2", (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PartitionMetadata[]{partition1Metadata, partition2Metadata})), TopicMetadata$.MODULE$.$lessinit$greater$default$3());
        HashMap topicPartitionInfos = new HashMap();
        topicPartitionInfos.put((Object)"topic1", (Object)topic1Metadata);
        topicPartitionInfos.put((Object)"topic2", (Object)topic2Metadata);
        Partitioner intPartitioner = new Partitioner(this){

            public int partition(Object key, int numPartitions) {
                return BoxesRunTime.unboxToInt((Object)key) % numPartitions;
            }
        };
        ProducerConfig config = new ProducerConfig(props);
        ProducerPool producerPool = new ProducerPool(config);
        DefaultEventHandler handler = new DefaultEventHandler(config, intPartitioner, null, (Encoder)new IntEncoder(IntEncoder$.MODULE$.$lessinit$greater$default$1()), producerPool, topicPartitionInfos);
        ArrayBuffer topic1Broker1Data = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)BoxesRunTime.boxToInteger((int)0), (Object)new Message("msg1".getBytes())), new KeyedMessage("topic1", (Object)BoxesRunTime.boxToInteger((int)2), (Object)new Message("msg3".getBytes()))}));
        ArrayBuffer topic1Broker2Data = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)BoxesRunTime.boxToInteger((int)-101), (Object)BoxesRunTime.boxToInteger((int)3), (Object)new Message("msg4".getBytes()))}));
        ArrayBuffer topic2Broker1Data = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic2", (Object)BoxesRunTime.boxToInteger((int)4), (Object)new Message("msg5".getBytes()))}));
        ArrayBuffer topic2Broker2Data = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic2", (Object)BoxesRunTime.boxToInteger((int)-99), (Object)BoxesRunTime.boxToInteger((int)1), (Object)new Message("msg2".getBytes()))}));
        Some expectedResult = new Some((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)topic1Broker1Data), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic2", 0)), (Object)topic2Broker1Data)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic1", 1)), (Object)topic1Broker2Data), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition("topic2", 1)), (Object)topic2Broker2Data)})))})));
        Option actualResult = handler.partitionAndCollate((Seq)producerDataList);
        Assert.assertEquals((Object)expectedResult, (Object)actualResult);
    }

    @Test
    public void testSerializeEvents() {
        Seq produceData = (Seq)TestUtils$.MODULE$.getMsgStrings(5).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KeyedMessage<String, String> apply(String m) {
                return new KeyedMessage("topic1", (Object)m);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Properties props = new Properties();
        props.put("metadata.broker.list", this.brokerList());
        ProducerConfig config = new ProducerConfig(props);
        TopicMetadata topic1Metadata = this.getTopicMetadata("topic1", 0, 0, "localhost", 9092);
        HashMap topicPartitionInfos = new HashMap();
        topicPartitionInfos.put((Object)"topic1", (Object)topic1Metadata);
        ProducerPool producerPool = new ProducerPool(config);
        DefaultEventHandler handler = new DefaultEventHandler(config, null, (Encoder)new StringEncoder(StringEncoder$.MODULE$.$lessinit$greater$default$1()), (Encoder)new StringEncoder(StringEncoder$.MODULE$.$lessinit$greater$default$1()), producerPool, topicPartitionInfos);
        Seq serializedData = handler.serialize(produceData);
        Seq deserializedData = (Seq)serializedData.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KeyedMessage<String, String> apply(KeyedMessage<String, Message> d) {
                return new KeyedMessage(d.topic(), (Object)TestUtils$.MODULE$.readString(((Message)d.message()).payload(), TestUtils$.MODULE$.readString$default$2()));
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq streamedSerializedData = handler.serialize((Seq)package$.MODULE$.Stream().apply(produceData));
        Seq deserializedStreamData = (Seq)streamedSerializedData.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KeyedMessage<String, String> apply(KeyedMessage<String, Message> d) {
                return new KeyedMessage(d.topic(), (Object)TestUtils$.MODULE$.readString(((Message)d.message()).payload(), TestUtils$.MODULE$.readString$default$2()));
            }
        }, Seq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.checkEquals(produceData.iterator(), deserializedData.iterator());
        TestUtils$.MODULE$.checkEquals(produceData.iterator(), deserializedStreamData.iterator());
    }

    @Test
    public void testInvalidPartition() {
        ArrayBuffer producerDataList = new ArrayBuffer();
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)"key1", (Object)new Message("msg1".getBytes()))}));
        Properties props = new Properties();
        props.put("metadata.broker.list", this.brokerList());
        ProducerConfig config = new ProducerConfig(props);
        TopicMetadata topic1Metadata = this.getTopicMetadata("topic1", 0, 0, "localhost", 9092);
        HashMap topicPartitionInfos = new HashMap();
        topicPartitionInfos.put((Object)"topic1", (Object)topic1Metadata);
        ProducerPool producerPool = new ProducerPool(config);
        DefaultEventHandler handler = new DefaultEventHandler(config, (Partitioner)new NegativePartitioner(NegativePartitioner$.MODULE$.$lessinit$greater$default$1()), null, null, producerPool, topicPartitionInfos);
        try {
            handler.partitionAndCollate((Seq)producerDataList);
        }
        catch (Throwable throwable) {
            Assert.fail((String)"Should not throw any exception");
        }
    }

    @Test
    public void testNoBroker() {
        Properties props = new Properties();
        props.put("metadata.broker.list", this.brokerList());
        ProducerConfig config = new ProducerConfig(props);
        TopicMetadata topic1Metadata = new TopicMetadata("topic1", (Seq)Seq$.MODULE$.empty(), TopicMetadata$.MODULE$.$lessinit$greater$default$3());
        HashMap topicPartitionInfos = new HashMap();
        topicPartitionInfos.put((Object)"topic1", (Object)topic1Metadata);
        ProducerPool producerPool = new ProducerPool(config);
        ArrayBuffer producerDataList = new ArrayBuffer();
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)"msg1")}));
        DefaultEventHandler handler = new DefaultEventHandler(config, null, (Encoder)new StringEncoder(StringEncoder$.MODULE$.$lessinit$greater$default$1()), (Encoder)new StringEncoder(StringEncoder$.MODULE$.$lessinit$greater$default$1()), producerPool, topicPartitionInfos);
        try {
            handler.handle((Seq)producerDataList);
            Assert.fail((String)"Should fail with FailedToSendMessageException");
        }
        catch (FailedToSendMessageException failedToSendMessageException) {
            // empty catch block
        }
    }

    @Test
    public void testIncompatibleEncoder() {
        Properties props = new Properties();
        props.put("message.send.max.retries", "0");
        String x$18 = this.brokerList();
        String x$19 = DefaultEncoder.class.getName();
        String x$20 = DefaultEncoder.class.getName();
        Properties x$21 = props;
        String x$22 = TestUtils$.MODULE$.createProducer$default$4();
        Producer producer = TestUtils$.MODULE$.createProducer(x$18, x$19, x$20, x$22, x$21);
        try {
            try {
                producer.send(this.getProduceData(1));
                Assert.fail((String)"Should fail with ClassCastException due to incompatible Encoder");
            }
            catch (ClassCastException classCastException) {}
        }
        finally {
            producer.close();
        }
    }

    @Test
    public void testRandomPartitioner() {
        Option option;
        block4: {
            block3: {
                block2: {
                    Option partitionedDataOpt;
                    Properties props = new Properties();
                    props.put("metadata.broker.list", this.brokerList());
                    ProducerConfig config = new ProducerConfig(props);
                    TopicMetadata topic1Metadata = this.getTopicMetadata("topic1", 0, 0, "localhost", 9092);
                    TopicMetadata topic2Metadata = this.getTopicMetadata("topic2", 0, 0, "localhost", 9092);
                    HashMap topicPartitionInfos = new HashMap();
                    topicPartitionInfos.put((Object)"topic1", (Object)topic1Metadata);
                    topicPartitionInfos.put((Object)"topic2", (Object)topic2Metadata);
                    ProducerPool producerPool = new ProducerPool(config);
                    DefaultEventHandler handler = new DefaultEventHandler(config, null, null, null, producerPool, topicPartitionInfos);
                    ArrayBuffer producerDataList = new ArrayBuffer();
                    producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)new Message("msg1".getBytes()))}));
                    producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic2", (Object)new Message("msg2".getBytes()))}));
                    producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)new Message("msg3".getBytes()))}));
                    option = partitionedDataOpt = handler.partitionAndCollate((Seq)producerDataList);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Map partitionedData = (Map)some.x();
                    partitionedData.withFilter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<String, Message>>>> check$ifrefutable$1) {
                            Tuple2<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<String, Message>>>> tuple2 = check$ifrefutable$1;
                            boolean bl = tuple2 != null;
                            return bl;
                        }
                    }).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(Tuple2<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<String, Message>>>> x$2) {
                            Tuple2<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<String, Message>>>> tuple2 = x$2;
                            if (tuple2 != null) {
                                scala.collection.mutable.Map dataPerBroker = (scala.collection.mutable.Map)tuple2._2();
                                dataPerBroker.withFilter((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(Tuple2<TopicAndPartition, Seq<KeyedMessage<String, Message>>> check$ifrefutable$2) {
                                        TopicAndPartition topicAndPartition;
                                        Tuple2<TopicAndPartition, Seq<KeyedMessage<String, Message>>> tuple2 = check$ifrefutable$2;
                                        boolean bl = tuple2 != null && (topicAndPartition = (TopicAndPartition)tuple2._1()) != null;
                                        return bl;
                                    }
                                }).foreach((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply(Tuple2<TopicAndPartition, Seq<KeyedMessage<String, Message>>> x$1) {
                                        TopicAndPartition topicAndPartition;
                                        Tuple2<TopicAndPartition, Seq<KeyedMessage<String, Message>>> tuple2 = x$1;
                                        if (tuple2 != null && (topicAndPartition = (TopicAndPartition)tuple2._1()) != null) {
                                            int partitionId = topicAndPartition.partition();
                                            Assert.assertTrue((partitionId == 0 ? 1 : 0) != 0);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            return;
                                        }
                                        throw new MatchError(tuple2);
                                    }
                                });
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                Assert.fail((String)"Failed to collate requests by topic, partition");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    @Test
    public void testFailedSendRetryLogic() {
        Properties props = new Properties();
        props.put("metadata.broker.list", this.brokerList());
        props.put("request.required.acks", "1");
        props.put("serializer.class", StringEncoder.class.getName().toString());
        props.put("key.serializer.class", NullEncoder.class.getName().toString());
        props.put("producer.num.retries", ((Object)BoxesRunTime.boxToInteger((int)3)).toString());
        ProducerConfig config = new ProducerConfig(props);
        String topic1 = "topic1";
        TopicMetadata topic1Metadata = this.getTopicMetadata(topic1, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}), 0, "localhost", 9092);
        HashMap topicPartitionInfos = new HashMap();
        topicPartitionInfos.put((Object)"topic1", (Object)topic1Metadata);
        Seq<String> msgs = TestUtils$.MODULE$.getMsgStrings(2);
        List x$23 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1}));
        List x$24 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        ByteBufferMessageSet x$25 = this.messagesToSet(msgs);
        int x$26 = 1;
        int x$27 = 11;
        int x$28 = TestUtils$.MODULE$.produceRequestWithAcks$default$5();
        String x$29 = TestUtils$.MODULE$.produceRequestWithAcks$default$7();
        ProducerRequest request1 = TestUtils$.MODULE$.produceRequestWithAcks((Seq<String>)x$23, (Seq<Object>)x$24, x$25, x$26, x$28, x$27, x$29);
        List x$30 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1}));
        List x$31 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        ByteBufferMessageSet x$32 = this.messagesToSet(msgs);
        int x$33 = 1;
        int x$34 = 17;
        int x$35 = TestUtils$.MODULE$.produceRequestWithAcks$default$5();
        String x$36 = TestUtils$.MODULE$.produceRequestWithAcks$default$7();
        ProducerRequest request2 = TestUtils$.MODULE$.produceRequestWithAcks((Seq<String>)x$30, (Seq<Object>)x$31, x$32, x$33, x$35, x$34, x$36);
        ProducerResponse response1 = new ProducerResponse(0, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new TopicAndPartition("topic1", 0), (Object)new ProducerResponseStatus(ErrorMapping$.MODULE$.NotLeaderForPartitionCode(), 0L)), new Tuple2((Object)new TopicAndPartition("topic1", 1), (Object)new ProducerResponseStatus(ErrorMapping$.MODULE$.NoError(), 0L))})), ProducerResponse$.MODULE$.apply$default$3(), ProducerResponse$.MODULE$.apply$default$4());
        String x$37 = topic1;
        int x$38 = 0;
        ByteBufferMessageSet x$39 = this.messagesToSet(msgs);
        int x$40 = 1;
        int x$41 = 21;
        int x$42 = TestUtils$.MODULE$.produceRequest$default$5();
        String x$43 = TestUtils$.MODULE$.produceRequest$default$7();
        ProducerRequest request3 = TestUtils$.MODULE$.produceRequest(x$37, x$38, x$39, x$40, x$42, x$41, x$43);
        ProducerResponse response2 = new ProducerResponse(0, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new TopicAndPartition("topic1", 0), (Object)new ProducerResponseStatus(ErrorMapping$.MODULE$.NoError(), 0L))})), ProducerResponse$.MODULE$.apply$default$3(), ProducerResponse$.MODULE$.apply$default$4());
        SyncProducer mockSyncProducer = (SyncProducer)EasyMock.createMock(SyncProducer.class);
        EasyMock.expect((Object)mockSyncProducer.config()).andReturn(EasyMock.anyObject()).anyTimes();
        EasyMock.expect((Object)mockSyncProducer.send(request1)).andThrow((Throwable)new RuntimeException());
        EasyMock.expect((Object)mockSyncProducer.send(request2)).andReturn((Object)response1);
        EasyMock.expect((Object)mockSyncProducer.send(request3)).andReturn((Object)response2);
        EasyMock.replay((Object[])new Object[]{mockSyncProducer});
        ProducerPool producerPool = (ProducerPool)EasyMock.createMock(ProducerPool.class);
        EasyMock.expect((Object)producerPool.getProducer(0)).andReturn((Object)mockSyncProducer).times(4);
        producerPool.close();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{producerPool});
        DefaultEventHandler handler = new DefaultEventHandler(config, (Partitioner)new FixedValuePartitioner(FixedValuePartitioner$.MODULE$.$lessinit$greater$default$1()), (Encoder)new StringEncoder(StringEncoder$.MODULE$.$lessinit$greater$default$1()), (Encoder)new NullEncoder(NullEncoder$.MODULE$.$lessinit$greater$default$1()), producerPool, topicPartitionInfos);
        Seq data = (Seq)((TraversableLike)msgs.map((Function1)new Serializable(this, topic1){
            public static final long serialVersionUID = 0L;
            private final String topic1$1;

            public final KeyedMessage<Object, String> apply(String m) {
                return new KeyedMessage(this.topic1$1, (Object)BoxesRunTime.boxToInteger((int)0), (Object)m);
            }
            {
                this.topic1$1 = topic1$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)msgs.map((Function1)new Serializable(this, topic1){
            public static final long serialVersionUID = 0L;
            private final String topic1$1;

            public final KeyedMessage<Object, String> apply(String m) {
                return new KeyedMessage(this.topic1$1, (Object)BoxesRunTime.boxToInteger((int)1), (Object)m);
            }
            {
                this.topic1$1 = topic1$1;
            }
        }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        handler.handle(data);
        handler.close();
        EasyMock.verify((Object[])new Object[]{mockSyncProducer});
        EasyMock.verify((Object[])new Object[]{producerPool});
    }

    @Test
    public void testJavaProducer() {
        String topic = "topic1";
        Seq<String> msgs = TestUtils$.MODULE$.getMsgStrings(5);
        Seq scalaProducerData = (Seq)msgs.map((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$1;

            public final KeyedMessage<String, String> apply(String m) {
                return new KeyedMessage(this.topic$1, (Object)m);
            }
            {
                this.topic$1 = topic$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        java.util.List javaProducerData = JavaConversions$.MODULE$.seqAsJavaList(scalaProducerData);
        Producer mockScalaProducer = (Producer)EasyMock.createMock(Producer.class);
        mockScalaProducer.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{(KeyedMessage)scalaProducerData.head()}));
        EasyMock.expectLastCall();
        mockScalaProducer.send(scalaProducerData);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{mockScalaProducer});
        kafka.javaapi.producer.Producer javaProducer = new kafka.javaapi.producer.Producer(mockScalaProducer);
        javaProducer.send((KeyedMessage)javaProducerData.get(0));
        javaProducer.send(javaProducerData);
        EasyMock.verify((Object[])new Object[]{mockScalaProducer});
    }

    @Test
    public void testInvalidConfiguration() {
        Properties props = new Properties();
        props.put("serializer.class", "kafka.serializer.StringEncoder");
        props.put("producer.type", "async");
        try {
            new ProducerConfig(props);
            Assert.fail((String)"should complain about wrong config");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     */
    public Seq<KeyedMessage<String, String>> getProduceData(int nEvents) {
        void var2_2;
        ArrayBuffer producerDataList = new ArrayBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nEvents).foreach$mVc$sp((Function1)new Serializable(this, producerDataList){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer producerDataList$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.producerDataList$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", null, (Object)new StringBuilder().append((Object)"msg").append((Object)BoxesRunTime.boxToInteger((int)i)).toString())}));
            }
            {
                this.producerDataList$1 = producerDataList$1;
            }
        });
        return var2_2;
    }

    private TopicMetadata getTopicMetadata(String topic, int partition, int brokerId, String brokerHost, int brokerPort) {
        return this.getTopicMetadata(topic, (Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{partition})), brokerId, brokerHost, brokerPort);
    }

    private TopicMetadata getTopicMetadata(String topic, Seq<Object> partition, int brokerId, String brokerHost, int brokerPort) {
        BrokerEndPoint broker1 = new BrokerEndPoint(brokerId, brokerHost, brokerPort);
        return new TopicMetadata(topic, (Seq)partition.map((Function1)new Serializable(this, broker1){
            public static final long serialVersionUID = 0L;
            private final BrokerEndPoint broker1$1;

            public final PartitionMetadata apply(int x$3) {
                return new PartitionMetadata(x$3, (Option)new Some((Object)this.broker1$1), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BrokerEndPoint[]{this.broker1$1})), PartitionMetadata$.MODULE$.$lessinit$greater$default$4(), PartitionMetadata$.MODULE$.$lessinit$greater$default$5());
            }
            {
                this.broker1$1 = broker1$1;
            }
        }, Seq$.MODULE$.canBuildFrom()), TopicMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public ByteBufferMessageSet messagesToSet(Seq<String> messages2) {
        return new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)messages2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Message apply(String m) {
                return new Message(m.getBytes());
            }
        }, Seq$.MODULE$.canBuildFrom()));
    }

    public ByteBufferMessageSet messagesToSet(byte[] key, Seq<byte[]> messages2) {
        return new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)messages2.map((Function1)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final byte[] key$1;

            public final Message apply(byte[] m) {
                byte[] x$44 = this.key$1;
                byte[] x$45 = m;
                return new Message(x$45, x$44);
            }
            {
                this.key$1 = key$1;
            }
        }, Seq$.MODULE$.canBuildFrom()));
    }

    public AsyncProducerTest() {
        Properties[] propertiesArray = new Properties[1];
        int x$4 = 1;
        String x$5 = "127.0.0.1:1";
        int x$6 = 65534;
        boolean x$7 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$8 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$9 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$10 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        boolean x$16 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        propertiesArray[0] = TestUtils$.MODULE$.createBrokerConfig(x$4, x$5, x$7, x$8, x$6, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17);
        this.props = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])propertiesArray));
        this.configs = (Seq)this.props().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.brokerList = ((TraversableOnce)this.configs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(KafkaConfig c) {
                return Utils.formatAddress((String)c.hostName(), (Integer)c.port());
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
    }
}

