/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.util.Hashtable;
import java.util.Properties;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001-4A!\u0001\u0002\u0001\u000f\t\t\"k\u001c7mS:<'i\\;oG\u0016$Vm\u001d;\u000b\u0005\r!\u0011aC5oi\u0016<'/\u0019;j_:T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0005\t\u0003\u0013Ai\u0011A\u0003\u0006\u0003\u00171\tQA[;oSRT!!\u0004\b\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\b\u0002\u0007=\u0014x-\u0003\u0002\u0012\u0015\tQ!*\u00168jiN+\u0018\u000e^3\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U!\u0011A\u0001>l\u0013\t9BC\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o\u001d\u0005\u00063\u0001!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"\u0001\b\u0001\u000e\u0003\tAqA\b\u0001C\u0002\u0013\u0005q$A\u0006qCJ$\u0018\u000e^5p]&#W#\u0001\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\u0007%sG\u000f\u0003\u0004(\u0001\u0001\u0006I\u0001I\u0001\ra\u0006\u0014H/\u001b;j_:LE\r\t\u0005\bS\u0001\u0001\r\u0011\"\u0001+\u0003\u001d\u0019XM\u001d<feN,\u0012a\u000b\t\u0004YQ:dBA\u00173\u001d\tq\u0013'D\u00010\u0015\t\u0001d!\u0001\u0004=e>|GOP\u0005\u0002G%\u00111GI\u0001\ba\u0006\u001c7.Y4f\u0013\t)dGA\u0002TKFT!a\r\u0012\u0011\u0005aZT\"A\u001d\u000b\u0005i\"\u0011AB:feZ,'/\u0003\u0002=s\tY1*\u00194lCN+'O^3s\u0011\u001dq\u0004\u00011A\u0005\u0002}\n1b]3sm\u0016\u00148o\u0018\u0013fcR\u0011\u0001i\u0011\t\u0003C\u0005K!A\u0011\u0012\u0003\tUs\u0017\u000e\u001e\u0005\b\tv\n\t\u00111\u0001,\u0003\rAH%\r\u0005\u0007\r\u0002\u0001\u000b\u0015B\u0016\u0002\u0011M,'O^3sg\u0002BQ\u0001\u0013\u0001\u0005B%\u000bQa]3u+B$\u0012\u0001\u0011\u0015\u0003\u000f.\u0003\"\u0001\u0014(\u000e\u00035S!a\u0003\b\n\u0005=k%A\u0002\"fM>\u0014X\rC\u0003R\u0001\u0011\u0005\u0013*\u0001\u0005uK\u0006\u0014Hi\\<oQ\t\u00016\u000b\u0005\u0002M)&\u0011Q+\u0014\u0002\u0006\u0003\u001a$XM\u001d\u0005\u0006/\u0002!\t\u0001W\u0001\u0012i\u0016\u001cHOU8mY&twMQ8v]\u000e,W#\u0001!)\u0005YS\u0006C\u0001'\\\u0013\taVJ\u0001\u0003UKN$\b\"\u00020\u0001\t\u0013y\u0016\u0001\u00042pk:\u001cWmU3sm\u0016\u0014Hc\u0001!aS\")\u0011-\u0018a\u0001E\u0006)Ao\u001c9jGB\u00111M\u001a\b\u0003C\u0011L!!\u001a\u0012\u0002\rA\u0013X\rZ3g\u0013\t9\u0007N\u0001\u0004TiJLgn\u001a\u0006\u0003K\nBQA[/A\u0002\u0001\n!b\u001d;beRLe\u000eZ3y\u0001")
public class RollingBounceTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private final int partitionId;
    private Seq<KafkaServer> servers;
    private EmbeddedZookeeper zookeeper;
    private int zkPort;
    private ZkUtils zkUtils;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public int zkPort() {
        return this.zkPort;
    }

    @Override
    public void zkPort_$eq(int x$1) {
        this.zkPort = x$1;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    @Override
    public String confFile() {
        return ZooKeeperTestHarness$class.confFile(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        RollingBounceTest rollingBounceTest = this;
        synchronized (rollingBounceTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public int partitionId() {
        return this.partitionId;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        IndexedSeq configs = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RollingBounceTest $outer;

            public final Properties apply(int i) {
                return TestUtils$.MODULE$.createBrokerConfig(i, this.$outer.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        ((Hashtable)configs.apply(3)).put("controlled.shutdown.retry.backoff.ms", "100");
        this.servers_$eq((Seq<KafkaServer>)((Seq)configs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(Properties c) {
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(c), TestUtils$.MODULE$.createServer$default$2());
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())));
    }

    @Override
    @After
    public void tearDown() {
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$1) {
                x$1.shutdown();
            }
        });
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                CoreUtils$.MODULE$.rm(server.config().logDirs());
            }
        });
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Test
    public void testRollingBounce() {
        String topic1 = "new-topic1";
        String topic2 = "new-topic2";
        String topic3 = "new-topic3";
        String topic4 = "new-topic4";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic1, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic2, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic3, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic4, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3})))}))), this.servers());
        this.bounceServer(topic1, 0);
        this.bounceServer(topic2, 1);
        this.bounceServer(topic3, 2);
        this.bounceServer(topic4, 3);
    }

    private void bounceServer(String topic, int startIndex) {
        int prevLeader = 0;
        if (TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, this.partitionId(), (KafkaServer)this.servers().apply(startIndex))) {
            ((KafkaServer)this.servers().apply(startIndex)).shutdown();
            prevLeader = startIndex;
        } else {
            ((KafkaServer)this.servers().apply((startIndex + 1) % 4)).shutdown();
            prevLeader = (startIndex + 1) % 4;
        }
        Option<Object> newleader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), topic, this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        Assert.assertTrue((String)new StringBuilder().append((Object)"Leader transition did not happen for ").append((Object)topic).toString(), (BoxesRunTime.unboxToInt((Object)newleader.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })) != -1 && BoxesRunTime.unboxToInt((Object)newleader.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })) != prevLeader ? 1 : 0) != 0);
        ((KafkaServer)this.servers().apply(prevLeader)).startup();
    }

    public RollingBounceTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        this.partitionId = 0;
        this.servers = null;
    }
}

