/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.Properties;
import java.util.regex.Pattern;
import kafka.api.BaseConsumerTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.NoOffsetForPartitionException;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t\ra\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003\u00157bS:$X\r\u001f;D_:\u001cX/\\3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0011\u0005\u0006\u001cXmQ8ogVlWM\u001d+fgRDQ!\u0004\u0001\u0005\u00029\ta\u0001P5oSRtD#A\b\u0011\u0005%\u0001\u0001\"B\t\u0001\t\u0003\u0011\u0012!\u0006;fgR\fU\u000f^8D_6l\u0017\u000e^(o\u00072|7/\u001a\u000b\u0002'A\u0011AcF\u0007\u0002+)\ta#A\u0003tG\u0006d\u0017-\u0003\u0002\u0019+\t!QK\\5uQ\t\u0001\"\u0004\u0005\u0002\u001cA5\tAD\u0003\u0002\u001e=\u0005)!.\u001e8ji*\tq$A\u0002pe\u001eL!!\t\u000f\u0003\tQ+7\u000f\u001e\u0005\u0006G\u0001!\tAE\u0001!i\u0016\u001cH/Q;u_\u000e{W.\\5u\u001f:\u001cEn\\:f\u0003\u001a$XM],bW\u0016,\b\u000f\u000b\u0002#5!)a\u0005\u0001C\u0001%\u0005\u0019B/Z:u\u0003V$xn\u00144gg\u0016$(+Z:fi\"\u0012QE\u0007\u0005\u0006S\u0001!\tAE\u0001\u0015i\u0016\u001cHo\u0012:pkB\u001cuN\\:v[B$\u0018n\u001c8)\u0005!R\u0002\"\u0002\u0017\u0001\t\u0003\u0011\u0012a\u0006;fgR\u0004\u0016\r\u001e;fe:\u001cVOY:de&\u0004H/[8oQ\tY#\u0004C\u00030\u0001\u0011\u0005!#A\ruKN$\b+\u0019;uKJtWK\\:vEN\u001c'/\u001b9uS>t\u0007F\u0001\u0018\u001b\u0011\u0015\u0011\u0004\u0001\"\u0001\u0013\u0003I!Xm\u001d;D_6l\u0017\u000e^'fi\u0006$\u0017\r^1)\u0005ER\u0002\"B\u001b\u0001\t\u0003\u0011\u0012a\b;fgR,\u0005\u0010]1oI&tw\rV8qS\u000e\u001cVOY:de&\u0004H/[8og\"\u0012AG\u0007\u0005\u0006q\u0001!\tAE\u0001 i\u0016\u001cHo\u00155sS:\\\u0017N\\4U_BL7mU;cg\u000e\u0014\u0018\u000e\u001d;j_:\u001c\bFA\u001c\u001b\u0011\u0015Y\u0004\u0001\"\u0001\u0013\u0003E!Xm\u001d;QCJ$\u0018\u000e^5p]N4uN\u001d\u0015\u0003uiAQA\u0010\u0001\u0005\u0002I\t1\u0004^3tiB\u000b'\u000f^5uS>t7OR8s\u0003V$xn\u0011:fCR,\u0007FA\u001f\u001b\u0011\u0015\t\u0005\u0001\"\u0001\u0013\u0003u!Xm\u001d;QCJ$\u0018\u000e^5p]N4uN]%om\u0006d\u0017\u000e\u001a+pa&\u001c\u0007\u0006\u0002!\u001b\u0007\u0012\u000b\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0002\u000bB\u0011aIT\u0007\u0002\u000f*\u0011\u0001*S\u0001\u0007KJ\u0014xN]:\u000b\u0005)[\u0015AB2p[6|gN\u0003\u0002\u0006\u0019*\u0011QJH\u0001\u0007CB\f7\r[3\n\u0005=;%!F%om\u0006d\u0017\u000e\u001a+pa&\u001cW\t_2faRLwN\u001c\u0005\u0006#\u0002!\tAE\u0001\ti\u0016\u001cHoU3fW\"\u0012\u0001K\u0007\u0005\u0006)\u0002!I!V\u0001\u0017g\u0016tGmQ8naJ,7o]3e\u001b\u0016\u001c8/Y4fgR\u00191CV.\t\u000b]\u001b\u0006\u0019\u0001-\u0002\u00159,XNU3d_J$7\u000f\u0005\u0002\u00153&\u0011!,\u0006\u0002\u0004\u0013:$\b\"\u0002/T\u0001\u0004i\u0016A\u0001;q!\tqv,D\u0001J\u0013\t\u0001\u0017J\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000b\t\u0004A\u0011\u0001\n\u0002+Q,7\u000f\u001e)pg&$\u0018n\u001c8B]\u0012\u001cu.\\7ji\")A\r\u0001C\u0001%\u0005YB/Z:u!\u0006\u0014H/\u001b;j_:\u0004\u0016-^:f\u0003:$'+Z:v[\u0016D#a\u0019\u000e\t\u000b\u001d\u0004A\u0011\u0001\n\u0002-Q,7\u000f\u001e$fi\u000eD\u0017J\u001c<bY&$wJ\u001a4tKRD#A\u001a\u000e\t\u000b)\u0004A\u0011\u0001\n\u0002/Q,7\u000f\u001e$fi\u000eD'+Z2pe\u0012$vn\u001c'be\u001e,\u0007FA5\u001b\u0011\u0015i\u0007\u0001\"\u0001\u0013\u0003a!Xm\u001d;S_VtGMU8cS:\f5o]5h]6,g\u000e\u001e\u0015\u0003YjAQ\u0001\u001d\u0001\u0005\u0002I\tQ\u0005^3ti6+H\u000e^5D_:\u001cX/\\3s%>,h\u000e\u001a*pE&t\u0017i]:jO:lWM\u001c;)\u0005=T\u0002\"B:\u0001\t\u0003\u0011\u0012A\t;fgRlU\u000f\u001c;j\u0007>t7/^7fe\u0012+g-Y;mi\u0006\u001b8/[4o[\u0016tG\u000f\u000b\u0002s5!)a\u000f\u0001C\u0001%\u0005aC/Z:u\u001bVdG/[\"p]N,X.\u001a:TKN\u001c\u0018n\u001c8US6,w.\u001e;P]N#x\u000e\u001d)pY2Lgn\u001a\u0015\u0003kjAQ!\u001f\u0001\u0005\u0002I\ta\u0005^3ti6+H\u000e^5D_:\u001cX/\\3s'\u0016\u001c8/[8o)&lWm\\;u\u001f:\u001cEn\\:fQ\tA(\u0004C\u0003}\u0001\u0011\u0005Q0\u0001\u0012sk:lU\u000f\u001c;j\u0007>t7/^7feN+7o]5p]RKW.Z8viR+7\u000f\u001e\u000b\u0003'yDaa`>A\u0002\u0005\u0005\u0011!D2m_N,7i\u001c8tk6,'\u000fE\u0002\u0015\u0003\u0007I1!!\u0002\u0016\u0005\u001d\u0011un\u001c7fC:Dq!!\u0003\u0001\t\u0003\tY!A\rde\u0016\fG/\u001a+pa&\u001c\u0017I\u001c3TK:$'+Z2pe\u0012\u001cH\u0003CA\u0007\u00037\t)#!\u000b\u0011\u000b\u0005=\u0011QC/\u000f\u0007Q\t\t\"C\u0002\u0002\u0014U\ta\u0001\u0015:fI\u00164\u0017\u0002BA\f\u00033\u00111aU3u\u0015\r\t\u0019\"\u0006\u0005\t\u0003;\t9\u00011\u0001\u0002 \u0005IAo\u001c9jG:\u000bW.\u001a\t\u0005\u0003\u001f\t\t#\u0003\u0003\u0002$\u0005e!AB*ue&tw\rC\u0004\u0002(\u0005\u001d\u0001\u0019\u0001-\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t\u0011\u001d\tY#a\u0002A\u0002a\u000b1C]3d_J$7\u000fU3s!\u0006\u0014H/\u001b;j_:Dq!a\f\u0001\t\u0003\t\t$\u0001\u0011tk\n\u001c8M]5cK\u000e{gn];nKJ\fe\u000eZ*uCJ$\bk\u001c7mS:<GCBA\u001a\u0003w\tI\u0006\u0005\u0003\u00026\u0005]R\"\u0001\u0001\n\u0007\u0005e\"B\u0001\rD_:\u001cX/\\3s\u0003N\u001c\u0018n\u001a8nK:$\bk\u001c7mKJD\u0001\"!\u0010\u0002.\u0001\u0007\u0011qH\u0001\tG>t7/^7feBA\u0011\u0011IA%\u0003\u001b\ni%\u0004\u0002\u0002D)!\u0011QHA#\u0015\r\t9eS\u0001\bG2LWM\u001c;t\u0013\u0011\tY%a\u0011\u0003\u0011\r{gn];nKJ\u0004R\u0001FA(\u0003'J1!!\u0015\u0016\u0005\u0015\t%O]1z!\r!\u0012QK\u0005\u0004\u0003/*\"\u0001\u0002\"zi\u0016D\u0001\"a\u0017\u0002.\u0001\u0007\u0011QL\u0001\u0012i>\u0004\u0018nY:U_N+(m]2sS\n,\u0007CBA0\u0003_\nyB\u0004\u0003\u0002b\u0005-d\u0002BA2\u0003Sj!!!\u001a\u000b\u0007\u0005\u001dd!\u0001\u0004=e>|GOP\u0005\u0002-%\u0019\u0011QN\u000b\u0002\u000fA\f7m[1hK&!\u0011\u0011OA:\u0005\u0011a\u0015n\u001d;\u000b\u0007\u00055T\u0003C\u0004\u0002x\u0001!\t!!\u001f\u0002MM,(m]2sS\n,7i\u001c8tk6,'o]!oI^\u000b\u0017\u000e\u001e$pe\u0006\u001b8/[4o[\u0016tG\u000f\u0006\u0005\u0002|\u0005-\u0015qSAM!\u0019\ti(a\"\u000245\u0011\u0011q\u0010\u0006\u0005\u0003\u0003\u000b\u0019)A\u0004nkR\f'\r\\3\u000b\u0007\u0005\u0015U#\u0001\u0006d_2dWm\u0019;j_:LA!!#\u0002\u0000\t1!)\u001e4gKJD\u0001\"!$\u0002v\u0001\u0007\u0011qR\u0001\u000eG>t7/^7fe\u001e\u0013x.\u001e9\u0011\r\u0005u\u0014qQAI!!\t\t%a%\u0002N\u00055\u0013\u0002BAK\u0003\u0007\u0012QbS1gW\u0006\u001cuN\\:v[\u0016\u0014\b\u0002CA.\u0003k\u0002\r!!\u0018\t\u0011\u0005m\u0015Q\u000fa\u0001\u0003\u001b\tQb];cg\u000e\u0014\u0018\u000e\u001d;j_:\u001c\bbBAP\u0001\u0011\u0005\u0011\u0011U\u0001(GJ,\u0017\r^3D_:\u001cX/\\3s\u000fJ|W\u000f]!oI^\u000b\u0017\u000e\u001e$pe\u0006\u001b8/[4o[\u0016tG\u000f\u0006\u0005\u0002$\u0006%\u0016QVAX!\u001d!\u0012QUAH\u0003wJ1!a*\u0016\u0005\u0019!V\u000f\u001d7fe!9\u00111VAO\u0001\u0004A\u0016!D2p]N,X.\u001a:D_VtG\u000f\u0003\u0005\u0002\\\u0005u\u0005\u0019AA/\u0011!\tY*!(A\u0002\u00055\u0001bBAZ\u0001\u0011\u0005\u0011QW\u0001-C\u0012$7i\u001c8tk6,'o\u001d+p\u000fJ|W\u000f]!oI^\u000b\u0017\u000e\u001e$pe\u001e\u0013x.\u001e9BgNLwM\\7f]R$2bEA\\\u0003w\u000bi,!1\u0002D\"9\u0011\u0011XAY\u0001\u0004A\u0016a\u00058v[>37i\u001c8tk6,'o\u001d+p\u0003\u0012$\u0007\u0002CAG\u0003c\u0003\r!a$\t\u0011\u0005}\u0016\u0011\u0017a\u0001\u0003w\nqbY8ogVlWM\u001d)pY2,'o\u001d\u0005\t\u00037\n\t\f1\u0001\u0002^!A\u00111TAY\u0001\u0004\ti\u0001C\u0004\u0002H\u0002!\t!!3\u0002/Y\fG.\u001b3bi\u0016<%o\\;q\u0003N\u001c\u0018n\u001a8nK:$H#C\n\u0002L\u00065\u0017qZAj\u0011!\ty,!2A\u0002\u0005m\u0004\u0002CAN\u0003\u000b\u0004\r!!\u0004\t\u0011\u0005E\u0017Q\u0019a\u0001\u0003?\t1!\\:h\u0011)\t).!2\u0011\u0002\u0003\u0007\u0011q[\u0001\to\u0006LG\u000fV5nKB\u0019A#!7\n\u0007\u0005mWC\u0001\u0003M_:<\u0007bBAp\u0001\u0011\u0005\u0011\u0011]\u00015G\"\fgnZ3D_:\u001cX/\\3s\u000fJ|W\u000f]*vEN\u001c'/\u001b9uS>t\u0017I\u001c3WC2LG-\u0019;f\u0003N\u001c\u0018n\u001a8nK:$HcB\n\u0002d\u0006\u0015\u0018q\u001d\u0005\t\u0003\u007f\u000bi\u000e1\u0001\u0002|!A\u00111LAo\u0001\u0004\ti\u0006\u0003\u0005\u0002\u001c\u0006u\u0007\u0019AA\u0007\u0011%\tY\u000fAI\u0001\n\u0003\ti/A\u0011wC2LG-\u0019;f\u000fJ|W\u000f]!tg&<g.\\3oi\u0012\"WMZ1vYR$C'\u0006\u0002\u0002p*\"\u0011q[AyW\t\t\u0019\u0010\u0005\u0003\u0002v\u0006}XBAA|\u0015\u0011\tI0a?\u0002\u0013Ut7\r[3dW\u0016$'bAA\u007f+\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0005\u0011q\u001f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class PlaintextConsumerTest
extends BaseConsumerTest {
    @Test
    public void testAutoCommitOnClose() {
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        int numRecords = 10000;
        this.sendRecords(numRecords);
        consumer0.subscribe((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        scala.collection.immutable.Set assignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, assignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$1;
            private final scala.collection.immutable.Set assignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$1.poll(50L);
                java.util.Set set = this.consumer0$1.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.assignment$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$1 = consumer0$1;
                this.assignment$1 = assignment$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)assignment).asJava(), consumer0.assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        consumer0.seek(this.tp(), 300L);
        consumer0.seek(this.tp2(), 500L);
        consumer0.close();
        Assert.assertEquals((long)300L, (long)((KafkaConsumer)this.consumers().apply(0)).committed(this.tp()).offset());
        Assert.assertEquals((long)500L, (long)((KafkaConsumer)this.consumers().apply(0)).committed(this.tp2()).offset());
    }

    @Test
    public void testAutoCommitOnCloseAfterWakeup() {
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        int numRecords = 10000;
        this.sendRecords(numRecords);
        consumer0.subscribe((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        scala.collection.immutable.Set assignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, assignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$2;
            private final scala.collection.immutable.Set assignment$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$2.poll(50L);
                java.util.Set set = this.consumer0$2.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.assignment$2).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$2 = consumer0$2;
                this.assignment$2 = assignment$2;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)assignment).asJava(), consumer0.assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        consumer0.seek(this.tp(), 300L);
        consumer0.seek(this.tp2(), 500L);
        consumer0.wakeup();
        consumer0.close();
        Assert.assertEquals((long)300L, (long)((KafkaConsumer)this.consumers().apply(0)).committed(this.tp()).offset());
        Assert.assertEquals((long)500L, (long)((KafkaConsumer)this.consumers().apply(0)).committed(this.tp2()).offset());
    }

    @Test
    public void testAutoOffsetReset() {
        this.sendRecords(1);
        ((KafkaConsumer)this.consumers().apply(0)).assign((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().apply(0)), 1, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5());
    }

    @Test
    public void testGroupConsumption() {
        this.sendRecords(10);
        ((KafkaConsumer)this.consumers().apply(0)).subscribe((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().apply(0)), 1, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5());
    }

    @Test
    public void testPatternSubscription() {
        int numRecords = 10000;
        this.sendRecords(numRecords);
        String topic1 = "tblablac";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic1, 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.sendRecords(1000, new TopicPartition(topic1, 0));
        this.sendRecords(1000, new TopicPartition(topic1, 1));
        String topic2 = "tblablak";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic2, 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.sendRecords(1000, new TopicPartition(topic2, 0));
        this.sendRecords(1000, new TopicPartition(topic2, 1));
        String topic3 = "tblab1";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic3, 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.sendRecords(1000, new TopicPartition(topic3, 0));
        this.sendRecords(1000, new TopicPartition(topic3, 1));
        Assert.assertEquals((long)0L, (long)((KafkaConsumer)this.consumers().apply(0)).assignment().size());
        Pattern pattern = Pattern.compile("t.*c");
        ((KafkaConsumer)this.consumers().apply(0)).subscribe(pattern, (ConsumerRebalanceListener)new BaseConsumerTest.TestConsumerReassignmentListener());
        ((KafkaConsumer)this.consumers().apply(0)).poll(50L);
        ObjectRef subscriptions = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}))));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final ObjectRef subscriptions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().apply(0)).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().apply(0)).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)this.subscriptions$1.elem)).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.subscriptions$1 = subscriptions$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)subscriptions.elem)).asJava(), ((KafkaConsumer)this.consumers().apply(0)).assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        String topic4 = "tsomec";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic4, 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.sendRecords(1000, new TopicPartition(topic4, 0));
        this.sendRecords(1000, new TopicPartition(topic4, 1));
        subscriptions.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)subscriptions.elem).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic4, 0), new TopicPartition(topic4, 1)})));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final ObjectRef subscriptions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().apply(0)).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().apply(0)).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)this.subscriptions$1.elem)).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.subscriptions$1 = subscriptions$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((scala.collection.immutable.Set)subscriptions.elem)).asJava(), ((KafkaConsumer)this.consumers().apply(0)).assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        ((KafkaConsumer)this.consumers().apply(0)).unsubscribe();
        Assert.assertEquals((long)0L, (long)((KafkaConsumer)this.consumers().apply(0)).assignment().size());
    }

    @Test
    public void testPatternUnsubscription() {
        int numRecords = 10000;
        this.sendRecords(numRecords);
        String topic1 = "tblablac";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic1, 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.sendRecords(1000, new TopicPartition(topic1, 0));
        this.sendRecords(1000, new TopicPartition(topic1, 1));
        Assert.assertEquals((long)0L, (long)((KafkaConsumer)this.consumers().apply(0)).assignment().size());
        ((KafkaConsumer)this.consumers().apply(0)).subscribe(Pattern.compile("t.*c"), (ConsumerRebalanceListener)new BaseConsumerTest.TestConsumerReassignmentListener());
        ((KafkaConsumer)this.consumers().apply(0)).poll(50L);
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final scala.collection.immutable.Set subscriptions$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().apply(0)).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().apply(0)).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.subscriptions$2).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.subscriptions$2 = subscriptions$2;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava(), ((KafkaConsumer)this.consumers().apply(0)).assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        ((KafkaConsumer)this.consumers().apply(0)).unsubscribe();
        Assert.assertEquals((long)0L, (long)((KafkaConsumer)this.consumers().apply(0)).assignment().size());
    }

    @Test
    public void testCommitMetadata() {
        ((KafkaConsumer)this.consumers().apply(0)).assign((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        OffsetAndMetadata syncMetadata = new OffsetAndMetadata(5L, "foo");
        ((KafkaConsumer)this.consumers().apply(0)).commitSync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)syncMetadata)}))).asJava());
        Assert.assertEquals((Object)syncMetadata, (Object)((KafkaConsumer)this.consumers().apply(0)).committed(this.tp()));
        OffsetAndMetadata asyncMetadata = new OffsetAndMetadata(10L, "bar");
        BaseConsumerTest.CountConsumerCommitCallback callback = new BaseConsumerTest.CountConsumerCommitCallback();
        ((KafkaConsumer)this.consumers().apply(0)).commitAsync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)asyncMetadata)}))).asJava(), (OffsetCommitCallback)callback);
        this.awaitCommitCallback((Consumer<byte[], byte[]>)((Consumer)this.consumers().apply(0)), callback);
        Assert.assertEquals((Object)asyncMetadata, (Object)((KafkaConsumer)this.consumers().apply(0)).committed(this.tp()));
    }

    @Test
    public void testExpandingTopicSubscriptions() {
        String otherTopic = "other";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)}));
        scala.collection.immutable.Set expandedSubscriptions = (scala.collection.immutable.Set)subscriptions.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(otherTopic, 0), new TopicPartition(otherTopic, 1)})));
        ((KafkaConsumer)this.consumers().apply(0)).subscribe((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final scala.collection.immutable.Set subscriptions$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().apply(0)).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().apply(0)).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.subscriptions$3).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.subscriptions$3 = subscriptions$3;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava(), ((KafkaConsumer)this.consumers().apply(0)).assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), otherTopic, 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        ((KafkaConsumer)this.consumers().apply(0)).subscribe((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), otherTopic}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, expandedSubscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final scala.collection.immutable.Set expandedSubscriptions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().apply(0)).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().apply(0)).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.expandedSubscriptions$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expandedSubscriptions$1 = expandedSubscriptions$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)expandedSubscriptions).asJava(), ((KafkaConsumer)this.consumers().apply(0)).assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
    }

    @Test
    public void testShrinkingTopicSubscriptions() {
        String otherTopic = "other";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), otherTopic, 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(otherTopic, 0), new TopicPartition(otherTopic, 1)}));
        scala.collection.immutable.Set shrunkenSubscriptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)}));
        ((KafkaConsumer)this.consumers().apply(0)).subscribe((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), otherTopic}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final scala.collection.immutable.Set subscriptions$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().apply(0)).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().apply(0)).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.subscriptions$4).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.subscriptions$4 = subscriptions$4;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava(), ((KafkaConsumer)this.consumers().apply(0)).assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        ((KafkaConsumer)this.consumers().apply(0)).subscribe((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, shrunkenSubscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final scala.collection.immutable.Set shrunkenSubscriptions$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ((KafkaConsumer)this.$outer.consumers().apply(0)).poll(50L);
                java.util.Set set = ((KafkaConsumer)this.$outer.consumers().apply(0)).assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.shrunkenSubscriptions$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.shrunkenSubscriptions$1 = shrunkenSubscriptions$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)shrunkenSubscriptions).asJava(), ((KafkaConsumer)this.consumers().apply(0)).assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
    }

    @Test
    public void testPartitionsFor() {
        int numParts = 2;
        TestUtils$.MODULE$.createTopic(this.zkUtils(), "part-test", numParts, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        java.util.List parts = ((KafkaConsumer)this.consumers().apply(0)).partitionsFor("part-test");
        Assert.assertNotNull((Object)parts);
        Assert.assertEquals((long)2L, (long)parts.size());
    }

    @Test
    public void testPartitionsForAutoCreate() {
        java.util.List partitions = ((KafkaConsumer)this.consumers().apply(0)).partitionsFor("non-exist-topic");
        Assert.assertFalse((boolean)partitions.isEmpty());
    }

    @Test(expected=InvalidTopicException.class)
    public void testPartitionsForInvalidTopic() {
        ((KafkaConsumer)this.consumers().apply(0)).partitionsFor(";3# ads,{234");
    }

    @Test
    public void testSeek() {
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().apply(0);
        long totalRecords = 50L;
        long mid = totalRecords / 2L;
        this.sendRecords((int)totalRecords, this.tp());
        consumer.assign((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        consumer.seekToEnd(new TopicPartition[]{this.tp()});
        Assert.assertEquals((long)totalRecords, (long)consumer.position(this.tp()));
        Assert.assertFalse((boolean)consumer.poll(totalRecords).iterator().hasNext());
        consumer.seekToBeginning(new TopicPartition[]{this.tp()});
        Assert.assertEquals((float)0.0f, (float)consumer.position(this.tp()), (float)0.0f);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5());
        consumer.seek(this.tp(), mid);
        Assert.assertEquals((long)mid, (long)consumer.position(this.tp()));
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, (int)mid, (int)mid, this.consumeAndVerifyRecords$default$5());
        this.sendCompressedMessages((int)totalRecords, this.tp2());
        consumer.assign((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        consumer.seekToEnd(new TopicPartition[]{this.tp2()});
        Assert.assertEquals((long)totalRecords, (long)consumer.position(this.tp2()));
        Assert.assertFalse((boolean)consumer.poll(totalRecords).iterator().hasNext());
        consumer.seekToBeginning(new TopicPartition[]{this.tp2()});
        Assert.assertEquals((float)0.0f, (float)consumer.position(this.tp2()), (float)0.0f);
        KafkaConsumer x$3 = consumer;
        int x$4 = 1;
        int x$5 = 0;
        TopicPartition x$6 = this.tp2();
        int x$7 = this.consumeAndVerifyRecords$default$4();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$3, x$4, x$5, x$7, x$6);
        consumer.seek(this.tp2(), mid);
        Assert.assertEquals((long)mid, (long)consumer.position(this.tp2()));
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, (int)mid, (int)mid, this.tp2());
    }

    private void sendCompressedMessages(int numRecords, TopicPartition tp) {
        Properties producerProps = new Properties();
        producerProps.setProperty("compression.type", CompressionType.GZIP.name);
        producerProps.setProperty("linger.ms", ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        String x$8 = this.brokerList();
        SecurityProtocol x$9 = this.securityProtocol();
        Option<File> x$10 = this.trustStoreFile();
        int x$11 = 0;
        long x$12 = Long.MAX_VALUE;
        Some x$13 = new Some((Object)producerProps);
        int x$14 = TestUtils$.MODULE$.createNewProducer$default$2();
        long x$15 = TestUtils$.MODULE$.createNewProducer$default$3();
        boolean x$16 = TestUtils$.MODULE$.createNewProducer$default$4();
        long x$17 = TestUtils$.MODULE$.createNewProducer$default$5();
        KafkaProducer<byte[], byte[]> producer = TestUtils$.MODULE$.createNewProducer(x$8, x$14, x$15, x$16, x$17, x$11, x$12, x$9, x$10, (Option<Properties>)x$13);
        this.sendRecords((Producer<byte[], byte[]>)producer, numRecords, tp);
        producer.close();
    }

    public void testPositionAndCommit() {
        this.sendRecords(5);
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final OffsetAndMetadata apply() {
                return ((KafkaConsumer)this.$outer.consumers().apply(0)).committed(new TopicPartition(this.$outer.topic(), 15));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ManifestFactory$.MODULE$.classType(NoOffsetForPartitionException.class));
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return ((KafkaConsumer)this.$outer.consumers().apply(0)).position(new TopicPartition(this.$outer.topic(), 15));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
        ((KafkaConsumer)this.consumers().apply(0)).assign((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assert.assertEquals((String)"position() on a partition that we are subscribed to should reset the offset", (long)0L, (long)((KafkaConsumer)this.consumers().apply(0)).position(this.tp()));
        ((KafkaConsumer)this.consumers().apply(0)).commitSync();
        Assert.assertEquals((long)0L, (long)((KafkaConsumer)this.consumers().apply(0)).committed(this.tp()).offset());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().apply(0)), 5, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5());
        Assert.assertEquals((String)"After consuming 5 records, position should be 5", (long)5L, (long)((KafkaConsumer)this.consumers().apply(0)).position(this.tp()));
        ((KafkaConsumer)this.consumers().apply(0)).commitSync();
        Assert.assertEquals((String)"Committed offset should be returned", (long)5L, (long)((KafkaConsumer)this.consumers().apply(0)).committed(this.tp()).offset());
        this.sendRecords(1);
        ((KafkaConsumer)this.consumers().apply(1)).assign((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().apply(1)), 1, 5, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5());
    }

    @Test
    public void testPartitionPauseAndResume() {
        this.sendRecords(5);
        ((KafkaConsumer)this.consumers().apply(0)).assign((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().apply(0)), 5, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5());
        ((KafkaConsumer)this.consumers().apply(0)).pause(new TopicPartition[]{this.tp()});
        this.sendRecords(5);
        Assert.assertTrue((boolean)((KafkaConsumer)this.consumers().apply(0)).poll(0L).isEmpty());
        ((KafkaConsumer)this.consumers().apply(0)).resume(new TopicPartition[]{this.tp()});
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().apply(0)), 5, 5, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5());
    }

    @Test
    public void testFetchInvalidOffset() {
        this.consumerConfig().setProperty("auto.offset.reset", "none");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        int totalRecords = 2;
        this.sendRecords(totalRecords, this.tp());
        consumer0.assign((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.intercept((Function0)new Serializable(this, consumer0){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$3;

            public final ConsumerRecords<byte[], byte[]> apply() {
                return this.consumer0$3.poll(50L);
            }
            {
                this.consumer0$3 = consumer0$3;
            }
        }, ManifestFactory$.MODULE$.classType(NoOffsetForPartitionException.class));
        int outOfRangePos = totalRecords + 1;
        consumer0.seek(this.tp(), (long)outOfRangePos);
        OffsetOutOfRangeException e = (OffsetOutOfRangeException)this.intercept((Function0)new Serializable(this, consumer0){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$3;

            public final ConsumerRecords<byte[], byte[]> apply() {
                return this.consumer0$3.poll(20000L);
            }
            {
                this.consumer0$3 = consumer0$3;
            }
        }, ManifestFactory$.MODULE$.classType(OffsetOutOfRangeException.class));
        java.util.Map outOfRangePartitions = e.offsetOutOfRangePartitions();
        Assert.assertNotNull((Object)outOfRangePartitions);
        Assert.assertEquals((long)1L, (long)outOfRangePartitions.size());
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)outOfRangePos), outOfRangePartitions.get(this.tp()));
        consumer0.close();
    }

    @Test
    public void testFetchRecordTooLarge() {
        int maxFetchBytes = 10240;
        this.consumerConfig().setProperty("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToInteger((int)maxFetchBytes)).toString());
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"key".getBytes(), (Object)new byte[maxFetchBytes + 1]);
        ((KafkaProducer)this.producers().apply(0)).send(record);
        consumer0.assign((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        RecordTooLargeException e = (RecordTooLargeException)this.intercept((Function0)new Serializable(this, consumer0){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$4;

            public final ConsumerRecords<byte[], byte[]> apply() {
                return this.consumer0$4.poll(20000L);
            }
            {
                this.consumer0$4 = consumer0$4;
            }
        }, ManifestFactory$.MODULE$.classType(RecordTooLargeException.class));
        java.util.Map oversizedPartitions = e.recordTooLargePartitions();
        Assert.assertNotNull((Object)oversizedPartitions);
        Assert.assertEquals((long)1L, (long)oversizedPartitions.size());
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), oversizedPartitions.get(this.tp()));
        consumer0.close();
    }

    @Test
    public void testRoundRobinAssignment() {
        this.consumerConfig().setProperty("group.id", "roundrobin-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", RoundRobinAssignor.class.getName());
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        String topic1 = "topic1";
        String topic2 = "topic2";
        scala.collection.immutable.Set expectedAssignment = (scala.collection.immutable.Set)this.createTopicAndSendRecords(topic1, 2, 100).$plus$plus(this.createTopicAndSendRecords(topic2, 2, 100));
        Assert.assertEquals((long)0L, (long)consumer0.assignment().size());
        consumer0.subscribe((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, expectedAssignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$5;
            private final scala.collection.immutable.Set expectedAssignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$5.poll(50L);
                java.util.Set set = this.consumer0$5.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.expectedAssignment$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$5 = consumer0$5;
                this.expectedAssignment$1 = expectedAssignment$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)expectedAssignment).asJava(), consumer0.assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        String topic3 = "topic3";
        this.createTopicAndSendRecords(topic3, 2, 100);
        scala.collection.immutable.Set newExpectedAssignment = (scala.collection.immutable.Set)expectedAssignment.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic3, 0), new TopicPartition(topic3, 1)})));
        consumer0.subscribe((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2, topic3}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, newExpectedAssignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$5;
            private final scala.collection.immutable.Set newExpectedAssignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$5.poll(50L);
                java.util.Set set = this.consumer0$5.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.newExpectedAssignment$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$5 = consumer0$5;
                this.newExpectedAssignment$1 = newExpectedAssignment$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)newExpectedAssignment).asJava(), consumer0.assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        consumer0.subscribe((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2}))).asJava());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer0, expectedAssignment){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer0$5;
            private final scala.collection.immutable.Set expectedAssignment$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer0$5.poll(50L);
                java.util.Set set = this.consumer0$5.assignment();
                Object object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.expectedAssignment$1).asJava();
                return !(set != null ? !((Object)set).equals(object) : object != null);
            }
            {
                this.consumer0$5 = consumer0$5;
                this.expectedAssignment$1 = expectedAssignment$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partitions ", " but actually got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)expectedAssignment).asJava(), consumer0.assignment()})), TestUtils$.MODULE$.waitUntilTrue$default$3());
        consumer0.unsubscribe();
        Assert.assertEquals((long)0L, (long)consumer0.assignment().size());
    }

    @Test
    public void testMultiConsumerRoundRobinAssignment() {
        this.consumerConfig().setProperty("group.id", "roundrobin-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", RoundRobinAssignor.class.getName());
        String topic1 = "topic1";
        String topic2 = "topic2";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)this.createTopicAndSendRecords(topic1, 5, 100).$plus$plus(this.createTopicAndSendRecords(topic2, 8, 100));
        Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<BaseConsumerTest.ConsumerAssignmentPoller>> tuple2 = this.createConsumerGroupAndWaitForAssignment(10, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2})), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Buffer rrConsumers = (Buffer)tuple2._1();
            Buffer consumerPollers = (Buffer)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)rrConsumers, (Object)consumerPollers);
            Buffer rrConsumers2 = (Buffer)tuple23._1();
            Buffer consumerPollers2 = (Buffer)tuple23._2();
            this.addConsumersToGroupAndWaitForGroupAssignment(1, (Buffer<KafkaConsumer<byte[], byte[]>>)rrConsumers2, (Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2})), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
            consumerPollers2.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(BaseConsumerTest.ConsumerAssignmentPoller poller) {
                    poller.shutdown();
                }
            });
            rrConsumers2.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(KafkaConsumer<byte[], byte[]> consumer) {
                    consumer.unsubscribe();
                }
            });
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testMultiConsumerDefaultAssignment() {
        this.sendRecords(100, this.tp());
        this.sendRecords(100, this.tp2());
        String topic1 = "topic1";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).$plus$plus(this.createTopicAndSendRecords(topic1, 5, 100));
        Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers = this.subscribeConsumersAndWaitForAssignment(this.consumers(), (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1})), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        this.addConsumersToGroupAndWaitForGroupAssignment(2, this.consumers(), consumerPollers, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1})), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        String topic2 = "topic2";
        scala.collection.immutable.Set expandedSubscriptions = (scala.collection.immutable.Set)subscriptions.$plus$plus(this.createTopicAndSendRecords(topic2, 3, 100));
        this.changeConsumerGroupSubscriptionAndValidateAssignment(consumerPollers, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1, topic2})), (scala.collection.immutable.Set<TopicPartition>)expandedSubscriptions);
        this.changeConsumerGroupSubscriptionAndValidateAssignment(consumerPollers, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1})), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        consumerPollers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(BaseConsumerTest.ConsumerAssignmentPoller poller) {
                poller.shutdown();
            }
        });
        this.consumers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaConsumer<byte[], byte[]> consumer) {
                consumer.unsubscribe();
            }
        });
    }

    @Test
    public void testMultiConsumerSessionTimeoutOnStopPolling() {
        this.runMultiConsumerSessionTimeoutTest(false);
    }

    @Test
    public void testMultiConsumerSessionTimeoutOnClose() {
        this.runMultiConsumerSessionTimeoutTest(true);
    }

    public void runMultiConsumerSessionTimeoutTest(boolean closeConsumer) {
        this.sendRecords(100, this.tp());
        this.sendRecords(100, this.tp2());
        String topic1 = "topic1";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).$plus$plus(this.createTopicAndSendRecords(topic1, 6, 100));
        Buffer consumerPollers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.consumers().foreach((Function1)new Serializable(this, topic1, consumerPollers){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final String topic1$1;
            private final Buffer consumerPollers$3;

            public final Buffer<BaseConsumerTest.ConsumerAssignmentPoller> apply(KafkaConsumer<byte[], byte[]> consumer) {
                return this.consumerPollers$3.$plus$eq((Object)((Object)this.$outer.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.topic(), this.topic1$1})))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic1$1 = topic1$1;
                this.consumerPollers$3 = consumerPollers$3;
            }
        });
        KafkaConsumer timeoutConsumer = new KafkaConsumer(this.consumerConfig());
        Buffer expandedConsumers = this.consumers().$plus$plus((GenTraversableOnce)Buffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[]{timeoutConsumer})));
        BaseConsumerTest.ConsumerAssignmentPoller timeoutPoller = this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)timeoutConsumer, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1})));
        Buffer expandedPollers = consumerPollers.$plus$plus((GenTraversableOnce)Buffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BaseConsumerTest.ConsumerAssignmentPoller[]{timeoutPoller})));
        this.validateGroupAssignment((Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)expandedPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid initial assignment for partitions ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava()})), this.validateGroupAssignment$default$4());
        timeoutPoller.shutdown();
        if (closeConsumer) {
            timeoutConsumer.close();
        }
        long maxSessionTimeout = new StringOps(Predef$.MODULE$.augmentString(this.serverConfig().getProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp()))).toLong();
        this.validateGroupAssignment((Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid assignment for partitions ", " after one consumer left"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava()})), 3L * maxSessionTimeout);
        consumerPollers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(BaseConsumerTest.ConsumerAssignmentPoller poller) {
                poller.shutdown();
            }
        });
    }

    public scala.collection.immutable.Set<TopicPartition> createTopicAndSendRecords(String topicName, int numPartitions, int recordsPerPartition) {
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topicName, numPartitions, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        ObjectRef parts = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)new Serializable(this, topicName, recordsPerPartition, parts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final String topicName$1;
            private final int recordsPerPartition$1;
            private final ObjectRef parts$1;

            public final void apply(int partition) {
                this.apply$mcVI$sp(partition);
            }

            public void apply$mcVI$sp(int partition) {
                TopicPartition tp = new TopicPartition(this.topicName$1, partition);
                this.$outer.sendRecords(this.recordsPerPartition$1, tp);
                this.parts$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)this.parts$1.elem).$plus((Object)tp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicName$1 = topicName$1;
                this.recordsPerPartition$1 = recordsPerPartition$1;
                this.parts$1 = parts$1;
            }
        });
        return (scala.collection.immutable.Set)parts.elem;
    }

    /*
     * WARNING - void declaration
     */
    public BaseConsumerTest.ConsumerAssignmentPoller subscribeConsumerAndStartPolling(Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe) {
        void var3_3;
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        BaseConsumerTest.ConsumerAssignmentPoller consumerPoller = new BaseConsumerTest.ConsumerAssignmentPoller(this, consumer, topicsToSubscribe);
        consumerPoller.start();
        return var3_3;
    }

    public Buffer<BaseConsumerTest.ConsumerAssignmentPoller> subscribeConsumersAndWaitForAssignment(Buffer<KafkaConsumer<byte[], byte[]>> consumerGroup, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        Buffer consumerPollers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        consumerGroup.foreach((Function1)new Serializable(this, topicsToSubscribe, consumerPollers){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final List topicsToSubscribe$2;
            private final Buffer consumerPollers$5;

            public final Buffer<BaseConsumerTest.ConsumerAssignmentPoller> apply(KafkaConsumer<byte[], byte[]> consumer) {
                return this.consumerPollers$5.$plus$eq((Object)((Object)this.$outer.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, (List<String>)this.topicsToSubscribe$2)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicsToSubscribe$2 = topicsToSubscribe$2;
                this.consumerPollers$5 = consumerPollers$5;
            }
        });
        this.validateGroupAssignment((Buffer<BaseConsumerTest.ConsumerAssignmentPoller>)consumerPollers, subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid initial assignment for partitions ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter(subscriptions).asJava()})), this.validateGroupAssignment$default$4());
        return consumerPollers;
    }

    public Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<BaseConsumerTest.ConsumerAssignmentPoller>> createConsumerGroupAndWaitForAssignment(int consumerCount, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        Assert.assertTrue((consumerCount <= subscriptions.size() ? 1 : 0) != 0);
        Buffer consumerGroup = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), consumerCount).foreach((Function1)new Serializable(this, consumerGroup){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final Buffer consumerGroup$2;

            public final Buffer<KafkaConsumer<byte[], byte[]>> apply(int i) {
                return this.consumerGroup$2.$plus$eq((Object)new KafkaConsumer(this.$outer.consumerConfig()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumerGroup$2 = consumerGroup$2;
            }
        });
        Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers = this.subscribeConsumersAndWaitForAssignment((Buffer<KafkaConsumer<byte[], byte[]>>)consumerGroup, topicsToSubscribe, subscriptions);
        return new Tuple2((Object)consumerGroup, consumerPollers);
    }

    public void addConsumersToGroupAndWaitForGroupAssignment(int numOfConsumersToAdd, Buffer<KafkaConsumer<byte[], byte[]>> consumerGroup, Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        Assert.assertTrue((consumerGroup.size() + numOfConsumersToAdd <= subscriptions.size() ? 1 : 0) != 0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numOfConsumersToAdd).foreach((Function1)new Serializable(this, consumerGroup, consumerPollers, topicsToSubscribe){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final Buffer consumerGroup$1;
            private final Buffer consumerPollers$1;
            private final List topicsToSubscribe$1;

            public final Buffer<BaseConsumerTest.ConsumerAssignmentPoller> apply(int i) {
                KafkaConsumer newConsumer = new KafkaConsumer(this.$outer.consumerConfig());
                this.consumerGroup$1.$plus$eq((Object)newConsumer);
                return this.consumerPollers$1.$plus$eq((Object)((Object)this.$outer.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)newConsumer, (List<String>)this.topicsToSubscribe$1)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumerGroup$1 = consumerGroup$1;
                this.consumerPollers$1 = consumerPollers$1;
                this.topicsToSubscribe$1 = topicsToSubscribe$1;
            }
        });
        this.validateGroupAssignment(consumerPollers, subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid assignment for partitions ", " after we added ", " consumer(s)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter(subscriptions).asJava(), BoxesRunTime.boxToInteger((int)numOfConsumersToAdd)})), this.validateGroupAssignment$default$4());
    }

    public void validateGroupAssignment(Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers, scala.collection.immutable.Set<TopicPartition> subscriptions, String msg, long waitTime) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumerPollers, subscriptions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final Buffer consumerPollers$4;
            private final scala.collection.immutable.Set subscriptions$5;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Buffer assignments = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.consumerPollers$4.foreach((Function1)new Serializable(this, assignments){
                    public static final long serialVersionUID = 0L;
                    private final Buffer assignments$1;

                    public final Buffer<scala.collection.immutable.Set<TopicPartition>> apply(BaseConsumerTest.ConsumerAssignmentPoller x$2) {
                        return this.assignments$1.$plus$eq(x$2.consumerAssignment());
                    }
                    {
                        this.assignments$1 = assignments$1;
                    }
                });
                return this.$outer.isPartitionAssignmentValid((Buffer<scala.collection.immutable.Set<TopicPartition>>)assignments, (scala.collection.immutable.Set<TopicPartition>)this.subscriptions$5);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.consumerPollers$4 = consumerPollers$4;
                this.subscriptions$5 = subscriptions$5;
            }
        }, msg, waitTime);
    }

    public long validateGroupAssignment$default$4() {
        return 10000L;
    }

    public void changeConsumerGroupSubscriptionAndValidateAssignment(Buffer<BaseConsumerTest.ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        consumerPollers.foreach((Function1)new Serializable(this, topicsToSubscribe){
            public static final long serialVersionUID = 0L;
            private final List topicsToSubscribe$3;

            public final void apply(BaseConsumerTest.ConsumerAssignmentPoller poller) {
                poller.subscribe((List<String>)this.topicsToSubscribe$3);
            }
            {
                this.topicsToSubscribe$3 = topicsToSubscribe$3;
            }
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumerPollers){
            public static final long serialVersionUID = 0L;
            private final Buffer consumerPollers$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.consumerPollers$2.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(BaseConsumerTest.ConsumerAssignmentPoller poller) {
                        return poller.isSubscribeRequestProcessed();
                    }
                });
            }
            {
                this.consumerPollers$2 = consumerPollers$2;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to call subscribe on all consumers in the group for subscription ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{subscriptions})), 1000L);
        this.validateGroupAssignment(consumerPollers, subscriptions, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get valid assignment for partitions ", " after we changed subscription"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.setAsJavaSetConverter(subscriptions).asJava()})), this.validateGroupAssignment$default$4());
    }
}

