/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import kafka.utils.KafkaScheduler;
import kafka.utils.KafkaScheduler$;
import kafka.utils.MockTime;
import kafka.utils.SchedulerTest$;
import kafka.utils.TestUtils$;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001}3A!\u0001\u0002\u0001\u000f\ti1k\u00195fIVdWM\u001d+fgRT!a\u0001\u0003\u0002\u000bU$\u0018\u000e\\:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0001+\u0005I1o\u00195fIVdWM]\u000b\u0002-A\u0011!cF\u0005\u00031\t\u0011abS1gW\u0006\u001c6\r[3ek2,'\u000f\u0003\u0004\u001b\u0001\u0001\u0006IAF\u0001\u000bg\u000eDW\rZ;mKJ\u0004\u0003b\u0002\u000f\u0001\u0005\u0004%\t!H\u0001\t[>\u001c7\u000eV5nKV\ta\u0004\u0005\u0002\u0013?%\u0011\u0001E\u0001\u0002\t\u001b>\u001c7\u000eV5nK\"1!\u0005\u0001Q\u0001\ny\t\u0011\"\\8dWRKW.\u001a\u0011\t\u000f\u0011\u0002!\u0019!C\u0001K\u0005A1m\\;oi\u0016\u0014\u0018'F\u0001'!\t9\u0003'D\u0001)\u0015\tI#&\u0001\u0004bi>l\u0017n\u0019\u0006\u0003W1\n!bY8oGV\u0014(/\u001a8u\u0015\tic&\u0001\u0003vi&d'\"A\u0018\u0002\t)\fg/Y\u0005\u0003c!\u0012Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\bBB\u001a\u0001A\u0003%a%A\u0005d_VtG/\u001a:2A!9Q\u0007\u0001b\u0001\n\u0003)\u0013\u0001C2pk:$XM\u001d\u001a\t\r]\u0002\u0001\u0015!\u0003'\u0003%\u0019w.\u001e8uKJ\u0014\u0004\u0005C\u0003:\u0001\u0011\u0005!(A\u0003tKR,\b\u000fF\u0001<!\tIA(\u0003\u0002>\u0015\t!QK\\5uQ\tAt\b\u0005\u0002A\u000b6\t\u0011I\u0003\u0002C\u0007\u0006)!.\u001e8ji*\tA)A\u0002pe\u001eL!AR!\u0003\r\t+gm\u001c:f\u0011\u0015A\u0005\u0001\"\u0001;\u0003!!X-\u0019:e_^t\u0007FA$K!\t\u00015*\u0003\u0002M\u0003\n)\u0011I\u001a;fe\")a\n\u0001C\u0001u\u0005\u0001C/Z:u\u001b>\u001c7nU2iK\u0012,H.\u001a:O_:\u0004VM]5pI&\u001cG+Y:lQ\ti\u0005\u000b\u0005\u0002A#&\u0011!+\u0011\u0002\u0005)\u0016\u001cH\u000fC\u0003U\u0001\u0011\u0005!(A\u000fuKN$Xj\\2l'\u000eDW\rZ;mKJ\u0004VM]5pI&\u001cG+Y:lQ\t\u0019\u0006\u000bC\u0003X\u0001\u0011\u0005!(\u0001\u0011uKN$(+Z3oiJ\fg\u000e\u001e+bg.Le.T8dWN\u001b\u0007.\u001a3vY\u0016\u0014\bF\u0001,Q\u0011\u0015Q\u0006\u0001\"\u0001;\u0003M!Xm\u001d;O_:\u0004VM]5pI&\u001cG+Y:lQ\tI\u0006\u000bC\u0003^\u0001\u0011\u0005!(\u0001\tuKN$\b+\u001a:j_\u0012L7\rV1tW\"\u0012A\f\u0015")
public class SchedulerTest {
    private final KafkaScheduler scheduler = new KafkaScheduler(1, KafkaScheduler$.MODULE$.$lessinit$greater$default$2(), KafkaScheduler$.MODULE$.$lessinit$greater$default$3());
    private final MockTime mockTime = new MockTime();
    private final AtomicInteger counter1 = new AtomicInteger(0);
    private final AtomicInteger counter2 = new AtomicInteger(0);

    public KafkaScheduler scheduler() {
        return this.scheduler;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public AtomicInteger counter1() {
        return this.counter1;
    }

    public AtomicInteger counter2() {
        return this.counter2;
    }

    @Before
    public void setup() {
        this.scheduler().startup();
    }

    @After
    public void teardown() {
        this.scheduler().shutdown();
    }

    @Test
    public void testMockSchedulerNonPeriodicTask() {
        this.mockTime().scheduler().schedule("test1", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SchedulerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.counter1().getAndIncrement();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, 1L, this.mockTime().scheduler().schedule$default$4(), this.mockTime().scheduler().schedule$default$5());
        this.mockTime().scheduler().schedule("test2", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SchedulerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.counter2().getAndIncrement();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, 100L, this.mockTime().scheduler().schedule$default$4(), this.mockTime().scheduler().schedule$default$5());
        Assert.assertEquals((String)"Counter1 should not be incremented prior to task running.", (int)0, (int)this.counter1().get());
        Assert.assertEquals((String)"Counter2 should not be incremented prior to task running.", (int)0, (int)this.counter2().get());
        this.mockTime().sleep(1L);
        Assert.assertEquals((String)"Counter1 should be incremented", (int)1, (int)this.counter1().get());
        Assert.assertEquals((String)"Counter2 should not be incremented", (int)0, (int)this.counter2().get());
        this.mockTime().sleep(100000L);
        Assert.assertEquals((String)"More sleeping should not result in more incrementing on counter1.", (int)1, (int)this.counter1().get());
        Assert.assertEquals((String)"Counter2 should now be incremented.", (int)1, (int)this.counter2().get());
    }

    @Test
    public void testMockSchedulerPeriodicTask() {
        this.mockTime().scheduler().schedule("test1", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SchedulerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.counter1().getAndIncrement();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, 1L, 1L, this.mockTime().scheduler().schedule$default$5());
        this.mockTime().scheduler().schedule("test2", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SchedulerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.counter2().getAndIncrement();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, 100L, 100L, this.mockTime().scheduler().schedule$default$5());
        Assert.assertEquals((String)"Counter1 should not be incremented prior to task running.", (int)0, (int)this.counter1().get());
        Assert.assertEquals((String)"Counter2 should not be incremented prior to task running.", (int)0, (int)this.counter2().get());
        this.mockTime().sleep(1L);
        Assert.assertEquals((String)"Counter1 should be incremented", (int)1, (int)this.counter1().get());
        Assert.assertEquals((String)"Counter2 should not be incremented", (int)0, (int)this.counter2().get());
        this.mockTime().sleep(100L);
        Assert.assertEquals((String)"Counter1 should be incremented 101 times", (int)101, (int)this.counter1().get());
        Assert.assertEquals((String)"Counter2 should not be incremented once", (int)1, (int)this.counter2().get());
    }

    @Test
    public void testReentrantTaskInMockScheduler() {
        this.mockTime().scheduler().schedule("test1", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SchedulerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.mockTime().scheduler().schedule("test2", (Function0<BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testReentrantTaskInMockScheduler$1 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.kafka$utils$SchedulerTest$$anonfun$$$outer().counter2().getAndIncrement();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, 0L, this.$outer.mockTime().scheduler().schedule$default$4(), this.$outer.mockTime().scheduler().schedule$default$5());
            }

            public /* synthetic */ SchedulerTest kafka$utils$SchedulerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, 1L, this.mockTime().scheduler().schedule$default$4(), this.mockTime().scheduler().schedule$default$5());
        this.mockTime().sleep(1L);
        Assert.assertEquals((int)1, (int)this.counter2().get());
    }

    @Test
    public void testNonPeriodicTask() {
        this.scheduler().schedule("test", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SchedulerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.counter1().getAndIncrement();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, 0L, this.scheduler().schedule$default$4(), this.scheduler().schedule$default$5());
        TestUtils$.MODULE$.retry(30000L, (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SchedulerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Assert.assertEquals((int)this.$outer.counter1().get(), (int)1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Thread.sleep(5L);
        Assert.assertEquals((String)"Should only run once", (int)1, (int)this.counter1().get());
    }

    @Test
    public void testPeriodicTask() {
        this.scheduler().schedule("test", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SchedulerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.counter1().getAndIncrement();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, 0L, 5L, this.scheduler().schedule$default$5());
        TestUtils$.MODULE$.retry(30000L, (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SchedulerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Assert.assertTrue((String)"Should count to 20", (this.$outer.counter1().get() >= 20 ? 1 : 0) != 0);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

