/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import java.util.Random;
import junit.framework.Assert;
import kafka.admin.AdminUtils$;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.api.OffsetResponse;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.api.PartitionOffsetsResponse;
import kafka.common.ErrorMapping$;
import kafka.common.TopicAndPartition;
import kafka.consumer.SimpleConsumer;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.NoCompressionCodec$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import kafka.utils.Time;
import kafka.utils.Utils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.I0Itec.zkclient.ZkClient;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnit3Suite;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005}c\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0002T8h\u001f\u001a47/\u001a;UKN$(BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001A!\u0003\u0005\u0002\n!5\t!B\u0003\u0002\f\u0019\u0005)!.\u001e8ji*\u0011QBD\u0001\ng\u000e\fG.\u0019;fgRT\u0011aD\u0001\u0004_J<\u0017BA\t\u000b\u0005-QUK\\5ugM+\u0018\u000e^3\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U!\u0011A\u0001>l\u0013\t9BC\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o\u001d\u0005\u00063\u0001!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"\u0001\b\u0001\u000e\u0003\tAqA\b\u0001C\u0002\u0013\u0005q$\u0001\u0004sC:$w.\\\u000b\u0002AA\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0005kRLGNC\u0001&\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0012#A\u0002*b]\u0012|W\u000e\u0003\u0004*\u0001\u0001\u0006I\u0001I\u0001\be\u0006tGm\\7!\u0011\u001dY\u0003\u00011A\u0005\u00021\na\u0001\\8h\t&\u0014X#A\u0017\u0011\u00059\nT\"A\u0018\u000b\u0005A\"\u0013AA5p\u0013\t\u0011tF\u0001\u0003GS2,\u0007b\u0002\u001b\u0001\u0001\u0004%\t!N\u0001\u000bY><G)\u001b:`I\u0015\fHC\u0001\u001c=!\t9$(D\u00019\u0015\u0005I\u0014!B:dC2\f\u0017BA\u001e9\u0005\u0011)f.\u001b;\t\u000fu\u001a\u0014\u0011!a\u0001[\u0005\u0019\u0001\u0010J\u0019\t\r}\u0002\u0001\u0015)\u0003.\u0003\u001dawn\u001a#je\u0002Bq!\u0011\u0001A\u0002\u0013\u0005A&A\u0006u_BL7\rT8h\t&\u0014\bbB\"\u0001\u0001\u0004%\t\u0001R\u0001\u0010i>\u0004\u0018n\u0019'pO\u0012K'o\u0018\u0013fcR\u0011a'\u0012\u0005\b{\t\u000b\t\u00111\u0001.\u0011\u00199\u0005\u0001)Q\u0005[\u0005aAo\u001c9jG2{w\rR5sA!91\u0001\u0001a\u0001\n\u0003IU#\u0001&\u0011\u0005qY\u0015B\u0001'\u0003\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\t\u000f9\u0003\u0001\u0019!C\u0001\u001f\u0006Q1/\u001a:wKJ|F%Z9\u0015\u0005Y\u0002\u0006bB\u001fN\u0003\u0003\u0005\rA\u0013\u0005\u0007%\u0002\u0001\u000b\u0015\u0002&\u0002\u000fM,'O^3sA!9A\u000b\u0001a\u0001\n\u0003)\u0016a\u00027pONK'0Z\u000b\u0002-B\u0011qgV\u0005\u00031b\u00121!\u00138u\u0011\u001dQ\u0006\u00011A\u0005\u0002m\u000b1\u0002\\8h'&TXm\u0018\u0013fcR\u0011a\u0007\u0018\u0005\b{e\u000b\t\u00111\u0001W\u0011\u0019q\u0006\u0001)Q\u0005-\u0006AAn\\4TSj,\u0007\u0005C\u0004a\u0001\t\u0007I\u0011A+\u0002\u0015\t\u0014xn[3s!>\u0014H\u000f\u0003\u0004c\u0001\u0001\u0006IAV\u0001\fEJ|7.\u001a:Q_J$\b\u0005C\u0004e\u0001\u0001\u0007I\u0011A3\u0002\u001dMLW\u000e\u001d7f\u0007>t7/^7feV\ta\r\u0005\u0002hU6\t\u0001N\u0003\u0002j\t\u0005A1m\u001c8tk6,'/\u0003\u0002lQ\nq1+[7qY\u0016\u001cuN\\:v[\u0016\u0014\bbB7\u0001\u0001\u0004%\tA\\\u0001\u0013g&l\u0007\u000f\\3D_:\u001cX/\\3s?\u0012*\u0017\u000f\u0006\u00027_\"9Q\b\\A\u0001\u0002\u00041\u0007BB9\u0001A\u0003&a-A\btS6\u0004H.Z\"p]N,X.\u001a:!\u0011\u001d\u0019\b\u00011A\u0005\u0002Q\fA\u0001^5nKV\tQ\u000f\u0005\u0002ws6\tqO\u0003\u0002y\t\u0005)Q\u000f^5mg&\u0011!p\u001e\u0002\u0005)&lW\rC\u0004}\u0001\u0001\u0007I\u0011A?\u0002\u0011QLW.Z0%KF$\"A\u000e@\t\u000fuZ\u0018\u0011!a\u0001k\"9\u0011\u0011\u0001\u0001!B\u0013)\u0018!\u0002;j[\u0016\u0004\u0003bBA\u0003\u0001\u0011\u0005\u0013qA\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002m!\"\u00111AA\u0006!\u0011\ti!!\u0005\u000e\u0005\u0005=!BA\u0006\u000f\u0013\u0011\t\u0019\"a\u0004\u0003\r\t+gm\u001c:f\u0011\u001d\t9\u0002\u0001C!\u0003\u000f\t\u0001\u0002^3be\u0012{wO\u001c\u0015\u0005\u0003+\tY\u0002\u0005\u0003\u0002\u000e\u0005u\u0011\u0002BA\u0010\u0003\u001f\u0011Q!\u00114uKJDq!a\t\u0001\t\u0003\t9!A\u000fuKN$x)\u001a;PM\u001a\u001cX\r^:G_J,fn\u001b8po:$v\u000e]5dQ\u0011\t\t#a\n\u0011\t\u00055\u0011\u0011F\u0005\u0005\u0003W\tyA\u0001\u0003UKN$\bbBA\u0018\u0001\u0011\u0005\u0011qA\u0001\u001fi\u0016\u001cHoR3u\u001f\u001a47/\u001a;t\u0005\u00164wN]3MCR,7\u000f\u001e+j[\u0016DC!!\f\u0002(!9\u0011Q\u0007\u0001\u0005\u0002\u0005\u001d\u0011a\u0006;fgR,U\u000e\u001d;z\u0019><7oR3u\u001f\u001a47/\u001a;tQ\u0011\t\u0019$a\n\t\u000f\u0005m\u0002\u0001\"\u0001\u0002\b\u00059B/Z:u\u000f\u0016$xJ\u001a4tKR\u001c()\u001a4pe\u0016tun\u001e\u0015\u0005\u0003s\t9\u0003C\u0004\u0002B\u0001!\t!a\u0002\u0002AQ,7\u000f^$fi>3gm]3ug\n+gm\u001c:f\u000b\u0006\u0014H.[3tiRKW.\u001a\u0015\u0005\u0003\u007f\t9\u0003C\u0004\u0002H\u0001!I!!\u0013\u0002%\r\u0014X-\u0019;f\u0005J|7.\u001a:D_:4\u0017n\u001a\u000b\u0007\u0003\u0017\n\t&!\u0016\u0011\u0007\u0005\ni%C\u0002\u0002P\t\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\t\u0019&!\u0012A\u0002Y\u000baA\\8eK&#\u0007bBA,\u0003\u000b\u0002\rAV\u0001\u0005a>\u0014H\u000fC\u0004\u0002\\\u0001!I!!\u0018\u0002\u0013\u001d,G\u000fT8h\t&\u0014H#A\u0017")
public class LogOffsetTest
extends JUnit3Suite
implements ZooKeeperTestHarness {
    private final Random random;
    private File logDir;
    private File topicLogDir;
    private KafkaServer server;
    private int logSize;
    private final int brokerPort;
    private SimpleConsumer simpleConsumer;
    private Time time;
    private final String zkConnect;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;

    @Override
    public String zkConnect() {
        return this.zkConnect;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public ZkClient zkClient() {
        return this.zkClient;
    }

    @Override
    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public /* synthetic */ void kafka$zk$ZooKeeperTestHarness$$super$setUp() {
        super.setUp();
    }

    @Override
    public /* synthetic */ void kafka$zk$ZooKeeperTestHarness$$super$tearDown() {
        super.tearDown();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    public Random random() {
        return this.random;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public File topicLogDir() {
        return this.topicLogDir;
    }

    public void topicLogDir_$eq(File x$1) {
        this.topicLogDir = x$1;
    }

    public KafkaServer server() {
        return this.server;
    }

    public void server_$eq(KafkaServer x$1) {
        this.server = x$1;
    }

    public int logSize() {
        return this.logSize;
    }

    public void logSize_$eq(int x$1) {
        this.logSize = x$1;
    }

    public int brokerPort() {
        return this.brokerPort;
    }

    public SimpleConsumer simpleConsumer() {
        return this.simpleConsumer;
    }

    public void simpleConsumer_$eq(SimpleConsumer x$1) {
        this.simpleConsumer = x$1;
    }

    public Time time() {
        return this.time;
    }

    public void time_$eq(Time x$1) {
        this.time = x$1;
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        Properties config = this.createBrokerConfig(1, this.brokerPort());
        String logDirPath = config.getProperty("log.dir");
        this.logDir_$eq(new File(logDirPath));
        this.time_$eq(new MockTime());
        this.server_$eq(TestUtils$.MODULE$.createServer(new KafkaConfig(config), this.time()));
        this.simpleConsumer_$eq(new SimpleConsumer("localhost", this.brokerPort(), 1000000, 65536, ""));
    }

    @Override
    @After
    public void tearDown() {
        this.simpleConsumer().close();
        this.server().shutdown();
        Utils$.MODULE$.rm(this.logDir());
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Test
    public void testGetOffsetsForUnknownTopic() {
        TopicAndPartition topicAndPartition = new TopicAndPartition("foo", 0);
        OffsetRequest request = new OffsetRequest((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)new PartitionOffsetRequestInfo(OffsetRequest$.MODULE$.LatestTime(), 10))})), OffsetRequest$.MODULE$.apply$default$2(), OffsetRequest$.MODULE$.apply$default$3(), OffsetRequest$.MODULE$.apply$default$4(), OffsetRequest$.MODULE$.apply$default$5());
        OffsetResponse offsetResponse = this.simpleConsumer().getOffsetsBefore(request);
        Assert.assertEquals((short)ErrorMapping$.MODULE$.UnknownTopicOrPartitionCode(), (short)((PartitionOffsetsResponse)offsetResponse.partitionErrorAndOffsets().apply((Object)topicAndPartition)).error());
    }

    @Test
    public void testGetOffsetsBeforeLatestTime() {
        String topicPartition = new StringBuilder().append((Object)"kafka-").append((Object)BoxesRunTime.boxToInteger((int)0)).toString();
        String topic = (String)Predef$.MODULE$.refArrayOps((Object[])topicPartition.split("-")).head();
        int part = Integer.valueOf((String)Predef$.MODULE$.refArrayOps((Object[])topicPartition.split("-")).last());
        AdminUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, AdminUtils$.MODULE$.createTopic$default$5());
        LogManager logManager = this.server().getLogManager();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, part, logManager){
            public static final long serialVersionUID = 0L;
            private final String topic$1;
            private final int part$1;
            private final LogManager logManager$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.logManager$1.getLog(new TopicAndPartition(this.topic$1, this.part$1)).isDefined();
            }
            {
                this.topic$1 = topic$1;
                this.part$1 = part$1;
                this.logManager$1 = logManager$1;
            }
        }, "Log for partition [topic,0] should be created", TestUtils$.MODULE$.waitUntilTrue$default$3());
        Log log = (Log)logManager.getLog(new TopicAndPartition(topic, part)).get();
        Message message = new Message(Integer.toString(42).getBytes());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1)new Serializable(this, log, message){
            public static final long serialVersionUID = 0L;
            private final Log log$1;
            private final Message message$1;

            public final Log.LogAppendInfo apply(int i) {
                return this.log$1.append(new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{this.message$1})), this.log$1.append$default$2());
            }
            {
                this.log$1 = log$1;
                this.message$1 = message$1;
            }
        });
        log.flush();
        Seq offsets = this.server().apis().fetchOffsets(logManager, new TopicAndPartition(topic, part), OffsetRequest$.MODULE$.LatestTime(), 10);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 15L, 12L, 9L, 6L, 3L, 0L})), (Object)offsets);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, part){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogOffsetTest $outer;
            private final String topic$1;
            private final int part$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return TestUtils$.MODULE$.isLeaderLocalOnBroker(this.topic$1, this.part$1, this.$outer.server());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
                this.part$1 = part$1;
            }
        }, "Leader should be elected", TestUtils$.MODULE$.waitUntilTrue$default$3());
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, part);
        Map x$1 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)new PartitionOffsetRequestInfo(OffsetRequest$.MODULE$.LatestTime(), 10))}));
        int x$2 = 0;
        short x$3 = OffsetRequest$.MODULE$.apply$default$2();
        int x$4 = OffsetRequest$.MODULE$.apply$default$3();
        String x$5 = OffsetRequest$.MODULE$.apply$default$4();
        OffsetRequest offsetRequest = new OffsetRequest(x$1, x$3, x$4, x$5, x$2);
        Seq consumerOffsets = ((PartitionOffsetsResponse)this.simpleConsumer().getOffsetsBefore(offsetRequest).partitionErrorAndOffsets().apply((Object)topicAndPartition)).offsets();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 15L, 12L, 9L, 6L, 3L, 0L})), (Object)consumerOffsets);
        FetchResponse fetchResponse = this.simpleConsumer().fetch(new FetchRequestBuilder().addFetch(topic, 0, BoxesRunTime.unboxToLong((Object)consumerOffsets.head()), 307200).build());
        Assert.assertFalse((boolean)fetchResponse.messageSet(topic, 0).iterator().hasNext());
    }

    @Test
    public void testEmptyLogsGetOffsets() {
        String topicPartition = new StringBuilder().append((Object)"kafka-").append((Object)BoxesRunTime.boxToInteger((int)this.random().nextInt(10))).toString();
        String topicPartitionPath = new StringBuilder().append((Object)this.getLogDir().getAbsolutePath()).append((Object)"/").append((Object)topicPartition).toString();
        this.topicLogDir_$eq(new File(topicPartitionPath));
        this.topicLogDir().mkdir();
        String topic = (String)Predef$.MODULE$.refArrayOps((Object[])topicPartition.split("-")).head();
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}))), TestUtils$.MODULE$.createTopic$default$6());
        BooleanRef offsetChanged = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 14).foreach$mVc$sp((Function1)new Serializable(this, topic, offsetChanged){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogOffsetTest $outer;
            private final String topic$2;
            private final BooleanRef offsetChanged$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                TopicAndPartition topicAndPartition = new TopicAndPartition(this.topic$2, 0);
                OffsetRequest offsetRequest = new OffsetRequest((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)new PartitionOffsetRequestInfo(OffsetRequest$.MODULE$.EarliestTime(), 1))})), OffsetRequest$.MODULE$.apply$default$2(), OffsetRequest$.MODULE$.apply$default$3(), OffsetRequest$.MODULE$.apply$default$4(), OffsetRequest$.MODULE$.apply$default$5());
                Seq consumerOffsets = ((PartitionOffsetsResponse)this.$outer.simpleConsumer().getOffsetsBefore(offsetRequest).partitionErrorAndOffsets().apply((Object)topicAndPartition)).offsets();
                if (BoxesRunTime.unboxToLong((Object)consumerOffsets.apply(0)) == 1L) {
                    this.offsetChanged$1.elem = true;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$2 = topic$2;
                this.offsetChanged$1 = offsetChanged$1;
            }
        });
        Assert.assertFalse((boolean)offsetChanged.elem);
    }

    @Test
    public void testGetOffsetsBeforeNow() {
        String topicPartition = new StringBuilder().append((Object)"kafka-").append((Object)BoxesRunTime.boxToInteger((int)this.random().nextInt(3))).toString();
        String topic = (String)Predef$.MODULE$.refArrayOps((Object[])topicPartition.split("-")).head();
        int part = Integer.valueOf((String)Predef$.MODULE$.refArrayOps((Object[])topicPartition.split("-")).last());
        AdminUtils$.MODULE$.createTopic(this.zkClient(), topic, 3, 1, AdminUtils$.MODULE$.createTopic$default$5());
        LogManager logManager = this.server().getLogManager();
        Log log = logManager.createLog(new TopicAndPartition(topic, part), logManager.defaultConfig());
        Message message = new Message(Integer.toString(42).getBytes());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1)new Serializable(this, log, message){
            public static final long serialVersionUID = 0L;
            private final Log log$2;
            private final Message message$2;

            public final Log.LogAppendInfo apply(int i) {
                return this.log$2.append(new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{this.message$2})), this.log$2.append$default$2());
            }
            {
                this.log$2 = log$2;
                this.message$2 = message$2;
            }
        });
        log.flush();
        long now = this.time().milliseconds() + 30000L;
        Seq offsets = this.server().apis().fetchOffsets(logManager, new TopicAndPartition(topic, part), now, 10);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 15L, 12L, 9L, 6L, 3L, 0L})), (Object)offsets);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, part){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogOffsetTest $outer;
            private final String topic$3;
            private final int part$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return TestUtils$.MODULE$.isLeaderLocalOnBroker(this.topic$3, this.part$2, this.$outer.server());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$3 = topic$3;
                this.part$2 = part$2;
            }
        }, "Leader should be elected", TestUtils$.MODULE$.waitUntilTrue$default$3());
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, part);
        Map x$6 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)new PartitionOffsetRequestInfo(now, 10))}));
        int x$7 = 0;
        short x$8 = OffsetRequest$.MODULE$.apply$default$2();
        int x$9 = OffsetRequest$.MODULE$.apply$default$3();
        String x$10 = OffsetRequest$.MODULE$.apply$default$4();
        OffsetRequest offsetRequest = new OffsetRequest(x$6, x$8, x$9, x$10, x$7);
        Seq consumerOffsets = ((PartitionOffsetsResponse)this.simpleConsumer().getOffsetsBefore(offsetRequest).partitionErrorAndOffsets().apply((Object)topicAndPartition)).offsets();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 15L, 12L, 9L, 6L, 3L, 0L})), (Object)consumerOffsets);
    }

    @Test
    public void testGetOffsetsBeforeEarliestTime() {
        String topicPartition = new StringBuilder().append((Object)"kafka-").append((Object)BoxesRunTime.boxToInteger((int)this.random().nextInt(3))).toString();
        String topic = (String)Predef$.MODULE$.refArrayOps((Object[])topicPartition.split("-")).head();
        int part = Integer.valueOf((String)Predef$.MODULE$.refArrayOps((Object[])topicPartition.split("-")).last());
        AdminUtils$.MODULE$.createTopic(this.zkClient(), topic, 3, 1, AdminUtils$.MODULE$.createTopic$default$5());
        LogManager logManager = this.server().getLogManager();
        Log log = logManager.createLog(new TopicAndPartition(topic, part), logManager.defaultConfig());
        Message message = new Message(Integer.toString(42).getBytes());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1)new Serializable(this, log, message){
            public static final long serialVersionUID = 0L;
            private final Log log$3;
            private final Message message$3;

            public final Log.LogAppendInfo apply(int i) {
                return this.log$3.append(new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{this.message$3})), this.log$3.append$default$2());
            }
            {
                this.log$3 = log$3;
                this.message$3 = message$3;
            }
        });
        log.flush();
        Seq offsets = this.server().apis().fetchOffsets(logManager, new TopicAndPartition(topic, part), OffsetRequest$.MODULE$.EarliestTime(), 10);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), (Object)offsets);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, part){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogOffsetTest $outer;
            private final String topic$4;
            private final int part$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return TestUtils$.MODULE$.isLeaderLocalOnBroker(this.topic$4, this.part$3, this.$outer.server());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$4 = topic$4;
                this.part$3 = part$3;
            }
        }, "Leader should be elected", TestUtils$.MODULE$.waitUntilTrue$default$3());
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, part);
        OffsetRequest offsetRequest = new OffsetRequest((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)new PartitionOffsetRequestInfo(OffsetRequest$.MODULE$.EarliestTime(), 10))})), OffsetRequest$.MODULE$.apply$default$2(), OffsetRequest$.MODULE$.apply$default$3(), OffsetRequest$.MODULE$.apply$default$4(), OffsetRequest$.MODULE$.apply$default$5());
        Seq consumerOffsets = ((PartitionOffsetsResponse)this.simpleConsumer().getOffsetsBefore(offsetRequest).partitionErrorAndOffsets().apply((Object)topicAndPartition)).offsets();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), (Object)consumerOffsets);
    }

    /*
     * WARNING - void declaration
     */
    private Properties createBrokerConfig(int nodeId, int port) {
        void var3_3;
        Properties props = new Properties();
        props.put("broker.id", ((Object)BoxesRunTime.boxToInteger((int)nodeId)).toString());
        props.put("port", ((Object)BoxesRunTime.boxToInteger((int)port)).toString());
        props.put("log.dir", this.getLogDir().getAbsolutePath());
        props.put("log.flush.interval.messages", "1");
        props.put("enable.zookeeper", "false");
        props.put("num.partitions", "20");
        props.put("log.retention.hours", "10");
        props.put("log.retention.check.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)300000)).toString());
        props.put("log.segment.bytes", ((Object)BoxesRunTime.boxToInteger((int)this.logSize())).toString());
        props.put("zookeeper.connect", this.zkConnect().toString());
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private File getLogDir() {
        void var1_1;
        File dir = TestUtils$.MODULE$.tempDir();
        return var1_1;
    }

    public LogOffsetTest() {
        ZooKeeperTestHarness$class.$init$(this);
        this.random = new Random();
        this.logDir = null;
        this.topicLogDir = null;
        this.server = null;
        this.logSize = 100;
        this.brokerPort = 9099;
        this.simpleConsumer = null;
        this.time = new MockTime();
    }
}

