/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.util.Properties;
import kafka.admin.AdminUtils$;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.common.ErrorMapping$;
import kafka.common.FailedToSendMessageException;
import kafka.consumer.SimpleConsumer;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.serializer.StringEncoder;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRequestHandler;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.StaticPartitioner;
import kafka.utils.SystemTime$;
import kafka.utils.TestUtils$;
import kafka.utils.Utils$;
import kafka.utils.ZkUtils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.exceptions.TestFailedException;
import org.scalatest.junit.JUnit3Suite;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001B\u0001\u0003\u0001\u001d\u0011A\u0002\u0015:pIV\u001cWM\u001d+fgRT!a\u0001\u0003\u0002\u0011A\u0014x\u000eZ;dKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001B\u0005\r\u0011\u0005%\u0001R\"\u0001\u0006\u000b\u0005-a\u0011!\u00026v]&$(BA\u0007\u000f\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001\u0010\u0003\ry'oZ\u0005\u0003#)\u00111BS+oSR\u001c4+^5uKB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0003u.L!a\u0006\u000b\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t!\tIB$D\u0001\u001b\u0015\tYB!A\u0003vi&d7/\u0003\u0002\u001e5\t9Aj\\4hS:<\u0007\"B\u0010\u0001\t\u0003\u0001\u0013A\u0002\u001fj]&$h\bF\u0001\"!\t\u0011\u0003!D\u0001\u0003\u0011\u001d!\u0003A1A\u0005\n\u0015\n\u0011B\u0019:pW\u0016\u0014\u0018\nZ\u0019\u0016\u0003\u0019\u0002\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u00121!\u00138u\u0011\u0019i\u0003\u0001)A\u0005M\u0005Q!M]8lKJLE-\r\u0011\t\u000f=\u0002!\u0019!C\u0005K\u0005I!M]8lKJLEM\r\u0005\u0007c\u0001\u0001\u000b\u0011\u0002\u0014\u0002\u0015\t\u0014xn[3s\u0013\u0012\u0014\u0004\u0005C\u00044\u0001\t\u0007I\u0011\u0002\u001b\u0002\u000bA|'\u000f^:\u0016\u0003U\u00022A\u000e '\u001d\t9DH\u0004\u00029w5\t\u0011H\u0003\u0002;\r\u00051AH]8pizJ\u0011!K\u0005\u0003{!\nq\u0001]1dW\u0006<W-\u0003\u0002@\u0001\n!A*[:u\u0015\ti\u0004\u0006\u0003\u0004C\u0001\u0001\u0006I!N\u0001\u0007a>\u0014Ho\u001d\u0011\t\u0015\u0011\u0003\u0001\u0013!A\u0002B\u0003%Q)A\u0002yIE\u0002Ba\n$'M%\u0011q\t\u000b\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f%\u0003!\u0019!C\u0005K\u0005)\u0001o\u001c:uc!11\n\u0001Q\u0001\n\u0019\na\u0001]8siF\u0002\u0003bB'\u0001\u0005\u0004%I!J\u0001\u0006a>\u0014HO\r\u0005\u0007\u001f\u0002\u0001\u000b\u0011\u0002\u0014\u0002\rA|'\u000f\u001e\u001a!\u0011\u001d\t\u0006\u00011A\u0005\nI\u000bqa]3sm\u0016\u0014\u0018'F\u0001T!\t!v+D\u0001V\u0015\t1F!\u0001\u0004tKJ4XM]\u0005\u00031V\u00131bS1gW\u0006\u001cVM\u001d<fe\"9!\f\u0001a\u0001\n\u0013Y\u0016aC:feZ,'/M0%KF$\"\u0001X0\u0011\u0005\u001dj\u0016B\u00010)\u0005\u0011)f.\u001b;\t\u000f\u0011K\u0016\u0011!a\u0001'\"1\u0011\r\u0001Q!\nM\u000b\u0001b]3sm\u0016\u0014\u0018\u0007\t\u0005\bG\u0002\u0001\r\u0011\"\u0003S\u0003\u001d\u0019XM\u001d<feJBq!\u001a\u0001A\u0002\u0013%a-A\u0006tKJ4XM\u001d\u001a`I\u0015\fHC\u0001/h\u0011\u001d!E-!AA\u0002MCa!\u001b\u0001!B\u0013\u0019\u0016\u0001C:feZ,'O\r\u0011\t\u000f-\u0004\u0001\u0019!C\u0005Y\u0006I1m\u001c8tk6,'/M\u000b\u0002[B\u0011a.]\u0007\u0002_*\u0011\u0001\u000fB\u0001\tG>t7/^7fe&\u0011!o\u001c\u0002\u000f'&l\u0007\u000f\\3D_:\u001cX/\\3s\u0011\u001d!\b\u00011A\u0005\nU\fQbY8ogVlWM]\u0019`I\u0015\fHC\u0001/w\u0011\u001d!5/!AA\u00025Da\u0001\u001f\u0001!B\u0013i\u0017AC2p]N,X.\u001a:2A!9!\u0010\u0001a\u0001\n\u0013a\u0017!C2p]N,X.\u001a:3\u0011\u001da\b\u00011A\u0005\nu\fQbY8ogVlWM\u001d\u001a`I\u0015\fHC\u0001/\u007f\u0011\u001d!50!AA\u00025Dq!!\u0001\u0001A\u0003&Q.\u0001\u0006d_:\u001cX/\\3se\u0001B\u0011\"!\u0002\u0001\u0005\u0004%I!a\u0002\u0002)I,\u0017/^3ti\"\u000bg\u000e\u001a7fe2{wmZ3s+\t\tI\u0001\u0005\u0003\u0002\f\u0005UQBAA\u0007\u0015\u0011\ty!!\u0005\u0002\u000b1|w\r\u000e6\u000b\u0007\u0005Ma\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003/\tiA\u0001\u0004M_\u001e<WM\u001d\u0005\t\u00037\u0001\u0001\u0015!\u0003\u0002\n\u0005)\"/Z9vKN$\b*\u00198eY\u0016\u0014Hj\\4hKJ\u0004\u0003\"CA\u0010\u0001\u0001\u0007I\u0011BA\u0011\u0003\u001d\u0019XM\u001d<feN,\"!a\t\u0011\u000b\u0005\u0015\u0012qF*\u000e\u0005\u0005\u001d\"\u0002BA\u0015\u0003W\t\u0011\"[7nkR\f'\r\\3\u000b\u0007\u00055\u0002&\u0001\u0006d_2dWm\u0019;j_:L1aPA\u0014\u0011%\t\u0019\u0004\u0001a\u0001\n\u0013\t)$A\u0006tKJ4XM]:`I\u0015\fHc\u0001/\u00028!IA)!\r\u0002\u0002\u0003\u0007\u00111\u0005\u0005\t\u0003w\u0001\u0001\u0015)\u0003\u0002$\u0005A1/\u001a:wKJ\u001c\b\u0005C\u0005\u0002@\u0001\u0011\r\u0011\"\u0003\u0002B\u00051\u0001O]8qgF*\"!a\u0011\u0011\t\u0005\u0015\u0013qJ\u0007\u0003\u0003\u000fRA!!\u0013\u0002L\u0005!Q\u000f^5m\u0015\t\ti%\u0001\u0003kCZ\f\u0017\u0002BA)\u0003\u000f\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0011!\t)\u0006\u0001Q\u0001\n\u0005\r\u0013a\u00029s_B\u001c\u0018\u0007\t\u0005\n\u00033\u0002!\u0019!C\u0005\u00037\nqaY8oM&<\u0017'\u0006\u0002\u0002^A\u0019A+a\u0018\n\u0007\u0005\u0005TKA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\u0002CA3\u0001\u0001\u0006I!!\u0018\u0002\u0011\r|gNZ5hc\u0001B\u0011\"!\u001b\u0001\u0005\u0004%I!!\u0011\u0002\rA\u0014x\u000e]:3\u0011!\ti\u0007\u0001Q\u0001\n\u0005\r\u0013a\u00029s_B\u001c(\u0007\t\u0005\n\u0003c\u0002!\u0019!C\u0005\u00037\nqaY8oM&<'\u0007\u0003\u0005\u0002v\u0001\u0001\u000b\u0011BA/\u0003!\u0019wN\u001c4jOJ\u0002\u0003bBA=\u0001\u0011\u0005\u00131P\u0001\u0006g\u0016$X\u000b\u001d\u000b\u00029\"9\u0011q\u0010\u0001\u0005B\u0005m\u0014\u0001\u0003;fCJ$un\u001e8\t\u000f\u0005\r\u0005\u0001\"\u0001\u0002|\u0005iB/Z:u+B$\u0017\r^3Ce>\\WM\u001d)beRLG/[8o\u0013:4w\u000e\u000b\u0003\u0002\u0002\u0006\u001d\u0005\u0003BAE\u0003\u001bk!!a#\u000b\u0005-q\u0011\u0002BAH\u0003\u0017\u0013A\u0001V3ti\"9\u00111\u0013\u0001\u0005\u0002\u0005m\u0014A\u0005;fgR\u001cVM\u001c3U_:+w\u000fV8qS\u000eDC!!%\u0002\b\"9\u0011\u0011\u0014\u0001\u0005\u0002\u0005m\u0014A\u0006;fgR\u001cVM\u001c3XSRDG)Z1e\u0005J|7.\u001a:)\t\u0005]\u0015q\u0011\u0005\b\u0003?\u0003A\u0011AA>\u0003!\"Xm\u001d;Bgft7mU3oI\u000e\u000bgnQ8se\u0016\u001cG\u000f\\=GC&dw+\u001b;i)&lWm\\;uQ\u0011\ti*a\"\t\u000f\u0005\u0015\u0006\u0001\"\u0001\u0002|\u0005\u0019B/Z:u'\u0016tGMT;mY6+7o]1hK\"\"\u00111UAD\u0001")
public class ProducerTest
extends JUnit3Suite
implements ZooKeeperTestHarness,
Logging {
    private final int brokerId1;
    private final int brokerId2;
    private final List<Object> ports;
    private final /* synthetic */ Tuple2 x$1;
    private final int port1;
    private final int port2;
    private KafkaServer server1;
    private KafkaServer server2;
    private SimpleConsumer consumer1;
    private SimpleConsumer consumer2;
    private final Logger requestHandlerLogger;
    private List<KafkaServer> servers;
    private final Properties props1;
    private final KafkaConfig config1;
    private final Properties props2;
    private final KafkaConfig config2;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private final String zkConnect;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ProducerTest producerTest = this;
        synchronized (producerTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    @Override
    public String zkConnect() {
        return this.zkConnect;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public ZkClient zkClient() {
        return this.zkClient;
    }

    @Override
    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public /* synthetic */ void kafka$zk$ZooKeeperTestHarness$$super$setUp() {
        super.setUp();
    }

    @Override
    public /* synthetic */ void kafka$zk$ZooKeeperTestHarness$$super$tearDown() {
        super.tearDown();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    private int brokerId1() {
        return this.brokerId1;
    }

    private int brokerId2() {
        return this.brokerId2;
    }

    private List<Object> ports() {
        return this.ports;
    }

    private int port1() {
        return this.port1;
    }

    private int port2() {
        return this.port2;
    }

    private KafkaServer server1() {
        return this.server1;
    }

    private void server1_$eq(KafkaServer x$1) {
        this.server1 = x$1;
    }

    private KafkaServer server2() {
        return this.server2;
    }

    private void server2_$eq(KafkaServer x$1) {
        this.server2 = x$1;
    }

    private SimpleConsumer consumer1() {
        return this.consumer1;
    }

    private void consumer1_$eq(SimpleConsumer x$1) {
        this.consumer1 = x$1;
    }

    private SimpleConsumer consumer2() {
        return this.consumer2;
    }

    private void consumer2_$eq(SimpleConsumer x$1) {
        this.consumer2 = x$1;
    }

    private Logger requestHandlerLogger() {
        return this.requestHandlerLogger;
    }

    private List<KafkaServer> servers() {
        return this.servers;
    }

    private void servers_$eq(List<KafkaServer> x$1) {
        this.servers = x$1;
    }

    private Properties props1() {
        return this.props1;
    }

    private KafkaConfig config1() {
        return this.config1;
    }

    private Properties props2() {
        return this.props2;
    }

    private KafkaConfig config2() {
        return this.config2;
    }

    @Override
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        this.server1_$eq(TestUtils$.MODULE$.createServer(this.config1(), TestUtils$.MODULE$.createServer$default$2()));
        this.server2_$eq(TestUtils$.MODULE$.createServer(this.config2(), TestUtils$.MODULE$.createServer$default$2()));
        this.servers_$eq((List<KafkaServer>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1(), this.server2()})));
        Properties props = new Properties();
        props.put("host", "localhost");
        props.put("port", ((Object)BoxesRunTime.boxToInteger((int)this.port1())).toString());
        this.consumer1_$eq(new SimpleConsumer("localhost", this.port1(), 1000000, 65536, ""));
        this.consumer2_$eq(new SimpleConsumer("localhost", this.port2(), 100, 65536, ""));
        this.requestHandlerLogger().setLevel(Level.FATAL);
    }

    @Override
    public void tearDown() {
        this.requestHandlerLogger().setLevel(Level.ERROR);
        if (this.consumer1() != null) {
            this.consumer1().close();
        }
        if (this.consumer2() != null) {
            this.consumer2().close();
        }
        this.server1().shutdown();
        this.server2().shutdown();
        Utils$.MODULE$.rm(this.server1().config().logDirs());
        Utils$.MODULE$.rm(this.server2().config().logDirs());
        ZooKeeperTestHarness$class.tearDown(this);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUpdateBrokerPartitionInfo() {
        String topic = "new-topic";
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        Properties props = new Properties();
        props.put("message.send.max.retries", "0");
        String x$2 = "localhost:80,localhost:81";
        String x$3 = StringEncoder.class.getName();
        String x$4 = StringEncoder.class.getName();
        Properties x$5 = props;
        String x$6 = TestUtils$.MODULE$.createProducer$default$4();
        Producer producer1 = TestUtils$.MODULE$.createProducer(x$2, x$3, x$4, x$6, x$5);
        try {
            try {
                producer1.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)"test", (Object)"test1")}));
                throw this.fail("Test should fail because the broker list provided are not valid");
            }
            catch (Throwable throwable) {
                throw this.fail("fails with exception", throwable);
            }
            catch (FailedToSendMessageException failedToSendMessageException) {
            }
        }
        finally {
            producer1.close();
        }
        Producer producer2 = TestUtils$.MODULE$.createProducer(new StringBuilder().append((Object)"localhost:80,").append((Object)TestUtils$.MODULE$.getBrokerListStrFromConfigs((Seq<KafkaConfig>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{this.config1()}))))).toString(), StringEncoder.class.getName(), StringEncoder.class.getName(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5());
        try {
            producer2.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)"test", (Object)"test1")}));
        }
        catch (Throwable throwable) {
            try {
                throw this.fail("Should succeed sending the message", throwable);
            }
            catch (Throwable throwable2) {
                void var12_12;
                var12_12.close();
                throw throwable2;
            }
        }
        producer2.close();
        Producer producer3 = TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromConfigs((Seq<KafkaConfig>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{this.config1(), this.config2()})))), StringEncoder.class.getName(), StringEncoder.class.getName(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5());
        try {
            producer3.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)"test", (Object)"test1")}));
        }
        catch (Throwable throwable) {
            try {
                throw this.fail("Should succeed sending the message", throwable);
            }
            catch (Throwable throwable3) {
                void var15_13;
                var15_13.close();
                throw throwable3;
            }
        }
        producer3.close();
    }

    @Test
    public void testSendToNewTopic() {
        Buffer buffer;
        Properties props1 = new Properties();
        props1.put("request.required.acks", "-1");
        String topic = "new-topic";
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        Producer producer1 = TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromConfigs((Seq<KafkaConfig>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{this.config1(), this.config2()})))), StringEncoder.class.getName(), StringEncoder.class.getName(), StaticPartitioner.class.getName(), props1);
        producer1.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)"test", (Object)"test1")}));
        producer1.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)"test", (Object)"test2")}));
        Option leaderOpt = ZkUtils$.MODULE$.getLeaderForPartition(this.zkClient(), topic, 0);
        Assert.assertTrue((String)"Leader for topic new-topic partition 0 should exist", (boolean)leaderOpt.isDefined());
        int leader = BoxesRunTime.unboxToInt((Object)leaderOpt.get());
        if (leader == this.server1().config().brokerId()) {
            FetchResponse response1 = this.consumer1().fetch(new FetchRequestBuilder().addFetch(topic, 0, 0L, 10000).build());
            buffer = response1.messageSet("new-topic", 0).iterator().toBuffer();
        } else {
            FetchResponse response2 = this.consumer2().fetch(new FetchRequestBuilder().addFetch(topic, 0, 0L, 10000).build());
            buffer = response2.messageSet("new-topic", 0).iterator().toBuffer();
        }
        Buffer messageSet = buffer;
        Assert.assertEquals((String)"Should have fetched 2 messages", (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)messageSet.size()));
        Assert.assertEquals((Object)new Message("test1".getBytes(), "test".getBytes()), (Object)((MessageAndOffset)messageSet.apply(0)).message());
        Assert.assertEquals((Object)new Message("test2".getBytes(), "test".getBytes()), (Object)((MessageAndOffset)messageSet.apply(1)).message());
        producer1.close();
        Properties props2 = new Properties();
        props2.put("request.required.acks", "3");
        props2.put("message.send.max.retries", "0");
        try {
            Producer producer2 = TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromConfigs((Seq<KafkaConfig>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{this.config1(), this.config2()})))), StringEncoder.class.getName(), StringEncoder.class.getName(), StaticPartitioner.class.getName(), props2);
            producer2.close();
            throw this.fail("we don't support request.required.acks greater than 1");
        }
        catch (Throwable throwable) {
            throw this.fail("Not expected", throwable);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    /*
     * Loose catch block
     */
    @Test
    public void testSendWithDeadBroker() {
        Properties props = new Properties();
        props.put("request.required.acks", "1");
        props.put("message.send.max.retries", "0");
        String topic = "new-topic";
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}))), (Seq<KafkaServer>)this.servers());
        Producer producer = TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromConfigs((Seq<KafkaConfig>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{this.config1(), this.config2()})))), StringEncoder.class.getName(), StringEncoder.class.getName(), StaticPartitioner.class.getName(), props);
        try {
            producer.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)"test", (Object)"test1")}));
        }
        catch (Throwable throwable) {
            throw this.fail(new StringBuilder().append((Object)"Unexpected exception: ").append((Object)throwable).toString());
        }
        this.server1().shutdown();
        this.server1().awaitShutdown();
        try {
            producer.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)"test", (Object)"test1")}));
            throw this.fail("Should fail since no leader exists for the partition.");
        }
        catch (Throwable throwable) {
            this.server1().startup();
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topic, 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), topic, 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            FetchResponse response1 = this.consumer1().fetch(new FetchRequestBuilder().addFetch(topic, 0, 0L, 10000).build());
            Iterator messageSet1 = response1.messageSet(topic, 0).iterator();
            Assert.assertTrue((String)"Message set should have 1 message", (boolean)messageSet1.hasNext());
            Assert.assertEquals((Object)new Message("test1".getBytes(), "test".getBytes()), (Object)((MessageAndOffset)messageSet1.next()).message());
            Assert.assertFalse((String)"Message set should have another message", (boolean)messageSet1.hasNext());
            producer.close();
            return;
        }
        catch (TestFailedException testFailedException) {
            throw testFailedException;
        }
        {
            catch (Exception exception) {
                throw this.fail("Not expected", exception);
            }
        }
    }

    @Test
    public void testAsyncSendCanCorrectlyFailWithTimeout() {
        int timeoutMs = 500;
        Properties props = new Properties();
        props.put("request.timeout.ms", String.valueOf(timeoutMs));
        props.put("request.required.acks", "1");
        props.put("message.send.max.retries", "0");
        props.put("client.id", "ProducerTest-testAsyncSendCanCorrectlyFailWithTimeout");
        Producer producer = TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromConfigs((Seq<KafkaConfig>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{this.config1(), this.config2()})))), StringEncoder.class.getName(), StringEncoder.class.getName(), StaticPartitioner.class.getName(), props);
        String topic = "new-topic";
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), (Seq<KafkaServer>)this.servers());
        try {
            producer.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)"test", (Object)"test")}));
            FetchResponse response1 = this.consumer1().fetch(new FetchRequestBuilder().addFetch(topic, 0, 0L, 10000).build());
            Iterator messageSet1 = response1.messageSet("new-topic", 0).iterator();
            Assert.assertTrue((String)"Message set should have 1 message", (boolean)messageSet1.hasNext());
            Assert.assertEquals((Object)new Message("test".getBytes()), (Object)((MessageAndOffset)messageSet1.next()).message());
        }
        catch (Exception exception) {
            producer.close();
            throw this.fail("Not expected", exception);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.server1().requestHandlerPool().shutdown();
        long t1 = SystemTime$.MODULE$.milliseconds();
        try {
            try {
                producer.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)"test", (Object)"test")}));
            }
            catch (Exception exception) {
                throw this.fail("Not expected", exception);
            }
            catch (FailedToSendMessageException failedToSendMessageException) {
            }
        }
        finally {
            producer.close();
        }
        long t2 = SystemTime$.MODULE$.milliseconds();
        Assert.assertTrue((t2 - t1 >= (long)timeoutMs ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSendNullMessage() {
        Producer producer = TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromConfigs((Seq<KafkaConfig>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{this.config1(), this.config2()})))), StringEncoder.class.getName(), StringEncoder.class.getName(), StaticPartitioner.class.getName(), TestUtils$.MODULE$.createProducer$default$5());
        try {
            AdminUtils$.MODULE$.createTopic(this.zkClient(), "new-topic", 2, 1, AdminUtils$.MODULE$.createTopic$default$5());
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProducerTest $outer;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return AdminUtils$.MODULE$.fetchTopicMetadataFromZk("new-topic", this.$outer.zkClient()).errorCode() != ErrorMapping$.MODULE$.UnknownTopicOrPartitionCode();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, "Topic new-topic not created after timeout", this.zookeeper().tickTime());
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), "new-topic", 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
            producer.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("new-topic", (Object)"key", null)}));
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.close();
            throw throwable;
        }
        producer.close();
    }

    public ProducerTest() {
        ZooKeeperTestHarness$class.$init$(this);
        Logging.class.$init$((Logging)this);
        this.brokerId1 = 0;
        this.brokerId2 = 1;
        this.ports = TestUtils$.MODULE$.choosePorts(2);
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)this.ports().apply(0)), BoxesRunTime.unboxToInt((Object)this.ports().apply(1)));
        if (sp2 != null) {
            int port1 = sp2._1$mcI$sp();
            int port2 = sp2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(port1, port2);
            this.x$1 = sp3;
            this.port1 = this.x$1._1$mcI$sp();
            this.port2 = this.x$1._2$mcI$sp();
            this.server1 = null;
            this.server2 = null;
            this.consumer1 = null;
            this.consumer2 = null;
            this.requestHandlerLogger = Logger.getLogger(KafkaRequestHandler.class);
            this.servers = List$.MODULE$.empty();
            this.props1 = TestUtils$.MODULE$.createBrokerConfig(this.brokerId1(), this.port1(), false);
            this.props1().put("num.partitions", "4");
            this.config1 = new KafkaConfig(this.props1());
            this.props2 = TestUtils$.MODULE$.createBrokerConfig(this.brokerId2(), this.port2(), false);
            this.props2().put("num.partitions", "4");
            this.config2 = new KafkaConfig(this.props2());
            return;
        }
        throw new MatchError((Object)sp2);
    }
}

