/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import junit.framework.Assert;
import kafka.common.InvalidOffsetException;
import kafka.log.OffsetIndex;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.utils.TestUtils$;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.TreeMap;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u00055b\u0001B\u0001\u0003\u0001\u001d\u0011qb\u00144gg\u0016$\u0018J\u001c3fqR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1\u0001\\8h\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\t\u000e\u0003)Q!a\u0003\u0007\u0002\u000b),h.\u001b;\u000b\u00055q\u0011!C:dC2\fG/Z:u\u0015\u0005y\u0011aA8sO&\u0011\u0011C\u0003\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007\"B\n\u0001\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\u0016!\t1\u0002!D\u0001\u0003\u0011\u001dA\u0002\u00011A\u0005\u0002e\t1!\u001b3y+\u0005Q\u0002C\u0001\f\u001c\u0013\ta\"AA\u0006PM\u001a\u001cX\r^%oI\u0016D\bb\u0002\u0010\u0001\u0001\u0004%\taH\u0001\bS\u0012Dx\fJ3r)\t\u0001c\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0003V]&$\bbB\u0014\u001e\u0003\u0003\u0005\rAG\u0001\u0004q\u0012\n\u0004BB\u0015\u0001A\u0003&!$\u0001\u0003jIb\u0004\u0003bB\u0016\u0001\u0005\u0004%\t\u0001L\u0001\u000b[\u0006DXI\u001c;sS\u0016\u001cX#A\u0017\u0011\u0005\u0005r\u0013BA\u0018#\u0005\rIe\u000e\u001e\u0005\u0007c\u0001\u0001\u000b\u0011B\u0017\u0002\u00175\f\u00070\u00128ue&,7\u000f\t\u0005\u0006g\u0001!\t\u0001N\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002A!\u0012!G\u000e\t\u0003oej\u0011\u0001\u000f\u0006\u0003\u00179I!A\u000f\u001d\u0003\r\t+gm\u001c:f\u0011\u0015a\u0004\u0001\"\u00015\u0003!!X-\u0019:e_^t\u0007FA\u001e?!\t9t(\u0003\u0002Aq\t)\u0011I\u001a;fe\")!\t\u0001C\u0001i\u0005\u0001\"/\u00198e_6dun\\6vaR+7\u000f\u001e\u0015\u0003\u0003\u0012\u0003\"aN#\n\u0005\u0019C$\u0001\u0002+fgRDQ\u0001\u0013\u0001\u0005\u0002Q\n!\u0003\\8pWV\u0004X\t\u001f;sK6,7)Y:fg\"\u0012q\t\u0012\u0005\u0006\u0017\u0002!\t\u0001N\u0001\u000eCB\u0004XM\u001c3U_>l\u0015M\\=)\u0005)#\u0005\"\u0002(\u0001\t\u0003!\u0014\u0001E1qa\u0016tGmT;u\u001f\u001a|%\u000fZ3sQ\u0011iE\tU)\u0002\u0011\u0015D\b/Z2uK\u0012\u001c\u0013A\u0015\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+\u0012\taaY8n[>t\u0017BA,U\u0005YIeN^1mS\u0012|eMZ:fi\u0016C8-\u001a9uS>t\u0007\"B-\u0001\t\u0003!\u0014A\u0003;fgR\u0014Vm\u001c9f]\"\u0012\u0001\f\u0012\u0005\u00069\u0002!\t\u0001N\u0001\tiJ,hnY1uK\"\u00121\f\u0012\u0005\u0006?\u0002!\t\u0001Y\u0001\u0011CN\u001cXM\u001d;Xe&$XMR1jYN,\"!Y;\u0015\u000b\u0001\u00127\u000e\u001c8\t\u000b\rt\u0006\u0019\u00013\u0002\u000f5,7o]1hKB\u0011Q\r\u001b\b\u0003C\u0019L!a\u001a\u0012\u0002\rA\u0013X\rZ3g\u0013\tI'N\u0001\u0004TiJLgn\u001a\u0006\u0003O\nBQ\u0001\u00070A\u0002iAQ!\u001c0A\u00025\naa\u001c4gg\u0016$\b\"B8_\u0001\u0004\u0001\u0018!B6mCN\u001c\bcA3rg&\u0011!O\u001b\u0002\u0006\u00072\f7o\u001d\t\u0003iVd\u0001\u0001B\u0003w=\n\u0007qOA\u0001U#\tA8\u0010\u0005\u0002\"s&\u0011!P\t\u0002\b\u001d>$\b.\u001b8h!\t\tC0\u0003\u0002~E\t\u0019\u0011I\\=\t\r}\u0004A\u0011AA\u0001\u00031iwN\\8u_:L7mU3r)\u0019\t\u0019!a\u0004\u0002\u0014A)\u0011QAA\u0006[5\u0011\u0011q\u0001\u0006\u0004\u0003\u0013\u0011\u0013AC2pY2,7\r^5p]&!\u0011QBA\u0004\u0005\r\u0019V-\u001d\u0005\u0007\u0003#q\b\u0019A\u0017\u0002\t\t\f7/\u001a\u0005\u0007\u0003+q\b\u0019A\u0017\u0002\u00071,g\u000eC\u0004\u0002\u001a\u0001!\t!a\u0007\u0002'9|g.\u0012=jgR\fg\u000e\u001e+f[B4\u0015\u000e\\3\u0015\u0005\u0005u\u0001\u0003BA\u0010\u0003Si!!!\t\u000b\t\u0005\r\u0012QE\u0001\u0003S>T!!a\n\u0002\t)\fg/Y\u0005\u0005\u0003W\t\tC\u0001\u0003GS2,\u0007")
public class OffsetIndexTest
extends JUnitSuite {
    private OffsetIndex idx = null;
    private final int maxEntries;

    public OffsetIndex idx() {
        return this.idx;
    }

    public void idx_$eq(OffsetIndex x$1) {
        this.idx = x$1;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    @Before
    public void setup() {
        this.idx_$eq(new OffsetIndex(this.nonExistantTempFile(), 45L, 240));
    }

    @After
    public void teardown() {
        if (this.idx() != null) {
            this.idx().file().delete();
        }
    }

    @Test
    public void randomLookupTest() {
        Assert.assertEquals((String)"Not present value should return physical offset 0.", (Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(92L));
        int base = (int)this.idx().baseOffset() + 1;
        int size = this.idx().maxEntries();
        Seq vals = (Seq)((IterableLike)this.monotonicSeq(base, size).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(int x$1) {
                return this.apply$mcJI$sp(x$1);
            }

            public long apply$mcJI$sp(int x$1) {
                return x$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).zip(this.monotonicSeq(0, size), Seq$.MODULE$.canBuildFrom());
        vals.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndexTest $outer;

            public final void apply(Tuple2<Object, Object> x) {
                this.$outer.idx().append(x._1$mcJ$sp(), x._2$mcI$sp());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        vals.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndexTest $outer;

            public final void apply(Tuple2<Object, Object> x$2) {
                Tuple2<Object, Object> tuple2 = x$2;
                if (tuple2 != null) {
                    long logical = tuple2._1$mcJ$sp();
                    int physical = tuple2._2$mcI$sp();
                    Assert.assertEquals((String)"Should be able to find values that are present.", (Object)new OffsetPosition(logical, physical), (Object)this.$outer.idx().lookup(logical));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        TreeMap valMap = new TreeMap((Ordering)Ordering.Long$.MODULE$).$plus$plus((GenTraversableOnce)vals.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Tuple2<Object, Object>> apply(Tuple2<Object, Object> p) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)p._1$mcJ$sp()), p);
            }
        }, Seq$.MODULE$.canBuildFrom()));
        long[] offsets = (long[])new RichLong(Predef$.MODULE$.longWrapper(this.idx().baseOffset())).until((Object)BoxesRunTime.boxToLong((long)((int)((Tuple2)vals.last())._1$mcJ$sp()))).toArray(ClassTag$.MODULE$.Long());
        Collections.shuffle(Arrays.asList((Object[])new long[][]{offsets}));
        Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.longArrayOps(offsets).take(30)).foreach((Function1)new Serializable(this, valMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndexTest $outer;
            private final TreeMap valMap$1;

            public final void apply(long offset) {
                this.apply$mcVJ$sp(offset);
            }

            public void apply$mcVJ$sp(long offset) {
                OffsetPosition rightAnswer = offset < BoxesRunTime.unboxToLong((Object)this.valMap$1.firstKey()) ? new OffsetPosition(this.$outer.idx().baseOffset(), 0) : new OffsetPosition(this.valMap$1.to((Object)BoxesRunTime.boxToLong((long)offset)).last()._1$mcJ$sp(), ((Tuple2)this.valMap$1.to((Object)BoxesRunTime.boxToLong((long)offset)).last()._2())._2$mcI$sp());
                Assert.assertEquals((String)"The index should give the same answer as the sorted map", (Object)rightAnswer, (Object)this.$outer.idx().lookup(offset));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.valMap$1 = valMap$1;
            }
        });
    }

    @Test
    public void lookupExtremeCases() {
        Assert.assertEquals((String)"Lookup on empty file", (Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(this.idx().baseOffset()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndexTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.idx().append(this.$outer.idx().baseOffset() + (long)i + 1L, i);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(this.idx().baseOffset()));
        Assert.assertEquals((Object)new OffsetPosition(this.idx().baseOffset() + (long)this.idx().maxEntries(), this.idx().maxEntries() - 1), (Object)this.idx().lookup(this.idx().baseOffset() + (long)this.idx().maxEntries()));
    }

    @Test
    public void appendTooMany() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndexTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                long offset = this.$outer.idx().baseOffset() + (long)i + 1L;
                this.$outer.idx().append(offset, i);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.assertWriteFails("Append should fail on a full index", this.idx(), this.idx().maxEntries() + 1, IllegalArgumentException.class);
    }

    @Test(expected=InvalidOffsetException.class)
    public void appendOutOfOrder() {
        this.idx().append(51L, 0);
        this.idx().append(50L, 1);
    }

    @Test
    public void testReopen() {
        OffsetPosition first = new OffsetPosition(51L, 0);
        OffsetPosition sec = new OffsetPosition(52L, 1);
        this.idx().append(first.offset(), first.position());
        this.idx().append(sec.offset(), sec.position());
        this.idx().close();
        OffsetIndex idxRo = new OffsetIndex(this.idx().file(), this.idx().baseOffset(), OffsetIndex$.MODULE$.$lessinit$greater$default$3());
        Assert.assertEquals((Object)first, (Object)idxRo.lookup(first.offset()));
        Assert.assertEquals((Object)sec, (Object)idxRo.lookup(sec.offset()));
        Assert.assertEquals((long)sec.offset(), (long)idxRo.lastOffset());
        Assert.assertEquals((int)2, (int)idxRo.entries());
        this.assertWriteFails("Append should fail on read-only index", idxRo, 53, IllegalArgumentException.class);
    }

    @Test
    public void truncate() {
        OffsetIndex idx = new OffsetIndex(this.nonExistantTempFile(), 0L, 80);
        idx.truncate();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)new Serializable(this, idx){
            public static final long serialVersionUID = 0L;
            private final OffsetIndex idx$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.idx$1.append((long)i, i);
            }
            {
                this.idx$1 = idx$1;
            }
        });
        idx.truncateTo(12L);
        Assert.assertEquals((String)"Index should be unchanged by truncate past the end", (Object)new OffsetPosition(9L, 9), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"9 should be the last entry in the index", (long)9L, (long)idx.lastOffset());
        idx.append(10L, 10);
        idx.truncateTo(10L);
        Assert.assertEquals((String)"Index should be unchanged by truncate at the end", (Object)new OffsetPosition(9L, 9), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"9 should be the last entry in the index", (long)9L, (long)idx.lastOffset());
        idx.append(10L, 10);
        idx.truncateTo(9L);
        Assert.assertEquals((String)"Index should truncate off last entry", (Object)new OffsetPosition(8L, 8), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"8 should be the last entry in the index", (long)8L, (long)idx.lastOffset());
        idx.append(9L, 9);
        idx.truncateTo(5L);
        Assert.assertEquals((String)"4 should be the last entry in the index", (Object)new OffsetPosition(4L, 4), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"4 should be the last entry in the index", (long)4L, (long)idx.lastOffset());
        idx.append(5L, 5);
        idx.truncate();
        Assert.assertEquals((String)"Full truncation should leave no entries", (int)0, (int)idx.entries());
        idx.append(0L, 0);
    }

    public <T> void assertWriteFails(String message, OffsetIndex idx, int offset, Class<T> klass) {
        try {
            idx.append((long)offset, 1);
            throw this.fail(message);
        }
        catch (Exception exception) {
            Assert.assertEquals((String)"Got an unexpected exception.", klass, exception.getClass());
            return;
        }
    }

    public Seq<Object> monotonicSeq(int base, int len) {
        Random rand = new Random(1L);
        ArrayBuffer vals = new ArrayBuffer(len);
        IntRef last = IntRef.create((int)base);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).foreach((Function1)new Serializable(this, rand, vals, last){
            public static final long serialVersionUID = 0L;
            private final Random rand$1;
            private final ArrayBuffer vals$1;
            private final IntRef last$1;

            public final ArrayBuffer<Object> apply(int i) {
                this.last$1.elem += this.rand$1.nextInt(15) + 1;
                return this.vals$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)this.last$1.elem));
            }
            {
                this.rand$1 = rand$1;
                this.vals$1 = vals$1;
                this.last$1 = last$1;
            }
        });
        return vals;
    }

    /*
     * WARNING - void declaration
     */
    public File nonExistantTempFile() {
        void var1_1;
        File file = TestUtils$.MODULE$.tempFile();
        file.delete();
        return var1_1;
    }

    public OffsetIndexTest() {
        this.maxEntries = 30;
    }
}

