/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.nio.ByteBuffer;
import java.util.Properties;
import junit.framework.Assert;
import kafka.admin.AdminUtils$;
import kafka.api.PartitionMetadata;
import kafka.api.TopicMetadata;
import kafka.api.TopicMetadataRequest;
import kafka.api.TopicMetadataRequest$;
import kafka.client.ClientUtils$;
import kafka.cluster.Broker;
import kafka.common.ErrorMapping$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.I0Itec.zkclient.ZkClient;
import org.scalatest.junit.JUnit3Suite;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U4A!\u0001\u0002\u0001\u000f\t\tBk\u001c9jG6+G/\u00193bi\u0006$Vm\u001d;\u000b\u0005\r!\u0011aC5oi\u0016<'/\u0019;j_:T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0005\t\u0003\u0013Ai\u0011A\u0003\u0006\u0003\u00171\tQA[;oSRT!!\u0004\b\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\b\u0002\u0007=\u0014x-\u0003\u0002\u0012\u0015\tY!*\u00168jiN\u001aV/\u001b;f!\t\u0019b#D\u0001\u0015\u0015\t)B!\u0001\u0002{W&\u0011q\u0003\u0006\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001b\u0002\u0010\u0001\u0005\u0004%\taH\u0001\u0006aJ|\u0007o]\u000b\u0002AA\u0019\u0011e\u000b\u0018\u000f\u0005\tBcBA\u0012'\u001b\u0005!#BA\u0013\u0007\u0003\u0019a$o\\8u}%\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*U\u00059\u0001/Y2lC\u001e,'\"A\u0014\n\u00051j#\u0001\u0002'jgRT!!\u000b\u0016\u0011\u0005=\"T\"\u0001\u0019\u000b\u0005E\u0012\u0014\u0001B;uS2T\u0011aM\u0001\u0005U\u00064\u0018-\u0003\u00026a\tQ\u0001K]8qKJ$\u0018.Z:\t\r]\u0002\u0001\u0015!\u0003!\u0003\u0019\u0001(o\u001c9tA!9\u0011\b\u0001b\u0001\n\u0003Q\u0014aB2p]\u001aLwm]\u000b\u0002wA\u0019A(\u0011\"\u000e\u0003uR!AP \u0002\u0013%lW.\u001e;bE2,'B\u0001!+\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003Yu\u0002\"a\u0011$\u000e\u0003\u0011S!!\u0012\u0003\u0002\rM,'O^3s\u0013\t9EIA\u0006LC\u001a\\\u0017mQ8oM&<\u0007BB%\u0001A\u0003%1(\u0001\u0005d_:4\u0017nZ:!\u0011\u001dY\u0005\u00011A\u0005\n1\u000bqa]3sm\u0016\u0014\u0018'F\u0001N!\t\u0019e*\u0003\u0002P\t\nY1*\u00194lCN+'O^3s\u0011\u001d\t\u0006\u00011A\u0005\nI\u000b1b]3sm\u0016\u0014\u0018g\u0018\u0013fcR\u00111k\u0016\t\u0003)Vk\u0011AK\u0005\u0003-*\u0012A!\u00168ji\"9\u0001\fUA\u0001\u0002\u0004i\u0015a\u0001=%c!1!\f\u0001Q!\n5\u000b\u0001b]3sm\u0016\u0014\u0018\u0007\t\u0005\b9\u0002\u0011\r\u0011\"\u0001^\u0003\u001d\u0011'o\\6feN,\u0012A\u0018\t\u0004y\u0005{\u0006C\u00011d\u001b\u0005\t'B\u00012\u0005\u0003\u001d\u0019G.^:uKJL!\u0001Z1\u0003\r\t\u0013xn[3s\u0011\u00191\u0007\u0001)A\u0005=\u0006A!M]8lKJ\u001c\b\u0005C\u0003i\u0001\u0011\u0005\u0013.A\u0003tKR,\u0006\u000fF\u0001T\u0011\u0015Y\u0007\u0001\"\u0011j\u0003!!X-\u0019:E_^t\u0007\"B7\u0001\t\u0003q\u0017\u0001\u0007;fgR$v\u000e]5d\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3tiV\t1\u000bC\u0003q\u0001\u0011\u0005a.\u0001\fuKN$()Y:jGR{\u0007/[2NKR\fG-\u0019;b\u0011\u0015\u0011\b\u0001\"\u0001o\u0003]!Xm\u001d;HKR\fE\u000e\u001c+pa&\u001cW*\u001a;bI\u0006$\u0018\rC\u0003u\u0001\u0011\u0005a.A\nuKN$\u0018)\u001e;p\u0007J,\u0017\r^3U_BL7\r")
public class TopicMetadataTest
extends JUnit3Suite
implements ZooKeeperTestHarness {
    private final List<Properties> props;
    private final List<KafkaConfig> configs;
    private KafkaServer server1;
    private final List<Broker> brokers;
    private final String zkConnect;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;

    @Override
    public String zkConnect() {
        return this.zkConnect;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public ZkClient zkClient() {
        return this.zkClient;
    }

    @Override
    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public /* synthetic */ void kafka$zk$ZooKeeperTestHarness$$super$setUp() {
        super.setUp();
    }

    @Override
    public /* synthetic */ void kafka$zk$ZooKeeperTestHarness$$super$tearDown() {
        super.tearDown();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    public List<Properties> props() {
        return this.props;
    }

    public List<KafkaConfig> configs() {
        return this.configs;
    }

    private KafkaServer server1() {
        return this.server1;
    }

    private void server1_$eq(KafkaServer x$1) {
        this.server1 = x$1;
    }

    public List<Broker> brokers() {
        return this.brokers;
    }

    @Override
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        this.server1_$eq(TestUtils$.MODULE$.createServer((KafkaConfig)this.configs().head(), TestUtils$.MODULE$.createServer$default$2()));
    }

    @Override
    public void tearDown() {
        this.server1().shutdown();
        ZooKeeperTestHarness$class.tearDown(this);
    }

    public void testTopicMetadataRequest() {
        String topic = "test";
        AdminUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, AdminUtils$.MODULE$.createTopic$default$5());
        TopicMetadataRequest topicMetadataRequest = new TopicMetadataRequest((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), 0);
        ByteBuffer serializedMetadataRequest = ByteBuffer.allocate(topicMetadataRequest.sizeInBytes() + 2);
        topicMetadataRequest.writeTo(serializedMetadataRequest);
        serializedMetadataRequest.rewind();
        TopicMetadataRequest deserializedMetadataRequest = TopicMetadataRequest$.MODULE$.readFrom(serializedMetadataRequest);
        Assert.assertEquals((Object)topicMetadataRequest, (Object)deserializedMetadataRequest);
    }

    public void testBasicTopicMetadata() {
        String topic = "test";
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1()}))), TestUtils$.MODULE$.createTopic$default$6());
        Seq topicsMetadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), this.brokers(), "TopicMetadataTest-testBasicTopicMetadata", 2000, 0).topicsMetadata();
        Assert.assertEquals((short)ErrorMapping$.MODULE$.NoError(), (short)((TopicMetadata)topicsMetadata.head()).errorCode());
        Assert.assertEquals((short)ErrorMapping$.MODULE$.NoError(), (short)((PartitionMetadata)((TopicMetadata)topicsMetadata.head()).partitionsMetadata().head()).errorCode());
        Assert.assertEquals((String)"Expecting metadata only for 1 topic", (int)1, (int)topicsMetadata.size());
        Assert.assertEquals((String)"Expecting metadata for the test topic", (String)"test", (String)((TopicMetadata)topicsMetadata.head()).topic());
        Seq partitionMetadata = ((TopicMetadata)topicsMetadata.head()).partitionsMetadata();
        Assert.assertEquals((String)"Expecting metadata for 1 partition", (int)1, (int)partitionMetadata.size());
        Assert.assertEquals((String)"Expecting partition id to be 0", (int)0, (int)((PartitionMetadata)partitionMetadata.head()).partitionId());
        Assert.assertEquals((int)1, (int)((PartitionMetadata)partitionMetadata.head()).replicas().size());
    }

    public void testGetAllTopicMetadata() {
        String topic1 = "testGetAllTopicMetadata1";
        String topic2 = "testGetAllTopicMetadata2";
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic1, 1, 1, (Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1()}))), TestUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic2, 1, 1, (Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1()}))), TestUtils$.MODULE$.createTopic$default$6());
        Seq topicsMetadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().empty(), this.brokers(), "TopicMetadataTest-testGetAllTopicMetadata", 2000, 0).topicsMetadata();
        Assert.assertEquals((short)ErrorMapping$.MODULE$.NoError(), (short)((TopicMetadata)topicsMetadata.head()).errorCode());
        Assert.assertEquals((int)2, (int)topicsMetadata.size());
        Assert.assertEquals((short)ErrorMapping$.MODULE$.NoError(), (short)((PartitionMetadata)((TopicMetadata)topicsMetadata.head()).partitionsMetadata().head()).errorCode());
        Assert.assertEquals((short)ErrorMapping$.MODULE$.NoError(), (short)((PartitionMetadata)((TopicMetadata)topicsMetadata.last()).partitionsMetadata().head()).errorCode());
        Seq partitionMetadataTopic1 = ((TopicMetadata)topicsMetadata.head()).partitionsMetadata();
        Seq partitionMetadataTopic2 = ((TopicMetadata)topicsMetadata.last()).partitionsMetadata();
        Assert.assertEquals((String)"Expecting metadata for 1 partition", (int)1, (int)partitionMetadataTopic1.size());
        Assert.assertEquals((String)"Expecting partition id to be 0", (int)0, (int)((PartitionMetadata)partitionMetadataTopic1.head()).partitionId());
        Assert.assertEquals((int)1, (int)((PartitionMetadata)partitionMetadataTopic1.head()).replicas().size());
        Assert.assertEquals((String)"Expecting metadata for 1 partition", (int)1, (int)partitionMetadataTopic2.size());
        Assert.assertEquals((String)"Expecting partition id to be 0", (int)0, (int)((PartitionMetadata)partitionMetadataTopic2.head()).partitionId());
        Assert.assertEquals((int)1, (int)((PartitionMetadata)partitionMetadataTopic2.head()).replicas().size());
    }

    public void testAutoCreateTopic() {
        String topic = "testAutoCreateTopic";
        Seq topicsMetadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), this.brokers(), "TopicMetadataTest-testAutoCreateTopic", 2000, 0).topicsMetadata();
        Assert.assertEquals((short)ErrorMapping$.MODULE$.LeaderNotAvailableCode(), (short)((TopicMetadata)topicsMetadata.head()).errorCode());
        Assert.assertEquals((String)"Expecting metadata only for 1 topic", (int)1, (int)topicsMetadata.size());
        Assert.assertEquals((String)"Expecting metadata for the test topic", (String)topic, (String)((TopicMetadata)topicsMetadata.head()).topic());
        Assert.assertEquals((int)0, (int)((TopicMetadata)topicsMetadata.head()).partitionsMetadata().size());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topic, 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1()}))), topic, 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        topicsMetadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), this.brokers(), "TopicMetadataTest-testBasicTopicMetadata", 2000, 0).topicsMetadata();
        Assert.assertEquals((short)ErrorMapping$.MODULE$.NoError(), (short)((TopicMetadata)topicsMetadata.head()).errorCode());
        Assert.assertEquals((short)ErrorMapping$.MODULE$.NoError(), (short)((PartitionMetadata)((TopicMetadata)topicsMetadata.head()).partitionsMetadata().head()).errorCode());
        Seq partitionMetadata = ((TopicMetadata)topicsMetadata.head()).partitionsMetadata();
        Assert.assertEquals((String)"Expecting metadata for 1 partition", (int)1, (int)partitionMetadata.size());
        Assert.assertEquals((String)"Expecting partition id to be 0", (int)0, (int)((PartitionMetadata)partitionMetadata.head()).partitionId());
        Assert.assertEquals((int)1, (int)((PartitionMetadata)partitionMetadata.head()).replicas().size());
        Assert.assertTrue((boolean)((PartitionMetadata)partitionMetadata.head()).leader().isDefined());
    }

    public TopicMetadataTest() {
        ZooKeeperTestHarness$class.$init$(this);
        this.props = TestUtils$.MODULE$.createBrokerConfigs(1, TestUtils$.MODULE$.createBrokerConfigs$default$2());
        this.configs = (List)this.props().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties p) {
                return new KafkaConfig(p);
            }
        }, List$.MODULE$.canBuildFrom());
        this.server1 = null;
        this.brokers = (List)this.configs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Broker apply(KafkaConfig c) {
                return new Broker(c.brokerId(), c.hostName(), c.port());
            }
        }, List$.MODULE$.canBuildFrom());
    }
}

