/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.nio.ByteBuffer;
import java.util.Properties;
import junit.framework.Assert;
import kafka.admin.AdminUtils$;
import kafka.api.FetchRequest;
import kafka.api.FetchRequest$;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.api.FetchResponsePartitionData;
import kafka.cluster.Replica;
import kafka.common.ErrorMapping$;
import kafka.common.OffsetOutOfRangeException;
import kafka.common.TopicAndPartition;
import kafka.common.UnknownTopicOrPartitionException;
import kafka.consumer.SimpleConsumer;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.integration.ProducerConsumerTestHarness;
import kafka.integration.ProducerConsumerTestHarness$class;
import kafka.log.Log;
import kafka.message.ByteBufferMessageSet;
import kafka.message.MessageAndOffset;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.serializer.StringEncoder;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRequestHandler;
import kafka.server.KafkaServer;
import kafka.server.ReplicaManager;
import kafka.utils.StaticPartitioner;
import kafka.utils.TestUtils$;
import kafka.utils.Utils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.scalatest.junit.JUnit3Suite;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0003\u0015:j[&$\u0018N^3Ba&$Vm\u001d;\u000b\u0005\r!\u0011aC5oi\u0016<'/\u0019;j_:T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001B\u0005\f\u0011\u0005%\u0001R\"\u0001\u0006\u000b\u0005-a\u0011!\u00026v]&$(BA\u0007\u000f\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001\u0010\u0003\ry'oZ\u0005\u0003#)\u00111BS+oSR\u001c4+^5uKB\u00111\u0003F\u0007\u0002\u0005%\u0011QC\u0001\u0002\u001c!J|G-^2fe\u000e{gn];nKJ$Vm\u001d;ICJtWm]:\u0011\u0005]QR\"\u0001\r\u000b\u0005e!\u0011A\u0001>l\u0013\tY\u0002D\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o\u001d\u0005\u0006;\u0001!\tAH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0001\"a\u0005\u0001\t\u000f\u0005\u0002!\u0019!C\u0001E\u0005!\"/Z9vKN$\b*\u00198eY\u0016\u0014Hj\\4hKJ,\u0012a\t\t\u0003I%j\u0011!\n\u0006\u0003M\u001d\nQ\u0001\\8hi)T!\u0001\u000b\b\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tQSE\u0001\u0004M_\u001e<WM\u001d\u0005\u0007Y\u0001\u0001\u000b\u0011B\u0012\u0002+I,\u0017/^3ti\"\u000bg\u000e\u001a7fe2{wmZ3sA!9a\u0006\u0001b\u0001\n\u0003y\u0013\u0001\u00029peR,\u0012\u0001\r\t\u0003cQj\u0011A\r\u0006\u0002g\u0005)1oY1mC&\u0011QG\r\u0002\u0004\u0013:$\bBB\u001c\u0001A\u0003%\u0001'A\u0003q_J$\b\u0005C\u0004:\u0001\t\u0007I\u0011\u0001\u001e\u0002\u000bA\u0014x\u000e]:\u0016\u0003m\u0002\"\u0001P!\u000e\u0003uR!AP \u0002\tU$\u0018\u000e\u001c\u0006\u0002\u0001\u0006!!.\u0019<b\u0013\t\u0011UH\u0001\u0006Qe>\u0004XM\u001d;jKNDa\u0001\u0012\u0001!\u0002\u0013Y\u0014A\u00029s_B\u001c\b\u0005C\u0004G\u0001\t\u0007I\u0011A$\u0002\r\r|gNZ5h+\u0005A\u0005CA%M\u001b\u0005Q%BA&\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011QJ\u0013\u0002\f\u0017\u000647.Y\"p]\u001aLw\r\u0003\u0004P\u0001\u0001\u0006I\u0001S\u0001\bG>tg-[4!\u0011\u001d\t\u0006A1A\u0005\u0002I\u000bqaY8oM&<7/F\u0001T!\r!\u0016\fS\u0007\u0002+*\u0011akV\u0001\nS6lW\u000f^1cY\u0016T!\u0001\u0017\u001a\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002[+\n!A*[:u\u0011\u0019a\u0006\u0001)A\u0005'\u0006A1m\u001c8gS\u001e\u001c\b\u0005C\u0003_\u0001\u0011\u0005q,\u0001\u0013uKN$h)\u001a;dQJ+\u0017/^3ti\u000e\u000bg\u000e\u0015:pa\u0016\u0014H._*fe&\fG.\u001b>f)\u0005\u0001\u0007CA\u0019b\u0013\t\u0011'G\u0001\u0003V]&$\b\"\u00023\u0001\t\u0003y\u0016!\u0006;fgR,U\u000e\u001d;z\r\u0016$8\r\u001b*fcV,7\u000f\u001e\u0005\u0006M\u0002!\taX\u0001#i\u0016\u001cH\u000fR3gCVdG/\u00128d_\u0012,'\u000f\u0015:pIV\u001cWM]!oI\u001a+Go\u00195\t\u000b!\u0004A\u0011A0\u0002cQ,7\u000f\u001e#fM\u0006,H\u000e^#oG>$WM\u001d)s_\u0012,8-\u001a:B]\u00124U\r^2i/&$\bnQ8naJ,7o]5p]\")!\u000e\u0001C\u0005W\u0006!\u0002O]8ek\u000e,\u0017I\u001c3Nk2$\u0018NR3uG\"$\"\u0001\u00197\t\u000b5L\u0007\u0019\u00018\u0002\u0011A\u0014x\u000eZ;dKJ\u0004Ba\\9tg6\t\u0001O\u0003\u0002n\t%\u0011!\u000f\u001d\u0002\t!J|G-^2feB\u0011Ao\u001e\b\u0003cUL!A\u001e\u001a\u0002\rA\u0013X\rZ3g\u0013\tA\u0018P\u0001\u0004TiJLgn\u001a\u0006\u0003mJBQa\u001f\u0001\u0005\u0002}\u000b\u0001\u0004^3tiB\u0013x\u000eZ;dK\u0006sG-T;mi&4U\r^2i\u0011\u0015i\b\u0001\"\u0003\u007f\u00031iW\u000f\u001c;j!J|G-^2f)\t\u0001w\u0010C\u0003ny\u0002\u0007a\u000e\u0003\u0004\u0002\u0004\u0001!\taX\u0001\u0011i\u0016\u001cH/T;mi&\u0004&o\u001c3vG\u0016Da!a\u0002\u0001\t\u0003y\u0016A\u0006;fgR\u001cuN\\:v[\u0016\u0014X)\u001c9usR{\u0007/[2\t\r\u0005-\u0001\u0001\"\u0001`\u0003q!Xm\u001d;QSB,G.\u001b8fIB\u0013x\u000eZ;dKJ+\u0017/^3tiNDq!a\u0004\u0001\t\u0013\t\t\"\u0001\u0011de\u0016\fG/Z*j[BdW\rV8qS\u000e\u001c\u0018I\u001c3Bo\u0006LG\u000fT3bI\u0016\u0014H#\u00021\u0002\u0014\u0005\u001d\u0002\u0002CA\u000b\u0003\u001b\u0001\r!a\u0006\u0002\u0011i\\7\t\\5f]R\u0004B!!\u0007\u0002$5\u0011\u00111\u0004\u0006\u0005\u0003;\ty\"\u0001\u0005{W\u000ed\u0017.\u001a8u\u0015\r\t\tCD\u0001\u0007\u0013BJE/Z2\n\t\u0005\u0015\u00121\u0004\u0002\t5.\u001cE.[3oi\"A\u0011\u0011FA\u0007\u0001\u0004\tY#\u0001\u0004u_BL7m\u001d\t\u0006\u0003[\tyc]\u0007\u0002/&\u0019\u0011\u0011G,\u0003\u0011%#XM]1cY\u0016\u0004")
public class PrimitiveApiTest
extends JUnit3Suite
implements ProducerConsumerTestHarness {
    private final Logger requestHandlerLogger;
    private final int port;
    private final Properties props;
    private final KafkaConfig config;
    private final List<KafkaConfig> configs;
    private final String host;
    private Producer<String, String> producer;
    private SimpleConsumer consumer;
    private List<KafkaServer> servers;
    private String brokerList;
    private final String zkConnect;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public Producer<String, String> producer() {
        return this.producer;
    }

    @Override
    public void producer_$eq(Producer<String, String> x$1) {
        this.producer = x$1;
    }

    @Override
    public SimpleConsumer consumer() {
        return this.consumer;
    }

    @Override
    public void consumer_$eq(SimpleConsumer x$1) {
        this.consumer = x$1;
    }

    @Override
    public /* synthetic */ void kafka$integration$ProducerConsumerTestHarness$$super$setUp() {
        KafkaServerTestHarness$class.setUp(this);
    }

    @Override
    public /* synthetic */ void kafka$integration$ProducerConsumerTestHarness$$super$tearDown() {
        KafkaServerTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$integration$ProducerConsumerTestHarness$_setter_$host_$eq(String x$1) {
        this.host = x$1;
    }

    @Override
    public void setUp() {
        ProducerConsumerTestHarness$class.setUp(this);
    }

    @Override
    public void tearDown() {
        ProducerConsumerTestHarness$class.tearDown(this);
    }

    @Override
    public List<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    @TraitSetter
    public void servers_$eq(List<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public String brokerList() {
        return this.brokerList;
    }

    @Override
    @TraitSetter
    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    @Override
    public /* synthetic */ void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public /* synthetic */ void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public String zkConnect() {
        return this.zkConnect;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public ZkClient zkClient() {
        return this.zkClient;
    }

    @Override
    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public /* synthetic */ void kafka$zk$ZooKeeperTestHarness$$super$setUp() {
        super.setUp();
    }

    @Override
    public /* synthetic */ void kafka$zk$ZooKeeperTestHarness$$super$tearDown() {
        super.tearDown();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    public Logger requestHandlerLogger() {
        return this.requestHandlerLogger;
    }

    @Override
    public int port() {
        return this.port;
    }

    public Properties props() {
        return this.props;
    }

    public KafkaConfig config() {
        return this.config;
    }

    @Override
    public List<KafkaConfig> configs() {
        return this.configs;
    }

    public void testFetchRequestCanProperlySerialize() {
        FetchRequest request = new FetchRequestBuilder().clientId("test-client").maxWait(10001).minBytes(4444).addFetch("topic1", 0, 0L, 10000).addFetch("topic2", 1, 1024L, 9999).addFetch("topic1", 1, 256L, 444).build();
        ByteBuffer serializedBuffer = ByteBuffer.allocate(request.sizeInBytes());
        request.writeTo(serializedBuffer);
        serializedBuffer.rewind();
        FetchRequest deserializedRequest = FetchRequest$.MODULE$.readFrom(serializedBuffer);
        Assert.assertEquals((Object)request, (Object)deserializedRequest);
    }

    public void testEmptyFetchRequest() {
        scala.collection.immutable.Map partitionRequests;
        scala.collection.immutable.Map x$12 = partitionRequests = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        short x$13 = FetchRequest$.MODULE$.$lessinit$greater$default$1();
        int x$14 = FetchRequest$.MODULE$.$lessinit$greater$default$2();
        String x$15 = FetchRequest$.MODULE$.$lessinit$greater$default$3();
        int x$16 = FetchRequest$.MODULE$.$lessinit$greater$default$4();
        int x$17 = FetchRequest$.MODULE$.$lessinit$greater$default$5();
        int x$18 = FetchRequest$.MODULE$.$lessinit$greater$default$6();
        FetchRequest request = new FetchRequest(x$13, x$14, x$15, x$16, x$17, x$18, x$12);
        FetchResponse fetched = this.consumer().fetch(request);
        Assert.assertTrue((!fetched.hasError() && fetched.data().size() == 0 ? 1 : 0) != 0);
    }

    public void testDefaultEncoderProducerAndFetch() {
        String topic = "test-topic";
        this.producer().send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)"test-message")}));
        ReplicaManager qual$1 = ((KafkaServer)this.servers().head()).replicaManager();
        String x$19 = topic;
        int x$20 = 0;
        int x$21 = qual$1.getReplica$default$3();
        Replica replica = (Replica)qual$1.getReplica(x$19, x$20, x$21).get();
        Assert.assertTrue((String)"HighWatermark should equal logEndOffset with just 1 replica", (replica.logEndOffset().messageOffset() > 0L && replica.logEndOffset().equals((Object)replica.highWatermark()) ? 1 : 0) != 0);
        FetchRequest request = new FetchRequestBuilder().clientId("test-client").addFetch(topic, 0, 0L, 10000).build();
        FetchResponse fetched = this.consumer().fetch(request);
        Assert.assertEquals((String)"Returned correlationId doesn't match that in request.", (int)0, (int)fetched.correlationId());
        ByteBufferMessageSet messageSet = fetched.messageSet(topic, 0);
        Assert.assertTrue((boolean)messageSet.iterator().hasNext());
        MessageAndOffset fetchedMessageAndOffset = (MessageAndOffset)messageSet.head();
        Assert.assertEquals((String)"test-message", (String)Utils$.MODULE$.readString(fetchedMessageAndOffset.message().payload(), "UTF-8"));
    }

    public void testDefaultEncoderProducerAndFetchWithCompression() {
        String topic = "test-topic";
        Properties props = new Properties();
        props.put("compression.codec", "gzip");
        Producer stringProducer1 = TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromConfigs((Seq<KafkaConfig>)this.configs()), StringEncoder.class.getName(), StringEncoder.class.getName(), StaticPartitioner.class.getName(), props);
        stringProducer1.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)"test-message")}));
        FetchResponse fetched = this.consumer().fetch(new FetchRequestBuilder().addFetch(topic, 0, 0L, 10000).build());
        ByteBufferMessageSet messageSet = fetched.messageSet(topic, 0);
        Assert.assertTrue((boolean)messageSet.iterator().hasNext());
        MessageAndOffset fetchedMessageAndOffset = (MessageAndOffset)messageSet.head();
        Assert.assertEquals((String)"test-message", (String)Utils$.MODULE$.readString(fetchedMessageAndOffset.message().payload(), "UTF-8"));
    }

    private void produceAndMultiFetch(Producer<String, String> producer) {
        this.createSimpleTopicsAndAwaitLeader(this.zkClient(), (Iterable<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2", "test3", "test4"})));
        List topics = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"test4", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"test1", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"test2", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"test3", (Object)BoxesRunTime.boxToInteger((int)0))}));
        HashMap messages2 = new HashMap();
        FetchRequestBuilder builder = new FetchRequestBuilder();
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$1) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, producer, messages2, builder){
            public static final long serialVersionUID = 0L;
            private final Producer producer$1;
            private final HashMap messages$1;
            private final FetchRequestBuilder builder$1;

            public final FetchRequestBuilder apply(Tuple2<String, Object> x$2) {
                Tuple2<String, Object> tuple2 = x$2;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int partition = tuple2._2$mcI$sp();
                    List messageList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)"a_").append((Object)topic).toString(), new StringBuilder().append((Object)"b_").append((Object)topic).toString()}));
                    List producerData = (List)messageList.map((Function1)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$1;

                        public final KeyedMessage<String, String> apply(String x$1) {
                            return new KeyedMessage(this.topic$1, (Object)this.topic$1, (Object)x$1);
                        }
                        {
                            this.topic$1 = topic$1;
                        }
                    }, List$.MODULE$.canBuildFrom());
                    this.messages$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)messageList));
                    this.producer$1.send((Seq)producerData);
                    FetchRequestBuilder fetchRequestBuilder = this.builder$1.addFetch(topic, partition, 0L, 10000);
                    return fetchRequestBuilder;
                }
                throw new MatchError(tuple2);
            }
            {
                this.producer$1 = producer$1;
                this.messages$1 = messages$1;
                this.builder$1 = builder$1;
            }
        });
        FetchRequest request = builder.build();
        FetchResponse response = this.consumer().fetch(request);
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$2) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, messages2, response){
            public static final long serialVersionUID = 0L;
            private final HashMap messages$1;
            private final FetchResponse response$1;

            public final void apply(Tuple2<String, Object> x$3) {
                Tuple2<String, Object> tuple2 = x$3;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int partition = tuple2._2$mcI$sp();
                    ByteBufferMessageSet fetched = this.response$1.messageSet(topic, partition);
                    Assert.assertEquals((Object)this.messages$1.apply((Object)topic), (Object)fetched.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(MessageAndOffset messageAndOffset) {
                            return Utils$.MODULE$.readString(messageAndOffset.message().payload(), Utils$.MODULE$.readString$default$2());
                        }
                    }, Iterable$.MODULE$.canBuildFrom()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.messages$1 = messages$1;
                this.response$1 = response$1;
            }
        });
        this.requestHandlerLogger().setLevel(Level.FATAL);
        FetchRequestBuilder builder2 = new FetchRequestBuilder();
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$3) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$3;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, builder2){
            public static final long serialVersionUID = 0L;
            private final FetchRequestBuilder builder$2;

            public final FetchRequestBuilder apply(Tuple2<String, Object> x$4) {
                Tuple2<String, Object> tuple2 = x$4;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int partition = tuple2._2$mcI$sp();
                    FetchRequestBuilder fetchRequestBuilder = this.builder$2.addFetch(topic, partition, -1L, 10000);
                    return fetchRequestBuilder;
                }
                throw new MatchError(tuple2);
            }
            {
                this.builder$2 = builder$2;
            }
        });
        try {
            FetchRequest request2 = builder2.build();
            FetchResponse response2 = this.consumer().fetch(request2);
            response2.data().values().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(FetchResponsePartitionData pdata) {
                    ErrorMapping$.MODULE$.maybeThrowException(pdata.error());
                }
            });
            throw this.fail("Expected exception when fetching message with invalid offset");
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {
            FetchRequestBuilder builder3 = new FetchRequestBuilder();
            topics.withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, Object> check$ifrefutable$4) {
                    Tuple2<String, Object> tuple2 = check$ifrefutable$4;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this, builder3){
                public static final long serialVersionUID = 0L;
                private final FetchRequestBuilder builder$3;

                public final FetchRequestBuilder apply(Tuple2<String, Object> x$5) {
                    Tuple2<String, Object> tuple2 = x$5;
                    if (tuple2 != null) {
                        String topic = (String)tuple2._1();
                        FetchRequestBuilder fetchRequestBuilder = this.builder$3.addFetch(topic, -1, 0L, 10000);
                        return fetchRequestBuilder;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.builder$3 = builder$3;
                }
            });
            try {
                FetchRequest request3 = builder3.build();
                FetchResponse response3 = this.consumer().fetch(request3);
                response3.data().values().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(FetchResponsePartitionData pdata) {
                        ErrorMapping$.MODULE$.maybeThrowException(pdata.error());
                    }
                });
                throw this.fail("Expected exception when fetching message with invalid partition");
            }
            catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
                this.requestHandlerLogger().setLevel(Level.ERROR);
                return;
            }
        }
    }

    public void testProduceAndMultiFetch() {
        this.produceAndMultiFetch(this.producer());
    }

    private void multiProduce(Producer<String, String> producer) {
        Map topics = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test4"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test1"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test2"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test3"), (Object)BoxesRunTime.boxToInteger((int)0))}));
        this.createSimpleTopicsAndAwaitLeader(this.zkClient(), (Iterable<String>)topics.keys());
        HashMap messages2 = new HashMap();
        FetchRequestBuilder builder = new FetchRequestBuilder();
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$5) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$5;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, producer, messages2, builder){
            public static final long serialVersionUID = 0L;
            private final Producer producer$2;
            private final HashMap messages$2;
            private final FetchRequestBuilder builder$4;

            public final FetchRequestBuilder apply(Tuple2<String, Object> x$7) {
                Tuple2<String, Object> tuple2 = x$7;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int partition = tuple2._2$mcI$sp();
                    List messageList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)"a_").append((Object)topic).toString(), new StringBuilder().append((Object)"b_").append((Object)topic).toString()}));
                    List producerData = (List)messageList.map((Function1)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$2;

                        public final KeyedMessage<String, String> apply(String x$6) {
                            return new KeyedMessage(this.topic$2, (Object)this.topic$2, (Object)x$6);
                        }
                        {
                            this.topic$2 = topic$2;
                        }
                    }, List$.MODULE$.canBuildFrom());
                    this.messages$2.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)messageList));
                    this.producer$2.send((Seq)producerData);
                    FetchRequestBuilder fetchRequestBuilder = this.builder$4.addFetch(topic, partition, 0L, 10000);
                    return fetchRequestBuilder;
                }
                throw new MatchError(tuple2);
            }
            {
                this.producer$2 = producer$2;
                this.messages$2 = messages$2;
                this.builder$4 = builder$4;
            }
        });
        FetchRequest request = builder.build();
        FetchResponse response = this.consumer().fetch(request);
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$6) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$6;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, messages2, response){
            public static final long serialVersionUID = 0L;
            private final HashMap messages$2;
            private final FetchResponse response$2;

            public final void apply(Tuple2<String, Object> x$8) {
                Tuple2<String, Object> tuple2 = x$8;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int partition = tuple2._2$mcI$sp();
                    ByteBufferMessageSet fetched = this.response$2.messageSet(topic, partition);
                    Assert.assertEquals((Object)this.messages$2.apply((Object)topic), (Object)fetched.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(MessageAndOffset messageAndOffset) {
                            return Utils$.MODULE$.readString(messageAndOffset.message().payload(), Utils$.MODULE$.readString$default$2());
                        }
                    }, Iterable$.MODULE$.canBuildFrom()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.messages$2 = messages$2;
                this.response$2 = response$2;
            }
        });
    }

    public void testMultiProduce() {
        this.multiProduce(this.producer());
    }

    public void testConsumerEmptyTopic() {
        String newTopic = "new-topic";
        TestUtils$.MODULE$.createTopic(this.zkClient(), newTopic, 1, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        FetchResponse fetchResponse = this.consumer().fetch(new FetchRequestBuilder().addFetch(newTopic, 0, 0L, 10000).build());
        Assert.assertFalse((boolean)fetchResponse.messageSet(newTopic, 0).iterator().hasNext());
    }

    public void testPipelinedProduceRequests() {
        Map topics = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test4"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test1"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test2"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test3"), (Object)BoxesRunTime.boxToInteger((int)0))}));
        this.createSimpleTopicsAndAwaitLeader(this.zkClient(), (Iterable<String>)topics.keys());
        Properties props = new Properties();
        props.put("request.required.acks", "0");
        Producer pipelinedProducer = TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromConfigs((Seq<KafkaConfig>)this.configs()), StringEncoder.class.getName(), StringEncoder.class.getName(), StaticPartitioner.class.getName(), props);
        HashMap messages2 = new HashMap();
        FetchRequestBuilder builder = new FetchRequestBuilder();
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$7) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$7;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, pipelinedProducer, messages2, builder){
            public static final long serialVersionUID = 0L;
            private final Producer pipelinedProducer$1;
            private final HashMap messages$3;
            private final FetchRequestBuilder builder$5;

            public final FetchRequestBuilder apply(Tuple2<String, Object> x$10) {
                Tuple2<String, Object> tuple2 = x$10;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int partition = tuple2._2$mcI$sp();
                    List messageList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)"a_").append((Object)topic).toString(), new StringBuilder().append((Object)"b_").append((Object)topic).toString()}));
                    List producerData = (List)messageList.map((Function1)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$3;

                        public final KeyedMessage<String, String> apply(String x$9) {
                            return new KeyedMessage(this.topic$3, (Object)this.topic$3, (Object)x$9);
                        }
                        {
                            this.topic$3 = topic$3;
                        }
                    }, List$.MODULE$.canBuildFrom());
                    this.messages$3.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)messageList));
                    this.pipelinedProducer$1.send((Seq)producerData);
                    FetchRequestBuilder fetchRequestBuilder = this.builder$5.addFetch(topic, partition, 0L, 10000);
                    return fetchRequestBuilder;
                }
                throw new MatchError(tuple2);
            }
            {
                this.pipelinedProducer$1 = pipelinedProducer$1;
                this.messages$3 = messages$3;
                this.builder$5 = builder$5;
            }
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Log)((KafkaServer)this.$outer.servers().head()).logManager().getLog(new TopicAndPartition("test1", 0)).get()).logEndOffset() == 2L;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "Published messages should be in the log", TestUtils$.MODULE$.waitUntilTrue$default$3());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Log)((KafkaServer)this.$outer.servers().head()).logManager().getLog(new TopicAndPartition("test2", 0)).get()).logEndOffset() == 2L;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "Published messages should be in the log", TestUtils$.MODULE$.waitUntilTrue$default$3());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Log)((KafkaServer)this.$outer.servers().head()).logManager().getLog(new TopicAndPartition("test3", 0)).get()).logEndOffset() == 2L;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "Published messages should be in the log", TestUtils$.MODULE$.waitUntilTrue$default$3());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Log)((KafkaServer)this.$outer.servers().head()).logManager().getLog(new TopicAndPartition("test4", 0)).get()).logEndOffset() == 2L;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "Published messages should be in the log", TestUtils$.MODULE$.waitUntilTrue$default$3());
        int replicaId = ((KafkaServer)this.servers().head()).config().brokerId();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, replicaId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;
            private final int replicaId$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Replica)((KafkaServer)this.$outer.servers().head()).replicaManager().getReplica("test1", 0, this.replicaId$1).get()).highWatermark().messageOffset() == 2L;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.replicaId$1 = replicaId$1;
            }
        }, "High watermark should equal to log end offset", TestUtils$.MODULE$.waitUntilTrue$default$3());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, replicaId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;
            private final int replicaId$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Replica)((KafkaServer)this.$outer.servers().head()).replicaManager().getReplica("test2", 0, this.replicaId$1).get()).highWatermark().messageOffset() == 2L;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.replicaId$1 = replicaId$1;
            }
        }, "High watermark should equal to log end offset", TestUtils$.MODULE$.waitUntilTrue$default$3());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, replicaId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;
            private final int replicaId$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Replica)((KafkaServer)this.$outer.servers().head()).replicaManager().getReplica("test3", 0, this.replicaId$1).get()).highWatermark().messageOffset() == 2L;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.replicaId$1 = replicaId$1;
            }
        }, "High watermark should equal to log end offset", TestUtils$.MODULE$.waitUntilTrue$default$3());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, replicaId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrimitiveApiTest $outer;
            private final int replicaId$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Replica)((KafkaServer)this.$outer.servers().head()).replicaManager().getReplica("test4", 0, this.replicaId$1).get()).highWatermark().messageOffset() == 2L;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.replicaId$1 = replicaId$1;
            }
        }, "High watermark should equal to log end offset", TestUtils$.MODULE$.waitUntilTrue$default$3());
        FetchRequest request = builder.build();
        FetchResponse response = this.consumer().fetch(request);
        topics.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> check$ifrefutable$8) {
                Tuple2<String, Object> tuple2 = check$ifrefutable$8;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, messages2, response){
            public static final long serialVersionUID = 0L;
            private final HashMap messages$3;
            private final FetchResponse response$3;

            public final void apply(Tuple2<String, Object> x$11) {
                Tuple2<String, Object> tuple2 = x$11;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    int partition = tuple2._2$mcI$sp();
                    ByteBufferMessageSet fetched = this.response$3.messageSet(topic, partition);
                    Assert.assertEquals((Object)this.messages$3.apply((Object)topic), (Object)fetched.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(MessageAndOffset messageAndOffset) {
                            return Utils$.MODULE$.readString(messageAndOffset.message().payload(), Utils$.MODULE$.readString$default$2());
                        }
                    }, Iterable$.MODULE$.canBuildFrom()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.messages$3 = messages$3;
                this.response$3 = response$3;
            }
        });
    }

    private void createSimpleTopicsAndAwaitLeader(ZkClient zkClient, Iterable<String> topics) {
        topics.foreach((Function1)new Serializable(this, zkClient){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$1;

            public final Option<Object> apply(String topic) {
                AdminUtils$.MODULE$.createTopic(this.zkClient$1, topic, 1, 1, AdminUtils$.MODULE$.createTopic$default$5());
                return TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient$1, topic, 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
            }
            {
                this.zkClient$1 = zkClient$1;
            }
        });
    }

    public PrimitiveApiTest() {
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
        ProducerConsumerTestHarness$class.$init$(this);
        this.requestHandlerLogger = Logger.getLogger(KafkaRequestHandler.class);
        this.port = TestUtils$.MODULE$.choosePort();
        this.props = TestUtils$.MODULE$.createBrokerConfig(0, this.port(), TestUtils$.MODULE$.createBrokerConfig$default$3());
        this.config = new KafkaConfig(this.props());
        this.configs = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{this.config()}));
    }
}

