/*
 * Decompiled with CFR 0.152.
 */
package kafka.api.test;

import java.util.Properties;
import java.util.concurrent.Future;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.consumer.SimpleConsumer;
import kafka.integration.KafkaServerTestHarness;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.utils.TestZKUtils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.I0Itec.zkclient.ZkClient;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnit3Suite;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001B\u0001\u0003\u0001%\u0011\u0001\u0003\u0015:pIV\u001cWM]*f]\u0012$Vm\u001d;\u000b\u0005\r!\u0011\u0001\u0002;fgRT!!\u0002\u0004\u0002\u0007\u0005\u0004\u0018NC\u0001\b\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0006\u0015!\tY!#D\u0001\r\u0015\tia\"A\u0003kk:LGO\u0003\u0002\u0010!\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002#\u0005\u0019qN]4\n\u0005Ma!a\u0003&V]&$8gU;ji\u0016\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0004\u0002\u0017%tG/Z4sCRLwN\\\u0005\u00033Y\u0011acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o\u001d\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003\tAq\u0001\t\u0001C\u0002\u0013\u0005\u0011%\u0001\u0006ok6\u001cVM\u001d<feN,\u0012A\t\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0004\u0013:$\bBB\u0015\u0001A\u0003%!%A\u0006ok6\u001cVM\u001d<feN\u0004\u0003bB\u0016\u0001\u0005\u0004%\t\u0001L\u0001\bG>tg-[4t+\u0005i\u0003c\u0001\u00184k5\tqF\u0003\u00021c\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003e\u0011\n!bY8mY\u0016\u001cG/[8o\u0013\t!tF\u0001\u0003MSN$\bC\u0001\u001c:\u001b\u00059$B\u0001\u001d\u0007\u0003\u0019\u0019XM\u001d<fe&\u0011!h\u000e\u0002\f\u0017\u000647.Y\"p]\u001aLw\r\u0003\u0004=\u0001\u0001\u0006I!L\u0001\tG>tg-[4tA!9a\b\u0001a\u0001\n\u0013y\u0014!C2p]N,X.\u001a:2+\u0005\u0001\u0005CA!E\u001b\u0005\u0011%BA\"\u0007\u0003!\u0019wN\\:v[\u0016\u0014\u0018BA#C\u00059\u0019\u0016.\u001c9mK\u000e{gn];nKJDqa\u0012\u0001A\u0002\u0013%\u0001*A\u0007d_:\u001cX/\\3sc}#S-\u001d\u000b\u0003\u00132\u0003\"a\t&\n\u0005-##\u0001B+oSRDq!\u0014$\u0002\u0002\u0003\u0007\u0001)A\u0002yIEBaa\u0014\u0001!B\u0013\u0001\u0015AC2p]N,X.\u001a:2A!9\u0011\u000b\u0001a\u0001\n\u0013y\u0014!C2p]N,X.\u001a:3\u0011\u001d\u0019\u0006\u00011A\u0005\nQ\u000bQbY8ogVlWM\u001d\u001a`I\u0015\fHCA%V\u0011\u001di%+!AA\u0002\u0001Caa\u0016\u0001!B\u0013\u0001\u0015AC2p]N,X.\u001a:3A!9\u0011\f\u0001b\u0001\n\u0013Q\u0016!\u0002;pa&\u001cW#A.\u0011\u0005q\u000bW\"A/\u000b\u0005y{\u0016\u0001\u00027b]\u001eT\u0011\u0001Y\u0001\u0005U\u00064\u0018-\u0003\u0002c;\n11\u000b\u001e:j]\u001eDa\u0001\u001a\u0001!\u0002\u0013Y\u0016A\u0002;pa&\u001c\u0007\u0005C\u0004g\u0001\t\u0007I\u0011B\u0011\u0002\u00159,XNU3d_J$7\u000f\u0003\u0004i\u0001\u0001\u0006IAI\u0001\f]Vl'+Z2pe\u0012\u001c\b\u0005C\u0003k\u0001\u0011\u00053.A\u0003tKR,\u0006\u000fF\u0001J\u0011\u0015i\u0007\u0001\"\u0011l\u0003!!X-\u0019:E_^tg\u0001B8\u0001\u0001A\u0014!c\u00115fG.,%O]8s\u0007\u0006dGNY1dWN\u0019a.\u001d;\u0011\u0005q\u0013\u0018BA:^\u0005\u0019y%M[3diB\u0011Q/`\u0007\u0002m*\u0011q\u000f_\u0001\taJ|G-^2fe*\u0011\u0011P_\u0001\bG2LWM\u001c;t\u0015\t91P\u0003\u0002}!\u00051\u0011\r]1dQ\u0016L!A <\u0003\u0011\r\u000bG\u000e\u001c2bG.Daa\u00078\u0005\u0002\u0005\u0005ACAA\u0002!\r\t)A\\\u0007\u0002\u0001!9\u0011\u0011\u00028\u0005\u0002\u0005-\u0011\u0001D8o\u0007>l\u0007\u000f\\3uS>tG#B%\u0002\u000e\u0005]\u0001\u0002CA\b\u0003\u000f\u0001\r!!\u0005\u0002\u00115,G/\u00193bi\u0006\u00042!^A\n\u0013\r\t)B\u001e\u0002\u000f%\u0016\u001cwN\u001d3NKR\fG-\u0019;b\u0011!\tI\"a\u0002A\u0002\u0005m\u0011!C3yG\u0016\u0004H/[8o!\u0011\ti\"!\f\u000f\t\u0005}\u0011\u0011\u0006\b\u0005\u0003C\t9#\u0004\u0002\u0002$)\u0019\u0011Q\u0005\u0005\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0013bAA\u0016I\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0018\u0003c\u0011\u0011\"\u0012=dKB$\u0018n\u001c8\u000b\u0007\u0005-B\u0005\u0003\u0004\u00026\u0001!\ta[\u0001\u000fi\u0016\u001cHoU3oI>3gm]3uQ\u0011\t\u0019$!\u000f\u0011\t\u0005m\u0012qH\u0007\u0003\u0003{Q!!\u0004\t\n\t\u0005\u0005\u0013Q\b\u0002\u0005)\u0016\u001cH\u000f\u0003\u0004\u0002F\u0001!\ta[\u0001\u000fi\u0016\u001cHoU3sS\u0006d\u0017N_3sQ\u0011\t\u0019%!\u000f\t\u000f\u0005-\u0003\u0001\"\u0003\u0002N\u0005!3M]3bi\u0016tUm\u001e)s_\u0012,8-\u001a:XSRDwK]8oON+'/[1mSj,'\u000f\u0006\u0003\u0002P\u0005\u0005\u0004cB;\u0002R\u0005U\u0013QK\u0005\u0004\u0003'2(!D&bM.\f\u0007K]8ek\u000e,'\u000fE\u0003$\u0003/\nY&C\u0002\u0002Z\u0011\u0012Q!\u0011:sCf\u00042aIA/\u0013\r\ty\u0006\n\u0002\u0005\u0005f$X\r\u0003\u0005\u0002d\u0005%\u0003\u0019AA3\u0003)\u0011'o\\6fe2K7\u000f\u001e\t\u0005\u0003O\niGD\u0002$\u0003SJ1!a\u001b%\u0003\u0019\u0001&/\u001a3fM&\u0019!-a\u001c\u000b\u0007\u0005-D\u0005C\u0004\u0002t\u0001!I!!\u001e\u0002C\r\u0014X-\u0019;f\u001d\u0016<\bK]8ek\u000e,'oV5uQ:{7+\u001a:jC2L'0\u001a:\u0015\t\u0005=\u0013q\u000f\u0005\t\u0003G\n\t\b1\u0001\u0002f!9\u00111\u0010\u0001\u0005\n\u0005u\u0014aJ2sK\u0006$XMT3x!J|G-^2fe^KG\u000f[#ya2L7-\u001b;TKJL\u0017\r\\5{KJ$B!a\u0014\u0002\u0000!A\u00111MA=\u0001\u0004\t)\u0007\u0003\u0004\u0002\u0004\u0002!\ta[\u0001\ni\u0016\u001cHo\u00117pg\u0016DC!!!\u0002:!1\u0011\u0011\u0012\u0001\u0005\u0002-\f1\u0003^3tiN+g\u000e\u001a+p!\u0006\u0014H/\u001b;j_:DC!a\"\u0002:!1\u0011q\u0012\u0001\u0005\u0002-\f1\u0003^3ti\u0006+Ho\\\"sK\u0006$X\rV8qS\u000eDC!!$\u0002:\u0001")
public class ProducerSendTest
extends JUnit3Suite
implements KafkaServerTestHarness {
    private final int numServers;
    private final List<KafkaConfig> configs;
    private SimpleConsumer consumer1;
    private SimpleConsumer consumer2;
    private final String kafka$api$test$ProducerSendTest$$topic;
    private final int numRecords;
    private List<KafkaServer> servers;
    private String brokerList;
    private final String zkConnect;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;

    @Override
    public List<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    public void servers_$eq(List<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public String brokerList() {
        return this.brokerList;
    }

    @Override
    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    @Override
    public /* synthetic */ void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public /* synthetic */ void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public String zkConnect() {
        return this.zkConnect;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public ZkClient zkClient() {
        return this.zkClient;
    }

    @Override
    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public /* synthetic */ void kafka$zk$ZooKeeperTestHarness$$super$setUp() {
        super.setUp();
    }

    @Override
    public /* synthetic */ void kafka$zk$ZooKeeperTestHarness$$super$tearDown() {
        super.tearDown();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    public int numServers() {
        return this.numServers;
    }

    @Override
    public List<KafkaConfig> configs() {
        return this.configs;
    }

    private SimpleConsumer consumer1() {
        return this.consumer1;
    }

    private void consumer1_$eq(SimpleConsumer x$1) {
        this.consumer1 = x$1;
    }

    private SimpleConsumer consumer2() {
        return this.consumer2;
    }

    private void consumer2_$eq(SimpleConsumer x$1) {
        this.consumer2 = x$1;
    }

    public String kafka$api$test$ProducerSendTest$$topic() {
        return this.kafka$api$test$ProducerSendTest$$topic;
    }

    private int numRecords() {
        return this.numRecords;
    }

    @Override
    public void setUp() {
        KafkaServerTestHarness$class.setUp(this);
        this.consumer1_$eq(new SimpleConsumer("localhost", ((KafkaConfig)this.configs().apply(0)).port(), 100, 0x100000, ""));
        this.consumer2_$eq(new SimpleConsumer("localhost", ((KafkaConfig)this.configs().apply(1)).port(), 100, 0x100000, ""));
    }

    @Override
    public void tearDown() {
        this.consumer1().close();
        this.consumer2().close();
        KafkaServerTestHarness$class.tearDown(this);
    }

    @Test
    public void testSendOffset() {
        ObjectRef producer = ObjectRef.create(TestUtils$.MODULE$.createNewProducer(this.brokerList(), TestUtils$.MODULE$.createNewProducer$default$2(), TestUtils$.MODULE$.createNewProducer$default$3(), TestUtils$.MODULE$.createNewProducer$default$4(), TestUtils$.MODULE$.createNewProducer$default$5(), TestUtils$.MODULE$.createNewProducer$default$6()));
        CheckErrorCallback callback = new CheckErrorCallback();
        try {
            TestUtils$.MODULE$.createTopic(this.zkClient(), this.kafka$api$test$ProducerSendTest$$topic(), 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
            ProducerRecord record0 = new ProducerRecord(this.kafka$api$test$ProducerSendTest$$topic(), new Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
            Assert.assertEquals((String)"Should have offset 0", (Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)((RecordMetadata)((KafkaProducer)producer.elem).send(record0, (Callback)callback).get()).offset()));
            ProducerRecord record1 = new ProducerRecord(this.kafka$api$test$ProducerSendTest$$topic(), new Integer(0), (Object)"key".getBytes(), null);
            Assert.assertEquals((String)"Should have offset 1", (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToLong((long)((RecordMetadata)((KafkaProducer)producer.elem).send(record1, (Callback)callback).get()).offset()));
            ProducerRecord record2 = new ProducerRecord(this.kafka$api$test$ProducerSendTest$$topic(), new Integer(0), null, (Object)"value".getBytes());
            Assert.assertEquals((String)"Should have offset 2", (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToLong((long)((RecordMetadata)((KafkaProducer)producer.elem).send(record2, (Callback)callback).get()).offset()));
            ProducerRecord record3 = new ProducerRecord(this.kafka$api$test$ProducerSendTest$$topic(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
            Assert.assertEquals((String)"Should have offset 3", (Object)BoxesRunTime.boxToLong((long)3L), (Object)BoxesRunTime.boxToLong((long)((RecordMetadata)((KafkaProducer)producer.elem).send(record3, (Callback)callback).get()).offset()));
            try {
                ProducerRecord record4 = new ProducerRecord(null, new Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
                ((KafkaProducer)producer.elem).send(record4, (Callback)callback);
                throw this.fail("Should not allow sending a record without topic");
            }
            catch (Throwable throwable) {
                throw this.fail("Only expecting IllegalArgumentException", throwable);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.numRecords()).foreach((Function1)new Serializable(this, producer, record0){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef producer$1;
                    private final ProducerRecord record0$1;

                    public final Future<RecordMetadata> apply(int i) {
                        return ((KafkaProducer)this.producer$1.elem).send(this.record0$1);
                    }
                    {
                        this.producer$1 = producer$1;
                        this.record0$1 = record0$1;
                    }
                });
                Assert.assertEquals((String)new StringBuilder().append((Object)"Should have offset ").append((Object)BoxesRunTime.boxToInteger((int)(this.numRecords() + 4))).toString(), (Object)BoxesRunTime.boxToLong((long)((long)this.numRecords() + 4L)), (Object)BoxesRunTime.boxToLong((long)((RecordMetadata)((KafkaProducer)producer.elem).send(record0, (Callback)callback).get()).offset()));
            }
        }
        finally {
            if ((KafkaProducer)producer.elem != null) {
                ((KafkaProducer)producer.elem).close();
                producer.elem = null;
            }
        }
    }

    @Test
    public void testSerializer() {
        try {
            KafkaProducer<byte[], byte[]> producer = this.createNewProducerWithWrongSerializer(this.brokerList());
            ProducerRecord record5 = new ProducerRecord(this.kafka$api$test$ProducerSendTest$$topic(), new Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
            producer.send(record5);
            throw this.fail("Should have gotten a SerializationException");
        }
        catch (SerializationException serializationException) {
            try {
                this.createNewProducerWithNoSerializer(this.brokerList());
                throw this.fail("Instantiating a producer without specifying a serializer should cause a ConfigException");
            }
            catch (ConfigException configException) {
                this.createNewProducerWithExplicitSerializer(this.brokerList());
                return;
            }
        }
    }

    private KafkaProducer<byte[], byte[]> createNewProducerWithWrongSerializer(String brokerList) {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", brokerList);
        producerProps.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        producerProps.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        return new KafkaProducer(producerProps);
    }

    private KafkaProducer<byte[], byte[]> createNewProducerWithNoSerializer(String brokerList) {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", brokerList);
        return new KafkaProducer(producerProps);
    }

    private KafkaProducer<byte[], byte[]> createNewProducerWithExplicitSerializer(String brokerList) {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", brokerList);
        return new KafkaProducer(producerProps, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
    }

    @Test
    public void testClose() {
        ObjectRef producer = ObjectRef.create(TestUtils$.MODULE$.createNewProducer(this.brokerList(), TestUtils$.MODULE$.createNewProducer$default$2(), TestUtils$.MODULE$.createNewProducer$default$3(), TestUtils$.MODULE$.createNewProducer$default$4(), TestUtils$.MODULE$.createNewProducer$default$5(), TestUtils$.MODULE$.createNewProducer$default$6()));
        try {
            TestUtils$.MODULE$.createTopic(this.zkClient(), this.kafka$api$test$ProducerSendTest$$topic(), 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
            ProducerRecord record0 = new ProducerRecord(this.kafka$api$test$ProducerSendTest$$topic(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.numRecords()).foreach((Function1)new Serializable(this, producer, record0){
                public static final long serialVersionUID = 0L;
                private final ObjectRef producer$2;
                private final ProducerRecord record0$2;

                public final Future<RecordMetadata> apply(int i) {
                    return ((KafkaProducer)this.producer$2.elem).send(this.record0$2);
                }
                {
                    this.producer$2 = producer$2;
                    this.record0$2 = record0$2;
                }
            });
            Future response0 = ((KafkaProducer)producer.elem).send(record0);
            ((KafkaProducer)producer.elem).close();
            producer.elem = null;
            Assert.assertTrue((String)"The last message should be acked before producer is shutdown", (boolean)response0.isDone());
            Assert.assertEquals((String)new StringBuilder().append((Object)"Should have offset ").append((Object)BoxesRunTime.boxToInteger((int)this.numRecords())).toString(), (Object)BoxesRunTime.boxToLong((long)this.numRecords()), (Object)BoxesRunTime.boxToLong((long)((RecordMetadata)response0.get()).offset()));
            return;
        }
        finally {
            if ((KafkaProducer)producer.elem != null) {
                ((KafkaProducer)producer.elem).close();
                producer.elem = null;
            }
        }
    }

    @Test
    public void testSendToPartition() {
        ObjectRef producer = ObjectRef.create(TestUtils$.MODULE$.createNewProducer(this.brokerList(), TestUtils$.MODULE$.createNewProducer$default$2(), TestUtils$.MODULE$.createNewProducer$default$3(), TestUtils$.MODULE$.createNewProducer$default$4(), TestUtils$.MODULE$.createNewProducer$default$5(), TestUtils$.MODULE$.createNewProducer$default$6()));
        try {
            Map<Object, Option<Object>> leaders = TestUtils$.MODULE$.createTopic(this.zkClient(), this.kafka$api$test$ProducerSendTest$$topic(), 2, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
            int partition = 1;
            Option leader1 = (Option)leaders.apply((Object)BoxesRunTime.boxToInteger((int)partition));
            Assert.assertTrue((String)"Leader for topic \"topic\" partition 1 should exist", (boolean)leader1.isDefined());
            IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.numRecords()).map((Function1)new Serializable(this, producer, partition){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProducerSendTest $outer;
                private final ObjectRef producer$3;
                private final int partition$1;

                public final Future<RecordMetadata> apply(int i) {
                    return ((KafkaProducer)this.producer$3.elem).send(new ProducerRecord(this.$outer.kafka$api$test$ProducerSendTest$$topic(), Predef$.MODULE$.int2Integer(this.partition$1), null, (Object)new StringBuilder().append((Object)"value").append((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes()));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producer$3 = producer$3;
                    this.partition$1 = partition$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            List futures = responses.toList();
            futures.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final RecordMetadata apply(Future<RecordMetadata> x$1) {
                    return x$1.get();
                }
            }, List$.MODULE$.canBuildFrom());
            futures.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Future<RecordMetadata> future) {
                    Assert.assertTrue((String)"Request should have completed", (boolean)future.isDone());
                }
            });
            ((TraversableLike)futures.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numRecords()), List$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Future<RecordMetadata>, Object> check$ifrefutable$1) {
                    Tuple2<Future<RecordMetadata>, Object> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this, partition){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProducerSendTest $outer;
                private final int partition$1;

                public final void apply(Tuple2<Future<RecordMetadata>, Object> x$2) {
                    Tuple2<Future<RecordMetadata>, Object> tuple2 = x$2;
                    if (tuple2 != null) {
                        Future future = (Future)tuple2._1();
                        int offset = tuple2._2$mcI$sp();
                        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)offset), (Object)BoxesRunTime.boxToLong((long)((RecordMetadata)future.get()).offset()));
                        Assert.assertEquals((Object)this.$outer.kafka$api$test$ProducerSendTest$$topic(), (Object)((RecordMetadata)future.get()).topic());
                        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)this.partition$1), (Object)BoxesRunTime.boxToInteger((int)((RecordMetadata)future.get()).partition()));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.partition$1 = partition$1;
                }
            });
            FetchResponse fetchResponse1 = BoxesRunTime.unboxToInt((Object)leader1.get()) == ((KafkaConfig)this.configs().apply(0)).brokerId() ? this.consumer1().fetch(new FetchRequestBuilder().addFetch(this.kafka$api$test$ProducerSendTest$$topic(), partition, 0L, Integer.MAX_VALUE).build()) : this.consumer2().fetch(new FetchRequestBuilder().addFetch(this.kafka$api$test$ProducerSendTest$$topic(), partition, 0L, Integer.MAX_VALUE).build());
            Buffer messageSet1 = fetchResponse1.messageSet(this.kafka$api$test$ProducerSendTest$$topic(), partition).iterator().toBuffer();
            Assert.assertEquals((String)new StringBuilder().append((Object)"Should have fetched ").append((Object)BoxesRunTime.boxToInteger((int)this.numRecords())).append((Object)" messages").toString(), (Object)BoxesRunTime.boxToInteger((int)this.numRecords()), (Object)BoxesRunTime.boxToInteger((int)messageSet1.size()));
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.numRecords() - 1).foreach$mVc$sp((Function1)new Serializable(this, messageSet1){
                public static final long serialVersionUID = 0L;
                private final Buffer messageSet1$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    Assert.assertEquals((Object)new Message(new StringBuilder().append((Object)"value").append((Object)BoxesRunTime.boxToInteger((int)(i + 1))).toString().getBytes()), (Object)((MessageAndOffset)this.messageSet1$1.apply(i)).message());
                    Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)i), (Object)BoxesRunTime.boxToLong((long)((MessageAndOffset)this.messageSet1$1.apply(i)).offset()));
                }
                {
                    this.messageSet1$1 = messageSet1$1;
                }
            });
            return;
        }
        finally {
            if ((KafkaProducer)producer.elem != null) {
                ((KafkaProducer)producer.elem).close();
                producer.elem = null;
            }
        }
    }

    @Test
    public void testAutoCreateTopic() {
        String x$3 = this.brokerList();
        int x$4 = 5;
        int x$5 = TestUtils$.MODULE$.createNewProducer$default$2();
        long x$6 = TestUtils$.MODULE$.createNewProducer$default$3();
        boolean x$7 = TestUtils$.MODULE$.createNewProducer$default$4();
        long x$8 = TestUtils$.MODULE$.createNewProducer$default$5();
        KafkaProducer<byte[], byte[]> producer = TestUtils$.MODULE$.createNewProducer(x$3, x$5, x$6, x$7, x$8, x$4);
        try {
            ProducerRecord record = new ProducerRecord(this.kafka$api$test$ProducerSendTest$$topic(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
            Assert.assertEquals((String)"Should have offset 0", (Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)((RecordMetadata)producer.send(record).get()).offset()));
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.kafka$api$test$ProducerSendTest$$topic(), 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
            return;
        }
        finally {
            if (producer != null) {
                producer.close();
                producer = null;
            }
        }
    }

    public ProducerSendTest() {
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
        this.numServers = 2;
        this.configs = (List)TestUtils$.MODULE$.createBrokerConfigs(this.numServers(), false).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return new KafkaConfig(this, props){
                    private final String zkConnect;
                    private final int numPartitions;

                    public String zkConnect() {
                        return this.zkConnect;
                    }

                    public int numPartitions() {
                        return this.numPartitions;
                    }
                    {
                        super(props$1);
                        this.zkConnect = TestZKUtils$.MODULE$.zookeeperConnect();
                        this.numPartitions = 4;
                    }
                };
            }
        }, List$.MODULE$.canBuildFrom());
        this.consumer1 = null;
        this.consumer2 = null;
        this.kafka$api$test$ProducerSendTest$$topic = "topic";
        this.numRecords = 100;
    }

    public class CheckErrorCallback
    implements Callback {
        public void onCompletion(RecordMetadata metadata, Exception exception) {
            if (exception == null) {
                return;
            }
            throw this.kafka$api$test$ProducerSendTest$CheckErrorCallback$$$outer().fail("Send callback returns the following exception", exception);
        }

        public /* synthetic */ ProducerSendTest kafka$api$test$ProducerSendTest$CheckErrorCallback$$$outer() {
            return ProducerSendTest.this;
        }

        public CheckErrorCallback() {
            if (ProducerSendTest.this == null) {
                throw null;
            }
        }
    }
}

