/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbortedTxn;
import kafka.log.Cleaner;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.FakeOffsetMap;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogCleanerTest$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetMap;
import kafka.server.BrokerTopicStats;
import kafka.utils.CoreUtils$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Throttler;
import kafka.utils.Throttler$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0001\r5f\u0001B\u0001\u0003\u0001\u001d\u0011a\u0002T8h\u00072,\u0017M\\3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"B\u0001\u0006K+:LGoU;ji\u0016DQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u000fa\u0001!\u0019!C\u00013\u00051A/\u001c9eSJ,\u0012A\u0007\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\t!![8\u000b\u0003}\tAA[1wC&\u0011\u0011\u0005\b\u0002\u0005\r&dW\r\u0003\u0004$\u0001\u0001\u0006IAG\u0001\bi6\u0004H-\u001b:!\u0011\u001d)\u0003A1A\u0005\u0002e\t1\u0001Z5s\u0011\u00199\u0003\u0001)A\u00055\u0005!A-\u001b:!\u0011\u001dI\u0003A1A\u0005\u0002)\n\u0001\u0002\\8h!J|\u0007o]\u000b\u0002WA\u0011AfL\u0007\u0002[)\u0011aFH\u0001\u0005kRLG.\u0003\u00021[\tQ\u0001K]8qKJ$\u0018.Z:\t\rI\u0002\u0001\u0015!\u0003,\u0003%awn\u001a)s_B\u001c\b\u0005C\u00045\u0001\t\u0007I\u0011A\u001b\u0002\u00131|wmQ8oM&<W#\u0001\u001c\u0011\u0005Y9\u0014B\u0001\u001d\u0003\u0005%aunZ\"p]\u001aLw\r\u0003\u0004;\u0001\u0001\u0006IAN\u0001\u000bY><7i\u001c8gS\u001e\u0004\u0003b\u0002\u001f\u0001\u0005\u0004%\t!P\u0001\u0005i&lW-F\u0001?!\ty$)D\u0001A\u0015\t\tE!A\u0003vi&d7/\u0003\u0002D\u0001\nAQj\\2l)&lW\r\u0003\u0004F\u0001\u0001\u0006IAP\u0001\u0006i&lW\r\t\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0003%!\bN]8ui2,'/F\u0001J!\ty$*\u0003\u0002L\u0001\nIA\u000b\u001b:piRdWM\u001d\u0005\u0007\u001b\u0002\u0001\u000b\u0011B%\u0002\u0015QD'o\u001c;uY\u0016\u0014\b\u0005C\u0003P\u0001\u0011\u0005\u0001+\u0001\u0005uK\u0006\u0014Hm\\<o)\u0005\t\u0006C\u0001*V\u001b\u0005\u0019&\"\u0001+\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001b&\u0001B+oSRD#A\u0014-\u0011\u0005e[V\"\u0001.\u000b\u0005-q\u0011B\u0001/[\u0005\u0015\te\r^3s\u0011\u0015q\u0006\u0001\"\u0001Q\u0003E!Xm\u001d;DY\u0016\fgnU3h[\u0016tGo\u001d\u0015\u0003;\u0002\u0004\"!W1\n\u0005\tT&\u0001\u0002+fgRDQ\u0001\u001a\u0001\u0005\u0002A\u000bq\u0006^3tiNK'0\u001a+sS6lW\r\u001a$peB\u0013X-\u00197m_\u000e\fG/\u001a3B]\u0012\u001cu.\u001c9bGR,G\rV8qS\u000eD#a\u00191\t\u000b\u001d\u0004A\u0011\u0001)\u0002?Q,7\u000f\u001e#va2L7-\u0019;f\u0007\",7m[!gi\u0016\u00148\t\\3b]&tw\r\u000b\u0002gA\")!\u000e\u0001C\u0001!\u0006\tC/Z:u\u0005\u0006\u001c\u0018n\u0019+sC:\u001c\u0018m\u0019;j_:\fu/\u0019:f\u00072,\u0017M\\5oO\"\u0012\u0011\u000e\u0019\u0005\u0006[\u0002!\t\u0001U\u0001*i\u0016\u001cHo\u00117fC:<\u0016\u000e\u001e5Ue\u0006t7/Y2uS>t7o\u00159b]:LgnZ*fO6,g\u000e^:)\u00051\u0004\u0007\"\u00029\u0001\t\u0003\u0001\u0016a\u0006;fgR\u001cu.\\7ji6\u000b'o[3s%\u0016lwN^1mQ\ty\u0007\rC\u0003t\u0001\u0011\u0005\u0001+A\u0014uKN$8i\\7nSRl\u0015M]6feJ+G/\u001a8uS>tw+\u001b;i\u000b6\u0004H/\u001f\"bi\u000eD\u0007F\u0001:a\u0011\u00151\b\u0001\"\u0001Q\u0003Y!Xm\u001d;BE>\u0014H/T1sW\u0016\u0014(+Z7pm\u0006d\u0007FA;a\u0011\u0015I\b\u0001\"\u0001Q\u0003\u0019\"Xm\u001d;BE>\u0014H/T1sW\u0016\u0014(+\u001a;f]RLwN\\,ji\",U\u000e\u001d;z\u0005\u0006$8\r\u001b\u0015\u0003q\u0002DQ\u0001 \u0001\u0005\u0002A\u000b\u0001\u0003^3ti2\u000b'oZ3NKN\u001c\u0018mZ3)\u0005m\u0004\u0007\"B@\u0001\t\u0003\u0001\u0016a\u0006;fgR\u001cE.Z1oS:<w+\u001b;i\t\u0016dW\r^3tQ\tq\b\r\u0003\u0004\u0002\u0006\u0001!\t\u0001U\u0001\u0014i\u0016\u001cH\u000fT8h\u00072,\u0017M\\3s'R\fGo\u001d\u0005\u0007\u0003\u0013\u0001A\u0011\u0001)\u0002SQ,7\u000f\u001e'pO\u000ecW-\u00198feJ+G/Y5ogB\u0013x\u000eZ;dKJd\u0015m\u001d;TKF,XM\\2fQ\r\t9\u0001\u0019\u0005\u0007\u0003\u001f\u0001A\u0011\u0001)\u0002sQ,7\u000f\u001e'pO\u000ecW-\u00198feJ+G/Y5og2\u000b7\u000f^*fcV,gnY3Fm\u0016t\u0017J\u001a+sC:\u001c\u0018m\u0019;j_:\f%m\u001c:uK\u0012D3!!\u0004a\u0011\u0019\t)\u0002\u0001C\u0001!\u00069B/Z:u!\u0006\u0014H/[1m'\u0016<W.\u001a8u\u00072,\u0017M\u001c\u0015\u0004\u0003'\u0001\u0007BBA\u000e\u0001\u0011\u0005\u0001+\u0001\u0012uKN$8\t\\3b]&twmV5uQVs7\r\\3b]\u0006\u0014G.Z*fGRLwN\u001c\u0015\u0004\u00033\u0001\u0007BBA\u0011\u0001\u0011\u0005\u0001+\u0001\buKN$Hj\\4U_\u000ecW-\u00198)\u0007\u0005}\u0001\r\u0003\u0004\u0002(\u0001!\t\u0001U\u0001%i\u0016\u001cH\u000fT8h)>\u001cE.Z1o/&$\b.\u00168dY\u0016\fg.\u00192mKN+7\r^5p]\"\u001a\u0011Q\u00051\t\r\u00055\u0002\u0001\"\u0001Q\u0003}!Xm\u001d;DY\u0016\fg.\u001b8h/&$\b.\u00168lKf,G-T3tg\u0006<Wm\u001d\u0015\u0004\u0003W\u0001\u0007bBA\u001a\u0001\u0011\u0005\u0011QG\u0001\nW\u0016L8/\u00138M_\u001e$B!a\u000e\u0002JA1\u0011\u0011HA \u0003\u0007j!!a\u000f\u000b\u0007\u0005u2+\u0001\u0006d_2dWm\u0019;j_:LA!!\u0011\u0002<\tA\u0011\n^3sC\ndW\rE\u0002S\u0003\u000bJ1!a\u0012T\u0005\rIe\u000e\u001e\u0005\b\u0007\u0005E\u0002\u0019AA&!\r1\u0012QJ\u0005\u0004\u0003\u001f\u0012!a\u0001'pO\"9\u00111\u000b\u0001\u0005\u0002\u0005U\u0013\u0001\u00077bgR|eMZ:fiN\u0004VM\u001d\"bi\u000eD\u0017J\u001c'pOR!\u0011qKA0!\u0019\tI$a\u0010\u0002ZA\u0019!+a\u0017\n\u0007\u0005u3K\u0001\u0003M_:<\u0007bB\u0002\u0002R\u0001\u0007\u00111\n\u0005\b\u0003G\u0002A\u0011AA3\u0003Ia\u0017m\u001d;TKF,XM\\2fg&sGj\\4\u0015\t\u0005\u001d\u0014Q\u000e\t\t\u0003s\tI'!\u0017\u0002D%!\u00111NA\u001e\u0005\ri\u0015\r\u001d\u0005\b\u0007\u0005\u0005\u0004\u0019AA&\u0011\u001d\t\t\b\u0001C\u0001\u0003g\nAb\u001c4gg\u0016$8/\u00138M_\u001e$B!a\u0016\u0002v!91!a\u001cA\u0002\u0005-\u0003bBA=\u0001\u0011\u0005\u00111P\u0001\u0019k:\\W-_3e\u001b\u0016\u001c8/Y4f\u0007>,h\u000e^%o\u0019><G\u0003BA\"\u0003{BqaAA<\u0001\u0004\tY\u0005C\u0004\u0002\u0002\u0002!\t!a!\u0002\u001d\u0005\u0014wN\u001d;DQ\u0016\u001c7\u000eR8oKR\u0019\u0011+!\"\t\u0011\u0005\u001d\u0015q\u0010a\u0001\u0003\u0013\u000ba\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0002\f\u0006]UBAAG\u0015\u0011\ty)!%\u0002\r\r|W.\\8o\u0015\r)\u00111\u0013\u0006\u0004\u0003+s\u0011AB1qC\u000eDW-\u0003\u0003\u0002\u001a\u00065%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007\u0003;\u0003A\u0011\u0001)\u00025Q,7\u000f^\"mK\u0006t7+Z4nK:$8oV5uQ\u0006\u0013wN\u001d;)\u0007\u0005m\u0005\r\u0003\u0004\u0002$\u0002!\t\u0001U\u0001\u0014i\u0016\u001cHoU3h[\u0016tGo\u0012:pkBLgn\u001a\u0015\u0004\u0003C\u0003\u0007BBAU\u0001\u0011\u0005\u0001+\u0001\u0013uKN$8+Z4nK:$xI]8va&twmV5uQN\u0003\u0018M]:f\u001f\u001a47/\u001a;tQ\r\t9\u000b\u0019\u0005\u0007\u0003_\u0003A\u0011\u0001)\u0002WQ,7\u000f^*fO6,g\u000e^$s_V\u0004\u0018N\\4G_2dwn^5oO2{\u0017\rZ(g5\u0016\u0014x.\u00138eKbD3!!,a\u0011\u001d\t)\f\u0001C\u0005\u0003o\u000b\u0011c\u00195fG.\u001cVmZ7f]R|%\u000fZ3s)\r\t\u0016\u0011\u0018\u0005\t\u0003w\u000b\u0019\f1\u0001\u0002>\u00061qM]8vaN\u0004b!!\u000f\u0002@\u0006\r\u0017\u0002BAa\u0003w\u00111aU3r!\u0019\tI$a0\u0002FB\u0019a#a2\n\u0007\u0005%'A\u0001\u0006M_\u001e\u001cVmZ7f]RDa!!4\u0001\t\u0003\u0001\u0016A\u0005;fgR\u0014U/\u001b7e\u001f\u001a47/\u001a;NCBD3!a3a\u0011\u0019\t\u0019\u000e\u0001C\u0001!\u00061B/Z:u%\u0016\u001cwN^3ss\u00063G/\u001a:De\u0006\u001c\b\u000eK\u0002\u0002R\u0002Da!!7\u0001\t\u0003\u0001\u0016a\u0007;fgR\u0014U/\u001b7e\u001f\u001a47/\u001a;NCB4\u0015m[3MCJ<W\rK\u0002\u0002X\u0002Da!a8\u0001\t\u0003\u0001\u0016!\u0007;fgR\u0014U/\u001b7e!\u0006\u0014H/[1m\u001f\u001a47/\u001a;NCBD3!!8a\u0011\u0019\t)\u000f\u0001C\u0001!\u0006QB/Z:u\u00072,\u0017M\\\"peJ,\b\u000f^'fgN\fw-Z*fi\"\u001a\u00111\u001d1\t\r\u0005-\b\u0001\"\u0001Q\u0003\u0015\"Xm\u001d;DY&,g\u000e\u001e%b]\u0012d\u0017N\\4PM\u000e{'O];qi6+7o]1hKN+G\u000fK\u0002\u0002j\u0002Da!!=\u0001\t\u0003\u0001\u0016A\u0005;fgR\u001cE.Z1o)>l'm\u001d;p]\u0016D3!a<a\u0011\u001d\t9\u0010\u0001C\u0005\u0003s\f!b\u001e:ji\u0016$v\u000eT8h)!\t9&a?\u0002~\n%\u0001bB\u0002\u0002v\u0002\u0007\u00111\n\u0005\t\u0003\u007f\f)\u00101\u0001\u0003\u0002\u0005i1.Z=t\u0003:$g+\u00197vKN\u0004b!!\u000f\u0002@\t\r\u0001c\u0002*\u0003\u0006\u0005\r\u00131I\u0005\u0004\u0005\u000f\u0019&A\u0002+va2,'\u0007\u0003\u0005\u0003\f\u0005U\b\u0019AA,\u0003%ygMZ:fiN+\u0017\u000fC\u0004\u0003\u0010\u0001!IA!\u0005\u0002+%tg/\u00197jI\u000ecW-\u00198fI6+7o]1hKRA!1\u0003B\u0010\u0005G\u0011)\u0003\u0005\u0003\u0003\u0016\tmQB\u0001B\f\u0015\u0011\u0011I\"!$\u0002\rI,7m\u001c:e\u0013\u0011\u0011iBa\u0006\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011!\u0011\tC!\u0004A\u0002\u0005e\u0013!D5oSRL\u0017\r\\(gMN,G\u000f\u0003\u0005\u0002\u0000\n5\u0001\u0019\u0001B\u0001\u0011)\u00119C!\u0004\u0011\u0002\u0003\u0007!\u0011F\u0001\u0006G>$Wm\u0019\t\u0005\u0005+\u0011Y#\u0003\u0003\u0003.\t]!aD\"p[B\u0014Xm]:j_:$\u0016\u0010]3\t\u000f\tE\u0002\u0001\"\u0003\u00034\u0005\tR.Z:tC\u001e,w+\u001b;i\u001f\u001a47/\u001a;\u0015\u0011\tM!Q\u0007B#\u0005\u0013B\u0001Ba\u000e\u00030\u0001\u0007!\u0011H\u0001\u0004W\u0016L\b#\u0002*\u0003<\t}\u0012b\u0001B\u001f'\n)\u0011I\u001d:bsB\u0019!K!\u0011\n\u0007\t\r3K\u0001\u0003CsR,\u0007\u0002\u0003B$\u0005_\u0001\rA!\u000f\u0002\u000bY\fG.^3\t\u0011\t-#q\u0006a\u0001\u00033\naa\u001c4gg\u0016$\bb\u0002B\u0019\u0001\u0011%!q\n\u000b\t\u0005'\u0011\tFa\u0015\u0003V!A!q\u0007B'\u0001\u0004\t\u0019\u0005\u0003\u0005\u0003H\t5\u0003\u0019AA\"\u0011!\u0011YE!\u0014A\u0002\u0005e\u0003b\u0002B-\u0001\u0011%!1L\u0001\b[\u0006\\W\rT8h)!\tYE!\u0018\u0003`\t\r\u0004\u0002C\u0013\u0003XA\u0005\t\u0019\u0001\u000e\t\u0013\t\u0005$q\u000bI\u0001\u0002\u00041\u0014AB2p]\u001aLw\r\u0003\u0006\u0003f\t]\u0003\u0013!a\u0001\u00033\nQB]3d_Z,'/\u001f)pS:$\bb\u0002B5\u0001\u0011%!1N\u0001\u000e]>|\u0005o\u00115fG.$uN\\3\u0015\u0007E\u0013i\u0007\u0003\u0005\u0002\b\n\u001d\u0004\u0019AAE\u0011\u001d\u0011\t\b\u0001C\u0005\u0005g\n1\"\\1lK\u000ecW-\u00198feRA!Q\u000fB>\u0005\u007f\u0012I\tE\u0002\u0017\u0005oJ1A!\u001f\u0003\u0005\u001d\u0019E.Z1oKJD\u0001B! \u0003p\u0001\u0007\u00111I\u0001\tG\u0006\u0004\u0018mY5us\"Q!\u0011\u0011B8!\u0003\u0005\rAa!\u0002\u0013\rDWmY6E_:,\u0007C\u0002*\u0003\u0006\u0006%\u0015+C\u0002\u0003\bN\u0013\u0011BR;oGRLwN\\\u0019\t\u0015\t-%q\u000eI\u0001\u0002\u0004\t\u0019%\u0001\bnCblUm]:bO\u0016\u001c\u0016N_3\t\u000f\u0005]\b\u0001\"\u0003\u0003\u0010R1\u0011q\u000bBI\u0005'Cqa\u0001BG\u0001\u0004\tY\u0005\u0003\u0005\u0003\u0016\n5\u0005\u0019\u0001B\u0001\u0003\r\u0019X-\u001d\u0005\b\u0005o\u0001A\u0011\u0002BM)\u0011\u0011YJa*\u0011\t\tu%1U\u0007\u0003\u0005?S1A!)\u001f\u0003\rq\u0017n\\\u0005\u0005\u0005K\u0013yJ\u0001\u0006CsR,')\u001e4gKJD\u0001B!+\u0003\u0018\u0002\u0007\u00111I\u0001\u0003S\u0012DqA!\u0007\u0001\t\u0013\u0011i\u000b\u0006\b\u0003\u0014\t=&\u0011\u0017BZ\u0005o\u0013\tM!2\t\u0011\t]\"1\u0016a\u0001\u0003\u0007B\u0001Ba\u0012\u0003,\u0002\u0007\u00111\t\u0005\u000b\u0005k\u0013Y\u000b%AA\u0002\u0005e\u0013A\u00039s_\u0012,8-\u001a:JI\"Q!\u0011\u0018BV!\u0003\u0005\rAa/\u0002\u001bA\u0014x\u000eZ;dKJ,\u0005o\\2i!\r\u0011&QX\u0005\u0004\u0005\u007f\u001b&!B*i_J$\bB\u0003Bb\u0005W\u0003\n\u00111\u0001\u0002D\u0005A1/Z9vK:\u001cW\r\u0003\u0006\u0003H\n-\u0006\u0013!a\u0001\u0003\u0007\nA\u0003]1si&$\u0018n\u001c8MK\u0006$WM]#q_\u000eD\u0007b\u0002Bf\u0001\u0011%!QZ\u0001\u001cCB\u0004XM\u001c3Ue\u0006t7/Y2uS>t\u0017\r\\!t\u0019\u0016\fG-\u001a:\u0015\u0011\t='\u0011\u001cBn\u0005;\u0004rA\u0015BC\u0005#\u0014\u0019\u000e\u0005\u0004\u0002:\u0005}\u00161\t\t\u0004-\tU\u0017b\u0001Bl\u0005\tiAj\\4BaB,g\u000eZ%oM>Dqa\u0001Be\u0001\u0004\tY\u0005\u0003\u0005\u00036\n%\u0007\u0019AA-\u0011)\u0011IL!3\u0011\u0002\u0003\u0007!1\u0018\u0005\b\u0005C\u0004A\u0011\u0002Br\u0003a\t\u0007\u000f]3oI&#W-\u001c9pi\u0016tG/Q:MK\u0006$WM\u001d\u000b\u000b\u0005\u001f\u0014)Oa:\u0003j\n-\bbB\u0002\u0003`\u0002\u0007\u00111\n\u0005\t\u0005k\u0013y\u000e1\u0001\u0002Z!Q!\u0011\u0018Bp!\u0003\u0005\rAa/\t\u0015\t5(q\u001cI\u0001\u0002\u0004\u0011y/A\bjgR\u0013\u0018M\\:bGRLwN\\1m!\r\u0011&\u0011_\u0005\u0004\u0005g\u001c&a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005o\u0004A\u0011\u0002B}\u00031\u0019w.\\7ji6\u000b'o[3s)!\u0011\u0019Ba?\u0003~\n}\b\u0002\u0003B[\u0005k\u0004\r!!\u0017\t\u0011\te&Q\u001fa\u0001\u0005wC!b!\u0001\u0003vB\u0005\t\u0019AA-\u0003%!\u0018.\\3ti\u0006l\u0007\u000fC\u0004\u0004\u0006\u0001!Iaa\u0002\u0002\u0017\u0005\u0014wN\u001d;NCJ\\WM\u001d\u000b\t\u0005'\u0019Iaa\u0003\u0004\u000e!A!QWB\u0002\u0001\u0004\tI\u0006\u0003\u0005\u0003:\u000e\r\u0001\u0019\u0001B^\u0011)\u0019\taa\u0001\u0011\u0002\u0003\u0007\u0011\u0011\f\u0005\b\u0007#\u0001A\u0011BB\n\u00031)g\u000e\u001a+y]6\u000b'o[3s)1\u0011\u0019b!\u0006\u0004\u0018\re11EB\u0013\u0011!\u0011)la\u0004A\u0002\u0005e\u0003\u0002\u0003B]\u0007\u001f\u0001\rAa/\t\u0011\rm1q\u0002a\u0001\u0007;\t\u0011cY8oiJ|GNU3d_J$G+\u001f9f!\u0011\u0011)ba\b\n\t\r\u0005\"q\u0003\u0002\u0012\u0007>tGO]8m%\u0016\u001cwN\u001d3UsB,\u0007\u0002\u0003B&\u0007\u001f\u0001\r!!\u0017\t\u0011\r\u00051q\u0002a\u0001\u00033BqA!\u0007\u0001\t\u0013\u0019I\u0003\u0006\u0004\u0003\u0014\r-2Q\u0006\u0005\t\u0005o\u00199\u00031\u0001\u0002D!A!qIB\u0014\u0001\u0004\u0011I\u0004C\u0004\u00042\u0001!Iaa\r\u0002\u001bUt7.Z=fIJ+7m\u001c:e)\u0011\u0011\u0019b!\u000e\t\u0011\t\u001d3q\u0006a\u0001\u0003\u0007Bqa!\u000f\u0001\t\u0013\u0019Y$A\bu_6\u00147\u000f^8oKJ+7m\u001c:e)\u0011\u0011\u0019b!\u0010\t\u0011\t]2q\u0007a\u0001\u0003\u0007B\u0011b!\u0011\u0001#\u0003%Iaa\u0011\u0002+5\f7.Z\"mK\u0006tWM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u00111Q\t\u0016\u0005\u0005\u0007\u001b9e\u000b\u0002\u0004JA!11JB+\u001b\t\u0019iE\u0003\u0003\u0004P\rE\u0013!C;oG\",7m[3e\u0015\r\u0019\u0019fU\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB,\u0007\u001b\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u0019Y\u0006AI\u0001\n\u0013\u0019i&A\u000bnC.,7\t\\3b]\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\r}#\u0006BA\"\u0007\u000fB\u0011ba\u0019\u0001#\u0003%Ia!\u001a\u0002#5\f7.\u001a'pO\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004h)\u001a!da\u0012\t\u0013\r-\u0004!%A\u0005\n\r5\u0014!E7bW\u0016dun\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u00111q\u000e\u0016\u0004m\r\u001d\u0003\"CB:\u0001E\u0005I\u0011BB;\u0003Ei\u0017m[3M_\u001e$C-\u001a4bk2$HeM\u000b\u0003\u0007oRC!!\u0017\u0004H!I11\u0010\u0001\u0012\u0002\u0013%1QO\u0001\u0011e\u0016\u001cwN\u001d3%I\u00164\u0017-\u001e7uIMB\u0011ba \u0001#\u0003%Ia!!\u0002!I,7m\u001c:eI\u0011,g-Y;mi\u0012\"TCABBU\u0011\u0011Yla\u0012\t\u0013\r\u001d\u0005!%A\u0005\n\ru\u0013\u0001\u0005:fG>\u0014H\r\n3fM\u0006,H\u000e\u001e\u00136\u0011%\u0019Y\tAI\u0001\n\u0013\u0019i&\u0001\tsK\u000e|'\u000f\u001a\u0013eK\u001a\fW\u000f\u001c;%m!I1q\u0012\u0001\u0012\u0002\u0013%1\u0011Q\u0001#CB\u0004XM\u001c3JI\u0016l\u0007o\u001c;f]R\f5\u000fT3bI\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\t\u0013\rM\u0005!%A\u0005\n\rU\u0015AI1qa\u0016tG-\u00133f[B|G/\u001a8u\u0003NdU-\u00193fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0004\u0018*\"!q^B$\u0011%\u0019Y\nAI\u0001\n\u0013\u0019\t)A\u0013baB,g\u000e\u001a+sC:\u001c\u0018m\u0019;j_:\fG.Q:MK\u0006$WM\u001d\u0013eK\u001a\fW\u000f\u001c;%g!I1q\u0014\u0001\u0012\u0002\u0013%1QO\u0001\u0016C\n|'\u000f^'be.,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0011%\u0019\u0019\u000bAI\u0001\n\u0013\u0019)(\u0001\fd_6l\u0017\u000e^'be.,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0011%\u00199\u000bAI\u0001\n\u0013\u0019I+A\u0010j]Z\fG.\u001b3DY\u0016\fg.\u001a3NKN\u001c\u0018mZ3%I\u00164\u0017-\u001e7uIM*\"aa++\t\t%2q\t")
public class LogCleanerTest
extends JUnitSuite {
    private final File tmpdir = TestUtils$.MODULE$.tempDir();
    private final File dir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpdir());
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private final MockTime time;
    private final Throttler throttler;

    public File tmpdir() {
        return this.tmpdir;
    }

    public File dir() {
        return this.dir;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    @After
    public void teardown() {
        Utils.delete((File)this.tmpdir());
    }

    @Test
    public void testCleanSegments() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$38 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$39 = this.makeLog$default$1();
        long x$40 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$39, x$38, x$40);
        while (log2.numberOfSegments() < 4) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        }
        Iterable<Object> keysFound = this.keysInLog(log2);
        Assert.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log2.logEndOffset())), keysFound);
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 5, 7, 9}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap map$1;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.map$1.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$1 = map$1;
            }
        });
        Seq segments = ((TraversableOnce)log2.logSegments().take(3)).toSeq();
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        int expectedBytesRead = BoxesRunTime.unboxToInt((Object)((TraversableOnce)segments.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$1) {
                return x$1.size();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        cleaner.cleanSegments(log2, segments, (OffsetMap)map, 0L, stats);
        Iterable shouldRemain = (Iterable)this.keysInLog(log2).filter((Function1)new Serializable(this, keys){
            public static final long serialVersionUID = 0L;
            private final ListSet keys$1;

            public final boolean apply(int x$2) {
                return this.apply$mcZI$sp(x$2);
            }

            public boolean apply$mcZI$sp(int x$2) {
                return !this.keys$1.contains((Object)BoxesRunTime.boxToInteger((int)x$2));
            }
            {
                this.keys$1 = keys$1;
            }
        });
        Assert.assertEquals((Object)shouldRemain, this.keysInLog(log2));
        Assert.assertEquals((long)expectedBytesRead, (long)stats.bytesRead());
    }

    @Test
    public void testSizeTrimmedForPreallocatedAndCompactedTopic() {
        int originalMaxFileSize = 1024;
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(originalMaxFileSize));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), "compact");
        logProps.put(LogConfig$.MODULE$.PreAllocateEnableProp(), "true");
        LogConfig x$41 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$42 = this.makeLog$default$1();
        long x$43 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$42, x$41, x$43);
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 2L, log2.activeSegment().baseOffset()));
        Assert.assertTrue((String)"Cleaned segment file should be trimmed to its real size.", (((LogSegment)log2.logSegments().iterator().next()).log().channel().size() < (long)originalMaxFileSize ? 1 : 0) != 0);
    }

    @Test
    public void testDuplicateCheckAfterCleaning() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(2048));
        LogConfig x$44 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$45 = this.makeLog$default$1();
        long x$46 = this.makeLog$default$3();
        ObjectRef log2 = ObjectRef.create((Object)this.makeLog(x$45, x$44, x$46));
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        int pid3 = 3;
        int pid4 = 4;
        this.appendIdempotentAsLeader((Log)log2.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        this.appendIdempotentAsLeader((Log)log2.elem, pid2, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 4})));
        this.appendIdempotentAsLeader((Log)log2.elem, pid3, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4})));
        Log qual$1 = (Log)log2.elem;
        long x$47 = qual$1.roll$default$1();
        qual$1.roll(x$47);
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), (Log)log2.elem, 0L, ((Log)log2.elem).activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 5, 7})), this.lastOffsetsPerBatchInLog((Log)log2.elem));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid1)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid3)), (Object)BoxesRunTime.boxToInteger((int)1))})), this.lastSequencesInLog((Log)log2.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1, 4})), this.keysInLog((Log)log2.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 6, 7})), this.offsetsInLog((Log)log2.elem));
        this.reloadLog$1(logProps, log2);
        LogAppendInfo logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log2.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        Assert.assertEquals((long)0L, (long)logAppendInfo.firstOffset());
        Assert.assertEquals((long)2L, (long)logAppendInfo.lastOffset());
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log2.elem, pid3, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4})));
        Assert.assertEquals((long)6L, (long)logAppendInfo.firstOffset());
        Assert.assertEquals((long)7L, (long)logAppendInfo.lastOffset());
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log2.elem, pid2, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 4})));
        Assert.assertEquals((long)3L, (long)logAppendInfo.firstOffset());
        Assert.assertEquals((long)5L, (long)logAppendInfo.lastOffset());
        this.appendIdempotentAsLeader((Log)log2.elem, pid4, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        Log qual$2 = (Log)log2.elem;
        long x$51 = qual$2.roll$default$1();
        qual$2.roll(x$51);
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), (Log)log2.elem, 0L, ((Log)log2.elem).activeSegment().baseOffset()));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid1)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid3)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid4)), (Object)BoxesRunTime.boxToInteger((int)0))})), this.lastSequencesInLog((Log)log2.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 5, 7, 8})), this.lastOffsetsPerBatchInLog((Log)log2.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 4, 2})), this.keysInLog((Log)log2.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 6, 7, 8})), this.offsetsInLog((Log)log2.elem));
        this.reloadLog$1(logProps, log2);
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log2.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        Assert.assertEquals((long)0L, (long)logAppendInfo.firstOffset());
        Assert.assertEquals((long)2L, (long)logAppendInfo.lastOffset());
    }

    @Test
    public void testBasicTransactionAwareCleaning() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(2048));
        LogConfig x$52 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$53 = this.makeLog$default$1();
        long x$54 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$53, x$52, x$54);
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        Function1<Seq<Object>, LogAppendInfo> appendProducer1 = this.appendTransactionalAsLeader(log2, pid1, producerEpoch);
        Function1<Seq<Object>, LogAppendInfo> appendProducer2 = this.appendTransactionalAsLeader(log2, pid2, producerEpoch);
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})));
        log2.appendAsLeader(this.abortMarker(pid1, producerEpoch, this.abortMarker$default$3()), 0, false);
        log2.appendAsLeader(this.commitMarker(pid2, producerEpoch, this.commitMarker$default$3()), 0, false);
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log2.appendAsLeader(this.commitMarker(pid1, producerEpoch, this.commitMarker$default$3()), 0, false);
        List abortedTransactions = log2.collectAbortedTransactions(log2.logStartOffset(), log2.logEndOffset());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 6, 7, 8, 9})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)abortedTransactions, (Object)log2.collectAbortedTransactions(log2.logStartOffset(), log2.logEndOffset()));
    }

    @Test
    public void testCleanWithTransactionsSpanningSegments() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$55 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$56 = this.makeLog$default$1();
        long x$57 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$56, x$55, x$57);
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        int pid3 = 3;
        Function1<Seq<Object>, LogAppendInfo> appendProducer1 = this.appendTransactionalAsLeader(log2, pid1, producerEpoch);
        Function1<Seq<Object>, LogAppendInfo> appendProducer2 = this.appendTransactionalAsLeader(log2, pid2, producerEpoch);
        Function1<Seq<Object>, LogAppendInfo> appendProducer3 = this.appendTransactionalAsLeader(log2, pid3, producerEpoch);
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})));
        log2.roll(log2.roll$default$1());
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 6})));
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6, 7})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8})));
        log2.appendAsLeader(this.abortMarker(pid2, producerEpoch, this.abortMarker$default$3()), 0, false);
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{8, 9})));
        log2.appendAsLeader(this.commitMarker(pid3, producerEpoch, this.commitMarker$default$3()), 0, false);
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{9, 10})));
        log2.appendAsLeader(this.abortMarker(pid1, producerEpoch, this.abortMarker$default$3()), 0, false);
        long dirtyOffset = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()))._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10})), this.keysInLog(log2));
        log2.roll(log2.roll$default$1());
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{11})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{12})));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, dirtyOffset, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 6, 7, 8, 9, 11, 12})), this.keysInLog(log2));
    }

    @Test
    public void testCommitMarkerRemoval() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$58 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$59 = this.makeLog$default$1();
        long x$60 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$59, x$58, x$60);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log2, producerId, producerEpoch);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log2.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log2.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false);
        log2.roll(log2.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 2})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3, 4, 5})), this.offsetsInLog(log2));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3})));
        log2.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false);
        log2.roll(log2.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6, 7, 8})), this.offsetsInLog(log2));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), 0L)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6, 7, 8})), this.offsetsInLog(log2));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7, 8})), this.offsetsInLog(log2));
    }

    @Test
    public void testCommitMarkerRetentionWithEmptyBatch() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$61 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$62 = this.makeLog$default$1();
        long x$63 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$62, x$61, x$63);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log2, producerId, producerEpoch);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log2.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false);
        log2.roll(log2.roll$default$1());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(2, 2, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(3, 3, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), this.lastOffsetsPerBatchInLog(log2));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), this.lastOffsetsPerBatchInLog(log2));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log2.roll(log2.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4, 5})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4, 5})), this.lastOffsetsPerBatchInLog(log2));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.lastOffsetsPerBatchInLog(log2));
    }

    @Test
    public void testAbortMarkerRemoval() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$64 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$65 = this.makeLog$default$1();
        long x$66 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$65, x$64, x$66);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log2, producerId, producerEpoch);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log2.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, false);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})));
        log2.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false);
        log2.roll(log2.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), 0L)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log2));
        cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5})), this.offsetsInLog(log2));
    }

    @Test
    public void testAbortMarkerRetentionWithEmptyBatch() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$67 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$68 = this.makeLog$default$1();
        long x$69 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$68, x$67, x$69);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log2, producerId, producerEpoch);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log2.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, false);
        log2.roll(log2.roll$default$1());
        this.assertAbortedTransactionIndexed$1(log2, producerId);
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        this.assertAbortedTransactionIndexed$1(log2, producerId);
        Assert.assertEquals((Object)Nil$.MODULE$, this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.lastOffsetsPerBatchInLog(log2));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        this.assertAbortedTransactionIndexed$1(log2, producerId);
        Assert.assertEquals((Object)Nil$.MODULE$, this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.lastOffsetsPerBatchInLog(log2));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log2.roll(log2.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        this.assertAbortedTransactionIndexed$1(log2, producerId);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.lastOffsetsPerBatchInLog(log2));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.lastOffsetsPerBatchInLog(log2));
        Assert.assertEquals((long)0L, (long)log2.collectAbortedTransactions(0L, 100L).size());
    }

    @Test
    public void testLargeMessage() {
        int largeMessageSize = 0x100000;
        int x$70 = Integer.MAX_VALUE;
        int x$71 = 1024;
        Function1<TopicPartition, BoxedUnit> x$72 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(x$70, x$72, x$71);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 16));
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 2));
        LogConfig x$73 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$74 = this.makeLog$default$1();
        long x$75 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$74, x$73, x$75);
        while (log2.numberOfSegments() < 2) {
            log2.appendAsLeader(this.record((int)log2.logEndOffset(), (byte[])Array$.MODULE$.fill(largeMessageSize, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte apply() {
                    return this.apply$mcB$sp();
                }

                public byte apply$mcB$sp() {
                    return 0;
                }
            }, ClassTag$.MODULE$.Byte())), 0, log2.appendAsLeader$default$3());
        }
        Iterable<Object> keysFound = this.keysInLog(log2);
        Assert.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log2.logEndOffset())), keysFound);
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 5, 7, 9}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap map$2;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.map$2.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$2 = map$2;
            }
        });
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner.cleanSegments(log2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)log2.logSegments().head()})), (OffsetMap)map, 0L, stats);
        Iterable shouldRemain = (Iterable)this.keysInLog(log2).filter((Function1)new Serializable(this, keys){
            public static final long serialVersionUID = 0L;
            private final ListSet keys$2;

            public final boolean apply(int x$3) {
                return this.apply$mcZI$sp(x$3);
            }

            public boolean apply$mcZI$sp(int x$3) {
                return !this.keys$2.contains((Object)BoxesRunTime.boxToInteger((int)x$3));
            }
            {
                this.keys$2 = keys$2;
            }
        });
        Assert.assertEquals((Object)shouldRemain, this.keysInLog(log2));
    }

    @Test
    public void testCleaningWithDeletes() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$76 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$77 = this.makeLog$default$1();
        long x$78 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$77, x$76, x$78);
        while (log2.numberOfSegments() < 2) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        }
        long leo = log2.logEndOffset();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).foreach((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$4;

            public final LogAppendInfo apply(int key) {
                return this.log$4.appendAsLeader(this.$outer.kafka$log$LogCleanerTest$$tombstoneRecord(key), 0, this.log$4.appendAsLeader$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$4 = log$4;
            }
        });
        while (log2.numberOfSegments() < 4) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        }
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        Set keys = this.keysInLog(log2).toSet();
        Assert.assertTrue((String)"None of the keys we deleted should still exist.", (boolean)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).forall((Function1)new Serializable(this, keys){
            public static final long serialVersionUID = 0L;
            private final Set keys$3;

            public final boolean apply(int x$4) {
                return this.apply$mcZI$sp(x$4);
            }

            public boolean apply$mcZI$sp(int x$4) {
                return !this.keys$3.contains((Object)BoxesRunTime.boxToInteger((int)x$4));
            }
            {
                this.keys$3 = keys$3;
            }
        }));
    }

    public void testLogCleanerStats() {
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$79 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$80 = this.makeLog$default$1();
        long x$81 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$80, x$79, x$81);
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        long initialLogSize = log2.size();
        Tuple2 tuple2 = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 2L, log2.activeSegment().baseOffset()));
        if (tuple2 != null) {
            Tuple2 tuple22;
            long endOffset = tuple2._1$mcJ$sp();
            CleanerStats stats = (CleanerStats)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)endOffset), (Object)stats);
            long endOffset2 = tuple23._1$mcJ$sp();
            CleanerStats stats2 = (CleanerStats)tuple23._2();
            Assert.assertEquals((long)5L, (long)endOffset2);
            Assert.assertEquals((long)5L, (long)stats2.messagesRead());
            Assert.assertEquals((long)initialLogSize, (long)stats2.bytesRead());
            Assert.assertEquals((long)2L, (long)stats2.messagesWritten());
            Assert.assertEquals((long)log2.size(), (long)stats2.bytesWritten());
            Assert.assertEquals((long)0L, (long)stats2.invalidMessagesRead());
            Assert.assertTrue((stats2.endTime() >= stats2.startTime() ? 1 : 0) != 0);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testLogCleanerRetainsProducerLastSequence() {
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$82 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$83 = this.makeLog$default$1();
        long x$84 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$83, x$82, x$84);
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 1, 1L, (short)0, 0, this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 2, 2L, (short)0, 0, this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 3, 3L, (short)0, 0, this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, 2L, (short)0, 1, this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), this.lastOffsetsPerBatchInLog(log2));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1L)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)2L)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)3L)), (Object)BoxesRunTime.boxToInteger((int)0))})), this.lastSequencesInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log2));
    }

    @Test
    public void testLogCleanerRetainsLastSequenceEvenIfTransactionAborted() {
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$85 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$86 = this.makeLog$default$1();
        long x$87 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$86, x$85, x$87);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log2, producerId, producerEpoch);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log2.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, false);
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.lastOffsetsPerBatchInLog(log2));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)producerId)), (Object)BoxesRunTime.boxToInteger((int)2))})), this.lastSequencesInLog(log2));
        Assert.assertEquals((Object)Nil$.MODULE$, this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.offsetsInLog(log2));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5})));
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 5})), this.lastOffsetsPerBatchInLog(log2));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)producerId)), (Object)BoxesRunTime.boxToInteger((int)4))})), this.lastSequencesInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log2));
    }

    @Test
    public void testPartialSegmentClean() {
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$88 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$89 = this.makeLog$default$1();
        long x$90 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$89, x$88, x$90);
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 2L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0, 1, 0})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), this.offsetsInLog(log2));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 3L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 0})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), this.offsetsInLog(log2));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 4L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})), this.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log2));
    }

    @Test
    public void testCleaningWithUncleanableSection() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$91 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$92 = this.makeLog$default$1();
        long x$93 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$92, x$91, x$93);
        int N = 10;
        int numCleanableSegments = 2;
        int numTotalSegments = 7;
        while (log2.numberOfSegments() <= numCleanableSegments) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset() % N, (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        }
        long firstUncleanableOffset = log2.logEndOffset() + 1L;
        while (log2.numberOfSegments() < numTotalSegments - 1) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset() % N, (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        }
        Seq disctinctValuesBySegmentBeforeClean = this.distinctValuesBySegment$1(log2);
        Assert.assertTrue((String)"Test is not effective unless each segment contains duplicates. Increase segment size or decrease number of keys.", (boolean)((IterableLike)((TraversableLike)this.distinctValuesBySegment$1(log2).reverse()).tail()).forall((Function1)new Serializable(this, N){
            public static final long serialVersionUID = 0L;
            private final int N$1;

            public final boolean apply(int x$6) {
                return this.apply$mcZI$sp(x$6);
            }

            public boolean apply$mcZI$sp(int x$6) {
                return x$6 > this.N$1;
            }
            {
                this.N$1 = N$1;
            }
        }));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, firstUncleanableOffset));
        Seq distinctValuesBySegmentAfterClean = this.distinctValuesBySegment$1(log2);
        Assert.assertTrue((String)"The cleanable segments should have fewer number of values after cleaning", (boolean)((IterableLike)((IterableLike)disctinctValuesBySegmentBeforeClean.zip((GenIterable)distinctValuesBySegmentAfterClean, Seq$.MODULE$.canBuildFrom())).take(numCleanableSegments)).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    int before = tuple2._1$mcI$sp();
                    int after = tuple2._2$mcI$sp();
                    boolean bl = after < before;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        }));
        Assert.assertTrue((String)"The uncleanable segments should have the same number of values after cleaning", (boolean)((IterableLike)((IterableLike)disctinctValuesBySegmentBeforeClean.zip((GenIterable)distinctValuesBySegmentAfterClean, Seq$.MODULE$.canBuildFrom())).slice(numCleanableSegments, numTotalSegments)).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> x) {
                return x._1$mcI$sp() == x._2$mcI$sp();
            }
        }));
    }

    @Test
    public void testLogToClean() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        LogConfig x$94 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$95 = this.makeLog$default$1();
        long x$96 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$95, x$94, x$96);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$6;

            public final LogAppendInfo apply(int _) {
                return this.log$6.appendAsLeader(this.$outer.kafka$log$LogCleanerTest$$createRecorcs$1(), 0, this.log$6.appendAsLeader$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$6 = log$6;
            }
        });
        LogToClean logToClean = new LogToClean(new TopicPartition("test", 0), log2, log2.activeSegment().baseOffset(), log2.activeSegment().baseOffset());
        Assert.assertEquals((String)"Total bytes of LogToClean should equal size of all segments excluding the active segment", (long)logToClean.totalBytes(), (long)(log2.size() - (long)log2.activeSegment().size()));
    }

    @Test
    public void testLogToCleanWithUncleanableSection() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        LogConfig x$97 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$98 = this.makeLog$default$1();
        long x$99 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$98, x$97, x$99);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$7;

            public final LogAppendInfo apply(int _) {
                return this.log$7.appendAsLeader(this.$outer.kafka$log$LogCleanerTest$$createRecords$1(), 0, this.log$7.appendAsLeader$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$7 = log$7;
            }
        });
        Seq segs = log2.logSegments().toSeq();
        LogToClean logToClean = new LogToClean(new TopicPartition("test", 0), log2, ((LogSegment)segs.apply(2)).baseOffset(), ((LogSegment)segs.apply(4)).baseOffset());
        int expectedCleanSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)segs.take(2)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$7) {
                return x$7.size();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int expectedCleanableSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)segs.slice(2, 4)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$8) {
                return x$8.size();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertEquals((String)"Uncleanable bytes of LogToClean should equal size of all segments prior the one containing first dirty", (long)logToClean.cleanBytes(), (long)expectedCleanSize);
        Assert.assertEquals((String)"Cleanable bytes of LogToClean should equal size of all segments from the one containing first dirty offset to the segment prior to the one with the first uncleanable offset", (long)logToClean.cleanableBytes(), (long)expectedCleanableSize);
        Assert.assertEquals((String)"Total bytes should be the sum of the clean and cleanable segments", (long)logToClean.totalBytes(), (long)(expectedCleanSize + expectedCleanableSize));
        Assert.assertEquals((String)"Total cleanable ratio should be the ratio of cleanable size to clean plus cleanable", (double)logToClean.cleanableRatio(), (double)((double)expectedCleanableSize / (double)(expectedCleanSize + expectedCleanableSize)), (double)1.0E-6);
    }

    @Test
    public void testCleaningWithUnkeyedMessages() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        LogConfig x$100 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$101 = this.makeLog$default$1();
        long x$102 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$101, x$100, x$102);
        while (log2.numberOfSegments() < 2) {
            log2.appendAsLeader(this.unkeyedRecord((int)log2.logEndOffset()), 0, log2.appendAsLeader$default$3());
        }
        int numInvalidMessages = this.unkeyedMessageCountInLog(log2);
        long sizeWithUnkeyedMessages = log2.size();
        while (log2.numberOfSegments() < 3) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        }
        long expectedSizeAfterCleaning = log2.size() - sizeWithUnkeyedMessages;
        Tuple2 tuple2 = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        if (tuple2 != null) {
            CleanerStats stats;
            CleanerStats cleanerStats;
            CleanerStats stats2 = cleanerStats = (stats = (CleanerStats)tuple2._2());
            Assert.assertEquals((String)"Log should only contain keyed messages after cleaning.", (long)0L, (long)this.unkeyedMessageCountInLog(log2));
            Assert.assertEquals((String)"Log should only contain keyed messages after cleaning.", (long)expectedSizeAfterCleaning, (long)log2.size());
            Assert.assertEquals((String)"Cleaner should have seen %d invalid messages.", (long)numInvalidMessages, (long)stats2.invalidMessagesRead());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public Iterable<Object> keysInLog(Log log2) {
        return (Iterable)log2.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Object> apply(LogSegment segment) {
                return (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(FileLogInputStream.FileChannelRecordBatch batch) {
                        return !batch.isControlBatch();
                    }
                }).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<Object> apply(FileLogInputStream.FileChannelRecordBatch batch) {
                        return (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).withFilter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Record record) {
                                return record.hasValue() && record.hasKey();
                            }
                        }).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(Record record) {
                                return new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
                            }
                        }, Iterable$.MODULE$.canBuildFrom());
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public Iterable<Object> lastOffsetsPerBatchInLog(Log log2) {
        return (Iterable)log2.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Object> apply(LogSegment segment) {
                return (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(FileLogInputStream.FileChannelRecordBatch batch) {
                        return batch.lastOffset();
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public Map<Object, Object> lastSequencesInLog(Log log2) {
        return ((TraversableOnce)log2.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Tuple2<Object, Object>> apply(LogSegment segment) {
                return (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(FileLogInputStream.FileChannelRecordBatch batch) {
                        return !batch.isControlBatch() && batch.hasProducerId();
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(FileLogInputStream.FileChannelRecordBatch batch) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)batch.producerId())), (Object)BoxesRunTime.boxToInteger((int)batch.lastSequence()));
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Iterable<Object> offsetsInLog(Log log2) {
        return (Iterable)log2.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Object> apply(LogSegment s) {
                return (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Record x$9) {
                        return x$9.hasValue();
                    }
                })).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Record x$10) {
                        return x$10.hasKey();
                    }
                })).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(Record m) {
                        return m.offset();
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public int unkeyedMessageCountInLog(Log log2) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)log2.logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment s) {
                return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Record x$11) {
                        return x$11.hasValue();
                    }
                })).count((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Record m) {
                        return !m.hasKey();
                    }
                });
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public void abortCheckDone(TopicPartition topicPartition) {
        throw new LogCleaningAbortedException();
    }

    @Test
    public void testCleanSegmentsWithAbort() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, (Function1<TopicPartition, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;

            public final void apply(TopicPartition topicPartition) {
                this.$outer.abortCheckDone(topicPartition);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$103 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$104 = this.makeLog$default$1();
        long x$105 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$104, x$103, x$105);
        while (log2.numberOfSegments() < 4) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        }
        Iterable<Object> keys = this.keysInLog(log2);
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap map$3;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.map$3.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$3 = map$3;
            }
        });
        this.intercept((Function0)new Serializable(this, cleaner, log2, map){
            public static final long serialVersionUID = 0L;
            private final Cleaner cleaner$1;
            private final Log log$8;
            private final FakeOffsetMap map$3;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.cleaner$1.cleanSegments(this.log$8, ((TraversableOnce)this.log$8.logSegments().take(3)).toSeq(), (OffsetMap)this.map$3, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
            }
            {
                this.cleaner$1 = cleaner$1;
                this.log$8 = log$8;
                this.map$3 = map$3;
            }
        }, ClassTag$.MODULE$.apply(LogCleaningAbortedException.class), new Position("LogCleanerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 780));
    }

    @Test
    public void testSegmentGrouping() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig x$106 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$107 = this.makeLog$default$1();
        long x$108 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$107, x$106, x$108);
        int i = 0;
        while (log2.numberOfSegments() < 10) {
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3());
            ++i;
        }
        List groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log2.logEndOffset());
        Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertEquals((long)log2.numberOfSegments(), (long)((SeqLike)groups.head()).size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log2.logSegments(), 1, Integer.MAX_VALUE, log2.logEndOffset());
        Assert.assertEquals((long)log2.numberOfSegments(), (long)groups.size());
        Assert.assertTrue((String)"All groups should be singletons.", (boolean)groups.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<LogSegment> x$12) {
                return x$12.size() == 1;
            }
        }));
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, 1, log2.logEndOffset());
        Assert.assertEquals((long)log2.numberOfSegments(), (long)groups.size());
        Assert.assertTrue((String)"All groups should be singletons.", (boolean)groups.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<LogSegment> x$13) {
                return x$13.size() == 1;
            }
        }));
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        int groupSize = 3;
        int logSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)log2.logSegments().take(groupSize)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$14) {
                return x$14.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log2.logSegments(), logSize, Integer.MAX_VALUE, log2.logEndOffset());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assert.assertTrue((String)"All but the last group should be the target size.", (boolean)groups.dropRight(1).forall((Function1)new Serializable(this, groupSize){
            public static final long serialVersionUID = 0L;
            private final int groupSize$1;

            public final boolean apply(Seq<LogSegment> x$15) {
                return x$15.size() == this.groupSize$1;
            }
            {
                this.groupSize$1 = groupSize$1;
            }
        }));
        int indexSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)log2.logSegments().take(groupSize)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$16) {
                return x$16.index().sizeInBytes();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, indexSize, log2.logEndOffset());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assert.assertTrue((String)"All but the last group should be the target size.", (boolean)groups.dropRight(1).forall((Function1)new Serializable(this, groupSize){
            public static final long serialVersionUID = 0L;
            private final int groupSize$1;

            public final boolean apply(Seq<LogSegment> x$17) {
                return x$17.size() == this.groupSize$1;
            }
            {
                this.groupSize$1 = groupSize$1;
            }
        }));
    }

    @Test
    public void testSegmentGroupingWithSparseOffsets() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(400));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig x$109 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$110 = this.makeLog$default$1();
        long x$111 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$110, x$109, x$111);
        while (log2.numberOfSegments() == 1) {
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3());
        }
        MemoryRecords records2 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0x7FFFFFFEL);
        log2.appendAsFollower(records2);
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)log2.activeSegment().index().lastOffset());
        List groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log2.logEndOffset());
        Assert.assertEquals((long)1L, (long)groups.size());
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3());
        groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log2.logEndOffset());
        Assert.assertEquals((long)2L, (long)groups.size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        while (log2.numberOfSegments() < 4) {
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3());
        }
        groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log2.logEndOffset());
        Assert.assertEquals((long)(log2.numberOfSegments() - 1), (long)groups.size());
        groups.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<LogSegment> group) {
                Assert.assertTrue((String)"Relative offset greater than Int.MaxValue", (((LogSegment)group.last()).index().lastOffset() - ((LogSegment)group.head()).index().baseOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0);
            }
        });
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
    }

    @Test
    public void testSegmentGroupingFollowingLoadOfZeroIndex() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(400));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(400));
        LogConfig x$112 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$113 = this.makeLog$default$1();
        long x$114 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$113, x$112, x$114);
        MemoryRecords record1 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0L);
        log2.appendAsFollower(record1);
        MemoryRecords record2 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 1L);
        log2.appendAsFollower(record2);
        log2.roll(0x3FFFFFFFL);
        MemoryRecords record3 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0x3FFFFFFFL);
        log2.appendAsFollower(record3);
        MemoryRecords record4 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), (long)Integer.MAX_VALUE + 1L);
        log2.appendAsFollower(record4);
        Assert.assertTrue((String)"Actual offset range should be > Int.MaxValue", (log2.logEndOffset() - 1L - log2.logStartOffset() > Integer.MAX_VALUE ? 1 : 0) != 0);
        Assert.assertTrue((String)"index.lastOffset is reporting the wrong last offset", (((LogSegment)log2.logSegments().last()).index().lastOffset() - log2.logStartOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0);
        List groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log2.logEndOffset());
        Assert.assertEquals((long)2L, (long)groups.size());
        groups.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<LogSegment> group) {
                Assert.assertTrue((String)"Relative offset greater than Int.MaxValue", (((LogSegment)group.last()).nextOffset() - 1L - ((LogSegment)group.head()).baseOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0);
            }
        });
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
    }

    private void checkSegmentOrder(Seq<Seq<LogSegment>> groups) {
        Seq offsets = (Seq)groups.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Seq<LogSegment> x$18) {
                return (Seq)x$18.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(LogSegment x$19) {
                        return x$19.baseOffset();
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((String)"Offsets should be in increasing order.", (Object)offsets.sorted((Ordering)Ordering.Long$.MODULE$), (Object)offsets);
    }

    @Test
    public void testBuildOffsetMap() {
        FakeOffsetMap map = new FakeOffsetMap(1000);
        Log log2 = this.makeLog(this.makeLog$default$1(), this.makeLog$default$2(), this.makeLog$default$3());
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        int start2 = 0;
        int end = 500;
        this.writeToLog(log2, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start2), end).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start2), end), IndexedSeq$.MODULE$.canBuildFrom())));
        Seq segments = log2.logSegments().toSeq();
        this.checkRange$1(map, 0, (int)((LogSegment)segments.apply(1)).baseOffset(), log2, cleaner);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(1)).baseOffset(), (int)((LogSegment)segments.apply(3)).baseOffset(), log2, cleaner);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(3)).baseOffset(), (int)log2.logEndOffset(), log2, cleaner);
    }

    @Test
    public void testRecoveryAfterCrash() {
        LogConfig config;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(10));
        LogConfig x$118 = config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$119 = this.makeLog$default$1();
        long x$120 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$119, x$118, x$120);
        int messageCount = 0;
        while (log2.numberOfSegments() < 10) {
            Log qual$3 = log2;
            MemoryRecords x$121 = this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6());
            int x$122 = 0;
            boolean x$123 = qual$3.appendAsLeader$default$3();
            qual$3.appendAsLeader(x$121, x$122, x$123);
            ++messageCount;
        }
        Iterable<Object> allKeys = this.keysInLog(log2);
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)new Serializable(this, offsetMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap offsetMap$1;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.offsetMap$1.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offsetMap$1 = offsetMap$1;
            }
        });
        cleaner.cleanSegments(log2, ((TraversableOnce)log2.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        Iterable<Object> cleanedKeys = this.keysInLog(log2);
        ((LogSegment)log2.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.CleanedFileSuffix());
        Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File file) {
                Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]));
            }
        });
        log2 = this.recoverAndCheck$1(config, allKeys);
        cleaner.cleanSegments(log2, ((TraversableOnce)log2.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        cleanedKeys = this.keysInLog(log2);
        ((LogSegment)log2.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File file) {
                Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]));
            }
        });
        log2 = this.recoverAndCheck$1(config, cleanedKeys);
        while (log2.numberOfSegments() < 10) {
            Log qual$4 = log2;
            MemoryRecords x$124 = this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6());
            int x$125 = 0;
            boolean x$126 = qual$4.appendAsLeader$default$3();
            qual$4.appendAsLeader(x$124, x$125, x$126);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)new Serializable(this, offsetMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap offsetMap$1;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.offsetMap$1.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offsetMap$1 = offsetMap$1;
            }
        });
        cleaner.cleanSegments(log2, ((TraversableOnce)log2.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        cleanedKeys = this.keysInLog(log2);
        ((LogSegment)log2.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        log2 = this.recoverAndCheck$1(config, cleanedKeys);
        while (log2.numberOfSegments() < 10) {
            Log qual$5 = log2;
            MemoryRecords x$127 = this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6());
            int x$128 = 0;
            boolean x$129 = qual$5.appendAsLeader$default$3();
            qual$5.appendAsLeader(x$127, x$128, x$129);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)new Serializable(this, offsetMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap offsetMap$1;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.offsetMap$1.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offsetMap$1 = offsetMap$1;
            }
        });
        cleaner.cleanSegments(log2, ((TraversableOnce)log2.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        cleanedKeys = this.keysInLog(log2);
        this.recoverAndCheck$1(config, cleanedKeys);
    }

    @Test
    public void testBuildOffsetMapFakeLarge() {
        LogConfig logConfig;
        FakeOffsetMap map = new FakeOffsetMap(1000);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(120));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(120));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        LogConfig x$130 = logConfig = new LogConfig((java.util.Map)logProps);
        File x$131 = this.makeLog$default$1();
        long x$132 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$131, x$130, x$132);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        int start2 = 0;
        int end = 2;
        Seq offsetSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 7206178L}));
        this.writeToLog(log2, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start2), end).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start2), end), IndexedSeq$.MODULE$.canBuildFrom())), (Iterable<Object>)offsetSeq);
        cleaner.buildOffsetMap(log2, (long)start2, (long)end, (OffsetMap)map, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        long endOffset = map.latestOffset();
        Assert.assertEquals((String)"Last offset should be the end offset.", (long)7206178L, (long)endOffset);
        Assert.assertEquals((String)"Should have the expected number of messages in the map.", (long)(end - start2), (long)map.size());
        Assert.assertEquals((String)"Map should contain first value", (long)0L, (long)map.get(this.kafka$log$LogCleanerTest$$key(0)));
        Assert.assertEquals((String)"Map should contain second value", (long)7206178L, (long)map.get(this.kafka$log$LogCleanerTest$$key(1)));
    }

    @Test
    public void testBuildPartialOffsetMap() {
        FakeOffsetMap map = new FakeOffsetMap(3);
        Log log2 = this.makeLog(this.makeLog$default$1(), this.makeLog$default$2(), this.makeLog$default$3());
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(2, 2, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(3, 3, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(4, 4, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner.buildOffsetMap(log2, 2L, Integer.MAX_VALUE, (OffsetMap)map, stats);
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((long)-1L, (long)map.get(this.kafka$log$LogCleanerTest$$key(0)));
        Assert.assertEquals((long)2L, (long)map.get(this.kafka$log$LogCleanerTest$$key(2)));
        Assert.assertEquals((long)3L, (long)map.get(this.kafka$log$LogCleanerTest$$key(3)));
        Assert.assertEquals((long)-1L, (long)map.get(this.kafka$log$LogCleanerTest$$key(4)));
        Assert.assertEquals((long)4L, (long)stats.mapMessagesRead());
    }

    @Test
    public void testCleanCorruptMessageSet() {
        LogConfig logConfig;
        CompressionType codec = CompressionType.GZIP;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CompressionTypeProp(), codec.name);
        LogConfig x$133 = logConfig = new LogConfig((java.util.Map)logProps);
        File x$134 = this.makeLog$default$1();
        long x$135 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$134, x$133, x$135);
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        IndexedSeq dupSetKeys = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2), IndexedSeq$.MODULE$.canBuildFrom());
        int dupSetOffset = 25;
        IndexedSeq dupSet = (IndexedSeq)dupSetKeys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(dupSetOffset), dupSetOffset + dupSetKeys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        Range noDupSetKeys = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(3), 5);
        int noDupSetOffset = 50;
        IndexedSeq noDupSet = (IndexedSeq)noDupSetKeys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(noDupSetOffset), noDupSetOffset + noDupSetKeys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        log2.appendAsFollower(this.invalidCleanedMessage(dupSetOffset, (Iterable<Tuple2<Object, Object>>)dupSet, codec));
        log2.appendAsFollower(this.invalidCleanedMessage(noDupSetOffset, (Iterable<Tuple2<Object, Object>>)noDupSet, codec));
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        log2.logSegments().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(LogSegment segment) {
                ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(FileLogInputStream.FileChannelRecordBatch batch) {
                        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1)new Serializable(this, batch){
                            public static final long serialVersionUID = 0L;
                            private final FileLogInputStream.FileChannelRecordBatch batch$1;

                            public final void apply(Record record) {
                                Assert.assertTrue((boolean)record.hasMagic(this.batch$1.magic()));
                                long value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()))).toLong();
                                Assert.assertEquals((long)record.offset(), (long)value);
                            }
                            {
                                this.batch$1 = batch$1;
                            }
                        });
                    }
                });
            }
        });
    }

    @Test
    public void testClientHandlingOfCorruptMessageSet() {
        Range keys = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 10);
        int offset = 50;
        IndexedSeq set = (IndexedSeq)keys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(offset), offset + keys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        MemoryRecords corruptedMessage = this.invalidCleanedMessage(offset, (Iterable<Tuple2<Object, Object>>)set, this.invalidCleanedMessage$default$3());
        MemoryRecords records2 = MemoryRecords.readableRecords((ByteBuffer)corruptedMessage.buffer());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Record logEntry) {
                long offset = logEntry.offset();
                long value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(logEntry.value(), TestUtils$.MODULE$.readString$default$2()))).toLong();
                Assert.assertEquals((long)offset, (long)value);
            }
        });
    }

    @Test
    public void testCleanTombstone() {
        LogConfig logConfig;
        LogConfig x$136 = logConfig = new LogConfig((java.util.Map)new Properties());
        File x$137 = this.makeLog$default$1();
        long x$138 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$137, x$136, x$138);
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        byte[] x$139 = "0".getBytes();
        byte[] x$140 = "0".getBytes();
        long x$141 = this.time().milliseconds() + Predef$.MODULE$.Long2long(logConfig.deleteRetentionMs()) + 10000L;
        CompressionType x$142 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$143 = TestUtils$.MODULE$.singletonRecords$default$5();
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$139, x$140, x$142, x$141, x$143), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        byte[] x$144 = null;
        byte[] x$145 = "0".getBytes();
        long x$146 = this.time().milliseconds() - Predef$.MODULE$.Long2long(logConfig.deleteRetentionMs()) - 10000L;
        CompressionType x$147 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$148 = TestUtils$.MODULE$.singletonRecords$default$5();
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$144, x$145, x$147, x$146, x$148), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 1L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((String)"The tombstone should be retained.", (long)1L, (long)((RecordBatch)((LogSegment)log2.logSegments().head()).log().batches().iterator().next()).lastOffset());
        byte[] x$149 = "1".getBytes();
        byte[] x$150 = "1".getBytes();
        long x$151 = this.time().milliseconds();
        CompressionType x$152 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$153 = TestUtils$.MODULE$.singletonRecords$default$5();
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$149, x$150, x$152, x$151, x$153), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 2L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((String)"The tombstone should be retained.", (long)1L, (long)((RecordBatch)((LogSegment)log2.logSegments().head()).log().batches().iterator().next()).lastOffset());
    }

    private Iterable<Object> writeToLog(Log log2, Iterable<Tuple2<Object, Object>> keysAndValues, Iterable<Object> offsetSeq) {
        return (Iterable)((TraversableLike)keysAndValues.zip(offsetSeq, Iterable$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Tuple2<Object, Object>, Object> check$ifrefutable$1) {
                Tuple2 tuple2;
                Tuple2<Tuple2<Object, Object>, Object> tuple22 = check$ifrefutable$1;
                boolean bl = tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null;
                return bl;
            }
        }).map((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$11;

            public final long apply(Tuple2<Tuple2<Object, Object>, Object> x$20) {
                Tuple2<Tuple2<Object, Object>, Object> tuple2 = x$20;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    if (tuple22 != null) {
                        int key = tuple22._1$mcI$sp();
                        int value = tuple22._2$mcI$sp();
                        long l = this.log$11.appendAsFollower(this.$outer.kafka$log$LogCleanerTest$$messageWithOffset(key, value, offset)).lastOffset();
                        return l;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$11 = log$11;
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    private MemoryRecords invalidCleanedMessage(long initialOffset, Iterable<Tuple2<Object, Object>> keysAndValues, CompressionType codec) {
        Iterable records2 = (Iterable)keysAndValues.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LegacyRecord apply(Tuple2<Object, Object> kv) {
                return LegacyRecord.create((byte)0, (long)-1L, (byte[])((Object)BoxesRunTime.boxToInteger((int)kv._1$mcI$sp())).toString().getBytes(), (byte[])((Object)BoxesRunTime.boxToInteger((int)kv._2$mcI$sp())).toString().getBytes());
            }
        }, Iterable$.MODULE$.canBuildFrom());
        ByteBuffer buffer = ByteBuffer.allocate(package$.MODULE$.min(package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)((TraversableOnce)records2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LegacyRecord x$21) {
                return x$21.sizeInBytes();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / 2, 1024), 65536));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)1, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)initialOffset);
        LongRef offset = LongRef.create((long)initialOffset);
        records2.foreach((Function1)new Serializable(this, builder, offset){
            public static final long serialVersionUID = 0L;
            private final MemoryRecordsBuilder builder$1;
            private final LongRef offset$1;

            public final void apply(LegacyRecord record) {
                this.builder$1.appendUncheckedWithOffset(this.offset$1.elem, record);
                ++this.offset$1.elem;
            }
            {
                this.builder$1 = builder$1;
                this.offset$1 = offset$1;
            }
        });
        return builder.build();
    }

    private CompressionType invalidCleanedMessage$default$3() {
        return CompressionType.GZIP;
    }

    private MemoryRecords messageWithOffset(byte[] key, byte[] value, long offset) {
        return MemoryRecords.withRecords((long)offset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(key, value)});
    }

    public MemoryRecords kafka$log$LogCleanerTest$$messageWithOffset(int key, int value, long offset) {
        return this.messageWithOffset(((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes(), offset);
    }

    private Log makeLog(File dir, LogConfig config, long recoveryPoint) {
        File x$29 = dir;
        LogConfig x$30 = config;
        long x$31 = 0L;
        long x$32 = recoveryPoint;
        MockScheduler x$33 = this.time().scheduler();
        MockTime x$34 = this.time();
        BrokerTopicStats x$35 = new BrokerTopicStats();
        int x$36 = Log$.MODULE$.apply$default$8();
        int x$37 = Log$.MODULE$.apply$default$9();
        return Log$.MODULE$.apply(x$29, x$30, x$31, x$32, (Scheduler)x$33, x$35, (Time)x$34, x$36, x$37);
    }

    private File makeLog$default$1() {
        return this.dir();
    }

    private LogConfig makeLog$default$2() {
        return this.logConfig();
    }

    private long makeLog$default$3() {
        return 0L;
    }

    public void kafka$log$LogCleanerTest$$noOpCheckDone(TopicPartition topicPartition) {
    }

    private Cleaner makeCleaner(int capacity, Function1<TopicPartition, BoxedUnit> checkDone, int maxMessageSize) {
        return new Cleaner(0, (OffsetMap)new FakeOffsetMap(capacity), maxMessageSize, maxMessageSize, 0.75, this.throttler(), (Time)this.time(), checkDone);
    }

    private Function1<TopicPartition, BoxedUnit> makeCleaner$default$2() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;

            public final void apply(TopicPartition topicPartition) {
                this.$outer.kafka$log$LogCleanerTest$$noOpCheckDone(topicPartition);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    private int makeCleaner$default$3() {
        return 65536;
    }

    private Iterable<Object> writeToLog(Log log2, Iterable<Tuple2<Object, Object>> seq) {
        return (Iterable)seq.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> check$ifrefutable$2) {
                Tuple2<Object, Object> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).map((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$10;

            public final long apply(Tuple2<Object, Object> x$22) {
                Tuple2<Object, Object> tuple2 = x$22;
                if (tuple2 != null) {
                    int key = tuple2._1$mcI$sp();
                    int value = tuple2._2$mcI$sp();
                    long l = this.log$10.appendAsLeader(this.$outer.kafka$log$LogCleanerTest$$record(key, value, this.$outer.kafka$log$LogCleanerTest$$record$default$3(), this.$outer.kafka$log$LogCleanerTest$$record$default$4(), this.$outer.kafka$log$LogCleanerTest$$record$default$5(), this.$outer.kafka$log$LogCleanerTest$$record$default$6()), 0, this.log$10.appendAsLeader$default$3()).firstOffset();
                    return l;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$10 = log$10;
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public ByteBuffer kafka$log$LogCleanerTest$$key(int id) {
        return ByteBuffer.wrap(((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
    }

    public MemoryRecords kafka$log$LogCleanerTest$$record(int key, int value, long producerId, short producerEpoch, int sequence, int partitionLeaderEpoch) {
        return MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes())});
    }

    private Function1<Seq<Object>, LogAppendInfo> appendTransactionalAsLeader(Log log2, long producerId, short producerEpoch) {
        return this.appendIdempotentAsLeader(log2, producerId, producerEpoch, true);
    }

    private short appendTransactionalAsLeader$default$3() {
        return 0;
    }

    private Function1<Seq<Object>, LogAppendInfo> appendIdempotentAsLeader(Log log2, long producerId, short producerEpoch, boolean isTransactional) {
        IntRef sequence = IntRef.create((int)0);
        return new Serializable(this, log2, producerId, producerEpoch, isTransactional, sequence){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$2;
            private final long producerId$1;
            private final short producerEpoch$1;
            private final boolean isTransactional$1;
            private final IntRef sequence$1;

            public final LogAppendInfo apply(Seq<Object> keys) {
                Seq simpleRecords = (Seq)keys.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$appendIdempotentAsLeader$1 $outer;

                    public final SimpleRecord apply(int key) {
                        byte[] keyBytes = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
                        return new SimpleRecord(this.$outer.kafka$log$LogCleanerTest$$anonfun$$$outer().time().milliseconds(), keyBytes, keyBytes);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                MemoryRecords records2 = this.isTransactional$1 ? MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)this.producerId$1, (short)this.producerEpoch$1, (int)this.sequence$1.elem, (SimpleRecord[])((SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))) : MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)this.producerId$1, (short)this.producerEpoch$1, (int)this.sequence$1.elem, (SimpleRecord[])((SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
                this.sequence$1.elem += simpleRecords.size();
                return this.log$2.appendAsLeader(records2, 0, this.log$2.appendAsLeader$default$3());
            }

            public /* synthetic */ LogCleanerTest kafka$log$LogCleanerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$2 = log$2;
                this.producerId$1 = producerId$1;
                this.producerEpoch$1 = producerEpoch$1;
                this.isTransactional$1 = isTransactional$1;
                this.sequence$1 = sequence$1;
            }
        };
    }

    private short appendIdempotentAsLeader$default$3() {
        return 0;
    }

    private boolean appendIdempotentAsLeader$default$4() {
        return false;
    }

    private MemoryRecords commitMarker(long producerId, short producerEpoch, long timestamp) {
        return this.endTxnMarker(producerId, producerEpoch, ControlRecordType.COMMIT, 0L, timestamp);
    }

    private long commitMarker$default$3() {
        return this.time().milliseconds();
    }

    private MemoryRecords abortMarker(long producerId, short producerEpoch, long timestamp) {
        return this.endTxnMarker(producerId, producerEpoch, ControlRecordType.ABORT, 0L, timestamp);
    }

    private long abortMarker$default$3() {
        return this.time().milliseconds();
    }

    private MemoryRecords endTxnMarker(long producerId, short producerEpoch, ControlRecordType controlRecordType, long offset, long timestamp) {
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlRecordType, 0);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)-1, (long)producerId, (short)producerEpoch, (EndTransactionMarker)endTxnMarker);
    }

    private MemoryRecords record(int key, byte[] value) {
        byte[] x$154 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
        byte[] x$155 = value;
        CompressionType x$156 = TestUtils$.MODULE$.singletonRecords$default$3();
        long x$157 = TestUtils$.MODULE$.singletonRecords$default$4();
        byte x$158 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(x$155, x$154, x$156, x$157, x$158);
    }

    public long kafka$log$LogCleanerTest$$record$default$3() {
        return -1L;
    }

    public short kafka$log$LogCleanerTest$$record$default$4() {
        return -1;
    }

    public int kafka$log$LogCleanerTest$$record$default$5() {
        return -1;
    }

    public int kafka$log$LogCleanerTest$$record$default$6() {
        return -1;
    }

    private MemoryRecords unkeyedRecord(int value) {
        return TestUtils$.MODULE$.singletonRecords(((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    public MemoryRecords kafka$log$LogCleanerTest$$tombstoneRecord(int key) {
        return this.record(key, null);
    }

    private final void reloadLog$1(Properties logProps$1, ObjectRef log$1) {
        ((Log)log$1.elem).close();
        LogConfig x$48 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps$1);
        long x$49 = 0L;
        File x$50 = this.makeLog$default$1();
        log$1.elem = this.makeLog(x$50, x$48, x$49);
    }

    private final void assertAbortedTransactionIndexed$1(Log log$3, long producerId$2) {
        List abortedTxns = log$3.collectAbortedTransactions(0L, 100L);
        Assert.assertEquals((long)1L, (long)abortedTxns.size());
        Assert.assertEquals((long)producerId$2, (long)((AbortedTxn)abortedTxns.head()).producerId());
        Assert.assertEquals((long)0L, (long)((AbortedTxn)abortedTxns.head()).firstOffset());
        Assert.assertEquals((long)2L, (long)((AbortedTxn)abortedTxns.head()).lastOffset());
    }

    private final Seq distinctValuesBySegment$1(Log log$5) {
        return ((TraversableOnce)log$5.logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment s) {
                return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Record record) {
                        return TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2());
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toSet().size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public final MemoryRecords kafka$log$LogCleanerTest$$createRecorcs$1() {
        return TestUtils$.MODULE$.singletonRecords((byte[])Array$.MODULE$.fill(25, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte apply() {
                return this.apply$mcB$sp();
            }

            public byte apply$mcB$sp() {
                return 0;
            }
        }, ClassTag$.MODULE$.Byte()), ((Object)BoxesRunTime.boxToInteger((int)1)).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    public final MemoryRecords kafka$log$LogCleanerTest$$createRecords$1() {
        return TestUtils$.MODULE$.singletonRecords((byte[])Array$.MODULE$.fill(25, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte apply() {
                return this.apply$mcB$sp();
            }

            public byte apply$mcB$sp() {
                return 0;
            }
        }, ClassTag$.MODULE$.Byte()), ((Object)BoxesRunTime.boxToInteger((int)1)).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    private final void checkRange$1(FakeOffsetMap map, int start2, int end, Log log$9, Cleaner cleaner$2) {
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner$2.buildOffsetMap(log$9, (long)start2, (long)end, (OffsetMap)map, stats);
        long endOffset = map.latestOffset() + 1L;
        Assert.assertEquals((String)"Last offset should be the end offset.", (long)end, (long)endOffset);
        Assert.assertEquals((String)"Should have the expected number of messages in the map.", (long)(end - start2), (long)map.size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start2), end).foreach$mVc$sp((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap map$4;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((String)"Should find all the keys", (long)i, (long)this.map$4.get(this.$outer.kafka$log$LogCleanerTest$$key(i)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$4 = map$4;
            }
        });
        Assert.assertEquals((String)"Should not find a value too small", (long)-1L, (long)map.get(this.kafka$log$LogCleanerTest$$key(start2 - 1)));
        Assert.assertEquals((String)"Should not find a value too large", (long)-1L, (long)map.get(this.kafka$log$LogCleanerTest$$key(end)));
        Assert.assertEquals((long)(end - start2), (long)stats.mapMessagesRead());
    }

    /*
     * WARNING - void declaration
     */
    private final Log recoverAndCheck$1(LogConfig config, Iterable expectedKeys) {
        void var3_6;
        LogConfig x$115 = config;
        File x$116 = this.makeLog$default$1();
        long x$117 = this.makeLog$default$3();
        Log recoveredLog = this.makeLog(x$116, x$115, x$117);
        this.time().sleep(Predef$.MODULE$.Long2long(config.fileDeleteDelayMs()) + 1L);
        Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File file) {
                Assert.assertFalse((String)"Unexpected .deleted file after recovery", (boolean)file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix()));
                Assert.assertFalse((String)"Unexpected .cleaned file after recovery", (boolean)file.getName().endsWith(Log$.MODULE$.CleanedFileSuffix()));
                Assert.assertFalse((String)"Unexpected .swap file after recovery", (boolean)file.getName().endsWith(Log$.MODULE$.SwapFileSuffix()));
            }
        });
        Assert.assertEquals((Object)expectedKeys, this.keysInLog(recoveredLog));
        return var3_6;
    }

    public LogCleanerTest() {
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logProps().put(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        this.logConfig = new LogConfig((java.util.Map)this.logProps());
        this.time = new MockTime();
        double x$23 = Double.MAX_VALUE;
        long x$24 = Long.MAX_VALUE;
        MockTime x$25 = this.time();
        boolean x$26 = Throttler$.MODULE$.$lessinit$greater$default$3();
        String x$27 = Throttler$.MODULE$.$lessinit$greater$default$4();
        String x$28 = Throttler$.MODULE$.$lessinit$greater$default$5();
        this.throttler = new Throttler(x$23, x$24, x$26, x$27, x$28, (Time)x$25);
    }
}

