/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.util.Collection;
import java.util.Properties;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerLagIntegrationTest$;
import kafka.log.LogSegment;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.Record;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001B\u0001\u0003\u0001\u001d\u0011A\u0004T8h\u00072,\u0017M\\3s\u0019\u0006<\u0017J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00111\u0001\"!\u0003\u0006\u000e\u0003\tI!a\u0003\u0002\u0003C\u0005\u00137\u000f\u001e:bGRdunZ\"mK\u0006tWM]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u0011\u00055\u0001R\"\u0001\b\u000b\u0005=!\u0011!B;uS2\u001c\u0018BA\t\u000f\u0005\u001daunZ4j]\u001eD\u0001b\u0005\u0001\u0003\u0002\u0003\u0006I\u0001F\u0001\u0015G>l\u0007O]3tg&|gnQ8eK\u000et\u0015-\\3\u0011\u0005UYbB\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\u0012A\u0002)sK\u0012,g-\u0003\u0002\u001d;\t11\u000b\u001e:j]\u001eT!AG\f\t\u000b}\u0001A\u0011\u0001\u0011\u0002\rqJg.\u001b;?)\t\t#\u0005\u0005\u0002\n\u0001!)1C\ba\u0001)!9A\u0005\u0001b\u0001\n\u0003)\u0013!C7t!\u0016\u0014\bj\\;s+\u00051\u0003C\u0001\f(\u0013\tAsCA\u0002J]RDaA\u000b\u0001!\u0002\u00131\u0013AC7t!\u0016\u0014\bj\\;sA!9A\u0006\u0001b\u0001\n\u0003)\u0013!D2p[B\f7\r^5p]2\u000bw\r\u0003\u0004/\u0001\u0001\u0006IAJ\u0001\u000fG>l\u0007/Y2uS>tG*Y4!\u0011\u001d\u0001\u0004A1A\u0005\u0002E\nA\u0001^5nKV\t!\u0007\u0005\u0002\u000eg%\u0011AG\u0004\u0002\t\u001b>\u001c7\u000eV5nK\"1a\u0007\u0001Q\u0001\nI\nQ\u0001^5nK\u0002Bq\u0001\u000f\u0001C\u0002\u0013\u0005\u0011(\u0001\tdY\u0016\fg.\u001a:CC\u000e\\wJ\u001a4NgV\t!\b\u0005\u0002\u0017w%\u0011Ah\u0006\u0002\u0005\u0019>tw\r\u0003\u0004?\u0001\u0001\u0006IAO\u0001\u0012G2,\u0017M\\3s\u0005\u0006\u001c7n\u00144g\u001bN\u0004\u0003b\u0002!\u0001\u0005\u0004%\t!J\u0001\fg\u0016<W.\u001a8u'&TX\r\u0003\u0004C\u0001\u0001\u0006IAJ\u0001\rg\u0016<W.\u001a8u'&TX\r\t\u0005\b\t\u0002\u0001\r\u0011\"\u0001&\u0003\u001d\u0019w.\u001e8uKJDqA\u0012\u0001A\u0002\u0013\u0005q)A\u0006d_VtG/\u001a:`I\u0015\fHC\u0001%L!\t1\u0012*\u0003\u0002K/\t!QK\\5u\u0011\u001daU)!AA\u0002\u0019\n1\u0001\u001f\u00132\u0011\u0019q\u0005\u0001)Q\u0005M\u0005A1m\\;oi\u0016\u0014\b\u0005C\u0004Q\u0001\t\u0007I\u0011A)\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N,\u0012A\u0015\t\u0004-M+\u0016B\u0001+\u0018\u0005\u0015\t%O]1z!\t1f,D\u0001X\u0015\tA\u0016,\u0001\u0004d_6lwN\u001c\u0006\u0003\u000biS!a\u0017/\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0016aA8sO&\u0011ql\u0016\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\t\u0007\u0001)A\u0005%\u0006\u0001Bo\u001c9jGB\u000b'\u000f^5uS>t7\u000f\t\u0005\bG\u0002\u0011\r\u0011\"\u0001e\u0003A\u0019w.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7-F\u0001f!\t1\u0017.D\u0001h\u0015\tAw+\u0001\u0004sK\u000e|'\u000fZ\u0005\u0003U\u001e\u0014qbQ8naJ,7o]5p]RK\b/\u001a\u0005\u0007Y\u0002\u0001\u000b\u0011B3\u0002#\r|W\u000e\u001d:fgNLwN\\\"pI\u0016\u001c\u0007\u0005C\u0003o\u0001\u0011\u0005q.A\u0006dY\u0016\fg.\u001a:UKN$H#\u0001%)\u00055\f\bC\u0001:v\u001b\u0005\u0019(B\u0001;]\u0003\u0015QWO\\5u\u0013\t18O\u0001\u0003UKN$\b\"\u0002=\u0001\t\u0013I\u0018a\u0003:fC\u00124%o\\7M_\u001e$2A_A\u0004!\u0011Yh0!\u0001\u000e\u0003qT!!`\f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002\u0000y\nA\u0011\n^3sC\ndW\rE\u0003\u0017\u0003\u00071c%C\u0002\u0002\u0006]\u0011a\u0001V;qY\u0016\u0014\u0004BB\u0002x\u0001\u0004\tI\u0001E\u0002\n\u0003\u0017I1!!\u0004\u0003\u0005\raun\u001a\u0005\b\u0003#\u0001A\u0011BA\n\u0003%9(/\u001b;f\tV\u00048\u000f\u0006\u0007\u0002\u0016\u0005m\u0011qDA\u0012\u0003K\tI\u0003E\u0003|\u0003/\t\t!C\u0002\u0002\u001aq\u00141aU3r\u0011\u001d\ti\"a\u0004A\u0002\u0019\nqA\\;n\u0017\u0016L8\u000fC\u0004\u0002\"\u0005=\u0001\u0019\u0001\u0014\u0002\u000f9,X\u000eR;qg\"91!a\u0004A\u0002\u0005%\u0001bBA\u0014\u0003\u001f\u0001\r!Z\u0001\u0006G>$Wm\u0019\u0005\b\u0003W\ty\u00011\u0001;\u0003%!\u0018.\\3ti\u0006l\u0007\u000fK\u0004\u0001\u0003_\tY$!\u0010\u0011\t\u0005E\u0012qG\u0007\u0003\u0003gQ1!!\u000et\u0003\u0019\u0011XO\u001c8fe&!\u0011\u0011HA\u001a\u0005\u001d\u0011VO\\,ji\"\fQA^1mk\u0016\u001c#!a\u0010\u0011\t\u0005\u0005\u0013qI\u0007\u0003\u0003\u0007R1!!\u0012t\u0003\u001d\u0011XO\u001c8feNLA!!\u0013\u0002D\ti\u0001+\u0019:b[\u0016$XM]5{K\u0012<q!!\u0014\u0003\u0011\u0003\ty%\u0001\u000fM_\u001e\u001cE.Z1oKJd\u0015mZ%oi\u0016<'/\u0019;j_:$Vm\u001d;\u0011\u0007%\t\tF\u0002\u0004\u0002\u0005!\u0005\u00111K\n\u0005\u0003#\n)\u0006E\u0002\u0017\u0003/J1!!\u0017\u0018\u0005\u0019\te.\u001f*fM\"9q$!\u0015\u0005\u0002\u0005uCCAA(\u0011!\t\t'!\u0015\u0005\u0002\u0005\r\u0014\u0001D8oKB\u000b'/Y7fi\u0016\u0014XCAA3!\u0019\t9'!\u001d\u0002v5\u0011\u0011\u0011\u000e\u0006\u0005\u0003W\ni'\u0001\u0003vi&d'BAA8\u0003\u0011Q\u0017M^1\n\t\u0005M\u0014\u0011\u000e\u0002\u000b\u0007>dG.Z2uS>t\u0007c\u0001\fT)!A\u0011\u0011PA)\t\u0003\t\u0019'\u0001\u0006qCJ\fW.\u001a;feNDC!a\u001e\u0002~A!\u0011qPAL\u001d\u0011\t\t)a%\u000f\t\u0005\r\u0015\u0011\u0013\b\u0005\u0003\u000b\u000byI\u0004\u0003\u0002\b\u00065UBAAE\u0015\r\tYIB\u0001\u0007yI|w\u000e\u001e \n\u0003uK!\u0001\u001e/\n\u0007\u0005\u00153/\u0003\u0003\u0002\u0016\u0006\r\u0013!\u0004)be\u0006lW\r^3sSj,G-\u0003\u0003\u0002\u001a\u0006m%A\u0003)be\u0006lW\r^3sg*!\u0011QSA\"\u0001")
public class LogCleanerLagIntegrationTest
extends AbstractLogCleanerIntegrationTest
implements Logging {
    private final int msPerHour;
    private final int compactionLag;
    private final MockTime time;
    private final long cleanerBackOffMs;
    private final int segmentSize;
    private int counter;
    private final TopicPartition[] topicPartitions;
    private final CompressionType compressionCodec;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Parameterized.Parameters
    public static Collection<String[]> parameters() {
        return LogCleanerLagIntegrationTest$.MODULE$.parameters();
    }

    public static Collection<String[]> oneParameter() {
        return LogCleanerLagIntegrationTest$.MODULE$.oneParameter();
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogCleanerLagIntegrationTest logCleanerLagIntegrationTest = this;
        synchronized (logCleanerLagIntegrationTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public int msPerHour() {
        return this.msPerHour;
    }

    public int compactionLag() {
        return this.compactionLag;
    }

    @Override
    public MockTime time() {
        return this.time;
    }

    public long cleanerBackOffMs() {
        return this.cleanerBackOffMs;
    }

    public int segmentSize() {
        return this.segmentSize;
    }

    public int counter() {
        return this.counter;
    }

    public void counter_$eq(int x$1) {
        this.counter = x$1;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    public CompressionType compressionCodec() {
        return this.compressionCodec;
    }

    @Test
    public void cleanerTest() {
        WrappedArray x$3 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        long x$4 = this.cleanerBackOffMs();
        long x$5 = this.compactionLag();
        int x$6 = this.segmentSize();
        float x$7 = this.makeCleaner$default$2();
        int x$8 = this.makeCleaner$default$3();
        int x$9 = this.makeCleaner$default$5();
        int x$10 = this.makeCleaner$default$7();
        Properties x$11 = this.makeCleaner$default$9();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$3, x$7, x$8, x$4, x$9, x$5, x$10, x$6, x$11));
        Log log2 = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        long T0 = this.time().milliseconds();
        Seq<Tuple2<Object, Object>> appends0 = this.writeDups(100, 3, log2, this.compressionCodec(), T0);
        long startSizeBlock0 = log2.size();
        this.debug((Function0<String>)new Serializable(this, startSizeBlock0){
            public static final long serialVersionUID = 0L;
            private final long startSizeBlock0$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"total log size at T0: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.startSizeBlock0$1)}));
            }
            {
                this.startSizeBlock0$1 = startSizeBlock0$1;
            }
        });
        LogSegment activeSegAtT0 = log2.activeSegment();
        this.debug((Function0<String>)new Serializable(this, activeSegAtT0){
            public static final long serialVersionUID = 0L;
            private final LogSegment activeSegAtT0$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"active segment at T0 has base offset: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.activeSegAtT0$1.baseOffset())}));
            }
            {
                this.activeSegAtT0$1 = activeSegAtT0$1;
            }
        });
        int sizeUpToActiveSegmentAtT0 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log2.logSegments(0L, activeSegAtT0.baseOffset()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$1) {
                return x$1.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        this.debug((Function0<String>)new Serializable(this, sizeUpToActiveSegmentAtT0){
            public static final long serialVersionUID = 0L;
            private final int sizeUpToActiveSegmentAtT0$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log size up to base offset of active segment at T0: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.sizeUpToActiveSegmentAtT0$1)}));
            }
            {
                this.sizeUpToActiveSegmentAtT0$1 = sizeUpToActiveSegmentAtT0$1;
            }
        });
        this.cleaner().startup();
        this.time().sleep(this.compactionLag() / 2);
        Thread.sleep(5L * this.cleanerBackOffMs());
        Assert.assertEquals((String)"There should be no cleaning until the compaction lag has passed", (long)startSizeBlock0, (long)log2.size());
        this.time().sleep(this.compactionLag() / 2 + 1);
        long T1 = this.time().milliseconds();
        Seq appends1 = (Seq)appends0.$plus$plus(this.writeDups(100, 3, log2, this.compressionCodec(), T1), Seq$.MODULE$.canBuildFrom());
        long firstBlock1SegmentBaseOffset = activeSegAtT0.baseOffset();
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$12 = new TopicPartition("log", 0);
        long x$13 = activeSegAtT0.baseOffset();
        long x$14 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$12, x$13, x$14);
        Iterable<Tuple2<Object, Object>> read1 = this.readFromLog(log2);
        Assert.assertEquals((String)"Contents of the map shouldn't change.", (Object)appends1.toMap(Predef$.MODULE$.$conforms()), (Object)read1.toMap(Predef$.MODULE$.$conforms()));
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log2.logSegments(0L, activeSegAtT0.baseOffset()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$2) {
                return x$2.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        this.debug((Function0<String>)new Serializable(this, compactedSize){
            public static final long serialVersionUID = 0L;
            private final int compactedSize$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"after cleaning the compacted size up to active segment at T0: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.compactedSize$1)}));
            }
            {
                this.compactedSize$1 = compactedSize$1;
            }
        });
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log cleaner should have processed up to offset ", ", but lastCleaned=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)firstBlock1SegmentBaseOffset), BoxesRunTime.boxToLong((long)lastCleaned)})), (lastCleaned >= firstBlock1SegmentBaseOffset ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: size up to offset of active segment at T0=", " compacted size=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sizeUpToActiveSegmentAtT0), BoxesRunTime.boxToInteger((int)compactedSize)})), (sizeUpToActiveSegmentAtT0 > compactedSize ? 1 : 0) != 0);
    }

    private Iterable<Tuple2<Object, Object>> readFromLog(Log log2) {
        return (Iterable)log2.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Tuple2<Object, Object>> apply(LogSegment segment) {
                return (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().records()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(Record record) {
                        int key = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
                        int value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()))).toInt();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)BoxesRunTime.boxToInteger((int)value));
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple2<Object, Object>> writeDups(int numKeys, int numDups, Log log2, CompressionType codec, long timestamp) {
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1)new Serializable(this, numKeys, log2, codec, timestamp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerLagIntegrationTest $outer;
            private final int numKeys$1;
            public final Log log$1;
            public final CompressionType codec$1;
            public final long timestamp$1;

            public final IndexedSeq<Tuple2<Object, Object>> apply(int _) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numKeys$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeDups$1 $outer;

                    public final Tuple2<Object, Object> apply(int key) {
                        int count = this.$outer.kafka$log$LogCleanerLagIntegrationTest$$anonfun$$$outer().counter();
                        byte[] x$15 = ((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$LogCleanerLagIntegrationTest$$anonfun$$$outer().counter())).toString().getBytes();
                        CompressionType x$16 = this.$outer.codec$1;
                        byte[] x$17 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
                        long x$18 = this.$outer.timestamp$1;
                        byte x$19 = TestUtils$.MODULE$.singletonRecords$default$5();
                        this.$outer.log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$15, x$17, x$16, x$18, x$19), 0, this.$outer.log$1.appendAsLeader$default$3());
                        this.$outer.kafka$log$LogCleanerLagIntegrationTest$$anonfun$$$outer().counter_$eq(this.$outer.kafka$log$LogCleanerLagIntegrationTest$$anonfun$$$outer().counter() + 1);
                        return new Tuple2.mcII.sp(key, count);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ LogCleanerLagIntegrationTest kafka$log$LogCleanerLagIntegrationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numKeys$1 = numKeys$1;
                this.log$1 = log$1;
                this.codec$1 = codec$1;
                this.timestamp$1 = timestamp$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    public LogCleanerLagIntegrationTest(String compressionCodecName) {
        Logging.class.$init$((Logging)this);
        this.msPerHour = 3600000;
        this.compactionLag = 1 * this.msPerHour();
        Assert.assertTrue((String)"compactionLag must be divisible by 2 for this test", (this.compactionLag() % 2 == 0 ? 1 : 0) != 0);
        this.time = new MockTime(1400000000000L, 1000L);
        this.cleanerBackOffMs = 200L;
        this.segmentSize = 512;
        this.counter = 0;
        this.topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
        this.compressionCodec = CompressionType.forName((String)compressionCodecName);
    }
}

