/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.util.Properties;
import kafka.admin.AdminUtils$;
import kafka.api.BaseQuotaTest;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaId;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.junit.Before;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001\u000f\t\t2\t\\5f]RLE-U;pi\u0006$Vm\u001d;\u000b\u0005\r!\u0011aA1qS*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u00055\u0011\u0015m]3Rk>$\u0018\rV3ti\")Q\u0002\u0001C\u0001\u001d\u00051A(\u001b8jiz\"\u0012a\u0004\t\u0003\u0013\u0001Aq!\u0005\u0001C\u0002\u0013\u0005##A\u0007vg\u0016\u0014\bK]5oG&\u0004\u0018\r\\\u000b\u0002'A\u0011A#G\u0007\u0002+)\u0011acF\u0001\u0005Y\u0006twMC\u0001\u0019\u0003\u0011Q\u0017M^1\n\u0005i)\"AB*ue&tw\r\u0003\u0004\u001d\u0001\u0001\u0006IaE\u0001\u000fkN,'\u000f\u0015:j]\u000eL\u0007/\u00197!\u0011\u001dq\u0002A1A\u0005B}\tq\u0002\u001d:pIV\u001cWM])v_R\f\u0017\nZ\u000b\u0002AA\u0011\u0011\u0005J\u0007\u0002E)\u00111\u0005B\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\u0015\u0012#aB)v_R\f\u0017\n\u001a\u0005\u0007O\u0001\u0001\u000b\u0011\u0002\u0011\u0002!A\u0014x\u000eZ;dKJ\fVo\u001c;b\u0013\u0012\u0004\u0003bB\u0015\u0001\u0005\u0004%\teH\u0001\u0010G>t7/^7feF+x\u000e^1JI\"11\u0006\u0001Q\u0001\n\u0001\n\u0001cY8ogVlWM])v_R\f\u0017\n\u001a\u0011\t\u000b5\u0002A\u0011\t\u0018\u0002\u000bM,G/\u00169\u0015\u0003=\u0002\"\u0001M\u001a\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u0012A!\u00168ji\"\u0012AF\u000e\t\u0003oqj\u0011\u0001\u000f\u0006\u0003si\nQA[;oSRT\u0011aO\u0001\u0004_J<\u0017BA\u001f9\u0005\u0019\u0011UMZ8sK\")q\b\u0001C!\u0001\u0006qqN^3se&$W-U;pi\u0006\u001cH\u0003B\u0018B\r\"CQA\u0011 A\u0002\r\u000bQ\u0002\u001d:pIV\u001cWM])v_R\f\u0007C\u0001\u0019E\u0013\t)\u0015G\u0001\u0003M_:<\u0007\"B$?\u0001\u0004\u0019\u0015!D2p]N,X.\u001a:Rk>$\u0018\rC\u0003J}\u0001\u0007!*\u0001\u0007sKF,Xm\u001d;Rk>$\u0018\r\u0005\u00021\u0017&\u0011A*\r\u0002\u0007\t>,(\r\\3\t\u000b9\u0003A\u0011\t\u0018\u0002)I,Wn\u001c<f#V|G/Y(wKJ\u0014\u0018\u000eZ3t\u0011\u0015\u0001\u0006\u0001\"\u0003R\u0003M)\b\u000fZ1uKF+x\u000e^1Pm\u0016\u0014(/\u001b3f)\ry#K\u0017\u0005\u0006'>\u0003\r\u0001V\u0001\tG2LWM\u001c;JIB\u0011Q\u000b\u0017\b\u0003aYK!aV\u0019\u0002\rA\u0013X\rZ3g\u0013\tQ\u0012L\u0003\u0002Xc!)1l\u0014a\u00019\u0006Q\u0001O]8qKJ$\u0018.Z:\u0011\u0005u\u0003W\"\u00010\u000b\u0005};\u0012\u0001B;uS2L!!\u00190\u0003\u0015A\u0013x\u000e]3si&,7\u000f")
public class ClientIdQuotaTest
extends BaseQuotaTest {
    private final String userPrincipal = KafkaPrincipal.ANONYMOUS.getName();
    private final QuotaId producerQuotaId = new QuotaId((Option)None$.MODULE$, (Option)new Some((Object)this.producerClientId()));
    private final QuotaId consumerQuotaId = new QuotaId((Option)None$.MODULE$, (Option)new Some((Object)this.consumerClientId()));

    @Override
    public String userPrincipal() {
        return this.userPrincipal;
    }

    @Override
    public QuotaId producerQuotaId() {
        return this.producerQuotaId;
    }

    @Override
    public QuotaId consumerQuotaId() {
        return this.consumerQuotaId;
    }

    @Override
    @Before
    public void setUp() {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ProducerQuotaBytesPerSecondDefaultProp(), ((Object)BoxesRunTime.boxToInteger((int)this.defaultProducerQuota())).toString());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ConsumerQuotaBytesPerSecondDefaultProp(), ((Object)BoxesRunTime.boxToInteger((int)this.defaultConsumerQuota())).toString());
        super.setUp();
    }

    @Override
    public void overrideQuotas(long producerQuota, long consumerQuota, double requestQuota) {
        Properties producerProps = new Properties();
        producerProps.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)producerQuota)).toString());
        producerProps.put(DynamicConfig.Client$.MODULE$.RequestPercentageOverrideProp(), ((Object)BoxesRunTime.boxToDouble((double)requestQuota)).toString());
        this.updateQuotaOverride(this.producerClientId(), producerProps);
        Properties consumerProps = new Properties();
        consumerProps.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)consumerQuota)).toString());
        consumerProps.put(DynamicConfig.Client$.MODULE$.RequestPercentageOverrideProp(), ((Object)BoxesRunTime.boxToDouble((double)requestQuota)).toString());
        this.updateQuotaOverride(this.consumerClientId(), consumerProps);
    }

    @Override
    public void removeQuotaOverrides() {
        Properties emptyProps = new Properties();
        this.updateQuotaOverride(this.producerClientId(), emptyProps);
        this.updateQuotaOverride(this.consumerClientId(), emptyProps);
    }

    private void updateQuotaOverride(String clientId, Properties properties) {
        AdminUtils$.MODULE$.changeClientIdConfig(this.zkUtils(), clientId, properties);
    }
}

