/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator;

import java.nio.ByteBuffer;
import kafka.common.KafkaException;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.coordinator.BaseKey;
import kafka.coordinator.Empty$;
import kafka.coordinator.GroupMetadata;
import kafka.coordinator.GroupMetadataKey;
import kafka.coordinator.GroupState;
import kafka.coordinator.GroupTopicPartition;
import kafka.coordinator.MemberMetadata;
import kafka.coordinator.OffsetKey;
import kafka.coordinator.Stable$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class GroupMetadataManager$ {
    public static final GroupMetadataManager$ MODULE$;
    private final short CURRENT_OFFSET_KEY_SCHEMA_VERSION;
    private final short CURRENT_GROUP_KEY_SCHEMA_VERSION;
    private final Schema OFFSET_COMMIT_KEY_SCHEMA;
    private final Field OFFSET_KEY_GROUP_FIELD;
    private final Field OFFSET_KEY_TOPIC_FIELD;
    private final Field OFFSET_KEY_PARTITION_FIELD;
    private final Schema OFFSET_COMMIT_VALUE_SCHEMA_V0;
    private final Field OFFSET_VALUE_OFFSET_FIELD_V0;
    private final Field OFFSET_VALUE_METADATA_FIELD_V0;
    private final Field OFFSET_VALUE_TIMESTAMP_FIELD_V0;
    private final Schema OFFSET_COMMIT_VALUE_SCHEMA_V1;
    private final Field OFFSET_VALUE_OFFSET_FIELD_V1;
    private final Field OFFSET_VALUE_METADATA_FIELD_V1;
    private final Field OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1;
    private final Field OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1;
    private final Schema GROUP_METADATA_KEY_SCHEMA;
    private final Field GROUP_KEY_GROUP_FIELD;
    private final String kafka$coordinator$GroupMetadataManager$$MEMBER_ID_KEY;
    private final String kafka$coordinator$GroupMetadataManager$$CLIENT_ID_KEY;
    private final String kafka$coordinator$GroupMetadataManager$$CLIENT_HOST_KEY;
    private final String kafka$coordinator$GroupMetadataManager$$REBALANCE_TIMEOUT_KEY;
    private final String kafka$coordinator$GroupMetadataManager$$SESSION_TIMEOUT_KEY;
    private final String kafka$coordinator$GroupMetadataManager$$SUBSCRIPTION_KEY;
    private final String kafka$coordinator$GroupMetadataManager$$ASSIGNMENT_KEY;
    private final Schema MEMBER_METADATA_V0;
    private final Schema MEMBER_METADATA_V1;
    private final String PROTOCOL_TYPE_KEY;
    private final String GENERATION_KEY;
    private final String PROTOCOL_KEY;
    private final String LEADER_KEY;
    private final String kafka$coordinator$GroupMetadataManager$$MEMBERS_KEY;
    private final Schema GROUP_METADATA_VALUE_SCHEMA_V0;
    private final Schema GROUP_METADATA_VALUE_SCHEMA_V1;
    private final Map<Object, Schema> MESSAGE_TYPE_SCHEMAS;
    private final Map<Object, Schema> OFFSET_VALUE_SCHEMAS;
    private final short CURRENT_OFFSET_VALUE_SCHEMA_VERSION;
    private final Map<Object, Schema> GROUP_VALUE_SCHEMAS;
    private final short kafka$coordinator$GroupMetadataManager$$CURRENT_GROUP_VALUE_SCHEMA_VERSION;
    private final Schema CURRENT_OFFSET_KEY_SCHEMA;
    private final Schema CURRENT_GROUP_KEY_SCHEMA;
    private final Schema CURRENT_OFFSET_VALUE_SCHEMA;
    private final Schema CURRENT_GROUP_VALUE_SCHEMA;

    static {
        new GroupMetadataManager$();
    }

    private short CURRENT_OFFSET_KEY_SCHEMA_VERSION() {
        return this.CURRENT_OFFSET_KEY_SCHEMA_VERSION;
    }

    private short CURRENT_GROUP_KEY_SCHEMA_VERSION() {
        return this.CURRENT_GROUP_KEY_SCHEMA_VERSION;
    }

    private Schema OFFSET_COMMIT_KEY_SCHEMA() {
        return this.OFFSET_COMMIT_KEY_SCHEMA;
    }

    private Field OFFSET_KEY_GROUP_FIELD() {
        return this.OFFSET_KEY_GROUP_FIELD;
    }

    private Field OFFSET_KEY_TOPIC_FIELD() {
        return this.OFFSET_KEY_TOPIC_FIELD;
    }

    private Field OFFSET_KEY_PARTITION_FIELD() {
        return this.OFFSET_KEY_PARTITION_FIELD;
    }

    private Schema OFFSET_COMMIT_VALUE_SCHEMA_V0() {
        return this.OFFSET_COMMIT_VALUE_SCHEMA_V0;
    }

    private Field OFFSET_VALUE_OFFSET_FIELD_V0() {
        return this.OFFSET_VALUE_OFFSET_FIELD_V0;
    }

    private Field OFFSET_VALUE_METADATA_FIELD_V0() {
        return this.OFFSET_VALUE_METADATA_FIELD_V0;
    }

    private Field OFFSET_VALUE_TIMESTAMP_FIELD_V0() {
        return this.OFFSET_VALUE_TIMESTAMP_FIELD_V0;
    }

    private Schema OFFSET_COMMIT_VALUE_SCHEMA_V1() {
        return this.OFFSET_COMMIT_VALUE_SCHEMA_V1;
    }

    private Field OFFSET_VALUE_OFFSET_FIELD_V1() {
        return this.OFFSET_VALUE_OFFSET_FIELD_V1;
    }

    private Field OFFSET_VALUE_METADATA_FIELD_V1() {
        return this.OFFSET_VALUE_METADATA_FIELD_V1;
    }

    private Field OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1() {
        return this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1;
    }

    private Field OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1() {
        return this.OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1;
    }

    private Schema GROUP_METADATA_KEY_SCHEMA() {
        return this.GROUP_METADATA_KEY_SCHEMA;
    }

    private Field GROUP_KEY_GROUP_FIELD() {
        return this.GROUP_KEY_GROUP_FIELD;
    }

    public String kafka$coordinator$GroupMetadataManager$$MEMBER_ID_KEY() {
        return this.kafka$coordinator$GroupMetadataManager$$MEMBER_ID_KEY;
    }

    public String kafka$coordinator$GroupMetadataManager$$CLIENT_ID_KEY() {
        return this.kafka$coordinator$GroupMetadataManager$$CLIENT_ID_KEY;
    }

    public String kafka$coordinator$GroupMetadataManager$$CLIENT_HOST_KEY() {
        return this.kafka$coordinator$GroupMetadataManager$$CLIENT_HOST_KEY;
    }

    public String kafka$coordinator$GroupMetadataManager$$REBALANCE_TIMEOUT_KEY() {
        return this.kafka$coordinator$GroupMetadataManager$$REBALANCE_TIMEOUT_KEY;
    }

    public String kafka$coordinator$GroupMetadataManager$$SESSION_TIMEOUT_KEY() {
        return this.kafka$coordinator$GroupMetadataManager$$SESSION_TIMEOUT_KEY;
    }

    public String kafka$coordinator$GroupMetadataManager$$SUBSCRIPTION_KEY() {
        return this.kafka$coordinator$GroupMetadataManager$$SUBSCRIPTION_KEY;
    }

    public String kafka$coordinator$GroupMetadataManager$$ASSIGNMENT_KEY() {
        return this.kafka$coordinator$GroupMetadataManager$$ASSIGNMENT_KEY;
    }

    private Schema MEMBER_METADATA_V0() {
        return this.MEMBER_METADATA_V0;
    }

    private Schema MEMBER_METADATA_V1() {
        return this.MEMBER_METADATA_V1;
    }

    private String PROTOCOL_TYPE_KEY() {
        return this.PROTOCOL_TYPE_KEY;
    }

    private String GENERATION_KEY() {
        return this.GENERATION_KEY;
    }

    private String PROTOCOL_KEY() {
        return this.PROTOCOL_KEY;
    }

    private String LEADER_KEY() {
        return this.LEADER_KEY;
    }

    public String kafka$coordinator$GroupMetadataManager$$MEMBERS_KEY() {
        return this.kafka$coordinator$GroupMetadataManager$$MEMBERS_KEY;
    }

    private Schema GROUP_METADATA_VALUE_SCHEMA_V0() {
        return this.GROUP_METADATA_VALUE_SCHEMA_V0;
    }

    private Schema GROUP_METADATA_VALUE_SCHEMA_V1() {
        return this.GROUP_METADATA_VALUE_SCHEMA_V1;
    }

    private Map<Object, Schema> MESSAGE_TYPE_SCHEMAS() {
        return this.MESSAGE_TYPE_SCHEMAS;
    }

    private Map<Object, Schema> OFFSET_VALUE_SCHEMAS() {
        return this.OFFSET_VALUE_SCHEMAS;
    }

    private short CURRENT_OFFSET_VALUE_SCHEMA_VERSION() {
        return this.CURRENT_OFFSET_VALUE_SCHEMA_VERSION;
    }

    private Map<Object, Schema> GROUP_VALUE_SCHEMAS() {
        return this.GROUP_VALUE_SCHEMAS;
    }

    public short kafka$coordinator$GroupMetadataManager$$CURRENT_GROUP_VALUE_SCHEMA_VERSION() {
        return this.kafka$coordinator$GroupMetadataManager$$CURRENT_GROUP_VALUE_SCHEMA_VERSION;
    }

    private Schema CURRENT_OFFSET_KEY_SCHEMA() {
        return this.CURRENT_OFFSET_KEY_SCHEMA;
    }

    private Schema CURRENT_GROUP_KEY_SCHEMA() {
        return this.CURRENT_GROUP_KEY_SCHEMA;
    }

    private Schema CURRENT_OFFSET_VALUE_SCHEMA() {
        return this.CURRENT_OFFSET_VALUE_SCHEMA;
    }

    private Schema CURRENT_GROUP_VALUE_SCHEMA() {
        return this.CURRENT_GROUP_VALUE_SCHEMA;
    }

    private Schema schemaForKey(int version) {
        Option schemaOpt = this.MESSAGE_TYPE_SCHEMAS().get((Object)BoxesRunTime.boxToInteger((int)version));
        Option option = schemaOpt;
        if (option instanceof Some) {
            Schema schema;
            Some some = (Some)option;
            Schema schema2 = schema = (Schema)some.x();
            return schema2;
        }
        throw new KafkaException(new StringBuilder().append((Object)"Unknown offset schema version ").append((Object)BoxesRunTime.boxToInteger((int)version)).toString());
    }

    private Schema schemaForOffset(int version) {
        Option schemaOpt = this.OFFSET_VALUE_SCHEMAS().get((Object)BoxesRunTime.boxToInteger((int)version));
        Option option = schemaOpt;
        if (option instanceof Some) {
            Schema schema;
            Some some = (Some)option;
            Schema schema2 = schema = (Schema)some.x();
            return schema2;
        }
        throw new KafkaException(new StringBuilder().append((Object)"Unknown offset schema version ").append((Object)BoxesRunTime.boxToInteger((int)version)).toString());
    }

    private Schema schemaForGroup(int version) {
        Option schemaOpt = this.GROUP_VALUE_SCHEMAS().get((Object)BoxesRunTime.boxToInteger((int)version));
        Option option = schemaOpt;
        if (option instanceof Some) {
            Schema schema;
            Some some = (Some)option;
            Schema schema2 = schema = (Schema)some.x();
            return schema2;
        }
        throw new KafkaException(new StringBuilder().append((Object)"Unknown group metadata version ").append((Object)BoxesRunTime.boxToInteger((int)version)).toString());
    }

    public byte[] kafka$coordinator$GroupMetadataManager$$offsetCommitKey(String group, String topic, int partition, short versionId) {
        Struct key = new Struct(this.CURRENT_OFFSET_KEY_SCHEMA());
        key.set(this.OFFSET_KEY_GROUP_FIELD(), (Object)group);
        key.set(this.OFFSET_KEY_TOPIC_FIELD(), (Object)topic);
        key.set(this.OFFSET_KEY_PARTITION_FIELD(), (Object)BoxesRunTime.boxToInteger((int)partition));
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + key.sizeOf());
        byteBuffer.putShort(this.CURRENT_OFFSET_KEY_SCHEMA_VERSION());
        key.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public short kafka$coordinator$GroupMetadataManager$$offsetCommitKey$default$4() {
        return 0;
    }

    public byte[] groupMetadataKey(String group) {
        Struct key = new Struct(this.CURRENT_GROUP_KEY_SCHEMA());
        key.set(this.GROUP_KEY_GROUP_FIELD(), (Object)group);
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + key.sizeOf());
        byteBuffer.putShort(this.CURRENT_GROUP_KEY_SCHEMA_VERSION());
        key.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public byte[] kafka$coordinator$GroupMetadataManager$$offsetCommitValue(OffsetAndMetadata offsetAndMetadata) {
        Struct value2 = new Struct(this.CURRENT_OFFSET_VALUE_SCHEMA());
        value2.set(this.OFFSET_VALUE_OFFSET_FIELD_V1(), (Object)BoxesRunTime.boxToLong((long)offsetAndMetadata.offset()));
        value2.set(this.OFFSET_VALUE_METADATA_FIELD_V1(), (Object)offsetAndMetadata.metadata());
        value2.set(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1(), (Object)BoxesRunTime.boxToLong((long)offsetAndMetadata.commitTimestamp()));
        value2.set(this.OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1(), (Object)BoxesRunTime.boxToLong((long)offsetAndMetadata.expireTimestamp()));
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + value2.sizeOf());
        byteBuffer.putShort(this.CURRENT_OFFSET_VALUE_SCHEMA_VERSION());
        value2.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public byte[] groupMetadataValue(GroupMetadata groupMetadata, Map<String, byte[]> assignment, short version) {
        Struct value2 = version == 0 ? new Struct(this.GROUP_METADATA_VALUE_SCHEMA_V0()) : new Struct(this.CURRENT_GROUP_VALUE_SCHEMA());
        value2.set(this.PROTOCOL_TYPE_KEY(), groupMetadata.protocolType().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }));
        value2.set(this.GENERATION_KEY(), (Object)BoxesRunTime.boxToInteger((int)groupMetadata.generationId()));
        value2.set(this.PROTOCOL_KEY(), (Object)groupMetadata.protocol());
        value2.set(this.LEADER_KEY(), (Object)groupMetadata.leaderId());
        List memberArray = (List)groupMetadata.allMemberMetadata().map((Function1)new Serializable(groupMetadata, assignment, version, value2){
            public static final long serialVersionUID = 0L;
            private final GroupMetadata groupMetadata$1;
            private final Map assignment$1;
            private final short version$1;
            private final Struct value$1;

            public final Struct apply(MemberMetadata x0$13) {
                MemberMetadata memberMetadata = x0$13;
                Struct memberStruct = this.value$1.instance(GroupMetadataManager$.MODULE$.kafka$coordinator$GroupMetadataManager$$MEMBERS_KEY());
                memberStruct.set(GroupMetadataManager$.MODULE$.kafka$coordinator$GroupMetadataManager$$MEMBER_ID_KEY(), (Object)memberMetadata.memberId());
                memberStruct.set(GroupMetadataManager$.MODULE$.kafka$coordinator$GroupMetadataManager$$CLIENT_ID_KEY(), (Object)memberMetadata.clientId());
                memberStruct.set(GroupMetadataManager$.MODULE$.kafka$coordinator$GroupMetadataManager$$CLIENT_HOST_KEY(), (Object)memberMetadata.clientHost());
                memberStruct.set(GroupMetadataManager$.MODULE$.kafka$coordinator$GroupMetadataManager$$SESSION_TIMEOUT_KEY(), (Object)BoxesRunTime.boxToInteger((int)memberMetadata.sessionTimeoutMs()));
                Object object = this.version$1 > 0 ? memberStruct.set(GroupMetadataManager$.MODULE$.kafka$coordinator$GroupMetadataManager$$REBALANCE_TIMEOUT_KEY(), (Object)BoxesRunTime.boxToInteger((int)memberMetadata.rebalanceTimeoutMs())) : BoxedUnit.UNIT;
                byte[] metadata = memberMetadata.metadata(this.groupMetadata$1.protocol());
                memberStruct.set(GroupMetadataManager$.MODULE$.kafka$coordinator$GroupMetadataManager$$SUBSCRIPTION_KEY(), (Object)ByteBuffer.wrap(metadata));
                byte[] memberAssignment = (byte[])this.assignment$1.apply((Object)memberMetadata.memberId());
                Predef$.MODULE$.assert(memberAssignment != null);
                memberStruct.set(GroupMetadataManager$.MODULE$.kafka$coordinator$GroupMetadataManager$$ASSIGNMENT_KEY(), (Object)ByteBuffer.wrap(memberAssignment));
                Struct struct = memberStruct;
                return struct;
            }
            {
                this.groupMetadata$1 = groupMetadata$1;
                this.assignment$1 = assignment$1;
                this.version$1 = version$1;
                this.value$1 = value$1;
            }
        }, List$.MODULE$.canBuildFrom());
        value2.set(this.kafka$coordinator$GroupMetadataManager$$MEMBERS_KEY(), memberArray.toArray(ClassTag$.MODULE$.apply(Struct.class)));
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + value2.sizeOf());
        byteBuffer.putShort(version);
        value2.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public short groupMetadataValue$default$3() {
        return 0;
    }

    public BaseKey readMessageKey(ByteBuffer buffer) {
        short version;
        block4: {
            Product product;
            block3: {
                Struct key;
                block2: {
                    version = buffer.getShort();
                    Schema keySchema = this.schemaForKey(version);
                    key = keySchema.read(buffer);
                    if (version > this.CURRENT_OFFSET_KEY_SCHEMA_VERSION()) break block2;
                    String group = (String)key.get(this.OFFSET_KEY_GROUP_FIELD());
                    String topic = (String)key.get(this.OFFSET_KEY_TOPIC_FIELD());
                    int partition = BoxesRunTime.unboxToInt((Object)key.get(this.OFFSET_KEY_PARTITION_FIELD()));
                    product = new OffsetKey(version, new GroupTopicPartition(group, new TopicPartition(topic, partition)));
                    break block3;
                }
                if (version != this.CURRENT_GROUP_KEY_SCHEMA_VERSION()) break block4;
                String group = (String)key.get(this.GROUP_KEY_GROUP_FIELD());
                product = new GroupMetadataKey(version, group);
            }
            return product;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)"Unknown version ").append((Object)BoxesRunTime.boxToShort((short)version)).append((Object)" for group metadata message").toString());
    }

    public OffsetAndMetadata readOffsetMessageValue(ByteBuffer buffer) {
        block5: {
            OffsetAndMetadata offsetAndMetadata;
            block3: {
                Struct value2;
                short version;
                block4: {
                    block2: {
                        if (buffer != null) break block2;
                        offsetAndMetadata = null;
                        break block3;
                    }
                    version = buffer.getShort();
                    Schema valueSchema = this.schemaForOffset(version);
                    value2 = valueSchema.read(buffer);
                    if (version != 0) break block4;
                    long offset = BoxesRunTime.unboxToLong((Object)value2.get(this.OFFSET_VALUE_OFFSET_FIELD_V0()));
                    String metadata = (String)value2.get(this.OFFSET_VALUE_METADATA_FIELD_V0());
                    long timestamp2 = BoxesRunTime.unboxToLong((Object)value2.get(this.OFFSET_VALUE_TIMESTAMP_FIELD_V0()));
                    offsetAndMetadata = OffsetAndMetadata$.MODULE$.apply(offset, metadata, timestamp2);
                    break block3;
                }
                if (version != 1) break block5;
                long offset = BoxesRunTime.unboxToLong((Object)value2.get(this.OFFSET_VALUE_OFFSET_FIELD_V1()));
                String metadata = (String)value2.get(this.OFFSET_VALUE_METADATA_FIELD_V1());
                long commitTimestamp = BoxesRunTime.unboxToLong((Object)value2.get(this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1()));
                long expireTimestamp = BoxesRunTime.unboxToLong((Object)value2.get(this.OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1()));
                offsetAndMetadata = OffsetAndMetadata$.MODULE$.apply(offset, metadata, commitTimestamp, expireTimestamp);
            }
            return offsetAndMetadata;
        }
        throw new IllegalStateException("Unknown offset message version");
    }

    public GroupMetadata readGroupMessageValue(String groupId, ByteBuffer buffer) {
        block4: {
            GroupMetadata groupMetadata;
            block3: {
                block2: {
                    if (buffer != null) break block2;
                    groupMetadata = null;
                    break block3;
                }
                short version = buffer.getShort();
                Schema valueSchema = this.schemaForGroup(version);
                Struct value2 = valueSchema.read(buffer);
                if (version != 0 && version != 1) break block4;
                String protocolType = (String)value2.get(this.PROTOCOL_TYPE_KEY());
                Object[] memberMetadataArray = value2.getArray(this.kafka$coordinator$GroupMetadataManager$$MEMBERS_KEY());
                Product initialState = Predef$.MODULE$.refArrayOps(memberMetadataArray).isEmpty() ? Empty$.MODULE$ : Stable$.MODULE$;
                GroupMetadata group = new GroupMetadata(groupId, (GroupState)initialState);
                group.generationId_$eq(BoxesRunTime.unboxToInt((Object)value2.get(this.GENERATION_KEY())));
                group.leaderId_$eq((String)value2.get(this.LEADER_KEY()));
                group.protocol_$eq((String)value2.get(this.PROTOCOL_KEY()));
                Predef$.MODULE$.refArrayOps(memberMetadataArray).foreach((Function1)new Serializable(groupId, version, protocolType, group){
                    public static final long serialVersionUID = 0L;
                    private final String groupId$2;
                    private final short version$2;
                    private final String protocolType$1;
                    private final GroupMetadata group$6;

                    public final void apply(Object x0$14) {
                        Object object = x0$14;
                        Struct memberMetadata = (Struct)object;
                        String memberId = (String)memberMetadata.get(GroupMetadataManager$.MODULE$.kafka$coordinator$GroupMetadataManager$$MEMBER_ID_KEY());
                        String clientId = (String)memberMetadata.get(GroupMetadataManager$.MODULE$.kafka$coordinator$GroupMetadataManager$$CLIENT_ID_KEY());
                        String clientHost = (String)memberMetadata.get(GroupMetadataManager$.MODULE$.kafka$coordinator$GroupMetadataManager$$CLIENT_HOST_KEY());
                        int sessionTimeout = BoxesRunTime.unboxToInt((Object)memberMetadata.get(GroupMetadataManager$.MODULE$.kafka$coordinator$GroupMetadataManager$$SESSION_TIMEOUT_KEY()));
                        int rebalanceTimeout = this.version$2 == 0 ? sessionTimeout : BoxesRunTime.unboxToInt((Object)memberMetadata.get(GroupMetadataManager$.MODULE$.kafka$coordinator$GroupMetadataManager$$REBALANCE_TIMEOUT_KEY()));
                        byte[] subscription = Utils.toArray((ByteBuffer)((ByteBuffer)memberMetadata.get(GroupMetadataManager$.MODULE$.kafka$coordinator$GroupMetadataManager$$SUBSCRIPTION_KEY())));
                        MemberMetadata member = new MemberMetadata(memberId, this.groupId$2, clientId, clientHost, rebalanceTimeout, sessionTimeout, this.protocolType$1, (List<Tuple2<String, byte[]>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.group$6.protocol(), (Object)subscription)})));
                        member.assignment_$eq(Utils.toArray((ByteBuffer)((ByteBuffer)memberMetadata.get(GroupMetadataManager$.MODULE$.kafka$coordinator$GroupMetadataManager$$ASSIGNMENT_KEY()))));
                        this.group$6.add(memberId, member);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    {
                        this.groupId$2 = groupId$2;
                        this.version$2 = version$2;
                        this.protocolType$1 = protocolType$1;
                        this.group$6 = group$6;
                    }
                });
                groupMetadata = group;
            }
            return groupMetadata;
        }
        throw new IllegalStateException("Unknown group metadata message version");
    }

    private GroupMetadataManager$() {
        MODULE$ = this;
        this.CURRENT_OFFSET_KEY_SCHEMA_VERSION = (short)1;
        this.CURRENT_GROUP_KEY_SCHEMA_VERSION = (short)2;
        this.OFFSET_COMMIT_KEY_SCHEMA = new Schema(new Field[]{new Field("group", Type.STRING), new Field("topic", Type.STRING), new Field("partition", Type.INT32)});
        this.OFFSET_KEY_GROUP_FIELD = this.OFFSET_COMMIT_KEY_SCHEMA().get("group");
        this.OFFSET_KEY_TOPIC_FIELD = this.OFFSET_COMMIT_KEY_SCHEMA().get("topic");
        this.OFFSET_KEY_PARTITION_FIELD = this.OFFSET_COMMIT_KEY_SCHEMA().get("partition");
        this.OFFSET_COMMIT_VALUE_SCHEMA_V0 = new Schema(new Field[]{new Field("offset", Type.INT64), new Field("metadata", Type.STRING, "Associated metadata.", (Object)""), new Field("timestamp", Type.INT64)});
        this.OFFSET_VALUE_OFFSET_FIELD_V0 = this.OFFSET_COMMIT_VALUE_SCHEMA_V0().get("offset");
        this.OFFSET_VALUE_METADATA_FIELD_V0 = this.OFFSET_COMMIT_VALUE_SCHEMA_V0().get("metadata");
        this.OFFSET_VALUE_TIMESTAMP_FIELD_V0 = this.OFFSET_COMMIT_VALUE_SCHEMA_V0().get("timestamp");
        this.OFFSET_COMMIT_VALUE_SCHEMA_V1 = new Schema(new Field[]{new Field("offset", Type.INT64), new Field("metadata", Type.STRING, "Associated metadata.", (Object)""), new Field("commit_timestamp", Type.INT64), new Field("expire_timestamp", Type.INT64)});
        this.OFFSET_VALUE_OFFSET_FIELD_V1 = this.OFFSET_COMMIT_VALUE_SCHEMA_V1().get("offset");
        this.OFFSET_VALUE_METADATA_FIELD_V1 = this.OFFSET_COMMIT_VALUE_SCHEMA_V1().get("metadata");
        this.OFFSET_VALUE_COMMIT_TIMESTAMP_FIELD_V1 = this.OFFSET_COMMIT_VALUE_SCHEMA_V1().get("commit_timestamp");
        this.OFFSET_VALUE_EXPIRE_TIMESTAMP_FIELD_V1 = this.OFFSET_COMMIT_VALUE_SCHEMA_V1().get("expire_timestamp");
        this.GROUP_METADATA_KEY_SCHEMA = new Schema(new Field[]{new Field("group", Type.STRING)});
        this.GROUP_KEY_GROUP_FIELD = this.GROUP_METADATA_KEY_SCHEMA().get("group");
        this.kafka$coordinator$GroupMetadataManager$$MEMBER_ID_KEY = "member_id";
        this.kafka$coordinator$GroupMetadataManager$$CLIENT_ID_KEY = "client_id";
        this.kafka$coordinator$GroupMetadataManager$$CLIENT_HOST_KEY = "client_host";
        this.kafka$coordinator$GroupMetadataManager$$REBALANCE_TIMEOUT_KEY = "rebalance_timeout";
        this.kafka$coordinator$GroupMetadataManager$$SESSION_TIMEOUT_KEY = "session_timeout";
        this.kafka$coordinator$GroupMetadataManager$$SUBSCRIPTION_KEY = "subscription";
        this.kafka$coordinator$GroupMetadataManager$$ASSIGNMENT_KEY = "assignment";
        this.MEMBER_METADATA_V0 = new Schema(new Field[]{new Field(this.kafka$coordinator$GroupMetadataManager$$MEMBER_ID_KEY(), Type.STRING), new Field(this.kafka$coordinator$GroupMetadataManager$$CLIENT_ID_KEY(), Type.STRING), new Field(this.kafka$coordinator$GroupMetadataManager$$CLIENT_HOST_KEY(), Type.STRING), new Field(this.kafka$coordinator$GroupMetadataManager$$SESSION_TIMEOUT_KEY(), Type.INT32), new Field(this.kafka$coordinator$GroupMetadataManager$$SUBSCRIPTION_KEY(), Type.BYTES), new Field(this.kafka$coordinator$GroupMetadataManager$$ASSIGNMENT_KEY(), Type.BYTES)});
        this.MEMBER_METADATA_V1 = new Schema(new Field[]{new Field(this.kafka$coordinator$GroupMetadataManager$$MEMBER_ID_KEY(), Type.STRING), new Field(this.kafka$coordinator$GroupMetadataManager$$CLIENT_ID_KEY(), Type.STRING), new Field(this.kafka$coordinator$GroupMetadataManager$$CLIENT_HOST_KEY(), Type.STRING), new Field(this.kafka$coordinator$GroupMetadataManager$$REBALANCE_TIMEOUT_KEY(), Type.INT32), new Field(this.kafka$coordinator$GroupMetadataManager$$SESSION_TIMEOUT_KEY(), Type.INT32), new Field(this.kafka$coordinator$GroupMetadataManager$$SUBSCRIPTION_KEY(), Type.BYTES), new Field(this.kafka$coordinator$GroupMetadataManager$$ASSIGNMENT_KEY(), Type.BYTES)});
        this.PROTOCOL_TYPE_KEY = "protocol_type";
        this.GENERATION_KEY = "generation";
        this.PROTOCOL_KEY = "protocol";
        this.LEADER_KEY = "leader";
        this.kafka$coordinator$GroupMetadataManager$$MEMBERS_KEY = "members";
        this.GROUP_METADATA_VALUE_SCHEMA_V0 = new Schema(new Field[]{new Field(this.PROTOCOL_TYPE_KEY(), Type.STRING), new Field(this.GENERATION_KEY(), Type.INT32), new Field(this.PROTOCOL_KEY(), Type.NULLABLE_STRING), new Field(this.LEADER_KEY(), Type.NULLABLE_STRING), new Field(this.kafka$coordinator$GroupMetadataManager$$MEMBERS_KEY(), (Type)new ArrayOf((Type)this.MEMBER_METADATA_V0()))});
        this.GROUP_METADATA_VALUE_SCHEMA_V1 = new Schema(new Field[]{new Field(this.PROTOCOL_TYPE_KEY(), Type.STRING), new Field(this.GENERATION_KEY(), Type.INT32), new Field(this.PROTOCOL_KEY(), Type.NULLABLE_STRING), new Field(this.LEADER_KEY(), Type.NULLABLE_STRING), new Field(this.kafka$coordinator$GroupMetadataManager$$MEMBERS_KEY(), (Type)new ArrayOf((Type)this.MEMBER_METADATA_V1()))});
        this.MESSAGE_TYPE_SCHEMAS = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)this.OFFSET_COMMIT_KEY_SCHEMA()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.OFFSET_COMMIT_KEY_SCHEMA()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)this.GROUP_METADATA_KEY_SCHEMA())}));
        this.OFFSET_VALUE_SCHEMAS = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)this.OFFSET_COMMIT_VALUE_SCHEMA_V0()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.OFFSET_COMMIT_VALUE_SCHEMA_V1())}));
        this.CURRENT_OFFSET_VALUE_SCHEMA_VERSION = (short)1;
        this.GROUP_VALUE_SCHEMAS = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)this.GROUP_METADATA_VALUE_SCHEMA_V0()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.GROUP_METADATA_VALUE_SCHEMA_V1())}));
        this.kafka$coordinator$GroupMetadataManager$$CURRENT_GROUP_VALUE_SCHEMA_VERSION = (short)1;
        this.CURRENT_OFFSET_KEY_SCHEMA = this.schemaForKey(this.CURRENT_OFFSET_KEY_SCHEMA_VERSION());
        this.CURRENT_GROUP_KEY_SCHEMA = this.schemaForKey(this.CURRENT_GROUP_KEY_SCHEMA_VERSION());
        this.CURRENT_OFFSET_VALUE_SCHEMA = this.schemaForOffset(this.CURRENT_OFFSET_VALUE_SCHEMA_VERSION());
        this.CURRENT_GROUP_VALUE_SCHEMA = this.schemaForGroup(this.kafka$coordinator$GroupMetadataManager$$CURRENT_GROUP_VALUE_SCHEMA_VERSION());
    }
}

