/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.net.Socket;
import java.nio.ByteBuffer;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.LZ4CompressionCodec$;
import kafka.message.Message;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u000113A!\u0001\u0002\u0001\u000f\t\u0011\u0002K]8ek\u000e,'+Z9vKN$H+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tI!\"D\u0001\u0003\u0013\tY!AA\bCCN,'+Z9vKN$H+Z:u\u0011\u0015i\u0001\u0001\"\u0001\u000f\u0003\u0019a\u0014N\\5u}Q\tq\u0002\u0005\u0002\n\u0001!)\u0011\u0003\u0001C\u0001%\u0005AB/Z:u'&l\u0007\u000f\\3Qe>$WoY3SKF,Xm\u001d;\u0015\u0003M\u0001\"\u0001F\f\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\u0011A!\u00168ji\"\u0012\u0001C\u0007\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\tQA[;oSRT\u0011aH\u0001\u0004_J<\u0017BA\u0011\u001d\u0005\u0011!Vm\u001d;\t\u000b\r\u0002A\u0011\u0002\u0013\u0002K\r\u0014X-\u0019;f)>\u0004\u0018nY!oI\u001aKg\u000e\u001a)beRLG/[8o/&$\b\u000eT3bI\u0016\u0014HCA\u0013,!\u0011!b\u0005\u000b\u0015\n\u0005\u001d*\"A\u0002+va2,'\u0007\u0005\u0002\u0015S%\u0011!&\u0006\u0002\u0004\u0013:$\b\"\u0002\u0017#\u0001\u0004i\u0013!\u0002;pa&\u001c\u0007C\u0001\u00182\u001d\t!r&\u0003\u00021+\u00051\u0001K]3eK\u001aL!AM\u001a\u0003\rM#(/\u001b8h\u0015\t\u0001T\u0003C\u00036\u0001\u0011\u0005!#\u0001\u000fuKN$8i\u001c:skB$HJ\u001f\u001bQe>$WoY3SKF,Xm\u001d;)\u0005QR\u0002\"\u0002\u001d\u0001\t\u0013I\u0014AE:f]\u0012\u0004&o\u001c3vG\u0016\u0014V-];fgR$2AO#H!\tY4)D\u0001=\u0015\tid(\u0001\u0005sKF,Xm\u001d;t\u0015\ty\u0004)\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\u0005S!A\u0011\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t!EHA\bQe>$WoY3SKN\u0004xN\\:f\u0011\u00151u\u00071\u0001)\u0003!aW-\u00193fe&#\u0007\"\u0002%8\u0001\u0004I\u0015a\u0002:fcV,7\u000f\u001e\t\u0003w)K!a\u0013\u001f\u0003\u001dA\u0013x\u000eZ;dKJ+\u0017/^3ti\u0002")
public class ProduceRequestTest
extends BaseRequestTest {
    @Test
    public void testSimpleProduceRequest() {
        Tuple2<Object, Object> tuple2 = this.createTopicAndFindPartitionWithLeader("topic");
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int partition = tuple2._1$mcI$sp();
            int leader = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(partition, leader);
            int partition2 = sp3._1$mcI$sp();
            int leader2 = sp3._2$mcI$sp();
            ByteBuffer messageBuffer = new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("value".getBytes(), "key".getBytes(), System.currentTimeMillis(), 1)})).buffer();
            TopicPartition topicPartition = new TopicPartition("topic", partition2);
            scala.collection.immutable.Map partitionRecords = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)messageBuffer)}));
            ProduceResponse produceResponse = this.sendProduceRequest(leader2, new ProduceRequest(-1, 3000, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRecords).asJava()));
            Assert.assertEquals((long)1L, (long)produceResponse.responses().size());
            Tuple2 tuple22 = (Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(produceResponse.responses()).asScala()).head();
            if (tuple22 != null) {
                Tuple2 tuple23;
                TopicPartition tp = (TopicPartition)tuple22._1();
                ProduceResponse.PartitionResponse partitionResponse = (ProduceResponse.PartitionResponse)tuple22._2();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)tp, (Object)partitionResponse);
                TopicPartition tp2 = (TopicPartition)tuple24._1();
                ProduceResponse.PartitionResponse partitionResponse2 = (ProduceResponse.PartitionResponse)tuple24._2();
                Assert.assertEquals((Object)topicPartition, (Object)tp2);
                Assert.assertEquals((long)Errors.NONE.code(), (long)partitionResponse2.errorCode);
                Assert.assertEquals((long)0L, (long)partitionResponse2.baseOffset);
                Assert.assertEquals((long)-1L, (long)partitionResponse2.timestamp);
                return;
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError(tuple2);
    }

    private Tuple2<Object, Object> createTopicAndFindPartitionWithLeader(String topic) {
        scala.collection.immutable.Map<Object, Option<Object>> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, 3, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        return (Tuple2)partitionToLeader.collectFirst((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, Option<Object>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    Some some;
                    int leader;
                    int partition = A1._1$mcI$sp();
                    Option option = (Option)A1._2();
                    if (option instanceof Some && (leader = BoxesRunTime.unboxToInt((Object)(some = (Some)option).x())) != -1) {
                        object = new Tuple2.mcII.sp(partition, leader);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, Option<Object>> x1) {
                Some some;
                int leader;
                Option option;
                Tuple2<Object, Option<Object>> tuple2 = x1;
                boolean bl = tuple2 != null && (option = (Option)tuple2._2()) instanceof Some && (leader = BoxesRunTime.unboxToInt((Object)(some = (Some)option).x())) != -1;
                return bl;
            }
        }).getOrElse((Function0)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProduceRequestTest $outer;
            private final String topic$1;

            public final Nothing$ apply() {
                return this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No leader elected for topic ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
            }
        });
    }

    @Test
    public void testCorruptLz4ProduceRequest() {
        Tuple2<Object, Object> tuple2 = this.createTopicAndFindPartitionWithLeader("topic");
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int partition = tuple2._1$mcI$sp();
            int leader = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(partition, leader);
            int partition2 = sp3._1$mcI$sp();
            int leader2 = sp3._2$mcI$sp();
            ByteBuffer messageBuffer = new ByteBufferMessageSet((CompressionCodec)LZ4CompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("value".getBytes(), "key".getBytes(), System.currentTimeMillis(), 1)})).buffer();
            messageBuffer.array()[40] = 0;
            TopicPartition topicPartition = new TopicPartition("topic", partition2);
            scala.collection.immutable.Map partitionRecords = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)messageBuffer)}));
            ProduceResponse produceResponse = this.sendProduceRequest(leader2, new ProduceRequest(-1, 3000, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRecords).asJava()));
            Assert.assertEquals((long)1L, (long)produceResponse.responses().size());
            Tuple2 tuple22 = (Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(produceResponse.responses()).asScala()).head();
            if (tuple22 != null) {
                Tuple2 tuple23;
                TopicPartition tp = (TopicPartition)tuple22._1();
                ProduceResponse.PartitionResponse partitionResponse = (ProduceResponse.PartitionResponse)tuple22._2();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)tp, (Object)partitionResponse);
                TopicPartition tp2 = (TopicPartition)tuple24._1();
                ProduceResponse.PartitionResponse partitionResponse2 = (ProduceResponse.PartitionResponse)tuple24._2();
                Assert.assertEquals((Object)topicPartition, (Object)tp2);
                Assert.assertEquals((long)Errors.CORRUPT_MESSAGE.code(), (long)partitionResponse2.errorCode);
                Assert.assertEquals((long)-1L, (long)partitionResponse2.baseOffset);
                Assert.assertEquals((long)-1L, (long)partitionResponse2.timestamp);
                return;
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError(tuple2);
    }

    private ProduceResponse sendProduceRequest(int leaderId, ProduceRequest request) {
        Socket socket = this.connect((SocketServer)this.servers().find((Function1)new Serializable(this, leaderId){
            public static final long serialVersionUID = 0L;
            private final int leaderId$1;

            public final boolean apply(KafkaServer x$5) {
                return x$5.config().brokerId() == this.leaderId$1;
            }
            {
                this.leaderId$1 = leaderId$1;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SocketServer apply(KafkaServer x$6) {
                return x$6.socketServer();
            }
        }).getOrElse((Function0)new Serializable(this, leaderId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProduceRequestTest $outer;
            private final int leaderId$1;

            public final Nothing$ apply() {
                return this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find broker with id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.leaderId$1)})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.leaderId$1 = leaderId$1;
            }
        }), this.connect$default$2());
        ByteBuffer response = this.send(socket, (AbstractRequest)request, ApiKeys.PRODUCE, ProtoUtils.latestVersion((int)ApiKeys.PRODUCE.id));
        return ProduceResponse.parse((ByteBuffer)response);
    }
}

