/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import kafka.common.LongRef;
import kafka.log.FileMessageSet;
import kafka.log.LogSegment;
import kafka.log.LogSegmentTest$;
import kafka.log.OffsetIndex;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.NoCompressionCodec$;
import kafka.server.FetchDataInfo;
import kafka.utils.SystemTime$;
import kafka.utils.TestUtils$;
import kafka.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\u0001\u0003\u0001\u001d\u0011a\u0002T8h'\u0016<W.\u001a8u)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0001+\u0005A1/Z4nK:$8/F\u0001\u0017!\r9BDH\u0007\u00021)\u0011\u0011DG\u0001\b[V$\u0018M\u00197f\u0015\tY\"\"\u0001\u0006d_2dWm\u0019;j_:L!!\b\r\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0003%}I!\u0001\t\u0002\u0003\u00151{wmU3h[\u0016tG\u000f\u0003\u0004#\u0001\u0001\u0006IAF\u0001\ng\u0016<W.\u001a8ug\u0002BQ\u0001\n\u0001\u0005\u0002\u0015\nQb\u0019:fCR,7+Z4nK:$HC\u0001\u0010'\u0011\u001593\u00051\u0001)\u0003\u0019ygMZ:fiB\u0011\u0011\"K\u0005\u0003U)\u0011A\u0001T8oO\")A\u0006\u0001C\u0001[\u0005AQ.Z:tC\u001e,7\u000fF\u0002/iU\u0002\"a\f\u001a\u000e\u0003AR!!\r\u0003\u0002\u000f5,7o]1hK&\u00111\u0007\r\u0002\u0015\u0005f$XMQ;gM\u0016\u0014X*Z:tC\u001e,7+\u001a;\t\u000b\u001dZ\u0003\u0019\u0001\u0015\t\u000b1Z\u0003\u0019\u0001\u001c\u0011\u0007%9\u0014(\u0003\u00029\u0015\tQAH]3qK\u0006$X\r\u001a \u0011\u0005ijdBA\u0005<\u0013\ta$\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003}}\u0012aa\u0015;sS:<'B\u0001\u001f\u000b\u0011\u0015\t\u0005\u0001\"\u0001C\u0003!!X-\u0019:e_^tG#A\"\u0011\u0005%!\u0015BA#\u000b\u0005\u0011)f.\u001b;)\u0005\u0001;\u0005C\u0001%N\u001b\u0005I%B\u0001&L\u0003\u0015QWO\\5u\u0015\u0005a\u0015aA8sO&\u0011a*\u0013\u0002\u0006\u0003\u001a$XM\u001d\u0005\u0006!\u0002!\tAQ\u0001\u0017i\u0016\u001cHOU3bI>sW)\u001c9usN+w-\\3oi\"\u0012qJ\u0015\t\u0003\u0011NK!\u0001V%\u0003\tQ+7\u000f\u001e\u0005\u0006-\u0002!\tAQ\u0001\u001ai\u0016\u001cHOU3bI\n+gm\u001c:f\r&\u00148\u000f^(gMN,G\u000f\u000b\u0002V%\")\u0011\f\u0001C\u0001\u0005\u0006iA/Z:u\u001b\u0006DxJ\u001a4tKRD#\u0001\u0017*\t\u000bq\u0003A\u0011\u0001\"\u0002#Q,7\u000f\u001e*fC\u0012\fe\r^3s\u0019\u0006\u001cH\u000f\u000b\u0002\\%\")q\f\u0001C\u0001\u0005\u0006yA/Z:u%\u0016\fGM\u0012:p[\u001e\u000b\u0007\u000f\u000b\u0002_%\")!\r\u0001C\u0001\u0005\u0006aA/Z:u)J,hnY1uK\"\u0012\u0011M\u0015\u0005\u0006K\u0002!\tAQ\u0001\u0011i\u0016\u001cH\u000f\u0016:v]\u000e\fG/\u001a$vY2D#\u0001\u001a*\t\u000b!\u0004A\u0011\u0001\"\u00023Q,7\u000f\u001e(fqR|eMZ:fi\u000e\u000bGnY;mCRLwN\u001c\u0015\u0003OJCQa\u001b\u0001\u0005\u0002\t\u000ba\u0003^3ti\u000eC\u0017M\\4f\r&dWmU;gM&DXm\u001d\u0015\u0003UJCQA\u001c\u0001\u0005\u0002\t\u000bQ\u0004^3tiJ+7m\u001c<fef4\u0015\u000e_3t\u0007>\u0014(/\u001e9u\u0013:$W\r\u001f\u0015\u0003[JCQ!\u001d\u0001\u0005\u0002\t\u000ba\u0004^3tiJ+7m\u001c<fef<\u0016\u000e\u001e5D_J\u0014X\u000f\u001d;NKN\u001c\u0018mZ3)\u0005A\u0014\u0006\"\u0002\u0013\u0001\t\u0003!HC\u0002\u0010vmn\f\t\u0001C\u0003(g\u0002\u0007\u0001\u0006C\u0004xgB\u0005\t\u0019\u0001=\u0002#\u0019LG.Z!me\u0016\fG-_#ySN$8\u000f\u0005\u0002\ns&\u0011!P\u0003\u0002\b\u0005>|G.Z1o\u0011\u001da8\u000f%AA\u0002u\fA\"\u001b8ji\u001aKG.Z*ju\u0016\u0004\"!\u0003@\n\u0005}T!aA%oi\"A\u00111A:\u0011\u0002\u0003\u0007\u00010A\u0006qe\u0016\fG\u000e\\8dCR,\u0007BBA\u0004\u0001\u0011\u0005!)A\u0014uKN$8I]3bi\u0016<\u0016\u000e\u001e5J]&$h)\u001b7f'&TX-\u00119qK:$W*Z:tC\u001e,\u0007fAA\u0003%\"1\u0011Q\u0002\u0001\u0005\u0002\t\u000bq\u0005^3ti\u000e\u0013X-\u0019;f/&$\b.\u00138ji\u001aKG.Z*ju\u0016\u001cE.Z1s'\",H\u000fZ8x]\"\u001a\u00111\u0002*\t\u0013\u0005M\u0001!%A\u0005\u0002\u0005U\u0011aF2sK\u0006$XmU3h[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\t9BK\u0002y\u00033Y#!a\u0007\u0011\t\u0005u\u0011qE\u0007\u0003\u0003?QA!!\t\u0002$\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003KQ\u0011AC1o]>$\u0018\r^5p]&!\u0011\u0011FA\u0010\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003[\u0001\u0011\u0013!C\u0001\u0003_\tqc\u0019:fCR,7+Z4nK:$H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005E\"fA?\u0002\u001a!I\u0011Q\u0007\u0001\u0012\u0002\u0013\u0005\u0011QC\u0001\u0018GJ,\u0017\r^3TK\u001elWM\u001c;%I\u00164\u0017-\u001e7uIQ\u0002")
public class LogSegmentTest {
    private final ArrayBuffer<LogSegment> segments = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);

    public ArrayBuffer<LogSegment> segments() {
        return this.segments;
    }

    public LogSegment createSegment(long offset) {
        File msFile = TestUtils$.MODULE$.tempFile();
        FileMessageSet ms = new FileMessageSet(msFile);
        File idxFile = TestUtils$.MODULE$.tempFile();
        idxFile.delete();
        OffsetIndex idx = new OffsetIndex(idxFile, offset, 1000);
        LogSegment seg = new LogSegment(ms, idx, offset, 10, 0L, (Time)SystemTime$.MODULE$);
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public ByteBufferMessageSet messages(long offset, Seq<String> messages2) {
        return new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, new LongRef(offset), (Seq)messages2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Message apply(String s) {
                return new Message(s.getBytes());
            }
        }, Seq$.MODULE$.canBuildFrom()));
    }

    @After
    public void teardown() {
        this.segments().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogSegment seg) {
                seg.index().delete();
                return seg.log().delete();
            }
        });
    }

    @Test
    public void testReadOnEmptySegment() {
        LogSegment seg = this.createSegment(40L);
        long x$3 = 40L;
        int x$4 = 300;
        None$ x$5 = None$.MODULE$;
        long x$6 = seg.read$default$4();
        FetchDataInfo read = seg.read(x$3, (Option)x$5, x$4, x$6);
        Assert.assertNull((String)"Read beyond the last offset in the segment should be null", (Object)read);
    }

    @Test
    public void testReadBeforeFirstOffset() {
        LogSegment seg = this.createSegment(40L);
        ByteBufferMessageSet ms = this.messages(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "little", "bee"}));
        seg.append(50L, ms);
        long x$7 = 41L;
        int x$8 = 300;
        None$ x$9 = None$.MODULE$;
        long x$10 = seg.read$default$4();
        MessageSet read = seg.read(x$7, (Option)x$9, x$8, x$10).messageSet();
        Assert.assertEquals((Object)ms.toList(), (Object)read.toList());
    }

    @Test
    public void testMaxOffset() {
        int baseOffset = 50;
        LogSegment seg = this.createSegment(baseOffset);
        ByteBufferMessageSet ms = this.messages(baseOffset, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "beautiful"}));
        seg.append((long)baseOffset, ms);
        this.validate$1(50L, seg, ms);
        this.validate$1(51L, seg, ms);
        this.validate$1(52L, seg, ms);
    }

    @Test
    public void testReadAfterLast() {
        LogSegment seg = this.createSegment(40L);
        ByteBufferMessageSet ms = this.messages(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(50L, ms);
        long x$15 = 52L;
        int x$16 = 200;
        None$ x$17 = None$.MODULE$;
        long x$18 = seg.read$default$4();
        FetchDataInfo read = seg.read(x$15, (Option)x$17, x$16, x$18);
        Assert.assertNull((String)"Read beyond the last offset in the segment should give null", (Object)read);
    }

    @Test
    public void testReadFromGap() {
        LogSegment seg = this.createSegment(40L);
        ByteBufferMessageSet ms = this.messages(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(50L, ms);
        ByteBufferMessageSet ms2 = this.messages(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(60L, ms2);
        long x$19 = 55L;
        int x$20 = 200;
        None$ x$21 = None$.MODULE$;
        long x$22 = seg.read$default$4();
        FetchDataInfo read = seg.read(x$19, (Option)x$21, x$20, x$22);
        Assert.assertEquals((Object)ms2.toList(), (Object)read.messageSet().toList());
    }

    @Test
    public void testTruncate() {
        LogSegment seg = this.createSegment(40L);
        IntRef offset = IntRef.create((int)40);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 30).foreach$mVc$sp((Function1)new Serializable(this, seg, offset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegmentTest $outer;
            private final LogSegment seg$2;
            private final IntRef offset$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                ByteBufferMessageSet ms1 = this.$outer.messages(this.offset$2.elem, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
                this.seg$2.append((long)this.offset$2.elem, ms1);
                ByteBufferMessageSet ms2 = this.$outer.messages(this.offset$2.elem + 1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
                this.seg$2.append((long)(this.offset$2.elem + 1), ms2);
                FetchDataInfo read = this.seg$2.read((long)this.offset$2.elem, (Option)None$.MODULE$, 10000, this.seg$2.read$default$4());
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MessageAndOffset[]{(MessageAndOffset)ms1.head(), (MessageAndOffset)ms2.head()})), (Object)read.messageSet().toList());
                this.seg$2.truncateTo((long)(this.offset$2.elem + 1));
                FetchDataInfo read2 = this.seg$2.read((long)this.offset$2.elem, (Option)None$.MODULE$, 10000, this.seg$2.read$default$4());
                Assert.assertEquals((long)1L, (long)read2.messageSet().size());
                Assert.assertEquals((Object)ms1.head(), (Object)read2.messageSet().head());
                ++this.offset$2.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.seg$2 = seg$2;
                this.offset$2 = offset$2;
            }
        });
    }

    @Test
    public void testTruncateFull() {
        LogSegment seg = this.createSegment(40L);
        seg.append(40L, this.messages(40L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
        seg.truncateTo(0L);
        Assert.assertNull((String)"Segment should be empty.", (Object)seg.read(0L, (Option)None$.MODULE$, 1024, seg.read$default$4()));
        seg.append(40L, this.messages(40L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
    }

    @Test
    public void testNextOffsetCalculation() {
        LogSegment seg = this.createSegment(40L);
        Assert.assertEquals((long)40L, (long)seg.nextOffset());
        seg.append(50L, this.messages(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "you"})));
        Assert.assertEquals((long)53L, (long)seg.nextOffset());
    }

    @Test
    public void testChangeFileSuffixes() {
        LogSegment seg = this.createSegment(40L);
        File logFile = seg.log().file();
        File indexFile = seg.index().file();
        seg.changeFileSuffixes("", ".deleted");
        Assert.assertEquals((Object)new StringBuilder().append((Object)logFile.getAbsolutePath()).append((Object)".deleted").toString(), (Object)seg.log().file().getAbsolutePath());
        Assert.assertEquals((Object)new StringBuilder().append((Object)indexFile.getAbsolutePath()).append((Object)".deleted").toString(), (Object)seg.index().file().getAbsolutePath());
        Assert.assertTrue((boolean)seg.log().file().exists());
        Assert.assertTrue((boolean)seg.index().file().exists());
    }

    @Test
    public void testRecoveryFixesCorruptIndex() {
        LogSegment seg = this.createSegment(0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)new Serializable(this, seg){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegmentTest $outer;
            private final LogSegment seg$3;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.seg$3.append((long)i, this.$outer.messages(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)i)).toString()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.seg$3 = seg$3;
            }
        });
        File indexFile = seg.index().file();
        TestUtils$.MODULE$.writeNonsenseToFile(indexFile, 5L, (int)indexFile.length());
        seg.recover(65536);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)new Serializable(this, seg){
            public static final long serialVersionUID = 0L;
            private final LogSegment seg$3;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((long)i, (long)((MessageAndOffset)this.seg$3.read((long)i, (Option)new Some((Object)BoxesRunTime.boxToLong((long)(i + 1))), 1024, this.seg$3.read$default$4()).messageSet().head()).offset());
            }
            {
                this.seg$3 = seg$3;
            }
        });
    }

    @Test
    public void testRecoveryWithCorruptMessage() {
        int messagesAppended = 20;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, messagesAppended){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegmentTest $outer;
            private final int messagesAppended$1;

            public final void apply(int iteration) {
                this.apply$mcVI$sp(iteration);
            }

            public void apply$mcVI$sp(int iteration) {
                LogSegment seg = this.$outer.createSegment(0L);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.messagesAppended$1).foreach$mVc$sp((Function1)new Serializable(this, seg){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testRecoveryWithCorruptMessage$1 $outer;
                    private final LogSegment seg$4;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.seg$4.append((long)i, this.$outer.kafka$log$LogSegmentTest$$anonfun$$$outer().messages(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)i)).toString()})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.seg$4 = seg$4;
                    }
                });
                int offsetToBeginCorruption = TestUtils$.MODULE$.random().nextInt(this.messagesAppended$1);
                int position = seg.log().searchFor((long)offsetToBeginCorruption, 0).position() + TestUtils$.MODULE$.random().nextInt(15);
                TestUtils$.MODULE$.writeNonsenseToFile(seg.log().file(), position, (int)seg.log().file().length() - position);
                seg.recover(65536);
                Assert.assertEquals((String)"Should have truncated off bad messages.", (Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), offsetToBeginCorruption).toList(), (Object)((TraversableOnce)seg.log().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(MessageAndOffset x$2) {
                        return x$2.offset();
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toList());
                seg.delete();
            }

            public /* synthetic */ LogSegmentTest kafka$log$LogSegmentTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.messagesAppended$1 = messagesAppended$1;
            }
        });
    }

    public LogSegment createSegment(long offset, boolean fileAlreadyExists, int initFileSize, boolean preallocate) {
        File tempDir = TestUtils$.MODULE$.tempDir();
        LogSegment seg = new LogSegment(tempDir, offset, 10, 1000, 0L, (Time)SystemTime$.MODULE$, fileAlreadyExists, initFileSize, preallocate);
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public boolean createSegment$default$2() {
        return false;
    }

    public int createSegment$default$3() {
        return 0;
    }

    public boolean createSegment$default$4() {
        return false;
    }

    @Test
    public void testCreateWithInitFileSizeAppendMessage() {
        LogSegment seg = this.createSegment(40L, false, 0x20000000, true);
        ByteBufferMessageSet ms = this.messages(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(50L, ms);
        ByteBufferMessageSet ms2 = this.messages(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(60L, ms2);
        long x$23 = 55L;
        int x$24 = 200;
        None$ x$25 = None$.MODULE$;
        long x$26 = seg.read$default$4();
        FetchDataInfo read = seg.read(x$23, (Option)x$25, x$24, x$26);
        Assert.assertEquals((Object)ms2.toList(), (Object)read.messageSet().toList());
    }

    @Test
    public void testCreateWithInitFileSizeClearShutdown() {
        File tempDir = TestUtils$.MODULE$.tempDir();
        LogSegment seg = new LogSegment(tempDir, 40L, 10, 1000, 0L, (Time)SystemTime$.MODULE$, false, 0x20000000, true);
        ByteBufferMessageSet ms = this.messages(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(50L, ms);
        ByteBufferMessageSet ms2 = this.messages(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(60L, ms2);
        long x$27 = 55L;
        int x$28 = 200;
        None$ x$29 = None$.MODULE$;
        long x$30 = seg.read$default$4();
        FetchDataInfo read = seg.read(x$27, (Option)x$29, x$28, x$30);
        Assert.assertEquals((Object)ms2.toList(), (Object)read.messageSet().toList());
        int oldSize = seg.log().sizeInBytes();
        long oldPosition = seg.log().channel().position();
        long oldFileSize = seg.log().file().length();
        Assert.assertEquals((long)0x20000000L, (long)oldFileSize);
        seg.close();
        Assert.assertEquals((long)oldSize, (long)seg.log().file().length());
        LogSegment segReopen = new LogSegment(tempDir, 40L, 10, 1000, 0L, (Time)SystemTime$.MODULE$, true, 0x20000000, true);
        this.segments().$plus$eq((Object)segReopen);
        long x$31 = 55L;
        int x$32 = 200;
        None$ x$33 = None$.MODULE$;
        long x$34 = segReopen.read$default$4();
        FetchDataInfo readAgain = segReopen.read(x$31, (Option)x$33, x$32, x$34);
        Assert.assertEquals((Object)ms2.toList(), (Object)readAgain.messageSet().toList());
        int size2 = segReopen.log().sizeInBytes();
        long position = segReopen.log().channel().position();
        long fileSize = segReopen.log().file().length();
        Assert.assertEquals((long)oldPosition, (long)position);
        Assert.assertEquals((long)oldSize, (long)size2);
        Assert.assertEquals((long)size2, (long)fileSize);
    }

    private final void validate$1(long offset, LogSegment seg$1, ByteBufferMessageSet ms$1) {
        long x$11 = offset;
        int x$12 = 1024;
        Some x$13 = new Some((Object)BoxesRunTime.boxToLong((long)(offset + 1L)));
        long x$14 = seg$1.read$default$4();
        Assert.assertEquals((Object)((TraversableOnce)ms$1.filter((Function1)new Serializable(this, offset){
            public static final long serialVersionUID = 0L;
            private final long offset$1;

            public final boolean apply(MessageAndOffset x$1) {
                return x$1.offset() == this.offset$1;
            }
            {
                this.offset$1 = offset$1;
            }
        })).toList(), (Object)seg$1.read(x$11, (Option)x$13, x$12, x$14).messageSet().toList());
    }
}

