/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.common.TopicAndPartition;
import kafka.coordinator.AwaitingSync$;
import kafka.coordinator.GroupCoordinator;
import kafka.coordinator.GroupCoordinator$;
import kafka.coordinator.GroupOverview;
import kafka.coordinator.GroupSummary;
import kafka.coordinator.JoinGroupResult;
import kafka.coordinator.MemberSummary;
import kafka.message.Message$;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.utils.KafkaScheduler;
import kafka.utils.MockTime$;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.timer.MockTimer;
import kafka.utils.timer.Timer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ProduceResponse;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0011ma\u0001B\u0001\u0003\u0001\u001d\u0011Ad\u0012:pkB\u001cun\u001c:eS:\fGo\u001c:SKN\u0004xN\\:f)\u0016\u001cHO\u0003\u0002\u0004\t\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\t\u000e\u0003)Q!a\u0003\u0007\u0002\u000b),h.\u001b;\u000b\u00055q\u0011!C:dC2\fG/Z:u\u0015\u0005y\u0011aA8sO&\u0011\u0011C\u0003\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007\"B\n\u0001\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\u0016!\t1\u0002!D\u0001\u0003\u000b\u0011A\u0002\u0001A\r\u0003#){\u0017N\\$s_V\u00048)\u00197mE\u0006\u001c7\u000e\u0005\u0003\u001b;}\u0011S\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001\f!\u0013\t\t#AA\bK_&twI]8vaJ+7/\u001e7u!\tQ2%\u0003\u0002%7\t!QK\\5u\u000b\u00111\u0003\u0001A\u0014\u0003/MKhnY$s_V\u00048)\u00197mE\u0006\u001c7\u000eU1sC6\u001c\b\u0003\u0002\u000e)UAJ!!K\u000e\u0003\rQ+\b\u000f\\33!\rQ2&L\u0005\u0003Ym\u0011Q!\u0011:sCf\u0004\"A\u0007\u0018\n\u0005=Z\"\u0001\u0002\"zi\u0016\u0004\"AG\u0019\n\u0005IZ\"!B*i_J$X\u0001\u0002\u001b\u0001\u0001U\u0012\u0011cU=oG\u001e\u0013x.\u001e9DC2d'-Y2l!\u0015QbG\u000b\u0019#\u0013\t94DA\u0005Gk:\u001cG/[8oe\u0015!\u0011\b\u0001\u00011\u0005]AU-\u0019:uE\u0016\fGoQ1mY\n\f7m\u001b)be\u0006l7/\u0002\u0003<\u0001\u0001a$!\u0005%fCJ$(-Z1u\u0007\u0006dGNY1dWB!!$\b\u0019#\u000b\u0011q\u0004\u0001A \u00035\r{W.\\5u\u001f\u001a47/\u001a;DC2d'-Y2l!\u0006\u0014\u0018-\\:\u0011\t\u0001\u001bU\tM\u0007\u0002\u0003*\u0011!iG\u0001\u000bG>dG.Z2uS>t\u0017B\u0001#B\u0005\ri\u0015\r\u001d\t\u0003\r2k\u0011a\u0012\u0006\u0003\u0011&\u000baaY8n[>t'BA\u0003K\u0015\tYe\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003\u001b\u001e\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0002\u0003P\u0001\u0001\u0001&\u0001F\"p[6LGo\u00144gg\u0016$8)\u00197mE\u0006\u001c7\u000e\u0005\u0003\u001b;}\u0012S\u0001\u0002*\u0001\u0001A\u0012\u0001\u0004T3bm\u0016<%o\\;q\u0007\u0006dGNY1dWB\u000b'/Y7t\u000b\u0011!\u0006\u0001\u0001\u001f\u0003%1+\u0017M^3He>,\boQ1mY\n\f7m\u001b\u0005\b-\u0002\u0011\r\u0011\"\u0001X\u0003!\u0019E.[3oi&#W#\u0001-\u0011\u0005esV\"\u0001.\u000b\u0005mc\u0016\u0001\u00027b]\u001eT\u0011!X\u0001\u0005U\u00064\u0018-\u0003\u0002`5\n11\u000b\u001e:j]\u001eDa!\u0019\u0001!\u0002\u0013A\u0016!C\"mS\u0016tG/\u00133!\u0011\u001d\u0019\u0007A1A\u0005\u0002]\u000b!b\u00117jK:$\bj\\:u\u0011\u0019)\u0007\u0001)A\u00051\u0006Y1\t\\5f]RDun\u001d;!\u0011\u001d9\u0007A1A\u0005\u0002!\f\u0011dQ8ogVlWM]'j]N+7o]5p]RKW.Z8viV\t\u0011\u000e\u0005\u0002\u001bU&\u00111n\u0007\u0002\u0004\u0013:$\bBB7\u0001A\u0003%\u0011.\u0001\u000eD_:\u001cX/\\3s\u001b&t7+Z:tS>tG+[7f_V$\b\u0005C\u0004p\u0001\t\u0007I\u0011\u00015\u00023\r{gn];nKJl\u0015\r_*fgNLwN\u001c+j[\u0016|W\u000f\u001e\u0005\u0007c\u0002\u0001\u000b\u0011B5\u00025\r{gn];nKJl\u0015\r_*fgNLwN\u001c+j[\u0016|W\u000f\u001e\u0011\t\u000fM\u0004!\u0019!C\u0001Q\u0006)B)\u001a4bk2$8+Z:tS>tG+[7f_V$\bBB;\u0001A\u0003%\u0011.\u0001\fEK\u001a\fW\u000f\u001c;TKN\u001c\u0018n\u001c8US6,w.\u001e;!\u0011\u001d9\b\u00011A\u0005\u0002a\fQ\u0001^5nKJ,\u0012!\u001f\t\u0003uzl\u0011a\u001f\u0006\u0003orT!! \u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005}\\(!C'pG.$\u0016.\\3s\u0011%\t\u0019\u0001\u0001a\u0001\n\u0003\t)!A\u0005uS6,'o\u0018\u0013fcR\u0019!%a\u0002\t\u0013\u0005%\u0011\u0011AA\u0001\u0002\u0004I\u0018a\u0001=%c!9\u0011Q\u0002\u0001!B\u0013I\u0018A\u0002;j[\u0016\u0014\b\u0005C\u0005\u0002\u0012\u0001\u0001\r\u0011\"\u0001\u0002\u0014\u0005\u0001rM]8va\u000e{wN\u001d3j]\u0006$xN]\u000b\u0003\u0003+\u00012AFA\f\u0013\r\tIB\u0001\u0002\u0011\u000fJ|W\u000f]\"p_J$\u0017N\\1u_JD\u0011\"!\b\u0001\u0001\u0004%\t!a\b\u0002)\u001d\u0014x.\u001e9D_>\u0014H-\u001b8bi>\u0014x\fJ3r)\r\u0011\u0013\u0011\u0005\u0005\u000b\u0003\u0013\tY\"!AA\u0002\u0005U\u0001\u0002CA\u0013\u0001\u0001\u0006K!!\u0006\u0002#\u001d\u0014x.\u001e9D_>\u0014H-\u001b8bi>\u0014\b\u0005C\u0005\u0002*\u0001\u0001\r\u0011\"\u0001\u0002,\u0005q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014XCAA\u0017!\u0011\ty#!\u000e\u000e\u0005\u0005E\"bAA\u001a\t\u000511/\u001a:wKJLA!a\u000e\u00022\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b\"CA\u001e\u0001\u0001\u0007I\u0011AA\u001f\u0003I\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ|F%Z9\u0015\u0007\t\ny\u0004\u0003\u0006\u0002\n\u0005e\u0012\u0011!a\u0001\u0003[A\u0001\"a\u0011\u0001A\u0003&\u0011QF\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA!I\u0011q\t\u0001A\u0002\u0013\u0005\u0011\u0011J\u0001\ng\u000eDW\rZ;mKJ,\"!a\u0013\u0011\t\u00055\u0013qJ\u0007\u0002y&\u0019\u0011\u0011\u000b?\u0003\u001d-\u000bgm[1TG\",G-\u001e7fe\"I\u0011Q\u000b\u0001A\u0002\u0013\u0005\u0011qK\u0001\u000eg\u000eDW\rZ;mKJ|F%Z9\u0015\u0007\t\nI\u0006\u0003\u0006\u0002\n\u0005M\u0013\u0011!a\u0001\u0003\u0017B\u0001\"!\u0018\u0001A\u0003&\u00111J\u0001\u000bg\u000eDW\rZ;mKJ\u0004\u0003\"CA1\u0001\u0001\u0007I\u0011AA2\u0003\u001dQ8.\u0016;jYN,\"!!\u001a\u0011\t\u00055\u0013qM\u0005\u0004\u0003Sb(a\u0002.l+RLGn\u001d\u0005\n\u0003[\u0002\u0001\u0019!C\u0001\u0003_\n1B_6Vi&d7o\u0018\u0013fcR\u0019!%!\u001d\t\u0015\u0005%\u00111NA\u0001\u0002\u0004\t)\u0007\u0003\u0005\u0002v\u0001\u0001\u000b\u0015BA3\u0003!Q8.\u0016;jYN\u0004\u0003\u0002CA=\u0001\t\u0007I\u0011B,\u0002\u000f\u001d\u0014x.\u001e9JI\"9\u0011Q\u0010\u0001!\u0002\u0013A\u0016\u0001C4s_V\u0004\u0018\n\u001a\u0011\t\u0011\u0005\u0005\u0005A1A\u0005\n]\u000bA\u0002\u001d:pi>\u001cw\u000e\u001c+za\u0016Dq!!\"\u0001A\u0003%\u0001,A\u0007qe>$xnY8m)f\u0004X\r\t\u0005\t\u0003\u0013\u0003!\u0019!C\u0005/\u0006AQ.Z7cKJLE\rC\u0004\u0002\u000e\u0002\u0001\u000b\u0011\u0002-\u0002\u00135,WNY3s\u0013\u0012\u0004\u0003\"CAI\u0001\t\u0007I\u0011BAJ\u0003!iW\r^1eCR\fW#\u0001\u0016\t\u000f\u0005]\u0005\u0001)A\u0005U\u0005IQ.\u001a;bI\u0006$\u0018\r\t\u0005\n\u00037\u0003!\u0019!C\u0005\u0003;\u000b\u0011\u0002\u001d:pi>\u001cw\u000e\\:\u0016\u0005\u0005}\u0005CBAQ\u0003O\u000bY+\u0004\u0002\u0002$*\u0019\u0011QU!\u0002\u0013%lW.\u001e;bE2,\u0017\u0002BAU\u0003G\u0013A\u0001T5tiB!!\u0004\u000b-+\u0011!\ty\u000b\u0001Q\u0001\n\u0005}\u0015A\u00039s_R|7m\u001c7tA!A\u00111\u0017\u0001A\u0002\u0013%\u0001.\u0001\the>,\b\u000fU1si&$\u0018n\u001c8JI\"I\u0011q\u0017\u0001A\u0002\u0013%\u0011\u0011X\u0001\u0015OJ|W\u000f\u001d)beRLG/[8o\u0013\u0012|F%Z9\u0015\u0007\t\nY\fC\u0005\u0002\n\u0005U\u0016\u0011!a\u0001S\"9\u0011q\u0018\u0001!B\u0013I\u0017!E4s_V\u0004\b+\u0019:uSRLwN\\%eA!A\u00111\u0019\u0001C\u0002\u0013%q+\u0001\u0007pi\",'o\u0012:pkBLE\rC\u0004\u0002H\u0002\u0001\u000b\u0011\u0002-\u0002\u001b=$\b.\u001a:He>,\b/\u00133!\u0011\u001d\tY\r\u0001C\u0001\u0003\u001b\fQa]3u+B$\u0012A\t\u0015\u0005\u0003\u0013\f\t\u000e\u0005\u0003\u0002T\u0006]WBAAk\u0015\tYa\"\u0003\u0003\u0002Z\u0006U'A\u0002\"fM>\u0014X\rC\u0004\u0002^\u0002!\t!!4\u0002\u0011Q,\u0017M\u001d#po:DC!a7\u0002bB!\u00111[Ar\u0013\u0011\t)/!6\u0003\u000b\u00053G/\u001a:\t\u000f\u0005%\b\u0001\"\u0001\u0002N\u0006iB/Z:u\u0015>Lgn\u0012:pkB<&o\u001c8h\u0007>|'\u000fZ5oCR|'\u000f\u000b\u0003\u0002h\u00065\b\u0003BAj\u0003_LA!!=\u0002V\n!A+Z:u\u0011\u001d\t)\u0010\u0001C\u0001\u0003\u001b\f1\u0005^3ti*{\u0017N\\$s_V\u00048+Z:tS>tG+[7f_V$Hk\\8T[\u0006dG\u000e\u000b\u0003\u0002t\u00065\bbBA~\u0001\u0011\u0005\u0011QZ\u0001$i\u0016\u001cHOS8j]\u001e\u0013x.\u001e9TKN\u001c\u0018n\u001c8US6,w.\u001e;U_>d\u0015M]4fQ\u0011\tI0!<\t\u000f\t\u0005\u0001\u0001\"\u0001\u0002N\u0006!C/Z:u\u0015>Lgn\u0012:pkB,fn\u001b8po:\u001cuN\\:v[\u0016\u0014h*Z<He>,\b\u000f\u000b\u0003\u0002\u0000\u00065\bb\u0002B\u0004\u0001\u0011\u0005\u0011QZ\u0001\u0013i\u0016\u001cH/\u00138wC2LGm\u0012:pkBLE\r\u000b\u0003\u0003\u0006\u00055\bb\u0002B\u0007\u0001\u0011\u0005\u0011QZ\u0001\u0013i\u0016\u001cHOV1mS\u0012Tu.\u001b8He>,\b\u000f\u000b\u0003\u0003\f\u00055\bb\u0002B\n\u0001\u0011\u0005\u0011QZ\u0001&i\u0016\u001cHOS8j]\u001e\u0013x.\u001e9J]\u000e|gn]5ti\u0016tG\u000f\u0015:pi>\u001cw\u000e\u001c+za\u0016DCA!\u0005\u0002n\"9!\u0011\u0004\u0001\u0005\u0002\u00055\u0017A\n;fgRTu.\u001b8He>,\b/\u00138d_:\u001c\u0018n\u001d;f]R<%o\\;q!J|Go\\2pY\"\"!qCAw\u0011\u001d\u0011y\u0002\u0001C\u0001\u0003\u001b\f\u0011\u0006^3ti*{\u0017N\\$s_V\u0004XK\\6o_^t7i\u001c8tk6,'/\u0012=jgRLgnZ$s_V\u0004\b\u0006\u0002B\u000f\u0003[DqA!\n\u0001\t\u0003\ti-A\u000fuKN$\b*Z1si\n,\u0017\r^,s_:<7i\\8sI&t\u0017\r^8sQ\u0011\u0011\u0019#!<\t\u000f\t-\u0002\u0001\"\u0001\u0002N\u0006IB/Z:u\u0011\u0016\f'\u000f\u001e2fCR,fn\u001b8po:<%o\\;qQ\u0011\u0011I#!<\t\u000f\tE\u0002\u0001\"\u0001\u0002N\u0006IC/Z:u\u0011\u0016\f'\u000f\u001e2fCR,fn\u001b8po:\u001cuN\\:v[\u0016\u0014X\t_5ti&twm\u0012:pkBDCAa\f\u0002n\"9!q\u0007\u0001\u0005\u0002\u00055\u0017\u0001\t;fgRDU-\u0019:uE\u0016\fGOU3cC2\fgnY3J]B\u0013xn\u001a:fgNDCA!\u000e\u0002n\"9!Q\b\u0001\u0005\u0002\u00055\u0017A\b;fgRDU-\u0019:uE\u0016\fG/\u00137mK\u001e\fGnR3oKJ\fG/[8oQ\u0011\u0011Y$!<\t\u000f\t\r\u0003\u0001\"\u0001\u0002N\u0006\u0011B/Z:u-\u0006d\u0017\u000e\u001a%fCJ$(-Z1uQ\u0011\u0011\t%!<\t\u000f\t%\u0003\u0001\"\u0001\u0002N\u0006\u0011B/Z:u'\u0016\u001c8/[8o)&lWm\\;uQ\u0011\u00119%!<\t\u000f\t=\u0003\u0001\"\u0001\u0002N\u0006iB/Z:u\u0011\u0016\f'\u000f\u001e2fCRl\u0015-\u001b8uC&t7oU3tg&|g\u000e\u000b\u0003\u0003N\u00055\bb\u0002B+\u0001\u0011\u0005\u0011QZ\u0001\u001bi\u0016\u001cHoQ8n[&$X*Y5oi\u0006Lgn]*fgNLwN\u001c\u0015\u0005\u0005'\ni\u000fC\u0004\u0003\\\u0001!\t!!4\u00029Q,7\u000f^*z]\u000e<%o\\;q\u000b6\u0004H/_!tg&<g.\\3oi\"\"!\u0011LAw\u0011\u001d\u0011\t\u0007\u0001C\u0001\u0003\u001b\f1\u0004^3tiNKhnY$s_V\u0004hj\u001c;D_>\u0014H-\u001b8bi>\u0014\b\u0006\u0002B0\u0003[DqAa\u001a\u0001\t\u0003\ti-A\u000fuKN$8+\u001f8d\u000fJ|W\u000f\u001d$s_6,fn\u001b8po:<%o\\;qQ\u0011\u0011)'!<\t\u000f\t5\u0004\u0001\"\u0001\u0002N\u0006qB/Z:u'ft7m\u0012:pkB4%o\\7V].twn\u001e8NK6\u0014WM\u001d\u0015\u0005\u0005W\ni\u000fC\u0004\u0003t\u0001!\t!!4\u0002EQ,7\u000f^*z]\u000e<%o\\;q\rJ|W.\u00137mK\u001e\fGnR3oKJ\fG/[8oQ\u0011\u0011\t(!<\t\u000f\te\u0004\u0001\"\u0001\u0002N\u0006\u0011D/Z:u\u0015>Lgn\u0012:pkB4%o\\7V]\u000eD\u0017M\\4fI\u001a{G\u000e\\8xKJ$u.Z:O_R\u0014VMY1mC:\u001cW\r\u000b\u0003\u0003x\u00055\bb\u0002B@\u0001\u0011\u0005\u0011QZ\u00010i\u0016\u001cHOS8j]\u001e\u0013x.\u001e9Ge>lWK\\2iC:<W\r\u001a'fC\u0012,'o\u00155pk2$'+\u001a2bY\u0006t7-\u001a\u0015\u0005\u0005{\ni\u000fC\u0004\u0003\u0006\u0002!\t!!4\u00029Q,7\u000f\u001e'fC\u0012,'OR1jYV\u0014X-\u00138Ts:\u001cwI]8va\"\"!1QAw\u0011\u001d\u0011Y\t\u0001C\u0001\u0003\u001b\f\u0001\u0005^3tiNKhnY$s_V\u0004hi\u001c7m_^,'/\u00114uKJdU-\u00193fe\"\"!\u0011RAw\u0011\u001d\u0011\t\n\u0001C\u0001\u0003\u001b\f\u0001\u0005^3tiNKhnY$s_V\u0004H*Z1eKJ\fe\r^3s\r>dGn\\<fe\"\"!qRAw\u0011\u001d\u00119\n\u0001C\u0001\u0003\u001b\f\u0001\u0005^3ti\u000e{W.\\5u\u001f\u001a47/\u001a;Ge>lWK\\6o_^twI]8va\"\"!QSAw\u0011\u001d\u0011i\n\u0001C\u0001\u0003\u001b\fQ\u0005^3ti\u000e{W.\\5u\u001f\u001a47/\u001a;XSRDG)\u001a4bk2$x)\u001a8fe\u0006$\u0018n\u001c8)\t\tm\u0015Q\u001e\u0005\b\u0005G\u0003A\u0011AAg\u0003y!Xm\u001d;D_6l\u0017\u000e^(gMN,G/\u00138Bo\u0006LG/\u001b8h'ft7\r\u000b\u0003\u0003\"\u00065\bb\u0002BU\u0001\u0011\u0005\u0011QZ\u00016i\u0016\u001cH\u000fS3beR\u0014W-\u0019;EkJLgn\u001a*fE\u0006d\u0017M\\2f\u0007\u0006,8/Z:SK\n\fG.\u00198dK&s\u0007K]8he\u0016\u001c8\u000f\u000b\u0003\u0003(\u00065\bb\u0002BX\u0001\u0011\u0005\u0011QZ\u0001&i\u0016\u001cHoR3oKJ\fG/[8o\u0013\u0012Len\u0019:f[\u0016tGo](o%\u0016\u0014\u0017\r\\1oG\u0016DCA!,\u0002n\"9!Q\u0017\u0001\u0005\u0002\u00055\u0017A\b;fgRdU-\u0019<f\u000fJ|W\u000f],s_:<7i\\8sI&t\u0017\r^8sQ\u0011\u0011\u0019,!<\t\u000f\tm\u0006\u0001\"\u0001\u0002N\u0006QB/Z:u\u0019\u0016\fg/Z$s_V\u0004XK\\6o_^twI]8va\"\"!\u0011XAw\u0011\u001d\u0011\t\r\u0001C\u0001\u0003\u001b\f!\u0006^3ti2+\u0017M^3He>,\b/\u00168l]><hnQ8ogVlWM]#ySN$\u0018N\\4He>,\b\u000f\u000b\u0003\u0003@\u00065\bb\u0002Bd\u0001\u0011\u0005\u0011QZ\u0001\u0014i\u0016\u001cHOV1mS\u0012dU-\u0019<f\u000fJ|W\u000f\u001d\u0015\u0005\u0005\u000b\fi\u000fC\u0004\u0003N\u0002!\t!!4\u0002EQ,7\u000f\u001e'jgR<%o\\;qg&s7\r\\;eKN\u001cF/\u00192mK\u001e\u0013x.\u001e9tQ\u0011\u0011Y-!<\t\u000f\tM\u0007\u0001\"\u0001\u0002N\u00069C/Z:u\u0019&\u001cHo\u0012:pkB\u001c\u0018J\\2mk\u0012,7OU3cC2\fgnY5oO\u001e\u0013x.\u001e9tQ\u0011\u0011\t.!<\t\u000f\te\u0007\u0001\"\u0001\u0002N\u0006\tC/Z:u\t\u0016\u001c8M]5cK\u001e\u0013x.\u001e9Xe>twmQ8pe\u0012Lg.\u0019;pe\"\"!q[Aw\u0011\u001d\u0011y\u000e\u0001C\u0001\u0003\u001b\fa\u0004^3ti\u0012+7o\u0019:jE\u0016<%o\\;q\u0013:\f7\r^5wK\u001e\u0013x.\u001e9)\t\tu\u0017Q\u001e\u0005\b\u0005K\u0004A\u0011AAg\u0003]!Xm\u001d;EKN\u001c'/\u001b2f\u000fJ|W\u000f]*uC\ndW\r\u000b\u0003\u0003d\u00065\bb\u0002Bv\u0001\u0011\u0005\u0011QZ\u0001\u001di\u0016\u001cH\u000fR3tGJL'-Z$s_V\u0004(+\u001a2bY\u0006t7-\u001b8hQ\u0011\u0011I/!<\t\u000f\tE\b\u0001\"\u0003\u0003t\u000612/\u001a;va*{\u0017N\\$s_V\u00048)\u00197mE\u0006\u001c7.\u0006\u0002\u0003vB1!\u0004\u000bB|\u0007\u0007\u0001RA!?\u0003\u0000~i!Aa?\u000b\u0007\tu8$\u0001\u0006d_:\u001cWO\u001d:f]RLAa!\u0001\u0003|\n1a)\u001e;ve\u0016\u00042a!\u0002\u0018\u001b\u0005\u0001\u0001bBB\u0005\u0001\u0011%11B\u0001\u0017g\u0016$X\u000f]*z]\u000e<%o\\;q\u0007\u0006dGNY1dWV\u00111Q\u0002\t\u00075!\u001ayaa\u0005\u0011\r\te(q`B\t!\r\u0019)!\n\t\u0004\u0007\u000b\u0019\u0004bBB\f\u0001\u0011%1\u0011D\u0001\u0017g\u0016$X\u000f\u001d%fCJ$(-Z1u\u0007\u0006dGNY1dWV\u001111\u0004\t\u00075!\u001aib!\t\u0011\r\te(q`B\u0010!\r\u0019)\u0001\u000f\t\u0004\u0007\u000bQ\u0004bBB\u0013\u0001\u0011%1qE\u0001\u001bg\u0016$X\u000f]\"p[6LGo\u00144gg\u0016$8oQ1mY\n\f7m[\u000b\u0003\u0007S\u0001bA\u0007\u0015\u0004,\r=\u0002C\u0002B}\u0005\u007f\u001ci\u0003E\u0002\u0004\u0006u\u00022a!\u0002O\u0011\u001d\u0019\u0019\u0004\u0001C\u0005\u0007k\tQb]3oI*{\u0017N\\$s_V\u0004H\u0003\u0004B|\u0007o\u0019)ea\u0012\u0004L\r5\u0003\u0002CA=\u0007c\u0001\ra!\u000f\u0011\t\rm2\u0011\t\b\u00045\ru\u0012bAB 7\u00051\u0001K]3eK\u001aL1aXB\"\u0015\r\u0019yd\u0007\u0005\t\u0003\u0013\u001b\t\u00041\u0001\u0004:!91\u0011JB\u0019\u0001\u0004I\u0017AD:fgNLwN\u001c+j[\u0016|W\u000f\u001e\u0005\t\u0003\u0003\u001b\t\u00041\u0001\u0004:!A\u00111TB\u0019\u0001\u0004\u0019y\u0005\u0005\u0004\u0004R\r\u00054Q\r\b\u0005\u0007'\u001aiF\u0004\u0003\u0004V\rmSBAB,\u0015\r\u0019IFB\u0001\u0007yI|w\u000e\u001e \n\u0003qI1aa\u0018\u001c\u0003\u001d\u0001\u0018mY6bO\u0016LA!!+\u0004d)\u00191qL\u000e\u0011\u000biA3\u0011\b\u0016\t\u000f\r%\u0004\u0001\"\u0003\u0004l\u0005\u00192/\u001a8e'ft7m\u0012:pkBdU-\u00193feRQ1qBB7\u0007_\u001a\u0019ha\u001e\t\u0011\u0005e4q\ra\u0001\u0007sAqa!\u001d\u0004h\u0001\u0007\u0011.\u0001\u0006hK:,'/\u0019;j_:D\u0001b!\u001e\u0004h\u0001\u00071\u0011H\u0001\tY\u0016\fG-\u001a:JI\"A1\u0011PB4\u0001\u0004\u0019Y(\u0001\u0006bgNLwM\\7f]R\u0004R\u0001Q\"\u0004:)Bqaa \u0001\t\u0013\u0019\t)A\u000btK:$7+\u001f8d\u000fJ|W\u000f\u001d$pY2|w/\u001a:\u0015\u0011\r=11QBC\u0007\u000fC\u0001\"!\u001f\u0004~\u0001\u00071\u0011\b\u0005\b\u0007c\u001ai\b1\u0001j\u0011!\tIi! A\u0002\re\u0002bBBF\u0001\u0011%1QR\u0001\nU>Lgn\u0012:pkB$2bHBH\u0007#\u001b\u0019j!&\u0004\u0018\"A\u0011\u0011PBE\u0001\u0004\u0019I\u0004\u0003\u0005\u0002\n\u000e%\u0005\u0019AB\u001d\u0011\u001d\u0019Ie!#A\u0002%D\u0001\"!!\u0004\n\u0002\u00071\u0011\b\u0005\t\u00037\u001bI\t1\u0001\u0004P!911\u0014\u0001\u0005\n\ru\u0015!E:z]\u000e<%o\\;q\r>dGn\\<feRA1\u0011CBP\u0007C\u001b)\u000b\u0003\u0005\u0002z\re\u0005\u0019AB\u001d\u0011\u001d\u0019\u0019k!'A\u0002%\fAbZ3oKJ\fG/[8o\u0013\u0012D\u0001\"!#\u0004\u001a\u0002\u00071\u0011\b\u0005\b\u0007S\u0003A\u0011BBV\u0003=\u0019\u0018P\\2He>,\b\u000fT3bI\u0016\u0014HCCB\t\u0007[\u001byk!-\u00044\"A\u0011\u0011PBT\u0001\u0004\u0019I\u0004C\u0004\u0004$\u000e\u001d\u0006\u0019A5\t\u0011\u0005%5q\u0015a\u0001\u0007sA\u0001b!\u001f\u0004(\u0002\u000711\u0010\u0005\b\u0007o\u0003A\u0011BB]\u0003%AW-\u0019:uE\u0016\fG\u000f\u0006\u0005\u0004 \rm6QXBa\u0011!\tIh!.A\u0002\re\u0002\u0002CB`\u0007k\u0003\ra!\u000f\u0002\u0015\r|gn];nKJLE\rC\u0004\u0004$\u000eU\u0006\u0019A5\t\u000f\r\u0015\u0007\u0001\"\u0003\u0004H\u0006)\u0011m^1jiV!1\u0011ZBh)\u0019\u0019Ym!9\u0004hB!1QZBh\u0019\u0001!\u0001b!5\u0004D\n\u000711\u001b\u0002\u0002)F!1Q[Bn!\rQ2q[\u0005\u0004\u00073\\\"a\u0002(pi\"Lgn\u001a\t\u00045\ru\u0017bABp7\t\u0019\u0011I\\=\t\u0011\r\r81\u0019a\u0001\u0007K\faAZ;ukJ,\u0007C\u0002B}\u0005\u007f\u001cY\r\u0003\u0005\u0004j\u000e\r\u0007\u0019ABv\u0003\u0019i\u0017\u000e\u001c7jgB\u0019!d!<\n\u0007\r=8D\u0001\u0003M_:<\u0007bBBz\u0001\u0011%1Q_\u0001\u000eG>lW.\u001b;PM\u001a\u001cX\r^:\u0015\u0015\r52q_B}\u0007w\u001ci\u0010\u0003\u0005\u0002z\rE\b\u0019AB\u001d\u0011!\u0019yl!=A\u0002\re\u0002bBBR\u0007c\u0004\r!\u001b\u0005\t\u0007\u007f\u001c\t\u00101\u0001\u0005\u0002\u00059qN\u001a4tKR\u001c\bcBAQ\t\u0007)EQA\u0005\u0004\t\u0006\r\u0006\u0003\u0002C\u0004\t\u0017i!\u0001\"\u0003\u000b\u0005!#\u0011\u0002\u0002C\u0007\t\u0013\u0011\u0011c\u00144gg\u0016$\u0018I\u001c3NKR\fG-\u0019;b\u0011\u001d!\t\u0002\u0001C\u0005\t'\t!\u0002\\3bm\u0016<%o\\;q)\u0019!)\u0002b\u0006\u0005\u001aA\u00191QA)\t\u0011\u0005eDq\u0002a\u0001\u0007sA\u0001ba0\u0005\u0010\u0001\u00071\u0011\b")
public class GroupCoordinatorResponseTest
extends JUnitSuite {
    private final String ClientId;
    private final String ClientHost;
    private final int ConsumerMinSessionTimeout;
    private final int ConsumerMaxSessionTimeout;
    private final int DefaultSessionTimeout;
    private MockTimer timer = null;
    private GroupCoordinator groupCoordinator = null;
    private ReplicaManager replicaManager = null;
    private KafkaScheduler scheduler = null;
    private ZkUtils zkUtils = null;
    private final String groupId;
    private final String protocolType;
    private final String memberId;
    private final byte[] metadata = (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte());
    private final List<Tuple2<String, byte[]>> protocols = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", (Object)this.metadata())}));
    private int kafka$coordinator$GroupCoordinatorResponseTest$$groupPartitionId = -1;
    private final String otherGroupId;

    public String ClientId() {
        return this.ClientId;
    }

    public String ClientHost() {
        return this.ClientHost;
    }

    public int ConsumerMinSessionTimeout() {
        return this.ConsumerMinSessionTimeout;
    }

    public int ConsumerMaxSessionTimeout() {
        return this.ConsumerMaxSessionTimeout;
    }

    public int DefaultSessionTimeout() {
        return this.DefaultSessionTimeout;
    }

    public MockTimer timer() {
        return this.timer;
    }

    public void timer_$eq(MockTimer x$1) {
        this.timer = x$1;
    }

    public GroupCoordinator groupCoordinator() {
        return this.groupCoordinator;
    }

    public void groupCoordinator_$eq(GroupCoordinator x$1) {
        this.groupCoordinator = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public KafkaScheduler scheduler() {
        return this.scheduler;
    }

    public void scheduler_$eq(KafkaScheduler x$1) {
        this.scheduler = x$1;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    private String groupId() {
        return this.groupId;
    }

    private String protocolType() {
        return this.protocolType;
    }

    private String memberId() {
        return this.memberId;
    }

    private byte[] metadata() {
        return this.metadata;
    }

    private List<Tuple2<String, byte[]>> protocols() {
        return this.protocols;
    }

    public int kafka$coordinator$GroupCoordinatorResponseTest$$groupPartitionId() {
        return this.kafka$coordinator$GroupCoordinatorResponseTest$$groupPartitionId;
    }

    private void kafka$coordinator$GroupCoordinatorResponseTest$$groupPartitionId_$eq(int x$1) {
        this.kafka$coordinator$GroupCoordinatorResponseTest$$groupPartitionId = x$1;
    }

    private String otherGroupId() {
        return this.otherGroupId;
    }

    @Before
    public void setUp() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        props.setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.ConsumerMinSessionTimeout())).toString());
        props.setProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.ConsumerMaxSessionTimeout())).toString());
        scala.collection.mutable.Map ret = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ret.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"__consumer_offsets"), (Object)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})))}))));
        this.replicaManager_$eq((ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class));
        this.zkUtils_$eq((ZkUtils)EasyMock.createNiceMock(ZkUtils.class));
        EasyMock.expect((Object)this.zkUtils().getPartitionAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"__consumer_offsets"})))).andReturn((Object)ret);
        EasyMock.replay((Object[])new Object[]{this.zkUtils()});
        this.timer_$eq(new MockTimer());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        String x$17 = "Heartbeat";
        MockTimer x$18 = this.timer();
        int x$19 = config.brokerId();
        boolean x$20 = false;
        int x$21 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        DelayedOperationPurgatory heartbeatPurgatory = new DelayedOperationPurgatory(x$17, (Timer)x$18, x$19, x$21, x$20);
        String x$22 = "Rebalance";
        MockTimer x$23 = this.timer();
        int x$24 = config.brokerId();
        boolean x$25 = false;
        int x$26 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        DelayedOperationPurgatory joinPurgatory = new DelayedOperationPurgatory(x$22, (Timer)x$23, x$24, x$26, x$25);
        this.groupCoordinator_$eq(GroupCoordinator$.MODULE$.apply(config, this.zkUtils(), this.replicaManager(), heartbeatPurgatory, joinPurgatory, MockTime$.MODULE$.toCommonTime(this.timer().time())));
        this.groupCoordinator().startup();
        this.kafka$coordinator$GroupCoordinatorResponseTest$$groupPartitionId_$eq(this.groupCoordinator().partitionFor(this.groupId()));
        this.groupCoordinator().groupManager().addPartitionOwnership(this.kafka$coordinator$GroupCoordinatorResponseTest$$groupPartitionId());
    }

    @After
    public void tearDown() {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        this.groupCoordinator().shutdown();
    }

    @Test
    public void testJoinGroupWrongCoordinator() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.otherGroupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NOT_COORDINATOR_FOR_GROUP.code(), (long)joinGroupErrorCode);
    }

    @Test
    public void testJoinGroupSessionTimeoutTooSmall() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.ConsumerMinSessionTimeout() - 1, this.protocolType(), this.protocols());
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.INVALID_SESSION_TIMEOUT.code(), (long)joinGroupErrorCode);
    }

    @Test
    public void testJoinGroupSessionTimeoutTooLarge() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.ConsumerMaxSessionTimeout() + 1, this.protocolType(), this.protocols());
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.INVALID_SESSION_TIMEOUT.code(), (long)joinGroupErrorCode);
    }

    @Test
    public void testJoinGroupUnknownConsumerNewGroup() {
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), this.memberId(), this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.UNKNOWN_MEMBER_ID.code(), (long)joinGroupErrorCode);
    }

    @Test
    public void testInvalidGroupId() {
        String groupId = "";
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(groupId, memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        Assert.assertEquals((long)Errors.INVALID_GROUP_ID.code(), (long)joinGroupResult.errorCode());
    }

    @Test
    public void testValidJoinGroup() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
    }

    @Test
    public void testJoinGroupInconsistentProtocolType() {
        String memberId = "";
        String otherMemberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        JoinGroupResult otherJoinGroupResult = this.joinGroup(this.groupId(), otherMemberId, this.DefaultSessionTimeout(), "connect", this.protocols());
        Assert.assertEquals((long)Errors.INCONSISTENT_GROUP_PROTOCOL.code(), (long)otherJoinGroupResult.errorCode());
    }

    @Test
    public void testJoinGroupInconsistentGroupProtocol() {
        String memberId = "";
        String otherMemberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), (List<Tuple2<String, byte[]>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", (Object)this.metadata())})));
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        JoinGroupResult otherJoinGroupResult = this.joinGroup(this.groupId(), otherMemberId, this.DefaultSessionTimeout(), this.protocolType(), (List<Tuple2<String, byte[]>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", (Object)this.metadata())})));
        Assert.assertEquals((long)Errors.INCONSISTENT_GROUP_PROTOCOL.code(), (long)otherJoinGroupResult.errorCode());
    }

    @Test
    public void testJoinGroupUnknownConsumerExistingGroup() {
        String memberId = "";
        String otherMemberId = "memberId";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        JoinGroupResult otherJoinGroupResult = this.joinGroup(this.groupId(), otherMemberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        Assert.assertEquals((long)Errors.UNKNOWN_MEMBER_ID.code(), (long)otherJoinGroupResult.errorCode());
    }

    @Test
    public void testHeartbeatWrongCoordinator() {
        short heartbeatResult = this.heartbeat(this.otherGroupId(), this.memberId(), -1);
        Assert.assertEquals((long)Errors.NOT_COORDINATOR_FOR_GROUP.code(), (long)heartbeatResult);
    }

    @Test
    public void testHeartbeatUnknownGroup() {
        short heartbeatResult = this.heartbeat(this.groupId(), this.memberId(), -1);
        Assert.assertEquals((long)Errors.UNKNOWN_MEMBER_ID.code(), (long)heartbeatResult);
    }

    @Test
    public void testHeartbeatUnknownConsumerExistingGroup() {
        String memberId = "";
        String otherMemberId = "memberId";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String assignedMemberId = joinGroupResult.memberId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupLeader(this.groupId(), joinGroupResult.generationId(), assignedMemberId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)assignedMemberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))));
        short syncGroupErrorCode = BoxesRunTime.unboxToShort((Object)syncGroupResult._2());
        Assert.assertEquals((long)Errors.NONE.code(), (long)syncGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        short heartbeatResult = this.heartbeat(this.groupId(), otherMemberId, 1);
        Assert.assertEquals((long)Errors.UNKNOWN_MEMBER_ID.code(), (long)heartbeatResult);
    }

    @Test
    public void testHeartbeatRebalanceInProgress() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String assignedMemberId = joinGroupResult.memberId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        short heartbeatResult = this.heartbeat(this.groupId(), assignedMemberId, 2);
        Assert.assertEquals((long)Errors.REBALANCE_IN_PROGRESS.code(), (long)heartbeatResult);
    }

    @Test
    public void testHeartbeatIllegalGeneration() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String assignedMemberId = joinGroupResult.memberId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupLeader(this.groupId(), joinGroupResult.generationId(), assignedMemberId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)assignedMemberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))));
        short syncGroupErrorCode = BoxesRunTime.unboxToShort((Object)syncGroupResult._2());
        Assert.assertEquals((long)Errors.NONE.code(), (long)syncGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        short heartbeatResult = this.heartbeat(this.groupId(), assignedMemberId, 2);
        Assert.assertEquals((long)Errors.ILLEGAL_GENERATION.code(), (long)heartbeatResult);
    }

    @Test
    public void testValidHeartbeat() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String assignedConsumerId = joinGroupResult.memberId();
        int generationId = joinGroupResult.generationId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupLeader(this.groupId(), generationId, assignedConsumerId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)assignedConsumerId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))));
        short syncGroupErrorCode = BoxesRunTime.unboxToShort((Object)syncGroupResult._2());
        Assert.assertEquals((long)Errors.NONE.code(), (long)syncGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        short heartbeatResult = this.heartbeat(this.groupId(), assignedConsumerId, 1);
        Assert.assertEquals((long)Errors.NONE.code(), (long)heartbeatResult);
    }

    @Test
    public void testSessionTimeout() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String assignedConsumerId = joinGroupResult.memberId();
        int generationId = joinGroupResult.generationId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> tuple2 = this.syncGroupLeader(this.groupId(), generationId, assignedConsumerId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)assignedConsumerId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))));
        if (tuple2 != null) {
            short syncGroupErrorCode;
            short s;
            short syncGroupErrorCode2 = s = (syncGroupErrorCode = BoxesRunTime.unboxToShort((Object)tuple2._2()));
            Assert.assertEquals((long)Errors.NONE.code(), (long)syncGroupErrorCode2);
            EasyMock.reset((Object[])new Object[]{this.replicaManager()});
            EasyMock.expect((Object)this.replicaManager().getPartition("__consumer_offsets", this.kafka$coordinator$GroupCoordinatorResponseTest$$groupPartitionId())).andReturn((Object)None$.MODULE$);
            EasyMock.expect((Object)this.replicaManager().getMessageFormatVersion((TopicAndPartition)EasyMock.anyObject())).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)Message$.MODULE$.MagicValue_V1()))).anyTimes();
            EasyMock.replay((Object[])new Object[]{this.replicaManager()});
            this.timer().advanceClock(this.DefaultSessionTimeout() + 100);
            EasyMock.reset((Object[])new Object[]{this.replicaManager()});
            short heartbeatResult = this.heartbeat(this.groupId(), assignedConsumerId, 1);
            Assert.assertEquals((long)Errors.UNKNOWN_MEMBER_ID.code(), (long)heartbeatResult);
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testHeartbeatMaintainsSession() {
        String memberId = "";
        int sessionTimeout = 1000;
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, sessionTimeout, this.protocolType(), this.protocols());
        String assignedConsumerId = joinGroupResult.memberId();
        int generationId = joinGroupResult.generationId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> tuple2 = this.syncGroupLeader(this.groupId(), generationId, assignedConsumerId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)assignedConsumerId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))));
        if (tuple2 != null) {
            short syncGroupErrorCode;
            short s;
            short syncGroupErrorCode2 = s = (syncGroupErrorCode = BoxesRunTime.unboxToShort((Object)tuple2._2()));
            Assert.assertEquals((long)Errors.NONE.code(), (long)syncGroupErrorCode2);
            this.timer().advanceClock(sessionTimeout / 2);
            EasyMock.reset((Object[])new Object[]{this.replicaManager()});
            short heartbeatResult = this.heartbeat(this.groupId(), assignedConsumerId, 1);
            Assert.assertEquals((long)Errors.NONE.code(), (long)heartbeatResult);
            this.timer().advanceClock(sessionTimeout / 2 + 100);
            EasyMock.reset((Object[])new Object[]{this.replicaManager()});
            heartbeatResult = this.heartbeat(this.groupId(), assignedConsumerId, 1);
            Assert.assertEquals((long)Errors.NONE.code(), (long)heartbeatResult);
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testCommitMaintainsSession() {
        int sessionTimeout = 1000;
        String memberId = "";
        TopicPartition tp = new TopicPartition("topic", 0);
        OffsetAndMetadata offset = OffsetAndMetadata$.MODULE$.apply(0L);
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, sessionTimeout, this.protocolType(), this.protocols());
        String assignedConsumerId = joinGroupResult.memberId();
        int generationId = joinGroupResult.generationId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> tuple2 = this.syncGroupLeader(this.groupId(), generationId, assignedConsumerId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)assignedConsumerId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))));
        if (tuple2 != null) {
            short syncGroupErrorCode;
            short s;
            short syncGroupErrorCode2 = s = (syncGroupErrorCode = BoxesRunTime.unboxToShort((Object)tuple2._2()));
            Assert.assertEquals((long)Errors.NONE.code(), (long)syncGroupErrorCode2);
            this.timer().advanceClock(sessionTimeout / 2);
            EasyMock.reset((Object[])new Object[]{this.replicaManager()});
            Map<TopicPartition, Object> commitOffsetResult = this.commitOffsets(this.groupId(), assignedConsumerId, generationId, (scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)((scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)offset)}))));
            Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)commitOffsetResult.apply((Object)tp)));
            this.timer().advanceClock(sessionTimeout / 2 + 100);
            EasyMock.reset((Object[])new Object[]{this.replicaManager()});
            short heartbeatResult = this.heartbeat(this.groupId(), assignedConsumerId, 1);
            Assert.assertEquals((long)Errors.NONE.code(), (long)heartbeatResult);
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testSyncGroupEmptyAssignment() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String assignedConsumerId = joinGroupResult.memberId();
        int generationId = joinGroupResult.generationId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupLeader(this.groupId(), generationId, assignedConsumerId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        short syncGroupErrorCode = BoxesRunTime.unboxToShort((Object)syncGroupResult._2());
        Assert.assertEquals((long)Errors.NONE.code(), (long)syncGroupErrorCode);
        Assert.assertTrue((boolean)Predef$.MODULE$.byteArrayOps((byte[])syncGroupResult._1()).isEmpty());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        short heartbeatResult = this.heartbeat(this.groupId(), assignedConsumerId, 1);
        Assert.assertEquals((long)Errors.NONE.code(), (long)heartbeatResult);
    }

    @Test
    public void testSyncGroupNotCoordinator() {
        int generation = 1;
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupFollower(this.otherGroupId(), generation, this.memberId());
        Assert.assertEquals((long)Errors.NOT_COORDINATOR_FOR_GROUP.code(), (long)BoxesRunTime.unboxToShort((Object)syncGroupResult._2()));
    }

    @Test
    public void testSyncGroupFromUnknownGroup() {
        int generation = 1;
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupFollower(this.groupId(), generation, this.memberId());
        Assert.assertEquals((long)Errors.UNKNOWN_MEMBER_ID.code(), (long)BoxesRunTime.unboxToShort((Object)syncGroupResult._2()));
    }

    @Test
    public void testSyncGroupFromUnknownMember() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String assignedConsumerId = joinGroupResult.memberId();
        int generationId = joinGroupResult.generationId();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupLeader(this.groupId(), generationId, assignedConsumerId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)assignedConsumerId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))));
        short syncGroupErrorCode = BoxesRunTime.unboxToShort((Object)syncGroupResult._2());
        Assert.assertEquals((long)Errors.NONE.code(), (long)syncGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        String unknownMemberId = "blah";
        Tuple2<byte[], Object> unknownMemberSyncResult = this.syncGroupFollower(this.groupId(), generationId, unknownMemberId);
        Assert.assertEquals((long)Errors.UNKNOWN_MEMBER_ID.code(), (long)BoxesRunTime.unboxToShort((Object)unknownMemberSyncResult._2()));
    }

    @Test
    public void testSyncGroupFromIllegalGeneration() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String assignedConsumerId = joinGroupResult.memberId();
        int generationId = joinGroupResult.generationId();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupLeader(this.groupId(), generationId + 1, assignedConsumerId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)assignedConsumerId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))));
        Assert.assertEquals((long)Errors.ILLEGAL_GENERATION.code(), (long)BoxesRunTime.unboxToShort((Object)syncGroupResult._2()));
    }

    @Test
    public void testJoinGroupFromUnchangedFollowerDoesNotRebalance() {
        JoinGroupResult firstJoinResult = this.joinGroup(this.groupId(), "", this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String firstMemberId = firstJoinResult.memberId();
        int firstGenerationId = firstJoinResult.generationId();
        Assert.assertEquals((Object)firstMemberId, (Object)firstJoinResult.leaderId());
        Assert.assertEquals((long)Errors.NONE.code(), (long)firstJoinResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> firstSyncResult = this.syncGroupLeader(this.groupId(), firstGenerationId, firstMemberId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)firstMemberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))));
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)firstSyncResult._2()));
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Future<JoinGroupResult> otherJoinFuture = this.sendJoinGroup(this.groupId(), "", this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Future<JoinGroupResult> joinFuture = this.sendJoinGroup(this.groupId(), firstMemberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        JoinGroupResult joinResult = this.await(joinFuture, this.DefaultSessionTimeout() + 100);
        JoinGroupResult otherJoinResult = this.await(otherJoinFuture, this.DefaultSessionTimeout() + 100);
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinResult.errorCode());
        Assert.assertEquals((long)Errors.NONE.code(), (long)otherJoinResult.errorCode());
        Assert.assertTrue((joinResult.generationId() == otherJoinResult.generationId() ? 1 : 0) != 0);
        Assert.assertEquals((Object)firstMemberId, (Object)joinResult.leaderId());
        Assert.assertEquals((Object)firstMemberId, (Object)otherJoinResult.leaderId());
        int nextGenerationId = joinResult.generationId();
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        JoinGroupResult followerJoinResult = this.joinGroup(this.groupId(), otherJoinResult.memberId(), this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        Assert.assertEquals((long)Errors.NONE.code(), (long)followerJoinResult.errorCode());
        Assert.assertEquals((long)nextGenerationId, (long)followerJoinResult.generationId());
    }

    @Test
    public void testJoinGroupFromUnchangedLeaderShouldRebalance() {
        JoinGroupResult firstJoinResult = this.joinGroup(this.groupId(), "", this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String firstMemberId = firstJoinResult.memberId();
        int firstGenerationId = firstJoinResult.generationId();
        Assert.assertEquals((Object)firstMemberId, (Object)firstJoinResult.leaderId());
        Assert.assertEquals((long)Errors.NONE.code(), (long)firstJoinResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> firstSyncResult = this.syncGroupLeader(this.groupId(), firstGenerationId, firstMemberId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)firstMemberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))));
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)firstSyncResult._2()));
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        JoinGroupResult secondJoinResult = this.joinGroup(this.groupId(), firstMemberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        Assert.assertEquals((long)Errors.NONE.code(), (long)secondJoinResult.errorCode());
        Assert.assertNotEquals((long)firstGenerationId, (long)secondJoinResult.generationId());
    }

    @Test
    public void testLeaderFailureInSyncGroup() {
        JoinGroupResult firstJoinResult = this.joinGroup(this.groupId(), "", this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String firstMemberId = firstJoinResult.memberId();
        int firstGenerationId = firstJoinResult.generationId();
        Assert.assertEquals((Object)firstMemberId, (Object)firstJoinResult.leaderId());
        Assert.assertEquals((long)Errors.NONE.code(), (long)firstJoinResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> firstSyncResult = this.syncGroupLeader(this.groupId(), firstGenerationId, firstMemberId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)firstMemberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))));
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)firstSyncResult._2()));
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Future<JoinGroupResult> otherJoinFuture = this.sendJoinGroup(this.groupId(), "", this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Future<JoinGroupResult> joinFuture = this.sendJoinGroup(this.groupId(), firstMemberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        JoinGroupResult joinResult = this.await(joinFuture, this.DefaultSessionTimeout() + 100);
        JoinGroupResult otherJoinResult = this.await(otherJoinFuture, this.DefaultSessionTimeout() + 100);
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinResult.errorCode());
        Assert.assertEquals((long)Errors.NONE.code(), (long)otherJoinResult.errorCode());
        Assert.assertTrue((joinResult.generationId() == otherJoinResult.generationId() ? 1 : 0) != 0);
        Assert.assertEquals((Object)firstMemberId, (Object)joinResult.leaderId());
        Assert.assertEquals((Object)firstMemberId, (Object)otherJoinResult.leaderId());
        int nextGenerationId = joinResult.generationId();
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Future<Tuple2<byte[], Object>> followerSyncFuture = this.sendSyncGroupFollower(this.groupId(), nextGenerationId, otherJoinResult.memberId());
        this.timer().advanceClock(this.DefaultSessionTimeout() + 100);
        Tuple2<byte[], Object> followerSyncResult = this.await(followerSyncFuture, this.DefaultSessionTimeout() + 100);
        Assert.assertEquals((long)Errors.REBALANCE_IN_PROGRESS.code(), (long)BoxesRunTime.unboxToShort((Object)followerSyncResult._2()));
    }

    @Test
    public void testSyncGroupFollowerAfterLeader() {
        JoinGroupResult firstJoinResult = this.joinGroup(this.groupId(), "", this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String firstMemberId = firstJoinResult.memberId();
        int firstGenerationId = firstJoinResult.generationId();
        Assert.assertEquals((Object)firstMemberId, (Object)firstJoinResult.leaderId());
        Assert.assertEquals((long)Errors.NONE.code(), (long)firstJoinResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> firstSyncResult = this.syncGroupLeader(this.groupId(), firstGenerationId, firstMemberId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)firstMemberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))));
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)firstSyncResult._2()));
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Future<JoinGroupResult> otherJoinFuture = this.sendJoinGroup(this.groupId(), "", this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Future<JoinGroupResult> joinFuture = this.sendJoinGroup(this.groupId(), firstMemberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        JoinGroupResult joinResult = this.await(joinFuture, this.DefaultSessionTimeout() + 100);
        JoinGroupResult otherJoinResult = this.await(otherJoinFuture, this.DefaultSessionTimeout() + 100);
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinResult.errorCode());
        Assert.assertEquals((long)Errors.NONE.code(), (long)otherJoinResult.errorCode());
        Assert.assertTrue((joinResult.generationId() == otherJoinResult.generationId() ? 1 : 0) != 0);
        Assert.assertEquals((Object)firstMemberId, (Object)joinResult.leaderId());
        Assert.assertEquals((Object)firstMemberId, (Object)otherJoinResult.leaderId());
        int nextGenerationId = joinResult.generationId();
        String leaderId = firstMemberId;
        byte[] leaderAssignment = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0}), ClassTag$.MODULE$.Byte());
        String followerId = otherJoinResult.memberId();
        byte[] followerAssignment = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{1}), ClassTag$.MODULE$.Byte());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> leaderSyncResult = this.syncGroupLeader(this.groupId(), nextGenerationId, leaderId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)leaderId), (Object)leaderAssignment), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)followerId), (Object)followerAssignment)}))));
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)leaderSyncResult._2()));
        Assert.assertEquals((Object)leaderAssignment, (Object)leaderSyncResult._1());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> followerSyncResult = this.syncGroupFollower(this.groupId(), nextGenerationId, otherJoinResult.memberId());
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)followerSyncResult._2()));
        Assert.assertEquals((Object)followerAssignment, (Object)followerSyncResult._1());
    }

    @Test
    public void testSyncGroupLeaderAfterFollower() {
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), "", this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String firstMemberId = joinGroupResult.memberId();
        int firstGenerationId = joinGroupResult.generationId();
        Assert.assertEquals((Object)firstMemberId, (Object)joinGroupResult.leaderId());
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupLeader(this.groupId(), firstGenerationId, firstMemberId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)firstMemberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))));
        short syncGroupErrorCode = BoxesRunTime.unboxToShort((Object)syncGroupResult._2());
        Assert.assertEquals((long)Errors.NONE.code(), (long)syncGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Future<JoinGroupResult> otherJoinFuture = this.sendJoinGroup(this.groupId(), "", this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Future<JoinGroupResult> joinFuture = this.sendJoinGroup(this.groupId(), firstMemberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        JoinGroupResult joinResult = this.await(joinFuture, this.DefaultSessionTimeout() + 100);
        JoinGroupResult otherJoinResult = this.await(otherJoinFuture, this.DefaultSessionTimeout() + 100);
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinResult.errorCode());
        Assert.assertEquals((long)Errors.NONE.code(), (long)otherJoinResult.errorCode());
        Assert.assertTrue((joinResult.generationId() == otherJoinResult.generationId() ? 1 : 0) != 0);
        int nextGenerationId = joinResult.generationId();
        String leaderId = joinResult.leaderId();
        byte[] leaderAssignment = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0}), ClassTag$.MODULE$.Byte());
        String followerId = otherJoinResult.memberId();
        byte[] followerAssignment = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{1}), ClassTag$.MODULE$.Byte());
        Assert.assertEquals((Object)firstMemberId, (Object)joinResult.leaderId());
        Assert.assertEquals((Object)firstMemberId, (Object)otherJoinResult.leaderId());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Future<Tuple2<byte[], Object>> followerSyncFuture = this.sendSyncGroupFollower(this.groupId(), nextGenerationId, followerId);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> leaderSyncResult = this.syncGroupLeader(this.groupId(), nextGenerationId, leaderId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)leaderId), (Object)leaderAssignment), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)followerId), (Object)followerAssignment)}))));
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)leaderSyncResult._2()));
        Assert.assertEquals((Object)leaderAssignment, (Object)leaderSyncResult._1());
        Tuple2<byte[], Object> followerSyncResult = this.await(followerSyncFuture, this.DefaultSessionTimeout() + 100);
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)followerSyncResult._2()));
        Assert.assertEquals((Object)followerAssignment, (Object)followerSyncResult._1());
    }

    @Test
    public void testCommitOffsetFromUnknownGroup() {
        int generationId = 1;
        TopicPartition tp = new TopicPartition("topic", 0);
        OffsetAndMetadata offset = OffsetAndMetadata$.MODULE$.apply(0L);
        Map<TopicPartition, Object> commitOffsetResult = this.commitOffsets(this.groupId(), this.memberId(), generationId, (scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)((scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)offset)}))));
        Assert.assertEquals((long)Errors.ILLEGAL_GENERATION.code(), (long)BoxesRunTime.unboxToShort((Object)commitOffsetResult.apply((Object)tp)));
    }

    @Test
    public void testCommitOffsetWithDefaultGeneration() {
        TopicPartition tp = new TopicPartition("topic", 0);
        OffsetAndMetadata offset = OffsetAndMetadata$.MODULE$.apply(0L);
        Map<TopicPartition, Object> commitOffsetResult = this.commitOffsets(this.groupId(), "", -1, (scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)((scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)offset)}))));
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)commitOffsetResult.apply((Object)tp)));
    }

    @Test
    public void testCommitOffsetInAwaitingSync() {
        String memberId = "";
        TopicPartition tp = new TopicPartition("topic", 0);
        OffsetAndMetadata offset = OffsetAndMetadata$.MODULE$.apply(0L);
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String assignedMemberId = joinGroupResult.memberId();
        int generationId = joinGroupResult.generationId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Map<TopicPartition, Object> commitOffsetResult = this.commitOffsets(this.groupId(), assignedMemberId, generationId, (scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)((scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)offset)}))));
        Assert.assertEquals((long)Errors.REBALANCE_IN_PROGRESS.code(), (long)BoxesRunTime.unboxToShort((Object)commitOffsetResult.apply((Object)tp)));
    }

    @Test
    public void testHeartbeatDuringRebalanceCausesRebalanceInProgress() {
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), "", this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String assignedConsumerId = joinGroupResult.memberId();
        int initialGenerationId = joinGroupResult.generationId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        this.sendJoinGroup(this.groupId(), "", this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        short heartbeatResult = this.heartbeat(this.groupId(), assignedConsumerId, initialGenerationId);
        Assert.assertEquals((long)Errors.REBALANCE_IN_PROGRESS.code(), (long)heartbeatResult);
    }

    @Test
    public void testGenerationIdIncrementsOnRebalance() {
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), "", this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        int initialGenerationId = joinGroupResult.generationId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        String memberId = joinGroupResult.memberId();
        Assert.assertEquals((long)1L, (long)initialGenerationId);
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupLeader(this.groupId(), initialGenerationId, memberId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)memberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))));
        short syncGroupErrorCode = BoxesRunTime.unboxToShort((Object)syncGroupResult._2());
        Assert.assertEquals((long)Errors.NONE.code(), (long)syncGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        JoinGroupResult otherJoinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        int nextGenerationId = otherJoinGroupResult.generationId();
        short otherJoinGroupErrorCode = otherJoinGroupResult.errorCode();
        Assert.assertEquals((long)2L, (long)nextGenerationId);
        Assert.assertEquals((long)Errors.NONE.code(), (long)otherJoinGroupErrorCode);
    }

    @Test
    public void testLeaveGroupWrongCoordinator() {
        String memberId = "";
        short leaveGroupResult = this.leaveGroup(this.otherGroupId(), memberId);
        Assert.assertEquals((long)Errors.NOT_COORDINATOR_FOR_GROUP.code(), (long)leaveGroupResult);
    }

    @Test
    public void testLeaveGroupUnknownGroup() {
        short leaveGroupResult = this.leaveGroup(this.groupId(), this.memberId());
        Assert.assertEquals((long)Errors.UNKNOWN_MEMBER_ID.code(), (long)leaveGroupResult);
    }

    @Test
    public void testLeaveGroupUnknownConsumerExistingGroup() {
        String memberId = "";
        String otherMemberId = "consumerId";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        short leaveGroupResult = this.leaveGroup(this.groupId(), otherMemberId);
        Assert.assertEquals((long)Errors.UNKNOWN_MEMBER_ID.code(), (long)leaveGroupResult);
    }

    @Test
    public void testValidLeaveGroup() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String assignedMemberId = joinGroupResult.memberId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        short leaveGroupResult = this.leaveGroup(this.groupId(), assignedMemberId);
        Assert.assertEquals((long)Errors.NONE.code(), (long)leaveGroupResult);
    }

    @Test
    public void testListGroupsIncludesStableGroups() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String assignedMemberId = joinGroupResult.memberId();
        int generationId = joinGroupResult.generationId();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupLeader(this.groupId(), generationId, assignedMemberId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)assignedMemberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))));
        short syncGroupErrorCode = BoxesRunTime.unboxToShort((Object)syncGroupResult._2());
        Assert.assertEquals((long)Errors.NONE.code(), (long)syncGroupErrorCode);
        Tuple2 tuple2 = this.groupCoordinator().handleListGroups();
        if (tuple2 != null) {
            Tuple2 tuple22;
            Errors error = (Errors)tuple2._1();
            List groups = (List)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)error, (Object)groups);
            Errors error2 = (Errors)tuple23._1();
            List groups2 = (List)tuple23._2();
            Assert.assertEquals((Object)Errors.NONE, (Object)error2);
            Assert.assertEquals((long)1L, (long)groups2.size());
            Assert.assertEquals((Object)new GroupOverview("groupId", "consumer"), (Object)groups2.apply(0));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testListGroupsIncludesRebalancingGroups() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupResult.errorCode());
        Tuple2 tuple2 = this.groupCoordinator().handleListGroups();
        if (tuple2 != null) {
            Tuple2 tuple22;
            Errors error = (Errors)tuple2._1();
            List groups = (List)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)error, (Object)groups);
            Errors error2 = (Errors)tuple23._1();
            List groups2 = (List)tuple23._2();
            Assert.assertEquals((Object)Errors.NONE, (Object)error2);
            Assert.assertEquals((long)1L, (long)groups2.size());
            Assert.assertEquals((Object)new GroupOverview("groupId", "consumer"), (Object)groups2.apply(0));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testDescribeGroupWrongCoordinator() {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2 tuple2 = this.groupCoordinator().handleDescribeGroup(this.otherGroupId());
        if (tuple2 != null) {
            Errors error;
            Errors errors;
            Errors error2 = errors = (error = (Errors)tuple2._1());
            Assert.assertEquals((Object)Errors.NOT_COORDINATOR_FOR_GROUP, (Object)error2);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testDescribeGroupInactiveGroup() {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2 tuple2 = this.groupCoordinator().handleDescribeGroup(this.groupId());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Errors error = (Errors)tuple2._1();
            GroupSummary summary = (GroupSummary)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)error, (Object)summary);
            Errors error2 = (Errors)tuple23._1();
            GroupSummary summary2 = (GroupSummary)tuple23._2();
            Assert.assertEquals((Object)Errors.NONE, (Object)error2);
            Assert.assertEquals((Object)GroupCoordinator$.MODULE$.DeadGroup(), (Object)summary2);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testDescribeGroupStable() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        String assignedMemberId = joinGroupResult.memberId();
        int generationId = joinGroupResult.generationId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupLeader(this.groupId(), generationId, assignedMemberId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)assignedMemberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))));
        short syncGroupErrorCode = BoxesRunTime.unboxToShort((Object)syncGroupResult._2());
        Assert.assertEquals((long)Errors.NONE.code(), (long)syncGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2 tuple2 = this.groupCoordinator().handleDescribeGroup(this.groupId());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Errors error = (Errors)tuple2._1();
            GroupSummary summary = (GroupSummary)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)error, (Object)summary);
            Errors error2 = (Errors)tuple23._1();
            GroupSummary summary2 = (GroupSummary)tuple23._2();
            Assert.assertEquals((Object)Errors.NONE, (Object)error2);
            Assert.assertEquals((Object)this.protocolType(), (Object)summary2.protocolType());
            Assert.assertEquals((Object)"range", (Object)summary2.protocol());
            Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{assignedMemberId})), (Object)summary2.members().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(MemberSummary x$5) {
                    return x$5.memberId();
                }
            }, List$.MODULE$.canBuildFrom()));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testDescribeGroupRebalancing() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.DefaultSessionTimeout(), this.protocolType(), this.protocols());
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2 tuple2 = this.groupCoordinator().handleDescribeGroup(this.groupId());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Errors error = (Errors)tuple2._1();
            GroupSummary summary = (GroupSummary)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)error, (Object)summary);
            Errors error2 = (Errors)tuple23._1();
            GroupSummary summary2 = (GroupSummary)tuple23._2();
            Assert.assertEquals((Object)Errors.NONE, (Object)error2);
            Assert.assertEquals((Object)this.protocolType(), (Object)summary2.protocolType());
            Assert.assertEquals((Object)GroupCoordinator$.MODULE$.NoProtocol(), (Object)summary2.protocol());
            Assert.assertEquals((Object)AwaitingSync$.MODULE$.toString(), (Object)summary2.state());
            Assert.assertTrue((boolean)((LinearSeqOptimized)summary2.members().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(MemberSummary x$7) {
                    return x$7.memberId();
                }
            }, List$.MODULE$.canBuildFrom())).contains((Object)joinGroupResult.memberId()));
            Assert.assertTrue((boolean)summary2.members().forall((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(MemberSummary x$8) {
                    return Predef$.MODULE$.byteArrayOps(x$8.metadata()).isEmpty();
                }
            }));
            Assert.assertTrue((boolean)summary2.members().forall((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(MemberSummary x$9) {
                    return Predef$.MODULE$.byteArrayOps(x$9.assignment()).isEmpty();
                }
            }));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private Tuple2<Future<JoinGroupResult>, Function1<JoinGroupResult, BoxedUnit>> setupJoinGroupCallback() {
        Promise responsePromise = Promise$.MODULE$.apply();
        Future responseFuture = responsePromise.future();
        Serializable responseCallback = new Serializable(this, responsePromise){
            public static final long serialVersionUID = 0L;
            private final Promise responsePromise$1;

            public final void apply(JoinGroupResult x$10) {
                this.responsePromise$1.success((Object)x$10);
            }
            {
                this.responsePromise$1 = responsePromise$1;
            }
        };
        return new Tuple2((Object)responseFuture, (Object)responseCallback);
    }

    private Tuple2<Future<Tuple2<byte[], Object>>, Function2<byte[], Object, BoxedUnit>> setupSyncGroupCallback() {
        Promise responsePromise = Promise$.MODULE$.apply();
        Future responseFuture = responsePromise.future();
        Serializable responseCallback = new Serializable(this, responsePromise){
            public static final long serialVersionUID = 0L;
            private final Promise responsePromise$2;

            public final void apply(byte[] assignment, short errorCode) {
                this.responsePromise$2.success((Object)new Tuple2((Object)assignment, (Object)BoxesRunTime.boxToShort((short)errorCode)));
            }
            {
                this.responsePromise$2 = responsePromise$2;
            }
        };
        return new Tuple2((Object)responseFuture, (Object)responseCallback);
    }

    private Tuple2<Future<Object>, Function1<Object, BoxedUnit>> setupHeartbeatCallback() {
        Promise responsePromise = Promise$.MODULE$.apply();
        Future responseFuture = responsePromise.future();
        Serializable responseCallback = new Serializable(this, responsePromise){
            public static final long serialVersionUID = 0L;
            private final Promise responsePromise$3;

            public final void apply(short errorCode) {
                this.responsePromise$3.success((Object)BoxesRunTime.boxToShort((short)errorCode));
            }
            {
                this.responsePromise$3 = responsePromise$3;
            }
        };
        return new Tuple2((Object)responseFuture, (Object)responseCallback);
    }

    private Tuple2<Future<Map<TopicPartition, Object>>, Function1<Map<TopicPartition, Object>, BoxedUnit>> setupCommitOffsetsCallback() {
        Promise responsePromise = Promise$.MODULE$.apply();
        Future responseFuture = responsePromise.future();
        Serializable responseCallback = new Serializable(this, responsePromise){
            public static final long serialVersionUID = 0L;
            private final Promise responsePromise$4;

            public final void apply(Map<TopicPartition, Object> offsets) {
                this.responsePromise$4.success(offsets);
            }
            {
                this.responsePromise$4 = responsePromise$4;
            }
        };
        return new Tuple2((Object)responseFuture, (Object)responseCallback);
    }

    private Future<JoinGroupResult> sendJoinGroup(String groupId, String memberId, int sessionTimeout, String protocolType, List<Tuple2<String, byte[]>> protocols) {
        Tuple2<Future<JoinGroupResult>, Function1<JoinGroupResult, BoxedUnit>> tuple2 = this.setupJoinGroupCallback();
        if (tuple2 != null) {
            Tuple2 tuple22;
            Future responseFuture = (Future)tuple2._1();
            Function1 responseCallback = (Function1)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)responseFuture, (Object)responseCallback);
            Future responseFuture2 = (Future)tuple23._1();
            Function1 responseCallback2 = (Function1)tuple23._2();
            EasyMock.replay((Object[])new Object[]{this.replicaManager()});
            this.groupCoordinator().handleJoinGroup(groupId, memberId, "clientId", "clientHost", sessionTimeout, protocolType, protocols, responseCallback2);
            return responseFuture2;
        }
        throw new MatchError(tuple2);
    }

    private Future<Tuple2<byte[], Object>> sendSyncGroupLeader(String groupId, int generation, String leaderId, Map<String, byte[]> assignment) {
        Tuple2<Future<Tuple2<byte[], Object>>, Function2<byte[], Object, BoxedUnit>> tuple2 = this.setupSyncGroupCallback();
        if (tuple2 != null) {
            Tuple2 tuple22;
            Future responseFuture = (Future)tuple2._1();
            Function2 responseCallback = (Function2)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)responseFuture, (Object)responseCallback);
            Future responseFuture2 = (Future)tuple23._1();
            Function2 responseCallback2 = (Function2)tuple23._2();
            Capture capturedArgument = EasyMock.newCapture();
            this.replicaManager().appendMessages(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.anyBoolean(), (Map)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)capturedArgument));
            EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, capturedArgument){
                private final /* synthetic */ GroupCoordinatorResponseTest $outer;
                private final Capture capturedArgument$1;

                public void answer() {
                    ((Function1)this.capturedArgument$1.getValue()).apply((Object)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("__consumer_offsets", this.$outer.kafka$coordinator$GroupCoordinatorResponseTest$$groupPartitionId())), (Object)new ProduceResponse.PartitionResponse(Errors.NONE.code(), 0L, -1L))})));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.capturedArgument$1 = capturedArgument$1;
                }
            });
            EasyMock.expect((Object)this.replicaManager().getMessageFormatVersion((TopicAndPartition)EasyMock.anyObject())).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)Message$.MODULE$.MagicValue_V1()))).anyTimes();
            EasyMock.replay((Object[])new Object[]{this.replicaManager()});
            this.groupCoordinator().handleSyncGroup(groupId, generation, leaderId, assignment, responseCallback2);
            return responseFuture2;
        }
        throw new MatchError(tuple2);
    }

    private Future<Tuple2<byte[], Object>> sendSyncGroupFollower(String groupId, int generation, String memberId) {
        Tuple2<Future<Tuple2<byte[], Object>>, Function2<byte[], Object, BoxedUnit>> tuple2 = this.setupSyncGroupCallback();
        if (tuple2 != null) {
            Tuple2 tuple22;
            Future responseFuture = (Future)tuple2._1();
            Function2 responseCallback = (Function2)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)responseFuture, (Object)responseCallback);
            Future responseFuture2 = (Future)tuple23._1();
            Function2 responseCallback2 = (Function2)tuple23._2();
            EasyMock.replay((Object[])new Object[]{this.replicaManager()});
            this.groupCoordinator().handleSyncGroup(groupId, generation, memberId, (Map)scala.collection.Map$.MODULE$.empty(), responseCallback2);
            return responseFuture2;
        }
        throw new MatchError(tuple2);
    }

    private JoinGroupResult joinGroup(String groupId, String memberId, int sessionTimeout, String protocolType, List<Tuple2<String, byte[]>> protocols) {
        Future<JoinGroupResult> responseFuture = this.sendJoinGroup(groupId, memberId, sessionTimeout, protocolType, protocols);
        this.timer().advanceClock(10L);
        return (JoinGroupResult)Await$.MODULE$.result(responseFuture, (Duration)Duration$.MODULE$.apply((long)(sessionTimeout + 100), TimeUnit.MILLISECONDS));
    }

    private Tuple2<byte[], Object> syncGroupFollower(String groupId, int generationId, String memberId) {
        Future<Tuple2<byte[], Object>> responseFuture = this.sendSyncGroupFollower(groupId, generationId, memberId);
        return (Tuple2)Await$.MODULE$.result(responseFuture, (Duration)Duration$.MODULE$.apply((long)(this.DefaultSessionTimeout() + 100), TimeUnit.MILLISECONDS));
    }

    private Tuple2<byte[], Object> syncGroupLeader(String groupId, int generationId, String memberId, Map<String, byte[]> assignment) {
        Future<Tuple2<byte[], Object>> responseFuture = this.sendSyncGroupLeader(groupId, generationId, memberId, assignment);
        return (Tuple2)Await$.MODULE$.result(responseFuture, (Duration)Duration$.MODULE$.apply((long)(this.DefaultSessionTimeout() + 100), TimeUnit.MILLISECONDS));
    }

    private short heartbeat(String groupId, String consumerId, int generationId) {
        Tuple2<Future<Object>, Function1<Object, BoxedUnit>> tuple2 = this.setupHeartbeatCallback();
        if (tuple2 != null) {
            Tuple2 tuple22;
            Future responseFuture = (Future)tuple2._1();
            Function1 responseCallback = (Function1)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)responseFuture, (Object)responseCallback);
            Future responseFuture2 = (Future)tuple23._1();
            Function1 responseCallback2 = (Function1)tuple23._2();
            EasyMock.replay((Object[])new Object[]{this.replicaManager()});
            this.groupCoordinator().handleHeartbeat(groupId, consumerId, generationId, responseCallback2);
            return BoxesRunTime.unboxToShort((Object)Await$.MODULE$.result((Awaitable)responseFuture2, (Duration)Duration$.MODULE$.apply(40L, TimeUnit.MILLISECONDS)));
        }
        throw new MatchError(tuple2);
    }

    private <T> T await(Future<T> future, long millis) {
        return (T)Await$.MODULE$.result(future, (Duration)Duration$.MODULE$.apply(millis, TimeUnit.MILLISECONDS));
    }

    private Map<TopicPartition, Object> commitOffsets(String groupId, String consumerId, int generationId, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets) {
        Tuple2<Future<Map<TopicPartition, Object>>, Function1<Map<TopicPartition, Object>, BoxedUnit>> tuple2 = this.setupCommitOffsetsCallback();
        if (tuple2 != null) {
            Tuple2 tuple22;
            Future responseFuture = (Future)tuple2._1();
            Function1 responseCallback = (Function1)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)responseFuture, (Object)responseCallback);
            Future responseFuture2 = (Future)tuple23._1();
            Function1 responseCallback2 = (Function1)tuple23._2();
            Capture capturedArgument = EasyMock.newCapture();
            this.replicaManager().appendMessages(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.anyBoolean(), (Map)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)capturedArgument));
            EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, capturedArgument){
                private final /* synthetic */ GroupCoordinatorResponseTest $outer;
                private final Capture capturedArgument$2;

                public void answer() {
                    ((Function1)this.capturedArgument$2.getValue()).apply((Object)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("__consumer_offsets", this.$outer.kafka$coordinator$GroupCoordinatorResponseTest$$groupPartitionId())), (Object)new ProduceResponse.PartitionResponse(Errors.NONE.code(), 0L, -1L))})));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.capturedArgument$2 = capturedArgument$2;
                }
            });
            EasyMock.expect((Object)this.replicaManager().getMessageFormatVersion((TopicAndPartition)EasyMock.anyObject())).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)Message$.MODULE$.MagicValue_V1()))).anyTimes();
            EasyMock.replay((Object[])new Object[]{this.replicaManager()});
            this.groupCoordinator().handleCommitOffsets(groupId, consumerId, generationId, offsets, responseCallback2);
            return (Map)Await$.MODULE$.result((Awaitable)responseFuture2, (Duration)Duration$.MODULE$.apply(40L, TimeUnit.MILLISECONDS));
        }
        throw new MatchError(tuple2);
    }

    private short leaveGroup(String groupId, String consumerId) {
        Tuple2<Future<Object>, Function1<Object, BoxedUnit>> tuple2 = this.setupHeartbeatCallback();
        if (tuple2 != null) {
            Tuple2 tuple22;
            Future responseFuture = (Future)tuple2._1();
            Function1 responseCallback = (Function1)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)responseFuture, (Object)responseCallback);
            Future responseFuture2 = (Future)tuple23._1();
            Function1 responseCallback2 = (Function1)tuple23._2();
            EasyMock.expect((Object)this.replicaManager().getPartition("__consumer_offsets", this.kafka$coordinator$GroupCoordinatorResponseTest$$groupPartitionId())).andReturn((Object)None$.MODULE$);
            EasyMock.expect((Object)this.replicaManager().getMessageFormatVersion((TopicAndPartition)EasyMock.anyObject())).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)Message$.MODULE$.MagicValue_V1()))).anyTimes();
            EasyMock.replay((Object[])new Object[]{this.replicaManager()});
            this.groupCoordinator().handleLeaveGroup(groupId, consumerId, responseCallback2);
            return BoxesRunTime.unboxToShort((Object)Await$.MODULE$.result((Awaitable)responseFuture2, (Duration)Duration$.MODULE$.apply(40L, TimeUnit.MILLISECONDS)));
        }
        throw new MatchError(tuple2);
    }

    public GroupCoordinatorResponseTest() {
        this.ClientId = "consumer-test";
        this.ClientHost = "localhost";
        this.ConsumerMinSessionTimeout = 10;
        this.ConsumerMaxSessionTimeout = 1000;
        this.DefaultSessionTimeout = 500;
        this.groupId = "groupId";
        this.protocolType = "consumer";
        this.memberId = "memberId";
        this.otherGroupId = "otherGroup";
    }
}

