/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.Collection;
import java.util.Properties;
import kafka.admin.AdminUtils$;
import kafka.api.FetchRequest;
import kafka.api.FetchRequestBuilder;
import kafka.api.FixedPortTestUtils$;
import kafka.consumer.SimpleConsumer;
import kafka.integration.KafkaServerTestHarness;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.server.ClientConfigOverride$;
import kafka.server.ClientQuotaManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.internals.ErrorLoggingCallback;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005=g\u0001B\u0001\u0003\u0001\u001d\u0011!\"U;pi\u0006\u001cH+Z:u\u0015\t\u0019A!A\u0002ba&T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0005\t\u0003\u0013Ai\u0011A\u0003\u0006\u0003\u00171\tQA[;oSRT!!\u0004\b\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\b\u0002\u0007=\u0014x-\u0003\u0002\u0012\u0015\tQ!*\u00168jiN+\u0018\u000e^3\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U!\u0011aC5oi\u0016<'/\u0019;j_:L!a\u0006\u000b\u0003--\u000bgm[1TKJ4XM\u001d+fgRD\u0015M\u001d8fgNDQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtD#A\u000e\u0011\u0005q\u0001Q\"\u0001\u0002\t\u000fy\u0001!\u0019!C\u0005?\u0005\u0011\u0002O]8ek\u000e,'OQ;gM\u0016\u00148+\u001b>f+\u0005\u0001\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#aA%oi\"1q\u0005\u0001Q\u0001\n\u0001\n1\u0003\u001d:pIV\u001cWM\u001d\"vM\u001a,'oU5{K\u0002Bq!\u000b\u0001C\u0002\u0013%!&A\u0006qe>$WoY3s\u0013\u0012\fT#A\u0016\u0011\u00051\nT\"A\u0017\u000b\u00059z\u0013\u0001\u00027b]\u001eT\u0011\u0001M\u0001\u0005U\u00064\u0018-\u0003\u00023[\t11\u000b\u001e:j]\u001eDa\u0001\u000e\u0001!\u0002\u0013Y\u0013\u0001\u00049s_\u0012,8-\u001a:JIF\u0002\u0003b\u0002\u001c\u0001\u0005\u0004%IAK\u0001\faJ|G-^2fe&#'\u0007\u0003\u00049\u0001\u0001\u0006IaK\u0001\raJ|G-^2fe&#'\u0007\t\u0005\bu\u0001\u0011\r\u0011\"\u0003+\u0003-\u0019wN\\:v[\u0016\u0014\u0018\nZ\u0019\t\rq\u0002\u0001\u0015!\u0003,\u00031\u0019wN\\:v[\u0016\u0014\u0018\nZ\u0019!\u0011\u001dq\u0004A1A\u0005\n)\n1bY8ogVlWM]%ee!1\u0001\t\u0001Q\u0001\n-\nAbY8ogVlWM]%ee\u0001BqA\u0011\u0001C\u0002\u0013\u0005q$\u0001\u0006ok6\u001cVM\u001d<feNDa\u0001\u0012\u0001!\u0002\u0013\u0001\u0013a\u00038v[N+'O^3sg\u0002BqA\u0012\u0001C\u0002\u0013\u0005q)A\bpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9t+\u0005A\u0005CA%M\u001b\u0005Q%BA&0\u0003\u0011)H/\u001b7\n\u00055S%A\u0003)s_B,'\u000f^5fg\"1q\n\u0001Q\u0001\n!\u000b\u0001c\u001c<feJLG-\u001b8h!J|\u0007o\u001d\u0011\t\u000bE\u0003A\u0011\t*\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON$\u0012a\u0015\t\u0004)r{fBA+[\u001d\t1\u0016,D\u0001X\u0015\tAf!\u0001\u0004=e>|GOP\u0005\u0002G%\u00111LI\u0001\ba\u0006\u001c7.Y4f\u0013\tifLA\u0002TKFT!a\u0017\u0012\u0011\u0005\u0001\u001cW\"A1\u000b\u0005\t$\u0011AB:feZ,'/\u0003\u0002eC\nY1*\u00194lC\u000e{gNZ5h\u0011\u001d1\u0007\u00011A\u0005\u0002\u001d\f\u0011\u0002\u001d:pIV\u001cWM]:\u0016\u0003!\u00042!\u001b8q\u001b\u0005Q'BA6m\u0003\u001diW\u000f^1cY\u0016T!!\u001c\u0012\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002pU\n1!)\u001e4gKJ\u0004B!]=|w6\t!O\u0003\u0002ti\u0006A\u0001O]8ek\u000e,'O\u0003\u0002vm\u000691\r\\5f]R\u001c(BA\u0003x\u0015\tAh\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003uJ\u0014QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\bcA\u0011}}&\u0011QP\t\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003C}L1!!\u0001#\u0005\u0011\u0011\u0015\u0010^3\t\u0013\u0005\u0015\u0001\u00011A\u0005\u0002\u0005\u001d\u0011!\u00049s_\u0012,8-\u001a:t?\u0012*\u0017\u000f\u0006\u0003\u0002\n\u0005=\u0001cA\u0011\u0002\f%\u0019\u0011Q\u0002\u0012\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003#\t\u0019!!AA\u0002!\f1\u0001\u001f\u00132\u0011\u001d\t)\u0002\u0001Q!\n!\f!\u0002\u001d:pIV\u001cWM]:!\u0011%\tI\u0002\u0001a\u0001\n\u0003\tY\"A\u0005d_:\u001cX/\\3sgV\u0011\u0011Q\u0004\t\u0005S:\fy\u0002\u0005\u0004\u0002\"\u0005\u001d2p_\u0007\u0003\u0003GQ1!!\nu\u0003!\u0019wN\\:v[\u0016\u0014\u0018\u0002BA\u0015\u0003G\u0011QbS1gW\u0006\u001cuN\\:v[\u0016\u0014\b\"CA\u0017\u0001\u0001\u0007I\u0011AA\u0018\u00035\u0019wN\\:v[\u0016\u00148o\u0018\u0013fcR!\u0011\u0011BA\u0019\u0011)\t\t\"a\u000b\u0002\u0002\u0003\u0007\u0011Q\u0004\u0005\t\u0003k\u0001\u0001\u0015)\u0003\u0002\u001e\u0005Q1m\u001c8tk6,'o\u001d\u0011\t\u0013\u0005e\u0002\u00011A\u0005\u0002\u0005m\u0012\u0001\u0005:fa2L7-Y\"p]N,X.\u001a:t+\t\ti\u0004\u0005\u0003j]\u0006}\u0002\u0003BA!\u0003\u000bj!!a\u0011\u000b\u0007\u0005\u0015B!\u0003\u0003\u0002H\u0005\r#AD*j[BdWmQ8ogVlWM\u001d\u0005\n\u0003\u0017\u0002\u0001\u0019!C\u0001\u0003\u001b\nAC]3qY&\u001c\u0017mQ8ogVlWM]:`I\u0015\fH\u0003BA\u0005\u0003\u001fB!\"!\u0005\u0002J\u0005\u0005\t\u0019AA\u001f\u0011!\t\u0019\u0006\u0001Q!\n\u0005u\u0012!\u0005:fa2L7-Y\"p]N,X.\u001a:tA!I\u0011q\u000b\u0001A\u0002\u0013\u0005\u0011\u0011L\u0001\u000bY\u0016\fG-\u001a:O_\u0012,WCAA.!\r\u0001\u0017QL\u0005\u0004\u0003?\n'aC&bM.\f7+\u001a:wKJD\u0011\"a\u0019\u0001\u0001\u0004%\t!!\u001a\u0002\u001d1,\u0017\rZ3s\u001d>$Wm\u0018\u0013fcR!\u0011\u0011BA4\u0011)\t\t\"!\u0019\u0002\u0002\u0003\u0007\u00111\f\u0005\t\u0003W\u0002\u0001\u0015)\u0003\u0002\\\u0005YA.Z1eKJtu\u000eZ3!\u0011%\ty\u0007\u0001a\u0001\n\u0003\tI&\u0001\u0007g_2dwn^3s\u001d>$W\rC\u0005\u0002t\u0001\u0001\r\u0011\"\u0001\u0002v\u0005\u0001bm\u001c7m_^,'OT8eK~#S-\u001d\u000b\u0005\u0003\u0013\t9\b\u0003\u0006\u0002\u0012\u0005E\u0014\u0011!a\u0001\u00037B\u0001\"a\u001f\u0001A\u0003&\u00111L\u0001\u000eM>dGn\\<fe:{G-\u001a\u0011\t\u0011\u0005}\u0004A1A\u0005\n)\na\u0001^8qS\u000e\f\u0004bBAB\u0001\u0001\u0006IaK\u0001\bi>\u0004\u0018nY\u0019!\u0011\u001d\t9\t\u0001C!\u0003\u0013\u000bQa]3u+B$\"!!\u0003)\t\u0005\u0015\u0015Q\u0012\t\u0005\u0003\u001f\u000b\u0019*\u0004\u0002\u0002\u0012*\u00111BD\u0005\u0005\u0003+\u000b\tJ\u0001\u0004CK\u001a|'/\u001a\u0005\b\u00033\u0003A\u0011IAE\u0003!!X-\u0019:E_^t\u0007\u0006BAL\u0003;\u0003B!a$\u0002 &!\u0011\u0011UAI\u0005\u0015\te\r^3s\u0011\u001d\t)\u000b\u0001C\u0001\u0003\u0013\u000bQ\u0004^3tiRC'o\u001c;uY\u0016$\u0007K]8ek\u000e,'oQ8ogVlWM\u001d\u0015\u0005\u0003G\u000bI\u000b\u0005\u0003\u0002\u0010\u0006-\u0016\u0002BAW\u0003#\u0013A\u0001V3ti\"9\u0011\u0011\u0017\u0001\u0005\u0002\u0005%\u0015a\n;fgR\u0004&o\u001c3vG\u0016\u00148i\u001c8tk6,'o\u0014<feJLG-Z+oi\"\u0014x\u000e\u001e;mK\u0012DC!a,\u0002*\"9\u0011q\u0017\u0001\u0005\u0002\u0005e\u0016a\u00029s_\u0012,8-\u001a\u000b\u0006A\u0005m\u0016q\u0018\u0005\b\u0003{\u000b)\f1\u0001q\u0003\u0005\u0001\bbBAa\u0003k\u0003\r\u0001I\u0001\u0006G>,h\u000e\u001e\u0005\b\u0003\u000b\u0004A\u0011AAd\u0003\u001d\u0019wN\\:v[\u0016$b!!\u0003\u0002J\u0006-\u0007\u0002CA\u0013\u0003\u0007\u0004\r!a\b\t\u000f\u00055\u00171\u0019a\u0001A\u0005Qa.^7SK\u000e|'\u000fZ:")
public class QuotasTest
extends JUnitSuite
implements KafkaServerTestHarness {
    private final int producerBufferSize;
    private final String producerId1;
    private final String kafka$api$QuotasTest$$producerId2;
    private final String consumerId1;
    private final String kafka$api$QuotasTest$$consumerId2;
    private final int numServers;
    private final Properties overridingProps;
    private Buffer<KafkaProducer<byte[], byte[]>> producers;
    private Buffer<KafkaConsumer<byte[], byte[]>> consumers;
    private Buffer<SimpleConsumer> replicaConsumers;
    private KafkaServer leaderNode;
    private KafkaServer followerNode;
    private final String kafka$api$QuotasTest$$topic1;
    private Seq<KafkaConfig> instanceConfigs;
    private Buffer<KafkaServer> servers;
    private String brokerList;
    private boolean[] alive;
    private final String kafkaPrincipalType;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    @Override
    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    @Override
    public Buffer<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    public void servers_$eq(Buffer<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public String brokerList() {
        return this.brokerList;
    }

    @Override
    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    @Override
    public boolean[] alive() {
        return this.alive;
    }

    @Override
    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    @Override
    public String kafkaPrincipalType() {
        return this.kafkaPrincipalType;
    }

    @Override
    public /* synthetic */ void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public /* synthetic */ void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$_setter_$kafkaPrincipalType_$eq(String x$1) {
        this.kafkaPrincipalType = x$1;
    }

    @Override
    public void setAclsBeforeServersStart() {
        KafkaServerTestHarness$class.setAclsBeforeServersStart(this);
    }

    @Override
    public Seq<KafkaConfig> configs() {
        return KafkaServerTestHarness$class.configs(this);
    }

    @Override
    public Option<KafkaServer> serverForId(int id) {
        return KafkaServerTestHarness$class.serverForId(this, id);
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return KafkaServerTestHarness$class.securityProtocol(this);
    }

    @Override
    public Option<File> trustStoreFile() {
        return KafkaServerTestHarness$class.trustStoreFile(this);
    }

    @Override
    public Option<Properties> saslProperties() {
        return KafkaServerTestHarness$class.saslProperties(this);
    }

    @Override
    public int killRandomBroker() {
        return KafkaServerTestHarness$class.killRandomBroker(this);
    }

    @Override
    public void restartDeadBrokers() {
        KafkaServerTestHarness$class.restartDeadBrokers(this);
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        QuotasTest quotasTest = this;
        synchronized (quotasTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    private int producerBufferSize() {
        return this.producerBufferSize;
    }

    private String producerId1() {
        return this.producerId1;
    }

    public String kafka$api$QuotasTest$$producerId2() {
        return this.kafka$api$QuotasTest$$producerId2;
    }

    private String consumerId1() {
        return this.consumerId1;
    }

    public String kafka$api$QuotasTest$$consumerId2() {
        return this.kafka$api$QuotasTest$$consumerId2;
    }

    public int numServers() {
        return this.numServers;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)FixedPortTestUtils$.MODULE$.createBrokerConfigs(this.numServers(), this.zkConnect(), false, FixedPortTestUtils$.MODULE$.createBrokerConfigs$default$4()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QuotasTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.overridingProps());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Buffer<KafkaProducer<byte[], byte[]>> producers() {
        return this.producers;
    }

    public void producers_$eq(Buffer<KafkaProducer<byte[], byte[]>> x$1) {
        this.producers = x$1;
    }

    public Buffer<KafkaConsumer<byte[], byte[]>> consumers() {
        return this.consumers;
    }

    public void consumers_$eq(Buffer<KafkaConsumer<byte[], byte[]>> x$1) {
        this.consumers = x$1;
    }

    public Buffer<SimpleConsumer> replicaConsumers() {
        return this.replicaConsumers;
    }

    public void replicaConsumers_$eq(Buffer<SimpleConsumer> x$1) {
        this.replicaConsumers = x$1;
    }

    public KafkaServer leaderNode() {
        return this.leaderNode;
    }

    public void leaderNode_$eq(KafkaServer x$1) {
        this.leaderNode = x$1;
    }

    public KafkaServer followerNode() {
        return this.followerNode;
    }

    public void followerNode_$eq(KafkaServer x$1) {
        this.followerNode = x$1;
    }

    public String kafka$api$QuotasTest$$topic1() {
        return this.kafka$api$QuotasTest$$topic1;
    }

    @Override
    @Before
    public void setUp() {
        KafkaServerTestHarness$class.setUp(this);
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.brokerList());
        producerProps.put("acks", "0");
        producerProps.put("buffer.memory", ((Object)BoxesRunTime.boxToInteger((int)this.producerBufferSize())).toString());
        producerProps.put("client.id", this.producerId1());
        producerProps.put("key.serializer", ByteArraySerializer.class);
        producerProps.put("value.serializer", ByteArraySerializer.class);
        this.producers().$plus$eq((Object)new KafkaProducer(producerProps));
        producerProps.put("client.id", this.kafka$api$QuotasTest$$producerId2());
        this.producers().$plus$eq((Object)new KafkaProducer(producerProps));
        int numPartitions = 1;
        scala.collection.immutable.Map<Object, Option<Object>> leaders = TestUtils$.MODULE$.createTopic(this.zkUtils(), this.kafka$api$QuotasTest$$topic1(), numPartitions, this.numServers(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.leaderNode_$eq(BoxesRunTime.unboxToInt((Object)((Option)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0))).get()) == ((KafkaServer)this.servers().head()).config().brokerId() ? (KafkaServer)this.servers().head() : (KafkaServer)this.servers().apply(1));
        this.followerNode_$eq(BoxesRunTime.unboxToInt((Object)((Option)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0))).get()) != ((KafkaServer)this.servers().head()).config().brokerId() ? (KafkaServer)this.servers().head() : (KafkaServer)this.servers().apply(1));
        Assert.assertTrue((String)"Leader of all partitions of the topic should exist", (boolean)leaders.values().forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Option<Object> leader) {
                return leader.isDefined();
            }
        }));
        Properties consumerProps = new Properties();
        consumerProps.setProperty("group.id", "QuotasTest");
        consumerProps.setProperty("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToInteger((int)4096)).toString());
        consumerProps.setProperty("auto.offset.reset", "earliest");
        consumerProps.put("bootstrap.servers", this.brokerList());
        consumerProps.put("key.deserializer", ByteArrayDeserializer.class);
        consumerProps.put("value.deserializer", ByteArrayDeserializer.class);
        consumerProps.put("client.id", this.consumerId1());
        this.consumers().$plus$eq((Object)new KafkaConsumer(consumerProps));
        KafkaServer qual$1 = this.leaderNode();
        SecurityProtocol x$5 = qual$1.boundPort$default$1();
        this.replicaConsumers().$plus$eq((Object)new SimpleConsumer("localhost", qual$1.boundPort(x$5), 1000000, 65536, this.consumerId1()));
        consumerProps.put("client.id", this.kafka$api$QuotasTest$$consumerId2());
        this.consumers().$plus$eq((Object)new KafkaConsumer(consumerProps));
        KafkaServer qual$2 = this.leaderNode();
        SecurityProtocol x$6 = qual$2.boundPort$default$1();
        this.replicaConsumers().$plus$eq((Object)new SimpleConsumer("localhost", qual$2.boundPort(x$6), 1000000, 65536, this.kafka$api$QuotasTest$$consumerId2()));
    }

    @Override
    @After
    public void tearDown() {
        this.producers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaProducer<byte[], byte[]> x$2) {
                x$2.close();
            }
        });
        this.consumers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaConsumer<byte[], byte[]> x$3) {
                x$3.close();
            }
        });
        this.replicaConsumers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(SimpleConsumer x$4) {
                x$4.close();
            }
        });
        KafkaServerTestHarness$class.tearDown(this);
    }

    @Test
    public void testThrottledProducerConsumer() {
        scala.collection.mutable.Map allMetrics = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.leaderNode().metrics().metrics()).asScala();
        int numRecords = 1000;
        this.produce((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), numRecords);
        MetricName producerMetricName = this.leaderNode().metrics().metricName("throttle-time", ApiKeys.PRODUCE.name, "Tracking throttle-time per client", new String[]{"client-id", this.producerId1()});
        Assert.assertTrue((String)"Should have been throttled", (((KafkaMetric)allMetrics.apply((Object)producerMetricName)).value() > 0.0 ? 1 : 0) != 0);
        this.consume((KafkaConsumer<byte[], byte[]>)((KafkaConsumer)this.consumers().head()), numRecords);
        FetchRequest request = new FetchRequestBuilder().addFetch(this.kafka$api$QuotasTest$$topic1(), 0, 0L, 0x100000).replicaId(this.followerNode().config().brokerId()).build();
        ((SimpleConsumer)this.replicaConsumers().head()).fetch(request);
        MetricName consumerMetricName = this.leaderNode().metrics().metricName("throttle-time", ApiKeys.FETCH.name, "Tracking throttle-time per client", new String[]{"client-id", this.consumerId1()});
        Assert.assertTrue((String)"Should have been throttled", (((KafkaMetric)allMetrics.apply((Object)consumerMetricName)).value() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testProducerConsumerOverrideUnthrottled() {
        Properties props = new Properties();
        props.put(ClientConfigOverride$.MODULE$.ProducerOverride(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        props.put(ClientConfigOverride$.MODULE$.ConsumerOverride(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        AdminUtils$.MODULE$.changeClientIdConfig(this.zkUtils(), this.kafka$api$QuotasTest$$producerId2(), props);
        AdminUtils$.MODULE$.changeClientIdConfig(this.zkUtils(), this.kafka$api$QuotasTest$$consumerId2(), props);
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QuotasTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map quotaManagers = this.$outer.leaderNode().apis().quotaManagers();
                Quota overrideProducerQuota = ((ClientQuotaManager)quotaManagers.get((Object)BoxesRunTime.boxToShort((short)ApiKeys.PRODUCE.id)).get()).quota(this.$outer.kafka$api$QuotasTest$$producerId2());
                Quota overrideConsumerQuota = ((ClientQuotaManager)quotaManagers.get((Object)BoxesRunTime.boxToShort((short)ApiKeys.FETCH.id)).get()).quota(this.$outer.kafka$api$QuotasTest$$consumerId2());
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ClientId ", " must have unlimited producer quota"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$api$QuotasTest$$producerId2()})), (Object)Quota.upperBound((double)9.223372036854776E18), (Object)overrideProducerQuota);
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ClientId ", " must have unlimited consumer quota"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$api$QuotasTest$$consumerId2()})), (Object)Quota.upperBound((double)9.223372036854776E18), (Object)overrideConsumerQuota);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        scala.collection.mutable.Map allMetrics = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.leaderNode().metrics().metrics()).asScala();
        int numRecords = 1000;
        this.produce((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().apply(1)), numRecords);
        MetricName producerMetricName = this.leaderNode().metrics().metricName("throttle-time", ApiKeys.PRODUCE.name, "Tracking throttle-time per client", new String[]{"client-id", this.kafka$api$QuotasTest$$producerId2()});
        Assert.assertEquals((String)"Should not have been throttled", (double)0.0, (double)((KafkaMetric)allMetrics.apply((Object)producerMetricName)).value(), (double)0.0);
        this.consume((KafkaConsumer<byte[], byte[]>)((KafkaConsumer)this.consumers().apply(1)), numRecords);
        FetchRequest request = new FetchRequestBuilder().addFetch(this.kafka$api$QuotasTest$$topic1(), 0, 0L, 0x100000).replicaId(this.followerNode().config().brokerId()).build();
        ((SimpleConsumer)this.replicaConsumers().apply(1)).fetch(request);
        MetricName consumerMetricName = this.leaderNode().metrics().metricName("throttle-time", ApiKeys.FETCH.name, "Tracking throttle-time per client", new String[]{"client-id", this.kafka$api$QuotasTest$$consumerId2()});
        Assert.assertEquals((String)"Should not have been throttled", (double)0.0, (double)((KafkaMetric)allMetrics.apply((Object)consumerMetricName)).value(), (double)0.0);
    }

    public int produce(KafkaProducer<byte[], byte[]> p, int count) {
        IntRef numBytesProduced = IntRef.create((int)0);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), count).foreach$mVc$sp((Function1)new Serializable(this, p, numBytesProduced){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QuotasTest $outer;
            private final KafkaProducer p$1;
            private final IntRef numBytesProduced$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                byte[] payload = ((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes();
                this.numBytesProduced$1.elem += payload.length;
                this.p$1.send(new ProducerRecord(this.$outer.kafka$api$QuotasTest$$topic1(), null, null, (Object)payload), (Callback)new ErrorLoggingCallback(this.$outer.kafka$api$QuotasTest$$topic1(), null, null, true)).get();
                Thread.sleep(1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.p$1 = p$1;
                this.numBytesProduced$1 = numBytesProduced$1;
            }
        });
        return numBytesProduced.elem;
    }

    public void consume(KafkaConsumer<byte[], byte[]> consumer, int numRecords) {
        consumer.subscribe((Collection)JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.kafka$api$QuotasTest$$topic1()}))));
        IntRef numConsumed = IntRef.create((int)0);
        while (numConsumed.elem < numRecords) {
            JavaConversions$.MODULE$.iterableAsScalaIterable((Iterable)consumer.poll(100L)).foreach((Function1)new Serializable(this, numConsumed){
                public static final long serialVersionUID = 0L;
                private final IntRef numConsumed$1;

                public final void apply(ConsumerRecord<byte[], byte[]> cr) {
                    ++this.numConsumed$1.elem;
                }
                {
                    this.numConsumed$1 = numConsumed$1;
                }
            });
        }
    }

    public QuotasTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
        this.producerBufferSize = 300000;
        this.producerId1 = "QuotasTestProducer-1";
        this.kafka$api$QuotasTest$$producerId2 = "QuotasTestProducer-2";
        this.consumerId1 = "QuotasTestConsumer-1";
        this.kafka$api$QuotasTest$$consumerId2 = "QuotasTestConsumer-2";
        this.numServers = 2;
        this.overridingProps = new Properties();
        this.overridingProps().put(KafkaConfig$.MODULE$.ProducerQuotaBytesPerSecondDefaultProp(), "8000");
        this.overridingProps().put(KafkaConfig$.MODULE$.ConsumerQuotaBytesPerSecondDefaultProp(), "2500");
        this.producers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.consumers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.replicaConsumers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.leaderNode = null;
        this.followerNode = null;
        this.kafka$api$QuotasTest$$topic1 = "topic-1";
    }
}

