/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.LeaderAndIsr;
import kafka.api.RequestOrResponse;
import kafka.common.LeaderElectionNotNeededException;
import kafka.common.NoReplicaOnlineException;
import kafka.common.StateChangeFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewPartition$;
import kafka.controller.NoOpLeaderSelector;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionLeaderSelector;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t\u001de\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003U1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tWM\u0003\u0002\u0004\t\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011\r\u0001!\u0011!Q\u0001\nU\u0001\"AF\f\u000e\u0003\tI!\u0001\u0007\u0002\u0003\u001f-\u000bgm[1D_:$(o\u001c7mKJDQA\u0007\u0001\u0005\u0002m\ta\u0001P5oSRtDC\u0001\u000f\u001e!\t1\u0002\u0001C\u0003\u00043\u0001\u0007Q\u0003C\u0004 \u0001\t\u0007I\u0011\u0002\u0011\u0002#\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH/F\u0001\"!\t1\"%\u0003\u0002$\u0005\t\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\t\r\u0015\u0002\u0001\u0015!\u0003\"\u0003I\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0011\t\u000f\u001d\u0002!\u0019!C\u0005Q\u0005a1m\u001c8ue>dG.\u001a:JIV\t\u0011\u0006\u0005\u0002\nU%\u00111F\u0003\u0002\u0004\u0013:$\bBB\u0017\u0001A\u0003%\u0011&A\u0007d_:$(o\u001c7mKJLE\r\t\u0005\b_\u0001\u0011\r\u0011\"\u00031\u0003!Q8n\u00117jK:$X#A\u0019\u0011\u0005IJT\"A\u001a\u000b\u0005Q*\u0014\u0001\u0003>lG2LWM\u001c;\u000b\u0005Y:\u0014AB%1\u0013R,7MC\u00019\u0003\ry'oZ\u0005\u0003uM\u0012\u0001BW6DY&,g\u000e\u001e\u0005\u0007y\u0001\u0001\u000b\u0011B\u0019\u0002\u0013i\\7\t\\5f]R\u0004\u0003b\u0002 \u0001\u0001\u0004%\taP\u0001\u000fa\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f+\u0005\u0001\u0005\u0003B!G\u0011:k\u0011A\u0011\u0006\u0003\u0007\u0012\u000bq!\\;uC\ndWM\u0003\u0002F\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u001d\u0013%aA'baB\u0011\u0011\nT\u0007\u0002\u0015*\u00111\nB\u0001\u0007G>lWn\u001c8\n\u00055S%!\u0005+pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]B\u0011acT\u0005\u0003!\n\u0011a\u0002U1si&$\u0018n\u001c8Ti\u0006$X\rC\u0004S\u0001\u0001\u0007I\u0011A*\u0002%A\f'\u000f^5uS>t7\u000b^1uK~#S-\u001d\u000b\u0003)^\u0003\"!C+\n\u0005YS!\u0001B+oSRDq\u0001W)\u0002\u0002\u0003\u0007\u0001)A\u0002yIEBaA\u0017\u0001!B\u0013\u0001\u0015a\u00049beRLG/[8o'R\fG/\u001a\u0011\t\u000fq\u0003!\u0019!C\u0001;\u0006\u0011\"M]8lKJ\u0014V-];fgR\u0014\u0015\r^2i+\u0005q\u0006C\u0001\f`\u0013\t\u0001'A\u0001\u000fD_:$(o\u001c7mKJ\u0014%o\\6feJ+\u0017/^3ti\n\u000bGo\u00195\t\r\t\u0004\u0001\u0015!\u0003_\u0003M\u0011'o\\6feJ+\u0017/^3ti\n\u000bGo\u00195!\u0011\u001d!\u0007A1A\u0005\n\u0015\f!\u0002[1t'R\f'\u000f^3e+\u00051\u0007CA4q\u001b\u0005A'BA5k\u0003\u0019\tGo\\7jG*\u00111\u000e\\\u0001\u000bG>t7-\u001e:sK:$(BA7o\u0003\u0011)H/\u001b7\u000b\u0003=\fAA[1wC&\u0011\u0011\u000f\u001b\u0002\u000e\u0003R|W.[2C_>dW-\u00198\t\rM\u0004\u0001\u0015!\u0003g\u0003-A\u0017m]*uCJ$X\r\u001a\u0011\t\u000fU\u0004!\u0019!C\u0005m\u0006Ybn\\(q!\u0006\u0014H/\u001b;j_:dU-\u00193feN+G.Z2u_J,\u0012a\u001e\t\u0003-aL!!\u001f\u0002\u0003%9{w\n\u001d'fC\u0012,'oU3mK\u000e$xN\u001d\u0005\u0007w\u0002\u0001\u000b\u0011B<\u000299|w\n\u001d)beRLG/[8o\u0019\u0016\fG-\u001a:TK2,7\r^8sA!9Q\u0010\u0001b\u0001\n\u0013q\u0018!E:uCR,7\t[1oO\u0016dunZ4feV\tq\u0010\u0005\u0003\u0002\u0002\u0005-QBAA\u0002\u0015\u0011\t)!a\u0002\u0002\u000b1|w\r\u000e6\u000b\u0007\u0005%q'\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003\u001b\t\u0019A\u0001\u0004M_\u001e<WM\u001d\u0005\b\u0003#\u0001\u0001\u0015!\u0003\u0000\u0003I\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM\u001d\u0011\t\u000f\u0005U\u0001\u0001\"\u0001\u0002\u0018\u000591\u000f^1siV\u0004H#\u0001+\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u0018\u0005\t\"/Z4jgR,'\u000fT5ti\u0016tWM]:\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\u0018\u0005A1\u000f[;uI><h\u000eC\u0004\u0002$\u0001!\t!a\u0006\u0002CQ\u0014\u0018nZ4fe>sG.\u001b8f!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0007\"\fgnZ3\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002*\u0005\u0011\u0002.\u00198eY\u0016\u001cF/\u0019;f\u0007\"\fgnZ3t)\u001d!\u00161FA\u001c\u0003wA\u0001\"!\f\u0002&\u0001\u0007\u0011qF\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\b#BA\u0019\u0003gAU\"\u0001#\n\u0007\u0005UBIA\u0002TKRDq!!\u000f\u0002&\u0001\u0007a*A\u0006uCJ<W\r^*uCR,\u0007BCA\u001f\u0003K\u0001\n\u00111\u0001\u0002@\u0005qA.Z1eKJ\u001cV\r\\3di>\u0014\bc\u0001\f\u0002B%\u0019\u00111\t\u0002\u0003/A\u000b'\u000f^5uS>tG*Z1eKJ\u001cV\r\\3di>\u0014\bbBA$\u0001\u0011%\u0011\u0011J\u0001\u0012Q\u0006tG\r\\3Ti\u0006$Xm\u00115b]\u001e,G#\u0003+\u0002L\u0005u\u0013\u0011MA2\u0011!\ti%!\u0012A\u0002\u0005=\u0013!\u0002;pa&\u001c\u0007\u0003BA)\u0003/r1!CA*\u0013\r\t)FC\u0001\u0007!J,G-\u001a4\n\t\u0005e\u00131\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005U#\u0002C\u0004\u0002`\u0005\u0015\u0003\u0019A\u0015\u0002\u0013A\f'\u000f^5uS>t\u0007bBA\u001d\u0003\u000b\u0002\rA\u0014\u0005\t\u0003{\t)\u00051\u0001\u0002@!9\u0011q\r\u0001\u0005\n\u0005]\u0011\u0001G5oSRL\u0017\r\\5{KB\u000b'\u000f^5uS>t7\u000b^1uK\"9\u00111\u000e\u0001\u0005\n\u00055\u0014!G1tg\u0016\u0014HOV1mS\u0012\u0004&/\u001a<j_V\u001c8\u000b^1uKN$r\u0001VA8\u0003g\ni\bC\u0004\u0002r\u0005%\u0004\u0019\u0001%\u0002#Q|\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0005\u0002v\u0005%\u0004\u0019AA<\u0003)1'o\\7Ti\u0006$Xm\u001d\t\u0006\u0003c\tIHT\u0005\u0004\u0003w\"%aA*fc\"9\u0011\u0011HA5\u0001\u0004q\u0005bBAA\u0001\u0011%\u00111Q\u0001\u001bCN\u001c\u0018n\u001a8SKBd\u0017nY1t)>\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0006)\u0006\u0015\u0015q\u0011\u0005\t\u0003\u001b\ny\b1\u0001\u0002P!9\u0011qLA@\u0001\u0004I\u0003bBAF\u0001\u0011%\u0011QR\u0001#S:LG/[1mSj,G*Z1eKJ\fe\u000eZ%te\u001a{'\u000fU1si&$\u0018n\u001c8\u0015\u0007Q\u000by\tC\u0004\u0002r\u0005%\u0005\u0019\u0001%\t\u000f\u0005M\u0005\u0001\"\u0001\u0002\u0016\u00069R\r\\3di2+\u0017\rZ3s\r>\u0014\b+\u0019:uSRLwN\u001c\u000b\b)\u0006]\u0015\u0011TAN\u0011!\ti%!%A\u0002\u0005=\u0003bBA0\u0003#\u0003\r!\u000b\u0005\t\u0003{\t\t\n1\u0001\u0002@!9\u0011q\u0014\u0001\u0005\n\u0005\u0005\u0016a\u0007:fO&\u001cH/\u001a:U_BL7m\u00115b]\u001e,G*[:uK:,'\u000f\u0006\u0002\u0002$B1\u0011QUAT\u0003Wk\u0011\u0001\\\u0005\u0004\u0003Sc'\u0001\u0002'jgR\u0004B!!,\u000246\u0011\u0011q\u0016\u0006\u0004\u0003cs\u0017\u0001\u00027b]\u001eLA!!\u0017\u00020\"9\u0011q\u0017\u0001\u0005\u0002\u0005e\u0016a\b:fO&\u001cH/\u001a:QCJ$\u0018\u000e^5p]\u000eC\u0017M\\4f\u0019&\u001cH/\u001a8feR\u0019A+a/\t\u0011\u00055\u0013Q\u0017a\u0001\u0003\u001fBq!a0\u0001\t\u0013\t\t-\u0001\u0013hKRdU-\u00193fe&\u001b(/\u00118e\u000bB|7\r[(s)\"\u0014xn^#yG\u0016\u0004H/[8o)\u0019\t\u0019-!3\u0002LB\u0019a#!2\n\u0007\u0005\u001d'AA\u000eMK\u0006$WM]%te\u0006sGmQ8oiJ|G\u000e\\3s\u000bB|7\r\u001b\u0005\t\u0003\u001b\ni\f1\u0001\u0002P!9\u0011qLA_\u0001\u0004IcABAh\u0001\u0001\t\tNA\nU_BL7m\u00115b]\u001e,G*[:uK:,'oE\u0004\u0002N\u0006M\u0017\u0011\u001c\b\u0011\t\u00055\u0016Q[\u0005\u0005\u0003/\fyK\u0001\u0004PE*,7\r\u001e\t\u0004e\u0005m\u0017bAAog\t\u0001\u0012JW6DQ&dG\rT5ti\u0016tWM\u001d\u0005\b5\u00055G\u0011AAq)\t\t\u0019\u000f\u0005\u0003\u0002f\u00065W\"\u0001\u0001\t\u0011\u0005%\u0018Q\u001aC\u0001\u0003W\f\u0011\u0003[1oI2,7\t[5mI\u000eC\u0017M\\4f)\u0015!\u0016Q^Ay\u0011!\ty/a:A\u0002\u0005=\u0013A\u00039be\u0016tG\u000fU1uQ\"A\u00111_At\u0001\u0004\t)0\u0001\u0005dQ&dGM]3o!\u0019\t)+a*\u0002P!2\u0011q]A}\u0005;\u0001R!CA~\u0003\u007fL1!!@\u000b\u0005\u0019!\bN]8xgB!!\u0011\u0001B\u0002\u0019\u0001!qA!\u0002\u0001\u0005\u0004\u00119AA\u0001U#\u0011\u0011IAa\u0004\u0011\u0007%\u0011Y!C\u0002\u0003\u000e)\u0011qAT8uQ&tw\r\u0005\u0003\u0003\u0012\t]abA\u0005\u0003\u0014%\u0019!Q\u0003\u0006\u0002\u000fA\f7m[1hK&!!\u0011\u0004B\u000e\u0005%!\u0006N]8xC\ndWMC\u0002\u0003\u0016)\u0019#Aa\b\u0011\t\t\u0005\"Q\u0006\b\u0005\u0005G\u0011\u0019B\u0004\u0003\u0003&\t-RB\u0001B\u0014\u0015\r\u0011ICB\u0001\u0007yI|w\u000e\u001e \n\u0003-IAAa\f\u0003\u001c\tIQ\t_2faRLwN\u001c\u0004\u0007\u0005g\u0001\u0001A!\u000e\u0003+\u0005#G\rU1si&$\u0018n\u001c8t\u0019&\u001cH/\u001a8feN9!\u0011GAj\u0005oq\u0001c\u0001\u001a\u0003:%\u0019!1H\u001a\u0003\u001f%S6\u000eR1uC2K7\u000f^3oKJD1\"!\u0014\u00032\t\u0005\t\u0015!\u0003\u0002P!9!D!\r\u0005\u0002\t\u0005C\u0003\u0002B\"\u0005\u000b\u0002B!!:\u00032!A\u0011Q\nB \u0001\u0004\ty\u0005\u0003\u0005\u0003J\tEB\u0011\u0001B&\u0003AA\u0017M\u001c3mK\u0012\u000bG/Y\"iC:<W\rF\u0003U\u0005\u001b\u0012\t\u0006\u0003\u0005\u0003P\t\u001d\u0003\u0019AA(\u0003!!\u0017\r^1QCRD\u0007\u0002\u0003B*\u0005\u000f\u0002\r!a5\u0002\t\u0011\fG/\u0019\u0015\u0007\u0005\u000f\u00129F!\b\u0011\u000b%\tYP!\u0017\u0011\t\t\u0005!1\f\u0003\b\u0005\u000b\u0001!\u0019\u0001B\u0004\u0011!\u0011yF!\r\u0005\u0002\t\u0005\u0014!\u00055b]\u0012dW\rR1uC\u0012+G.\u001a;fIR\u0019AKa\u0019\t\u0011\u0005=(Q\fa\u0001\u0003\u001fBcA!\u0018\u0003h\tu\u0001#B\u0005\u0002|\n%\u0004\u0003\u0002B\u0001\u0005W\"qA!\u0002\u0001\u0005\u0004\u00119\u0001C\u0005\u0003p\u0001\t\n\u0011\"\u0001\u0003r\u0005a\u0002.\u00198eY\u0016\u001cF/\u0019;f\u0007\"\fgnZ3tI\u0011,g-Y;mi\u0012\u001aTC\u0001B:U\u0011\tyD!\u001e,\u0005\t]\u0004\u0003\u0002B=\u0005\u0007k!Aa\u001f\u000b\t\tu$qP\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!!\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u000b\u0013YHA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class PartitionStateMachine
implements Logging {
    public final KafkaController kafka$controller$PartitionStateMachine$$controller;
    private final ControllerContext kafka$controller$PartitionStateMachine$$controllerContext;
    private final int controllerId;
    private final ZkClient kafka$controller$PartitionStateMachine$$zkClient;
    private Map<TopicAndPartition, PartitionState> partitionState;
    private final ControllerBrokerRequestBatch brokerRequestBatch;
    private final AtomicBoolean kafka$controller$PartitionStateMachine$$hasStarted;
    private final NoOpLeaderSelector noOpPartitionLeaderSelector;
    private final Logger stateChangeLogger;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        PartitionStateMachine partitionStateMachine = this;
        synchronized (partitionStateMachine) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public ControllerContext kafka$controller$PartitionStateMachine$$controllerContext() {
        return this.kafka$controller$PartitionStateMachine$$controllerContext;
    }

    private int controllerId() {
        return this.controllerId;
    }

    public ZkClient kafka$controller$PartitionStateMachine$$zkClient() {
        return this.kafka$controller$PartitionStateMachine$$zkClient;
    }

    public Map<TopicAndPartition, PartitionState> partitionState() {
        return this.partitionState;
    }

    public void partitionState_$eq(Map<TopicAndPartition, PartitionState> map) {
        this.partitionState = map;
    }

    public ControllerBrokerRequestBatch brokerRequestBatch() {
        return this.brokerRequestBatch;
    }

    public AtomicBoolean kafka$controller$PartitionStateMachine$$hasStarted() {
        return this.kafka$controller$PartitionStateMachine$$hasStarted;
    }

    private NoOpLeaderSelector noOpPartitionLeaderSelector() {
        return this.noOpPartitionLeaderSelector;
    }

    private Logger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    public void startup() {
        this.initializePartitionState();
        this.kafka$controller$PartitionStateMachine$$hasStarted().set(true);
        this.triggerOnlinePartitionStateChange();
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Started partition state machine with initial state -> ").append((Object)this.$outer.partitionState().toString()).toString();
            }
            {
                if (partitionStateMachine == null) {
                    throw new NullPointerException();
                }
                this.$outer = partitionStateMachine;
            }
        });
    }

    public void registerListeners() {
        this.registerTopicChangeListener();
    }

    public void shutdown() {
        this.kafka$controller$PartitionStateMachine$$hasStarted().set(false);
        this.partitionState().clear();
    }

    public void triggerOnlinePartitionStateChange() {
        try {
            this.brokerRequestBatch().newBatch();
            this.partitionState().withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<TopicAndPartition, PartitionState> tuple2) {
                    Tuple2<TopicAndPartition, PartitionState> tuple22 = tuple2;
                    boolean bl = tuple22 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PartitionStateMachine $outer;

                public final void apply(Tuple2<TopicAndPartition, PartitionState> tuple2) {
                    Tuple2<TopicAndPartition, PartitionState> tuple22 = tuple2;
                    if (tuple22 != null) {
                        BoxedUnit boxedUnit;
                        TopicAndPartition topicAndPartition = (TopicAndPartition)tuple22._1();
                        PartitionState partitionState = (PartitionState)tuple22._2();
                        if (partitionState.equals(OfflinePartition$.MODULE$) || partitionState.equals(NewPartition$.MODULE$)) {
                            this.$outer.kafka$controller$PartitionStateMachine$$handleStateChange(topicAndPartition.topic(), topicAndPartition.partition(), OnlinePartition$.MODULE$, this.$outer.kafka$controller$PartitionStateMachine$$controller.offlinePartitionSelector());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        return;
                    }
                    throw new MatchError(tuple22);
                }
                {
                    if (partitionStateMachine == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = partitionStateMachine;
                }
            });
            this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$PartitionStateMachine$$controller.epoch(), this.kafka$controller$PartitionStateMachine$$controllerContext().correlationId().getAndIncrement());
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error while moving some partitions to the online state";
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$1;

                public final Throwable apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = throwable;
                }
            });
        }
    }

    public void handleStateChanges(Set<TopicAndPartition> set, PartitionState partitionState, PartitionLeaderSelector partitionLeaderSelector) {
        this.info((Function0<String>)new Serializable(this, set, partitionState){
            public static final long serialVersionUID = 0L;
            private final Set partitions$1;
            private final PartitionState targetState$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Invoking state change to %s for partitions %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1, this.partitions$1.mkString(",")}));
            }
            {
                this.partitions$1 = set;
                this.targetState$1 = partitionState;
            }
        });
        try {
            this.brokerRequestBatch().newBatch();
            set.foreach((Function1)new Serializable(this, partitionState, partitionLeaderSelector){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PartitionStateMachine $outer;
                private final PartitionState targetState$1;
                private final PartitionLeaderSelector leaderSelector$1;

                public final void apply(TopicAndPartition topicAndPartition) {
                    this.$outer.kafka$controller$PartitionStateMachine$$handleStateChange(topicAndPartition.topic(), topicAndPartition.partition(), this.targetState$1, this.leaderSelector$1);
                }
                {
                    if (partitionStateMachine == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = partitionStateMachine;
                    this.targetState$1 = partitionState;
                    this.leaderSelector$1 = partitionLeaderSelector;
                }
            });
            this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$PartitionStateMachine$$controller.epoch(), this.kafka$controller$PartitionStateMachine$$controllerContext().correlationId().getAndIncrement());
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(this, partitionState){
                public static final long serialVersionUID = 0L;
                private final PartitionState targetState$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Error while moving some partitions to %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1}));
                }
                {
                    this.targetState$1 = partitionState;
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$2;

                public final Throwable apply() {
                    return this.e$2;
                }
                {
                    this.e$2 = throwable;
                }
            });
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void kafka$controller$PartitionStateMachine$$handleStateChange(String string, int n, PartitionState partitionState, PartitionLeaderSelector partitionLeaderSelector) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(string, n);
        if (!this.kafka$controller$PartitionStateMachine$$hasStarted().get()) throw new StateChangeFailedException(new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change for partition %s to %s failed because the partition state machine has not started")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition, partitionState})));
        PartitionState partitionState2 = (PartitionState)this.partitionState().getOrElseUpdate((Object)topicAndPartition, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NonExistentPartition$ apply() {
                return NonExistentPartition$.MODULE$;
            }
        });
        try {
            PartitionState partitionState3 = partitionState;
            NewPartition$ newPartition$ = NewPartition$.MODULE$;
            PartitionState partitionState4 = partitionState3;
            if (!(newPartition$ != null ? !newPartition$.equals(partitionState4) : partitionState4 != null)) {
                this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NonExistentPartition$[]{NonExistentPartition$.MODULE$})), NewPartition$.MODULE$);
                this.assignReplicasToPartitions(string, n);
                this.partitionState().put((Object)topicAndPartition, (Object)NewPartition$.MODULE$);
                String string2 = ((TraversableOnce)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition)).mkString(",");
                this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from NotExists to New with assigned replicas %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition, string2})));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            } else {
                OnlinePartition$ onlinePartition$ = OnlinePartition$.MODULE$;
                PartitionState partitionState5 = partitionState3;
                if (!(onlinePartition$ != null ? !onlinePartition$.equals(partitionState5) : partitionState5 != null)) {
                    this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewPartition$.MODULE$, OnlinePartition$.MODULE$, OfflinePartition$.MODULE$})), OnlinePartition$.MODULE$);
                    PartitionState partitionState6 = (PartitionState)this.partitionState().apply((Object)topicAndPartition);
                    NewPartition$ newPartition$2 = NewPartition$.MODULE$;
                    PartitionState partitionState7 = partitionState6;
                    if (!(newPartition$2 != null ? !newPartition$2.equals(partitionState7) : partitionState7 != null)) {
                        this.initializeLeaderAndIsrForPartition(topicAndPartition);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
                        PartitionState partitionState8 = partitionState6;
                        if (!(offlinePartition$ != null ? !offlinePartition$.equals(partitionState8) : partitionState8 != null)) {
                            this.electLeaderForPartition(string, n, partitionLeaderSelector);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            OnlinePartition$ onlinePartition$2 = OnlinePartition$.MODULE$;
                            PartitionState partitionState9 = partitionState6;
                            if (!(onlinePartition$2 != null ? !onlinePartition$2.equals(partitionState9) : partitionState9 != null)) {
                                this.electLeaderForPartition(string, n, partitionLeaderSelector);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                    }
                    this.partitionState().put((Object)topicAndPartition, (Object)OnlinePartition$.MODULE$);
                    int n2 = ((LeaderIsrAndControllerEpoch)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().apply((Object)topicAndPartition)).leaderAndIsr().leader();
                    this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s from %s to OnlinePartition with leader %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition, this.partitionState().apply((Object)topicAndPartition), BoxesRunTime.boxToInteger((int)n2)})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                } else {
                    OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
                    PartitionState partitionState10 = partitionState3;
                    if (!(offlinePartition$ != null ? !offlinePartition$.equals(partitionState10) : partitionState10 != null)) {
                        this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewPartition$.MODULE$, OnlinePartition$.MODULE$})), OfflinePartition$.MODULE$);
                        this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from Online to Offline")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition})));
                        this.partitionState().put((Object)topicAndPartition, (Object)OfflinePartition$.MODULE$);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    } else {
                        NonExistentPartition$ nonExistentPartition$ = NonExistentPartition$.MODULE$;
                        PartitionState partitionState11 = partitionState3;
                        if (nonExistentPartition$ != null ? !nonExistentPartition$.equals(partitionState11) : partitionState11 != null) throw new MatchError((Object)partitionState3);
                        this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OfflinePartition$[]{OfflinePartition$.MODULE$})), NonExistentPartition$.MODULE$);
                        this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from Offline to NotExists")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition})));
                        this.partitionState().put((Object)topicAndPartition, (Object)NonExistentPartition$.MODULE$);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }
            return;
        }
        catch (Throwable throwable) {
            this.stateChangeLogger().error((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change for partition %s from %s to %s failed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition, partitionState2, partitionState})), throwable);
        }
    }

    public PartitionLeaderSelector handleStateChanges$default$3() {
        return this.noOpPartitionLeaderSelector();
    }

    private void initializePartitionState() {
        this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> tuple2) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple22 = tuple2;
                boolean bl = tuple22 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;

            public final Option<PartitionState> apply(Tuple2<TopicAndPartition, Seq<Object>> tuple2) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple22;
                block2: {
                    Option option;
                    block8: {
                        Option option2;
                        block7: {
                            TopicAndPartition topicAndPartition;
                            block3: {
                                boolean bl;
                                block6: {
                                    Option option3;
                                    block5: {
                                        block4: {
                                            tuple22 = tuple2;
                                            if (tuple22 == null) break block2;
                                            topicAndPartition = (TopicAndPartition)tuple22._1();
                                            option = this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().get((Object)topicAndPartition);
                                            if (!(option instanceof Some)) break block3;
                                            Some some = (Some)option;
                                            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
                                            bl = this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)leaderIsrAndControllerEpoch.leaderAndIsr().leader()));
                                            if (!bl) break block4;
                                            option3 = this.$outer.partitionState().put((Object)topicAndPartition, (Object)OnlinePartition$.MODULE$);
                                            break block5;
                                        }
                                        if (bl) break block6;
                                        option3 = this.$outer.partitionState().put((Object)topicAndPartition, (Object)OfflinePartition$.MODULE$);
                                    }
                                    option2 = option3;
                                    break block7;
                                }
                                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                            }
                            None$ none$ = None$.MODULE$;
                            Option option4 = option;
                            if (none$ != null ? !none$.equals(option4) : option4 != null) break block8;
                            option2 = this.$outer.partitionState().put((Object)topicAndPartition, (Object)NewPartition$.MODULE$);
                        }
                        Option option5 = option2;
                        return option5;
                    }
                    throw new MatchError((Object)option);
                }
                throw new MatchError(tuple22);
            }
            {
                if (partitionStateMachine == null) {
                    throw new NullPointerException();
                }
                this.$outer = partitionStateMachine;
            }
        });
    }

    private void assertValidPreviousStates(TopicAndPartition topicAndPartition, Seq<PartitionState> seq, PartitionState partitionState) {
        if (seq.contains(this.partitionState().apply((Object)topicAndPartition))) {
            return;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Partition %s should be in the %s states before moving to %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, seq.mkString(","), partitionState}))).append((Object)new StringOps(Predef$.MODULE$.augmentString(". Instead it is in %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionState().apply((Object)topicAndPartition)}))).toString());
    }

    private void assignReplicasToPartitions(String string, int n) {
        Seq<Object> seq = ZkUtils$.MODULE$.getReplicasForPartition(this.kafka$controller$PartitionStateMachine$$controllerContext().zkClient(), string, n);
        this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(string, n)), seq));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initializeLeaderAndIsrForPartition(TopicAndPartition topicAndPartition) {
        Seq seq = (Seq)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
        Seq seq2 = (Seq)seq.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;

            public final boolean apply(int n) {
                return this.apply$mcZI$sp(n);
            }

            public boolean apply$mcZI$sp(int n) {
                return this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)n));
            }
            {
                if (partitionStateMachine == null) {
                    throw new NullPointerException();
                }
                this.$outer = partitionStateMachine;
            }
        });
        int n = seq2.size();
        switch (n) {
            default: {
                this.debug((Function0<String>)new Serializable(this, topicAndPartition, seq2){
                    public static final long serialVersionUID = 0L;
                    private final TopicAndPartition topicAndPartition$1;
                    private final Seq liveAssignedReplicas$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Live assigned replicas for partition %s are: [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$1, this.liveAssignedReplicas$1}));
                    }
                    {
                        this.topicAndPartition$1 = topicAndPartition;
                        this.liveAssignedReplicas$1 = seq;
                    }
                });
                int n2 = BoxesRunTime.unboxToInt((Object)seq2.head());
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(new LeaderAndIsr(n2, (List<Object>)seq2.toList()), this.kafka$controller$PartitionStateMachine$$controller.epoch());
                this.debug((Function0<String>)new Serializable(this, topicAndPartition, leaderIsrAndControllerEpoch){
                    public static final long serialVersionUID = 0L;
                    private final TopicAndPartition topicAndPartition$1;
                    private final LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Initializing leader and isr for partition %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$1, this.leaderIsrAndControllerEpoch$1}));
                    }
                    {
                        this.topicAndPartition$1 = topicAndPartition;
                        this.leaderIsrAndControllerEpoch$1 = leaderIsrAndControllerEpoch;
                    }
                });
                try {
                    ZkUtils$.MODULE$.createPersistentPath(this.kafka$controller$PartitionStateMachine$$controllerContext().zkClient(), ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(topicAndPartition.topic(), topicAndPartition.partition()), ZkUtils$.MODULE$.leaderAndIsrZkData(leaderIsrAndControllerEpoch.leaderAndIsr(), this.kafka$controller$PartitionStateMachine$$controller.epoch()));
                    this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().put((Object)topicAndPartition, (Object)leaderIsrAndControllerEpoch);
                    this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)seq2, topicAndPartition.topic(), topicAndPartition.partition(), leaderIsrAndControllerEpoch, (Seq<Object>)seq);
                    return;
                }
                catch (ZkNodeExistsException zkNodeExistsException) {
                    leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)ZkUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.kafka$controller$PartitionStateMachine$$zkClient(), topicAndPartition.topic(), topicAndPartition.partition()).get();
                    String string2 = new StringOps(Predef$.MODULE$.augmentString("encountered error while changing partition %s's state from New to Online since LeaderAndIsr path already exists with value %s and controller epoch %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, leaderIsrAndControllerEpoch.leaderAndIsr().toString(), BoxesRunTime.boxToInteger((int)leaderIsrAndControllerEpoch.controllerEpoch())}));
                    this.stateChangeLogger().error((Object)new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)string2).toString());
                    throw new StateChangeFailedException(string2);
                }
            }
            case 0: 
        }
        String string = new StringOps(Predef$.MODULE$.augmentString("encountered error during state change of partition %s from New to Online, assigned replicas are [%s], live brokers are [%s]. No assigned replica is alive.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, seq.mkString(","), this.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokerIds()}));
        this.stateChangeLogger().error((Object)new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)string).toString());
        throw new StateChangeFailedException(string);
    }

    public void electLeaderForPartition(String string, int n, PartitionLeaderSelector partitionLeaderSelector) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(string, n);
        this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d started leader election for partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition})));
        try {
            Seq seq;
            LeaderAndIsr leaderAndIsr;
            block6: {
                Tuple2<LeaderAndIsr, Seq<Object>> tuple2;
                block7: {
                    Tuple2<Object, Object> tuple22;
                    boolean bl = false;
                    leaderAndIsr = null;
                    seq = (Seq)Seq$.MODULE$.empty();
                    while (true) {
                        Tuple2.mcZI.sp sp2;
                        Tuple2 tuple23;
                        if (bl) break block6;
                        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = this.getLeaderIsrAndEpochOrThrowException(string, n);
                        LeaderAndIsr leaderAndIsr2 = leaderIsrAndControllerEpoch.leaderAndIsr();
                        int n2 = leaderIsrAndControllerEpoch.controllerEpoch();
                        if (n2 > this.kafka$controller$PartitionStateMachine$$controller.epoch()) {
                            String string2 = new StringOps(Predef$.MODULE$.augmentString("aborted leader election for partition [%s,%d] since the LeaderAndIsr path was already written by another controller. This probably means that the current controller %d went through a soft failure and another controller was elected with epoch %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)n2)}));
                            this.stateChangeLogger().error((Object)new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)string2).toString());
                            throw new StateChangeFailedException(string2);
                        }
                        tuple2 = partitionLeaderSelector.selectLeader(topicAndPartition, leaderAndIsr2);
                        if (tuple2 == null) break block7;
                        LeaderAndIsr leaderAndIsr3 = (LeaderAndIsr)tuple2._1();
                        Seq seq2 = (Seq)tuple2._2();
                        Tuple2 tuple24 = tuple23 = new Tuple2((Object)leaderAndIsr3, (Object)seq2);
                        LeaderAndIsr leaderAndIsr4 = (LeaderAndIsr)tuple24._1();
                        Seq seq3 = (Seq)tuple24._2();
                        tuple22 = ZkUtils$.MODULE$.conditionalUpdatePersistentPath(this.kafka$controller$PartitionStateMachine$$zkClient(), ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(string, n), ZkUtils$.MODULE$.leaderAndIsrZkData(leaderAndIsr4, this.kafka$controller$PartitionStateMachine$$controller.epoch()), leaderAndIsr2.zkVersion());
                        if (tuple22 == null) break;
                        boolean bl2 = tuple22._1$mcZ$sp();
                        int n3 = tuple22._2$mcI$sp();
                        Tuple2.mcZI.sp sp3 = sp2 = new Tuple2.mcZI.sp(bl2, n3);
                        boolean bl3 = sp3._1$mcZ$sp();
                        int n4 = sp3._2$mcI$sp();
                        leaderAndIsr = leaderAndIsr4;
                        leaderAndIsr.zkVersion_$eq(n4);
                        bl = bl3;
                        seq = seq3;
                    }
                    throw new MatchError(tuple22);
                }
                throw new MatchError(tuple2);
            }
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.kafka$controller$PartitionStateMachine$$controller.epoch());
            this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().put((Object)new TopicAndPartition(string, n), (Object)leaderIsrAndControllerEpoch);
            this.stateChangeLogger().trace((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d elected leader %d for Offline partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)leaderAndIsr.leader()), topicAndPartition})));
            Seq seq4 = (Seq)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)new TopicAndPartition(string, n));
            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)seq, string, n, leaderIsrAndControllerEpoch, (Seq<Object>)seq4);
        }
        catch (Throwable throwable) {
            String string3 = new StringOps(Predef$.MODULE$.augmentString("encountered error while electing leader for partition %s due to: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, throwable.getMessage()}));
            this.stateChangeLogger().error((Object)new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)string3).toString());
            throw new StateChangeFailedException(string3, throwable);
        }
        catch (NoReplicaOnlineException noReplicaOnlineException) {
            throw noReplicaOnlineException;
        }
        catch (LeaderElectionNotNeededException leaderElectionNotNeededException) {
            // empty catch block
        }
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachine $outer;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("After leader election, leader cache is updated to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<TopicAndPartition, LeaderIsrAndControllerEpoch> apply(Tuple2<TopicAndPartition, LeaderIsrAndControllerEpoch> tuple2) {
                        return new Tuple2(tuple2._1(), tuple2._2());
                    }
                }, Map$.MODULE$.canBuildFrom())}));
            }
            {
                if (partitionStateMachine == null) {
                    throw new NullPointerException();
                }
                this.$outer = partitionStateMachine;
            }
        });
    }

    private java.util.List<String> registerTopicChangeListener() {
        return this.kafka$controller$PartitionStateMachine$$zkClient().subscribeChildChanges(ZkUtils$.MODULE$.BrokerTopicsPath(), (IZkChildListener)new TopicChangeListener());
    }

    public void registerPartitionChangeListener(String string) {
        this.kafka$controller$PartitionStateMachine$$zkClient().subscribeDataChanges(ZkUtils$.MODULE$.getTopicPath(string), (IZkDataListener)new AddPartitionsListener(this, string));
    }

    private LeaderIsrAndControllerEpoch getLeaderIsrAndEpochOrThrowException(String string, int n) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(string, n);
        Option<LeaderIsrAndControllerEpoch> option = ZkUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.kafka$controller$PartitionStateMachine$$zkClient(), string, n);
        if (option instanceof Some) {
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch;
            Some some = (Some)option;
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch2 = leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
            return leaderIsrAndControllerEpoch2;
        }
        None$ none$ = None$.MODULE$;
        Option<LeaderIsrAndControllerEpoch> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            String string2 = new StringOps(Predef$.MODULE$.augmentString("LeaderAndIsr information doesn't exist for partition %s in %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, this.partitionState().apply((Object)topicAndPartition)}));
            throw new StateChangeFailedException(string2);
        }
        throw new MatchError(option);
    }

    public PartitionStateMachine(KafkaController kafkaController) {
        this.kafka$controller$PartitionStateMachine$$controller = kafkaController;
        Logging$class.$init$(this);
        this.kafka$controller$PartitionStateMachine$$controllerContext = kafkaController.controllerContext();
        this.controllerId = kafkaController.config().brokerId();
        this.kafka$controller$PartitionStateMachine$$zkClient = this.kafka$controller$PartitionStateMachine$$controllerContext().zkClient();
        this.partitionState = Map$.MODULE$.empty();
        this.brokerRequestBatch = new ControllerBrokerRequestBatch(kafkaController.controllerContext(), (Function3<Object, RequestOrResponse, Function1<RequestOrResponse, BoxedUnit>, BoxedUnit>)new $anonfun$2(this), this.controllerId(), kafkaController.clientId());
        this.kafka$controller$PartitionStateMachine$$hasStarted = new AtomicBoolean(false);
        this.noOpPartitionLeaderSelector = new NoOpLeaderSelector(this.kafka$controller$PartitionStateMachine$$controllerContext());
        this.logIdent_$eq(new StringBuilder().append((Object)"[Partition state machine on Controller ").append((Object)BoxesRunTime.boxToInteger((int)this.controllerId())).append((Object)"]: ").toString());
        this.stateChangeLogger = Logger.getLogger((String)KafkaController$.MODULE$.stateChangeLogger());
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class TopicChangeListener
    implements IZkChildListener,
    Logging {
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        private Logger logger$lzycompute() {
            TopicChangeListener topicChangeListener = this;
            synchronized (topicChangeListener) {
                if (!this.bitmap$0) {
                    this.logger = Logging$class.logger(this);
                    this.bitmap$0 = true;
                }
                return this.logger;
            }
        }

        @Override
        public Logger logger() {
            return this.bitmap$0 ? this.logger : this.logger$lzycompute();
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String string) {
            this.logIdent = string;
        }

        @Override
        public Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
            this.loggerName = string;
        }

        @Override
        public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
            this.kafka$utils$Logging$$log4jController = log4jController$;
        }

        @Override
        public void trace(Function0<String> function0) {
            Logging$class.trace(this, function0);
        }

        @Override
        public Object trace(Function0<Throwable> function0) {
            return Logging$class.trace(this, function0);
        }

        @Override
        public void trace(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.trace(this, function0, function02);
        }

        @Override
        public void swallowTrace(Function0<BoxedUnit> function0) {
            Logging$class.swallowTrace(this, function0);
        }

        @Override
        public void debug(Function0<String> function0) {
            Logging$class.debug(this, function0);
        }

        @Override
        public Object debug(Function0<Throwable> function0) {
            return Logging$class.debug(this, function0);
        }

        @Override
        public void debug(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.debug(this, function0, function02);
        }

        @Override
        public void swallowDebug(Function0<BoxedUnit> function0) {
            Logging$class.swallowDebug(this, function0);
        }

        @Override
        public void info(Function0<String> function0) {
            Logging$class.info(this, function0);
        }

        @Override
        public Object info(Function0<Throwable> function0) {
            return Logging$class.info(this, function0);
        }

        @Override
        public void info(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.info(this, function0, function02);
        }

        @Override
        public void swallowInfo(Function0<BoxedUnit> function0) {
            Logging$class.swallowInfo(this, function0);
        }

        @Override
        public void warn(Function0<String> function0) {
            Logging$class.warn(this, function0);
        }

        @Override
        public Object warn(Function0<Throwable> function0) {
            return Logging$class.warn(this, function0);
        }

        @Override
        public void warn(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.warn(this, function0, function02);
        }

        @Override
        public void swallowWarn(Function0<BoxedUnit> function0) {
            Logging$class.swallowWarn(this, function0);
        }

        @Override
        public void swallow(Function0<BoxedUnit> function0) {
            Logging$class.swallow(this, function0);
        }

        @Override
        public void error(Function0<String> function0) {
            Logging$class.error(this, function0);
        }

        @Override
        public Object error(Function0<Throwable> function0) {
            return Logging$class.error(this, function0);
        }

        @Override
        public void error(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.error(this, function0, function02);
        }

        @Override
        public void swallowError(Function0<BoxedUnit> function0) {
            Logging$class.swallowError(this, function0);
        }

        @Override
        public void fatal(Function0<String> function0) {
            Logging$class.fatal(this, function0);
        }

        @Override
        public Object fatal(Function0<Throwable> function0) {
            return Logging$class.fatal(this, function0);
        }

        @Override
        public void fatal(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.fatal(this, function0, function02);
        }

        public void handleChildChange(String string, java.util.List<String> list) throws Exception {
            Object object = this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().controllerLock();
            synchronized (object) {
                BoxedUnit boxedUnit;
                if (this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$hasStarted().get()) {
                    this.liftedTree1$1(string, list);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
        }

        public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer() {
            return PartitionStateMachine.this;
        }

        private final void liftedTree1$1(String string, java.util.List list) {
            try {
                this.debug((Function0<String>)new Serializable(this, string, list){
                    public static final long serialVersionUID = 0L;
                    private final String parentPath$1;
                    private final java.util.List children$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Topic change listener fired for path %s with children %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.parentPath$1, JavaConversions$.MODULE$.asScalaBuffer(this.children$1).mkString(",")}));
                    }
                    {
                        this.parentPath$1 = string;
                        this.children$1 = list;
                    }
                });
                scala.collection.immutable.Set set = JavaConversions$.MODULE$.asScalaBuffer(list).toSet();
                scala.collection.immutable.Set set2 = (scala.collection.immutable.Set)set.$minus$minus(this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics());
                scala.collection.immutable.Set set3 = (scala.collection.immutable.Set)this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics().$minus$minus((GenTraversableOnce)set);
                this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics_$eq((scala.collection.immutable.Set<String>)set);
                Map<TopicAndPartition, Seq<Object>> map = ZkUtils$.MODULE$.getReplicaAssignmentForTopics(this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$zkClient(), (Seq<String>)set2.toSeq());
                this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment_$eq((Map<TopicAndPartition, Seq<Object>>)((Map)this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().filter((Function1)new Serializable(this, set3){
                    public static final long serialVersionUID = 0L;
                    private final scala.collection.immutable.Set deletedTopics$1;

                    public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> tuple2) {
                        return !this.deletedTopics$1.contains((Object)((TopicAndPartition)tuple2._1()).topic());
                    }
                    {
                        this.deletedTopics$1 = set;
                    }
                })));
                this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().$plus$plus$eq(map);
                this.info((Function0<String>)new Serializable(this, set2, set3, map){
                    public static final long serialVersionUID = 0L;
                    private final scala.collection.immutable.Set newTopics$1;
                    private final scala.collection.immutable.Set deletedTopics$1;
                    private final Map addedPartitionReplicaAssignment$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("New topics: [%s], deleted topics: [%s], new partition replica assignment [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newTopics$1, this.deletedTopics$1, this.addedPartitionReplicaAssignment$1}));
                    }
                    {
                        this.newTopics$1 = set;
                        this.deletedTopics$1 = set2;
                        this.addedPartitionReplicaAssignment$1 = map;
                    }
                });
                if (set2.size() > 0) {
                    this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controller.onNewTopicCreation((scala.collection.immutable.Set<String>)set2, (scala.collection.immutable.Set<TopicAndPartition>)map.keySet().toSet());
                }
            }
            catch (Throwable throwable) {
                this.error((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Error while handling new topic";
                    }
                }, (Function0<Throwable>)new Serializable(this, throwable){
                    public static final long serialVersionUID = 0L;
                    private final Throwable e$3;

                    public final Throwable apply() {
                        return this.e$3;
                    }
                    {
                        this.e$3 = throwable;
                    }
                });
            }
        }

        public TopicChangeListener() {
            if (PartitionStateMachine.this == null) {
                throw new NullPointerException();
            }
            Logging$class.$init$(this);
            this.logIdent_$eq(new StringBuilder().append((Object)"[TopicChangeListener on Controller ").append((Object)BoxesRunTime.boxToInteger((int)PartitionStateMachine.this.kafka$controller$PartitionStateMachine$$controller.config().brokerId())).append((Object)"]: ").toString());
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class AddPartitionsListener
    implements IZkDataListener,
    Logging {
        private final String topic;
        public final /* synthetic */ PartitionStateMachine $outer;
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        private Logger logger$lzycompute() {
            AddPartitionsListener addPartitionsListener = this;
            synchronized (addPartitionsListener) {
                if (!this.bitmap$0) {
                    this.logger = Logging$class.logger(this);
                    this.bitmap$0 = true;
                }
                return this.logger;
            }
        }

        @Override
        public Logger logger() {
            return this.bitmap$0 ? this.logger : this.logger$lzycompute();
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String string) {
            this.logIdent = string;
        }

        @Override
        public Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
            this.loggerName = string;
        }

        @Override
        public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
            this.kafka$utils$Logging$$log4jController = log4jController$;
        }

        @Override
        public void trace(Function0<String> function0) {
            Logging$class.trace(this, function0);
        }

        @Override
        public Object trace(Function0<Throwable> function0) {
            return Logging$class.trace(this, function0);
        }

        @Override
        public void trace(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.trace(this, function0, function02);
        }

        @Override
        public void swallowTrace(Function0<BoxedUnit> function0) {
            Logging$class.swallowTrace(this, function0);
        }

        @Override
        public void debug(Function0<String> function0) {
            Logging$class.debug(this, function0);
        }

        @Override
        public Object debug(Function0<Throwable> function0) {
            return Logging$class.debug(this, function0);
        }

        @Override
        public void debug(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.debug(this, function0, function02);
        }

        @Override
        public void swallowDebug(Function0<BoxedUnit> function0) {
            Logging$class.swallowDebug(this, function0);
        }

        @Override
        public void info(Function0<String> function0) {
            Logging$class.info(this, function0);
        }

        @Override
        public Object info(Function0<Throwable> function0) {
            return Logging$class.info(this, function0);
        }

        @Override
        public void info(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.info(this, function0, function02);
        }

        @Override
        public void swallowInfo(Function0<BoxedUnit> function0) {
            Logging$class.swallowInfo(this, function0);
        }

        @Override
        public void warn(Function0<String> function0) {
            Logging$class.warn(this, function0);
        }

        @Override
        public Object warn(Function0<Throwable> function0) {
            return Logging$class.warn(this, function0);
        }

        @Override
        public void warn(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.warn(this, function0, function02);
        }

        @Override
        public void swallowWarn(Function0<BoxedUnit> function0) {
            Logging$class.swallowWarn(this, function0);
        }

        @Override
        public void swallow(Function0<BoxedUnit> function0) {
            Logging$class.swallow(this, function0);
        }

        @Override
        public void error(Function0<String> function0) {
            Logging$class.error(this, function0);
        }

        @Override
        public Object error(Function0<Throwable> function0) {
            return Logging$class.error(this, function0);
        }

        @Override
        public void error(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.error(this, function0, function02);
        }

        @Override
        public void swallowError(Function0<BoxedUnit> function0) {
            Logging$class.swallowError(this, function0);
        }

        @Override
        public void fatal(Function0<String> function0) {
            Logging$class.fatal(this, function0);
        }

        @Override
        public Object fatal(Function0<Throwable> function0) {
            return Logging$class.fatal(this, function0);
        }

        @Override
        public void fatal(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.fatal(this, function0, function02);
        }

        public void handleDataChange(String string, Object object) throws Exception {
            Object object2 = this.kafka$controller$PartitionStateMachine$AddPartitionsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().controllerLock();
            synchronized (object2) {
                this.liftedTree2$1(string, object);
                return;
            }
        }

        public void handleDataDeleted(String string) throws Exception {
        }

        public /* synthetic */ PartitionStateMachine kafka$controller$PartitionStateMachine$AddPartitionsListener$$$outer() {
            return this.$outer;
        }

        private final void liftedTree2$1(String string, Object object) {
            try {
                this.info((Function0<String>)new Serializable(this, string, object){
                    public static final long serialVersionUID = 0L;
                    private final String dataPath$1;
                    private final Object data$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Add Partition triggered ").append((Object)this.data$1.toString()).append((Object)" for path ").append((Object)this.dataPath$1).toString();
                    }
                    {
                        this.dataPath$1 = string;
                        this.data$1 = object;
                    }
                });
                Map<TopicAndPartition, Seq<Object>> map = ZkUtils$.MODULE$.getReplicaAssignmentForTopics(this.kafka$controller$PartitionStateMachine$AddPartitionsListener$$$outer().kafka$controller$PartitionStateMachine$$zkClient(), (Seq<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic})));
                Map map2 = (Map)map.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ AddPartitionsListener $outer;

                    public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> tuple2) {
                        return !this.$outer.kafka$controller$PartitionStateMachine$AddPartitionsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().contains(tuple2._1());
                    }
                    {
                        if (addPartitionsListener == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = addPartitionsListener;
                    }
                });
                this.info((Function0<String>)new Serializable(this, map2){
                    public static final long serialVersionUID = 0L;
                    private final Map partitionsRemainingToBeAdded$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("New partitions to be added [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionsRemainingToBeAdded$1}));
                    }
                    {
                        this.partitionsRemainingToBeAdded$1 = map;
                    }
                });
                this.kafka$controller$PartitionStateMachine$AddPartitionsListener$$$outer().kafka$controller$PartitionStateMachine$$controller.onNewPartitionCreation((scala.collection.immutable.Set<TopicAndPartition>)map2.keySet().toSet());
            }
            catch (Throwable throwable) {
                this.error((Function0<String>)new Serializable(this, string){
                    public static final long serialVersionUID = 0L;
                    private final String dataPath$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Error while handling add partitions for data path ").append((Object)this.dataPath$1).toString();
                    }
                    {
                        this.dataPath$1 = string;
                    }
                }, (Function0<Throwable>)new Serializable(this, throwable){
                    public static final long serialVersionUID = 0L;
                    private final Throwable e$4;

                    public final Throwable apply() {
                        return this.e$4;
                    }
                    {
                        this.e$4 = throwable;
                    }
                });
            }
        }

        public AddPartitionsListener(PartitionStateMachine partitionStateMachine, String string) {
            this.topic = string;
            if (partitionStateMachine == null) {
                throw new NullPointerException();
            }
            this.$outer = partitionStateMachine;
            Logging$class.$init$(this);
            this.logIdent_$eq(new StringBuilder().append((Object)"[AddPartitionsListener on ").append((Object)BoxesRunTime.boxToInteger((int)partitionStateMachine.kafka$controller$PartitionStateMachine$$controller.config().brokerId())).append((Object)"]: ").toString());
        }
    }
}

